//
//  Cube.java
//  Cube
//
//  Created by Gunter Blache on Sun Dec 15 2002.
//  Copyright (c) 2002 __MyCompanyName__. All rights reserved.
//
//	For information on setting Java configuration information, including 
//	setting Java properties, refer to the documentation at
//		http://developer.apple.com/techpubs/java/java.html
//

import Part;

import java.util.*;
import java.io.*;

public class Cube {
    private Part t[];

    public Cube(Part p[]) {
        t = new Part[p.length];
        System.arraycopy(p,0,t,0,p.length);
    }
    
    private void shadow(StringBuffer b, double x1,double y1,double z1,double x2,double y2,double z2, boolean s) {
        b.append("  box { <");
        b.append(x1);
        b.append(",");
        b.append(y1);
        b.append(",");
        b.append(z1);
        b.append(">, <");
        b.append(x2);
        b.append(",");
        b.append(y2);
        b.append(",");
        b.append(z2);
        b.append("> ");
        if (s)
            b.append("texture{pigment { color red 1 green 0 blue 0 }}");
        else
            b.append("texture{pigment { color red 1 green 1 blue 1 }}");
        b.append("}\n");
    }

    public void povRay(String filename) {
        try {
            FileWriter f = new FileWriter(filename);
            PrintWriter pw = new PrintWriter(f);
            pw.print(povRay());
            pw.flush();
            f.close();
        } catch (IOException e) {
            System.out.println(e);
        }
    }
    
    public String povRay() {
        StringBuffer b = new StringBuffer();
        int sizex,sizey;
        int sizeX=t[0].getSizeX();
        int sizeY=t[0].getSizeY();
        int sizeZ=t[0].getSizeZ();
        sizex=(int)Math.ceil(Math.sqrt(t.length));
        sizey=(int)Math.ceil(t.length*1.0f/sizex);
        b.append("#declare transform_cube = transform {\n");
        b.append("  translate <");
        b.append(-sizeX/2f);
        b.append(",");
        b.append(-sizeY/2f);
        b.append(",");
        b.append(-sizeZ/2f);
        b.append(">\n");
        b.append("  rotate <0,45,0>\n");
        b.append("  rotate <-45,0,0>\n");
        b.append("  translate <");
        b.append(sizeX/2f);
        b.append(",");
        b.append(sizeY/2f);
        b.append(",");
        b.append(sizeZ/2f);
        b.append(">\n");
        b.append("}\n");
        for (int i=0;i<t.length;i++) {
            b.append("#declare part"+i+" = union {\n");
            b.append(t[i].povRay());
            b.append("}\n\n");
        }
        double translateX=sizeX+1,translateY=(sizey*2-1)*(sizeY+1);
        int rowcounter=0;
        for (int i=0;i<t.length;i++) {
            Part p = t[i];
            b.append("union {\n");
            for (int x=0;x<sizeX;x++)
                for (int y=0;y<sizeY;y++) {
                    boolean shadow=false;
                    for (int z=0;z<sizeZ;z++) shadow|=p.isCubelet(x,y,z);
                    shadow(b,x,y,sizeZ,x+1,y+1,sizeZ+0.1,shadow);
                }
            b.append("\n");
            for (int x=0;x<sizeX;x++)
                for (int z=0;z<sizeZ;z++) {
                    boolean shadow=false;
                    for (int y=0;y<sizeY;y++) shadow|=p.isCubelet(x,y,z);
                    shadow(b,x,-0.1,z,x+1,0,z+1,shadow);
                }
            b.append("\n");
            for (int z=0;z<sizeZ;z++)
                for (int y=0;y<sizeY;y++) {
                    boolean shadow=false;
                    for (int x=0;x<sizeX;x++) shadow|=p.isCubelet(x,y,z);
                    shadow(b,-0.1,y,z,0,y+1,z+1,shadow);
                }
            b.append("\n");
            b.append("  part"+i+"\n");
            b.append("  transform transform_cube\n");
            b.append("  translate <");
            b.append(translateX);
            b.append(",");
            b.append(translateY);
            b.append(",0>\n");
            b.append("}\n\n");
            rowcounter++;translateX+=2*(sizeX+1);
            if (rowcounter>=sizex) {rowcounter=0;translateX=sizeX+1;translateY-=2*(sizeY+1);}
        }
        double width=sizex*2*(sizeX+1),height=sizey*2*(sizeY+1);
        double viewx=width,viewy=height;
        if (viewx*3/4>viewy) viewy=viewx*3/4;
        if (viewy*4/3>viewx) viewx=viewy*4/3;
        b.append("camera {\n");
        b.append("   orthographic\n");
        b.append("   right     <"+viewx+", 0.0,  0.0>\n");
        b.append("   up        <0.0, "+viewy+",  0.0>\n");
        b.append("   translate <"+(width/2)+", "+(height/2)+",  -100.0>\n");
        b.append("}\n");

        b.append("light_source { <"+(width/2)+", "+(height)+", -100> color red 1 green 1 blue 1 }\n");
        return b.toString();
    }

    public static void main(String args[]) {
        CubeGUI.main(args);
    }
}
