from constants import *
from pprint import pprint
import partreader
import part
import bitvector
import box

class PlaceInfoC:
   "Eine Platzierung eines Teils"
   def __init__(self, nr, partcount, posL, box):            
      self.box=box
      self.nr=nr
      self.boxranges=box.getSize()
      self.partcount = partcount

      "Stckliste der Elementarwrfel in Koordinatenschreibweise"
      self.posL=posL

      "Stckliste der Elementarwrfel bestehend aus Platzummern "
      self.indexL=[self.box.posIndex(pos) for pos in posL]
      self.indexL.sort()             
      self.first=self.indexL[0]
      self.last=self.indexL[-1]
      #print "<%s><%s><%s>" % (self.indexL, self.first, self.last)

      "Stckliste der Elementarwrfel als bitvektor"
      self.bv=bitvector.BitVectorC(dim=self.last+1)
      self.bv.extend(self.indexL)

      "Liste der Lcher zwischen den Elementarwrfel.."
      self.holesL=[]
      for i in range(self.first,self.last):
         if i not in self.indexL:
            self.holesL.append(i)

      ".. einschlielich der nchsten freien Position (wenn vorhanden)"
      if self.last+1 < self.box.getVolume():
         self.holesL.append(self.last+1)
      
      "Lochliste als Bitvector"
      self.bvholes=bitvector.BitVectorC(dim=self.last+1)
      if self.holesL:
         self.bvholes.extend(self.holesL)

      #print posL,self.indexL

   def poslist(self):
      return self.posL

   def placeIndex(self):
      "die kleinste Platznummer"
      return self.first

class PrepareC:
   "Fr alle Teile werden alle Positionen berechnet und nach der kleinsten Position indiziert"
   def __init__(self,allpartL, box):
      self.box=box
      self.boxranges=box.getSize()
      self.placeD = {}
      move = part.MoveC()
      self.partcount = len(allpartL)
      for nr in range(self.partcount):               
         for bWithTurns in (false,true):
            LL = move.genpos(allpartL[nr],self.boxranges,bWithTurns)
            for posL in LL:
               placeInfo = PlaceInfoC(nr, self.partcount, posL,self.box)
               idx = placeInfo.placeIndex()
               #print bWithTurns,nr,idx
               if (bWithTurns,nr,idx) in self.placeD:
                  self.placeD[bWithTurns,nr,idx].append(placeInfo) 
               else:
                  self.placeD[bWithTurns,nr,idx]=[placeInfo]
             
   def show(self):
      for (key,value) in self.placeD.items():
         print "%d,%d,%d -> " % (key)
         for v in value:
            print v.poslist()

   def placeInfos(self,idx,freelist, bWithTurns):
      placeInfoL=[]
      for nr in freelist:
         L=self.placeD.get((bWithTurns,nr,idx),None)
         if L:
            placeInfoL.extend(L)          
      return placeInfoL     
      
#--------------------------------------------------

if __name__ == "__main__":
   r = partreader.PartReaderC(partlist)
   the_box = box.BoxC(r.getSize(),r.getPartCount())
   print 'box', the_box.getSize()
   print "%d parts found:" % r.getPartCount()
   
   allpartL= r.partlist()   
   pprint(allpartL)
   prepare=PrepareC(allpartL,the_box)
 

   if 1:
      print "--"
      prepare.show()
      print "--"   
      k=prepare.placeD.keys()
      k.sort()
      print k
      placeInfoL=prepare.placeInfos(0,[])
      print 'placeInfoL'
      for pi in placeInfoL:
         print  pi.poslist()

 