from constants import *
from pprint import pprint
import partreader


class TurnC:
   def __init__(self):
      self.gen_turns()

   def basis_turn(self,tripel,axis):
      new_tripel=list(tripel)
      if axis == 0:
         new_tripel[1], new_tripel[2] = tripel[2], -tripel[1]
      elif axis == 1:
         new_tripel[0], new_tripel[2] = tripel[2], -tripel[0]
      elif axis == 2:
         new_tripel[0], new_tripel[1] = tripel[1], -tripel[0]
      return (new_tripel[0],new_tripel[1],new_tripel[2])


   def gen_turns(self):   
      tripel=(1,2,3)
      self.tripelD={tripel:""}

      while 1:
         anz = len(self.tripelD.keys())
         for tripel in self.tripelD.keys():
            for axis in range(len(tripel)):
               for i in range(3):
                  new_tripel = self.basis_turn(tripel,axis)
                  self.tripelD[new_tripel]=""
         self.tripelSet=self.tripelD.keys()
         if anz == len(self.tripelSet):
            break
      #print "self.tripelSet" ,self.tripelSet


   def f(self, tripel, posL):
      ret = [7,7,7]
      for i in range(3):
         v=tripel[i]
         #print tripel,v
         if v > 0:
            ret[i] = posL[v-1]
         else:
            ret[i] = -posL[-v-1]
      return ret       
   
   def apply_turns(self,posLL):
      turnLLL=[]
      #print "tripelSet", self.tripelSet
      for tripel in self.tripelSet:
         turnLL = [self.f(tripel,posL) for posL in posLL]
         #print "turnLL",turnLL
         turnLLL.append(turnLL)
      return turnLLL

class MoveC:
   def __init__(self):            
      self.turn = TurnC()

   def max(self,axis,posL):
      return max([L[axis] for L in posL])
   
   def min(self,axis,posL):
      return min([L[axis] for L in posL])
                         
   def moveToWall(self,axis,value,side,posL):
      if side == '<':
         delta = value - self.max(axis, posL)
      elif side == '>':
         delta = value - self.min(axis, posL)
      for i in range(len(posL)):
         posL[i][axis] = posL[i][axis] + delta
   
   def normalize(self, posL):
      for axis in range(3):
         min_axis = self.min(axis, posL)
         for j in range(len(posL)):
            posL[j][axis] -= min_axis
      posL.sort()
   
   def genNormSet(self, bWithTurns):
      if bWithTurns:
         self.posLL = self.turn.apply_turns(self.posL)                
      else:
         self.posLL = [self.posL]

      normposLL =[]
      for posL in self.posLL:
          #print 'v', posL
          self.normalize(posL)
          #print 'n', posL
          if posL not in normposLL: 
             normposLL.append(posL)
      return normposLL 
      

   def genpos(self, posL, boxranges, bWithTurns):
      self.posL = posL
      self.genposLL=[]  
      normposLL = self.genNormSet(bWithTurns)
      for normposL in normposLL:       
         deltaT = [boxranges[axis] - self.max(axis,normposL) for axis in range(3)]                            
         #print deltaT,"normposL",normposL 
         for x in range(deltaT[0]):
            for y in range(deltaT[1]):
                for z in range(deltaT[2]):
                   genposL=[[pos[0]+x, pos[1]+y, pos[2]+z] for pos in normposL]
                   if genposL not in self.genposLL:
                      self.genposLL.append(genposL)
                      #print '+%d,+%d,+%d' % (x,y,z),genposL
      return self.genposLL
      
#unittest
if __name__ == "__main__":
   r = partreader.PartReaderC(partlist)   
   allpartL= r.partlist()  
   boxranges = r.getSize()

   print "%d parts found:" % r.getPartCount()
   print 'boxranges', boxranges
   print 'parts',
   pprint(allpartL)
   allpartCL =[]
   move=MoveC()
   for i in range(len(allpartL)):
      LL = move.genpos(allpartL[i], boxranges,true)
      print "ergo"
      for L in LL:
         print L

         