from constants import *
from pprint import pprint
import bitvector
import partreader

class CoverageC:
   def __init__(self,dim):
      self.dim=dim
      self.bv= bitvector.BitVectorC(dim)
   def add(self,el):
      self.bv.append(el)
   def release(self,el):
      self.bv.subtract(el)
   def coverlist(self):
      return self.bv.to_list()
   def freelist(self):
      return bitvector.to_list(~self.bv.b,self.dim)
 

class BoxC:
   def __init__(self,size,partcount):
      self.partcount = partcount
      self.size=size
      self.volume = reduce(lambda x, y: x*y, size)
      self.bv= bitvector.BitVectorC(dim=self.volume)
      self.coverage=CoverageC(partcount)
      self.fillstack=[]
      self.placestack=[]
      self.indexstack=[]
      self.idx=0
  
   def fits(self, placeInfo):
      'Das Puzzelteil passt'
      bfit = bitvector.disjoint(placeInfo.bv,self.bv)
      #if not bfit:
      #   print "placeInfo",placeInfo.bv.to_list()
      #   print "box      ",self.bv.to_list()
      return bfit

   def newIdx(self):
      'idx ist die Arbeitsposition, die erste leere Position des puzzles'
      free=self.bv.clone()
      free.make_complement()
      holes = self.placeInfo.bvholes.clone()
      holes.intersect(free)
      idx = holes.first()
      #print "newIdx",idx
      return  idx
         
   def add(self, placeInfo,idx):
      'Ein Puzzleteil vorlufig dazufgen. Gibt true zurch wenn alle Teile gelegt sind'
      self.coverage.add(placeInfo.nr)
      
      #die Elementarwrfelein"      
      self.fillstack.append(self.bv.clone())
      self.bv.b |= placeInfo.bv.b
      
      self.placeInfo=placeInfo
      self.placestack.append(placeInfo)
      self.idx = idx
      
      self.indexstack.append(self.idx)
      return self.coverage.freelist() == []     

   def release(self,placeInfo):
      'Teil wieder aus der Box entfernen'
      self.coverage.release(placeInfo.nr)
      #auch die Wrfelchen"
      self.bv = self.fillstack.pop()
      self.placeInfo=self.placestack.pop()
      self.idx=self.indexstack.pop()
  
   def posIndex(self,pos):
      "Platzummer einer Koordinatenangabe"
      dim = len(self.size)
      index = 0
      for i in range(dim-1):
         index += pos[i]
         index *= self.size[i+1]
      index += pos[dim-1]
      return index
      
   def getSize(self):
      "Mae der Box"
      return self.size

   def getVolume(self):
      'Anzahl der Elementarwrfel'
      return self.volume 

   def show(self):
      'Visualisierung'
      d={}
      cL=self.coverage.coverlist()
      print cL
      #print ["%d#%s"%(p.nr,p.indexL) for p in self.placestack]

      for i in range(len(cL)):
         nr = self.placestack[i].nr
         bv = self.placestack[i].bv
         indexL = bv.to_list()
         for idx in indexL:
            d[idx] = nr
      d[self.idx]= "(%s)" % d.get(self.idx,'')
            
      for x in range(self.size[0]):
          for y in range(self.size[1]):
              print "%3d   " % self.posIndex((x,y,0)),
              for z in range(self.size[2]):
                 idx = self.posIndex((x,y,z))
                 nr = d.get(idx,".")
                 print "%4s" % nr,
              print
          print
      

#--------------------------------------------------


if __name__ == "__main__":
   r = partreader.PartReaderC(partlist)

   print "%d parts found:" % r.getPartCount()
   the_box = BoxC(r.getSize(),r.getPartCount())
   print 'box', the_box.getSize()      
