#! /usr/bin/python

from constants import *
from pprint import pprint
import bitvector
import place
import partreader
import box
import bitvector
import profile
#--------------------------------------------------

class PuzzleC:
   def __init__(self, prepare):
      self.prepare=prepare
      self.box = prepare.box
      self.count=0
      self.progress=0
   
   def run(self,idx,tiefe):
      self.progress +=1
      if self.progress %1000 ==0:
         print '.',
      if self.progress %10000 ==0:
         print
         
      coverlist = self.box.coverage.coverlist()
      freelist  = self.box.coverage.freelist()
      if len(coverlist) <  self.prepare.partcount:
         L=self.prepare.placeInfos(idx,freelist,idx>0)
         
         for i in range(len(L)):       
            p = L[i]        
            if self.box.fits(p):
               bFull=self.box.add(p,idx)
               if bFull:
                  self.count += 1
                  print "count",self.count
                  self.box.show()
                  if self.count % 10 == 0:
                     print '.',
               new_idx=self.box.newIdx()
               if new_idx >= 0:
                  self.run(new_idx, tiefe+1)
               self.box.release(p)
      return self.count

def main():
   r = partreader.PartReaderC(partlist)
   the_box = box.BoxC(r.getSize(),r.getPartCount())
   prepare=place.PrepareC(r.partlist(),the_box)

   puzzle=PuzzleC(prepare)
   count=puzzle.run(0,tiefe=0)
   print
   print "Count",count


main()   
#import profile
#profile.run('main()')