// Cube3.cpp : Definiert den Einsprungpunkt fr die Konsolenanwendung.
//

//#include "stdafx.h"
#include <stdio.h>
#include <time.h>

#define NPARTS 12
#define NPOS 25
#define ECKEN 0x0A05000000000A05

const __int64 eins = 1;

// Arrays fr die Puzzleteile und deren Stellungen im Raum
__int64 Stellung[NPARTS][NPOS];							// die gedrehten Puzzleteile
__int64 StellungEcke[NPARTS][NPOS];						// die Stellungen, die in die erse Ecke passen
__int64 TransStellung[NPARTS][60][NPOS];				// die verschobenen Stellungen
short anzTransPos[NPARTS][60];
short anzTransPosEcke[NPARTS][60];
short anzPos[NPARTS], anzPosEcke[NPARTS];						// tatschlich verschiedene Positionen
short xFirst[NPARTS][NPOS], yFirst[NPARTS][NPOS];				// erstes Bit des Teils
short dx[NPARTS][NPOS], dy[NPARTS][NPOS], dz[NPARTS][NPOS];		// Platz zum Verschieben
short MaxAchse[3];												// frs Initialisieren der Teile
short anzEcken[NPARTS];											// wieviele Ecken kann ein Teil belegen?

// globale Variablen fr Initialisierung
short iPart, iCube;
short point[6][6];

short firstPart;
__int64 X0, X2, Y0, Y3, Z0, Z4;			// Rand-Ebenen

// fr Zeitmessung
time_t start, now;

// Zhler fr Lsungen und getestete Stellungen
__int64 nSolutions;


















/////////////// ein Wrfel zum Teil hinzufgen //////////////////////////////
// iCube wird in Main() und Drehen() auf 0 (zurck-)gesetzt
void Insert(short x, short y, short z)
{
	point[iCube][0] = x;
	point[iCube][1] = y;
	point[iCube][2] = z;
	iCube++;
}












/////////////////////////////////////////////////////////
///////// Eckstellungen berechnen ///////////////////////
void Ecken()
{
	__int64  teil;

	anzPosEcke[iPart] = 0;
	for( short iPos = 0; iPos<anzPos[iPart]; iPos++)
	{
		// Teil in Ecke (x,y,z) schieben
		teil =	Stellung[iPart][iPos];
		
		if( (teil & eins)==0 )  // Prfen, ob Teil die 1.Ecke belegt
			continue;

		if( anzEcken[iPart]==0 )
			// Teil kann eine Ecke belegen
			anzEcken[iPart] = 1;
		
		StellungEcke[iPart][anzPosEcke[iPart]++] = teil;
		
		if( teil & ( ECKEN - 1 ) )
		{
			// Teil kann 2 Ecken belegen
			anzEcken[iPart] = 2;
			if( teil & 4 )	// Ecke1 (x=2, y=0, z=0)
				teil = ((teil&X0)<<2) | (teil&(~(X0|X2))) | ((teil&X2)>>2);
			else if( teil & 0x200 )	// Ecke2 (x=0, y=3, z=0)
				teil = ((teil&Y0)<<9) | ((teil&(Y0<<3))<<3) | ((teil&(Y3>>3))>>3) | ((teil&Y3)>>9);
			else
				printf("Programmfehler in Ecken()\n");

			// gespiegeltes Teil suchen
			for( short i=0; i<anzPosEcke[iPart]-1; i++)
			{
				if( teil==StellungEcke[iPart][i] )
				{
					anzPosEcke[iPart]--;
					break;
				}
			}
		} //if Ecke==0
	}// for iPos
//	printf("%i Eckpositionen\n", anzPosEcke[iPart]);
//	printf("Teil kann %i Ecken belegen\n", anzEcken[iPart]);
}




////////////////////////////////////////////////////////////
/////////// Verschiebungen berechnen ///////////////////////
void Verschieben()
{
	short movex, movey, x,y,z, iPos, hatEcken;
	for(z=0;z<=4;z++)
		for(y=0;y<=3;y++)
			for(x=0;x<=2;x++)
			{
				anzTransPos[iPart][x+3*y+12*z] = 0;
				for( hatEcken=1; hatEcken>=0; hatEcken--)	// Zuerst alle Stellungen, die eine Ecke belegen
				{
					for( iPos = 0; iPos<anzPos[iPart]; iPos++)
					{
						if(											  z<=dz[iPart][iPos]
						 && (movex = x-xFirst[iPart][iPos])>=0 && movex<=dx[iPart][iPos]
						 && (movey = y-yFirst[iPart][iPos])>=0 && movey<=dy[iPart][iPos] )
							if( ((Stellung[iPart][iPos]<<(movex+3*movey+12*z))&ECKEN ? 1 : 0)==hatEcken )
								TransStellung[iPart][x+3*y+12*z][anzTransPos[iPart][x+3*y+12*z]++] 
									= Stellung[iPart][iPos]<<(movex+3*movey+12*z);

					}
					if( hatEcken )
						anzTransPosEcke[iPart][x+3*y+12*z] = anzTransPos[iPart][x+3*y+12*z];
				}
			}


	
}














///////////// Teil in alle Rcihtungen drehen und spiegeln //////////////////////////////
void Drehen()
{
	// Ausdehnung des Teils fr jede Achse berechnen
	short cube,achse;
	for( achse=0; achse<3; achse++)
	{
		MaxAchse[achse]=0;
		for( cube=0; cube<iCube; cube++)
		{
			if( point[cube][achse]>MaxAchse[achse] )
				MaxAchse[achse] = point[cube][achse];
		}
	}
	
	// Achswerte spiegeln
	for( cube=0; cube<iCube; cube++)
		for( achse=0; achse<3; achse++)
			point[cube][achse+3] = MaxAchse[achse]-point[cube][achse];

	// Jetzt knnen alle Drehungen berechnet werden
	short achse1,achse2,achse3,iPos;
	anzPos[iPart] = 0;
	__int64 newBit, firstBit;
	for( achse1=0; achse1<6; achse1++)
		for( achse2=0; achse2<6; achse2++)
		{
			if( achse2%3 == achse1%3 )
				continue;

			for(achse3 = 3- achse1%3 - achse2%3; achse3<6; achse3+=3)
			{
				// Prfen, ob gedrehtes Teil in Quader passt
				if( MaxAchse[achse1%3]<=2 && MaxAchse[achse2%3]<=3 && MaxAchse[achse3%3]<=4 )
				{
					// Bitmap fr neue Stellung berechnen
					Stellung[iPart][ anzPos[iPart] ] = 0;
					xFirst[iPart][ anzPos[iPart] ] = 0;
					yFirst[iPart][ anzPos[iPart] ] = 0;
					firstBit = 60;
					for( cube=0; cube<iCube; cube++)
					{
						newBit = point[cube][achse1] + 3*point[cube][achse2] + 12*point[cube][achse3];
						Stellung[iPart][anzPos[iPart]] |= eins<<newBit;
						// das niedrigste Bit merken
						if( newBit<firstBit )
						{
							xFirst[iPart][ anzPos[iPart] ] = point[cube][achse1];
							yFirst[iPart][ anzPos[iPart] ] = point[cube][achse2];
							// Bemerkung: zFirst ist immer = 0!
							firstBit = newBit;
						}
					}

					// Prfen, ob Stellung schon in der Liste
					for( iPos=0; Stellung[iPart][iPos] != Stellung[iPart][ anzPos[iPart] ]; iPos++ );

					if( iPos==anzPos[iPart] )
					{
						// Stellung nicht gefunden
						// Maximalwerte frs Verschieben
						dx[iPart][anzPos[iPart]] = 2-MaxAchse[achse1%3];
						dy[iPart][anzPos[iPart]] = 3-MaxAchse[achse2%3];
						dz[iPart][anzPos[iPart]] = 4-MaxAchse[achse3%3];
						anzPos[iPart]++;
					}
				}//if MaxAchse...
			}//for achse3
		}//for achse2
		
//	printf("\nTeil %i   ", iPart);
//	printf("%i Stellungen\n", anzPos[iPart]);
	//printPart(Stellung[iPart][0]);

	Ecken();
	Verschieben();

	iPart++;
	iCube = 0;
}

///////////////  Teile erstellen ////////////////////////////////////////////

// Die Teile wurden so umsortiert,
// dass die Teile mit wenigen mglichen Stellungen zuerst kommen.

void InitParts()
{
	iPart = 0;
	iCube = 0;

	// + Teil, passt nicht ins Eck!
	Insert(0,1,0); Insert(1,0,0); Insert(1,1,0); Insert(2,1,0); Insert(1,2,0);
	Drehen();

	// Z-Teil
	Insert(0,0,0); Insert(1,0,0); Insert(1,1,0); Insert(2,1,0); Insert(2,2,0);
	Drehen();
	
	// W-Teil
	Insert(0,0,0); Insert(1,0,0); Insert(1,1,0); Insert(1,2,0); Insert(2,2,0);
	Drehen();
	
	// Abzweig-Teil
	Insert(0,0,0); Insert(0,1,0); Insert(1,1,0); Insert(0,2,0); Insert(0,3,0);
	Drehen();

	// ct-Teil (Sechser)
	Insert(0,0,0); Insert(1,0,0); Insert(0,1,0); Insert(0,2,0); Insert(1,2,0); Insert(0,3,0);
	Drehen();

	// L-Teil	
	Insert(0,0,0); Insert(1,0,0); Insert(0,1,0); Insert(0,2,0); Insert(0,3,0);
	Drehen();

	// komisches Teil ( Drehstuhl)	(nur ein Wrfelchen passt in Ecke)
	Insert(0,0,0); Insert(0,1,0); Insert(1,1,0); Insert(2,1,0); Insert(1,2,0);
	Drehen();

	// Viererteil (3D)
	Insert(0,0,0); Insert(1,0,0); Insert(1,1,0); Insert(0,0,1);
	Drehen();

	// Quadrat-3-D-Teil
	Insert(0,0,0); Insert(1,0,0); Insert(1,1,0); Insert(0,1,0); Insert(0,0,1);
	Drehen();

	// T-Teil 
	Insert(0,0,0); Insert(0,1,0); Insert(1,1,0); Insert(2,1,0); Insert(0,2,0);
	Drehen();

	// U-Teil
	Insert(0,0,0); Insert(1,0,0); Insert(0,1,0); Insert(0,2,0); Insert(1,2,0);
	Drehen();

	// Quadrat mit Anhngsel
	Insert(0,0,0); Insert(1,0,0); Insert(1,1,0); Insert(0,1,0); Insert(0,2,0);
	Drehen();
}












/////////// Lsungsfunktion fr die erste noch freie Stelle im Quader ////////////////////////////
void Solve(__int64 quader, short stelle, short benutzt)
{
	// Alle Teile vernutzt?
	if(benutzt==0x0FFF)
	{
		// Lsung gefunden
		nSolutions++;
		return;
	}

	// Enthlt Quader eine freie Position ohne freien Nachbarn?
	if( (~quader) & ((quader >> 1)|X2) 
				  & ((quader << 1)|X0) 
				  & ((quader >> 3)|Y3)
				  & ((quader << 3)|Y0) 
				  & ((quader >>12)|Z4) 
				  & ((quader <<12)|Z0) )
		return;

	//Ecken zhlen
	short belegteEcken = 1		// erste Ecke ist immer belegt
					   + ( ( quader>>2 ) & 1 )
					   + ( ( quader>>9 ) & 1 )
					   + ( ( quader>>11) & 1 )
					   + ( ( quader>>48) & 1 )
					   + ( ( quader>>50) & 1 )
					   + ( ( quader>>57) & 1 )
					   + ( ( quader>>59) & 1 );

	// Ecken dazuzhlen, die die brigen Teile maximal bedecken knnten
	for( short iPart=firstPart+1; iPart<NPARTS && belegteEcken<8; iPart++)
		if((~benutzt>>iPart)&1)
		{
			belegteEcken++;
			if( (iPart>=3 && iPart<=5 && ( ((0x101<< 2)&quader)==(0x101<< 2)
									    || ((0x101<<48)&quader)==(0x101<<48)
									    || ((0x101<<50)&quader)==(0x101<<50) ))
			  ||(iPart>=9 && iPart<=11 && ( ((5<< 9)&quader)==(5<< 9)
									     || ((5<<48)&quader)==(5<<48)
									     || ((5<<57)&quader)==(5<<57) ))    )
				belegteEcken++;
		}

	if( belegteEcken < 8 )	
		// nicht mehr gengend Ecken vorhanden
		return;

	// Nchste freie Position suchen
	while( quader & (eins<<stelle) )
		stelle++;

	if( stelle>=60 )
		printf("Programmfehler 1\n");// hier darf man nie hinkommen

	// freie Position gefunden
	// Alle noch nicht benutzen Teile probieren
	short i, benutztNeu;
	__int64* pStellung;
	for( iPart=((eins<<stelle)&ECKEN ? firstPart+1 : 0); iPart<NPARTS; iPart++)
	{
		if( benutzt == (benutztNeu = benutzt | (1<<iPart)) )
			continue;

		for(pStellung = &TransStellung[iPart][stelle][ i=( iPart>firstPart ? 0 : anzTransPosEcke[iPart][stelle] ) ];
				i<anzTransPos[iPart][stelle]; i++, pStellung++)
			if( (*pStellung & quader)==0 )
				Solve(quader|*pStellung, stelle+1, benutztNeu );
	}
}








///////////////// Hauptprogramm ///////////////////////////////////////////
int main(int argc, char* argv[])
{
	time(&start);

	// Die Randebenen initialisieren
	short x,y,z;
	__int64 testbit = 1;
	X0=Y0=Z0=X2=Y3=Z4=0;
	for(z=0; z<=5; z++)
		for(y=0; y<=3; y++)
			for(x=0; x<=2; x++, testbit<<=1)
			{
				if(x==0) X0|=testbit;
				if(x==2) X2|=testbit;
				if(y==0) Y0|=testbit;
				if(y==3) Y3|=testbit;
				if(z==0) Z0|=testbit;
				if(z==4) Z4|=testbit;
			}

	InitParts();

//	time(&now);
//	printf("\nZeit frs Drehen der Teile %i Sekunden\n\n", now-start);


	
	nSolutions = 0;
	// Alle Teile, die fr erste Ecke in Frage kommen
	// t-Teil kommt nicht in Frage
	for( firstPart=1; firstPart<=7; firstPart++)
		// Alle Drehungen des Teils durchprobieren
		for( int iPos=0; iPos<anzPosEcke[firstPart]; iPos++)
		{
			// Fortschrittsanzeige
			printf("Mit Teil %i, ", firstPart);
			printf("Stellung %i beginnen. Bis jetzt ", iPos);
			printf("%i Loesungen ", nSolutions);
			time(&now);
			printf("in %i Sekunden\n", now-start);

			Solve(StellungEcke[firstPart][iPos], 1, 1<<firstPart);
		}
	
	
		
		
	time(&now);
	printf("%i Loesungen\n", nSolutions);
	printf("in %i Sekunden\n", now-start);
	return 0;
}