#! xbigforth
include rotation.fs
: dcount  ( adr -- adr len ) dup @ >r cell+ r> ; macro

: vdup ( n1 n2 n3 -- n1 n2 n3 n1 n2 n3 )
      2 pick 2 pick 2 pick ;

: v- ( x1 y1 z1 x2 y2 z2 -- dx dy dz )
     >r rot r> swap - >r      \ dz
     rot - >r                 \ dy
     swap - r> r> ;

: v+ ( x1 y1 z1 x2 y2 z2 -- x3 y3 z3 )
     >r rot r> + >r      \ z
     rot + >r            \ y
     + r> r> ;

: vnegate >r >r negate r> negate r> negate ;

: x-pos ;

: y-pos cell+ ;

: z-pos cell+ cell+ ;

: v@ ( adr -- x y z ) dup >r x-pos @ r@ y-pos @ r> z-pos @ ;

: v! ( x y z adr -- ) dup >r z-pos ! r@ y-pos ! r> x-pos ! ;

: v, ( x y z -- )
     rot , swap , , ;

: teil: ( x1 y1 z1 .. xn yn zn n -- )
   Create dup , 0 ?DO v, LOOP  ;

: t> ( n adr -- x y z ) >r 3 * cells r> + cell+ v@ ;

 1  0  0         0  1  0         0  1  0
-1  0  0         0  0  0         5 teil: t1
 1  0  0         0  1  0         0  1  0
 1  0  0         0  0  0         5 teil: t2
 0  1  0         0  1  0         0  1  0
 1  0  0         0  0  0         5 teil: t3
-1 -1  0         0  1  0         0  1 0
 0  1  0         0  0  0         5 teil: t4
 0 -1  0         0  0  1        -1  1 0
 1  0  0         0  0  0         5 teil: t5
-2  0  0         1  0  0         0  1 0
 0  1  0         0  0  0         5 teil: t6
-1 -1 0         0 1 0           0 1 0
 1 0 0          0 0 0           5 teil: t7
 0 1 0          1 0 0           0 1 0
 1 0 0          0 0 0           5 teil: t8
 0 1 0          1 0 -1          0 0 1
 0 0 0          4 teil: t9
 1 -1 0         0 1 0           0 1 0
 1 0 0          0 0 0           5 teil: t10
 1 1 0         -2 0 0           1 0 0
 0 1 0          0 0 0           5 teil: t11
 1 -1 0         0 1 0           0 1 0
-1 1 0          1 0 0           0 0 0      6 teil: t12

\ Table: teile t1 t2 t3 t4 t5 t6 t7 t8 t9 t10 t11 t12 ]
\ DOES> swap cells + perform ;

Table: teile  t11 t12 t2 t6 t8 t4 t3 t1 t9 t10 t7 t5 ]
DOES> swap cells + perform ;

\ : negate1  negate ;
\ : negate2  swap negate swap ;
\ : negate3  rot negate -rot ;

\ : vnegs  ( 0..7 -- )
\     >r r@ %001 and IF negate1 THEN
\       r@ %010 and IF negate2 THEN
\       r> %100 and IF negate3 THEN ;

2Variable #overlap  2 cells allot
2Variable #ueberdeckung  2 cells allot
2Variable w
Variable fehler
Variable teil    \ Adresse von Teil
Variable richtung

: print ( adr -- ) cr
   [ 5 4 * 3 * ] Literal
   0 DO I 5 mod 0= IF cr THEN  dup I bit@
        IF 1 ELSE 0 THEN . LOOP drop ;

: w> ( x y z -- nr )
    20 * swap 5 * + + dup 0 60 within 0= abort" fehler" ;

: chk ( x y z -- x y z false / x y z true )
    vdup 0 3 within >r 0 4 within >r 0 5 within r> and r> and ;

: +element ( adr x y z -- )
   chk IF w> +bit ELSE fehler on 2drop 2drop THEN ;

: fehler> ( -- flg )
   fehler @ ;

: +teil ( adr x y z teil-adr -- )
   fehler off dup teil !
   @ 0 DO I teil @ t>
     \  richtung @ 8 /mod swap >r 
     \    teil @ [ t12 ] Literal =
     \    IF drop ELSE 0 ?DO rot LOOP THEN r> vnegs
         teil @ [ t12 ] Literal =
         IF richtung @ 3 min rotation2
         ELSE richtung @ rotation1 THEN 
          v+ ( vdup) 3 pick 3 pick 3 pick 3 pick
          +element LOOP 2drop 2drop ;

: overlap ( adr -- flg )
   2@ #overlap 2@ rot and >r and r> or ; macro

: add ( adr -- )
   2@ #ueberdeckung 2@ rot or >r or r>
   #ueberdeckung 2! ; macro

: value-
   2@ w 2@  d- or ;   macro

: ueberdecked (  adr -- flg )
   2@ $FFFFFFFF0FFFFFFF. d- d0= ; macro

Create teilesatz 20000 2* cells allot
: teilesatz-empty
       teilesatz 20000 2* cells erase ;

Create teilestack 14 2* cells allot
: teilestack-empty
       teilestack 14  2* cells erase ;

Create einfuege-stack 14 2* cells allot
: einfuege-stack-empty
       einfuege-stack 14  2* cells erase ;

1000000 12 * 2 * cells allocate 0= [IF] Value loesungen [THEN]

: loesungen-empty
       loesungen  1000000  12 * 2 * cells erase ;

: wuerfel-enthalten? ( adr -- flg )
   dcount 0 -rot bounds
   ?DO I value- 0= IF drop true leave THEN 2 cells +LOOP ;

: einfuegen  ( wadr adr -- )
   >r 2@ r@ dcount + 2! 2 cells r> +! ;  macro

: neue-einfuegen ( adr -- )
   dup wuerfel-enthalten? 0=
   IF w swap einfuegen ELSE drop THEN ;

: print-set ( adr -- )
   dcount bounds ?DO I print 2 cells +LOOP ;

Variable #teil  -1 #teil !
Variable einfuegeptr

: mark-ende
   -1 einfuegeptr @ ! cell einfuegeptr +! ;

: naechster
  einfuegeptr @ dcount + dup off einfuegeptr ! ;

: .lens ( adr -- )
   BEGIN dup @ -1 -
   WHILE dup @ 2 cells / . dcount + REPEAT drop ;

: printteilestack
   teilestack dcount bounds ?DO I @ cr .lens cell +LOOP ;

: teile-berechnen
    teilestack-empty
    teilesatz-empty teilesatz einfuegeptr !
    einfuegeptr @ teilestack dcount + ! cell teilestack +!
    60 24 * 12 * 0
    DO  I 5 /mod 4 /mod 3 /mod  24 /mod 12 mod
        dup #teil @ -
        IF naechster dup #teil ! THEN
        teile swap 0. w 2! richtung ! w 4 -roll +teil
        fehler> 0= IF einfuegeptr @ neue-einfuegen THEN
    LOOP naechster mark-ende ;
teile-berechnen
printteilestack

: ((neue-suche ( adr --  )
   dcount bounds
   ?DO I overlap 0= IF I dup add einfuegeptr @ einfuegen THEN
    2 cells +LOOP ;

: (neue-suche ( adr -- ) dcount + einfuegeptr @ off naechster
   BEGIN dup @ -1 -
   WHILE dup ((neue-suche dcount +
   naechster REPEAT drop mark-ende ;

einfuege-stack-empty

: neue-suche ( -- )
   0. #ueberdeckung 2!
   einfuegeptr @ teilestack dcount + ! cell teilestack +!
   einfuege-stack  dcount bounds ?DO I add 2 cells +LOOP
   teilestack dcount + cell- cell- @ dcount + (neue-suche ;

: ein-teil-entnehmen ( -- adr true/0 )
   teilestack @ 0= IF 0 EXIT THEN
   teilestack dcount + cell- @
   dup dcount + dcount dup -1 = IF drop 0 THEN dup dup >r
   IF over 2@ #overlap 2!
   cell /string cell- swap ! 2 cells  swap +!
   ELSE drop 2drop THEN r> ;

: produktiv ( -- flg )
   teilestack dcount + cell- @
   $7FFFFFFF swap dcount + dup @ -1 - 0=
   IF 2drop 0 EXIT THEN
   BEGIN dup @ -1 -
   WHILE dup >r @ 2 cells / min r> dcount + REPEAT drop ;

: loesung-einfuegen  (  -- )
   einfuege-stack cell+ loesungen dcount + 96 move
   96 loesungen +! ;

loesungen-empty

Variable #loesungen

: zerlege
   ein-teil-entnehmen
   IF #overlap einfuege-stack einfuegen neue-suche THEN
   einfuege-stack @ 96 =
   IF loesung-einfuegen 1 #loesungen +! THEN
   #ueberdeckung ueberdecked 0=  produktiv 0= or
   IF 2 cells negate einfuege-stack +!
        cell  negate teilestack +!
      teilestack dcount + @ einfuegeptr ! THEN ;

\needs durchlaeufe Variable durchlaeufe

: wuerfeln durchlaeufe off
   BEGIN  1 durchlaeufe +! zerlege
   teilestack @ 0= key? or UNTIL ;

!time wuerfeln 
cr .( Rechenzeit : ) .time
cr .( ausgefhrte Vergleichszyclen : ) durchlaeufe @ u.
cr .( gefundene Lsungen : ) #loesungen @ .
include ctwgraph.m
ctwuerfel open
