// Lsung des ct-Puzzles
// Eiko Bleicher
// Eiko.Bleicher@t-online.de


#include <stdio.h>

#include <time.h>





/*
       
       55 56 57 58 59    obere Schicht
	   50 51 52 53 54
       45 46 47 48 49
       40 41 42 43 44

	 35 36 37 38 39		 mittlere Schicht
     30 31 32 33 34
     25 26 27 28 29
     20 21 22 23 24
   
   15 16 17 18 19		 untere Schicht
   10 11 12 13 14
   05 06 07 08 09
   00 01 02 03 04

*/


typedef unsigned __int64 WUERFEL; 

#define		BIT00	(((WUERFEL) 1)<<0)
#define		BIT01	(((WUERFEL) 1)<<1)
#define		BIT02	(((WUERFEL) 1)<<2)
#define		BIT03	(((WUERFEL) 1)<<3)
#define		BIT04	(((WUERFEL) 1)<<4)
#define		BIT05	(((WUERFEL) 1)<<5)
#define		BIT06	(((WUERFEL) 1)<<6)
#define		BIT07	(((WUERFEL) 1)<<7)
#define		BIT08	(((WUERFEL) 1)<<8)
#define		BIT09	(((WUERFEL) 1)<<9)
#define		BIT10	(((WUERFEL) 1)<<10)
#define		BIT11	(((WUERFEL) 1)<<11)
#define		BIT12	(((WUERFEL) 1)<<12)
#define		BIT13	(((WUERFEL) 1)<<13)
#define		BIT14	(((WUERFEL) 1)<<14)
#define		BIT15	(((WUERFEL) 1)<<15)
#define		BIT16	(((WUERFEL) 1)<<16)
#define		BIT17	(((WUERFEL) 1)<<17)
#define		BIT18	(((WUERFEL) 1)<<18)
#define		BIT19	(((WUERFEL) 1)<<19)
#define		BIT20	(((WUERFEL) 1)<<20)
#define		BIT21	(((WUERFEL) 1)<<21)
#define		BIT22	(((WUERFEL) 1)<<22)
#define		BIT23	(((WUERFEL) 1)<<23)
#define		BIT24	(((WUERFEL) 1)<<24)
#define		BIT25	(((WUERFEL) 1)<<25)
#define		BIT26	(((WUERFEL) 1)<<26)
#define		BIT27	(((WUERFEL) 1)<<27)
#define		BIT28	(((WUERFEL) 1)<<28)
#define		BIT29	(((WUERFEL) 1)<<29)
#define		BIT30	(((WUERFEL) 1)<<30)
#define		BIT31	(((WUERFEL) 1)<<31)
#define		BIT32	(((WUERFEL) 1)<<32)
#define		BIT33	(((WUERFEL) 1)<<33)
#define		BIT34	(((WUERFEL) 1)<<34)
#define		BIT35	(((WUERFEL) 1)<<35)
#define		BIT36	(((WUERFEL) 1)<<36)
#define		BIT37	(((WUERFEL) 1)<<37)
#define		BIT38	(((WUERFEL) 1)<<38)
#define		BIT39	(((WUERFEL) 1)<<39)
#define		BIT40	(((WUERFEL) 1)<<40)
#define		BIT41	(((WUERFEL) 1)<<41)
#define		BIT42	(((WUERFEL) 1)<<42)
#define		BIT43	(((WUERFEL) 1)<<43)
#define		BIT44	(((WUERFEL) 1)<<44)
#define		BIT45	(((WUERFEL) 1)<<45)
#define		BIT46	(((WUERFEL) 1)<<46)
#define		BIT47	(((WUERFEL) 1)<<47)
#define		BIT48	(((WUERFEL) 1)<<48)
#define		BIT49	(((WUERFEL) 1)<<49)
#define		BIT50	(((WUERFEL) 1)<<50)
#define		BIT51	(((WUERFEL) 1)<<51)
#define		BIT52	(((WUERFEL) 1)<<52)
#define		BIT53	(((WUERFEL) 1)<<53)
#define		BIT54	(((WUERFEL) 1)<<54)
#define		BIT55	(((WUERFEL) 1)<<55)
#define		BIT56	(((WUERFEL) 1)<<56)
#define		BIT57	(((WUERFEL) 1)<<57)
#define		BIT58	(((WUERFEL) 1)<<58)
#define		BIT59	(((WUERFEL) 1)<<59)

#define		UNGUELTIG		((((WUERFEL) 1) << 63) - 1)
#define		UNG_TESTBIT		(((WUERFEL) 1) << 62)
#define		UNG_TESTBIT_32	((unsigned int) (UNG_TESTBIT >> 32))

#define		RANDUNTEN	(BIT20 - ((WUERFEL) 1))
#define		RANDOBEN	(RANDUNTEN << 40)
#define		RANDLINKS	(BIT00 | BIT05 | BIT10 | BIT15 | BIT20 | BIT25 | BIT30 | BIT35 | BIT40 | BIT45 | BIT50 | BIT55)
#define		RANDRECHTS	(RANDLINKS << 4)
#define		RANDVORNE	(BIT00 | BIT01 | BIT02 | BIT03 | BIT04 | BIT20 | BIT21 | BIT22 | BIT23 | BIT24 | BIT40 | BIT41 | BIT42 | BIT43 | BIT44)
#define		RANDHINTEN	(RANDVORNE << 15)

#define TESTBIT(wuerfel,bit)	(wuerfel&(((WUERFEL) 1)<<bit))
#define CLEARBIT(wuerfel,bit)	{wuerfel &= ~(((WUERFEL) 1)<<bit);}
#define SETBIT(wuerfel,bit)		{wuerfel |= (((WUERFEL) 1)<<bit);}
#define COPYBIT(dest,dbit,source,sbit)	{if TESTBIT((source),(sbit)) SETBIT((dest),(dbit)) else CLEARBIT((dest),(dbit)) }

// 12 Teile.. + das letzte = Teil nr. 2 symmetriebeschrnkt

WUERFEL teile[13];	// die originalen Teile

WUERFEL rotationen[13][64];

WUERFEL *final[13];

short anzahl[13]; // anzahl in final[0..12]

time_t startzeit, endzeit;

unsigned int loesungsanzahl;


void printWuerfel(WUERFEL w) {
	for (int a4 = 3; a4 >= 0; a4--) {
		for (int a3 = 0; a3 <= 2; a3++) {
			for (int a5 = 0; a5 < 5; a5++) {
				if (TESTBIT(w,(WUERFEL) (a3*20+a4*5+a5))) printf("#");
				else printf(".");
			}
			printf("  ");
		}
		printf("\n");
	}
	printf("\n");

}

// Teil nach links unten vorne verschieben
void nach_untenlinksvorne(WUERFEL &w){
	// nach unten schieben
	while ((w & RANDUNTEN) == 0) {
		w >>= 20;
	}
	// nach links schieben
	while ((w & RANDLINKS) == 0) {
		w >>= 1;
	}
	// nach vorn schieben
	while ((w & RANDVORNE) == 0) {
		w >>= 5;
	}

}

void entferne_doppelte() {
	for (int i = 0; i < 13; i++) {
		for (int j = 0; j < 64; j++) {
			WUERFEL temp = rotationen[i][j];
			for (int k = j+1; k < 64; k++) {
				if (rotationen[i][k] == temp)
					rotationen[i][k] = 0;
			}
		}
	}
}

// Dreht innerhalb des Wuerfels w den 3er-Subwuerfel links unten
// a3: Anzahl der PI/4-Drehungen um Achse der Laenge 3, etc.
WUERFEL dreh_sub333wuerfel(WUERFEL w, short a3, short a4, short a5) {
	WUERFEL result = w;
	while (a3>0) {
		w = result;
		COPYBIT(result,0,w,10);
		COPYBIT(result,1,w,5);
		COPYBIT(result,2,w,0);
		COPYBIT(result,5,w,11);
		COPYBIT(result,7,w,1);
		COPYBIT(result,10,w,12);
		COPYBIT(result,11,w,7);
		COPYBIT(result,12,w,2);
		COPYBIT(result,20,w,30);
		COPYBIT(result,21,w,25);
		COPYBIT(result,22,w,20);
		COPYBIT(result,25,w,31);
		COPYBIT(result,27,w,21);
		COPYBIT(result,30,w,32);
		COPYBIT(result,31,w,27);
		COPYBIT(result,32,w,22);
		COPYBIT(result,40,w,50);
		COPYBIT(result,41,w,45);
		COPYBIT(result,42,w,40);
		COPYBIT(result,45,w,51);
		COPYBIT(result,47,w,41);
		COPYBIT(result,50,w,52);
		COPYBIT(result,51,w,47);
		COPYBIT(result,52,w,42);
		a3--;
	}
	while (a4>0) {
		w = result;
		COPYBIT(result,0,w,40);
		COPYBIT(result,1,w,20);
		COPYBIT(result,2,w,0);
		COPYBIT(result,5,w,45);
		COPYBIT(result,6,w,25);
		COPYBIT(result,7,w,5);
		COPYBIT(result,10,w,50);
		COPYBIT(result,11,w,30);
		COPYBIT(result,12,w,10);
		COPYBIT(result,20,w,41);
		COPYBIT(result,22,w,1);
		COPYBIT(result,25,w,46);
		COPYBIT(result,27,w,6);
		COPYBIT(result,30,w,51);
		COPYBIT(result,32,w,11);
		COPYBIT(result,40,w,42);
		COPYBIT(result,41,w,22);
		COPYBIT(result,42,w,2);
		COPYBIT(result,45,w,47);
		COPYBIT(result,46,w,27);
		COPYBIT(result,47,w,7);
		COPYBIT(result,50,w,52);
		COPYBIT(result,51,w,32);
		COPYBIT(result,52,w,12);
		a4--;
	}
	while (a5>0) {
		w = result;
		COPYBIT(result,0,w,40);
		COPYBIT(result,1,w,41);
		COPYBIT(result,2,w,42);
		COPYBIT(result,5,w,20);
		COPYBIT(result,6,w,21);
		COPYBIT(result,7,w,22);
		COPYBIT(result,10,w,0);
		COPYBIT(result,11,w,1);
		COPYBIT(result,12,w,2);
		COPYBIT(result,20,w,45);
		COPYBIT(result,21,w,46);
		COPYBIT(result,22,w,47);
		COPYBIT(result,30,w,5);
		COPYBIT(result,31,w,6);
		COPYBIT(result,32,w,7);
		COPYBIT(result,40,w,50);
		COPYBIT(result,41,w,51);
		COPYBIT(result,42,w,52);
		COPYBIT(result,45,w,30);
		COPYBIT(result,46,w,31);
		COPYBIT(result,47,w,32);
		COPYBIT(result,50,w,10);
		COPYBIT(result,51,w,11);
		COPYBIT(result,52,w,12);
		a5--;
	}
	nach_untenlinksvorne(result);
	return result;
}

// Teil muss mit der langen Seite vorne liegen!!
// Teil darf max. 4 * 2 * 2 sein
WUERFEL dreh_sub442wuerfel(WUERFEL w, short a3, short a4, short a5) {
	WUERFEL result = w;
	while (a4>0) {
		w = result;
		COPYBIT(result,0,w,23);
		COPYBIT(result,1,w,22);
		COPYBIT(result,2,w,21);
		COPYBIT(result,3,w,20);
		COPYBIT(result,5,w,28);
		COPYBIT(result,6,w,27);
		COPYBIT(result,7,w,26);
		COPYBIT(result,8,w,25);
		COPYBIT(result,20,w,3);
		COPYBIT(result,21,w,2);
		COPYBIT(result,22,w,1);
		COPYBIT(result,23,w,0);
		COPYBIT(result,25,w,8);
		COPYBIT(result,26,w,7);
		COPYBIT(result,27,w,6);
		COPYBIT(result,28,w,5);
		a4-=2;
		nach_untenlinksvorne(result);

	}
	while (a5>0) {
		w = result;
		COPYBIT(result,0,w,20);
		COPYBIT(result,1,w,21);
		COPYBIT(result,2,w,22);
		COPYBIT(result,3,w,23);
		COPYBIT(result,5,w,0);
		COPYBIT(result,6,w,1);
		COPYBIT(result,7,w,2);
		COPYBIT(result,8,w,3);
		COPYBIT(result,20,w,25);
		COPYBIT(result,21,w,26);
		COPYBIT(result,22,w,27);
		COPYBIT(result,23,w,28);
		COPYBIT(result,25,w,5);
		COPYBIT(result,26,w,6);
		COPYBIT(result,27,w,7);
		COPYBIT(result,28,w,8);
		a5--;
		nach_untenlinksvorne(result);
	}
	while (a3>0) {
		w = result;
		COPYBIT(result,0,w,15);
		COPYBIT(result,1,w,10);
		COPYBIT(result,2,w,5);
		COPYBIT(result,3,w,0);
		COPYBIT(result,5,w,16);
		COPYBIT(result,6,w,11);
		COPYBIT(result,7,w,6);
		COPYBIT(result,8,w,1);
		COPYBIT(result,10,w,17);
		COPYBIT(result,11,w,12);
		COPYBIT(result,12,w,7);
		COPYBIT(result,13,w,2);
		COPYBIT(result,15,w,18);
		COPYBIT(result,16,w,13);
		COPYBIT(result,17,w,8);
		COPYBIT(result,18,w,3);
		COPYBIT(result,20,w,35);
		COPYBIT(result,21,w,30);
		COPYBIT(result,22,w,25);
		COPYBIT(result,23,w,20);
		COPYBIT(result,25,w,36);
		COPYBIT(result,26,w,31);
		COPYBIT(result,27,w,26);
		COPYBIT(result,28,w,21);
		COPYBIT(result,30,w,37);
		COPYBIT(result,31,w,32);
		COPYBIT(result,32,w,27);
		COPYBIT(result,33,w,22);
		COPYBIT(result,35,w,38);
		COPYBIT(result,36,w,33);
		COPYBIT(result,37,w,28);
		COPYBIT(result,38,w,23);
		a3--;
	}
	nach_untenlinksvorne(result);
	return result;
}

// liefert die anzahl der positionen eines Teils auf den entsprechenden Achsen 
// Teil muss links vorne unten liegen!
void anzahl_positionen(WUERFEL w, int &a3, int &a4, int &a5) {
	a3 = 1; 
	a4 = 1;
	a5 = 1;
	while ((w & RANDRECHTS) == 0) {
		w <<= 1;
		a5++;
	}
	while ((w & RANDHINTEN) == 0) {
		w <<= 5;
		a4++;
	}
	while ((w & RANDOBEN) == 0) {
		w <<= 20;
		a3++;
	}
}

// erledigt die Verschiebungen
void erstelle_final() {
	WUERFEL *temp = new WUERFEL[1024];
	for (int i = 0; i < 13; i++) {
		int count = 0;
		for (int j = 0; j < 64; j++) {
			if (rotationen[i][j] != 0) {
				int a3, a4, a5;
				WUERFEL trans = rotationen[i][j];
				anzahl_positionen(trans,a3,a4,a5);
				for (int t3 = 0; t3 < a3; t3++)
					for (int t4 = 0; t4 < a4; t4++)
						for (int t5 = 0; t5 < a5; t5++) {
							temp[count] = trans << (t5 + 5*t4 + 20*t3);
							count++;
						}
			}
		}

		final[i] = new WUERFEL[count];
		for (int j = 0; j < count; j++)
			final[i][j] = temp[j];
			anzahl[i] = count;
	}
	delete temp;
}

/*
WUERFEL drehe_komplett3(WUERFEL w) {
	WUERFEL result = w;
	for (int i = 0; i < 20; i++) {
		COPYBIT(result,i,w,(19-i));
		COPYBIT(result,i+20,w,39-i);
		COPYBIT(result,i+40,w,59-i);
	}
	return result;
}

WUERFEL drehe_komplett4(WUERFEL w) {
	WUERFEL result = w;
	for (int i = 0; i < 5; i++) {
		COPYBIT(result,i,w,44-i);
		COPYBIT(result,i+5,w,49-i);
		COPYBIT(result,i+10,w,54-i);
		COPYBIT(result,i+15,w,59-i);

		COPYBIT(result,i+20,w,24-i);
		COPYBIT(result,i+25,w,29-i);
		COPYBIT(result,i+30,w,34-i);
		COPYBIT(result,i+35,w,39-i);
		COPYBIT(result,i+40,w,4-i);
		COPYBIT(result,i+45,w,9-i);
		COPYBIT(result,i+50,w,14-i);
		COPYBIT(result,i+55,w,19-i);
	}
	return result;
}
*/

// erstellt Teil 7
void entferne_symmetrien() {
	delete [] final[7];
	final[7] = new WUERFEL[12];
	anzahl[7] = 12;
	final[7][0] = BIT01 | BIT05 | BIT06 | BIT07 | BIT11;
	final[7][1] = final[7][0] << 20;
	final[7][2] = final[7][1] << 20;
	final[7][3] = final[7][0] << 1;
	final[7][4] = final[7][3] << 20;
	final[7][5] = BIT05 | BIT20 | BIT25 | BIT30 | BIT45;
	final[7][6] = final[7][5] << 1;
	final[7][7] = final[7][6] << 1;
	final[7][8] = BIT01 | BIT20 | BIT21 | BIT22 | BIT41;
	final[7][9] = final[7][8] << 5;
	final[7][10] = final[7][8] << 1;
	final[7][11] = final[7][10] << 5;

}

void init_teile() {
	// Teil 0:
	// ##
	// #
	// ##
	teile[0] = BIT00 | BIT01 | BIT05 | BIT10 | BIT11;

	// Teil 1:
	//  ##
	// ##
	//  #
	teile[1] = BIT01 | BIT05 | BIT06 | BIT11 | BIT12;

	// Teil 2:
	//  # #
	// ####
	teile[2] = BIT00 | BIT01 | BIT02 | BIT03 | BIT06 | BIT08;

	
	// Teil 3:
	// #
	// ###
	// #
	teile[3] = BIT00 | BIT05 | BIT06 | BIT07 | BIT10;

	// Teil 4:
	//  ##
	//  #
	// ##
	teile[4] = BIT00 | BIT01 | BIT06 | BIT11 | BIT12;

	// Teil 5:
	// ##
	// ###
	teile[5] = BIT00 | BIT01 | BIT02 | BIT05 | BIT06;

	// Teil 6:
	// ##     
	// +#       Links unten in der unteren und mittleren Ebene
	teile[6] = BIT00 | BIT01 | BIT05 | BIT06 | BIT20;

	// Teil 7:
	//  #
	// ###
	//  #
	teile[7] = BIT01 | BIT05 | BIT06 | BIT07 | BIT11;

	// Teil 8:
	// #	   Links unten in der unteren und mittleren Ebene
	// +*      rechts unten in der mittleren Ebene
	teile[8] = BIT00 | BIT05 | BIT20 | BIT21;

	// Teil 9:
	// #
	// ####
	teile[9] = BIT00 | BIT01 | BIT02 | BIT03 | BIT05;

	//Teil 10:
	//  ##
	// ##
	// #
	teile[10] = BIT00 | BIT05 | BIT06 | BIT11 | BIT12;

	// Teil 11:
	//  #
	// ####
	teile[11] = BIT00 | BIT01 | BIT02 | BIT03 | BIT06;

	// Teil 12: = Teil 2
	//  # #
	// ####
	teile[12] = teile[2];
	// Rotation

	// Ausser Teile 2, 9 und 11 sind alle Teile komplett im Sub-Wuerfel 
	// links unten (3,3,3).
	// Diese werden jetzt erstmal alle gedreht...


	for (int i = 0; i < 13; i++) {
		for (int j = 0; j < 64; j++) {
			rotationen[i][j] = 0;
		}
	}

	int num = 0;
	for (int a3 = 0; a3 <= 3; a3++) {
		for (int a4 = 0; a4 <=3; a4++) {
			for (int a5 = 0; a5 <= 3; a5++) {
				rotationen[0][num] = dreh_sub333wuerfel(teile[0],a3,a4,a5);
				rotationen[1][num] = dreh_sub333wuerfel(teile[1],a3,a4,a5);
				rotationen[3][num] = dreh_sub333wuerfel(teile[3],a3,a4,a5);
				rotationen[4][num] = dreh_sub333wuerfel(teile[4],a3,a4,a5);
				rotationen[5][num] = dreh_sub333wuerfel(teile[5],a3,a4,a5);
				rotationen[6][num] = dreh_sub333wuerfel(teile[6],a3,a4,a5);
//				rotationen[7][num] = dreh_sub333wuerfel(teile[7],a3,a4,a5);
				rotationen[8][num] = dreh_sub333wuerfel(teile[8],a3,a4,a5);
				rotationen[10][num] = dreh_sub333wuerfel(teile[10],a3,a4,a5);
				num++;
			}
		}
	}
	// Nun die Teile 9 und 11
	num = 0;
	for (int a4 = 0; a4 <= 3; a4+=2) {
		for (int a5 = 0; a5 <=3; a5++) {
			for (int a3 = 0; a3 <= 3; a3++) {
			  rotationen[2][num] = dreh_sub442wuerfel(teile[2],a3,a4,a5);
				rotationen[9][num] = dreh_sub442wuerfel(teile[9],a3,a4,a5);
				rotationen[11][num] = dreh_sub442wuerfel(teile[11],a3,a4,a5);
				num++;
			}
		}
	}
	// Nun Teil 12 so drehen, dass die restlichen Symmetrien ausgeschaltet sind!


	rotationen[12][0] = BIT00 | BIT01 | BIT02 | BIT03 | BIT06 | BIT08;
	rotationen[12][1] = BIT00 | BIT01 | BIT02 | BIT03 | BIT21 | BIT23;
	rotationen[12][2] = BIT00 | BIT01 | BIT02 | BIT03 | BIT20 | BIT22;
	rotationen[12][3] = BIT01 | BIT06 | BIT11 | BIT16 | BIT05 | BIT15;
	rotationen[12][4] = BIT00 | BIT05 | BIT10 | BIT15 | BIT25 | BIT35;
	rotationen[12][5] = BIT00 | BIT05 | BIT10 | BIT15 | BIT20 | BIT30;
	rotationen[12][6] = BIT01 | BIT06 | BIT11 | BIT16 | BIT00 | BIT10;
	rotationen[12][7] = BIT01 | BIT03 | BIT05 | BIT06 | BIT07 | BIT08;

	entferne_doppelte();

	erstelle_final();

	entferne_symmetrien();
}




WUERFEL ***sortiert;  // [Teilnr][erstes belegtes Bit][nummer] = wuerfel

WUERFEL **sortiert0;
WUERFEL **sortiert1;
WUERFEL **sortiert2;
WUERFEL **sortiert3;
WUERFEL **sortiert4;
WUERFEL **sortiert5;
WUERFEL **sortiert6;
WUERFEL **sortiert7;
WUERFEL **sortiert8;
WUERFEL **sortiert9;
WUERFEL **sortiert10;
WUERFEL **sortiert11;
WUERFEL **sortiert12;


// sortiert die fertigen Teile vor
void einsortieren() {
	sortiert = new WUERFEL** [13];
	for (int i = 0; i < 13; i++) 
		sortiert[i] = new WUERFEL* [60];

	for (int teil = 0; teil < 13; teil++) {
		int count[60];
		for (int bit = 0; bit < 60; bit++) {
			count[bit] = 0;
			WUERFEL bitfield = ((WUERFEL) 1) << bit;
			for (int i = 0; i < anzahl[teil]; i++) {
				if ((final[teil][i] & ((bitfield<<1)-1) ) == bitfield)	
					count[bit]++;
			}
			sortiert[teil][bit] = new WUERFEL[count[bit]+1];	
			int num = 0;
			for (int i = 0; i < anzahl[teil]; i++) {
				if ((final[teil][i] & ((bitfield<<1)-1) ) == bitfield)	
					sortiert[teil][bit][num++] = final[teil][i];
			}
			sortiert[teil][bit][num] = UNGUELTIG;

		}
	}
	sortiert0 = sortiert[0];
	sortiert1 = sortiert[1];
	sortiert2 = sortiert[2];
	sortiert3 = sortiert[3];
	sortiert4 = sortiert[4];
	sortiert5 = sortiert[5];
	sortiert6 = sortiert[6];
	sortiert7 = sortiert[7];
	sortiert8 = sortiert[8];
	sortiert9 = sortiert[9];
	sortiert10 = sortiert[10];
	sortiert11 = sortiert[11];
	sortiert12 = sortiert[12];
}

// Bitanordnung: 
// 0  1  2  3
// 4  10 11 9
// 5  6  7  8   ... und das dann fnf mal nebeneinander

void aendereGeometrie345() {
	for (int teil = 0; teil < 13; teil++) {
		for (int i = 0; i < anzahl[teil]; i++) {
			WUERFEL temp = 0;
			COPYBIT(temp,0,final[teil][i],0);
			COPYBIT(temp,1,final[teil][i],20);
			COPYBIT(temp,2,final[teil][i],40);
			COPYBIT(temp,3,final[teil][i],45);
			COPYBIT(temp,4,final[teil][i],50);
			COPYBIT(temp,5,final[teil][i],55);
			COPYBIT(temp,6,final[teil][i],35);
			COPYBIT(temp,7,final[teil][i],15);
			COPYBIT(temp,8,final[teil][i],10);
			COPYBIT(temp,9,final[teil][i],5);
			COPYBIT(temp,10,final[teil][i],25);
			COPYBIT(temp,11,final[teil][i],30);
			COPYBIT(temp,12,final[teil][i],1);
			COPYBIT(temp,13,final[teil][i],21);
			COPYBIT(temp,14,final[teil][i],41);
			COPYBIT(temp,15,final[teil][i],46);
			COPYBIT(temp,16,final[teil][i],51);
			COPYBIT(temp,17,final[teil][i],56);
			COPYBIT(temp,18,final[teil][i],36);
			COPYBIT(temp,19,final[teil][i],16);
			COPYBIT(temp,20,final[teil][i],11);
			COPYBIT(temp,21,final[teil][i],6);
			COPYBIT(temp,22,final[teil][i],26);
			COPYBIT(temp,23,final[teil][i],31);
			COPYBIT(temp,24,final[teil][i],2);
			COPYBIT(temp,25,final[teil][i],22);
			COPYBIT(temp,26,final[teil][i],42);
			COPYBIT(temp,27,final[teil][i],47);
			COPYBIT(temp,28,final[teil][i],52);
			COPYBIT(temp,29,final[teil][i],57);
			COPYBIT(temp,30,final[teil][i],37);
			COPYBIT(temp,31,final[teil][i],17);
			COPYBIT(temp,32,final[teil][i],12);
			COPYBIT(temp,33,final[teil][i],7);
			COPYBIT(temp,34,final[teil][i],27);
			COPYBIT(temp,35,final[teil][i],32);
			COPYBIT(temp,36,final[teil][i],3);
			COPYBIT(temp,37,final[teil][i],23);
			COPYBIT(temp,38,final[teil][i],43);
			COPYBIT(temp,39,final[teil][i],48);
			COPYBIT(temp,40,final[teil][i],53);
			COPYBIT(temp,41,final[teil][i],58);
			COPYBIT(temp,42,final[teil][i],38);
			COPYBIT(temp,43,final[teil][i],18);
			COPYBIT(temp,44,final[teil][i],13);
			COPYBIT(temp,45,final[teil][i],8);
			COPYBIT(temp,46,final[teil][i],28);
			COPYBIT(temp,47,final[teil][i],33);
			COPYBIT(temp,48,final[teil][i],4);
			COPYBIT(temp,49,final[teil][i],24);
			COPYBIT(temp,50,final[teil][i],44);
			COPYBIT(temp,51,final[teil][i],49);
			COPYBIT(temp,52,final[teil][i],54);
			COPYBIT(temp,53,final[teil][i],59);
			COPYBIT(temp,54,final[teil][i],39);
			COPYBIT(temp,55,final[teil][i],19);
			COPYBIT(temp,56,final[teil][i],14);
			COPYBIT(temp,57,final[teil][i],9);
			COPYBIT(temp,58,final[teil][i],29);
			COPYBIT(temp,59,final[teil][i],34);
			final[teil][i] = temp;	
		}
	}
}



// unsigned __int64 zaehler = 0;


// Es folgen die zwei eigentlichen Tiefensuchen, eine ("..Up") bercksichtigt nur noch
// die oberen Bits

void __fastcall doLoopSortedAsm(/*register */WUERFEL current, short freiesBitNr, short offen);

void __fastcall doLoopSortedAsmUp(short freiesBitNr,short offen, unsigned int current) {

// zaehler++;		
		__asm{ 
/*lStartA:*/
			movsx	eax, WORD PTR offen  	// if ((offen & 1)!=0) {
			test	eax, 1
			jz		lStartB

			movsx	eax, WORD PTR freiesBitNr	// sortiert = sortiert0[freiesBitNr];
			mov		ecx, DWORD PTR sortiert0
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax							// sortiert auf den Stack
			xor		ecx, ecx					// i = 0 (in ecx)
lStartForA:
			// for (; (sortiert[i] & UNG_TESTBIT) == 0; )
			// in eax ist schon sortiert
			test	DWORD PTR [eax+8*ecx+4], 1073741824	// UNG_TESTBIT_32
			jnz		lEndeForA

			mov		edx, DWORD PTR current		// if ((current & sortiert[i] == 0)
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfA
			
			push	ecx								// i merken
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx								// neu auf den Stack
lUpperTestA:
			not		edx
			bsf		ecx,edx
			add		ecx,32				// in ecx: freiesBitNrNeu
 
lEndeTestA:
			movzx	edx, WORD PTR offen		//	 short neuOffen = offen ^ currOffen;
			xor		edx, 1 
			jz		lLoesungA				//	if (neuOffen) {
			call	doLoopSortedAsmUp         //     doLoopSortedAsm(neu,freiesBitNrNeu,neuOffen); 			
			pop		ecx
			inc		ecx
			mov		eax, [esp]						// sortiert wieder herstellen
			jmp		lStartForA


lLoesungA:
			mov		eax, DWORD PTR loesungsanzahl	//   else
			inc		eax								//     loesungsanzahl++;
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax								// neu wieder vom stack entfernen
			pop		ecx								// i nach ecx
lEndeIfA:
			inc		ecx
			mov		eax, [esp]						// sortiert wieder herstellen
			jmp		lStartForA
lEndeForA:	//pop		ecx								// sortiert vom Stack nehmen

lStartB:
			movsx	eax, WORD PTR offen  	// if ((offen & 2)!=0) {
			test	eax, 2
			jz		lStartC
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert1
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx			
lStartForB:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForB
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfB
			push	ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestB:
			not		edx
			bsf		ecx,edx
			add		ecx,32 
lEndeTestB:
			movzx	edx, WORD PTR offen
			xor		edx, 2 
			jz		lLoesungB
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForB
lLoesungB:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
	//		pop		eax
			pop		ecx
lEndeIfB:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForB
lEndeForB:	//pop		ecx		

lStartC:
			movsx	eax, WORD PTR offen  	// if ((offen & 4)!=0) {
			test	eax, 4
			jz		lStartD
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert2
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForC:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForC
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfC
			push	ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestC:
			not		edx
			bsf		ecx,edx
			add		ecx,32
lEndeTestC:
			movzx	edx, WORD PTR offen
			xor		edx, 4 
			jz		lLoesungC
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForC
lLoesungC:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
	//		pop		eax
			pop		ecx
lEndeIfC:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForC
lEndeForC:	//pop		ecx	

lStartD:
			movsx	eax, WORD PTR offen  	// if ((offen & 8)!=0) {
			test	eax, 8
			jz		lStartE
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert3
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForD:
			test	DWORD PTR [eax+8*ecx+4], 1073741824
			jnz		lEndeForD
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfD
			push ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestD:
			not		edx
			bsf		ecx,edx
			add		ecx,32
lEndeTestD:
			movzx	edx, WORD PTR offen
			xor		edx, 8 
			jz		lLoesungD
			call	doLoopSortedAsmUp           
			pop ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForD
lLoesungD:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
//			pop		eax
			pop		ecx
lEndeIfD:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForD
lEndeForD:	//pop		ecx								// sortiert vom Stack nehmen

lStartE:
			movsx	eax, WORD PTR offen  	// if ((offen & 16)!=0) {
			test	eax, 16
			jz		lStartF
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert4
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForE:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForE
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfE
			push	ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestE:
			not		edx
			bsf		ecx,edx
			add		ecx,32	
lEndeTestE:
			movzx	edx, WORD PTR offen
			xor		edx, 16 
			jz		lLoesungE
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov	eax, [esp]
			jmp		lStartForE
lLoesungE:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
	//		pop		eax
			pop		ecx
lEndeIfE:
			inc		ecx
			mov	eax, [esp]
			jmp		lStartForE
lEndeForE:	//pop		ecx	

lStartF:
			movsx	eax, WORD PTR offen  	// if ((offen & 32)!=0) {
			test	eax, 32
			jz		lStartG
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert5
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx	
lStartForF:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForF
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfF
			push	ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestF:
			not		edx
			bsf		ecx,edx
			add		ecx,32			
lEndeTestF:
			movzx	edx, WORD PTR offen
			xor		edx, 32 
			jz		lLoesungF
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForF
lLoesungF:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
	//		pop		eax
			pop		ecx
lEndeIfF:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForF
lEndeForF:	//pop		ecx				

lStartG:
			movsx	eax, WORD PTR offen  	// if ((offen & 64)!=0) {
			test	eax, 64
			jz		lStartH
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert6
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForG:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForG
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfG
			push	ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestG:
			not		edx
			bsf		ecx,edx
			add		ecx,32			
lEndeTestG:
			movzx	edx, WORD PTR offen
			xor		edx, 64 
			jz		lLoesungG
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForG
lLoesungG:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
	//		pop		eax
			pop		ecx
lEndeIfG:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForG
lEndeForG:	//pop		ecx

lStartH:
			movsx	eax, WORD PTR offen  	// if ((offen & 256)!=0) {
			test	eax, 256
			jz		lStartI
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert8
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForH:
			test	DWORD PTR [eax+8*ecx+4], 1073741824
			jnz		lEndeForH
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfH
			push	ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestH:
			not		edx
			bsf		ecx,edx
			add		ecx,32
lEndeTestH:
			movzx	edx, WORD PTR offen
			xor		edx, 256 
			jz		lLoesungH
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForH
lLoesungH:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
	//		pop		eax
			pop		eax
			pop		ecx
lEndeIfH:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForH
lEndeForH:	//pop		ecx	

lStartI:
			movsx	eax, WORD PTR offen  	// if ((offen & 512)!=0) {
			test	eax, 512
			jz		lStartJ
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert9
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx	
lStartForI:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForI
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfI
			push	ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestI:
			not		edx
			bsf		ecx,edx
			add		ecx,32		
lEndeTestI:
			movzx	edx, WORD PTR offen
			xor		edx, 512 
			jz		lLoesungI
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForI
lLoesungI:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
	//		pop		eax
			pop		ecx
lEndeIfI:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForI
lEndeForI:	//pop		ecx

lStartJ:
			movsx	eax, WORD PTR offen  	// if ((offen & 512)!=0) {
			test	eax, 1024
			jz		lStartK
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert10
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForJ:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForJ
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfJ
			push	ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestJ:
			not		edx
			bsf		ecx,edx
			add		ecx,32	
lEndeTestJ:
			movzx	edx, WORD PTR offen
			xor		edx, 1024 
			jz		lLoesungJ
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForJ
lLoesungJ:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
	//		pop		eax
			pop		ecx
lEndeIfJ:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForJ
lEndeForJ://	pop		ecx	

lStartK:

			movsx	eax, WORD PTR offen  	// if ((offen & 512)!=0) {
			test	eax, 2048
			jz		lStartL
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert11
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForK:
			test	DWORD PTR [eax+8*ecx+4], 1073741824
			jnz		lEndeForK
			mov		edx, DWORD PTR current
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfK
			push	ecx
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
	//		push	ebx
lUpperTestK:
			not		edx
			bsf		ecx,edx
			add		ecx,32	
lEndeTestK:
			movzx	edx, WORD PTR offen
			xor		edx, 2048 
			jz		lLoesungK
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForK
lLoesungK:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
	//		pop		eax
			pop		eax
			pop		ecx
lEndeIfK:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForK
lEndeForK://	pop		ecx	

lStartL:  // ENDE
		}
	
}











/*	Das _fastcall ist hier extrem wichtig, da innerhalb der Funktion
	direkt die Parameter entsprechend bergeben werden.
*/
void __fastcall doLoopSortedAsm(/*register */WUERFEL current, short freiesBitNr, short offen) {
// zaehler++;
//	 WUERFEL* sortiert;

	//	WUERFEL neu;
	//	short freiesBitNrNeu;// = freiesBitNr + 1;
	//	int i = 0;

//int neuoffen;
		
		__asm{
/*lStartA:*/
			movsx	eax, WORD PTR offen  	// if ((offen & 1)!=0) {
			test	eax, 1
			jz		lStartB

			movsx	eax, WORD PTR freiesBitNr	// sortiert = sortiert0[freiesBitNr];
			mov		ecx, DWORD PTR sortiert0
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax							// sortiert auf den Stack
			xor		ecx, ecx					// i = 0 (in ecx)
lStartForA:
			// for (; (sortiert[i] & UNG_TESTBIT) == 0; )
			// in eax ist schon sortiert
			test	DWORD PTR [eax+8*ecx+4], 1073741824	// UNG_TESTBIT_32
			jnz		lEndeForA

			mov		edx, DWORD PTR current+4		// if ((current & sortiert[i] == 0)
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfA
			mov		ebx, DWORD PTR current			
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfA
			
			push	ecx								// i merken
			or		ebx, DWORD PTR [eax+ecx*8]		// neu = current | sortiert[i];
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx								// neu auf den Stack
			push	ebx
			//		while ((neu & freiesBitNeu) != 0) {freiesBitNeu <<= 1;freiesBitNrNeu++;}
			xor		ebx, 0xFFFFFFFF	//	    alle 32 lower bits besetzt?
			jz		lUpperTestA
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen		//	 short neuOffen = offen ^ currOffen;
			xor		edx, 1 
			jz		lLoesungA				//	if (neuOffen) {
			call	doLoopSortedAsm         //     doLoopSortedAsm(neu,freiesBitNrNeu,neuOffen); 			
			pop		ecx
			inc		ecx
			mov		eax, [esp]						// sortiert wieder herstellen
			jmp		lStartForA

lUpperTestA:
			not		edx
			bsf		ecx,edx
			add		ecx,32				// in ecx: freiesBitNrNeu
 
lEndeTestA:
			movzx	edx, WORD PTR offen		//	 short neuOffen = offen ^ currOffen;
			xor		edx, 1 
			jz		lLoesungA				//	if (neuOffen) {
			pop ebx
			call	doLoopSortedAsmUp         //     doLoopSortedAsm(neu,freiesBitNrNeu,neuOffen); 			
			pop		ecx
			inc		ecx
			mov		eax, [esp]						// sortiert wieder herstellen
			jmp		lStartForA


lLoesungA:
			mov		eax, DWORD PTR loesungsanzahl	//   else
			inc		eax								//     loesungsanzahl++;
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax								// neu wieder vom stack entfernen
			pop		eax
			pop		ecx								// i nach ecx
lEndeIfA:
			inc		ecx
			mov		eax, [esp]						// sortiert wieder herstellen
			jmp		lStartForA
lEndeForA://	pop		ecx								// sortiert vom Stack nehmen

lStartB:
			movsx	eax, WORD PTR offen  	// if ((offen & 2)!=0) {
			test	eax, 2
			jz		lStartC
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert1
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx			
lStartForB:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForB
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfB
			mov		ebx, DWORD PTR current	
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfB
			push	ecx
			or		ebx, DWORD PTR [eax+ecx*8]
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx	
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestB
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 2 
			jz		lLoesungB
			call	doLoopSortedAsm           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForB
lUpperTestB:
			not		edx
			bsf		ecx,edx
			add		ecx,32 
lEndeTestB:
			movzx	edx, WORD PTR offen
			xor		edx, 2 
			jz		lLoesungB
pop	ebx		
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForB
lLoesungB:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfB:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForB
lEndeForB://	pop		ecx		

lStartC:
			movsx	eax, WORD PTR offen  	// if ((offen & 4)!=0) {
			test	eax, 4
			jz		lStartD
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert2
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForC:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForC
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfC
			mov		ebx, DWORD PTR current
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfC
			push	ecx
			or		ebx, DWORD PTR [eax+ecx*8]	
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx	
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestC
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 4 
			jz		lLoesungC
			call	doLoopSortedAsm           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForC
lUpperTestC:
			not		edx
			bsf		ecx,edx
			add		ecx,32
lEndeTestC:
			movzx	edx, WORD PTR offen
			xor		edx, 4 
			jz		lLoesungC
pop	ebx		
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForC
lLoesungC:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfC:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForC
lEndeForC://	pop		ecx	

lStartD:
			movsx	eax, WORD PTR offen  	// if ((offen & 8)!=0) {
			test	eax, 8
			jz		lStartE
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert3
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForD:
			test	DWORD PTR [eax+8*ecx+4], 1073741824
			jnz		lEndeForD
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfD
			mov		ebx, DWORD PTR current	
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfD
			push ecx
			or		ebx, DWORD PTR [eax+ecx*8]
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestD
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 8 
			jz		lLoesungD
			call	doLoopSortedAsm           
			pop ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForD
lUpperTestD:
			not		edx
			bsf		ecx,edx
			add		ecx,32
lEndeTestD:
			movzx	edx, WORD PTR offen
			xor		edx, 8 
			jz		lLoesungD
pop	ebx		
			call	doLoopSortedAsmUp           
			pop ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForD
lLoesungD:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfD:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForD
lEndeForD:	//pop		ecx								// sortiert vom Stack nehmen

lStartE:
			movsx	eax, WORD PTR offen  	// if ((offen & 16)!=0) {
			test	eax, 16
			jz		lStartF
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert4
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForE:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForE
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfE
			mov		ebx, DWORD PTR current		
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfE
			push	ecx
			or		ebx, DWORD PTR [eax+ecx*8]
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx	
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestE
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 16 
			jz		lLoesungE
			call	doLoopSortedAsm           
			pop		ecx
			inc		ecx
			mov	eax, [esp]
			jmp		lStartForE
lUpperTestE:
			not		edx
			bsf		ecx,edx
			add		ecx,32	
lEndeTestE:
			movzx	edx, WORD PTR offen
			xor		edx, 16 
			jz		lLoesungE
pop	ebx		
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov	eax, [esp]
			jmp		lStartForE
lLoesungE:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfE:
			inc		ecx
			mov	eax, [esp]
			jmp		lStartForE
lEndeForE:	//pop		ecx	

lStartF:
			movsx	eax, WORD PTR offen  	// if ((offen & 32)!=0) {
			test	eax, 32
			jz		lStartG
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert5
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx	
lStartForF:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForF
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfF
			mov		ebx, DWORD PTR current
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfF
			push	ecx
			or		ebx, DWORD PTR [eax+ecx*8]
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx	
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestF
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 32 
			jz		lLoesungF
			call	doLoopSortedAsm           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForF
lUpperTestF:
			not		edx
			bsf		ecx,edx
			add		ecx,32			
lEndeTestF:
			movzx	edx, WORD PTR offen
			xor		edx, 32 
			jz		lLoesungF
pop	ebx		
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForF
lLoesungF:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfF:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForF
lEndeForF:	//pop		ecx				

lStartG:
			movsx	eax, WORD PTR offen  	// if ((offen & 64)!=0) {
			test	eax, 64
			jz		lStartH
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert6
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForG:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForG
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfG
			mov		ebx, DWORD PTR current
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfG
			push	ecx
			or		ebx, DWORD PTR [eax+ecx*8]
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx	
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestG
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 64 
			jz		lLoesungG
			call	doLoopSortedAsm           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForG
lUpperTestG:
			not		edx
			bsf		ecx,edx
			add		ecx,32			
lEndeTestG:
			movzx	edx, WORD PTR offen
			xor		edx, 64 
			jz		lLoesungG
pop	ebx		
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForG
lLoesungG:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfG:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForG
lEndeForG://	pop		ecx

lStartH:
			movsx	eax, WORD PTR offen  	// if ((offen & 256)!=0) {
			test	eax, 256
			jz		lStartI
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert8
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForH:
			test	DWORD PTR [eax+8*ecx+4], 1073741824
			jnz		lEndeForH
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfH
			mov		ebx, DWORD PTR current
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfH
			push	ecx
			or		ebx, DWORD PTR [eax+ecx*8]
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx	
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestH
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 256 
			jz		lLoesungH
			call	doLoopSortedAsm           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForH
lUpperTestH:
			not		edx
			bsf		ecx,edx
			add		ecx,32
lEndeTestH:
			movzx	edx, WORD PTR offen
			xor		edx, 256 
			jz		lLoesungH
pop	ebx		
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForH
lLoesungH:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfH:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForH
lEndeForH:	//pop		ecx	

lStartI:
			movsx	eax, WORD PTR offen  	// if ((offen & 512)!=0) {
			test	eax, 512
			jz		lStartJ
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert9
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx	
lStartForI:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForI
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfI
			mov		ebx, DWORD PTR current	
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfI
			push	ecx
			or		ebx, DWORD PTR [eax+ecx*8]
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx	
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestI
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 512 
			jz		lLoesungI
			call	doLoopSortedAsm           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForI
lUpperTestI:
			not		edx
			bsf		ecx,edx
			add		ecx,32		
lEndeTestI:
			movzx	edx, WORD PTR offen
			xor		edx, 512 
			jz		lLoesungI
pop	ebx		
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForI
lLoesungI:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfI:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForI
lEndeForI:	//pop		ecx

lStartJ:
			movsx	eax, WORD PTR offen  	// if ((offen & 512)!=0) {
			test	eax, 1024
			jz		lStartK
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert10
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForJ:
			test	DWORD PTR [eax+8*ecx+4], 1073741824	
			jnz		lEndeForJ
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfJ
			mov		ebx, DWORD PTR current
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfJ
			push	ecx
			or		ebx, DWORD PTR [eax+ecx*8]
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx	
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestJ
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 1024 
			jz		lLoesungJ
			call	doLoopSortedAsm           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForJ
lUpperTestJ:
			not		edx
			bsf		ecx,edx
			add		ecx,32	
lEndeTestJ:
			movzx	edx, WORD PTR offen
			xor		edx, 1024 
			jz		lLoesungJ
pop	ebx		
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForJ
lLoesungJ:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfJ:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForJ
lEndeForJ:	//pop		ecx	

lStartK:

			movsx	eax, WORD PTR offen  	// if ((offen & 512)!=0) {
			test	eax, 2048
			jz		lStartL
			movsx	eax, WORD PTR freiesBitNr
			mov		ecx, DWORD PTR sortiert11
			mov		eax, DWORD PTR [ecx+eax*4]
			push	eax
			xor		ecx, ecx
lStartForK:
			test	DWORD PTR [eax+8*ecx+4], 1073741824
			jnz		lEndeForK
			mov		edx, DWORD PTR current+4
			test	edx, DWORD PTR [eax+ecx*8+4]
			jnz		lEndeIfK
			mov		ebx, DWORD PTR current
			test	ebx, DWORD PTR [eax+8*ecx]
			jnz		lEndeIfK
			push	ecx
			or		ebx, DWORD PTR [eax+ecx*8]
			or		edx, DWORD PTR [eax+ecx*8+4]
			push	edx
			push	ebx
		//	not		ebx	
			xor	ebx, 0xFFFFFFFF
			jz		lUpperTestK
			bsf		ecx, ebx
			movzx	edx, WORD PTR offen
			xor		edx, 2048 
			jz		lLoesungK
			call	doLoopSortedAsm           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForK
lUpperTestK:
			not		edx
			bsf		ecx,edx
			add		ecx,32	
lEndeTestK:
			movzx	edx, WORD PTR offen
			xor		edx, 2048 
			jz		lLoesungK
pop	ebx		
			call	doLoopSortedAsmUp           
			pop		ecx
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForK
lLoesungK:
			mov		eax, DWORD PTR loesungsanzahl
			inc		eax
			mov		DWORD PTR loesungsanzahl, eax
			pop		eax
			pop		eax
			pop		ecx
lEndeIfK:
			inc		ecx
			mov		eax, [esp]
			jmp		lStartForK
lEndeForK:	//pop		ecx	

lStartL:  // ENDE
		}
	
}

/*
void zaehleBits(WUERFEL w, int &bits0bis15, int &bits16bis31, int &bits32bis47) {
	bits0bis15 = 0; bits16bis31 = 0; bits32bis47 = 0;
	for (int i = 0; i < 17; i++) {
		if (TESTBIT(w,(i))) bits0bis15++;
		if (TESTBIT(w,(i+17))) bits16bis31++;
		if (TESTBIT(w,(i+34))) bits32bis47++;
	}
}

*/




void findeLoesungen() {
	loesungsanzahl = 0;

	aendereGeometrie345();

	einsortieren();

	// Fr diese Flle von Teil 7 mssen weitere "Rotationsblocker"
	// bercksichtigt werden.
	WUERFEL symmfall1 = final[7][4];
	WUERFEL symmfall2 = final[7][7];
	WUERFEL symmfall3 = final[7][10];
	WUERFEL symmfall4 = final[7][11];
		
	printf("Init beendet: %d sek.\n",time(&endzeit)-startzeit);

	for (int i = 0; i < anzahl[7]; i++) {
		unsigned int loesungalt = loesungsanzahl;
		WUERFEL w = final[7][i];
		short freiesBitNr = 0;
		while ((w & (((WUERFEL) 1)<<freiesBitNr)) != 0) {freiesBitNr++;}
		if ((w == symmfall1) || (w == symmfall2) || (w == symmfall3) || (w == symmfall4)) {
			WUERFEL ** temp = sortiert2;
			sortiert2 = sortiert12;
			doLoopSortedAsm(w,freiesBitNr,(1|2|4|8|16|32|64|/*128|*/256|512|1024|2048));
			sortiert2 = temp;
		}
		else	
	 		doLoopSortedAsm(w,freiesBitNr,(1|2|4|8|16|32|64|/*128|*/256|512|1024|2048));
//		printf("Nummer %d: %d (gesamt: %d). Dauer bisher: %d sek., %d Mio Platzierungen\n",i,(loesungsanzahl-loesungalt),loesungsanzahl,time(&endzeit)-startzeit,(unsigned int) (zaehler/1000000));
		printf("Nummer %d: %d (gesamt: %d). Dauer bisher: %d sek.\n",i,(loesungsanzahl-loesungalt),loesungsanzahl,time(&endzeit)-startzeit);
	}
}



int main()
{
	time(&startzeit);
	
	init_teile();

	printf("Anzahl der Lagemoeglichkeiten der einzelnen Teile\nTeil 7: Einschraenkung wegen Symmetrien\nTeil 12 = Teil 2 ohne Symmetrien\n");
	for (int i = 0;i < 13; i++)
		printf("Teil %d: %d\n",i,anzahl[i]);

	findeLoesungen();

	printf("Anzahl der eigenstaendigen Loesungen: %d\n",loesungsanzahl);
	printf("--- Programm von Eiko Bleicher (Eiko.Bleicher@t-online.de) ---\n");

	time(&endzeit);
	printf("%d Sekunden\n", (int) (endzeit-startzeit) );

//	printf("%d Mio Platzierungen\n",(unsigned int) (zaehler/1000000));
	return 0;
}

