/***************************************************************************
                          solve.cpp  -  description
                             -------------------
    begin                : Fri Mar 28 2003
    copyright            : (C) 2003 by Dominik Raddatz
    email                : dom@wtal.de
 ***************************************************************************/

#include "solve.h"
#include <pthread.h>
#include <stdio.h>

long long allPieces[57*16*16];        // Array with all pieces sorted
int pieceCount[57*16];

pthread_mutex_t fastmutex = PTHREAD_MUTEX_INITIALIZER;
int globalThreadSync=0;                   // Requires Mutex
int numberOfSolutions=0;                  // Requires Mutex

long long andMasks[60];
long long equalsMasks[60];

int solve()
{
  pthread_t myThreadID=1;
  void *nothing;
  pthread_create(&myThreadID, NULL, &solve12, NULL);
  solve12(nothing);
  pthread_join(myThreadID, NULL);
  return numberOfSolutions;
}

void permute(const long long *source, long long *target)
{
  *target=0ull;
  for(int i=0; i<60; ++i)
  {
    *target|=(((*source)>>permutation13[i])&1)<<i;
  }
}

void insert(bool box[3][4][5], int pieceIndex)
{
  long long temp, temp2;
  convert(box, &temp2);
  permute(&temp2, &temp);
  int firstBit=findLowestBit(temp);
  if(pieceIndex==11)++pieceIndex;   // Hack for 16-Positions-Alignment; piece10 and piece 11 need more space than allocated
  allPieces[(firstBit<<8)+(pieceIndex<<4)+pieceCount[(firstBit<<4)+pieceIndex]]=temp;
  ++(*(pieceCount+((firstBit<<4)+pieceIndex)));
}

void insert(const long long &indexMask, const long long &andMask, const long long &equalsMask)
{
  long long temp;
  permute(&indexMask, &temp);
  int index=findLowestBit(temp);
  permute(&andMask, &temp);
  *(andMasks+index)=temp;
  permute(&equalsMask, &temp);
  *(equalsMasks+index)=temp;
}

void convert(bool source[3][4][5], long long *target)
{
  (*target)=0ull;
  for(int z=0; z<5; ++z)
  {
    for(int y=0; y<4; ++y)
    {
      for(int x=0; x<3; ++x)
      {
        (*target)<<=1;
        (*target)|=(long long)(source[x][y][z]);
      }
    }
  }
}

int findLowestBit(long long piece)
{
  int i=0;
  while(testBit(&piece, i)==false) ++i;
  return i;
}

inline bool testBit(const long long *piece, const int position)
{
  return(((*piece)&(1ull<<position))!=0);
}

void initializePC()
{
  for(int i=0; i<57; ++i)
  {
    for(int j=0; j<16; ++j)
    {
      *(pieceCount+((i<<4)+j))=0;
    }
  }
}

void *solve12(void *nothing)   // Here be 2 threads...
{
  int remainingPiecesList[13]={0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 0};  // Element#12 is # of found solutions, 1 and 3 are additional space for 0 and 2
  int localThreadSync=0;
  int i, j;
  int pieceNumber=*remainingPiecesList;
  const int *pC=pieceCount;                 // [0][0]
  const int last=*(remainingPiecesList+11);
  const long long *aP=allPieces;   // [0][0][0]
  const long long *cP=aP;
  int *rpl=remainingPiecesList;
  *rpl=last;
  for(j=0; j<*pC; ++j)
  {
    ++localThreadSync;
    pthread_mutex_lock(&fastmutex);    //mutexStart
    if(localThreadSync>globalThreadSync)
    {
      globalThreadSync=localThreadSync;
      pthread_mutex_unlock(&fastmutex);   //mutexEnd
      solve11(*cP, 0, remainingPiecesList);     // Does only work in first round
      printf("Thread's Solutions: %d\n", remainingPiecesList[12]);
      ++cP;
    }
    else 
    {
      pthread_mutex_unlock(&fastmutex);    //mutexEnd
      ++cP;
    }
  }
  *rpl++=pieceNumber;
  for(i=1; i<12; ++i)             // Leave out piece 0
  {
    aP+=16;
    cP=aP;
    ++pC;
    pieceNumber=*rpl;
    *rpl=last;
    for(j=0; j<*pC; ++j)
    {
      ++localThreadSync;
      pthread_mutex_lock(&fastmutex);    //mutexStart
      if(localThreadSync>globalThreadSync)
      {
        globalThreadSync=localThreadSync;
        pthread_mutex_unlock(&fastmutex);   //mutexEnd
        solve11(*cP, 0, remainingPiecesList);
        printf("Thread's Solutions: %d\n", remainingPiecesList[12]);
        ++cP;
      }
      else
      {
        pthread_mutex_unlock(&fastmutex);    //mutexEnd
        ++cP;
      }
    }
    *(rpl++)=pieceNumber;
  }
  pthread_mutex_lock(&fastmutex);    //mutexStart
  numberOfSolutions+=remainingPiecesList[12];   // += here
  pthread_mutex_unlock(&fastmutex);   //mutexEnd
}

void solve11(const long long puzzle , int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  int pieceNumber=*remainingPiecesList;
  const int lastPiece=*(remainingPiecesList+10);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve10(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<10; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve10(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve10(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
}

void solve10(const long long puzzle , int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  const long long *currentPiece=andMasks+fillPosition;
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int pieceNumber=*remainingPiecesList;
  const int lastPiece=*(remainingPiecesList+9);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve9(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<9; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve9(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve9(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
}

void solve9(const long long puzzle , int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  const long long *currentPiece=andMasks+fillPosition;
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int pieceNumber=*remainingPiecesList;
  const int lastPiece=*(remainingPiecesList+8);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=allPieces+(offsetPart<<4);   // Compute offset for to be selected pieces
  currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve8(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<8; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve8(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve8(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
}

void solve8(const long long puzzle , int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  const long long *currentPiece=andMasks+fillPosition;
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int pieceNumber=*remainingPiecesList;
  const int lastPiece=*(remainingPiecesList+7);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=allPieces+(offsetPart<<4);   // Compute offset for to be selected pieces
  currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve7(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<7; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve7(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve7(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
}

void solve7(const long long puzzle , int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  const long long *currentPiece=andMasks+fillPosition;
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int pieceNumber=*remainingPiecesList;
  const int lastPiece=*(remainingPiecesList+6);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=allPieces+(offsetPart<<4);   // Compute offset for to be selected pieces
  currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve6(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<6; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve6(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve6(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
}

inline void solve6(const long long puzzle , int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int j;
  const long long *currentPiece=andMasks+fillPosition;
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int *p234=remainingPiecesList;
  int pieceNumber=*(p234++);
  const int last=*(p234+4);
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+pieceNumber;                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  currentPiece=aPfP+(pieceNumber<<4);
  *remainingPiecesList=last;    // Replace 1st element
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve5(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *remainingPiecesList=pieceNumber;
  pieceNumber=*p234;
  *p234=last;        // Replace 2nd element
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;              // Replace 3rd element
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pC=pCfP+last;            // set pieceCount to next Piece
  currentPiece=aPfP+(last<<4);         // evtl tunable here
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
}

inline void solve5(const long long puzzle , int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int *p234=remainingPiecesList;
  int pieceNumber=*(p234++);
  const int last=*(p234+3);
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+pieceNumber;                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece=aPfP+(pieceNumber<<4);
  int j;
  *remainingPiecesList=last;    // Replace 1st element
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve4(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *remainingPiecesList=pieceNumber;
  pieceNumber=*p234;
  *p234=last;        // Replace 2nd element
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve4(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;              // Replace 3rd element
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve4(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve4(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pC=pCfP+last;            // set pieceCount to next Piece
  currentPiece=aPfP+(last<<4);         // evtl tunable here
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve4(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
}

inline void solve4(const long long puzzle, int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int *p23_4=remainingPiecesList;
  int pieceNumber_4=*(p23_4++);
  const int last_4=*(p23_4+2);
  const int offsetPart_4=fillPosition<<4;
  const int * const pCfP_4=pieceCount+offsetPart_4;       // Compute offset for pieceCount
  const int *pC_4=pCfP_4+pieceNumber_4;                   // get number of elements there
  const long long * const aPfP_4=(allPieces+(offsetPart_4<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece_4=aPfP_4+(pieceNumber_4<<4);
  int j_4;
  *remainingPiecesList=last_4;    // Replace 1st element
  for(j_4=0; j_4<*pC_4; ++j_4)
  {
    if((puzzle&(*currentPiece_4))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve3(puzzle|(*currentPiece_4), fillPosition, remainingPiecesList);
    }
    ++currentPiece_4;
  }
  *remainingPiecesList=pieceNumber_4;
  pieceNumber_4=*p23_4;
  *p23_4=last_4;        // Replace 2nd element
  pC_4=pCfP_4+pieceNumber_4;            // set pieceCount to next Piece
  currentPiece_4=aPfP_4+(pieceNumber_4<<4);
  for(j_4=0; j_4<*pC_4; ++j_4)
  {
    if((puzzle&(*currentPiece_4))==0ull)
    {
      solve3(puzzle|(*currentPiece_4), fillPosition, remainingPiecesList);
    }
    ++currentPiece_4;
  }
  *p23_4=pieceNumber_4;
  pieceNumber_4=*(++p23_4);
  *p23_4=last_4;              // Replace 3rd element
  pC_4=pCfP_4+pieceNumber_4;            // set pieceCount to next Piece
  currentPiece_4=aPfP_4+(pieceNumber_4<<4);
  for(j_4=0; j_4<*pC_4; ++j_4)
  {
    if((puzzle&(*currentPiece_4))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve3(puzzle|(*currentPiece_4), fillPosition, remainingPiecesList);
    }
    ++currentPiece_4;
  }
  *p23_4=pieceNumber_4;
  pC_4=pCfP_4+last_4;            // set pieceCount to next Piece
  currentPiece_4=aPfP_4+(last_4<<4);         // evtl tunable here
  for(j_4=0; j_4<*pC_4; ++j_4)
  {
    if((puzzle&(*currentPiece_4))==0ull)
    {
      solve3(puzzle|(*currentPiece_4), fillPosition, remainingPiecesList);
    }
    ++currentPiece_4;
  }
}

inline void solve3(const long long puzzle , int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int *p2=remainingPiecesList;
  int pieceNumber=*(p2++);
  const int last=*(p2+1);
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+pieceNumber;                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece=aPfP+(pieceNumber<<4);
  int j;
  *remainingPiecesList=last;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve2(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *remainingPiecesList=pieceNumber;
  pieceNumber=*p2;
  *p2=last;
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve2(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *p2=pieceNumber;
  pC=pCfP+last;            // set pieceCount to next Piece
  currentPiece=aPfP+(last<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve2(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
}

inline void solve2(const long long puzzle , int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int j;
  const int pieceNumber=*remainingPiecesList;
  const int last=*(remainingPiecesList+1);
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+pieceNumber;                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece=aPfP+((pieceNumber)<<4);
  *remainingPiecesList=last;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve1(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
  *remainingPiecesList=pieceNumber;
  pC=pCfP+last;
  currentPiece=aPfP+(last<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve1(puzzle|(*currentPiece), fillPosition, remainingPiecesList);
    }
    ++currentPiece;
  }
}

inline void solve1(const long long puzzle, int fillPosition, int remainingPiecesList[13])
{
  while(((1ull<<(++fillPosition))&puzzle)!=0);
  const int offsetPart=(fillPosition<<4)+(*remainingPiecesList);
  const int pC=*(pieceCount+offsetPart);       // Compute offset for pieceCount
  const long long *currentPiece=allPieces+(offsetPart<<4);
  for(int j=0; j<pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      ++(*(remainingPiecesList+12));
      return;
    }
    ++currentPiece;
  }
}
