/* ct_puzzle_select.c
 by Arnold W., Frth, anno Domini 2003
 bcc32 -WE
*/

#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <dir.h>
#include <sys/stat.h>
#include <io.h>

typedef int GrInt;
#include "ct_puzzle_common.c"
#include "icontools.c"
HICON IconGross = NULL, IconKlein = NULL;

#define ThisClassName "arnold's ct-Puzzle-select"
#define ThisTitleBar  "Arnold's c't-Puzzle-Ergebnis-Viewing-Tool(s)"

#define ERGEBNIS  "ct_puzzle_erg.bin"
#define DEFAULT_VIEWING_CMD "neut2slp -d"
#define BERECHNUNGSPROGRAMM "ct_puzzle_erg"

#define MN_START_SUCHE   200
#define MN_DIMETSCALE    201
#define MN_DIMET_S1      202
#define MN_DIMET_S2      203
#define MN_DIMET_S3      204
#define MN_PARTS         205
#define MN_MIRROR_1      206
#define MN_MIRROR_2      207
#define MN_MIRROR_9      208
#define MN_FILTER        209
#define MN_FILTER_CLEAR  210
#define MN_FILTER_A_B    211
#define MN_FILTER_A_C    212
#define MN_FILTER_A_D    213
#define MN_INFO          290
HMENU DimetrieMenu = NULL, SpiegelMenu = NULL;
#define CMD_FILTER       300
#define CMD_FB           316 /* letzter Wert!!! */
#define CMD_FILTERINFO   301
#define CMD_VWR_NAME     302
#define CMD_VWR_STRT     303
#define CMD_SOL_EDIT     304
#define CMD_SOL_NEXT     305
#define CMD_SOL_PREV     306
#define CMD_ALTSUCHE     307
#define CMD_SUCHE        308
#define CMD_SCROLL       309
#define CMD_ADDITEM      310
#define CMD_ADDITEMSTRT  311
#define CMD_SEARCHEND    312
#define CMD_STATISTIK    313
#define CMD_SEARCHPRED   314
#define CMD_SEARCHSUCC   315

#define PictWidth1 60
HINSTANCE hThisInstance;
HWND hwndApplication;
int cxChar, cyChar, cxScreen, cyScreen;
int Grenze1, Grenze2, BH1, EH1, MH1, EW1, EWB1, EHD, SBx, PMx, LSx, SSx, SSy, SSl, SSp = 0, TXy;
int DI1_cx, DI1_cy, DI2_cx, DI2_cy, DI_scale = 1;
int Filter_an = 0, SucheAlle = 0, BitteSuchen = 0;
RECT Bereich1, Bereich2, Bereich3;
HWND Filter, FilterInfo;
HWND Vorgaben[BAUSTEINZAHL][3];
HWND Viewer_Start, Viewer_Cmd, Viewer_Title;
HWND Loesung_Title, Loesung_Nr, Loesung_plus, Loesung_minus;
HWND SucheAlt, SucheStart, SucheScroll, SucheStat, SuchePred, SucheSucc;
HBRUSH HintergrundLeiste = NULL;
int Vorgabenwerte[BAUSTEINZAHL][3][4];
int VorgabeAktivBS = -1, VorgabeAktivSp = -1;
int MarkierterBS = -1;

int SearchThread_halt = 0, SearchThread_halted = 1, SearchThread_start = 0, SearchThread_started = 0,
    SearchThread_Suspend = 0;
HANDLE SearchThread = NULL;
DWORD SearchThreadId;
FILE *SearchThreadDat = NULL;

unsigned long Loesung = 0; int Loesungslage = -1;
int Mirror1 = 0, Mirror2 = 0, Mirror9 = 0;
FILE *Loesungsdatei = NULL;
unsigned short Loesungssatz[12];
int LoesungssatzGueltig = 0;
// MATRIX Loesungstransformationen[12];
int SuchErgebnisse = 0;
int SuchBlockSeite = 0;
int ChoosenResult = -1;
int ScrollOffset = 0;
#define SuchBlockSize 1000
struct SUCHBLOCK {
  int in_diesem_block;
  struct SUCHBLOCK *next, *prev;
  unsigned long Ergebnis[SuchBlockSize];
} *StartSuchBlock = NULL, *AktiverSuchBlock = NULL, *LetzterSuchBlock = NULL;

char *ErgebnisString(int EintragNummer)
{ int block, index;
  static char ErgString[40];
  block = EintragNummer / SuchBlockSize;
  index = EintragNummer % SuchBlockSize;
  ErgString[0] = '\0';
  if (StartSuchBlock == NULL) return ErgString;
  if (block == 0) {
    AktiverSuchBlock = StartSuchBlock; SuchBlockSeite = 0;
  } else
  if (block != SuchBlockSeite) {
    if (block > SuchBlockSeite) {
      while ((block != SuchBlockSeite) && (AktiverSuchBlock->next != NULL)) {
        AktiverSuchBlock = AktiverSuchBlock->next; SuchBlockSeite++;
      }
    } else { /* block < SuchBlcokSeite */
      while ((block != SuchBlockSeite) && (AktiverSuchBlock->prev != NULL)) {
        AktiverSuchBlock = AktiverSuchBlock->prev; SuchBlockSeite--;
      }
    }
  }
  if (AktiverSuchBlock->in_diesem_block > index) {
    if ((AktiverSuchBlock->Ergebnis[index] >> 28) & 4)
      sprintf(ErgString, "%lu", AktiverSuchBlock->Ergebnis[index] & 0x0fffffffL);
     else
      sprintf(ErgString, "%lu%c", AktiverSuchBlock->Ergebnis[index] & 0x0fffffffL,
         'a' + (((AktiverSuchBlock->Ergebnis[index]) >> 28) & 3));
  }
  return ErgString;
}

void PredSuccEnable(void)
{ EnableWindow(SuchePred, SuchErgebnisse ? TRUE : FALSE);
  EnableWindow(SucheSucc, SuchErgebnisse ? TRUE : FALSE);
}

void ClearErgebnis(void)
{ struct SUCHBLOCK *sb;
  SuchErgebnisse = SuchBlockSeite = SSp = 0;
  PredSuccEnable();
  AktiverSuchBlock = LetzterSuchBlock = StartSuchBlock;
  for (sb = StartSuchBlock; sb != NULL; sb = sb->next) sb->in_diesem_block = 0;
  ChoosenResult = -1;
  SetWindowText(SucheStat, "");
}

void AddErgebnis(unsigned long Nummer, int Lage)
{ unsigned long Schreibwert;
  struct SUCHBLOCK *Satz, *neu;
  char Zwischenstatistik[50];
  Schreibwert = Nummer | (Lage << 28);
  if (StartSuchBlock == NULL) {
    if((Satz = malloc(sizeof(struct SUCHBLOCK))) == NULL) return;
    Satz->next = NULL; Satz->prev = NULL; Satz->in_diesem_block = 0;
    StartSuchBlock = Satz;
    AktiverSuchBlock = Satz;
    LetzterSuchBlock = Satz;
    SuchBlockSeite = 0;
  }
  Satz = LetzterSuchBlock;
  while (Satz->in_diesem_block >= SuchBlockSize) {
    if (Satz->next == NULL) {
      if ((neu = malloc(sizeof(struct SUCHBLOCK))) == NULL) return;
      neu->prev = Satz; neu->next = NULL; neu->in_diesem_block = 0;
      LetzterSuchBlock = neu;
      Satz->next = neu;
      Satz = neu;
    } else Satz = Satz->next;
  }
  Satz->Ergebnis[Satz->in_diesem_block] = Schreibwert;
  (Satz->in_diesem_block)++;
  SuchErgebnisse++;
  PredSuccEnable();
  sprintf(Zwischenstatistik, "%u/%lu", SuchErgebnisse, Nummer & 0x0fffffffL);
  SetWindowText(SucheStat, Zwischenstatistik);
}

void StartLoesungsBerechnung(int start_von_winmain)
{ int ok;
  STARTUPINFO si;
  static PROCESS_INFORMATION pi;
  static calculation_started = 0;
  DWORD ec;
  if (!start_von_winmain) {
    if (!access(ERGEBNIS, 4)) {
      if (MessageBox(hwndApplication,
        "Sie wollen die Lsungstabelle neu berechnen lassen, obwohl die Datei \""
	ERGEBNIS "\" bereits vorhanden ist?\n"
	"Da diese Berechnung einige Stunden dauern kann (gemessen auf meinem Testrechner),"
	" berlegen Sie es sich gut, ob sie dies jetzt tun wollen, denn Sie sollten den"
	" Berechnungslauf nicht vorzeitig abbrechen.\n"
	"\nWollen Sie nun die Lsungstabelle neu berechnen?",
        "c't-Puzzle-Lsungstabelle berechnen", MB_ICONQUESTION | MB_OKCANCEL | MB_DEFBUTTON2) == IDCANCEL)
	return;
    }
  }
  do {
    ok = 1;
    /* Luft Suche ? */
    if (!SearchThread_halted || (SearchThreadDat != NULL)) {
      if (MessageBox(hwndApplication, "Um die Lsungsssuche starten zu knnen,"
        " mu die Filtersuche erst abgeschlossen sein!",
	"Lsungssuche starten ...", MB_ICONEXCLAMATION | MB_RETRYCANCEL) == IDCANCEL) return;
      ok = 0;
    }
    /* Schon gestartet und noch nicht beendet? */
    if (calculation_started) {
      if (GetExitCodeProcess(pi.hProcess, &ec)) {
        if (ec != STILL_ACTIVE) calculation_started = 0;
      }
    }
    if (calculation_started) {
      if (MessageBox(hwndApplication, "Es wurde bereits eine Lsungssuche gestartet und diese ist noch"
        "nicht beendet.\n", "Lsungssuche starten ...",
	MB_ICONEXCLAMATION | MB_RETRYCANCEL | MB_DEFBUTTON2) == IDCANCEL) return;
      ok = 0;
    }
  } while (!ok);
  if (Loesungsdatei != NULL) fclose(Loesungsdatei);
  memset(&si, 0, sizeof(STARTUPINFO)); si.cb = sizeof(STARTUPINFO);
  if (CreateProcess(NULL, BERECHNUNGSPROGRAMM, NULL, NULL, FALSE, CREATE_NEW_CONSOLE | NORMAL_PRIORITY_CLASS,
                NULL, NULL, &si, &pi)) {
    calculation_started = 1;
    MessageBox(hwndApplication, "Die Berechnung der Lsungstabelle wurde gestartet. "
      "Dies kann einige Zeit dauern, bitte haben Sie deshalb jetzt etwas Geduld:\n"
      "Auf meinem Testrechner bentigte dieser Rechenlauf\n"
      "\n ca. 3\xbd Stunden Rechenzeit.\n\n[in Worten: sieben mal dreiig Minuten]",
      "Berechnung gestartet", MB_ICONINFORMATION | MB_OK | MB_SYSTEMMODAL);
  } else {
    MessageBox(hwndApplication, "Das Berechnungsprogramm \"" BERECHNUNGSPROGRAMM "\" konnte nicht gestartet"
      " werden!", "Fehler beim Starten der Lsungssuche", MB_ICONEXCLAMATION | MB_OK | MB_SYSTEMMODAL);
  }
}

int SuchtGerade(void)
{ char Z[20];
  GetWindowText(SucheStart, Z, 20);
  Z[19] = '\0';
  if (!strcmp(Z, "Suche ...")) return 1;
  return 0;
}

void AdjustScrollbarSize(void)
{ SCROLLINFO si;
  si.cbSize = sizeof(si);
  si.fMask = SIF_PAGE | SIF_RANGE | SIF_POS;
  si.nPos = ScrollOffset;
  si.nPage = SSl; si.nMin = 0; si.nMax = SuchErgebnisse - 1;
  SetScrollInfo(SucheScroll, SB_CTL, &si, TRUE);
}

int BausteinNummer(unsigned short InsertID)
{ return(((InsertID >> 12) & 15) - 1); }

MATRIX Orientierung(unsigned short InsertID)
{ MATRIX erg;
  int xdir, ydir;
  memset(&erg, 0, sizeof(MATRIX));
  /* Richtung X-Achse des Bausteinkoordinatensystems */
  xdir = (InsertID >> 10) & 3;
  erg.MATRIX[xdir] = ((InsertID >> 9) & 1) ? -1 : 1;
  /* Richtung Y-Achse des Bausteinkoordinatensystems */
  ydir = (xdir + 1 + ((InsertID >> 8) & 1)) % 3 + 3;
  erg.MATRIX[ydir] = ((InsertID >> 7) & 1) ? -1 : 1;
  /* Kreuzprodukt fr Z-Achse */
  erg.MATRIX[8] = erg.MATRIX[0] * erg.MATRIX[4] - erg.MATRIX[1] * erg.MATRIX[3];
  erg.MATRIX[6] = erg.MATRIX[1] * erg.MATRIX[5] - erg.MATRIX[2] * erg.MATRIX[4];
  erg.MATRIX[7] = erg.MATRIX[2] * erg.MATRIX[3] - erg.MATRIX[0] * erg.MATRIX[5];
  /* Ursprung */
  erg.MATRIX[ 9] = (InsertID >>  4) & 7;
  erg.MATRIX[10] = (InsertID >> 2) & 3;
  erg.MATRIX[11] =  InsertID & 3;
  /* Ergebnisrckgabe */
  return erg;
}

#include "ct_puzzle_gdata.c"


void ViewerStartLoesung(void)
{ int ct, bs, a, i;
  MATRIX m;
  STARTUPINFO si;
  PROCESS_INFORMATION pi;
  FILE *posdat;
  char PosDat[MAX_PATH];
  char Programm[2 * MAXPATH];
  if (!LoesungssatzGueltig) return;
  a = Loesungslage; if (a < 0) a = 0;
  mkdir("loesungen");
  sprintf(PosDat, "loesungen\\ct_puzzle_%.6lu%c.pos", Loesung, 'a' + a);
  if ((posdat = fopen(PosDat, "w")) == NULL) {
    char M[MAX_PATH + 70];
    sprintf(M, "Datei '%s' konnte nicht angelegt werden!", PosDat);
    MessageBox(NULL, M, "Datenbergabe fehlgeschlagen", MB_ICONEXCLAMATION | MB_OK);
    return;
  }
  for (ct = 0; ct < BAUSTEINZAHL; ct++) {
    bs = BausteinNummer(Loesungssatz[ct]);
    if ((bs >= 0) && (bs < BAUSTEINZAHL)) {
      if ((bs == 0) && Mirror1) {
        m = MatMul(Hinlegen[a], MatMul(Orientierung(Loesungssatz[ct]), INV1));
      } else
      if ((bs == 1) && Mirror2) {
        m = MatMul(Hinlegen[a], MatMul(Orientierung(Loesungssatz[ct]), INV2));
      } else
      if ((bs == 8) && Mirror9) {
        m = MatMul(Hinlegen[a], MatMul(Orientierung(Loesungssatz[ct]), INV9));
      } else
        m = MatMul(Hinlegen[a], Orientierung(Loesungssatz[ct]));
      fprintf(posdat, "%2d  ", bs + 1);
      for (i = 0; i < 12; i++) fprintf(posdat, " %2d", m.MATRIX[i]);
      fprintf(posdat, "\n");
    }
  }
  fclose(posdat);
  GetWindowText(Viewer_Cmd, Programm, MAX_PATH);
  Programm[MAX_PATH - 1] = '\0';
  strcat(Programm, " ");
  strcat(Programm, PosDat);
  // system(Programm);
  memset(&si, 0, sizeof(STARTUPINFO)); si.cb = sizeof(STARTUPINFO);
  CreateProcess(NULL, Programm, NULL, NULL, FALSE, CREATE_NEW_CONSOLE | NORMAL_PRIORITY_CLASS,
                NULL, NULL, &si, &pi);
}

void CheckCheckbox(HWND hwnd, int set_it)
{ SendMessage(hwnd, BM_SETCHECK, set_it ? BST_CHECKED : BST_UNCHECKED, 0L); }

void SetSwitches(void)
{ int b, i;
  CheckCheckbox(Filter, Filter_an);
  for (b = 0; b < BAUSTEINZAHL; b++) for (i = 0; i < 3; i++)
    EnableWindow(Vorgaben[b][i], Filter_an ? TRUE : FALSE);
  EnableWindow(SucheAlt, Filter_an ? TRUE : FALSE);
  EnableWindow(SucheStart, Filter_an ? TRUE : FALSE);
  EnableWindow(SucheScroll, Filter_an ? TRUE : FALSE);
  CheckCheckbox(SucheAlt, SucheAlle);
}

void CreateSubwindows(HWND hwnd)
{ int b, i;
  /* 1. Sektion */
  Filter = CreateWindow("button", "Lsungen filtern",
    WS_CHILD | WS_VISIBLE | BS_CHECKBOX | WS_BORDER,
    0, 0, 0, 0, hwnd, (HMENU) CMD_FILTER, hThisInstance, NULL);
  for (b = 0; b < BAUSTEINZAHL; b++) for (i = 0; i < 3; i++) {
    Vorgaben[b][i] = CreateWindow("edit", "", WS_CHILD | WS_VISIBLE | WS_BORDER,
      0, 0, 0, 0, hwnd, (HMENU) (CMD_FB + 3 * b + i), hThisInstance, NULL);
    Vorgabenwerte[b][i][3] = 0;
  }
  FilterInfo = CreateWindow("static", "",
    WS_CHILD | WS_VISIBLE | SS_LEFT,
    0, 0, 0, 0, hwnd, (HMENU) CMD_FILTERINFO, hThisInstance, NULL);
  /* 2. Sektion */
  SucheAlt = CreateWindow("button", "mit Rotationen",
    WS_CHILD | WS_VISIBLE | BS_CHECKBOX | WS_BORDER,
    0, 0, 0, 0, hwnd, (HMENU) CMD_ALTSUCHE, hThisInstance, NULL);
  SucheStart  = CreateWindow("button", BitteSuchen ? "Suchen!" : "Suchen",
    WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
    0, 0, 0, 0, hwnd, (HMENU) CMD_SUCHE, hThisInstance, NULL);
  SucheScroll  = CreateWindow("scrollbar", NULL,
    WS_CHILD | WS_VISIBLE | SBS_VERT,
    0, 0, 0, 0, hwnd, (HMENU) CMD_SCROLL, hThisInstance, NULL);
  SucheStat = CreateWindow("static", "",
    WS_CHILD | WS_VISIBLE | SS_CENTER,
    0, 0, 0, 0, hwnd, (HMENU) CMD_STATISTIK, hThisInstance, NULL);
  SucheSucc  = CreateWindow("button", "+",
    WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
    0, 0, 0, 0, hwnd, (HMENU) CMD_SEARCHSUCC, hThisInstance, NULL);
  SuchePred  = CreateWindow("button", "-",
    WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
    0, 0, 0, 0, hwnd, (HMENU) CMD_SEARCHPRED, hThisInstance, NULL);
  /* 3. Sektion */
  Viewer_Title = CreateWindow("static", "3D-Viewer:",
    WS_CHILD | WS_VISIBLE | SS_LEFT,
    0, 0, 0, 0, hwnd, (HMENU) 0, hThisInstance, NULL);
  Viewer_Cmd = CreateWindow("edit", DEFAULT_VIEWING_CMD,
    WS_CHILD | WS_VISIBLE | WS_BORDER | ES_AUTOHSCROLL,
    0, 0, 0, 0, hwnd, (HMENU) CMD_VWR_NAME, hThisInstance, NULL);
  Viewer_Start = CreateWindow("button", "START",
    WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
    0, 0, 0, 0, hwnd, (HMENU) CMD_VWR_STRT, hThisInstance, NULL);
  Loesung_Title = CreateWindow("static", "Lsung Nr.:",
    WS_CHILD | WS_VISIBLE | SS_LEFT | WS_BORDER,
    0, 0, 0, 0, hwnd, (HMENU) 0, hThisInstance, NULL);
  Loesung_Nr = CreateWindow("edit", "",
    WS_CHILD | WS_VISIBLE | WS_BORDER | ES_AUTOHSCROLL | ES_LOWERCASE,
    0, 0, 0, 0, hwnd, (HMENU) CMD_SOL_EDIT, hThisInstance, NULL);
  Loesung_plus  = CreateWindow("button", "+",
    WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
    0, 0, 0, 0, hwnd, (HMENU) CMD_SOL_NEXT, hThisInstance, NULL);
  Loesung_minus = CreateWindow("button", "-",
    WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
    0, 0, 0, 0, hwnd, (HMENU) CMD_SOL_PREV, hThisInstance, NULL);
  SetSwitches();
}

void CheckSolutionNumber(int aktion)
{ char Nummer[22], NummerNeu[22];
  int md, p, q, nr, alternative; char c;
  struct stat sb;
  DWORD sel_strt, sel_end;
  GetWindowText(Loesung_Nr, Nummer, 22); Nummer[21] = '\0';
  SendMessage(Loesung_Nr, EM_GETSEL, (WPARAM) (LPDWORD) &sel_strt, (LPARAM) (LPDWORD) &sel_end);
  nr = 0; c = ' ';
  md = 0; NummerNeu[0] = '\0';
  for (p = q = 0; Nummer[p]; p++) {
    switch (md) {
      case 0:
        if ((Nummer[p] >= '0') && (Nummer[p] <= '9')) {
	  NummerNeu[q] = Nummer[p];
	  NummerNeu[++q] = '\0';
	} else if (q) {
	  switch (Nummer[p]) {
	    case 'a': case 'A': NummerNeu[q++] = 'a'; md = 1; break;
	    case 'b': case 'B': NummerNeu[q++] = 'b'; md = 1; break;
	    case 'c': case 'C': NummerNeu[q++] = 'c'; md = 1; break;
	    case 'd': case 'D': NummerNeu[q++] = 'd'; md = 1; break;
	  }
	  NummerNeu[q] = '\0';
	} else {
          if (sel_strt) sel_strt--;
          if (sel_end) sel_end--;
        }
      break;
    }
  }
  NummerNeu[20] = '\0';
  if (sel_strt > strlen(NummerNeu)) sel_strt = strlen(NummerNeu);
  if (sel_end > strlen(NummerNeu)) sel_end = strlen(NummerNeu);
  sscanf(NummerNeu, "%u%c", &nr, &c);
  switch (c) {
    case 'a': case 'A': alternative = 0; break;
    case 'b': case 'B': alternative = 1; break;
    case 'c': case 'C': alternative = 2; break;
    case 'd': case 'D': alternative = 3; break;
    default: alternative = -1;
  }
  if (!aktion) {
    if (!stat(ERGEBNIS, &sb)) {
      if (nr > sb.st_size / 24L) nr = sb.st_size / 24L;
      if (alternative >= 0) sprintf(NummerNeu, "%u%c", nr, 'a' + alternative);
                       else sprintf(NummerNeu, "%u", nr);
      ChoosenResult = -1;
    }
    if (strcmp(Nummer, NummerNeu)) {
      SetWindowText(Loesung_Nr, NummerNeu);
      SendMessage(Loesung_Nr, EM_SETSEL, (WPARAM) (INT) sel_strt, (LPARAM) (INT) sel_end);
    }
  }
  if (aktion) {
    if ((nr > 1) || (aktion > 0)) nr += aktion;
    if (!stat(ERGEBNIS, &sb)) {
      if (nr > sb.st_size / 24L) nr = sb.st_size / 24L;
    }
    if (nr == 0) nr = 1;
    if (alternative >= 0) sprintf(Nummer, "%c", 'a' + alternative); else Nummer[0] = '\0';
    sprintf(NummerNeu, "%u%s", nr, Nummer);
    NummerNeu[20] = '\0';
    SetWindowText(Loesung_Nr, NummerNeu);
    ChoosenResult = -1;
  }
}

void SelectSolutionNumber(HWND hwnd)
{ char Nummer[22];
  int nr, alternative; char c;
  GetWindowText(Loesung_Nr, Nummer, 22); Nummer[21] = '\0';
  nr = 0; c = ' ';
  sscanf(Nummer, "%u%c", &nr, &c);
  switch (c) {
    case 'a': case 'A': alternative = 0; break;
    case 'b': case 'B': alternative = 1; break;
    case 'c': case 'C': alternative = 2; break;
    case 'd': case 'D': alternative = 3; break;
    default: alternative = -1;
  }
  if (nr > 0) {
    Loesung = nr, Loesungslage = alternative;
    if (Loesungsdatei == NULL) {
      if ((Loesungsdatei = fopen(ERGEBNIS, "rb")) == NULL) {
        LoesungssatzGueltig = 0; return;
      }
    }
    fseek(Loesungsdatei, 24L * (Loesung - 1), SEEK_SET);
    fread(Loesungssatz, 24, 1, Loesungsdatei);
    LoesungssatzGueltig = 1;
    InvalidateRect(hwnd, &Bereich3, TRUE);
  } else 
  if (LoesungssatzGueltig) {
    LoesungssatzGueltig = 0;
    InvalidateRect(hwnd, &Bereich3, TRUE);
  }
}

void SetDimetScale(int scale)
{ DI_scale = scale;
  CheckMenuItem(DimetrieMenu, MN_DIMET_S1, MF_BYCOMMAND | ((DI_scale == 1) ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(DimetrieMenu, MN_DIMET_S2, MF_BYCOMMAND | ((DI_scale == 2) ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(DimetrieMenu, MN_DIMET_S3, MF_BYCOMMAND | ((DI_scale == 3) ? MF_CHECKED : MF_UNCHECKED));
  DI1_cx = (cxScreen + Grenze2 + 93 * DI_scale) / 2;
  DI2_cx = (cxScreen + Grenze2 - 93 * DI_scale) / 2;
  DI1_cy = (1 * (cyScreen - 3 * BH1 - 1) - 114 * DI_scale) / 4 + BH1 + 1;
  DI2_cy = (3 * (cyScreen - 3 * BH1 - 1) - 114 * DI_scale) / 4 + BH1 + 1;
}

#pragma argsused
void ChangeSize(HWND hwnd, LPARAM lParam)
{ int b, i;
  HDC hdc;
  TEXTMETRIC tm;
  /* Schriften */
  hdc = GetDC(hwnd); GetTextMetrics(hdc, &tm); ReleaseDC(hwnd, hdc);
  TXy = tm.tmHeight + tm.tmExternalLeading + 2;
  /* allgemein bzw. Bereich 1 */
  EW1 = 6 * cxChar;
  Grenze1 = 3 * EW1 + PictWidth1;
  Grenze2 = Grenze1 + 15 * cxChar;
  Bereich1.top = 0; Bereich1.left = 0; Bereich1.bottom = cyScreen; Bereich1.right = Grenze1;
  Bereich2.top = 0; Bereich2.left = Grenze1; Bereich2.bottom = cyScreen; Bereich2.right = Grenze2;
  Bereich3.top = 0; Bereich3.left = Grenze2; Bereich3.bottom = cyScreen; Bereich3.right = cxScreen;
  BH1 = cyChar + 6;
  EHD = EH1 = (cyScreen - BH1 - 2) / (BAUSTEINZAHL + 2);
  MH1 = cyScreen - BH1 - BAUSTEINZAHL * EH1 - 1;
  EWB1 = BH1 + EH1 / 2 + 1;
  if (EH1 > cyChar + 6) { EH1 = cyChar + 6; }
  /* Bereich 2 */
  SSx = Grenze2 - 2 * cxChar;
  SSy = 2 * BH1 + 1;
  SSl = (cyScreen - SSy - 2 * BH1) / TXy;
  /* Bereich 3 */
  SBx = cxScreen - 7 * cxChar; if (SBx <= Grenze2) SBx = Grenze2 + 1;
  LSx = 9 * cxChar;
  PMx = cxScreen - 2 * cxChar; if (PMx <= Grenze2) { PMx = Grenze2 + 1; LSx = 0; }
  SetDimetScale(DI_scale); /* nur, damit der Ursprung neu berechnet wird */
  /* Bereich 1 */
  MoveWindow(Filter, 1, 1, Grenze1 - 1, BH1, TRUE);
  for (b = 0; b < BAUSTEINZAHL; b++)
   for (i = 0; i < 3; i++)
    MoveWindow(Vorgaben[b][i], Grenze1 - (3 - i) * EW1 + 1, EWB1 - EH1 / 2 + b * EHD , EW1 - 2, EH1 - 2, TRUE);
  MoveWindow(FilterInfo, 0, cyScreen - MH1, Grenze1, MH1, TRUE);
  /* Bereich 2 */
  MoveWindow(SucheAlt,   Grenze1 + 1,       1, Grenze2 - Grenze1 - 1, BH1, TRUE);
  MoveWindow(SucheStart, Grenze1 + 1, BH1 + 1, Grenze2 - Grenze1 - 1, BH1, TRUE);
  MoveWindow(SucheStat,  Grenze1 + 1, cyScreen - BH1, Grenze2 - Grenze1 - 1, BH1, TRUE);
  MoveWindow(SuchePred,  Grenze1 + 1, cyScreen - 2 * BH1, (Grenze2 - Grenze1 - 1) / 2, BH1, TRUE);
  MoveWindow(SucheSucc,  Grenze2 - (Grenze2 - Grenze1 - 1) / 2, cyScreen - 2 * BH1,
                         (Grenze2 - Grenze1 - 1) / 2, BH1, TRUE);
  MoveWindow(SucheScroll, SSx, SSy, 2 * cxChar, cyScreen - SSy - 2 * BH1, TRUE);
  PredSuccEnable();
  /* Bereich 3 */
  MoveWindow(Loesung_plus, PMx, 1, cxScreen - PMx, BH1 / 2, TRUE);
  MoveWindow(Loesung_minus, PMx, BH1 / 2 + 1, cxScreen - PMx, BH1 / 2, TRUE);
  MoveWindow(Loesung_Title, Grenze2 + 1, 1, PMx - Grenze2 - 1, BH1, TRUE);
  MoveWindow(Loesung_Nr, PMx - LSx - 1, 2, LSx, BH1 - 2, TRUE);
  MoveWindow(Viewer_Title, Grenze2 + 1, cyScreen - 2 * BH1, SBx - Grenze2 - 1, BH1, TRUE);
  MoveWindow(Viewer_Cmd, Grenze2 + 1, cyScreen - BH1, SBx - Grenze2 - 1, BH1, TRUE);
  MoveWindow(Viewer_Start, SBx, cyScreen - 2 * BH1, cxScreen - SBx, 2 * BH1, TRUE);
}

void FilterLoeschen(void)
{ int bs, i;
  for (bs = 0; bs < BAUSTEINZAHL; bs++) for (i = 0; i < 3; i++) {
    SetWindowText(Vorgaben[bs][i], "");
    Vorgabenwerte[bs][i][3] = 0;
  }
}

void FilterWenden(int a)
{ KOORD k;
  int bs, i;
  char Position[16];
  for (bs = 0; bs < BAUSTEINZAHL; bs++) for (i = 0; i < 3; i++) if (Vorgabenwerte[bs][i][3]) {
    k = PosTrans3i(Hinlegen[a], Vorgabenwerte[bs][i][0], Vorgabenwerte[bs][i][1], Vorgabenwerte[bs][i][2]);
    Vorgabenwerte[bs][i][0] = k.KOORD[0];
    Vorgabenwerte[bs][i][1] = k.KOORD[1];
    Vorgabenwerte[bs][i][2] = k.KOORD[2];
    sprintf(Position, "%d,%d,%d", k.KOORD[0], k.KOORD[1], k.KOORD[2]);
    SetWindowText(Vorgaben[bs][i], Position);
  }
  BitteSuchen = 1;
  if (!SuchtGerade()) SetWindowText(SucheStart, "Suchen!");
}

#pragma argsused
DWORD WINAPI SearchThreadProc(LPVOID dummy)
{ unsigned short Erg[12];
  unsigned long p;
  int a, ct, bs, i, verwerfen, halten, bed;
  BAUSTEIN BS;
  char Endstatistik[50];
  SearchThreadDat = NULL;
  while (1) {
    if (SearchThread_halt) {
      if (SearchThreadDat != NULL) fclose(SearchThreadDat); SearchThreadDat = NULL;
      if (!SearchThread_halted) {
        SearchThread_halted = 1;
	SendMessage(hwndApplication, WM_COMMAND, CMD_SEARCHEND, 0L);
      }
      SwitchToThread();
      Sleep(350);
    } else {
      if (SearchThread_start) {
        SearchThread_started = 1;
	SearchThread_start = SearchThread_halted = 0;
	SendMessage(hwndApplication, WM_COMMAND, CMD_ADDITEMSTRT, 0L);
	p = 0;
	if ((SearchThreadDat = fopen(ERGEBNIS, "rb")) == NULL) {
	  SearchThread_halt = 1;
	} else {
	  BitteSuchen = 0;
	  SetWindowText(SucheStart, "Suche ...");
	}
      } else {
        if (fread(Erg, 24, 1, SearchThreadDat) > 0) {
	  p++;
          for (a = 0; a < (SucheAlle ? 4 : 1); a++) {
	    halten = 1;
	    for (ct = 0; (ct < BAUSTEINZAHL) && halten; ct++) {
              bs = BausteinNummer(Erg[ct]);
              if ((bs >= 0) && (bs < BAUSTEINZAHL)) {
                BS = BewegterBaustein(Baustein[bs], MatMul(Hinlegen[a], Orientierung(Erg[ct])));
                for (bed = 0; bed < 3; bed++) if (Vorgabenwerte[bs][bed][3]) {
	          verwerfen = 1;
                  for (i = 0; i < BS.Teilwuerfelzahl; i++) {
                    if ((BS.Einzelelemente[i].KOORD[0] == Vorgabenwerte[bs][bed][0])
                     && (BS.Einzelelemente[i].KOORD[1] == Vorgabenwerte[bs][bed][1])
                     && (BS.Einzelelemente[i].KOORD[2] == Vorgabenwerte[bs][bed][2])) verwerfen = 0;
		  }
		  if (verwerfen) halten = 0;
	        }
	      }
	    }
	    if (halten) {
	      SendMessage(hwndApplication, WM_COMMAND, CMD_ADDITEM, p | (SucheAlle ? (a << 28) : 0x40000000L));
	    }
	  }
	} else {
	  fclose(SearchThreadDat); SearchThreadDat = NULL;
	  SearchThread_halt = 1;
	  SetWindowText(SucheStart, BitteSuchen ? "Suchen!" : "Suchen");
          InvalidateRect(hwndApplication, &Bereich2, TRUE);
          sprintf(Endstatistik, "%u/%lu", SuchErgebnisse, p);
          SetWindowText(SucheStat, Endstatistik);
	}
      }
    }
  }
}

void StarteSuche(HWND hwnd)
{ int ct, bs, i;
  ct = 0;
  for (bs = 0; bs < BAUSTEINZAHL; bs++) for (i = 0; i < 3; i++) ct += Vorgabenwerte[bs][i][3];
  if (!ct) {
    MessageBox(hwnd, "Es ist unsinnig eine Filtersuche zu starten, ohne eine Bauteilbeschrnkung"
                     " eingegeben zu haben.\n\n"
		     "Suche nicht gestartet!", "Kein Grund zur Filtersuche", MB_ICONEXCLAMATION | MB_OK);
    return;
  }
  SearchThread_started = 0;
  SearchThread_start = 1;
  SearchThread_halt = 0;
  if (SearchThread == NULL) {
    SearchThread = CreateThread(NULL, 0, SearchThreadProc, NULL, 0, &SearchThreadId);
  }
  do {
    ResumeThread(SearchThread);
    SearchThread_Suspend--;
  } while (SearchThread_Suspend > 0);
  if (SearchThread_Suspend < 0) SearchThread_Suspend = 0;
}

#pragma argsused
void ScrollAction(HWND hwnd, int Notification, int Cmd, LPARAM lParam)
{ SCROLLINFO si;
  switch(Cmd) {
    case SB_LINEUP:
      if (--ScrollOffset < 0) ScrollOffset = 0;
    break;
    case SB_LINEDOWN:
      ScrollOffset++;
      if (ScrollOffset + SSl > SuchErgebnisse) ScrollOffset = SuchErgebnisse - SSl;
      if (ScrollOffset < 0) ScrollOffset = 0;
    break;
    case SB_PAGEUP:
      ScrollOffset -= SSl;
      if (--ScrollOffset < 0) ScrollOffset = 0;
    break;
    case SB_PAGEDOWN:
      ScrollOffset += SSl;
      if (ScrollOffset + SSl > SuchErgebnisse) ScrollOffset = SuchErgebnisse - SSl;
      if (ScrollOffset < 0) ScrollOffset = 0;
    break;
    case SB_THUMBTRACK:
    case SB_THUMBPOSITION:
      si.cbSize = sizeof(si);
      si.fMask = SIF_ALL;
      GetScrollInfo(SucheScroll, SB_CTL, &si);
      ScrollOffset = si.nTrackPos;
      if (ScrollOffset + SSl > SuchErgebnisse) ScrollOffset = SuchErgebnisse - SSl;
      if (ScrollOffset < 0) ScrollOffset = 0;
      if (Cmd == SB_THUMBTRACK) InvalidateRect(hwnd, &Bereich2, TRUE);
    break;
  }
  si.cbSize = sizeof(si);
  si.fMask = SIF_POS;
  si.nPos = ScrollOffset;
  SetScrollInfo(SucheScroll, SB_CTL, &si, TRUE);
  InvalidateRect(hwnd, &Bereich2, TRUE);
}

void NextScrollErg(HWND hwnd, int inc)
{ SCROLLINFO si;
  int neupos;
  if (!SuchErgebnisse) return;
  if (ChoosenResult < 0) {
    if (inc > 0) neupos = 0; else neupos = SuchErgebnisse - 1;
  } else {
    if (ChoosenResult + inc >= SuchErgebnisse) return;
    if (ChoosenResult + inc < 0) return;
    neupos = ChoosenResult + inc;
  }
  if (ScrollOffset > neupos) {
    ScrollOffset = neupos;
    si.cbSize = sizeof(si);
    si.fMask = SIF_POS;
    si.nPos = ScrollOffset;
    SetScrollInfo(SucheScroll, SB_CTL, &si, TRUE);
  } else
  if (neupos >= ScrollOffset + SSl) {
    ScrollOffset = neupos - SSl + 1;
    if (ScrollOffset < 0) ScrollOffset = 0;
    si.cbSize = sizeof(si);
    si.fMask = SIF_POS;
    si.nPos = ScrollOffset;
    SetScrollInfo(SucheScroll, SB_CTL, &si, TRUE);
  }
  SetWindowText(Loesung_Nr, ErgebnisString(neupos));
  ChoosenResult = neupos;
  InvalidateRect(hwnd, &Bereich2, TRUE);
}

void ZeigeHinweise(HWND hwnd)
{ MessageBox(hwnd,
    "Allgemeine Hinweise zu diesem Programm:\n\n"

    "- Wenn Sie eine bestimmte Lsungsnummer sehen wollen, so geben Sie die Nummer in dem Eingabefeld"
    " rechts oben ein. Hngen Sie noch einen Buchstaben (a bis d) an, wenn Sie auch die Gesamtorientierung"
    " ndern wollen.\n"

    "- Wollen Sie wissen, wieviele Lsungen berhaupt in der Lsungsdatei gespeichert sind, dann geben Sie einfach"
    " eine sehr hohe Zahl ein, sie wird automatisch herabgesetzt.\n"

    "- Filtervorgaben (Raumkoordinaten, an denen ein bestimmtes Puzzleteil liegen soll) knnen Sie auch bequem"
    " durch einen Mausklick (linke Taste) auf den entsprechenden Teilwrfel in der dimetrischen Darstellung"
    " in das Eingabefeld bernehmen.\n"
    "- Wenn Sie statt dessen wissen wollen, welches Puzzleteil an einer Position der angezeigten Lsung liegt,"
    " dann klicken Sie diesen Teilwrfel mit der rechten Maustaste an.\n"

    "- nderungen der Filtereinstellung wirken sich sofort auf die laufende Filtersuche aus. Wenn Sie also die"
    " Filtereinstellungen ndern whrend die Filtersuche noch luft, gengen die ersten Suchergebnisse anderen"
    " Bedingungen als die letzten Suchergebnisse.\n"
    "- Sie knnen sich die Lsung auch rumlich rotierbar ansehen. Der Aufruf des mitgelieferten Standardviewers"
    " (Anweisung \"neut2slp -d\") kann im Eingabefeld rechts unten ersetzt werden, um andere mit der bergabesyntax"
    " kompatible Anzeigeprogramme zu starten.\n"
    "Nachdem Sie im mitgelieferten Standardviewer die Spachumstellung gefunden haben, werden Sie sicher auch unter"
    " \"Objektdarstellung\" die Mglichkeit finden, die Einzelteile des Puzzles einzeln aus- und wieder einzublenden.\n"
    "Die bergabe der Platzierungpositionen der einzelen Bausteine fr diesen Standardviewer steht in einer Datei"
    " mit der Endung \".pos\" im Unterverzeichnis \"loesungen\". Es empfiehlt sich, den Inhalt dieses"
    " Temporrverzeichnisses gelegentlich wieder zu lschen.\n"

    "\nSollten bei der Berechung der Lsungstabelle in dem Textfenster statt Umlauten seltsame Zeichen erscheinen,"
    " liegt das womglich an der Zeichensatzeinstellung des 'DOS-Fensters': Rasterfont statt UNICODE-True-Type-Font.\n"
    "\n\xa9 Arnold Wendl, Frth, anno Domini 2003\n\n"
    "P.S. Mein Testrechner war ein Pentium MMX mit 233 MHz, 192 MB RAM und Shared Memory Grafik.",
    ThisTitleBar " - Info", MB_ICONINFORMATION | MB_OK);
}

void CommandAction(HWND hwnd, int Notification, int Cmd, LPARAM lParam)
{ switch (Cmd) {
    case CMD_SUCHE:
      StarteSuche(hwnd);
    break;
    case CMD_SEARCHEND:
      SuspendThread(SearchThread);
      SearchThread_Suspend++;
    break;
    case CMD_SEARCHPRED:
      NextScrollErg(hwnd, -1);
    break;
    case CMD_SEARCHSUCC:
      NextScrollErg(hwnd, 1);
    break;
    case CMD_ADDITEMSTRT:
      ClearErgebnis();
      ScrollOffset = 0;
      AdjustScrollbarSize();
    break;
    case CMD_ADDITEM:
      /* if (vorherige Suche ist beendet) */
      AddErgebnis((unsigned long) lParam, 0);
      AdjustScrollbarSize();
      if (ScrollOffset + SSl >= SuchErgebnisse) InvalidateRect(hwnd, &Bereich2, TRUE);
    break;
    case CMD_FILTER:
      Filter_an = !Filter_an;
      SetSwitches();
    break;
    case CMD_ALTSUCHE:
      SucheAlle = !SucheAlle;
      BitteSuchen = 1;
      SetSwitches();
    break;
    case CMD_VWR_STRT:
      ViewerStartLoesung();
    break;
    case MN_START_SUCHE:
      StartLoesungsBerechnung(0);
    break;
    case MN_FILTER_CLEAR:
      FilterLoeschen();
    break;
    case MN_FILTER_A_B:
    case MN_FILTER_A_C:
    case MN_FILTER_A_D:
      FilterWenden(Cmd - MN_FILTER_CLEAR);
    break;
    case MN_INFO:
      ZeigeHinweise(hwnd);
    break;
    case MN_DIMET_S1:
      SetDimetScale(1);
      InvalidateRect(hwnd, &Bereich3, TRUE);
    break;
    case MN_DIMET_S2:
      SetDimetScale(2);
      InvalidateRect(hwnd, &Bereich3, TRUE);
    break;
    case MN_DIMET_S3:
      SetDimetScale(3);
      InvalidateRect(hwnd, &Bereich3, TRUE);
    break;
    case MN_MIRROR_1:
      Mirror1 = !Mirror1;
      CheckMenuItem(SpiegelMenu, MN_MIRROR_1, MF_BYCOMMAND | (Mirror1 ? MF_CHECKED : MF_UNCHECKED));
      InvalidateRect(hwnd, &Bereich1, TRUE);
      InvalidateRect(hwnd, &Bereich3, TRUE);
    break;
    case MN_MIRROR_2:
      Mirror2 = !Mirror2;
      CheckMenuItem(SpiegelMenu, MN_MIRROR_2, MF_BYCOMMAND | (Mirror2 ? MF_CHECKED : MF_UNCHECKED));
      InvalidateRect(hwnd, &Bereich1, TRUE);
      InvalidateRect(hwnd, &Bereich3, TRUE);
    break;
    case MN_MIRROR_9:
      Mirror9 = !Mirror9;
      CheckMenuItem(SpiegelMenu, MN_MIRROR_9, MF_BYCOMMAND | (Mirror9 ? MF_CHECKED : MF_UNCHECKED));
      InvalidateRect(hwnd, &Bereich1, TRUE);
      InvalidateRect(hwnd, &Bereich3, TRUE);
    break;
    case CMD_SOL_NEXT:
      CheckSolutionNumber(1);
      SelectSolutionNumber(hwnd);
      ChoosenResult = -1;
      InvalidateRect(hwnd, &Bereich2, TRUE);
    break;
    case CMD_SOL_PREV:
      CheckSolutionNumber(-1);
      SelectSolutionNumber(hwnd);
      ChoosenResult = -1;
      InvalidateRect(hwnd, &Bereich2, TRUE);
    break;
    case CMD_SOL_EDIT:
      switch (Notification) {
        case EN_UPDATE:
	  CheckSolutionNumber(0);
	break;
        case EN_CHANGE:
	  CheckSolutionNumber(0);
          SelectSolutionNumber(hwnd);
          ChoosenResult = -1;
          InvalidateRect(hwnd, &Bereich2, TRUE);
	break;
	case EN_KILLFOCUS:
	  // ReadSolutionNumber();
        break;
      }
    break;
    default:
      if ((Cmd >= CMD_FB) && (Cmd - CMD_FB < 3 * BAUSTEINZAHL)) {
	int bs, i, x, y, z;
        char Box[40];
	switch (Notification) {
          /* case EN_UPDATE:    T = "EN_UPDATE"; break; */
	  case EN_CHANGE:
	    bs = (Cmd - CMD_FB) / 3;
	    i = (Cmd - CMD_FB) % 3;
	    x = y = z = -1;
	    GetWindowText(Vorgaben[bs][i], Box, 39); Box[39] = '\0';
	    sscanf(Box, "%d,%d,%d", &x, &y, &z);
	    if ((x < 0) || (y < 0) || (z < 0)) {
	      Vorgabenwerte[bs][i][3] = 0;
	      SetWindowText(FilterInfo, "Koordinate ist (noch) ungltig. Bitte Form \"x,y,z\" einhalten.");
	    } else
	    if (x > 4) {
	      Vorgabenwerte[bs][i][3] = 0;
	      SetWindowText(FilterInfo, "Koordinate ist ungltig. Bitte x-Wert zwischen 0 und 4 einhalten.");
	    } else
	    if (y > 3) {
	      Vorgabenwerte[bs][i][3] = 0;
	      SetWindowText(FilterInfo, "Koordinate ist ungltig. Bitte y-Wert zwischen 0 und 3 einhalten.");
	    } else
	    if (z > 2) {
	      Vorgabenwerte[bs][i][3] = 0;
	      SetWindowText(FilterInfo, "Koordinate ist ungltig. Bitte z-Wert zwischen 0 und 2 einhalten.");
	    } else {
	      Vorgabenwerte[bs][i][0] = x; Vorgabenwerte[bs][i][1] = y; Vorgabenwerte[bs][i][2] = z;
	      Vorgabenwerte[bs][i][3] = 1;
	      SetWindowText(FilterInfo, "");
	    }
            BitteSuchen = 1;
            if (!SuchtGerade()) SetWindowText(SucheStart, "Suchen!");
	  break;
	  case EN_KILLFOCUS:
            VorgabeAktivBS = VorgabeAktivSp = -1;
	    SetWindowText(FilterInfo, "");
	  break;
	  case EN_SETFOCUS:
            VorgabeAktivBS = (Cmd - CMD_FB) / 3;
	    VorgabeAktivSp = (Cmd - CMD_FB) % 3;
	    SetWindowText(FilterInfo, "Bitte Koordinaten in der Form \"x,y,z\" angeben. "
	      "Oder whlen Sie rechts im Raumbild eine Position aus.");
	  break;
        }
      }
  }
}

void Text(HDC hdc, char *Text, UINT Alignment)
{ POINT akt_pos;
  UINT TextAlign;
  int PrevBKM;
  GetCurrentPositionEx(hdc, &akt_pos);
  TextAlign = GetTextAlign(hdc);
  SetBkMode(hdc, TRANSPARENT);
  if (Alignment) SetTextAlign(hdc, Alignment);
  TextOut(hdc, akt_pos.x, akt_pos.y, Text, strlen(Text));
  SetTextAlign(hdc, TextAlign);
  SetBkMode(hdc, PrevBKM);
}

void Pfeil(HDC hdc, float Richtung, float Spitzwinkel, float Schenkellaenge)
{ POINT akt_pos[3];
  GetCurrentPositionEx(hdc, akt_pos);
  akt_pos[1].x = akt_pos[0].x
    + floor(Schenkellaenge * cos(M_PI * (180.0 + Richtung + 0.5 * Spitzwinkel) / 180.0) + 0.5);
  akt_pos[1].y = akt_pos[0].y
    - floor(Schenkellaenge * sin(M_PI * (180.0 + Richtung + 0.5 * Spitzwinkel) / 180.0) + 0.5);
  akt_pos[2].x = akt_pos[0].x
    + floor(Schenkellaenge * cos(M_PI * (180.0 + Richtung - 0.5 * Spitzwinkel) / 180.0) + 0.5);
  akt_pos[2].y = akt_pos[0].y
    - floor(Schenkellaenge * sin(M_PI * (180.0 + Richtung - 0.5 * Spitzwinkel) / 180.0) + 0.5);
  BeginPath(hdc); Polyline(hdc, akt_pos, 3); EndPath(hdc); StrokeAndFillPath(hdc);
}

void MoveTo3D(HDC hdc, int Ansicht, int x, int y, int z, int teiler)
{ int px, py;
  if (Ansicht > 0) {
    px = DI1_cx - (5 * 24 - 3 * 9) * DI_scale;
    py = DI1_cy - (5 * 3 + 3 * 8 - 4 * 24) * DI_scale;
    px += (24 * x - 9 * z) * DI_scale / teiler;
    py += (3 * x - 24 * y + 8 * z) * DI_scale / teiler;
  } else {
    px = DI2_cx; py = DI2_cy;
    px += (24 * x - 9 * z) * DI_scale / teiler;
    py += (24 * y - 3 * x - 8 * z) * DI_scale / teiler;
  }
  MoveToEx(hdc, px, py, NULL);
}

void LineTo3D(HDC hdc, int Ansicht, int x, int y, int z, int teiler)
{ int px, py;
  if (Ansicht > 0) {
    px = DI1_cx - (5 * 24 - 3 * 9) * DI_scale;
    py = DI1_cy - (5 * 3 + 3 * 8 - 4 * 24) * DI_scale;
    px += (24 * x - 9 * z) * DI_scale / teiler;
    py += (3 * x - 24 * y + 8 * z) * DI_scale / teiler;
  } else {
    px = DI2_cx; py = DI2_cy;
    px += (24 * x - 9 * z) * DI_scale / teiler;
    py += (24 * y - 3 * x - 8 * z) * DI_scale / teiler;
  }
  LineTo(hdc, px, py);
}

void SurfaceLine3D(HDC hdc, int Ansicht, KOORD p1, KOORD p2)
{ if ((Ansicht >= 0)
   && (((p1.KOORD[0] == 45) && (p2.KOORD[0] == 45))
    || ((p1.KOORD[1] == 35) && (p2.KOORD[1] == 35))
    || ((p1.KOORD[2] == 25) && (p2.KOORD[2] == 25)))) {
    MoveTo3D(hdc, 1, p1.KOORD[0] + 5, p1.KOORD[1] + 5, p1.KOORD[2] + 5, 10);
    LineTo3D(hdc, 1, p2.KOORD[0] + 5, p2.KOORD[1] + 5, p2.KOORD[2] + 5, 10);
  }
  if ((Ansicht <= 0)
   && (((p1.KOORD[0] == -5) && (p2.KOORD[0] == -5))
    || ((p1.KOORD[1] == -5) && (p2.KOORD[1] == -5))
    || ((p1.KOORD[2] == -5) && (p2.KOORD[2] == -5)))) {
    MoveTo3D(hdc, -1, p1.KOORD[0] + 5, p1.KOORD[1] + 5, p1.KOORD[2] + 5, 10);
    LineTo3D(hdc, -1, p2.KOORD[0] + 5, p2.KOORD[1] + 5, p2.KOORD[2] + 5, 10);
  }
}

void BausteinSurfaceLines3D(HDC hdc, int Ansicht, MATRIX m, int *surfaces)
{ int p; MATRIX M;
  if (surfaces == NULL) return;
  if (surfaces[0] >= 9999) return;
  /* "explodieren", da die Oberflchen in zehntel-Einheiten beschrieben sind */
  M = m; for (p = 9; p < 12; p++) M.MATRIX[p] *= 10;
  for (p = 0; surfaces[p + 3] < 9999;) {
    if (surfaces[p + 3] == 2000) { /* Move */
      p += 4;
    } else { /* Draw */
      SurfaceLine3D(hdc, Ansicht,
                    PosTrans3i(M, surfaces[p    ], surfaces[p + 1], surfaces[p + 2]),
                    PosTrans3i(M, surfaces[p + 3], surfaces[p + 4], surfaces[p + 5]));
      p += 3;
    }
  }
}

void PaintLoesung(HDC hdc, int Ansicht)
{ HPEN Stift, altStift;
  int ct, bs, a, i;
  MATRIX m;
  if (!LoesungssatzGueltig) return;
  a = Loesungslage; if (a < 0) a = 0;
  altStift = GetCurrentObject(hdc, OBJ_PEN);
  Stift = CreatePen(PS_SOLID, 3, RGB(0, 0, 255));
  SelectObject(hdc, Stift);
  for (ct = 0; ct < BAUSTEINZAHL; ct++) {
    bs = BausteinNummer(Loesungssatz[ct]);
    if ((bs >= 0) && (bs < BAUSTEINZAHL)) {
      if ((bs == 0) && Mirror1) {
        m = MatMul(Hinlegen[a], MatMul(Orientierung(Loesungssatz[ct]), INV1));
      } else
      if ((bs == 1) && Mirror2) {
        m = MatMul(Hinlegen[a], MatMul(Orientierung(Loesungssatz[ct]), INV2));
      } else
      if ((bs == 8) && Mirror9) {
        m = MatMul(Hinlegen[a], MatMul(Orientierung(Loesungssatz[ct]), INV9));
      } else
        m = MatMul(Hinlegen[a], Orientierung(Loesungssatz[ct]));
      BausteinSurfaceLines3D(hdc, Ansicht, m, SURFACELINES[bs]);
    }
  }
  SelectObject(hdc, altStift);
  DeleteObject(Stift);
}

void PaintSection3(HDC hdc)
{ HPEN Stift1, Stift2, alterStift;
  HBRUSH Farbe1, Farbe2, Farbe3, Farbe4, alteFarbe;
  POINT R1[4], R2[4], R3[4];
  int c, x, y, Ansicht;
  alteFarbe = GetCurrentObject(hdc, OBJ_BRUSH);
  alterStift = GetCurrentObject(hdc, OBJ_PEN);
  Farbe1 = CreateSolidBrush(RGB(224, 224, 255)); /* rechts */
  Farbe2 = CreateSolidBrush(RGB(255, 255, 255)); /* oben */
  Farbe3 = CreateSolidBrush(RGB(255, 255, 224)); /* links */
  Farbe4 = CreateSolidBrush(RGB(255,   0,   0)); /* links */
  Stift1 = CreatePen(PS_SOLID, 0, RGB(0, 0, 255));
  Stift2 = CreatePen(PS_SOLID, 0, RGB(0, 255, 255));
  
  BeginPath(hdc); Rectangle(hdc, Grenze2 + 1, 1, cxScreen, cyScreen); EndPath(hdc);
  SelectClipPath(hdc, RGN_COPY);
#define DI_cx(a) ((a > 0) ? DI1_cx : DI2_cx)
#define DI_cy(a) ((a > 0) ? DI1_cy : DI2_cy)
  SelectObject(hdc, Farbe4);
  for (Ansicht = -1; Ansicht < 2; Ansicht += 2) {
    MoveTo3D(hdc, Ansicht, 0, 0, 0, 1); LineTo3D(hdc, Ansicht, 50 * DI_scale + 10, 0, 0, 10 * DI_scale);
    Text(hdc, " x", TA_BASELINE | TA_LEFT);
    Pfeil(hdc,   -7.125  * Ansicht, 22.0, 15.0);
    MoveTo3D(hdc, Ansicht, 0, 0, 0, 1); LineTo3D(hdc, Ansicht, 0, 40 * DI_scale + 10, 0, 10 * DI_scale);
    Text(hdc, "y", ((Ansicht > 0) ? TA_BOTTOM : TA_TOP) | TA_CENTER);
    Pfeil(hdc,   90.0    * Ansicht, 22.0, 15.0);
    MoveTo3D(hdc, Ansicht, 0, 0, 0, 1); LineTo3D(hdc, Ansicht, 0, 0, 30 * DI_scale + 15, 10 * DI_scale);
    Text(hdc, "z", ((Ansicht > 0) ? TA_TOP : TA_BOTTOM) | TA_RIGHT);
    Pfeil(hdc, -138.3665 * Ansicht, 22.0, 15.0);
  }
  for (Ansicht = -1; Ansicht < 2; Ansicht += 2) {
    /* -1 : untere Ansicht, +1 : obere Ansicht */
    R1[0].x = DI_cx(Ansicht);                           R1[0].y = DI_cy(Ansicht);
    R1[1].x = DI_cx(Ansicht);                           R1[1].y = DI_cy(Ansicht) + 96 * DI_scale;
    R1[2].x = DI_cx(Ansicht) + 27 * DI_scale * Ansicht; R1[2].y = DI_cy(Ansicht) + 72 * DI_scale;
    R1[3].x = DI_cx(Ansicht) + 27 * DI_scale * Ansicht; R1[3].y = DI_cy(Ansicht) - 24 * DI_scale;
    R2[0].x = DI_cx(Ansicht);                           R2[0].y = DI_cy(Ansicht);
    R2[1].x = DI_cx(Ansicht) + 27 * DI_scale * Ansicht; R2[1].y = DI_cy(Ansicht) - 24 * DI_scale;
    R2[2].x = DI_cx(Ansicht) - 93 * DI_scale * Ansicht; R2[2].y = DI_cy(Ansicht) - 39 * DI_scale;
    R2[3].x = DI_cx(Ansicht) -120 * DI_scale * Ansicht; R2[3].y = DI_cy(Ansicht) - 15 * DI_scale;
    R3[0].x = DI_cx(Ansicht);                           R3[0].y = DI_cy(Ansicht);
    R3[1].x = DI_cx(Ansicht) -120 * DI_scale * Ansicht; R3[1].y = DI_cy(Ansicht) - 15 * DI_scale;
    R3[2].x = DI_cx(Ansicht) -120 * DI_scale * Ansicht; R3[2].y = DI_cy(Ansicht) + 81 * DI_scale;
    R3[3].x = DI_cx(Ansicht);                           R3[3].y = DI_cy(Ansicht) + 96 * DI_scale;
    SelectObject(hdc, Stift2);
    SelectObject(hdc, (Ansicht > 0) ? Farbe1 : Farbe3);
    BeginPath(hdc); Polyline(hdc, R1, 4); EndPath(hdc); FillPath(hdc);
    SelectObject(hdc, Farbe2);
    BeginPath(hdc); Polyline(hdc, R2, 4); EndPath(hdc); FillPath(hdc);
    SelectObject(hdc, (Ansicht > 0) ? Farbe3 : Farbe1);
    BeginPath(hdc); Polyline(hdc, R3, 4); EndPath(hdc); FillPath(hdc);
    for (c = 1; c < 3; c++) {
      MoveToEx(hdc, DI_cx(Ansicht) +  9 * c        * DI_scale * Ansicht,
                    DI_cy(Ansicht) + (96 - 8 * c)  * DI_scale, NULL);
      LineTo  (hdc, DI_cx(Ansicht) +  9 * c        * DI_scale * Ansicht,
                    DI_cy(Ansicht) -       8 * c   * DI_scale);
      LineTo  (hdc, DI_cx(Ansicht) + (9 * c - 120) * DI_scale * Ansicht,
                    DI_cy(Ansicht) - (15 + 8 * c)  * DI_scale);
    }
    for (c = 1; c < 4; c++) {
      MoveToEx(hdc, DI_cx(Ansicht) -  120           * DI_scale * Ansicht,
                    DI_cy(Ansicht) + ( 24 * c - 15) * DI_scale, NULL);
      LineTo  (hdc, DI_cx(Ansicht)                                      ,
                    DI_cy(Ansicht) +   24 * c       * DI_scale);
      LineTo  (hdc, DI_cx(Ansicht) +   27           * DI_scale * Ansicht,
                    DI_cy(Ansicht) + ( 24 * c - 24) * DI_scale);
    }
    for (c = 1; c < 5; c++) {
      MoveToEx(hdc, DI_cx(Ansicht) -       24 * c  * DI_scale * Ansicht,
                    DI_cy(Ansicht) + (96 -  3 * c) * DI_scale, NULL);
      LineTo  (hdc, DI_cx(Ansicht) -       24 * c  * DI_scale * Ansicht,
                    DI_cy(Ansicht) -        3 * c  * DI_scale);
      LineTo  (hdc, DI_cx(Ansicht) + (27 - 24 * c) * DI_scale * Ansicht,
                    DI_cy(Ansicht) - (24 +  3 * c) * DI_scale);
    }
    SelectObject(hdc, Stift1);
    BeginPath(hdc); Polyline(hdc, R1, 4); EndPath(hdc); StrokePath(hdc);
    BeginPath(hdc); Polyline(hdc, R2, 4); EndPath(hdc); StrokePath(hdc);
    BeginPath(hdc); Polyline(hdc, R3, 4); EndPath(hdc); StrokePath(hdc);
    PaintLoesung(hdc, Ansicht);
  }
  /* Abschluss */
  SelectObject(hdc, alteFarbe);
  SelectObject(hdc, alterStift);
#ifdef Ursprungskreuz
  MoveToEx(hdc, DI1_cx - 10, DI1_cy - 10, NULL);
  LineTo(hdc, DI1_cx + 10, DI1_cy + 10);
  MoveToEx(hdc, DI1_cx + 10, DI1_cy - 10, NULL);
  LineTo(hdc, DI1_cx - 10, DI1_cy + 10);
  MoveToEx(hdc, DI2_cx - 10, DI2_cy - 10, NULL);
  LineTo(hdc, DI2_cx + 10, DI2_cy + 10);
  MoveToEx(hdc, DI2_cx + 10, DI2_cy - 10, NULL);
  LineTo(hdc, DI2_cx - 10, DI2_cy + 10);
#endif
  DeleteObject(Farbe1); DeleteObject(Farbe2); DeleteObject(Farbe3); DeleteObject(Farbe4);
  DeleteObject(Stift1); DeleteObject(Stift2);
}

void PaintIsoBS(HDC hdc, RECT *rect, int *data, int xS, int yS)
{ int xmin, xmax, ymin, ymax, extset = 0, p, i;
  POINT P[BS_ISO_MAX_POINTS];
  HBRUSH falt, F[3];
  if (hdc != NULL) {
    falt = GetCurrentObject(hdc, OBJ_BRUSH);
    F[0] = CreateSolidBrush(RGB(255, 255, 255));
    F[1] = CreateSolidBrush(RGB(255, 255,   0));
    F[2] = CreateSolidBrush(RGB(  0, 255, 255));
  }  
  for (p = 0; data[p] < 9999;) {
    if (data[p] >= 1000) { /* Farbe */
      if (data[p] < 1003) SelectObject(hdc, F[data[p] - 1000]);
      p++; i = 0;
    } else {
      if (extset) {
        if (xmin > xS + data[p]) xmin = xS +data[p]; else if (xmax < xS + data[p]) xmax = xS + data[p];
        if (ymin > yS - data[p+1]) ymin = yS - data[p+1]; else if (ymax < yS - data[p+1]) ymax = yS -data[p+1];
      } else { xmin = xmax = data[p]; ymin = ymax = yS - data[p + 1]; extset = 1; }
      if (hdc != NULL) { P[i].x = xS + data[p]; P[i].y = yS - data[p+1]; i++; }
      p += 2;
    }
    if ((hdc != NULL) && (data[p] >= 1000)) {
      BeginPath(hdc);
      Polyline(hdc, P, i);
      EndPath(hdc);
      StrokeAndFillPath(hdc);
      i = 0;
    }
  }
  if (rect != NULL) {
    rect->top = ymin; rect->bottom = ymax; rect->left = xmin; rect->right = xmax;
  }
  if (hdc != NULL) {
    SelectObject(hdc, falt);
    for (i = 0; i < 3; i++) DeleteObject(F[i]);
  }
}

void PaintSection2(HDC hdc)
{ int y, ct, bkm, crf;
  RECT r;
  r.left = Grenze1 + 1; r.right = SSx;
  bkm = SetBkMode(hdc, TRANSPARENT);
  for (ct = 0; ct < SSl; ct++) {
    r.top = SSy + ct * TXy;
    r.bottom = r.top + TXy;
    if (ct + ScrollOffset == ChoosenResult) crf = SetTextColor(hdc, RGB(255, 0, 0));
    DrawText(hdc, ErgebnisString(ct + ScrollOffset), -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
    if (ct + ScrollOffset == ChoosenResult) SetTextColor(hdc, crf);
  }
  SetBkMode(hdc, bkm);
}

void PaintSection1(HDC hdc)
{ int y, b; RECT r;
  char RectInfo[300];
  HPEN altstift, stift;
  COLORREF bkcolor;
  altstift = GetCurrentObject(hdc, OBJ_PEN);
  bkcolor = GetBkColor(hdc);
  stift = CreatePen(PS_DOT, 0, RGB(0, 0, 0)); /* Zur Wahl: DOT, DASHDOT */
  SetBkColor(hdc, RGB(255, 255, 128));
  y = EWB1;
  for (b = 0; b < BAUSTEINZAHL; b++) {
    if (b == MarkierterBS) {
      MoveToEx(hdc, 0, y - EHD / 2, NULL);
      LineTo(hdc, PictWidth1, y - EHD / 2);
      LineTo(hdc, PictWidth1, y + EHD / 2);
      LineTo(hdc, 0 , y + EHD / 2);
      LineTo(hdc, 0 , y - EHD / 2);
    }
    if (((b == 0) && Mirror1) || ((b == 1) && Mirror2) || ((b == 8) && Mirror9)) {
      SelectObject(hdc, stift);
      MoveToEx(hdc, PictWidth1 / 2 + 4 * EHD / 7, y - EHD / 2, NULL);
      LineTo(  hdc, PictWidth1 / 2 - 4 * EHD / 7, y + EHD / 2);
      SelectObject(hdc, altstift);
    }
    PaintIsoBS(NULL, &r, BS_ISO[b], 0, 0);
    PaintIsoBS(hdc, NULL, BS_ISO[b], (PictWidth1 - r.right + r.left) / 2, y + (r.bottom - r.top) / 2);
    sprintf(RectInfo, "{ l=%d, r=%d, t=%d, b=%d } -> %d, %d\n",
      r.left, r.right, r.top, r.bottom, (PictWidth1 - r.right + r.left) / 2, y + (r.bottom - r.top) / 2);
    y += EHD;
  }
  SetBkColor(hdc, bkcolor);
  DeleteObject(stift);
}

void PaintGlobal(HDC hdc)
{ HPEN stift1, stift2, altstift;
  altstift = GetCurrentObject(hdc, OBJ_PEN);
  stift1 = CreatePen(PS_SOLID, 0, RGB(255, 255, 255));
  stift2 = CreatePen(PS_SOLID, 0, RGB(  0,   0, 128));
  SelectObject(hdc, stift2);
  MoveToEx(hdc, Grenze1, 0, NULL); LineTo(hdc, Grenze1, cyScreen);
  MoveToEx(hdc, Grenze2, 0, NULL); LineTo(hdc, Grenze2, cyScreen);
  SelectObject(hdc, stift1);
  MoveToEx(hdc, 0, 0, NULL); LineTo(hdc, cxScreen, 0);
  SelectObject(hdc, altstift);
  DeleteObject(stift1); DeleteObject(stift2);
}

void SucheBSaufPos(int x, int y, int z)
{ char Mldg[200];
  int bs, ct, a, i;
  BAUSTEIN BS;
  MarkierterBS = -1;
  if (!LoesungssatzGueltig) return;
  a = Loesungslage; if (a < 0) a = 0;
  for (ct = 0; ct < BAUSTEINZAHL; ct++) {
    bs = BausteinNummer(Loesungssatz[ct]);
    if ((bs >= 0) && (bs < BAUSTEINZAHL)) {
      BS = BewegterBaustein(Baustein[bs], MatMul(Hinlegen[a], Orientierung(Loesungssatz[ct])));
      for (i = 0; i < BS.Teilwuerfelzahl; i++) {
        if ((BS.Einzelelemente[i].KOORD[0] == x)
         && (BS.Einzelelemente[i].KOORD[1] == y)
         && (BS.Einzelelemente[i].KOORD[2] == z)) {
	  MarkierterBS = bs;
	  InvalidateRect(hwndApplication, &Bereich1, TRUE);
	  sprintf(Mldg, "Der %d. Baustein liegt auf der Raumkoordinate '%d,%d,%d'",
	    bs + 1, x, y, z);
	  MessageBox(hwndApplication, Mldg, "Positionsinfo:", MB_ICONINFORMATION | MB_OK);
	  return;
	}
      }
    }
  }
  InvalidateRect(hwndApplication, &Bereich1, TRUE);
}

void SetFilterCoordinate(int x, int y, int z)
{ char Positionsstring[16];
  if (!Filter_an || (VorgabeAktivBS < 0) || (VorgabeAktivSp < 0)) return;
  sprintf(Positionsstring, "%d,%d,%d", x, y, z);
  SetWindowText(Vorgaben[VorgabeAktivBS][VorgabeAktivSp], Positionsstring);
  Vorgabenwerte[VorgabeAktivBS][VorgabeAktivSp][0] = x;
  Vorgabenwerte[VorgabeAktivBS][VorgabeAktivSp][1] = y;
  Vorgabenwerte[VorgabeAktivBS][VorgabeAktivSp][2] = z;
  Vorgabenwerte[VorgabeAktivBS][VorgabeAktivSp][3] = 1;
  BitteSuchen = 1;
  if (!SuchtGerade()) SetWindowText(SucheStart, "Suchen!");
}

void ButtonPosClickSelect(HWND hwnd, int x, int y)
{ int p;
  if ((x <= Grenze1) || (x >= Grenze2)) return;
  p = y - SSy;
  if (p < 0) return;
  p = p / TXy;
  if (p >= SSl) return;
  p += ScrollOffset;
  if (p >= SuchErgebnisse) return;
  /* In die Eingabe zur Darstellung bertragen */
  SetWindowText(Loesung_Nr, ErgebnisString(p));
  ChoosenResult = p;
  InvalidateRect(hwnd, &Bereich2, TRUE);
}

void ButtonPosClickTransfer(HWND hwnd, int to_filter, int x, int y)
{ int dx, dy, u, v;
  if (x < Grenze2) return;
  /* Loesung eines Gleichungssystem mit 2 Unbekannten nach dem Determinantenverfahren */
  /* oberes Bild */
  dx = x - DI1_cx; dy = y - DI1_cy;
  /* oben */
  u = (  3 * dx - 24 * dy + 219 * DI_scale) / 219 / DI_scale - 1;
  v = ( -8 * dx -  9 * dy + 219 * DI_scale) / 219 / DI_scale - 1;
  if ((u >= 0) && (v >= 0) && (u < 3) && (v < 5)) {
    if (!to_filter) { SucheBSaufPos(4 - v, 3, 2 - u); return; }
    SetFilterCoordinate(4 - v, 3, 2 - u);
    return;
  }
  /* vorne / links */
  u = (-24 * dx           + 576 * DI_scale) / 576 / DI_scale - 1;
  v = ( -3 * dx + 24 * dy + 576 * DI_scale) / 576 / DI_scale - 1;
  if ((u >= 0) && (v >= 0) && (u < 5) && (v < 4)) {
    if (!to_filter) { SucheBSaufPos(4 - u, 3 - v, 2); return; }
    SetFilterCoordinate(4 - u, 3 - v, 2);
    return;
  }
  /* rechts */
  u = ( 24 * dx           + 216 * DI_scale) / 216 / DI_scale - 1;
  v = (  8 * dx +  9 * dy + 216 * DI_scale) / 216 / DI_scale - 1;
  if ((u >= 0) && (v >= 0) && (u < 3) && (v < 4)) {
    if (!to_filter) { SucheBSaufPos(4, 3 - v, 2 - u); return; }
    SetFilterCoordinate(4, 3 - v, 2 - u);
    return;
  }
  /* unteres Bild */
  dx = x - DI2_cx; dy = y - DI2_cy;
  /* oben */
  u = (  8 * dx -  9 * dy + 219 * DI_scale) / 219 / DI_scale - 1;
  v = ( -3 * dx - 24 * dy + 219 * DI_scale) / 219 / DI_scale - 1;
  if ((u >= 0) && (v >= 0) && (u < 5) && (v < 3)) {
    if (!to_filter) { SucheBSaufPos(u, 0, v); return; }
    SetFilterCoordinate(u, 0, v);
    return;
  }
  /* links */
  u = (-24 * dx           + 216 * DI_scale) / 216 / DI_scale - 1;
  v = ( -8 * dx +  9 * dy + 216 * DI_scale) / 216 / DI_scale - 1;
  if ((u >= 0) && (v >= 0) && (u < 3) && (v < 4)) {
    if (!to_filter) { SucheBSaufPos(0, v, u); return; }
    SetFilterCoordinate(0, v, u);
    return;
  }
  /* vorne / rechts */
  u = ( 24 * dx           + 567 * DI_scale) / 576 / DI_scale - 1;
  v = (  3 * dx + 24 * dy + 576 * DI_scale) / 576 / DI_scale - 1;
  if ((u >= 0) && (v >= 0) && (u < 5) && (v < 4)) {
    if (!to_filter) { SucheBSaufPos(u, v, 0); return; }
    SetFilterCoordinate(u, v, 0);
    return;
  }
  if (!to_filter) { MarkierterBS = -1; InvalidateRect(hwnd, &Bereich1, TRUE); }
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{ HDC hdc;
  PAINTSTRUCT ps;
  switch (uMsg) {
    case WM_PAINT:
      hdc = BeginPaint(hwnd, &ps);
      PaintGlobal(hdc);
      PaintSection1(hdc);
      PaintSection2(hdc);
      PaintSection3(hdc);
      EndPaint(hwnd, &ps);
    return 0;
    case WM_CREATE:
      cxChar = LOWORD(GetDialogBaseUnits());
      cyChar = HIWORD(GetDialogBaseUnits());
      CreateSubwindows(hwnd);
    break;
    case WM_SIZE:
      cxScreen = LOWORD(lParam);
      cyScreen = HIWORD(lParam);
      ChangeSize(hwnd, lParam);
      AdjustScrollbarSize();
    break;
    case WM_COMMAND:
      CommandAction(hwnd, HIWORD(wParam), LOWORD(wParam), lParam);
    break;
    case WM_VSCROLL:
      ScrollAction(hwnd, HIWORD(wParam), LOWORD(wParam), lParam);
    break;
    case WM_RBUTTONDOWN:
      ButtonPosClickTransfer(hwnd, 0, LOWORD(lParam), HIWORD(lParam));
    break;
    case WM_LBUTTONDOWN:
      ButtonPosClickTransfer(hwnd, 1, LOWORD(lParam), HIWORD(lParam));
      ButtonPosClickSelect(hwnd, LOWORD(lParam), HIWORD(lParam));
    break;
    case WM_DESTROY:
      if (Loesungsdatei != NULL) fclose(Loesungsdatei);
      PostQuitMessage(0);
      return 0;
  }
  return DefWindowProc(hwnd, uMsg, wParam, lParam);
}

BOOL InsertSubmenuString(HMENU hMenu, UINT Pos, BOOL byPos, HMENU submenu, CHAR *Text)
{ MENUITEMINFO mii;
  mii.cbSize = sizeof(MENUITEMINFO);
  mii.fMask = MIIM_SUBMENU | MIIM_TYPE;
  mii.fType = MFT_STRING;
  mii.fState = MFS_DEFAULT;
  mii.wID = 0;
  mii.hSubMenu= submenu;
  mii.hbmpChecked = NULL;
  mii.hbmpUnchecked = NULL;
  mii.dwItemData = 0;
  mii.dwTypeData = Text;
  mii.cch = strlen(Text);
  return InsertMenuItem(hMenu, Pos, byPos, &mii);
}

void BuildMenu(HWND hwnd)
{ HMENU newmenu, oldmenu, submenu;

  newmenu = CreateMenu();

  AppendMenu(newmenu, MF_STRING, MN_START_SUCHE, "&Lsungssuche starten");

  SpiegelMenu = CreateMenu();
  AppendMenu(SpiegelMenu, MF_STRING, MN_MIRROR_1, "&C-Teil umdrehen");
  AppendMenu(SpiegelMenu, MF_STRING, MN_MIRROR_2, "&Z-Teil umdrehen");
  AppendMenu(SpiegelMenu, MF_STRING, MN_MIRROR_9, "&r-Teil umdrehen");
  InsertSubmenuString(newmenu, -1, TRUE, SpiegelMenu, "&Bausteinspiegelungen");

  submenu = CreateMenu();
  AppendMenu(submenu, MF_STRING, MN_FILTER_CLEAR, "alle Filter &lschen");
  AppendMenu(submenu, MF_STRING, MN_FILTER_A_B, "wenden a/&b und c/d");
  AppendMenu(submenu, MF_STRING, MN_FILTER_A_C, "wenden a/&c und b/d");
  AppendMenu(submenu, MF_STRING, MN_FILTER_A_D, "wenden a/&d und b/c");
  InsertSubmenuString(newmenu, -1, TRUE, submenu, "&Filtermanipulationen");

  DimetrieMenu = CreateMenu();
  AppendMenu(DimetrieMenu, MF_STRING, MN_DIMET_S1, "Zoomfaktor &1");
  AppendMenu(DimetrieMenu, MF_STRING, MN_DIMET_S2, "Zoomfaktor &2");
  AppendMenu(DimetrieMenu, MF_STRING, MN_DIMET_S3, "Zoomfaktor &3");
  InsertSubmenuString(newmenu, -1, TRUE, DimetrieMenu, "&Dimetrische Darstellungen");

  AppendMenu(newmenu, MF_STRING, MN_INFO, "&Hinweise");

  oldmenu = GetMenu(hwnd);
  SetMenu(hwnd, newmenu);
  DestroyMenu(oldmenu);
  DrawMenuBar(hwnd);
}

#pragma argsused
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR d3, int nCmdShow)
{ 
  MSG msg;
  WNDCLASSEX wndClass;
  // HBRUSH BackgroundColor;

  hThisInstance = hInstance;
  IconGross = CreateIconString(hInstance, 32, 32, 2, 2, 0,
                "                "
                "                "
                "KKKKKKKKKKKKKKKK"
		"K..K..KRRKR.K..K"
		"K..K..KRRKR.K..K"
		"KKKKKKK.RKR.KKKK"
		"K..RRRK.RKRRRRRK"
		"K.R...KR.KR....K"
		"KR.KKKKKKKR.KKKK"
		"KR.K.....KR.K..K"
		"KR.K.....KR.K..K"
		"KR.KKKKKKKR.KKKK"
		"K.R...K..K.R...K"
		"K..RRRK..K..RRRK"
		"KKKKKKKKKKKKKKKK"
		"                ");
  IconKlein = CreateIconString(hInstance, 16, 16, 1, 1, 0,
                "                "
                "                "
                "KKKKKKKKKKKKKKKK"
		"K..K..KRRKR.K..K"
		"K..K..KRRKR.K..K"
		"KKKKKKK.RKR.KKKK"
		"K..RRRK.RKRRRRRK"
		"K.R...KR.KR....K"
		"KR.KKKKKKKR.KKKK"
		"KR.K.....KR.K..K"
		"KR.K.....KR.K..K"
		"KR.KKKKKKKR.KKKK"
		"K.R...K..K.R...K"
		"K..RRRK..K..RRRK"
		"KKKKKKKKKKKKKKKK"
		"                ");
  if (hPrevInstance == NULL) {
    memset(&wndClass, 0, sizeof(WNDCLASSEX));
    wndClass.cbSize        = sizeof(WNDCLASSEX);
    wndClass.style         = CS_HREDRAW | CS_VREDRAW;
    wndClass.lpfnWndProc   = WndProc;
    wndClass.cbClsExtra    = 0;
    wndClass.cbWndExtra    = 0;
    wndClass.hInstance     = hInstance;
    wndClass.hIcon         = IconGross;
    wndClass.hIconSm       = IconKlein;
    wndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wndClass.hbrBackground = /* BackgroundColor = CreateSolidBrush(RGB(0, 0, 128)); */ (HBRUSH) (COLOR_MENU + 1);
    wndClass.lpszMenuName  = NULL;
    wndClass.lpszClassName = ThisClassName;
    if (!RegisterClassEx(&wndClass)) {
      MessageBox(NULL, "RegisterClass() schlug fehl!", "Prinzipielle Startprobleme",
      MB_ICONEXCLAMATION | MB_OK);
      return 1;
    }
  }

  HintergrundLeiste = CreateSolidBrush(RGB(0, 0, 128));

  hwndApplication = CreateWindow(ThisClassName, ThisTitleBar,
    WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
    CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
    NULL, NULL, hInstance, NULL);
  BuildMenu(hwndApplication);
  SetDimetScale(1);
  ShowWindow(hwndApplication, nCmdShow);
  UpdateWindow(hwndApplication);
  if (access(ERGEBNIS, 4)) StartLoesungsBerechnung(1);

  while (GetMessage(&msg, NULL, 0, 0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  return msg.wParam;
}


