#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#ifdef __BORLANDC__
#define MINRECSZ 1
#else
#define MINRECSZ 0
#endif
#ifdef _WIN32
#include <windows.h>
#include <process.h>
#endif

#ifdef _PA_RISC1_1
#include <unistd.h>
#define wchar_t unsigned short
#define __int64 long long
#define MAX_PATH 256
#endif

#define MAX_COORDS 12000
#define HASHSIZE 256

#define SLP_STL_ASCII_HEAD "solid "

void Pause(void)
{ char Zeile[100];
  fprintf(stderr, ">>> RETURN bitte >>> RETURN please >>>");
  fgets(Zeile, 100, stdin);
}

struct HEAD {
  unsigned char  c[30];
  unsigned short us;
  unsigned long  ul;
  float          f;
  double         d;
} head = { "triangulara dosiero (.vtf)\r\n\32", 1, 987654321L,
	   7654321.0, 9876543210123456.0 };

FILE *aus = NULL, *aus2 = NULL;

void swap2(unsigned short *p)
{ unsigned char uc;
  union tausch2 {
    unsigned short h;
    unsigned char c[2];
  } *u;
  uc = ((union tausch2 *)p)->c[0];
  ((union tausch2 *)p)->c[0] = ((union tausch2 *)p)->c[1];
  ((union tausch2 *)p)->c[1] = uc;
}

void swap4(unsigned long *p)
{ unsigned char uc;
  union tausch4 {
    unsigned long h;
    unsigned char c[4];
  } *u;
  uc = ((union tausch4 *)p)->c[0];
  ((union tausch4 *)p)->c[0] = ((union tausch4 *)p)->c[3];
  ((union tausch4 *)p)->c[3] = uc;
  uc = ((union tausch4 *)p)->c[1];
  ((union tausch4 *)p)->c[1] = ((union tausch4 *)p)->c[2];
  ((union tausch4 *)p)->c[2] = uc;
}

void swap8(unsigned __int64 *p)
{ unsigned char uc;
  union tausch8 {
    unsigned __int64 h;
    unsigned char c[8];
  } *u;
  uc = ((union tausch8 *)p)->c[0];
  ((union tausch8 *)p)->c[0] = ((union tausch8 *)p)->c[7];
  ((union tausch8 *)p)->c[7] = uc;
  uc = ((union tausch8 *)p)->c[1];
  ((union tausch8 *)p)->c[1] = ((union tausch8 *)p)->c[6];
  ((union tausch8 *)p)->c[6] = uc;
  uc = ((union tausch8 *)p)->c[2];
  ((union tausch8 *)p)->c[2] = ((union tausch8 *)p)->c[5];
  ((union tausch8 *)p)->c[5] = uc;
  uc = ((union tausch8 *)p)->c[3];
  ((union tausch8 *)p)->c[3] = ((union tausch8 *)p)->c[4];
  ((union tausch8 *)p)->c[4] = uc;
}

void swap2x4(unsigned __int64 *p)
{ unsigned char uc;
  union tausch8 {
    unsigned __int64 h;
    unsigned char c[8];
  } *u;
  uc = ((union tausch8 *)p)->c[0];
  ((union tausch8 *)p)->c[0] = ((union tausch8 *)p)->c[3];
  ((union tausch8 *)p)->c[3] = uc;
  uc = ((union tausch8 *)p)->c[1];
  ((union tausch8 *)p)->c[1] = ((union tausch8 *)p)->c[2];
  ((union tausch8 *)p)->c[2] = uc;
  uc = ((union tausch8 *)p)->c[4];
  ((union tausch8 *)p)->c[4] = ((union tausch8 *)p)->c[7];
  ((union tausch8 *)p)->c[7] = uc;
  uc = ((union tausch8 *)p)->c[5];
  ((union tausch8 *)p)->c[5] = ((union tausch8 *)p)->c[6];
  ((union tausch8 *)p)->c[6] = uc;
}

struct {
  float hx, hy, hz;
  unsigned long ret_val, count;
} Hash[HASHSIZE];
int in_hash_cnt = 0, hashpos_to_replace;
unsigned long hash_hit = 0, no_hash_hit =0;
unsigned long FileSize;

/* Extend of the model */
float xmin, xmax,  ymin, ymax,  zmin, zmax;
unsigned long total_facet_count;
/* options */
int indexed = 0, colorindexed = 0, silent = 0, swaped = 0, swap_still_allowed = 1;

struct Coords_accel {
  struct Coords_accel *X, *Y, *Z;
  int                 this_pos;
  float               *values;
} *BaseAccel = NULL;

unsigned long stored_coordinates = 0;
struct CoordsField {
  struct CoordsField *next;
  float               coords[MAX_COORDS];
  struct Coords_accel accel[MAX_COORDS / 3];
} *CArr = NULL, *CArrLast = NULL;

union NomoX {
  struct NomoL {
    unsigned long size_n_flags;
    wchar_t ObjectName[MAX_PATH + 10];
  } n;
  __int64 Data[1];
} nomo;

struct Nomo {
  unsigned long size_n_flags;
  wchar_t ObjectName[MINRECSZ];
}; /* 1/2 * 8 bytes + x */

struct Coloratoro {
  unsigned long size_n_flags;
  unsigned long index;
} coloratoro; /* 1 * 8 bytes */

struct Dauxrigo {
  unsigned long size_n_flags;
  void * There;
} dauxrigo; /* 1 * 8 bytes */

struct Triangulo {
  unsigned long size_n_flags;
  unsigned long repeated;
  double        coordinates[MINRECSZ];
}; /* 1 * 8 bytes + n * 8 bytes */

struct TrianguletoL {
  unsigned long size_n_flags;
  unsigned long repeated;
  union { float         coordinates[MAX_COORDS];
	  unsigned long index[MAX_COORDS];
        }       d;
} trianguleto;

struct Trianguleto {
  unsigned long size_n_flags;
  unsigned long repeated;
  float         coordinates[MINRECSZ];
}; /* 1 * 8 bytes + n / 2 * 8 bytes */

struct Coloro {
  unsigned long size_n_flags;
  float r, g, b;
} coloro; /* 16 bytes = 2 * 8 bytes */

union Unu {
  struct Coloro      coloro;
  struct Coloratoro  coloratoro;
  struct Triangulo   triangulo;
  struct Trianguleto trianguleto;
  struct Dauxrigo    dauxrigo;
  struct Nomo        nomo;
  unsigned __int64   Data[1];
};

struct Memorilo {
  struct Memorilo *next_block;
  unsigned long capacity;
  unsigned long next_free;
  void *        next_free_p;
  unsigned __int64 Data[MINRECSZ];
} *TDate = NULL, *TDate_Current = NULL;

void free_coordinates(void)
{ struct CoordsField *arr, *nxt;
  for (arr = CArr; arr != NULL; arr = nxt) {
    nxt = arr->next;
    free(arr);
  }
  CArr = CArrLast = NULL; BaseAccel = NULL;
  in_hash_cnt = 0;
  stored_coordinates = 0;
}

struct CoordsField *alloc_CoordsField(void)
{ struct CoordsField *neu;
  if ((neu = malloc(sizeof(struct CoordsField))) == NULL) return NULL;
  neu->next = NULL;
  return neu;
}

unsigned long new_index(float wx, float wy, float wz, int e, struct Coords_accel *ca)
{ unsigned long erg, idx, aidx;
  if ((CArr == NULL) || (stored_coordinates == 0)) {
    if ((CArr = alloc_CoordsField()) == NULL) return 0xffffffffL;
    CArrLast = CArr;
  }
  idx = stored_coordinates % MAX_COORDS;
  aidx = idx / 3;
  if ((idx == 0) && stored_coordinates) {
    if ((CArrLast->next = alloc_CoordsField()) == NULL) return 0xffffffffL;
    CArrLast = CArrLast->next;
  }
  CArrLast->coords[idx] = wx;
  CArrLast->coords[idx + 1] = wy;
  CArrLast->coords[idx + 2] = wz;
  CArrLast->accel[aidx].X = NULL;
  CArrLast->accel[aidx].Y = NULL;
  CArrLast->accel[aidx].Z = NULL;
  CArrLast->accel[aidx].this_pos = stored_coordinates;
  CArrLast->accel[aidx].values = &(CArrLast->coords[idx]);
  switch (e) {
    case 0: BaseAccel = &(CArrLast->accel[aidx]); break;
    case 1: ca->X     = &(CArrLast->accel[aidx]); break;
    case 2: ca->Y     = &(CArrLast->accel[aidx]); break;
    case 3: ca->Z     = &(CArrLast->accel[aidx]); break;
  }
  erg = stored_coordinates;
  stored_coordinates += 3;
  Hash[hashpos_to_replace].hx = wx;
  Hash[hashpos_to_replace].hy = wy;
  Hash[hashpos_to_replace].hz = wz;
  Hash[hashpos_to_replace].ret_val = erg;
  Hash[hashpos_to_replace].count = 0;
  if (in_hash_cnt <= hashpos_to_replace) in_hash_cnt = hashpos_to_replace + 1;
  return erg;
}

unsigned long coordinate_index(float wx, float wy, float wz)
{ struct Coords_accel *p;
  unsigned long hmv;
  int ct, i;
  hmv = 0; hashpos_to_replace = 0;
  if ((CArr == NULL) || (stored_coordinates == 0) || (BaseAccel == NULL))
    return(new_index(wx, wy, wz, 0, NULL));
  /* Try, if it is one of the last used coordinates */
  for (ct = 0; ct < in_hash_cnt; ct++) {
    if ((Hash[ct].hx == wx) && (Hash[ct].hy == wy) && (Hash[ct].hz == wz)) {
      for (i = ct; i < in_hash_cnt; i++) Hash[i].count++;
      Hash[ct].count = 0;
      hash_hit++;
      return(Hash[ct].ret_val);
    }
    if (Hash[ct].count >= hmv) {
      hashpos_to_replace = ct;
      hmv = Hash[ct].count;
    }
    Hash[ct].count++;
  }
  if (in_hash_cnt < HASHSIZE) hashpos_to_replace = in_hash_cnt;
  /* Well, now we have to scan all coordinates im memory */
  p = BaseAccel;
  while (1) {
    if (wx == p->values[0]) {
      while (1) {
        if (wy == p->values[1]) {
	  while (1) {
	    if (wz == p->values[2]) {
              Hash[hashpos_to_replace].hx = wx;
              Hash[hashpos_to_replace].hy = wy;
              Hash[hashpos_to_replace].hz = wz;
              Hash[hashpos_to_replace].ret_val = p->this_pos;
              Hash[hashpos_to_replace].count = 0;
              /* "Um herausgefallen zu sein, muessen schon alle Pos. belegt sein!"
	       * if (in_hash_cnt <= hashpos_to_replace)
	       *   in_hash_cnt = hashpos_to_replace + 1;
	       */
	      no_hash_hit++;
	      return p->this_pos;
	    } else {
	      if (p->Z == NULL) return(new_index(wx, wy, wz, 3, p));
	      p = p->Z;
	    }
	  }
	} else {
	  if (p->Y == NULL) return(new_index(wx, wy, wz, 2, p));
	  p = p->Y;
	}
      }
    } else {
      if (p->X == NULL) return(new_index(wx, wy, wz, 1, p));
      p = p->X;
    }
  }
}

void flush_facets(FILE *aus)
{ unsigned long QWordsToStore;
  unsigned long ct, swaplimit;
  if (!trianguleto.repeated) return;
  if (indexed) {
    QWordsToStore = 1L + 2L * trianguleto.repeated;
    swaplimit = 4L * trianguleto.repeated;
    trianguleto.size_n_flags = 0x10000000L + QWordsToStore;
  } else {
    QWordsToStore = 1L + 6L * trianguleto.repeated;
    swaplimit = 12L * trianguleto.repeated;
    trianguleto.size_n_flags = 0x20000000L + QWordsToStore;
  }
  if (swaped) {
    swap4(&(trianguleto.size_n_flags)); swap4(&(trianguleto.repeated));
    for (ct = 0; ct < swaplimit; ct++) swap4(&(trianguleto.d.index[ct]));
  }
  fwrite(&trianguleto, 8, QWordsToStore, aus);
  trianguleto.repeated = 0;
}

void store_endsolid(FILE *aus)
{ unsigned long QWords_to_store;
  flush_facets(aus);
  QWords_to_store = 1;
  dauxrigo.size_n_flags = 0x90000001;
  dauxrigo.There = NULL;
  if (swaped) {
    swap4(&(dauxrigo.size_n_flags));
    swap4((unsigned long*)&(dauxrigo.There));
  }
  fwrite(&dauxrigo, 1, sizeof(struct Dauxrigo), aus);
}

void store_beginsolid(FILE *aus2, char *Name)
{ unsigned long QWords_to_store;
  unsigned int Strlg;
  if (!silent) fprintf(stderr, "     Solid %s ...\n", Name);
  flush_facets(aus);
  Strlg = strlen(Name) + 3;
  while (Strlg & 3) Strlg++;
  QWords_to_store = Strlg / 4;
  nomo.Data[QWords_to_store - 1] = 0;
  nomo.n.size_n_flags = 0x80000000 + QWords_to_store;
  for (Strlg = 0; Name[Strlg]; Strlg++) {
    nomo.n.ObjectName[Strlg] = (wchar_t) ((unsigned char) Name[Strlg]);
    if (swaped) swap2(&(nomo.n.ObjectName[Strlg]));
  }
  if (swaped) swap4(&(nomo.n.size_n_flags));
  fwrite(&nomo, 8, QWords_to_store, aus2);
}

void store_set_color(FILE *aus, float r, float g, float b)
{ unsigned long QWords_to_store;
  flush_facets(aus);
  QWords_to_store = 2;
  coloro.size_n_flags = 0x40000000L + QWords_to_store;
  coloro.r = r;
  coloro.g = g;
  coloro.b = b;
  if (swaped) {
    swap4(&(coloro.size_n_flags));
    swap4((unsigned long *)&(coloro.r)); swap4((unsigned long *)&(coloro.g)); swap4((unsigned long *)&(coloro.b));
  }
  fwrite(&coloro, 1, sizeof(struct Coloro), aus);
}


void store_color_indexed(FILE *aus, unsigned long p)
{ unsigned long Words_pos;
  unsigned long QWords_to_store;
  flush_facets(aus);
  QWords_to_store = 1;
  coloratoro.size_n_flags = 1;
  coloratoro.index = p;
  if (swaped) {
    swap4(&(coloratoro.size_n_flags));
    swap4(&(coloratoro.index));
  }
  fwrite(&coloratoro, 1, sizeof(struct Coloratoro), aus);
}


void store_facet_indexed(FILE *aus, unsigned long pn, unsigned long p1, unsigned long p2, unsigned long p3)
{ unsigned long Words_pos;
  if (trianguleto.repeated >= MAX_COORDS / 4) flush_facets(aus);
  Words_pos = 4L * trianguleto.repeated;
  trianguleto.d.index[Words_pos + 0] = pn;
  trianguleto.d.index[Words_pos + 1] = p1;
  trianguleto.d.index[Words_pos + 2] = p2;
  trianguleto.d.index[Words_pos + 3] = p3;
  trianguleto.repeated++;
  total_facet_count++;
}


void store_facet_short(FILE* aus, float Nx, float Ny, float Nz, float *vx, float *vy, float *vz)
{ unsigned long Words_pos;
  int ct;
  if (trianguleto.repeated >= MAX_COORDS / 12) flush_facets(aus);
  Words_pos = 12L * trianguleto.repeated;
  if (!total_facet_count) {
    xmin = xmax = vx[0]; ymin = ymax = vy[0]; zmin = zmax = vz[0];
  }
  for (ct = 0; ct < 3; ct++) {
    if (vx[ct] < xmin) xmin = vx[ct]; else if (vx[ct] > xmax) xmax = vx[ct];
    if (vy[ct] < ymin) ymin = vy[ct]; else if (vy[ct] > ymax) ymax = vy[ct];
    if (vz[ct] < zmin) zmin = vz[ct]; else if (vz[ct] > zmax) zmax = vz[ct];
  }
  trianguleto.d.coordinates[Words_pos + 0] = Nx;
  trianguleto.d.coordinates[Words_pos + 1] = Ny;
  trianguleto.d.coordinates[Words_pos + 2] = Nz;
  trianguleto.d.coordinates[Words_pos +  3] = vx[0];
  trianguleto.d.coordinates[Words_pos +  4] = vy[0];
  trianguleto.d.coordinates[Words_pos +  5] = vz[0];
  trianguleto.d.coordinates[Words_pos +  6] = vx[1];
  trianguleto.d.coordinates[Words_pos +  7] = vy[1];
  trianguleto.d.coordinates[Words_pos +  8] = vz[1];
  trianguleto.d.coordinates[Words_pos +  9] = vx[2];
  trianguleto.d.coordinates[Words_pos + 10] = vy[2];
  trianguleto.d.coordinates[Words_pos + 11] = vz[2];
  trianguleto.repeated++;
  total_facet_count++;
}


void FlushFileIndexedSLP(FILE *ein, FILE *aus2)
{ char Data[8192];
  int sz, ct;
  unsigned long QWords_to_store;
  struct Trianguleto KK;
  struct CoordsField *p;
  KK.repeated = stored_coordinates / 3;
  if (!silent) fprintf(stderr, "%lu Koordinaten = %lu Zahlen = 0x%lx Byte\n",
    (unsigned long) KK.repeated,
    (unsigned long) stored_coordinates,
    (unsigned long) stored_coordinates * sizeof(float));
  if (!silent) fprintf(stderr, "%lu : %lu Hashtreffer in Feldgroesse %d\n",
    hash_hit, no_hash_hit, HASHSIZE);
  QWords_to_store = (stored_coordinates + 1) / 2;
  KK.size_n_flags = 0x60000001 + QWords_to_store;
  if (swaped) { swap4(&(KK.size_n_flags)); swap4(&(KK.repeated)); }
  fwrite(&KK, 1, sizeof(KK), aus2);
  p = CArr;
  while (QWords_to_store) {
    if (p != NULL) {
      if (swaped) {
        for (ct = 0; ct < MAX_COORDS; ct++) swap4((unsigned long *)&(p->coords[ct]));
      }
      fwrite(&(p->coords[0]), 8,
             (QWords_to_store > MAX_COORDS / 2) ? MAX_COORDS / 2 : QWords_to_store,
             aus2);
      p = p->next;
    }
    if (QWords_to_store > MAX_COORDS / 2)
      QWords_to_store -= (MAX_COORDS / 2);
     else
      QWords_to_store = 0;
  }
  rewind(ein);
  while ((sz = fread(Data, 1, 8192, ein)) > 0)
    fwrite(Data, 1, sz, aus2);
  /* warum nicht gleich loeschen! */
  free_coordinates();
}

int ReadFileIndexedSLP(FILE *ein, FILE *aus2)
{ char Zeile[MAX_PATH + 50], Kennwort[MAX_PATH + 50], Kennwort2[MAX_PATH + 50];
  unsigned long ZNR, pn, p1, p2, p3;
  int sw, stp = -1, STATE = -1, cv, cn, data_in_temp = 0;
  float d1, d2, d3, nx[3], ny[3], nz[3], vx[6], vy[6], vz[6], Nx, Ny, Nz, NNx, NNy, NNz; double NL;
  FILE *temp; char LTemp[MAX_PATH];
  sprintf(LTemp, "_vtf_%u.tmp", getpid());
  if ((temp = fopen(LTemp, "w+b"))== NULL) {
    fprintf(stderr, "Temporaerdatei '%s' nicht schreibbar!\n", LTemp);
    fclose(ein); Pause(); return 0;
  }
  trianguleto.repeated = 0;
  ZNR = 0;
  while (fgets(Zeile, MAX_PATH + 50, ein) != NULL) {
    if (!silent) if (!(ZNR & 0xfff)) {
      fprintf(stderr, " %5.1f %%\r", (float) ((100.0 * ftell(ein)) / ((float) FileSize)));
    }
    Kennwort[0] = '\0'; ZNR++;
    sw = sscanf(Zeile, "%s %f %f %f", Kennwort, &d1, &d2, &d3);
    if (!strcmp(Kennwort, "solid")) {
      STATE = 1;
      Kennwort2[0] = '\0';
      sscanf(Zeile, "%s %s", Kennwort, Kennwort2);
      if (data_in_temp) {
        if (!silent) fprintf(stderr, " Pass 1 ready\r");
        FlushFileIndexedSLP(temp, aus2);
        data_in_temp = 0;
	fclose(temp); unlink(LTemp);
        if ((temp = fopen(LTemp, "w+b"))== NULL) {
          fprintf(stderr, "Temporaerdatei '%s' nicht schreibbar!\n", LTemp);
          fclose(ein); Pause(); return 0;
        }
        if (!silent) fprintf(stderr, " Pass 2 ready        \n");
      }
      store_beginsolid(aus2, Kennwort2);
    } else
    if (!strcmp(Kennwort, "endsolid")) {
      STATE = 0;
      if (data_in_temp) {
        if (!silent) fprintf(stderr, " Pass 1 ready\r");
        FlushFileIndexedSLP(temp, aus2);
        data_in_temp = 0;
	fclose(temp); unlink(LTemp);
        if ((temp = fopen(LTemp, "w+b"))== NULL) {
          fprintf(stderr, "Temporaerdatei '%s' nicht schreibbar!\n", LTemp);
          fclose(ein); Pause(); return 0;
        }
        if (!silent) fprintf(stderr, " Pass 2 ready        \n");
      }
      store_endsolid(aus2);
    } else
    if (!strcmp(Kennwort, "color")) {
      if ((STATE == 1) && (sw == 4))
        if (colorindexed) {
          pn = coordinate_index(d1, d2, d3);
          store_color_indexed(temp, pn);
	} else
          store_set_color(temp, (float) d1, (float) d2, (float) d3);
	data_in_temp = 1;
    } else
    if (!strcmp(Kennwort, "facet")) {
      if (STATE == 1) {
        cn = cv = 0;
        STATE = 2;
	sw = sscanf(Zeile, "%s %s %f %f %f", Kennwort, Kennwort2, &d1, &d2, &d3);
	if ((sw == 5) && !strcmp(Kennwort2, "normal") && (cn < 3)) {
          nx[cn] = d1; ny[cn] = d2; nz[cn] = d3; cn++;
	}
      }
    } else
    if (!strcmp(Kennwort, "endfacet")) {
      if (STATE > 1) {
        if ((cv == 3) && (cn > 0)) {
	  NNx = nx[0]; NNy = ny[0]; NNz = nz[0];
	  for (sw = 1; sw < cn; sw++) {
	    NNx += nx[sw]; NNy += ny[sw]; NNz += nz[sw];
	  }
	  vx[3] = vx[1] - vx[0]; vx[4] = vx[2] - vx[1]; vx[5] = vx[0] - vx[2];
	  vy[3] = vy[1] - vy[0]; vy[4] = vy[2] - vy[1]; vy[5] = vy[0] - vy[2];
	  vz[3] = vz[1] - vz[0]; vz[4] = vz[2] - vz[1]; vz[5] = vz[0] - vz[2];
	  Nx = (vy[3] * vz[4] - vz[3] * vy[4]) + (vy[4] * vz[5] - vz[4] * vy[5]) + (vy[5] * vz[3] - vz[5] * vy[3]);
	  Ny = (vz[3] * vx[4] - vx[3] * vz[4]) + (vz[4] * vx[5] - vx[4] * vz[5]) + (vz[5] * vx[3] - vx[5] * vz[3]);
	  Nz = (vx[3] * vy[4] - vy[3] * vx[4]) + (vx[4] * vy[5] - vy[4] * vx[5]) + (vx[5] * vy[3] - vy[5] * vx[3]);
	  NL = sqrt(Nx*Nx + Ny*Ny + Nz*Nz);
	  if (NL >= 1.0e-100L) {
	    if ((d1 = Nx * NNx + Ny * NNy + Nz * NNz) > 0.0) {
            } else if (d1 < 0.0) {
	      NL *= -1.0;
	      vx[4] = vx[1]; vx[1] = vx[2]; vx[2] = vx[4];
	      vy[4] = vy[1]; vy[1] = vy[2]; vy[2] = vy[4];
	      vz[4] = vz[1]; vz[1] = vz[2]; vz[2] = vz[4];
            }
	    Nx /= NL; Ny /= NL; Nz /= NL;
	  }
          pn = coordinate_index(Nx, Ny, Nz);
          p1 = coordinate_index(vx[0], vy[0], vz[0]);
          p2 = coordinate_index(vx[1], vy[1], vz[1]);
          p3 = coordinate_index(vx[2], vy[2], vz[2]);
          store_facet_indexed(temp, pn, p1, p2, p3);
          data_in_temp = 1;
	}
        STATE = 1;
      }
    } else
    if (!strcmp(Kennwort, "outer")) {
      if (STATE == 2) STATE = 3;
    } else
    if (!strcmp(Kennwort, "endloop")) {
      if (STATE == 3) STATE = 2;
    } else
    if (!strcmp(Kennwort, "normal")) {
      if ((STATE == 2) && (sw == 4) && (cn < 3)) {
        nx[cn] = d1; ny[cn] = d2; nz[cn] = d3; cn++;
      }
    } else
    if (!strcmp(Kennwort, "vertex")) {
      if ((STATE == 3) && (sw == 4) && (cv < 3)) {
        vx[cv] = d1; vy[cv] = d2; vz[cv] = d3; cv++;
      }
    }
  }
  flush_facets(temp);
  if (data_in_temp) {
    if (!silent) fprintf(stderr, " Pass 1 ready\r");
    FlushFileIndexedSLP(temp, aus2);
    data_in_temp = 0;
    if (!silent) fprintf(stderr, " Pass 2 ready        \n");
  }
  fclose(temp); unlink(LTemp);
  return 1;
}


int ReadFileSLP(FILE *ein, FILE *aus)
{ char Zeile[MAX_PATH + 50], Kennwort[MAX_PATH + 50], Kennwort2[MAX_PATH + 50];
  unsigned long ZNR;
  int sw, stp = -1, STATE = -1, cv, cn;
  float d1, d2, d3, nx[3], ny[3], nz[3], vx[6], vy[6], vz[6], Nx, Ny, Nz, NNx, NNy, NNz; double NL;
  trianguleto.repeated = 0;
  ZNR = 0;
  while (fgets(Zeile, MAX_PATH + 50, ein) != NULL) {
    Kennwort[0] = '\0'; ZNR++;
    sw = sscanf(Zeile, "%s %f %f %f", Kennwort, &d1, &d2, &d3);
    if (!strcmp(Kennwort, "solid")) {
      STATE = 1;
      Kennwort2[0] = '\0';
      sscanf(Zeile, "%s %s", Kennwort, Kennwort2);
      store_beginsolid(aus, Kennwort2);
    } else
    if (!strcmp(Kennwort, "endsolid")) {
      STATE = 0;
      store_endsolid(aus);
    } else
    if (!strcmp(Kennwort, "color")) {
      if ((STATE == 1) && (sw == 4))
        store_set_color(aus, (float) d1, (float) d2, (float) d3);
    } else
    if (!strcmp(Kennwort, "facet")) {
      if (STATE == 1) {
        cn = cv = 0;
        STATE = 2;
	sw = sscanf(Zeile, "%s %s %f %f %f", Kennwort, Kennwort2, &d1, &d2, &d3);
	if ((sw == 5) && !strcmp(Kennwort2, "normal") && (cn < 3)) {
          nx[cn] = d1; ny[cn] = d2; nz[cn] = d3; cn++;
	}
      }
    } else
    if (!strcmp(Kennwort, "endfacet")) {
      if (STATE > 1) {
        if ((cv == 3) && (cn > 0)) {
	  NNx = nx[0]; NNy = ny[0]; NNz = nz[0];
	  for (sw = 1; sw < cn; sw++) {
	    NNx += nx[sw]; NNy += ny[sw]; NNz += nz[sw];
	  }
	  // fprintf(stderr, "NN %8.3f %8.3f %8.3f\n", NNx, NNy, NNz);
	  vx[3] = vx[1] - vx[0]; vx[4] = vx[2] - vx[1]; vx[5] = vx[0] - vx[2];
	  vy[3] = vy[1] - vy[0]; vy[4] = vy[2] - vy[1]; vy[5] = vy[0] - vy[2];
	  vz[3] = vz[1] - vz[0]; vz[4] = vz[2] - vz[1]; vz[5] = vz[0] - vz[2];
	  /*
	  { int i;
	    for (i = 0; i < 6; i++) fprintf(stderr, " %d %8.3f %8.3f %8.3f\n", i, vx[i], vy[i], vz[i]);
	  }
	  */
	  Nx = (vy[3] * vz[4] - vz[3] * vy[4]) + (vy[4] * vz[5] - vz[4] * vy[5]) + (vy[5] * vz[3] - vz[5] * vy[3]);
	  Ny = (vz[3] * vx[4] - vx[3] * vz[4]) + (vz[4] * vx[5] - vx[4] * vz[5]) + (vz[5] * vx[3] - vx[5] * vz[3]);
	  Nz = (vx[3] * vy[4] - vy[3] * vx[4]) + (vx[4] * vy[5] - vy[4] * vx[5]) + (vx[5] * vy[3] - vy[5] * vx[3]);
	  // fprintf(stderr, " X %8.3f+%8.3f+%8.3f\n", vy[3] * vz[4] - vz[3] * vy[4], vy[4] * vz[5] - vz[4] * vy[5], vy[5] * vz[3] - vz[5] * vy[3]);
	  // fprintf(stderr, " Y %8.3f+%8.3f+%8.3f\n", vz[3] * vx[4] - vx[3] * vz[4], vz[4] * vx[5] - vx[4] * vz[5], vz[5] * vx[3] - vx[5] * vz[3]);
	  // fprintf(stderr, " Z %8.3f+%8.3f+%8.3f\n", vx[3] * vy[4] - vy[3] * vx[4], vx[4] * vy[5] - vy[4] * vx[5], vx[5] * vy[3] - vy[5] * vx[3]);
	  NL = sqrt(Nx*Nx + Ny*Ny + Nz*Nz);
	  // fprintf(stderr, "xN %8.3f %8.3f %8.3f - %8.3f\n", Nx, Ny, Nz, NL);
	  if (NL >= 1.0e-100L) {
	    if ((d1 = Nx * NNx + Ny * NNy + Nz * NNz) > 0.0) {
            } else if (d1 < 0.0) {
	      NL *= -1.0;
	      vx[4] = vx[1]; vx[1] = vx[2]; vx[2] = vx[4];
	      vy[4] = vy[1]; vy[1] = vy[2]; vy[2] = vy[4];
	      vz[4] = vz[1]; vz[1] = vz[2]; vz[2] = vz[4];
            }
	    // fprintf(stderr, "xN %8.3f %8.3f %8.3f - %8.3f\n", Nx, Ny, Nz, NL);
	    Nx /= NL; Ny /= NL; Nz /= NL;
	    // fprintf(stderr, "xN %8.3f %8.3f %8.3f - %8.3f\n", Nx, Ny, Nz, NL);
	  }
	  // fprintf(stderr, " N %8.3f %8.3f %8.3f\n", Nx, Ny, Nz);
          store_facet_short(aus, Nx, Ny, Nz, vx, vy, vz);
	}
        STATE = 1;
      }
    } else
    if (!strcmp(Kennwort, "outer")) {
      if (STATE == 2) STATE = 3;
    } else
    if (!strcmp(Kennwort, "endloop")) {
      if (STATE == 3) STATE = 2;
    } else
    if (!strcmp(Kennwort, "normal")) {
      if ((STATE == 2) && (sw == 4) && (cn < 3)) {
        nx[cn] = d1; ny[cn] = d2; nz[cn] = d3; cn++;
      }
    } else
    if (!strcmp(Kennwort, "vertex")) {
      if ((STATE == 3) && (sw == 4) && (cv < 3)) {
        vx[cv] = d1; vy[cv] = d2; vz[cv] = d3; cv++;
      }
    }
  }
  flush_facets(aus);
  return 1;
}


int which_eoln(FILE *ein)
{ unsigned char C;
  unsigned long CP;
  CP = ftell(ein);
  while (fread(&C, 1, 1, ein) > 0) {
    switch(C) {
      case '\n': case '\r': 
        fseek(ein, CP, SEEK_SET);
        return 1;
      case '\0':
        fseek(ein, CP, SEEK_SET);
        return 2;
    }
  }
  fseek(ein, CP, SEEK_SET);
  return -1;
}

void ReadFileIn(char *datei, char *nach)
{ FILE *ein;
  char Kopf[8];
  total_facet_count = 0;
  if ((ein = fopen(datei, "rb")) == NULL) {
    fprintf(stderr, "Datei '%s' nicht lesbar!\n", datei);
    Pause();
    return;
  }
  Kopf[0] = '\0';
  fread(Kopf, 1, strlen(SLP_STL_ASCII_HEAD), ein);
  fseek(ein, 0L, SEEK_END); FileSize = ftell(ein); fseek(ein, 0L, SEEK_SET);
  Kopf[strlen(SLP_STL_ASCII_HEAD)] = '\0';
  if (!strcmp(Kopf, SLP_STL_ASCII_HEAD)) {
    switch(which_eoln(ein)) {
      case 1:
	if ((aus = aus2 = fopen(nach, "wb")) == NULL) {
	  fprintf(stderr, "Datei '%s' nicht schreibbar!\n", nach);
	  fclose(ein); Pause(); return;
        }
	fwrite(&head, 1, sizeof(struct HEAD), aus); swap_still_allowed = 0;
        ReadFileSLP(ein, aus);
	fclose(aus);
	if (!total_facet_count) unlink(nach);
      break;
      default:
        goto reading_unknown_type;
    }
  } else {
    reading_unknown_type:
    fprintf(stderr, "Unbekannter Datentyp!\n");
  }
  fclose(ein);
}

void ReadFileInIndexed(char *datei, char *nach)
{ FILE *ein;
  char Kopf[8], Temp[MAX_PATH];
  Temp[0] = '\0'; ein = NULL;
  total_facet_count = 0;
  if ((ein = fopen(datei, "rb")) == NULL) {
    fprintf(stderr, "Datei '%s' nicht lesbar!\n", datei);
    Pause(); return;
  }
  // sprintf(Temp, "_vtf.%u.tmp", getpid());
  Kopf[0] = '\0';
  fread(Kopf, 1, strlen(SLP_STL_ASCII_HEAD), ein);
  fseek(ein, 0L, SEEK_END); FileSize = ftell(ein); fseek(ein, 0L, SEEK_SET);
  Kopf[strlen(SLP_STL_ASCII_HEAD)] = '\0';
  if (!strcmp(Kopf, SLP_STL_ASCII_HEAD)) {
    switch(which_eoln(ein)) {
      case 1:
        // if ((aus = fopen(Temp, "wb"))== NULL) {
        //   fprintf(stderr, "Temporaerdatei '%s' nicht schreibbar!\n", Temp);
        //   fclose(ein); Pause(); return;
        // }
	if ((aus2 = fopen(nach, "wb")) == NULL) {
	  fprintf(stderr, "Datei '%s' nicht schreibbar!\n", nach);
	  fclose(ein); fclose(aus); Pause(); return;
        }
	fwrite(&head, 1, sizeof(struct HEAD), aus2); swap_still_allowed = 0;
        ReadFileIndexedSLP(ein, aus2);
        fclose(ein); /* fclose(aus);
        if ((ein = fopen(Temp, "rb")) == NULL) {
          fprintf(stderr, "Temporaerdatei '%s' nicht lesbar!\n", Temp);
          Pause(); return;
        }
        FlushFileIndexedSLP(ein, aus2);
	*/
	fclose(aus2); fclose(ein); ein = NULL;
        // unlink(Temp);
	if (!total_facet_count) unlink(nach);
        // if (!silent) fprintf(stderr, " Pass 2 ready        \n");
      break;
      default:
        goto reading_unknown_type;
    }
  } else {
    reading_unknown_type:
    fprintf(stderr, "Unbekannter Datentyp!\n");
  }
  if (ein != NULL) fclose(ein);
}

void ask_if_indexed(void)
{ int wahl = 2;
  char Zeile[50];
  fprintf(stderr, "\nErzeugungsoptionen:         Conversion options:\n");
  fprintf(stderr, " 1 = einfach                 1 = simple\n");
  fprintf(stderr, " 2 = mit Koordinatentabelle  2 = with coordinate table\n");
  fprintf(stderr, " 3 = zus. Farbtabelle        3 = with color and coordinate table\n");
  fprintf(stderr, " 0 = ABBRUCH                 0 = ABORT\n");
  fprintf(stderr, " Ihre Wahl / your selection? [%d]? ", wahl);
  Zeile[0] = '\0'; fgets(Zeile, 50, stdin); sscanf(Zeile, "%d", &wahl);
  switch(wahl) {
    case 1: indexed = 0; colorindexed = 0; break;
    case 2: indexed = 1; colorindexed = 0; break;
    case 3: indexed = 1; colorindexed = 1; break;
    case 0: exit(0);
  }
}

int main(int argc, char **argv)
{ int ct, argp;
  char Erg[MAX_PATH + 3], LongPath[MAX_PATH + 3], *FileIn;
#ifdef _WIN32
  HANDLE Find; WIN32_FIND_DATA fd;
#endif
  int auto_name = 0;
#ifdef _WIN32
  unsigned long s_time, e_time;
  s_time = GetTickCount();
  // fprintf(stderr, ">>> %s <<<\npwd = %s\n", GetCommandLine(), getcwd(NULL, MAX_PATH));
#endif
  if (argc < 3) {
    if (argc == 2) { /* Dialogmodus */
#ifdef _WIN32
      Find = FindFirstFile(argv[1], &fd);
      LongPath[0] = '\0'; GetFullPathName(argv[1], MAX_PATH + 3, LongPath, &FileIn);
      if (LongPath[0]) {
        strcpy(FileIn, fd.cFileName);
        FileIn = LongPath;
      } else FileIn = argv[1];
#else
      FileIn = argv[1];
#endif
      strcpy(Erg, FileIn);
      for (ct = strlen(Erg) - 1; ct >= 0; ct--) {
        switch (Erg[ct]) {
          case '.':
            strcpy(&(Erg[ct]), ".vtf");
            ct = -1;
          break;
          case '\\':
            strcat(Erg, ".vtf");
            ct = -1;
          break;
        }
      }
      if (strcmp(Erg, FileIn)) {
        fprintf(stderr, "  %s -> %s ...\n", FileIn, Erg);
	if (access(Erg, 0) >= 0) fprintf(stderr, "\nA C H T U N G ! ! !   W A R N I N G ! ! !\n"
            "\nDatei wird ueberschrieben!   Output file will be replaced!\n");
	indexed = 1; ask_if_indexed();
        if (indexed) ReadFileInIndexed(FileIn, Erg);
         else ReadFileIn(FileIn, Erg);
      }
#ifdef _WIN32
      FindClose(Find);
      e_time = GetTickCount();
      e_time -= s_time;
      s_time = e_time % 60000L;
      if (!silent) fprintf(stderr, "%lu Min., %lu Sek., %lu ms\n",
        e_time / 60000L, s_time / 1000L, s_time % 1000L);
#endif
      return 0;
    } else {
      fprintf(stderr, "Zu wenig Argumente!\n");
      fprintf(stderr, "Gebrauch:\n"
                      "  slp2vtf [-index] [-silent] [-swap] <SLP-Datei-'von'> <VTF-Datei-'nach'>\n"
                      "  slp2vtf [-colorindex] [-silent] [-swap] <SLP-Datei-'von'> <VTF-Datei-'nach'>\n"
                      "  slp2vtf [-auto] [-index] [-silent] [-swap] <SLP-Datei(en)-'von'>\n"
                      "  slp2vtf [-auto] [-colorindex] [-silent] [-swap] <SLP-Datei(en)-'von'>\n");
      Pause(); return 1;
    }
  }
  for (argp = 1; argp < argc; argp++) {
    if (argv[argp][0] == '-') {
      if (!strcmp(argv[argp], "-auto"))   auto_name = 1;
      if (!strcmp(argv[argp], "-index"))  indexed = 1;
      if (!strcmp(argv[argp], "-silent")) silent = 1;
      if (!strcmp(argv[argp], "-swap") && swap_still_allowed) { swaped = 1 - swaped;
        swap2(&(head.us)); swap4(&(head.ul));
	swap4((unsigned long *)&(head.f)); swap8((unsigned __int64 *)&(head.d));
      }
      if (!strcmp(argv[argp], "-colorindex")) { indexed = 1, colorindexed = 1; }
    } else {
      if (auto_name) {
#ifdef _WIN32
        Find = FindFirstFile(argv[argp], &fd);
        LongPath[0] = '\0'; GetFullPathName(argv[argp], MAX_PATH + 3, LongPath, &FileIn);
        if (LongPath[0]) {
          strcpy(FileIn, fd.cFileName);
          FileIn = LongPath;
        } else FileIn = argv[argp];
#else
        FileIn = argv[argp];
#endif
        strcpy(Erg, FileIn);
        for (ct = strlen(Erg) - 1; ct >= 0; ct--) {
          switch (Erg[ct]) {
            case '.':
	      strcpy(&(Erg[ct]), ".vtf");
	      ct = -1;
	    break;
	    case '\\': case '/': case ':':
	      strcat(Erg, ".vtf");
	      ct = -1;
	    break;
	  }
        }
        if (strcmp(Erg, FileIn)) {
          if (!silent) fprintf(stderr, "  %s -> %s ...\n", FileIn, Erg);
          if (indexed) ReadFileInIndexed(FileIn, Erg);
           else ReadFileIn(FileIn, Erg);
        }
#ifdef _WIN32
        FindClose(Find);
#endif
      } else {
        if (indexed) ReadFileInIndexed(argv[argp], argv[argp + 1]);
          else ReadFileIn(argv[argp], argv[argp + 1]);
#ifdef _WIN32
  e_time = GetTickCount();
  e_time -= s_time;
  s_time = e_time % 60000L;
  if (!silent) fprintf(stderr, "%lu Min., %lu Sek., %lu ms\n",
    e_time / 60000L, s_time / 1000L, s_time % 1000L);
#endif
        return 0;
      }
    }
  }
#ifdef _WIN32
  e_time = GetTickCount();
  e_time -= s_time;
  s_time = e_time % 60000L;
  if (!silent) fprintf(stderr, "%lu Min., %lu Sek., %lu ms\n",
    e_time / 60000L, s_time / 1000L, s_time % 1000L);
#endif
  return 0;
}

