/* low end viewer for triangulation files
 * a short description of the <<.vtf>> files see function definition GraphicsDataInterpretation()
 */
#define UNICODE
#include <windows.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <wchar.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <sys/stat.h>
#include <math.h>
#include <process.h>
#include <errno.h>
#include "esperanto.h"
#include "s_text.c"
#include "dlg_utils.c"
extern int errno;

#define L_Version_string L"0.0"

#define INTERNAL_LANG_ESPERANTO        0
#define INTERNAL_LANG_ESPERANTO_XCODED 1
#define INTERNAL_LANG_GERMAN           2
#define INTERNAL_LANG_ENGLISH          3
#define STARTUP_DEFAULT_LANG INTERNAL_LANG_ESPERANTO

#define NO_DUMP_MAT
#define NO_CUBE
#define NO_FADEN_1
#define NO_FADEN_2
#define NO_DUMP_VIEW_DATA
#define NE_KUN_STATISTIKO
#define NO_DUMP_MODEL_SELECT_RECORDS
#ifdef FADEN_1
#define FADEN_INIT
#endif
#ifdef FADEN_2
#define FADEN_INIT
#endif

#ifdef DUMP_MAT
FILE *trail = NULL;
#endif

#define	MdlDispClassName    L"RTD_Models"
#define	AboutClassName      L"RTD_About"
#define ThisClassName       L"RigardiloTriangularajDosieroj"
#define ThisWindowName      L"Rigardilo por triangularaj dosieroj"
#define ThisWindowNameGer   L"Triangulationsdateienbetrachter"
#define ThisWindowNameEng   L"Triangulation File Viewer"
#define RegistryBaseDir     L"Software\\Arnold.WENDL-Fuerth\\rtd"
#define RegistryDir RegistryBaseDir L"\\" L_Version_string
wchar_t *RevHistory[] = { L"0.0pre", L"0.0", NULL };
wchar_t *KeywordHistory[] = { L"malantauxo rugxona", L"malantauxo verdona",
                              L"malantauxo bluona", L"openGl listoj",
                              L"malantauxa edro" L"montri centro", L"dimensio", L"X kodo", L"lingvo",
                              L"simplaj coloroj", L"helaj korpoj", L"anstatauxaj prog", L"muso", NULL };

#define SLP_STL_ASCII_HEAD "solid "
#define VTF_ASCII_HEAD "triangulara dosiero (.vtf)\r\n\32"

#define Title1en L"LOW END"
#define Title2en L"TRIANGULATION FILE"
#define Title3en L"VIEWER"
#define Title1eo L"KAPABLETA"
#define Title2eo L"RIGARDILO POR"
#define Title3eo L"TRIANGULARAJ DOSIEROJ"
#define Versn_en L"Version " L_Version_string
#define Versn_eo L"Versio " L_Version_string
#define VSW 0.70F
#define VSC 3.45F

#define MN_FILE_OPEN 201
#define MN_FILE_SAVE 202
#define MN_FILE_QUIT 203
#define MN_VIEW_LEFT   210
#define MN_VIEW_FRONT  211
#define MN_VIEW_RIGHT  212
#define MN_VIEW_BACK   213
#define MN_VIEW_TOP    214
#define MN_VIEW_BOTTOM 215
#define MN_VIEW_ISO    216
#define MN_VIEW_DI     217
#define MN_VIEW_TRI    218
#define MN_ZOOM_PLUS   220
#define MN_ZOOM_MINUS  221
#define MN_ZOOM_FIT    222
#define MN_PART_DISP   230
#define MN_MOUSE_L_INV 231
#define MN_MOUSE_M_INV 232
#define MN_MOUSE_R_INV 233
#define MN_REPAINT     239    /* invisible */
#define MN_SET_BACKGRND  240
#define MN_SET_LIGHTY    241
#define MN_SET_SIMPLCOL  242
#define MN_SET_LISTS     243
#define MN_SET_WIREFRAME 244
#define MN_SET_CULL      245
#define MN_SET_CS        246
#define MN_SET_EXTEND    247
#define MN_SET_CALLEXIT  248
#define RT_SET_LANG      249  /* object dialog window */
#define MN_SET_LANG_EO   350
#define MN_SET_LANG_EOX  351
#define MN_SET_LANG_GER  352
#define MN_SET_LANG_ENG  353
#define MN_INFO          299
#define RT_CLEAR_CHECKBOXES 170
#define RT_BUILD_CHECKBOXES 171
#define MN_OBJECT_ZERO   300

#define PROJ_LAST   0
#define PROJ_FRONT  1
#define PROJ_LEFT   2
#define PROJ_TOP    3
#define PROJ_BOTTOM 4
#define PROJ_RIGHT  5
#define PROJ_BACK   6
#define PROJ_ISO    7
#define PROJ_DI     8
#define PROJ_TRI    9

int Argc;
wchar_t **Argv;
int CmdLineFileRead = 0, CmdLineFirstFileBasenameStart = 0,
                         CmdLineFirstFileExtensionStart = 0;
HICON MyIcon, MySmallIcon;
HINSTANCE hThisInstance;

struct ES_DIALOG_DATA {
  int record_size;
  int prompt_launching;
  struct PER_FILETYPE {
    int enabled;
    wchar_t Program[MAX_PATH], ProgramBasename[MAX_PATH];
    int with_optional_param;
    wchar_t OptionalParam[MAX_PATH];
  } VtfSlpStl[3];
} ES_Settings;

void Clear_ES_Settings(void)
{ memset(&ES_Settings, 0, sizeof(struct ES_DIALOG_DATA));
  ES_Settings.record_size = sizeof(struct ES_DIALOG_DATA);
  ES_Settings.prompt_launching = 1;
}

int compact_ES_Data(wchar_t *z, struct ES_DIALOG_DATA *dd)
{ int erg, i;
  erg = 0;
  z[erg] = dd->record_size;      erg++;
  z[erg] = dd->prompt_launching; erg++;
  for (i = 0; i < 3; i++) {
    z[erg] = dd->VtfSlpStl[i].enabled; erg++;
    wcsncpy(&(z[erg]), dd->VtfSlpStl[i].Program,         MAX_PATH); z[erg + MAX_PATH - 1] = 0;
     erg += wcslen(&(z[erg])) + 1;
    wcsncpy(&(z[erg]), dd->VtfSlpStl[i].ProgramBasename, MAX_PATH); z[erg + MAX_PATH - 1] = 0;
     erg += wcslen(&(z[erg])) + 1;
    z[erg] = dd->VtfSlpStl[i].with_optional_param; erg++;
    wcsncpy(&(z[erg]), dd->VtfSlpStl[i].OptionalParam,   MAX_PATH); z[erg + MAX_PATH - 1] = 0;
     erg += wcslen(&(z[erg])) + 1;
  }
  return erg;
}

int uncompact_ES_Data(struct ES_DIALOG_DATA *dd, wchar_t *z)
{ int pos, i;
  pos = 0;
  if (z[0] != sizeof(struct ES_DIALOG_DATA)) return 0;
  memset(dd, 0, sizeof(struct ES_DIALOG_DATA));
  dd->record_size = z[0]; 
  dd->prompt_launching = z[1]; pos = 2;
  for (i = 0; i < 3; i++) {
    dd->VtfSlpStl[i].enabled = z[pos]; pos++;
    wcsncpy(dd->VtfSlpStl[i].Program,         &(z[pos]), MAX_PATH); pos += wcslen(&(z[pos])) + 1;
    wcsncpy(dd->VtfSlpStl[i].ProgramBasename, &(z[pos]), MAX_PATH); pos += wcslen(&(z[pos])) + 1;
    dd->VtfSlpStl[i].with_optional_param = z[pos]; pos++;
    wcsncpy(dd->VtfSlpStl[i].OptionalParam,   &(z[pos]), MAX_PATH); pos += wcslen(&(z[pos])) + 1;
  }
  return 1;
}

#ifdef FADEN_INIT
void cPrintfI(char *fmt, int i)
{ char Zeile[300]; wchar_t WZ[300];
  int erg;
  sprintf(Zeile, fmt, i); wsprintf(WZ, L"%S", Zeile);
  WriteConsole(GetStdHandle(STD_OUTPUT_HANDLE), WZ, strlen(Zeile), &erg, NULL); 
}

void cPrintfF(char *fmt, float i)
{ char Zeile[300]; wchar_t WZ[300];
  int erg;
  sprintf(Zeile, fmt, i); wsprintf(WZ, L"%S", Zeile);
  WriteConsole(GetStdHandle(STD_OUTPUT_HANDLE), WZ, strlen(Zeile), &erg, NULL); 
}
#else
#define cPrintfI(a, b) 
#define cPrintfF(a, b) 
#undef DUMP_VIEW_DATA
#endif

/* if not UNICODE font prefere this set to TRUE: */
X_CODING = STARTUP_DEFAULT_LANG;

/* simple color */
simple_color = 0;

/* more lighty colors */
lighty_models = 0;

/* opposite mouse actions */
mouse_inversion = 0;

/* Startup projection */
int Projection = PROJ_TRI;

/* Background color */
#define BG_R 0
#define BG_G 0
#define BG_B 64
DWORD SBG_R = BG_R, SBG_G = BG_G, SBG_B = BG_B;
GLclampf bg_r = BG_R / 255.0F, bg_g = BG_G / 255.0F, bg_b = BG_B / 255.0F;
COLORREF Farbfeld[16] = {
    RGB(BG_R, BG_G, BG_B), RGB(BG_R, BG_G, BG_B),
    RGB(BG_R, BG_G, BG_B), RGB(BG_R, BG_G, BG_B),
    RGB(BG_R, BG_G, BG_B), RGB(BG_R, BG_G, BG_B),
    RGB(BG_R, BG_G, BG_B), RGB(BG_R, BG_G, BG_B),
    RGB(BG_R, BG_G, BG_B), RGB(BG_R, BG_G, BG_B),
    RGB(BG_R, BG_G, BG_B), RGB(BG_R, BG_G, BG_B),
    RGB(BG_R, BG_G, BG_B), RGB(BG_R, BG_G, BG_B),
    RGB(BG_R, BG_G, BG_B), RGB(BG_R, BG_G, BG_B) };

/* Options modified */
int options_altered = 0;

/* Show CS at startup */
int Disp_CS = 1;

/* Show Extend at startup */
int Disp_Extend = 0;

/* Off course, no WIREFRAME display at startup */
int Wireframe = 0;

/* Cullface at startup */
int CullFace = 0;

/* Use openGL lists */
int UseLists = 0, RebuildLists = 1;

/* Keep Border? */
#define RANDFAKTOR 1.05

/* GL lightning parameters */
GLfloat specular  [] = { 1.0F, 1.0F, 1.0F, 1.0F };
GLfloat shininess [] = { 70.0F };
GLfloat position  [] = { 0.0F, 0.0F, 50.0F, 0.0F };
GLfloat position0 [] = {-10.0F, 15.0F, 50.0F, 0.0F };
GLfloat ambient   [] = { 0.15F, 0.15F, 0.15F, 1.0F };
GLfloat diffuse   [] = { 0.35F, 0.35F, 0.35F, 1.0F };

HWND hwndApplication, hwndObjectDisplayDialog = NULL;
HGLRC hglrc;
HMENU optionsmenu, filemenu, viewmenu, mousemenu, langmenu = NULL;

#ifdef CUBE
#define VersX 10.0
#define VersY 20.0
#define VersZ 70.0
#define a_halb 1.5
#endif


int short_in_mapping, long_in_mapping, float_in_mapping, double_in_mapping;

int SWAPING[8][8] = {
  { 0, 1, 2, 3, 4, 5, 6, 7 },
  { 1, 0, 3, 2, 5, 4, 7, 6 },
  { 2, 3, 0, 1, 6, 7, 4, 5 },
  { 3, 2, 1, 0, 7, 6, 5, 4 },
  { 4, 5, 6, 7, 0, 1, 2, 3 },
  { 5, 4, 7, 6, 1, 0, 3, 2 },
  { 6, 7, 4, 5, 2, 3, 0, 1 },
  { 7, 6, 5, 4, 3, 2, 1, 0 } };

union SWAP2 {
  unsigned short us;
  short          s;
  unsigned char  c[2];
};

union SWAP4 {
  unsigned long ul;
  long          l;
  float         f;
  unsigned char c[4];
};

union SWAP8 {
  unsigned __int64 uxl;
  __int64          xl;
  double           d;
  unsigned char    c[8];
};

/* Extend of the model */
GLdouble xmin, xmax,  ymin, ymax,  zmin, zmax;
unsigned long total_facet_count;
/* center, diagonal and required scaling to fit into the screen */
GLdouble xc, yc, zc, scale, halfdiagonal;
double view_scale = 1.0, view_x = 0.0, view_y = 0.0;
#define DefaultZoomFaktor sqrt(sqrt(8.0))
#define MaxZoomFaktor 512.0

/* screen size info */
float screen_center_x, screen_center_y, screen_size;

/* Saved Model Matrix (rotation only) */
GLdouble MVMat[16];

wchar_t *StrByLang(int lang, ...)
{ int ct;
  wchar_t *erg, *next;
  va_list ap;

  erg = NULL;
  va_start(ap, lang);
  for (ct = 0;; ct++) {
    next = va_arg(ap, wchar_t *);
    if (next == NULL) { va_end(ap); return erg; }
    if (wcscmp(next, L"\xffff")) erg = next;
    if (ct == lang) { va_end(ap); return erg; }
  }
  /* va_end(ap); return erg; */
}

float TFloatByLang(int lang, ...)
{ int ct;
  long erg, next;
  va_list ap;

  erg = 0L;
  va_start(ap, lang);
  for (ct = 0;; ct++) {
    next = va_arg(ap, long);
    if (next == 0L) { va_end(ap); return((float) erg / 1000.0F); }
    erg = next;
    if (ct == lang) { va_end(ap); return((float) erg / 1000.0F); }
  }
  /* va_end(ap); return erg; */
}

#define LangWindowName StrByLang(X_CODING, ThisWindowName, L"\xffff", ThisWindowNameGer, ThisWindowNameEng, NULL)

#ifdef DUMP_MAT
void dump_Mat(void)
{ int z, s;
  if (trail == NULL) return;
  fprintf(trail, "\n");
  for (z = 0; z < 4; z++) {
    for (s = 0; s < 16; s += 4)
      fprintf(trail, "%8.4lf  ", (double) MVMat[s + z]);
    fprintf(trail, "\n");
  }
  fflush(trail);
}
#else
#define dump_Mat()
#endif

float scol_r, scol_g, scol_b;

void SimpleColorSave(float r, float g, float b)
{ scol_r = r; scol_g = g; scol_b = b;
}

void SimpleColorSetNormal(double nx, double ny, double nz)
{ double px, py, pz;
  float dir;
  px = MVMat[0] * nx + MVMat[4] * ny + MVMat[ 8] * nz;
  py = MVMat[1] * nx + MVMat[5] * ny + MVMat[ 9] * nz;
  pz = MVMat[2] * nx + MVMat[6] * ny + MVMat[10] * nz;
  dir = (float) pow(pz * pz / ( px * px + py * py + pz * pz), 0.4);
  if (lighty_models) glColor3f(dir * (0.5F + 0.5F * scol_r),
		               dir * (0.5F + 0.5F * scol_g),
			       dir * (0.5F + 0.5F * scol_b));
   else glColor3f(dir * scol_r, dir * scol_g, dir * scol_b);
}

struct Nomo {
  unsigned long size_n_flags;
  wchar_t ObjectName[0];
}; /* 1/2 * 8 bytes + x */

struct Dauxrigo {
  unsigned long size_n_flags;
  void * There;
}; /* 1 * 8 bytes */

struct Triangulo {
  unsigned long size_n_flags;
  unsigned long repeated;
  double        coordinates[0];
}; /* 1 * 8 bytes + n * 8 bytes */

struct Trianguleto {
  unsigned long size_n_flags;
  unsigned long repeated;
  float         coordinates[0];
}; /* 1 * 8 bytes + n / 2 * 8 bytes */

struct Triangulatoro {
  unsigned long size_n_flags;
  unsigned long repeated;
  unsigned long index[0];
}; /* 1 * 8 bytes + n / 2 * 8 bytes */

struct Coloro {
  unsigned long size_n_flags;
  float r, g, b;
}; /* 16 bytes = 2 * 8 bytes */

union Unu {
  struct Coloro        coloro;
  struct Triangulo     triangulo;
  struct Trianguleto   trianguleto;
  struct Triangulatoro triangulatoro;
  struct Dauxrigo      dauxrigo;
  struct Nomo          nomo;
  unsigned __int64     Data[1];
};

struct Memorilo {
  struct Memorilo *next_block;
  unsigned long capacity;
  unsigned long next_free;
  void *        next_free_p;
  unsigned __int64 Data[0];
} *TDate = NULL, *TDate_Current = NULL;

void swap2(void *dta, int mode)
{ union SWAP2 erg;
  int ct;
  for (ct = 0; ct < 2; ct++) erg.c[SWAPING[mode][ct]] = ((union SWAP2 *) dta)->c[ct];
  ((union SWAP2 *) dta)->us = erg.us;
}

void swap4(void *dta, int mode)
{ union SWAP4 erg;
  int ct;
  for (ct = 0; ct < 4; ct++) erg.c[SWAPING[mode][ct]] = ((union SWAP4 *) dta)->c[ct];
  ((union SWAP4 *) dta)->ul = erg.ul;
}

void swap8(void *dta, int mode)
{ union SWAP8 erg;
  int ct;
  for (ct = 0; ct < 8; ct++) erg.c[SWAPING[mode][ct]] = ((union SWAP8 *) dta)->c[ct];
  ((union SWAP8 *) dta)->uxl = erg.uxl;
}

struct HEAD {
  unsigned char t[30];
  wchar_t       us;
  unsigned long ul;
  float         f;
  double        d;
};

/* How many valid models */
int VALID_MODELS = 0, IN_FILE_DIALOG = 0;
int ObjectsShowAll = 1, stored_model_references = 0;

struct MODEL_SELECT {
  union Unu *Start;
  wchar_t *Name;
  union Unu *ValidCoords;
  int ValidCoordType;
  int Number, Display;
  HWND Checkbox;
  struct MODEL_SELECT *next;
} *model_select_chain = NULL, *model_select_chain_last;

#ifdef DUMP_MODEL_SELECT_RECORDS
void DumpModelSelectRecord(void)
{ struct MODEL_SELECT *ms;
  wchar_t T[3000];
  int ct = 0;
  wcscpy(T, L"model_select_chain:");
  for (ms = model_select_chain; ms != NULL; ms = ms->next) {
    wsprintf(&(T[wcslen(T)]), L"\n%d: \"%s\" CA(%d)-<%.8lx> @%.8lx Disp=%d",
      ms->Number,
      (ms->Name == NULL) ? L"<null>" : ms->Name,
      ms->ValidCoordType, (unsigned long) (ms->ValidCoords), (unsigned long) ms->Start,
      ms->Display);
    ct++;
  }
  wsprintf(&(T[wcslen(T)]), L"\n< %d >\nstored_model_references = %d\nVALID_MODLES = %d ",
    ct, stored_model_references, VALID_MODELS);
  MessageBox(NULL, T, L"msc", MB_ICONINFORMATION | MB_OK);
}
#endif

int AddModelSelectRecord(void)
{ struct MODEL_SELECT *neu;
  if ((neu = malloc(sizeof(struct MODEL_SELECT))) == NULL) return 0;
  neu->Start = NULL; neu->Name = NULL; neu->Number = 0; neu->Display = -1;
  neu->ValidCoords = NULL; neu->ValidCoordType = -1;
  neu->Checkbox = NULL; neu->next = NULL;
  if (model_select_chain == NULL) model_select_chain = neu;
  else
  if (model_select_chain_last != NULL) model_select_chain_last->next = neu;
  model_select_chain_last = neu;
  return 1;
}

void AddModelReference(union Unu *Strt, wchar_t *Nm, union Unu *VC, int VCT)
{ struct MODEL_SELECT *ms;
  for (ms = model_select_chain; ms != NULL; ms = ms->next) {
    if (ms->Name == NULL) goto add_there;
  }
  if (!AddModelSelectRecord()) return;
  ms = model_select_chain_last;
  add_there:
  if (ms == NULL) return;
  ms->Number = ++stored_model_references;
  ms->Name = Nm; ms->Start = Strt;
  ms->ValidCoords = VC; ms->ValidCoordType = VCT;
  // { wchar_t T[9]; wsprintf(T, L"%d", __LINE__); MessageBox(NULL, T, L"Trail", MB_ICONINFORMATION | MB_OK); }
  /*
  { wchar_t T[300];
    wsprintf(T, L"Solid '%s'", Nm);
    MessageBox(NULL, T, L"Addig Model Reference (Start Pointer)", MB_ICONINFORMATION | MB_OK);
  }
  */
}

void UnlinkModelSelectItems(void)
{ struct MODEL_SELECT *sm;
  if (hwndObjectDisplayDialog == NULL) return;
  for (sm = model_select_chain; sm != NULL; sm = sm->next) {
    if (sm->Checkbox != NULL) {
      ShowWindow(sm->Checkbox, SW_HIDE);
      sm->Display = -1;
    }
  }
}

void ClearModelSelectItems(void)
{ struct MODEL_SELECT *sm;
  for (sm = model_select_chain; sm != NULL; sm = sm->next) {
    sm->Name = NULL; sm->Start = NULL;
    sm->Number = 0;
    sm->ValidCoords = NULL; sm->ValidCoordType = -1;
  }
  stored_model_references = 0;
}


void Initialize_Local_Parameters(void)
{ wchar_t *T;
  Clear_ES_Settings();
  if ((T = _wgetenv(L"mylang")) == NULL) T = _wgetenv(L"LANG");
  if (T != NULL) {
    if (!wcscmp(T, L"esperanto")) X_CODING = 0;
    else
    if (!wcscmp(T, L"esperanto-x")) X_CODING = 1;
    else
    if (!wcscmp(T, L"german")) X_CODING = 2;
    else
    if (!wcscmp(T, L"english")) X_CODING = 3;
  }
}

void try_launching(int typeno, wchar_t *datei)
{ int erg; wchar_t T[100 + 2 * MAX_PATH];
  if (ES_Settings.prompt_launching) {
    wsprintf(T, StrByLang(X_CODING,
	        US_CX L"u apertas dosiero \273%s\253 kun programon \273%s\253?",
	        L"Cxu apertas dosiero \273%s\253 kun programon \273%s\253?",
		L"Datei '%s' mit Programm '%s' ffnen?",
		L"To open file '%s' launch program '%s' now?", NULL),
		datei, ES_Settings.VtfSlpStl[typeno].Program);
    if (MessageBox(hwndApplication, T, StrByLang(X_CODING,
	                                         L"nekonata enhavo en tiu " US_cx L"i dosiero!",
                                                 L"nekonata enhavo en tiu cxi dosiero!",
			                         L"unbekanntes Dateiformat in dieser Datei!",
			                         L"this file is an unknown file format!",
			                         NULL),
                   MB_ICONQUESTION | MB_YESNOCANCEL) != IDYES) return;
  }
  if (ES_Settings.VtfSlpStl[typeno].with_optional_param)
    erg = _wexecl(ES_Settings.VtfSlpStl[typeno].Program,
                  ES_Settings.VtfSlpStl[typeno].ProgramBasename,
                  ES_Settings.VtfSlpStl[typeno].OptionalParam,
	          datei, NULL);
   else
    erg = _wexecl(ES_Settings.VtfSlpStl[typeno].Program,
                  ES_Settings.VtfSlpStl[typeno].ProgramBasename,
	          datei, NULL);
  if (erg) {
    switch (errno) {
      case EACCES:  wsprintf(T, L"(%d) \"%s\"", errno, StrByLang(X_CODING,
                             L"alira eraro", L"\xffff",
                             L"Zugriff verweigert",
			     L"No access", NULL));
                    break;
      case EMFILE:  wsprintf(T, L"(%d) \"%s\"", errno, StrByLang(X_CODING,
                             L"tro multe da malfermaj dosieroj", L"\xffff",
                             L"Zu viele offene Dateien",
			     L"Too many open files", NULL));
                    break;
      case ENOENT:  wsprintf(T, L"(%d) \"%s\"", errno, StrByLang(X_CODING,
                             L"ne trovas dosieron a" US_ux L" ser" US_cx L"vojo",
                             L"ne trovas dosieron aux sercxvojo",
                             L"Pfad oder Dateiname nicht gefunden",
			     L"Path of file name not found", NULL));
                    break;
      case ENOEXEC: wsprintf(T, L"(%d) \"%s\"", errno, StrByLang(X_CODING,
                             L"eraro da pretigo de \273EXEC\253", L"\xffff",
                             L"Falsches EXEC-Dateiformat",
			     L"Exec format error", NULL));
                    break;
      case ENOMEM:  wsprintf(T, L"(%d) \"%s\"", errno, StrByLang(X_CODING,
                             L"tro malmulte da storo", L"\xffff",
                             L"Zu wenig freier Speicher",
			     L"Not enough memory", NULL));
                    break;
      default:      wsprintf(T, L"%s %d", StrByLang(X_CODING,
                             L"Eraro No.", L"\xffff",
                             L"Fehler Nummer ",
			     L"Error number ", NULL), errno);
                    break;
    }
    MessageBox(hwndApplication, T, StrByLang(X_CODING,
                                             L"eraro da starto de aplika programo", L"\xffff",
					     L"Applikationsstartfehler:",
					     L"Launching Error:", NULL),
               MB_OK | MB_ICONINFORMATION);
  }
}

int ItsVTFtype(FILE *ein, int *short_in_mapping, int *long_in_mapping,
                int *float_in_mapping, int *double_in_mapping)
{ int test, gl, p;
  union SWAP2 /* us, s, c[2]      */ s2, S2;
  union SWAP4 /* ul, l, f, c[4]   */ s4, S4;
  union SWAP8 /* uxl, xl, d, c[8] */ s8, S8;
  struct HEAD head;
  head.t[29] = 1;
  fread(&head, 1, sizeof(struct HEAD), ein); fseek(ein, 0L, SEEK_SET);
  if (head.t[29]) return 0;
  if (strcmp(head.t, VTF_ASCII_HEAD)) return 0;
  /* the lower byte of the short word must be greater */
  s2.us = head.us; S2.us = 1;
  if (s2.c[0] == s2.c[1]) return 0;
  if (s2.c[0] > s2.c[1]) { s2.c[0] = 1; s2.c[1] = 0; } else { s2.c[0] = 0; s2.c[1] = 1; }
  *short_in_mapping = -1;
  for (test = 0; test < 2; test++) {
    gl = 1;
    for (p = 0; p < 2; p++) {
      if (s2.c[SWAPING[test][p]] != S2.c[p]) gl = 0;
    }
    if (gl) { *short_in_mapping = test; test = 9; }
  }
  if (*short_in_mapping < 0) return 0;
  /* the bytes of the long word must match exactly */
  s4.ul = head.ul; S4.ul = 987654321L;
  *long_in_mapping = -1;
  for (test = 0; test < 4; test++) {
    gl = 1;
    for (p = 0; p < 4; p++) {
      if (s4.c[SWAPING[test][p]] != S4.c[p]) gl = 0;
    }
    if (gl) { *long_in_mapping = test; test = 9; }
  }
  if (*long_in_mapping < 0) return 0;
  /* the bytes of the float must match exactly */
  s4.f = head.f; S4.f = 7654321.0F;
  *float_in_mapping = -1;
  for (test = 0; test < 4; test++) {
    gl = 1;
    for (p = 0; p < 4; p++) {
      if (s4.c[SWAPING[test][p]] != S4.c[p]) gl = 0;
    }
    if (gl) { *float_in_mapping = test; test = 9; }
  }
  if (*float_in_mapping < 0) return 0;
  /* the bytes of the double must match exactly */
  s8.d = head.d; S8.d = 9876543210123456.0;
  *double_in_mapping = -1;
  for (test = 0; test < 8; test++) {
    gl = 1;
    for (p = 0; p < 8; p++) {
      if (s8.c[SWAPING[test][p]] != S8.c[p]) gl = 0;
    }
    if (gl) { *double_in_mapping = test; test = 9; }
  }
  if (*double_in_mapping < 0) return 0;
  /* success */
  return 1;
}

void clear_triangulation(void)
{ struct Memorilo *This, *Next;
  for (This = TDate; This != NULL; This = Next) {
    Next = This->next_block;
    free(This);
  }
  TDate = NULL; TDate_Current = NULL;
}

void alloc_memory_block(unsigned long how_much)
{ unsigned long words_to_align, bytes_to_align;
  struct Memorilo *neu;
  words_to_align = (how_much < 20L) ? 65536L : how_much;
  bytes_to_align = 8L * words_to_align + sizeof(struct Memorilo);
  if ((neu = malloc(bytes_to_align)) == NULL) {
    return;
  }
  neu->next_block = NULL;
  neu->capacity = words_to_align;
  neu->next_free = 0;
  neu->next_free_p = &(neu->Data[0]);
  if (TDate_Current != NULL) {
    TDate_Current->next_block = neu;
    ((struct Dauxrigo *) (TDate_Current->next_free_p))->size_n_flags = 0xc0000001L;
    ((struct Dauxrigo *) (TDate_Current->next_free_p))->There = neu->next_free_p;
    (TDate_Current->next_free)++;
    TDate_Current->next_free_p = &(TDate_Current->Data[TDate_Current->next_free]);
  }
  TDate_Current = neu;
  if (TDate == NULL) TDate = neu;
}

void store_end(void)
{ if (TDate_Current == NULL) return;
  ((struct Dauxrigo *) (TDate_Current->next_free_p))->size_n_flags = 0xf0000001;
}

void store_endsolid(void)
{ unsigned long QWords_to_store;
  QWords_to_store = 1;
  if ((TDate_Current == NULL)
   || (TDate_Current->capacity < TDate_Current->next_free + QWords_to_store + 5UL))
    alloc_memory_block(0UL);
  if (TDate_Current == NULL) return;
  ((struct Dauxrigo *) (TDate_Current->next_free_p))->size_n_flags = 0x90000001;
  ((struct Dauxrigo *) (TDate_Current->next_free_p))->There = NULL;
  TDate_Current->next_free += QWords_to_store;
  TDate_Current->next_free_p = &(TDate_Current->Data[TDate_Current->next_free]);
  store_end();
}

void store_beginsolid(char *Name)
{ unsigned long QWords_to_store;
  unsigned int Strlg;
  Strlg = strlen(Name) + 3;
  while (Strlg & 3) Strlg++;
  QWords_to_store = Strlg / 4;
  if ((TDate_Current == NULL)
   || (TDate_Current->capacity < TDate_Current->next_free + QWords_to_store + 5UL))
    alloc_memory_block(0UL);
  if (TDate_Current == NULL) return;
  ((union Unu *) (TDate_Current->next_free_p))->Data[QWords_to_store - 1] = 0;
  ((struct Nomo *) (TDate_Current->next_free_p))->size_n_flags = 0x80000000 + QWords_to_store;
  for (Strlg = 0; Name[Strlg]; Strlg++)
    ((struct Nomo *) (TDate_Current->next_free_p))->ObjectName[Strlg]
      = (wchar_t) ((unsigned char) Name[Strlg]);
  AddModelReference((union Unu *)(TDate_Current->next_free_p),
                    ((struct Nomo *)(TDate_Current->next_free_p))->ObjectName,
		    NULL, -1);
    /* VTF-Dateien haben andere 2. und 3. Parameter! */
  // DumpModelSelectRecord();
  TDate_Current->next_free += QWords_to_store;
  TDate_Current->next_free_p = &(TDate_Current->Data[TDate_Current->next_free]);
  store_end();
}

void store_set_color(float r, float g, float b)
{ unsigned long QWords_to_store;
  QWords_to_store = 2;
  if ((TDate_Current == NULL)
   || (TDate_Current->capacity < TDate_Current->next_free + QWords_to_store + 5UL))
    alloc_memory_block(0UL);
  if (TDate_Current == NULL) return;
  ((struct Coloro *) (TDate_Current->next_free_p))->size_n_flags = 0x40000000L + QWords_to_store;
  ((struct Coloro *) (TDate_Current->next_free_p))->r = r;
  ((struct Coloro *) (TDate_Current->next_free_p))->g = g;
  ((struct Coloro *) (TDate_Current->next_free_p))->b = b;
  TDate_Current->next_free += QWords_to_store;
  TDate_Current->next_free_p = &(TDate_Current->Data[TDate_Current->next_free]);
  store_end();
}

void store_facet_short(float Nx, float Ny, float Nz, float *vx, float *vy, float *vz)
{ unsigned long QWords_to_store;
  int ct;
  QWords_to_store = 7;
  if ((TDate_Current == NULL)
   || (TDate_Current->capacity < TDate_Current->next_free + QWords_to_store + 5UL))
    alloc_memory_block(0UL);
  if (TDate_Current == NULL) return;
  if (!total_facet_count) {
    xmin = xmax = vx[0]; ymin = ymax = vy[0]; zmin = zmax = vz[0];
  }
  for (ct = 0; ct < 3; ct++) {
    if (vx[ct] < xmin) xmin = vx[ct]; else if (vx[ct] > xmax) xmax = vx[ct];
    if (vy[ct] < ymin) ymin = vy[ct]; else if (vy[ct] > ymax) ymax = vy[ct];
    if (vz[ct] < zmin) zmin = vz[ct]; else if (vz[ct] > zmax) zmax = vz[ct];
  }
  ((struct Trianguleto *) (TDate_Current->next_free_p))->size_n_flags = 0x20000000L + QWords_to_store;
  ((struct Trianguleto *) (TDate_Current->next_free_p))->repeated = 1;
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[0] = Nx;
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[1] = Ny;
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[2] = Nz;
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[ 3] = vx[0];
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[ 4] = vy[0];
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[ 5] = vz[0];
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[ 6] = vx[1];
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[ 7] = vy[1];
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[ 8] = vz[1];
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[ 9] = vx[2];
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[10] = vy[2];
  ((struct Trianguleto *) (TDate_Current->next_free_p))->coordinates[11] = vz[2];
  TDate_Current->next_free += QWords_to_store;
  TDate_Current->next_free_p = &(TDate_Current->Data[TDate_Current->next_free]);
  store_end();
  total_facet_count++;
}

void store_facet(double Nx, double Ny, double Nz, double *vx, double *vy, double *vz)
{ unsigned long QWords_to_store;
  int ct;
  QWords_to_store = 13;
  if ((TDate_Current == NULL)
   || (TDate_Current->capacity < TDate_Current->next_free + QWords_to_store + 5UL))
    alloc_memory_block(0UL);
  if (TDate_Current == NULL) return;
  if (!total_facet_count) {
    xmin = xmax = vx[0]; ymin = ymax = vy[0]; zmin = zmax = vz[0];
  }
  for (ct = 0; ct < 3; ct++) {
    if (vx[ct] < xmin) xmin = vx[ct]; else if (vx[ct] > xmax) xmax = vx[ct];
    if (vy[ct] < ymin) ymin = vy[ct]; else if (vy[ct] > ymax) ymax = vy[ct];
    if (vz[ct] < zmin) zmin = vz[ct]; else if (vz[ct] > zmax) zmax = vz[ct];
  }
  ((struct Triangulo *) (TDate_Current->next_free_p))->size_n_flags = 0x30000000L + QWords_to_store;
  ((struct Triangulo *) (TDate_Current->next_free_p))->repeated = 1;
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[0] = Nx;
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[1] = Ny;
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[2] = Nz;
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[ 3] = vx[0];
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[ 4] = vy[0];
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[ 5] = vz[0];
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[ 6] = vx[1];
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[ 7] = vy[1];
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[ 8] = vz[1];
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[ 9] = vx[2];
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[10] = vy[2];
  ((struct Triangulo *) (TDate_Current->next_free_p))->coordinates[11] = vz[2];
  TDate_Current->next_free += QWords_to_store;
  TDate_Current->next_free_p = &(TDate_Current->Data[TDate_Current->next_free]);
  store_end();
  total_facet_count++;
}

int AdjustInputVTF(void *start, unsigned long total_length)
{ unsigned long pos, cnt, j;
  int stp, models_added = 0;
  unsigned long typ, sz, i, coords_type;
  union Unu *Ptr, *coords;
  double px, py, pz;
  pos = coords_type = stp = 0;
  coords = NULL;
  while (pos < total_length) {
    wchar_t TT[300]; int c, stp_neu;
    Ptr = (union Unu *) &(((union Unu *)start)->Data[pos]);
    if (long_in_mapping) swap4(&(Ptr->dauxrigo.size_n_flags), long_in_mapping);
    sz = Ptr->dauxrigo.size_n_flags & 0x0fffffffL;
    typ = (Ptr->dauxrigo.size_n_flags >> 28) & 0x0fL;
    switch (typ) {
      case 8: /* Begin Solid */
        cPrintfI("Begin solid ...\n", 0);
	if (short_in_mapping) for (i = 0; i + 2 < 4 * sz; i++)
	  swap2(&(Ptr->nomo.ObjectName[i]), short_in_mapping);
        AddModelReference(Ptr, Ptr->nomo.ObjectName, coords, coords_type);
	models_added++;
	Ptr = (union Unu *) &(Ptr->Data[sz]);
      break;
      case 0: /* indexed color */
        if (float_in_mapping)
	  swap4(&(Ptr->triangulatoro.repeated), long_in_mapping);
	Ptr = (union Unu *) &(Ptr->Data[sz]);
      break;
      case 4: /* color */
        if (float_in_mapping) {
	  swap4(&(Ptr->coloro.r), float_in_mapping);
	  swap4(&(Ptr->coloro.g), float_in_mapping);
	  swap4(&(Ptr->coloro.b), float_in_mapping);
	}
	Ptr = (union Unu *) &(Ptr->Data[sz]);
      break;
      case 7:
        if (long_in_mapping) swap4(&(Ptr->triangulo.repeated), long_in_mapping);
	if (double_in_mapping) for (cnt = 0; cnt < 3 * Ptr->triangulo.repeated; cnt++)
          swap8(&(Ptr->triangulo.coordinates[cnt]), double_in_mapping);
        coords = Ptr;
        coords_type = 7;
	Ptr = (union Unu *) &(Ptr->Data[sz]);
      break;
      case 6:
        if (long_in_mapping) swap4(&(Ptr->trianguleto.repeated), long_in_mapping);
	if (float_in_mapping) for (cnt = 0; cnt < 3 * Ptr->trianguleto.repeated; cnt++)
          swap4(&(Ptr->trianguleto.coordinates[cnt]), float_in_mapping);
        coords = Ptr;
        coords_type = 6;
	Ptr = (union Unu *) &(Ptr->Data[sz]);
      break;
      case 1: /* triangulatoro */
        if (long_in_mapping) swap4(&(Ptr->triangulatoro.repeated), long_in_mapping);
	for (cnt = 0; cnt < 4 * Ptr->triangulatoro.repeated; cnt += 4) {
	  if (long_in_mapping) for (j = 0; j < 4; j++)
            swap4(&(Ptr->triangulatoro.index[cnt + j]), long_in_mapping);
          if (!total_facet_count) {
	    switch (coords_type) {
	      case 7:
	        xmin = xmax = coords->triangulo.coordinates[Ptr->triangulatoro.index[cnt + 1]];
	        ymin = ymax = coords->triangulo.coordinates[Ptr->triangulatoro.index[cnt + 1] + 1];
	        zmin = zmax = coords->triangulo.coordinates[Ptr->triangulatoro.index[cnt + 1] + 2];
              break;
	      case 6:
	        xmin = xmax = coords->trianguleto.coordinates[Ptr->triangulatoro.index[cnt + 1]];
	        ymin = ymax = coords->trianguleto.coordinates[Ptr->triangulatoro.index[cnt + 1] + 1];
	        zmin = zmax = coords->trianguleto.coordinates[Ptr->triangulatoro.index[cnt + 1] + 2];
              break;
	    }
	  }
	  for (j = 1; j < 4; j++) {
	    switch (coords_type) {
	      case 7:
	        px = coords->triangulo.coordinates[Ptr->triangulatoro.index[cnt + j]];
	        py = coords->triangulo.coordinates[Ptr->triangulatoro.index[cnt + j] + 1];
	        pz = coords->triangulo.coordinates[Ptr->triangulatoro.index[cnt + j] + 2];
              break;
	      case 6:
	        px = coords->trianguleto.coordinates[Ptr->triangulatoro.index[cnt + j]];
	        py = coords->trianguleto.coordinates[Ptr->triangulatoro.index[cnt + j] + 1];
	        pz = coords->trianguleto.coordinates[Ptr->triangulatoro.index[cnt + j] + 2];
              break;
	    }
	    if (xmin > px) xmin = px; else if (xmax < px) xmax = px;
	    if (ymin > py) ymin = py; else if (ymax < py) ymax = py;
	    if (zmin > pz) zmin = pz; else if (zmax < pz) zmax = pz;
	  }
	  total_facet_count++;
        }
	Ptr = (union Unu *) &(Ptr->Data[sz]);
      break;
      case 3: /* triangulo */
        if (long_in_mapping) swap4(&(Ptr->triangulo.repeated), long_in_mapping);
	for (cnt = 0; cnt < 12 * Ptr->triangulo.repeated; cnt += 12) {
	  if (double_in_mapping) for (j = 0; j < 12; j++)
            swap8(&(Ptr->triangulo.coordinates[cnt + j]), double_in_mapping);
          if (!total_facet_count) {
	    xmin = xmax = Ptr->triangulo.coordinates[cnt + 3];
	    ymin = ymax = Ptr->triangulo.coordinates[cnt + 4];
	    zmin = zmax = Ptr->triangulo.coordinates[cnt + 5];
	  }
	  for (j = 3; j < 12; j += 3) {
	    if (xmin > Ptr->triangulo.coordinates[cnt + j])
	      xmin = Ptr->triangulo.coordinates[cnt + j];
	     else if (xmax < Ptr->triangulo.coordinates[cnt + j])
	      xmax = Ptr->triangulo.coordinates[cnt + j];
	    if (ymin > Ptr->triangulo.coordinates[cnt + j + 1])
	      ymin = Ptr->triangulo.coordinates[cnt + j + 1];
	     else if (ymax < Ptr->triangulo.coordinates[cnt + j + 1])
	      ymax = Ptr->triangulo.coordinates[cnt + j + 1];
	    if (zmin > Ptr->triangulo.coordinates[cnt + j + 2])
	      zmin = Ptr->triangulo.coordinates[cnt + j + 2];
	     else if (zmax < Ptr->triangulo.coordinates[cnt + j + 2])
	      zmax = Ptr->triangulo.coordinates[cnt + j + 2];
	  }
	  total_facet_count++;
        }
	Ptr = (union Unu *) &(Ptr->Data[sz]);
      break;
      case 2: /* trianguleto */
        if (long_in_mapping) swap4(&(Ptr->trianguleto.repeated), long_in_mapping);
	for (cnt = 0; cnt < 12 * Ptr->trianguleto.repeated; cnt += 12) {
	  if (float_in_mapping) for (j = 0; j < 12; j++)
            swap4(&(Ptr->trianguleto.coordinates[cnt + j]), float_in_mapping);
          if (!total_facet_count) {
	    xmin = xmax = Ptr->trianguleto.coordinates[cnt + 3];
	    ymin = ymax = Ptr->trianguleto.coordinates[cnt + 4];
	    zmin = zmax = Ptr->trianguleto.coordinates[cnt + 5];
	  }
	  for (j = 3; j < 12; j += 3) {
	    if (xmin > Ptr->trianguleto.coordinates[cnt + j])
	      xmin = Ptr->trianguleto.coordinates[cnt + j];
	     else if (xmax < Ptr->trianguleto.coordinates[cnt + j])
	      xmax = Ptr->trianguleto.coordinates[cnt + j];
	    if (ymin > Ptr->trianguleto.coordinates[cnt + j + 1])
	      ymin = Ptr->trianguleto.coordinates[cnt + j + 1];
	     else if (ymax < Ptr->trianguleto.coordinates[cnt + j + 1])
	      ymax = Ptr->trianguleto.coordinates[cnt + j + 1];
	    if (zmin > Ptr->trianguleto.coordinates[cnt + j + 2])
	      zmin = Ptr->trianguleto.coordinates[cnt + j + 2];
	     else if (zmax < Ptr->trianguleto.coordinates[cnt + j + 2])
	      zmax = Ptr->trianguleto.coordinates[cnt + j + 2];
	  }
	  total_facet_count++;
        }
	Ptr = (union Unu *) &(Ptr->Data[sz]);
      break;
      default:
	Ptr = (union Unu *) &(Ptr->Data[sz]);
    }
    pos += sz;
    stp_neu = (int) floor((25.0 * pos) / ((double) total_length) + 25.0);
    if (stp_neu != stp) {
      stp = stp_neu;
      wsprintf(TT, L"%s ", LangWindowName);
      for (c = 0; c < stp; c++) wcscat(TT, L".");
      wcscat (TT, L"|");
      for (c = stp; c < 49; c++) wcscat(TT, L".");
      SetWindowText(hwndApplication, TT);
    }
  }
  return models_added;
}

int ReadFileVTF(FILE *ein)
{ unsigned long QWords_to_store, start_index, load_index, to_load;
  int stp, models_added = 0;
  struct stat sb;
  sb.st_size = 0L; stp = 0;
  fstat(fileno(ein), &sb);
  if (sb.st_size <= 48) return 0;
  QWords_to_store = (sb.st_size / 8L) - 6L;
  if ((TDate_Current == NULL)
   || (TDate_Current->capacity < TDate_Current->next_free + QWords_to_store + 5UL))
    alloc_memory_block(QWords_to_store + 5UL);
  if (TDate_Current == NULL) return 0;
  load_index = start_index = TDate_Current->next_free;
  to_load = QWords_to_store;
  fseek(ein, 48L, SEEK_SET);
  while (to_load > 4096) {
    wchar_t TT[300]; int c, stp_neu;
    fread(&(TDate_Current->Data[load_index]), 8, 4096, ein);
    load_index += 4096; to_load -= 4096;
    stp_neu = (int) floor((25.0 * (double) ftell(ein)) / ((double) sb.st_size));
    if (stp_neu != stp) {
      stp = stp_neu;
      wsprintf(TT, L"%s ", LangWindowName);
      for (c = 0; c < stp; c++) wcscat(TT, L".");
      wcscat (TT, L"|");
      for (c = stp; c < 49; c++) wcscat(TT, L".");
      SetWindowText(hwndApplication, TT);
    }
  }
  if (to_load) {
    fread(&(TDate_Current->Data[load_index]), 8, to_load, ein);
    load_index += to_load; to_load = 0;
  }
  models_added = AdjustInputVTF(TDate_Current->next_free_p, QWords_to_store);
  TDate_Current->next_free += QWords_to_store;
  TDate_Current->next_free_p = &(TDate_Current->Data[TDate_Current->next_free]);
  store_end();
  if (total_facet_count) VALID_MODELS += models_added;
  if (TDate_Current == NULL) VALID_MODELS = 0;
  return 1;
}

int ReadFileSTL(FILE *ein)
{ char Z1[81];
  int stp, models_added = 0;
  unsigned long fcnt, ct;
  float vx[5], vy[5], vz[5];
  struct vv {
    float V[12];
    unsigned short us;
  } VV;
  struct stat sb;
  sb.st_size = 1000000L; stp = 0;
  fstat(fileno(ein), &sb);
  if (fread(Z1, 1, 80, ein) < 80) return 0;
  store_beginsolid(&(Z1[6])); models_added = 1;
  Z1[80] = '\0';
  if (strncmp(Z1, "solid ", 6)) return 0;
  fcnt = 0;
  fread(&fcnt, 4, 1, ein);
  cPrintfI("%u Facetten ...\n", (int) fcnt);
  for (ct = 0; ct < fcnt; ct++) {
    if (!(ct & 0x3f)) {
      wchar_t TT[300]; int c, stp_neu;
      cPrintfI("Facette %u:\n", (int) ct);
      stp_neu = (int) floor((50.0 * (double) ftell(ein)) / ((double) sb.st_size));
      if (stp_neu != stp) {
        stp = stp_neu;
        wsprintf(TT, L"%s ", LangWindowName);
        for (c = 0; c < stp; c++) wcscat(TT, L".");
        wcscat (TT, L"|");
        for (c = stp; c < 49; c++) wcscat(TT, L".");
        SetWindowText(hwndApplication, TT);
      }
    }
    if (fread(&VV, 50, 1, ein) >= 1) {
      /*
      if (!(ct & 0x3f)) {
        cPrintfF("%6.3f ", VV.V[0]); cPrintfF("%6.3f ", VV.V[1]); cPrintfF("%6.3f\n", VV.V[2]);
        cPrintfF("%6.3f ", VV.V[3]); cPrintfF("%6.3f ", VV.V[4]); cPrintfF("%6.3f\n", VV.V[5]);
        cPrintfF("%6.3f ", VV.V[6]); cPrintfF("%6.3f ", VV.V[7]); cPrintfF("%6.3f\n", VV.V[8]);
        cPrintfF("%6.3f ", VV.V[9]); cPrintfF("%6.3f ", VV.V[10]); cPrintfF("%6.3f\n", VV.V[11]);
	cPrintfI("< %u >\n", (int) VV.us);
      }
      */
      vx[0] = VV.V[ 3]; vy[0] = VV.V[ 4]; vz[0] = VV.V[ 5];
      vx[1] = VV.V[ 6]; vy[1] = VV.V[ 7]; vz[1] = VV.V[ 8];
      vx[2] = VV.V[ 9]; vy[2] = VV.V[10]; vz[2] = VV.V[11];
      store_facet_short(VV.V[0], VV.V[1], VV.V[2], vx, vy, vz);
    } /* else cPrintfI("Datensatz %u nicht gelesen!\n", ct); */
  }
  store_endsolid();
  SetWindowText(hwndApplication, LangWindowName);
  if (total_facet_count) VALID_MODELS += models_added;
  if (TDate_Current == NULL) VALID_MODELS = 0;
  return 1;
}

int ReadFileSLP(FILE *ein)
{ char Zeile[MAX_PATH + 50], Kennwort[MAX_PATH + 50], Kennwort2[MAX_PATH + 50];
  unsigned long ZNR;
  int sw, stp = -1, STATE = -1, cv, cn;
  double d1, d2, d3, nx[3], ny[3], nz[3], vx[6], vy[6], vz[6], Nx, Ny, Nz, NNx, NNy, NNz, NL;
  int ct_solid;
#ifdef KUN_STATISTIKO
  int ct_unknown = 0, ct_endsolid = 0, ct_color = 0,
      ct_facet = 0, ct_endfacet = 0, ct_outer_loop = 0, ct_endloop = 0,
      ct_normal = 0, ct_vertex = 0, ct_rechts = 0, ct_links = 0;
#endif
  struct stat sb;
#ifdef KUN_STATISTIKO
  wchar_t Meldung[500];
  char Meldung2[300];
#endif
  ZNR = 0; sb.st_size = 1000000L;
  ct_solid = 0;
  fstat(fileno(ein), &sb);
  while (fgets(Zeile, MAX_PATH + 50, ein) != NULL) {
    /* Anzeige des Ladefortschritts in der Titelleiste! */
    if (!(ZNR & 0x3f)) {
      wchar_t TT[300]; int c, stp_neu;
      stp_neu = (int) floor((50.0 * (double) ftell(ein)) / ((double) sb.st_size));
      if (stp_neu != stp) {
        stp = stp_neu;
        wsprintf(TT, L"%s ", LangWindowName);
        for (c = 0; c < stp; c++) wcscat(TT, L".");
        wcscat (TT, L"|");
        for (c = stp; c < 49; c++) wcscat(TT, L".");
        /* if (stp >= 32) stp = 0; */
        SetWindowText(hwndApplication, TT);
      }
    }
    Kennwort[0] = '\0'; ZNR++;
    sw = sscanf(Zeile, "%s %lf %lf %lf", Kennwort, &d1, &d2, &d3);
    if (!stricmp(Kennwort, "solid")) {
      STATE = 1;
      Kennwort2[0] = '\0';
      sscanf(Zeile, "%s %s", Kennwort, Kennwort2);
      store_beginsolid(Kennwort2);
      ct_solid++;
    } else
    if (!stricmp(Kennwort, "endsolid")) {
      STATE = 0;
      store_endsolid();
#ifdef KUN_STATISTIKO
      ct_endsolid++;
#endif
    } else
    if (!stricmp(Kennwort, "color")) {
      if ((STATE == 1) && (sw == 4))
        store_set_color((float) d1, (float) d2, (float) d3);
#ifdef KUN_STATISTIKO
      ct_color++;
#endif
    } else
    if (!stricmp(Kennwort, "facet")) {
      if (STATE == 1) {
        cn = cv = 0;
        STATE = 2;
	sw = sscanf(Zeile, "%s %s %lf %lf %lf", Kennwort, Kennwort2, &d1, &d2, &d3);
	if ((sw == 5) && !stricmp(Kennwort2, "normal") && (cn < 3)) {
          nx[cn] = d1; ny[cn] = d2; nz[cn] = d3; cn++;
#ifdef KUN_STATISTIKO
          ct_normal++;
#endif
	}
      }
#ifdef KUN_STATISTIKO
      ct_facet++;
#endif
    } else
    if (!stricmp(Kennwort, "endfacet")) {
      if (STATE > 1) {
        if ((cv == 3) && (cn > 0)) {
	  NNx = nx[0]; NNy = ny[0]; NNz = nz[0];
	  for (sw = 1; sw < cn; sw++) {
	    NNx += nx[sw]; NNy += ny[sw]; NNz += nz[sw];
	  }
	  vx[3] = vx[1] - vx[0]; vx[4] = vx[2] - vx[1]; vx[5] = vx[0] - vx[2];
	  vy[3] = vy[1] - vy[0]; vy[4] = vy[2] - vy[1]; vy[5] = vy[0] - vy[2];
	  vz[3] = vz[1] - vz[0]; vz[4] = vz[2] - vz[1]; vz[5] = vz[0] - vz[2];
	  Nx = (vy[3] * vz[4] - vz[3] * vy[4]) + (vy[4] * vz[5] - vz[4] * vy[5]) + (vy[5] * vz[3] - vz[5] * vy[3]);
	  Ny = (vz[3] * vx[4] - vx[3] * vz[4]) + (vz[4] * vx[5] - vx[4] * vz[5]) + (vz[5] * vx[3] - vx[5] * vz[3]);
	  Nz = (vx[3] * vy[4] - vy[3] * vx[4]) + (vx[4] * vy[5] - vy[4] * vx[5]) + (vx[5] * vy[3] - vy[5] * vx[3]);
	  NL = sqrt(Nx*Nx + Ny*Ny + Nz*Nz);
	  if (NL >= 1.0e-100L) {
	    if ((d1 = Nx * NNx + Ny * NNy + Nz * NNz) > 0.0) {
#ifdef KUN_STATISTIKO
	      ct_rechts++;
#endif
            } else if (d1 < 0.0) {
	      /*
	      sprintf(Meldung2, "Normal:\n"
	        "%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n"
		"Vertizes:\n"
	        "%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n",
                  nx[0], ny[0], nz[0], nx[1], ny[1], nz[1], nx[2], ny[2], nz[2],
                  vx[0], vy[0], vz[0], vx[1], vy[1], vz[1], vx[2], vy[2], vz[2]);
              wsprintf(Meldung, L"%S", Meldung2);
              MessageBox(hwndApplication, Meldung, L"maldekstra triangolo:", MB_OK | MB_ICONINFORMATION);
	      */
	      NL *= -1.0;
#ifdef KUN_STATISTIKO
	      ct_links++;
#endif
	      vx[4] = vx[1]; vx[1] = vx[2]; vx[2] = vx[4];
	      vy[4] = vy[1]; vy[1] = vy[2]; vy[2] = vy[4];
	      vz[4] = vz[1]; vz[1] = vz[2]; vz[2] = vz[4];
            }
	    Nx /= NL; Ny /= NL; Nz /= NL;
	  }
	  /*
	  { sprintf(Meldung2, "Normal:\n"
	        "%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n"
		"nova Normal:\n"
		"%9.3lf %9.3lf %9.3lf\n(%9.3lf)\n"
		"Vertizes:\n"
	        "%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n",
                  nx[0], ny[0], nz[0], nx[1], ny[1], nz[1], nx[2], ny[2], nz[2],
		  Nx, Ny, Nz, NL,
                  vx[0], vy[0], vz[0], vx[1], vy[1], vz[1], vx[2], vy[2], vz[2]);
              wsprintf(Meldung, L"%S", Meldung2);
              MessageBox(hwndApplication, Meldung, L"maldekstra triangolo:", MB_OK | MB_ICONINFORMATION);
	  }
	  */
          store_facet(Nx, Ny, Nz, vx, vy, vz);
	}
        STATE = 1;
      }
#ifdef KUN_STATISTIKO
      ct_endfacet++;
#endif
    } else
    if (!stricmp(Kennwort, "outer")) {
      if (STATE == 2) STATE = 3;
#ifdef KUN_STATISTIKO
      ct_outer_loop++;
#endif
    } else
    if (!stricmp(Kennwort, "endloop")) {
      if (STATE == 3) STATE = 2;
#ifdef KUN_STATISTIKO
      ct_endloop++;
#endif
    } else
    if (!stricmp(Kennwort, "normal")) {
      if ((STATE == 2) && (sw == 4) && (cn < 3)) {
        nx[cn] = d1; ny[cn] = d2; nz[cn] = d3; cn++;
      }
#ifdef KUN_STATISTIKO
      ct_normal++;
#endif
    } else
    if (!stricmp(Kennwort, "vertex")) {
      if ((STATE == 3) && (sw == 4) && (cv < 3)) {
        vx[cv] = d1; vy[cv] = d2; vz[cv] = d3; cv++;
      }
#ifdef KUN_STATISTIKO
      ct_vertex++;
#endif
    } else {
#ifdef KUN_STATISTIKO
      ct_unknown++;
#endif
    }
  }
  SetWindowText(hwndApplication, LangWindowName);
#ifdef KUN_STATISTIKO
  if (ct_vertex)
    sprintf(Meldung2, "\n\n[ %5.3lf..%5.3lf ; %5.3lf..%5.3lf ; %5.3lf..%5.3lf ]",
      xmin, xmax, ymin, ymax, zmin, zmax);
   else Meldung2[0] = '\0';
  wsprintf(Meldung,
           StrByLang(X_CODING,
	   /*   0*/  L"%d\tsolid\n%d\tendsolid\n%d\tcolor\n"
                     L"%d\tfacet\n%d\tendfacet\n%d\touter loop\n%d\tendloop\n"
		     L"\t%d\tdekstra\n\t%d\tmaldekstra\n"
		     L"%d\tnormal\n%d\tvertex\n%d\tnekonata\n---------------\n%d\tlinioj%S", L"\xffff",
           /* EOL */ NULL),
                    ct_solid, ct_endsolid, ct_color,
		    ct_facet, ct_endfacet, ct_outer_loop, ct_endloop,
		    ct_rechts, ct_links,
		    ct_normal, ct_vertex, ct_unknown, ZNR, Meldung2);
  MessageBox(hwndApplication, Meldung,
             StrByLang(X_CODING, L"statistiko:", L"\xffff", NULL),
	     MB_OK | MB_ICONINFORMATION);
#endif
  if (total_facet_count) VALID_MODELS += ct_solid;
  if (TDate_Current == NULL) VALID_MODELS = 0;
  return 1;
}

int which_eoln(FILE *ein)
{ unsigned char C;
  unsigned long CP;
  CP = ftell(ein);
  while (fread(&C, 1, 1, ein) > 0) {
    switch(C) {
      case '\n': case '\r': 
        fseek(ein, CP, SEEK_SET);
        return 1;
      case '\0':
        fseek(ein, CP, SEEK_SET);
        return 2;
    }
  }
  fseek(ein, CP, SEEK_SET);
  return -1;
}

void ReadFileIn(wchar_t *datei, wchar_t *basename, int ext_start, int append)
/* append = -1 : Zu lesende Datei im Dialog ausgewhlt
 * append =  0 : erste Datei aus Kommandozeile
 * append >= 1 : Folgedatei aus Kommandozeile            */
{ FILE *ein;
  wchar_t Fehler[MAX_PATH + 100];
  char Kopf[8];
  if ((ein = _wfopen(datei, L"rb")) == NULL) {
    wsprintf(Fehler,
             StrByLang(X_CODING,
	               L"Ne konas legi dosieron '%s'!", L"\xffff",
		       L"Kann Datei '%s' nicht lesen!",
		       L"File \"%s\" cannot be read!",
		       NULL),
	     datei);
    MessageBox(hwndApplication, Fehler,
               StrByLang(X_CODING,
	                 L"apertas triangularan dosieron", L"\xffff",
			 L"ffnen einer Triangulationsdatei",
			 L"Opening a triangulation file",
			 NULL),
	       MB_OK | MB_ICONEXCLAMATION);
    return;
  }
  Kopf[0] = '\0';
  fread(Kopf, 1, strlen(SLP_STL_ASCII_HEAD), ein); fseek(ein, 0, SEEK_SET);
  Kopf[strlen(SLP_STL_ASCII_HEAD)] = '\0';
  IN_FILE_DIALOG = 1; RebuildLists = 1;
  if (append <= 0) {
    clear_triangulation(); total_facet_count = 0; VALID_MODELS = 0;
    if (hwndObjectDisplayDialog != NULL) SendMessage(hwndObjectDisplayDialog, WM_COMMAND, RT_CLEAR_CHECKBOXES, 0L);
    ClearModelSelectItems();
  }
  if (!stricmp(Kopf, SLP_STL_ASCII_HEAD)) {
    switch(which_eoln(ein)) {
      case 1:
        ReadFileSLP(ein);
      break;
      case 2:
        ReadFileSTL(ein);
      break;
      default:
        goto reading_unknown_type;
    }
    if (hwndObjectDisplayDialog != NULL) SendMessage(hwndObjectDisplayDialog, WM_COMMAND, RT_BUILD_CHECKBOXES, 0L);
  } else 
  if (ItsVTFtype(ein, &short_in_mapping, &long_in_mapping,
                      &float_in_mapping, &double_in_mapping)) {
    ReadFileVTF(ein);
    if (hwndObjectDisplayDialog != NULL) SendMessage(hwndObjectDisplayDialog, WM_COMMAND, RT_BUILD_CHECKBOXES, 0L);
    /*
    wsprintf(Fehler, L"Mappings:\nshort = %d\nlong = %d\nfloat = %d\ndouble = %d",
             short_in_mapping, long_in_mapping, float_in_mapping, double_in_mapping);
    MessageBox(hwndApplication, Fehler, L"tipo:", MB_OK | MB_ICONINFORMATION);
    */
  } else {
    reading_unknown_type:
    if (append == 0) {
      // wchar_t M[500];
      // wsprintf(M, L"ReadFileIn(\"%s\",\n           \"%s\",\n           %d, %d)\n\"%s\"\nnokonata enhavo!",
      //  datei, basename, ext_start, append, &(datei[ext_start]));
      // MessageBox(hwndApplication, M, L"launching problem", MB_OK | MB_ICONEXCLAMATION);
      if (ES_Settings.VtfSlpStl[0].enabled && !wcsicmp(&(datei[ext_start]), L".vtf")) {
        fclose(ein);
        // MessageBox(hwndApplication, L"VTF-Application", L"should launch by", MB_OK | MB_ICONEXCLAMATION);
	try_launching(0, datei);
	goto this_routine_exit_code;
      }
      if (ES_Settings.VtfSlpStl[1].enabled && !wcsicmp(&(datei[ext_start]), L".slp")) {
        fclose(ein);
        // MessageBox(hwndApplication, L"SLP-Application", L"should launch by", MB_OK | MB_ICONEXCLAMATION);
	try_launching(1, datei);
	goto this_routine_exit_code;
      }
      if (ES_Settings.VtfSlpStl[2].enabled && !wcsicmp(&(datei[ext_start]), L".stl")) {
        fclose(ein);
        // MessageBox(hwndApplication, L"STL-Application", L"should launch by", MB_OK | MB_ICONEXCLAMATION);
	try_launching(2, datei);
	goto this_routine_exit_code;
      }
    }
    MessageBox(hwndApplication,
               StrByLang(X_CODING, 
	                 L"nekonata enhavo en tiu " US_cx L"i dosiero!",
                         L"nekonata enhavo en tiu cxi dosiero!",
			 L"unbekanntes Dateiformat in dieser Datei!",
			 L"this file is an unknown file format!",
			 NULL),
	       StrByLang(X_CODING, L"lega manko", L"\xffff",
		                   L"Lesefehler",
				   L"Error while reading",
				   NULL),
	       MB_OK | MB_ICONEXCLAMATION);
    if (append <= 0) total_facet_count = 0;
  }
  fclose(ein);
  this_routine_exit_code:
  if ((TDate_Current == NULL) || (total_facet_count == 0)) {
    clear_triangulation(); VALID_MODELS = 0;
  }
  IN_FILE_DIALOG = 0;
  EnableMenuItem(filemenu, MN_FILE_SAVE, MF_BYCOMMAND | (VALID_MODELS ? MF_ENABLED : MF_GRAYED));
  EnableMenuItem(viewmenu, MN_PART_DISP, MF_BYCOMMAND | ((VALID_MODELS > 1) ? MF_ENABLED : MF_GRAYED));
  if (VALID_MODELS && (append <= 0)) {
    wsprintf(Fehler, L"%s - %s", LangWindowName, basename);
    SetWindowText(hwndApplication, Fehler);
  }
  Projection = PROJ_TRI;
}

void UnlinkAllMyRegistryKeys(void)
{ wchar_t RegName[MAX_PATH];
  int ct, i;
  for (ct = 0; RevHistory[ct] != NULL; ct++) {
    for (i = 0; KeywordHistory[i] != NULL; i++) {
      wsprintf(RegName, L"%s\\%s\\%s", RegistryBaseDir, RevHistory[ct], KeywordHistory[i]);
      /* MessageBox(NULL, RegName, L"Registry entry to delete", MB_OK | MB_ICONINFORMATION);
      if ( */ RegDeleteKey(HKEY_CURRENT_USER, RegName) /* == FALSE)
        MessageBox(NULL, RegName, L"Registry deletion failed", MB_OK | MB_ICONEXCLAMATION) */;
    }
    wsprintf(RegName, L"%s\\%s", RegistryBaseDir, RevHistory[ct]);
    /* MessageBox(NULL, RegName, L"Registry entry to delete", MB_OK | MB_ICONINFORMATION);
    if ( */ RegDeleteKey(HKEY_CURRENT_USER, RegName) /* == FALSE)
      MessageBox(NULL, RegName, L"Registry deletion failed", MB_OK | MB_ICONEXCLAMATION) */;
  }
  /* MessageBox(NULL, RegistryBaseDir, L"Registry entry to delete", MB_OK | MB_ICONINFORMATION);
  if ( */ RegDeleteKey(HKEY_CURRENT_USER, RegistryBaseDir) /* == FALSE)
    MessageBox(NULL, RegistryBaseDir, L"Registry deletion failed", MB_OK | MB_ICONEXCLAMATION) */;
}

void SaveParametersInRegistry(void)
{ HKEY regkey;
  DWORD disposition;
  wchar_t ES_Packed[sizeof(struct ES_DIALOG_DATA) / 2];
  int lg;
  if (!options_altered) return;
  if (RegCreateKeyEx(HKEY_CURRENT_USER, RegistryDir, 0, L"",
      REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL,
      &regkey, &disposition) != ERROR_SUCCESS)
        return;
  RegSetValueEx(regkey, L"malantauxo rugxona", 0, REG_DWORD,  (void *) &SBG_R,           4);
  RegSetValueEx(regkey, L"malantauxo verdona", 0, REG_DWORD,  (void *) &SBG_G,           4);
  RegSetValueEx(regkey, L"malantauxo bluona",  0, REG_DWORD,  (void *) &SBG_B,           4);
  RegSetValueEx(regkey, L"openGl listoj",      0, REG_DWORD,  (void *) &UseLists,        4);
  RegSetValueEx(regkey, L"malantauxa edro",    0, REG_DWORD,  (void *) &CullFace,        4);
  RegSetValueEx(regkey, L"montri centro",      0, REG_DWORD,  (void *) &Disp_CS,         4);
  RegSetValueEx(regkey, L"dimensio",           0, REG_DWORD,  (void *) &Disp_Extend,     4);
  RegSetValueEx(regkey, L"lingvo",             0, REG_DWORD,  (void *) &X_CODING,        4);
  RegSetValueEx(regkey, L"simplaj coloroj",    0, REG_DWORD,  (void *) &simple_color,    4);
  RegSetValueEx(regkey, L"helaj korpoj",       0, REG_DWORD,  (void *) &lighty_models,   4);
  RegSetValueEx(regkey, L"muso",               0, REG_DWORD,  (void *) &mouse_inversion, 4);
  if ((lg = 2 * compact_ES_Data(ES_Packed, &ES_Settings)) != 0);
    RegSetValueEx(regkey, L"anstatauxaj prog",   0, REG_BINARY, (void *) ES_Packed,   lg);
  RegCloseKey(regkey);
  options_altered = 0;
}

void LoadParametersFromRegistry(void)
{ HKEY regkey;
  int erg, ct;
  DWORD sz, buffertype;
  wchar_t ES_Packed[sizeof(struct ES_DIALOG_DATA) / 2];
  erg = 0;
  if (RegOpenKeyEx(HKEY_CURRENT_USER, RegistryDir, 0,
      KEY_SET_VALUE | KEY_QUERY_VALUE, &regkey) != ERROR_SUCCESS)
        return;
  sz = 4; buffertype = REG_DWORD;
  if (RegQueryValueEx(regkey, L"malantauxo rugxona", 0, &buffertype, (void *) &SBG_R,   &sz)
      == ERROR_SUCCESS) erg++;
  sz = 4; buffertype = REG_DWORD;
  if (RegQueryValueEx(regkey, L"malantauxo verdona", 0, &buffertype, (void *) &SBG_G,   &sz)
      == ERROR_SUCCESS) erg++;
  sz = 4; buffertype = REG_DWORD;
  if (RegQueryValueEx(regkey, L"malantauxo bluona",  0, &buffertype, (void *) &SBG_B,   &sz)
      == ERROR_SUCCESS) erg++;
  sz = 4; buffertype = REG_DWORD;
  RegQueryValueEx(regkey, L"openGl listoj",   0, &buffertype, (void *) &UseLists,        &sz);
  sz = 4; buffertype = REG_DWORD;
  RegQueryValueEx(regkey, L"malantauxa edro", 0, &buffertype, (void *) &CullFace,        &sz);
  sz = 4; buffertype = REG_DWORD;
  RegQueryValueEx(regkey, L"montri centro",   0, &buffertype, (void *) &Disp_CS,         &sz);
  sz = 4; buffertype = REG_DWORD;
  RegQueryValueEx(regkey, L"dimensio",        0, &buffertype, (void *) &Disp_Extend,     &sz);
  sz = 4; buffertype = REG_DWORD;
  RegQueryValueEx(regkey, L"lingvo",          0, &buffertype, (void *) &X_CODING,        &sz);
  sz = 4; buffertype = REG_DWORD;
  RegQueryValueEx(regkey, L"simplaj coloroj", 0, &buffertype, (void *) &simple_color,    &sz);
  sz = 4; buffertype = REG_DWORD;
  RegQueryValueEx(regkey, L"helaj korpoj",    0, &buffertype, (void *) &lighty_models,   &sz);
  sz = 4; buffertype = REG_DWORD;
  RegQueryValueEx(regkey, L"muso",            0, &buffertype, (void *) &mouse_inversion, &sz);
  sz = ES_Settings.record_size; buffertype = REG_BINARY;
  RegQueryValueEx(regkey, L"anstatauxaj prog",0, &buffertype, (void *) ES_Packed,      &sz);
  uncompact_ES_Data(&ES_Settings, ES_Packed);
  RegCloseKey(regkey);
  if (erg >= 3) {
    bg_r = SBG_R / 255.0F; bg_g = SBG_G / 255.0F; bg_b = SBG_B / 255.0F;
    for (ct = 1; ct < 16; ct += 2) Farbfeld[ct] = RGB(SBG_R, SBG_G, SBG_B);
  }
}

wchar_t FT_IE[] = L"invalid enum",
        FT_IV[] = L"invalid value",
        FT_IO[] = L"invalid operation",
        FT_SO[] = L"stack overflow",
        FT_SU[] = L"stack underflow",
        FT_OM[] = L"out of memory";

void report_glerror(int zeile)
{ GLenum fehler;
  wchar_t *FText, Unbekant[80], Kopf[80];
  switch (fehler = glGetError()) {
    case GL_NO_ERROR: return;
    case GL_INVALID_ENUM:      FText = FT_IE; break;
    case GL_INVALID_VALUE:     FText = FT_IV; break;
    case GL_INVALID_OPERATION: FText = FT_IO; break;
    case GL_STACK_OVERFLOW:    FText = FT_SO; break;
    case GL_STACK_UNDERFLOW:   FText = FT_SU; break;
    case GL_OUT_OF_MEMORY:     FText = FT_OM; break;
    default:                   FText = Unbekant; break;
      wsprintf(Unbekant,
               StrByLang(X_CODING, L"neniu teksto por eraro No. %u", L"\xffff",
	                           L"Kein Beschreibungstext fr Fehlermeldung Nr. %u",
				   L"No description available for error number %u",
				   NULL),
	       (unsigned int) fehler);
           
  }
  wsprintf(Kopf,
           StrByLang(X_CODING, L"eraro de openGL en lineo de codo No. %d", L"\xffff",
	                       L"openGL-Fehler in Programmzeile %d",
			       L"openGL error in line %d",
			       NULL),
	   zeile);
  MessageBox(NULL, FText, Kopf, MB_OK | MB_ICONEXCLAMATION);
}


void Rotate0(GLdouble rot, GLdouble x, GLdouble y, GLdouble z)
{ GLdouble CurrMat[16], ax, ay, az;

  glGetDoublev(GL_MODELVIEW_MATRIX, CurrMat); report_glerror(__LINE__); dump_Mat();
  ax = x * (CurrMat[ 5] * CurrMat[10] - CurrMat[ 6] * CurrMat[ 9])
     + y * (CurrMat[ 6] * CurrMat[ 8] - CurrMat[ 4] * CurrMat[10])
     + z * (CurrMat[ 4] * CurrMat[10] - CurrMat[ 6] * CurrMat[ 8]);
  ay = x * (CurrMat[ 2] * CurrMat[ 9] - CurrMat[ 1] * CurrMat[10])
     + y * (CurrMat[ 0] * CurrMat[10] - CurrMat[ 2] * CurrMat[ 8])
     + z * (CurrMat[ 2] * CurrMat[ 8] - CurrMat[ 0] * CurrMat[10]);
  az = x * (CurrMat[ 1] * CurrMat[ 6] - CurrMat[ 2] * CurrMat[ 5])
     + y * (CurrMat[ 2] * CurrMat[ 4] - CurrMat[ 0] * CurrMat[ 6])
     + z * (CurrMat[ 0] * CurrMat[ 5] - CurrMat[ 1] * CurrMat[ 4]);
  glRotated(rot, ax, ay, az);
}

void show_center_box(void)
{ GLdouble RSize;
  RSize = 11.0 / screen_size / view_scale;
  glPushMatrix();
  glLoadIdentity();
  glLineWidth(1.0);
  glShadeModel(GL_FLAT); report_glerror(__LINE__);
  glDisable(GL_LIGHTING); report_glerror(__LINE__);
  glDisable(GL_DEPTH_TEST); report_glerror(__LINE__);
  glClear(GL_DEPTH_BUFFER_BIT); report_glerror(__LINE__);
  glColor3f(1.0, 1.0, 1.0);
  glBegin(GL_LINE_LOOP);
  glVertex3d(view_x + RSize, view_y + RSize, 0.0);
  glVertex3d(view_x + RSize, view_y - RSize, 0.0);
  glVertex3d(view_x - RSize, view_y - RSize, 0.0);
  glVertex3d(view_x - RSize, view_y + RSize, 0.0);
  glEnd();
  glColor3f(0.0, 0.0, 0.0);
  glBegin(GL_LINES);
  glVertex3d(view_x + RSize, view_y + 0.5 * RSize, 0.0);
  glVertex3d(view_x + RSize, view_y - 0.5 * RSize, 0.0);
  glVertex3d(view_x - RSize, view_y - 0.5 * RSize, 0.0);
  glVertex3d(view_x - RSize, view_y + 0.5 * RSize, 0.0);
  glVertex3d(view_x - 0.5 * RSize, view_y + RSize, 0.0);
  glVertex3d(view_x + 0.5 * RSize, view_y + RSize, 0.0);
  glVertex3d(view_x + 0.5 * RSize, view_y - RSize, 0.0);
  glVertex3d(view_x - 0.5 * RSize, view_y - RSize, 0.0);
  glEnd();
  glPopMatrix();
}

void CoordinateSystem(void)
{
  double CSSZ, CSZ;
  CSSZ = 0.175 * halfdiagonal / view_scale;
  CSZ = 0.045 * halfdiagonal / view_scale;
  glLineWidth(5.0); report_glerror(__LINE__);
  glDisable(GL_LIGHTING); report_glerror(__LINE__);
  glDisable(GL_DEPTH_TEST); report_glerror(__LINE__);
  glColor3f(0.0, 0.0, 0.0); report_glerror(__LINE__);
  /* X, Y, Z directions in the center of extend */
  glBegin(GL_LINES);
  glVertex3d(xc, yc, zc); glVertex3d(CSSZ + xc, yc, zc);
  glVertex3d(xc, yc, zc); glVertex3d(xc, CSSZ + yc, zc);
  glVertex3d(xc, yc, zc); glVertex3d(xc, yc, CSSZ + zc);
  glEnd();
  /* Origin */
  glLineWidth(3.0);
  glBegin(GL_LINES);
  glVertex3d(-CSZ, 0.0, 0.0); glVertex3d(CSZ, 0.0, 0.0);
  glVertex3d(0.0, -CSZ, 0.0); glVertex3d(0.0, CSZ, 0.0);
  glVertex3d(0.0, 0.0, -CSZ); glVertex3d(0.0, 0.0, CSZ);
  glEnd();
  show_center_box();
  glEnable(GL_DEPTH_TEST); report_glerror(__LINE__);
  glLineWidth(3.0); report_glerror(__LINE__);
  glClear(GL_DEPTH_BUFFER_BIT); report_glerror(__LINE__);
  glShadeModel(GL_FLAT); report_glerror(__LINE__);
  /* X, Y, Z directions in the center of extend */
  glBegin(GL_LINES);
  glColor3f(1.0, 0.0, 0.0); glVertex3d(xc, yc, zc); glVertex3d(CSSZ + xc, yc, zc);
  glColor3f(0.0, 1.0, 0.0); glVertex3d(xc, yc, zc); glVertex3d(xc, CSSZ + yc, zc);
  glColor3f(0.0, 0.0, 1.0); glVertex3d(xc, yc, zc); glVertex3d(xc, yc, CSSZ + zc);
  glEnd();
  /* Origin */
  glLineWidth(1.0);
  glBegin(GL_LINES);
  glColor3f(1.0, 0.0, 0.0); glVertex3d(-CSZ, 0.0, 0.0); glVertex3d(CSZ, 0.0, 0.0);
  glColor3f(0.0, 1.0, 0.0); glVertex3d(0.0, -CSZ, 0.0); glVertex3d(0.0, CSZ, 0.0);
  glColor3f(0.0, 0.0, 1.0); glVertex3d(0.0, 0.0, -CSZ); glVertex3d(0.0, 0.0, CSZ);
  glEnd();
  glLineWidth(1.0);
}

void GraphicsDataInterpretation(union Unu *Startpunkt, int rs_coord,
                                union Unu *ValidCoords, int ValidCoordType, int stop_at_endsolid)
/* Record Types: 
 *     The 4 most significant bits of the 32 bit integer leading a data record are the record type.
 *     The 28 least significant bits indicate the size of this record - counted in 8 byte blocks.
 *     The records within a <<.vtf>> file is preceded by this header:
 *       Zero terminated ANSI string "triangluara doriero (.vtf)\r\n\32"
 *       16 bit integer, where the least significant byte is greater then the most significant
 *       32 bit integer, value 987654321
 *       32 bit float, value 7654321.0
 *       64 bit double, value 9876543210123456.0
 * 0000 =  0 = 0x0 : Set Color, indexed (next unsigned long = index to Coordinate_Array) ** size = 1 only
 * 0001 =  1 = 0x1 : Surface Triangles, indexed (next unsigned long = count of 4-long-index_to_Coordiante_Array-group)
 * 0010 =  2 = 0x2 : Surface Triangles, float (next unsigned long = count of 12-float-groups [normal, 3 corners])
 * 0011 =  3 = 0x3 : Surface Triangles, double (next unsigned long = count of 12-double-groups [normal, 3 corners])
 * 0100 =  4 = 0x4 : Set Color (next 3 floats: red, green, blue) ** size = 2 only
 * 0101 =  5 = 0x5 : *** reserved ***
 * 0110 =  6 = 0x6 : Coordiante Array (next unsigned long = count of 3-float-groups)
 * 0111 =  7 = 0x7 : Coordinate Array (next unsigned long = count of 3-double-groups)
 * 1000 =  8 = 0x8 : Begin Solid (next is name in UNICODE, zero terminated and filled with zero until the next 8 byte boundary is reached)
 * 1001 =  9 = 0x9 : End Solid ** size = 1 only
 * 1010 = 10 = 0xA : *** reserved ***
 * 1011 = 11 = 0xB : *** reserved ***
 * 1100 = 12 = 0xC : Jump to next memory location - only used within the viewer ** size = 1 only
 * 1101 = 13 = 0xD : *** reserved ***
 * 1110 = 14 = 0xE : *** reserved ***
 * 1111 = 15 = 0xF : End of Data - only used within the viewer ** size = 1 only
 */
{ union Unu *dta;
  static union Unu *coords;
  unsigned long typ, sz, rep, offs, start_solid_count;
  static int coords_type;
  if (rs_coord) { coords = NULL; coords_type = 0; }
  if (ValidCoords != NULL) {
    coords = ValidCoords; coords_type = ValidCoordType;
  }
  start_solid_count = 0;
  for (dta = Startpunkt;
       ((dta->dauxrigo.size_n_flags >> 28) & 0x0fL) != 0x0fL;
       ) {
    sz = dta->dauxrigo.size_n_flags & 0x0fffffffL;
    typ = (dta->dauxrigo.size_n_flags >> 28) & 0x0fL;
    switch (typ) {
      case 12: /* Jump to next memory segment */
#ifdef DUMP_VIEW_DATA
        cPrintfI("Jump to new Segment ...\n", 0);
#endif
        dta = (union Unu *) dta->dauxrigo.There;
      break;
      case 8: /* Begin Solid */
#ifdef DUMP_VIEW_DATA
        cPrintfI("Begin solid ...\n", 0);
	{ unsigned int i;
	  for (i = 0; i + 2 < 4 * sz; i++)
	    cPrintfI(" %.4x", dta->nomo.ObjectName[i]);
        } cPrintfI("\n", 0);
#endif
        if (stop_at_endsolid && (start_solid_count++)) return;
        glColor4f(1.0, 1.0, 1.0, 1.0);
	dta = (union Unu *) &(dta->Data[sz]);
      break;
      case 0: /* indexed color */
        if (simple_color && !Wireframe) {
	  switch (coords_type) {
            case 7:
	      SimpleColorSave((float) coords->triangulo.coordinates[dta->triangulatoro.repeated],
	                      (float) coords->triangulo.coordinates[dta->triangulatoro.repeated + 1],
	                      (float) coords->triangulo.coordinates[dta->triangulatoro.repeated + 2]);
            break;
            case 6:
	      SimpleColorSave((float) coords->trianguleto.coordinates[dta->triangulatoro.repeated],
	                      (float) coords->trianguleto.coordinates[dta->triangulatoro.repeated + 1],
	                      (float) coords->trianguleto.coordinates[dta->triangulatoro.repeated + 2]);
            break;
          }
	} else {
	  switch (coords_type) {
            case 7:
	      if (lighty_models)
	        glColor4f(0.5F + 0.5F * (float) coords->triangulo.coordinates[dta->triangulatoro.repeated],
	                  0.5F + 0.5F * (float) coords->triangulo.coordinates[dta->triangulatoro.repeated + 1],
	                  0.5F + 0.5F * (float) coords->triangulo.coordinates[dta->triangulatoro.repeated + 2],
			  1.0);
	      else
	        glColor4f((float) coords->triangulo.coordinates[dta->triangulatoro.repeated],
	                  (float) coords->triangulo.coordinates[dta->triangulatoro.repeated + 1],
	                  (float) coords->triangulo.coordinates[dta->triangulatoro.repeated + 2],
			  1.0);
	    break;
            case 6:
	      if (lighty_models)
	        glColor4f(0.5F + 0.5F * (float) coords->trianguleto.coordinates[dta->triangulatoro.repeated],
	                  0.5F + 0.5F * (float) coords->trianguleto.coordinates[dta->triangulatoro.repeated + 1],
	                  0.5F + 0.5F * (float) coords->trianguleto.coordinates[dta->triangulatoro.repeated + 2],
			  1.0);
	      else
	        glColor4f((float) coords->trianguleto.coordinates[dta->triangulatoro.repeated],
	                  (float) coords->trianguleto.coordinates[dta->triangulatoro.repeated + 1],
	                  (float) coords->trianguleto.coordinates[dta->triangulatoro.repeated + 2],
			  1.0);
	    break;
	  }
	}
	dta = (union Unu *) &(dta->Data[sz]);
      break;
      case 4: /* set color */
#ifdef DUMP_VIEW_DATA
        cPrintfI("color ...\n", 0);
	cPrintfF(" %5.3f", dta->coloro.r);
	cPrintfF(" %5.3f", dta->coloro.g);
	cPrintfF(" %5.3f\n", dta->coloro.b);
#endif
        if (simple_color && !Wireframe) 
	 SimpleColorSave(dta->coloro.r, dta->coloro.g, dta->coloro.b);
	  else {
#ifdef FADEN_1
           float colors[4];
	   colors[0] = dta->coloro.r;
	   colors[1] = dta->coloro.g;
	   colors[2] = dta->coloro.b;
	   colors[3] = 1.0;
	   if (maxr < dta->coloro.r) maxr = dta->coloro.r;
	     else if (minr > dta->coloro.r) minr = dta->coloro.r;
	   if (maxg < dta->coloro.g) maxg = dta->coloro.g;
	     else if (ming > dta->coloro.g) ming = dta->coloro.g;
	   if (maxb < dta->coloro.b) maxb = dta->coloro.b;
	     else if (minb > dta->coloro.b) minb = dta->coloro.b;
	   // glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, ambient);
	   // glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, diffuse);
#endif
	 if (lighty_models)
           glColor4f(0.5F + 0.5F * dta->coloro.r, 0.5F + 0.5F * dta->coloro.g, 0.5F + 0.5F * dta->coloro.b, 1.0);
	  else
	   glColor4f(dta->coloro.r, dta->coloro.g, dta->coloro.b, 1.0);
	}
#ifdef DUMP_MAT
        fprintf(trail, "Color: %5.3f %5.3f %5.3f\n",
	  dta->coloro.r, dta->coloro.g, dta->coloro.b);
        fflush(trail);
#endif
	dta = (union Unu *) &(dta->Data[sz]);
      break;
      case 7:
        coords = dta;
        coords_type = 7;
	dta = (union Unu *) &(dta->Data[sz]);
      break;
      case 6:
        coords = dta;
        coords_type = 6;
	dta = (union Unu *) &(dta->Data[sz]);
      break;
      case 1:
#ifdef DUMP_VIEW_DATA
        cPrintfI("%d triangles by index ", dta->triangulatoro.repeated);
        cPrintfI("[%d] ...\n", sz);
#endif
        for (rep = offs = 0; rep < dta->triangulatoro.repeated; rep++) {
	  if (Wireframe) glBegin(GL_LINE_LOOP);
	  if (simple_color && !Wireframe) switch (coords_type) {
            case 7:
	      SimpleColorSetNormal(coords->triangulo.coordinates[dta->triangulatoro.index[offs]],
	                           coords->triangulo.coordinates[dta->triangulatoro.index[offs] + 1],
	                           coords->triangulo.coordinates[dta->triangulatoro.index[offs] + 2]);
	    break;
            case 6:
	      SimpleColorSetNormal(coords->trianguleto.coordinates[dta->triangulatoro.index[offs]],
	                           coords->trianguleto.coordinates[dta->triangulatoro.index[offs] + 1],
	                           coords->trianguleto.coordinates[dta->triangulatoro.index[offs] + 2]);
	    break;
          }
	  switch (coords_type) {
	    case 7:
              glNormal3d(coords->triangulo.coordinates[dta->triangulatoro.index[offs]],
	                 coords->triangulo.coordinates[dta->triangulatoro.index[offs] + 1],
	                 coords->triangulo.coordinates[dta->triangulatoro.index[offs] + 2]);
              glVertex3d(coords->triangulo.coordinates[dta->triangulatoro.index[offs + 1]],
	                 coords->triangulo.coordinates[dta->triangulatoro.index[offs + 1] + 1],
	                 coords->triangulo.coordinates[dta->triangulatoro.index[offs + 1] + 2]);
              glVertex3d(coords->triangulo.coordinates[dta->triangulatoro.index[offs + 2]],
	                 coords->triangulo.coordinates[dta->triangulatoro.index[offs + 2] + 1],
	                 coords->triangulo.coordinates[dta->triangulatoro.index[offs + 2] + 2]);
              glVertex3d(coords->triangulo.coordinates[dta->triangulatoro.index[offs + 3]],
	                 coords->triangulo.coordinates[dta->triangulatoro.index[offs + 3] + 1],
	                 coords->triangulo.coordinates[dta->triangulatoro.index[offs + 3] + 2]);
	    break;
	    case 6:
              glNormal3f(coords->trianguleto.coordinates[dta->triangulatoro.index[offs]],
	                 coords->trianguleto.coordinates[dta->triangulatoro.index[offs] + 1],
	                 coords->trianguleto.coordinates[dta->triangulatoro.index[offs] + 2]);
              glVertex3f(coords->trianguleto.coordinates[dta->triangulatoro.index[offs + 1]],
	                 coords->trianguleto.coordinates[dta->triangulatoro.index[offs + 1] + 1],
	                 coords->trianguleto.coordinates[dta->triangulatoro.index[offs + 1] + 2]);
              glVertex3f(coords->trianguleto.coordinates[dta->triangulatoro.index[offs + 2]],
	                 coords->trianguleto.coordinates[dta->triangulatoro.index[offs + 2] + 1],
	                 coords->trianguleto.coordinates[dta->triangulatoro.index[offs + 2] + 2]);
              glVertex3d(coords->trianguleto.coordinates[dta->triangulatoro.index[offs + 3]],
	                 coords->trianguleto.coordinates[dta->triangulatoro.index[offs + 3] + 1],
	                 coords->trianguleto.coordinates[dta->triangulatoro.index[offs + 3] + 2]);
	    break;
          }
          if (Wireframe) glEnd();
	  offs += 4;
	}
	dta = (union Unu *) &(dta->Data[sz]);
      break;
      case 3:
#ifdef DUMP_VIEW_DATA
        cPrintfI("%d triangles ", dta->triangulo.repeated);
        cPrintfI("[%d] ...\n", sz);
#endif
        for (rep = offs = 0; rep < dta->triangulo.repeated; rep++) {
#ifdef DUMP_VIEW_DATA
	  cPrintfF(" n %8.3f", (float) dta->triangulo.coordinates[offs]);
	  cPrintfF(" %8.3f", (float) dta->triangulo.coordinates[offs + 1]);
	  cPrintfF(" %8.3f\n", (float) dta->triangulo.coordinates[offs + 2]);
	  cPrintfF("   %8.3f", (float) dta->triangulo.coordinates[offs + 3]);
	  cPrintfF(" %8.3f", (float) dta->triangulo.coordinates[offs + 4]);
	  cPrintfF(" %8.3f\n", (float) dta->triangulo.coordinates[offs + 5]);
	  cPrintfF("   %8.3f", (float) dta->triangulo.coordinates[offs + 6]);
	  cPrintfF(" %8.3f", (float) dta->triangulo.coordinates[offs + 7]);
	  cPrintfF(" %8.3f\n", (float) dta->triangulo.coordinates[offs + 8]);
	  cPrintfF("   %8.3f", (float) dta->triangulo.coordinates[offs + 9]);
	  cPrintfF(" %8.3f", (float) dta->triangulo.coordinates[offs + 10]);
	  cPrintfF(" %8.3f\n", (float) dta->triangulo.coordinates[offs + 11]);
#endif
	  if (Wireframe) glBegin(GL_LINE_LOOP);
	  if (simple_color && !Wireframe)
	  SimpleColorSetNormal(dta->triangulo.coordinates[offs     ],
                               dta->triangulo.coordinates[offs +  1],
                               dta->triangulo.coordinates[offs +  2]);
#ifdef FADEN_1
	  NLG = dta->triangulo.coordinates[offs    ] * dta->triangulo.coordinates[offs    ]
              + dta->triangulo.coordinates[offs + 1] * dta->triangulo.coordinates[offs + 1]
	      + dta->triangulo.coordinates[offs + 2] * dta->triangulo.coordinates[offs + 2];
	  if (NLGmin > NLG) NLGmin = NLG;
	  if (NLGmax < NLG) NLGmax = NLG;
#endif
          glNormal3d(dta->triangulo.coordinates[offs     ],
                     dta->triangulo.coordinates[offs +  1],
                     dta->triangulo.coordinates[offs +  2]);
          glVertex3d(dta->triangulo.coordinates[offs +  3],
                     dta->triangulo.coordinates[offs +  4],
                     dta->triangulo.coordinates[offs +  5]);
          glVertex3d(dta->triangulo.coordinates[offs +  6],
                     dta->triangulo.coordinates[offs +  7],
                     dta->triangulo.coordinates[offs +  8]);
          glVertex3d(dta->triangulo.coordinates[offs +  9],
                     dta->triangulo.coordinates[offs + 10],
                     dta->triangulo.coordinates[offs + 11]);
#ifdef FADEN_1
	  ndmin = ndmax = dta->triangulo.coordinates[offs     ] * dta->triangulo.coordinates[offs +  3]
	                + dta->triangulo.coordinates[offs +  1] * dta->triangulo.coordinates[offs +  4]
			+ dta->triangulo.coordinates[offs +  2] * dta->triangulo.coordinates[offs +  5];
	  nd = dta->triangulo.coordinates[offs     ] * dta->triangulo.coordinates[offs +  6]
             + dta->triangulo.coordinates[offs +  1] * dta->triangulo.coordinates[offs +  7]
	     + dta->triangulo.coordinates[offs +  2] * dta->triangulo.coordinates[offs +  8];
	  if (nd > ndmax) ndmax = nd; if (nd < ndmin) ndmin = nd;
	  nd = dta->triangulo.coordinates[offs     ] * dta->triangulo.coordinates[offs +  9]
	     + dta->triangulo.coordinates[offs +  1] * dta->triangulo.coordinates[offs + 10]
	     + dta->triangulo.coordinates[offs +  2] * dta->triangulo.coordinates[offs + 11];
	  if (nd > ndmax) ndmax = nd; if (nd < ndmin) ndmin = nd;
	  if (nddiff < ndmax - ndmin) nddiff = ndmax - ndmin;
#endif
#ifdef DUMP_MAT
          fprintf(trail, "Normal:\n%9.3lf %9.3lf %9.3lf\n"
	                 "Vertex:\n%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n%9.3lf %9.3lf %9.3lf\n",
                     dta->triangulo.coordinates[offs     ],
                     dta->triangulo.coordinates[offs +  1],
                     dta->triangulo.coordinates[offs +  2],
                     dta->triangulo.coordinates[offs +  3],
                     dta->triangulo.coordinates[offs +  4],
                     dta->triangulo.coordinates[offs +  5],
                     dta->triangulo.coordinates[offs +  6],
                     dta->triangulo.coordinates[offs +  7],
                     dta->triangulo.coordinates[offs +  8],
                     dta->triangulo.coordinates[offs +  9],
                     dta->triangulo.coordinates[offs + 10],
                     dta->triangulo.coordinates[offs + 11]);
          fflush(trail);
#endif
          if (Wireframe) glEnd();
	  offs += 12;
	}
	dta = (union Unu *) &(dta->Data[sz]);
      break;
      case 2:
#ifdef DUMP_VIEW_DATA
        cPrintfI("%d small triangles ", dta->trianguleto.repeated);
        cPrintfI("[%d] ...\n", sz);
#endif
        for (rep = offs = 0; rep < dta->trianguleto.repeated; rep++) {
#ifdef DUMP_VIEW_DATA
	  cPrintfF(" n %8.3f", dta->trianguleto.coordinates[offs]);
	  cPrintfF(" %8.3f", dta->trianguleto.coordinates[offs + 1]);
	  cPrintfF(" %8.3f\n", dta->trianguleto.coordinates[offs + 2]);
	  cPrintfF("   %8.3f", dta->trianguleto.coordinates[offs + 3]);
	  cPrintfF(" %8.3f", dta->trianguleto.coordinates[offs + 4]);
	  cPrintfF(" %8.3f\n", dta->trianguleto.coordinates[offs + 5]);
	  cPrintfF("   %8.3f", dta->trianguleto.coordinates[offs + 6]);
	  cPrintfF(" %8.3f", dta->trianguleto.coordinates[offs + 7]);
	  cPrintfF(" %8.3f\n", dta->trianguleto.coordinates[offs + 8]);
	  cPrintfF("   %8.3f", dta->trianguleto.coordinates[offs + 9]);
	  cPrintfF(" %8.3f", dta->trianguleto.coordinates[offs + 10]);
	  cPrintfF(" %8.3f\n", dta->trianguleto.coordinates[offs + 11]);
#endif
          if (Wireframe) glBegin(GL_LINE_LOOP);
          if (simple_color && !Wireframe)
          SimpleColorSetNormal((double) dta->trianguleto.coordinates[offs     ],
                               (double) dta->trianguleto.coordinates[offs +  1],
                               (double) dta->trianguleto.coordinates[offs +  2]);
          glNormal3f(dta->trianguleto.coordinates[offs     ],
                     dta->trianguleto.coordinates[offs +  1],
                     dta->trianguleto.coordinates[offs +  2]);
          glVertex3f(dta->trianguleto.coordinates[offs +  3],
                     dta->trianguleto.coordinates[offs +  4],
                     dta->trianguleto.coordinates[offs +  5]);
          glVertex3f(dta->trianguleto.coordinates[offs +  6],
                     dta->trianguleto.coordinates[offs +  7],
                     dta->trianguleto.coordinates[offs +  8]);
          glVertex3f(dta->trianguleto.coordinates[offs +  9],
                     dta->trianguleto.coordinates[offs + 10],
                     dta->trianguleto.coordinates[offs + 11]);
          if (Wireframe) glEnd();
	  offs += 12;
	}
	dta = (union Unu *) &(dta->Data[sz]);
      break;
      case 9:
        if (stop_at_endsolid) return;
      default: /* perhaps 9= EndSolid */
#ifdef DUMP_VIEW_DATA
        cPrintfI("Unknown %lx ", typ);
        cPrintfI("[%ld] ...\n", sz);
#endif
	dta = (union Unu *) &(dta->Data[sz]);
      break;
    }
  }
}

void DisplayModelFromMemory(void)
{ struct MODEL_SELECT *vmod;
#ifdef FADEN_1
  float maxr, maxg, maxb, minr, ming, minb;
  double NLGmin, NLGmax, NLG, nd, ndmin, ndmax, nddiff;
  maxr = maxg = maxb = 0.0; minr = ming = minb = 0.0;
  NLGmin = 1.0; NLGmax = 0.0, nddiff = 0.0;
#endif
  // glColor3f(0.2, 0.2, 0.2);
  if (TDate == NULL) return;
  if (simple_color && !Wireframe) {
    glShadeModel(GL_FLAT); report_glerror(__LINE__);
    glDisable(GL_LIGHTING); report_glerror(__LINE__);
    glDisable(GL_LIGHT0); report_glerror(__LINE__);
  }
  if (UseLists) {
    if (!RebuildLists) {
      /* nderung von Wireframe setzt RebuildLists auf 1 */
      for (vmod = model_select_chain; vmod != NULL; vmod = vmod->next)
       if ((vmod->Name != NULL)
        && (vmod->Start != NULL)
        && (ObjectsShowAll || (vmod->Display == 1)))
         glCallList(vmod->Number);
      return;
    }
    /* RebuildLists */
#ifdef FADEN_2
    cPrintfI("VALID_MODES = %d\n", VALID_MODELS);
#endif
#ifdef DUMP_MODEL_SELECT_RECORDS
    DumpModelSelectRecord();
#endif
#ifdef FADEN_2
    cPrintfI("VALID_MODES = %d\n", VALID_MODELS);
#endif
    for (vmod = model_select_chain; vmod != NULL; vmod = vmod->next)
     if ((vmod->Name != NULL)
      && (vmod->Start != NULL)) {
      glNewList(vmod->Number, (ObjectsShowAll || (vmod->Display == 1)) ? GL_COMPILE_AND_EXECUTE : GL_COMPILE);
      if (!Wireframe) glBegin(GL_TRIANGLES);
      GraphicsDataInterpretation(             vmod->Start,
        /* Reset Coord Array Pointer       */ 1,
        /* Coord Pointer and Type at Start */ vmod->ValidCoords, vmod->ValidCoordType,
        /* Stop at Endsolid                */ 1);
      if (!Wireframe) glEnd();
      glEndList();
    }
    RebuildLists = 0;
  } else { /* e.g. simple_color, or "no option" */
    if (!Wireframe) glBegin(GL_TRIANGLES);
    if (!ObjectsShowAll) {
      for (vmod = model_select_chain; vmod != NULL; vmod = vmod->next)
       if ((vmod->Name != NULL)
	&& (vmod->Start != NULL)
        && (vmod->Display == 1))
        GraphicsDataInterpretation(             vmod->Start,
          /* Reset Coord Array Pointer       */ 1,
          /* Coord Pointer and Type at Start */ vmod->ValidCoords, vmod->ValidCoordType,
          /* Stop at Endsolid                */ 1);
    } else {
      GraphicsDataInterpretation((union Unu *) &(TDate->Data[0]),
        /* Reset Coord Array Pointer       */  1,
        /* Coord Pointer and Type at Start */  NULL, 0,
        /* Stop at Endsolid                */  0);
    }
    if (!Wireframe) glEnd();
  }
#ifdef FADEN_1
  cPrintfI("Farbwerte:\n", 0);
  cPrintfF("R = %f ..", minr); cPrintfF(" %f\n", maxr);
  cPrintfF("G = %f ..", ming); cPrintfF(" %f\n", maxg);
  cPrintfF("B = %f ..", minb); cPrintfF(" %f\n", maxb);
  cPrintfI("\nModellgre:\n", 0);
  cPrintfF("[ %6.3f ..", (float) xmin); cPrintfF(" %6.3f ", (float) xmax);
  cPrintfF("| %6.3f ..", (float) ymin); cPrintfF(" %6.3f ", (float) ymax);
  cPrintfF("| %6.3f ..", (float) zmin); cPrintfF(" %6.3f ]\n", (float) zmax);
  cPrintfI("\nNormalenlngen zum Quadrat:\n", 0);
  cPrintfF("  %6.3f ..", (float) NLGmin); cPrintfF(" %.3f\n", (float) NLGmax);
  cPrintfF("Endpunkthhendifferenz: %6.4f\n\n", (float) nddiff);
#endif
}


void NoModelDefaultModel(void)
{
  if (lighty_models) glColor3f(1.0F, 0.5F, 0.5F); else glColor3f(1.0F, 0.0F, 0.0F);
  S_FONT_stroketext(1.0, 1.0, - 0.5F * S_FONT_stringwidth(1.0, 1.0, Title1eo), 4.0, 3.0, Title1eo, !Wireframe);
  S_FONT_stroketext(1.0, 1.0, - 0.5F * S_FONT_stringwidth(1.0, 1.0, Title2eo), 2.0, 3.0, Title2eo, !Wireframe);
  S_FONT_stroketext(1.0, 1.0, - 0.5F * S_FONT_stringwidth(1.0, 1.0, Title3eo), 0.0, 3.0, Title3eo, !Wireframe);
  if (lighty_models) glColor3f(0.5F, 0.5F, 1.0F); else glColor3f(0.0F, 0.0F, 1.0F);
  S_FONT_stroketext(VSC, VSW, - 0.5F * S_FONT_stringwidth(VSC, VSW, Versn_eo), 2.5 - 0.5 * VSC, 0.5, Versn_eo, !Wireframe);

  glPushMatrix();
  glRotated(180.0, 0.0, 1.0, 0.0);

  if (lighty_models) glColor3f(0.9F, 1.0F, 0.5F); else glColor3f(0.8F, 1.0F, 0.0F);
  S_FONT_stroketext(1.0, 1.0, - 0.5F * S_FONT_stringwidth(1.0, 1.0, Title1en), 4.0, 3.0, Title1en, !Wireframe);
  S_FONT_stroketext(1.0, 1.0, - 0.5F * S_FONT_stringwidth(1.0, 1.0, Title2en), 2.0, 3.0, Title2en, !Wireframe);
  S_FONT_stroketext(1.0, 1.0, - 0.5F * S_FONT_stringwidth(1.0, 1.0, Title3en), 0.0, 3.0, Title3en, !Wireframe);
  if (lighty_models) glColor3f(0.5F, 0.5F, 1.0F); else glColor3f(0.0F, 0.0F, 1.0F);
  S_FONT_stroketext(VSC, VSW, - 0.5F * S_FONT_stringwidth(VSC, VSW, Versn_en), 2.5F - 0.5F * VSC, 0.5F, Versn_en, !Wireframe);

  glPopMatrix();
}

void NoModelExtent(void)
{ float sz;
  xmax = 0.5 * S_FONT_stringwidth(1.0, 1.0, Title1en);
  sz = 0.5F * S_FONT_stringwidth(1.0, 1.0, Title2en); if (sz > xmax) xmax = sz;
  sz = 0.5F * S_FONT_stringwidth(1.0, 1.0, Title3en); if (sz > xmax) xmax = sz;
  sz = 0.5F * S_FONT_stringwidth(1.0, 1.0, Title1eo); if (sz > xmax) xmax = sz;
  sz = 0.5F * S_FONT_stringwidth(1.0, 1.0, Title2eo); if (sz > xmax) xmax = sz;
  sz = 0.5F * S_FONT_stringwidth(1.0, 1.0, Title3eo); if (sz > xmax) xmax = sz;
  sz = 0.5F * S_FONT_stringwidth(VSC, VSW, Versn_en); if (sz > xmax) xmax = sz;
  sz = 0.5F * S_FONT_stringwidth(VSC, VSW, Versn_eo); if (sz > xmax) xmax = sz;
  xmin = - xmax;
  ymin = 0.0; ymax = 5.0;
  zmin = -3.0; zmax = 3.0;
}


void view_pan_limit(void)
{ double Limitation;
  Limitation = 1.0 - 1.0 / view_scale;
  if (view_x < - Limitation) view_x = - Limitation;
  if (view_x >   Limitation) view_x =   Limitation;
  if (view_y < - Limitation) view_y = - Limitation;
  if (view_y >   Limitation) view_y =   Limitation;
}

void view_pan(WORD x, WORD y)
{ double dx, dy;
  dx = (x - screen_center_x) * 2.0 / screen_size / view_scale;
  dy = (y - screen_center_y) * 2.0 / screen_size / view_scale;
  if (mouse_inversion & 4) {
    view_x += dx; view_y -= dy;
  } else {
    view_x -= dx; view_y += dy;
  }
}

void view_zoom(WORD y)
{ double dy, veraenderung;
  dy = (screen_center_y - y) * 2.0 / screen_size;
  // f = pow((double) sqrt(8.0), dy);
  veraenderung = exp((mouse_inversion & 2) ? -dy : dy);
  view_scale *= veraenderung;
  if (view_scale > MaxZoomFaktor) view_scale = MaxZoomFaktor;
  if (view_scale < 1.0) view_scale = 1.0;
}


#define DRAW_ADD_ROT 1

void DrawExtend(HDC hdc, RECT clientRect)
{ char Zl[100];
  wchar_t wZl[100];
  TEXTMETRIC tm;
  GetTextMetrics(hdc, &tm);
  SetBkMode(hdc, TRANSPARENT);
  SetTextColor(hdc, (39 * SBG_R + 44 * SBG_G + 17 * SBG_B < 12800) ? RGB(255, 255, 255) : RGB(0, 0, 0));
  sprintf(Zl, "X: %+9lE ... %+9lE", xmin, xmax);
  wsprintf(wZl, L"%S", Zl);
  TextOut(hdc, 3, clientRect.bottom - (tm.tmHeight + tm.tmInternalLeading) * 3, wZl, wcslen(wZl));
  sprintf(Zl, "Y: %+9lE ... %+9lE", ymin, ymax);
  wsprintf(wZl, L"%S", Zl);
  TextOut(hdc, 3, clientRect.bottom - (tm.tmHeight + tm.tmInternalLeading) * 2, wZl, wcslen(wZl));
  sprintf(Zl, "Z: %+9lE ... %+9lE", zmin, zmax);
  wsprintf(wZl, L"%S", Zl);
  TextOut(hdc, 3, clientRect.bottom - (tm.tmHeight + tm.tmInternalLeading) * 1, wZl, wcslen(wZl));
}

void Draw3D(HDC hDC, RECT clientRect, int addition, WORD x, WORD y)
{
    GLdouble li, re, ob, ut, dx, dy, dw;

    if (!VALID_MODELS && !IN_FILE_DIALOG) NoModelExtent();

    xc = xmax - xmin;
    yc = ymax - ymin;
    zc = zmax - zmin;
    halfdiagonal = sqrt(xc * xc + yc * yc + zc * zc) * 0.5;
    scale = 1.0 / halfdiagonal / RANDFAKTOR;
    xc = (xmax + xmin) * 0.5F;
    yc = (ymax + ymin) * 0.5F;
    zc = (zmax + zmin) * 0.5F;

    screen_center_x = 0.5F * clientRect.right;
    screen_center_y = 0.5F * clientRect.bottom;

    if (clientRect.right > clientRect.bottom) {
      ob = 1.0; ut = -1.0;
      re = ((double) clientRect.right) / ((double) clientRect.bottom);
      li = -re;
      screen_size = (float) clientRect.bottom;
    } else {
      li = -1.0; re = 1.0;
      ob = ((double) clientRect.bottom) / ((double) clientRect.right);
      ut = -ob;
      screen_size = (float) clientRect.right;
    }
    if (screen_size <= 0.0) screen_size = 1.0;

    view_pan_limit();
    li = li / view_scale + view_x;
    re = re / view_scale + view_x;
    ob = ob / view_scale + view_y;
    ut = ut / view_scale + view_y;

    SetCursor(NULL);

    wglMakeCurrent(hDC, hglrc);
    glMatrixMode(GL_PROJECTION); report_glerror(__LINE__);
    glLoadIdentity(); report_glerror(__LINE__);
    glViewport(0, 0, clientRect.right, clientRect.bottom); report_glerror(__LINE__);
    glOrtho(li, re, ut, ob, -1.0, 1.0); report_glerror(__LINE__);

    glMatrixMode(GL_MODELVIEW); report_glerror(__LINE__);
    glLoadIdentity(); report_glerror(__LINE__);

    if (Wireframe) {
      glShadeModel(GL_FLAT); report_glerror(__LINE__);
    } else {
      glShadeModel(GL_SMOOTH); report_glerror(__LINE__);
    }
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL); report_glerror(__LINE__);
    // glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,  specular); report_glerror(__LINE__);
    // glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, shininess); report_glerror(__LINE__);
    // glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT,   ambient); report_glerror(__LINE__);
    // glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE,   diffuse); report_glerror(__LINE__);
    glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE); report_glerror(__LINE__);
    glEnable(GL_COLOR_MATERIAL); report_glerror(__LINE__);
    // glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient);
    glLightfv(GL_LIGHT0, GL_POSITION, position0); report_glerror(__LINE__);
    // glLightfv(GL_LIGHT0, GL_AMBIENT, ambient); report_glerror(__LINE__);
    // glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse); report_glerror(__LINE__);
    if (Wireframe) {
      glDisable(GL_LIGHTING); report_glerror(__LINE__);
    } else {
      glEnable(GL_LIGHTING); report_glerror(__LINE__);
    }
    glEnable(GL_LIGHT0); report_glerror(__LINE__);
    glEnable(GL_DEPTH_TEST); report_glerror(__LINE__);

    if (CullFace) {
      glCullFace(GL_BACK); report_glerror(__LINE__);
      glEnable(GL_CULL_FACE); report_glerror(__LINE__);
    } else {
      glDisable(GL_CULL_FACE); report_glerror(__LINE__);
    }

    glColor4f(1.0, 1.0, 1.0, 1.0); report_glerror(__LINE__);
    if (simple_color && !Wireframe) SimpleColorSave(1.0, 1.0, 1.0);

    glClearColor(bg_r, bg_g, bg_b, 0.0); report_glerror(__LINE__);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); report_glerror(__LINE__);

	if (!IN_FILE_DIALOG) {
    switch(Projection) {
      case PROJ_LAST:
        glLoadMatrixd(MVMat); report_glerror(__LINE__);
      break;
      /* case PROJ_FRONT: break; */
      case PROJ_LEFT:
        Rotate0(90.0, 0.0, 1.0, 0.0);
      break;
      case PROJ_RIGHT:
        Rotate0(-90.0, 0.0, 1.0, 0.0);
      break;
      case PROJ_BACK:
        Rotate0(180.0, 0.0, 1.0, 0.0);
      break;
      case PROJ_TOP:
        Rotate0(90.0, 1.0, 0.0, 0.0);
      break;
      case PROJ_BOTTOM:
        Rotate0(-90.0, 1.0, 0.0, 0.0);
      break;
      case PROJ_ISO:
        Rotate0(-45.0, 0.0, 1.0, 0.0);
        Rotate0(35.26439, 1.0, 0.0, 0.0);
      break;
      case PROJ_DI:
        Rotate0(-20.705, 0.0, 1.0, 0.0);
        Rotate0(19.471, 1.0, 0.0, 0.0);
      break;
      case PROJ_TRI:
        Rotate0(-37.761, 0.0, 1.0, 0.0);
        Rotate0(14.763, 1.0, 0.0, 0.0);
      break;
    }
    if (Projection != PROJ_LAST) glScaled(scale, scale, scale);
    switch(addition) {
      case DRAW_ADD_ROT:
        if (mouse_inversion & 1) {
          dx = screen_center_x - x;
          dy = screen_center_y - y;
	} else {
          dx = x - screen_center_x;
          dy = y - screen_center_y;
	}
	dw = sqrt(dx * dx + dy * dy) / screen_size * 180.0 / view_scale;
	Rotate0(dw, dy, dx, 0.0);
        Projection = PROJ_LAST;
      break;
    }
    glGetDoublev(GL_MODELVIEW_MATRIX, MVMat); report_glerror(__LINE__); dump_Mat();
    glTranslated(-xc, -yc, -zc);
    /* I scaled the model to match a viewing port size of -1.0 .. 1.0, and on large
     * Models the colors were too light. Normalizing of the normal vectors did help
     * correcting the colors.
     */
    glEnable(GL_NORMALIZE);

    /* Display Model */
    if (VALID_MODELS) DisplayModelFromMemory(); else NoModelDefaultModel();

    /* Display Coordinate System, when requested */
    if (Disp_CS) CoordinateSystem();
    }

    glFlush(); report_glerror(__LINE__);
    wglMakeCurrent(NULL, NULL);
    SetCursor(LoadCursor(NULL, IDC_CROSS));
}


void DrawScene(HWND hwnd, int addition, WORD x, WORD y)
{
    HDC hDC;
    PAINTSTRUCT paintStruct;
    RECT clientRect;

    InvalidateRect(hwnd, NULL, FALSE);

    hDC = BeginPaint(hwnd, &paintStruct);
    if (hDC != NULL) {
      GetClientRect(hwnd, &clientRect);
      Draw3D(hDC, clientRect, addition, x, y);
      if (Disp_Extend) DrawExtend(hDC, clientRect);
      EndPaint(hwnd, &paintStruct);
    }
}

BOOL InsertSubmenuString(HMENU hMenu, UINT Pos, BOOL byPos, HMENU submenu, WCHAR *Text)
{ MENUITEMINFO mii;
  // char Name[100];
  mii.cbSize = sizeof(MENUITEMINFO);
  mii.fMask = MIIM_SUBMENU | MIIM_TYPE;
  mii.fType = MFT_STRING;
  mii.fState = MFS_DEFAULT;
  mii.wID = 0;
  mii.hSubMenu = submenu;
  mii.hbmpChecked = NULL;
  mii.hbmpUnchecked = NULL;
  mii.dwItemData = 0;
  mii.dwTypeData = Text;
  mii.cch = wcslen(Text);
  return InsertMenuItem(hMenu, Pos, byPos, &mii);
}

void BuildMenue(HWND hwnd)
{ HMENU newmenu, oldmenu;

  langmenu = CreateMenu();
  AppendMenu(langmenu, MF_STRING, MN_SET_LANG_EO,  L"Esperant&o");
  AppendMenu(langmenu, MF_STRING, MN_SET_LANG_EOX, L"Esperanto &X kodo");
  AppendMenu(langmenu, MF_STRING, MN_SET_LANG_GER, L"&Deutsch");
  AppendMenu(langmenu, MF_STRING, MN_SET_LANG_ENG, L"&English");

  newmenu = CreateMenu();

  filemenu = CreateMenu();
  AppendMenu(filemenu, MF_STRING, MN_FILE_OPEN,
             StrByLang(X_CODING, L"&aperti", L"\xffff",
	               L"&ffnen",
		       L"&open",
		       NULL));
  AppendMenu(filemenu, MF_STRING, MN_FILE_SAVE,
             StrByLang(X_CODING, L"&sekurigi", L"\xffff",
	               L"&speichern",
		       L"&save",
		       NULL));
  AppendMenu(filemenu, MF_SEPARATOR, 0, NULL);
  AppendMenu(filemenu, MF_STRING, MN_FILE_QUIT,
             StrByLang(X_CODING, US_cx L"&esu\tQ", L"cx&esu\tQ",
	               L"&beenden\tQ",
		       L"&quit\tQ",
		       NULL));
  InsertSubmenuString(newmenu, -1, TRUE, filemenu,
                      StrByLang(X_CODING, L"&Dosiero", L"\xffff",
		      L"&Datei",
		      L"&File",
		      NULL));

  viewmenu = CreateMenu();
  AppendMenu(viewmenu, MF_STRING, MN_VIEW_FRONT,
             StrByLang(X_CODING, L"anta" US_ux L"a\tJ", L"antauxa\tJ",
	               L"Aufriss\tJ",
		       L"front\tJ",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_VIEW_LEFT,
             StrByLang(X_CODING, L"maldekstra\tK", L"\xffff",
	               L"Seitenriss v. links\tK",
		       L"left\tK",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_VIEW_TOP,
             StrByLang(X_CODING, L"supra\tM", L"\xffff",
	               L"Grundriss\tM",
		       L"top\tM",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_VIEW_RIGHT,
             StrByLang(X_CODING, L"dekstra\tH", L"\xffff",
	               L"Seitenriss v. rechts\tH",
		       L"right\tH",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_VIEW_BACK,
             StrByLang(X_CODING, L"malanta" US_ux L"a\tL", L"malantauxa\tL",
	               L"von hinten\tL",
		       L"back\tL",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_VIEW_BOTTOM,
             StrByLang(X_CODING, L"malsupra\tU", L"\xffff",
	               L"von unten\tU",
		       L"bottom\tU",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_VIEW_ISO,
             StrByLang(X_CODING, L"&IZO (1:1:1)\tI", L"\xffff",
	               L"&Isometrie (1:1:1)\tI",
		       L"&isometric (1/1/1)\tI",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_VIEW_DI,
             StrByLang(X_CODING, L"&DI (2:2:1)\tD", L"\xffff",
	               L"&Dimetrie (2:2:1)\tD",
		       L"&dimetric (2/2/1)\tD",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_VIEW_TRI,
             StrByLang(X_CODING, L"&TRI (6:5:4)\tT", L"\xffff",
	               L"&Trimetire (6:5:4)\tT",
		       L"&trimetric (6/5/4)\tT",
		       NULL));
  AppendMenu(viewmenu, MF_SEPARATOR, 0, NULL);
  AppendMenu(viewmenu, MF_STRING, MN_ZOOM_PLUS,
             StrByLang(X_CODING, L"&pligrani\t+", L"\xffff",
	               L"ver&grern\t+",
		       L"en&large\t+",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_ZOOM_MINUS,
             StrByLang(X_CODING, L"&malgrani\t-", L"\xffff",
	               L"ver&kleinern\t-",
		       L"scale &down\t-",
		       NULL));
  AppendMenu(viewmenu, MF_STRING, MN_ZOOM_FIT,
             StrByLang(X_CODING, L"&akomodi\t#", L"\xffff",
	               L"ein&passen\t#",
		       L"&fit in\t#",
		       NULL));
  AppendMenu(viewmenu, MF_SEPARATOR, 0, NULL);
  AppendMenu(viewmenu, MF_STRING, MN_PART_DISP,
             StrByLang(X_CODING, L"&videblaj objektoj", L"\xffff",
	               L"&Objektdarstellung",
		       L"&object display status",
		       NULL));
  InsertSubmenuString(newmenu, -1, TRUE, viewmenu,
                      StrByLang(X_CODING, L"&Vida" US_jx L"oj", L"&Vidajxoj",
		                L"&Ansichten",
				L"&Viewing",
				NULL));

  mousemenu = CreateMenu();
  AppendMenu(mousemenu, MF_STRING, MN_MOUSE_L_INV,
             StrByLang(X_CODING, L"inversigi ago de mald&ekstra musa butono (rotacio)", L"\xffff",
	                         L"Rotationsrichtung (&linke Maustaste) umkehren",
		                 L"invert &left mouse button click rotation direction",
		                 NULL));
  AppendMenu(mousemenu, MF_STRING, MN_MOUSE_M_INV,
             StrByLang(X_CODING, L"inversigi ago de &dekstra musa butono (zumo)", L"\xffff",
	                         L"Skalierungsrichtung (&mittlere Maustaste) umkehren",
		                 L"invert &middle mouse button click scaling direction",
		                 NULL));
  AppendMenu(mousemenu, MF_STRING, MN_MOUSE_R_INV,
             StrByLang(X_CODING, L"inversigi ago de &meza musa butono (for" US_sx L"ovo)",
                                 L"inversigi ago de &meza musa butono (forsxovo)",
	                         L"Verschieberichtung (&rechte Maustaste) umkehren",
		                 L"invert &right mouse button click movement direction",
		                 NULL));
  InsertSubmenuString(newmenu, -1, TRUE, mousemenu,
                      StrByLang(X_CODING, L"&Movoj", L"\xffff",
		                L"&Bewegungen",
				L"&Movements",
				NULL));

  optionsmenu = CreateMenu();
  AppendMenu(optionsmenu, MF_STRING, MN_SET_BACKGRND,
             StrByLang(X_CODING, L"malanta" US_ux L"a &koloro", L"malantauxa &koloro",
	               L"&Hintergrundfarbe",
		       L"&background color",
		       NULL));
  AppendMenu(optionsmenu, MF_STRING, MN_SET_LIGHTY,
             StrByLang(X_CODING, L"&helaj korpoj", L"\xffff",
	               L"helle &Krper",
		       L"light &model colors",
		       NULL));
  AppendMenu(optionsmenu, MF_STRING, MN_SET_SIMPLCOL,
             StrByLang(X_CODING, L"&simplaj coloroj", L"\xffff",
	               L"einfache &Farben",
		       L"&simplified colors",
		       NULL));
  AppendMenu(optionsmenu, MF_STRING, MN_SET_LISTS,
             StrByLang(X_CODING, L"openGL &listoj", L"\xffff",
	               L"openGL-&Listen",
		       L"openGL &lists",
		       NULL));
  AppendMenu(optionsmenu, MF_STRING, MN_SET_WIREFRAME,
             StrByLang(X_CODING, L"drata &montri", L"\xffff",
	               L"&Drahtmodell",
		       L"&wireframe",
		       NULL));
  AppendMenu(optionsmenu, MF_STRING, MN_SET_CULL,
             StrByLang(X_CODING, L"malanta" US_ux L"a edro", L"malantauxa &edro",
	               L"Flchen&rckseiten",
		       L"back &faces",
		       NULL));
  AppendMenu(optionsmenu, MF_STRING, MN_SET_CS,
             StrByLang(X_CODING, L"montri &centron\tC", L"\xffff",
	               L"&Mittelpunkte u.s.w.\tC",
		       L"&center, koordinates\tC",
		       NULL));
  AppendMenu(optionsmenu, MF_STRING, MN_SET_EXTEND,
             StrByLang(X_CODING, L"&dimensio\tX", L"\xffff",
	               L"&Abmessungen\tX",
		       L"over all &dimension\tX",
		       NULL));
  AppendMenu(optionsmenu, MF_STRING, MN_SET_CALLEXIT,
             StrByLang(X_CODING, L"&anstata" US_ux L"aj programoj",
		                 L"&anstatauxaj programoj",
				 L"andere &Programme",
				 L"&other applications",
				 NULL));
  InsertSubmenuString(optionsmenu, -1, TRUE, langmenu,
                      StrByLang(X_CODING, L"lingv&oj", L"\xffff",
		                L"&Sprachen",
				L"languag&es",
				NULL));
  InsertSubmenuString(newmenu, -1, TRUE, optionsmenu,
                      StrByLang(X_CODING, L"&Kazoj", L"\xffff",
		                L"&Einstellungen",
				L"&Settings",
				NULL));
  AppendMenu(newmenu, MF_STRING, MN_INFO, L"&?");
  /*
   * dosiero         vidajxoj           movoj   kazoj                       ?
   * - aperti        - antauxa     J            - malantauxa koloro
   * - sekurigi      - maldekstra  K            - helaj korpoj
   * ------------    - supra       M            - simplaj coloroj
   * - cxesu    Q    - dekstra     H            - openGL listoj
   *                 - malantauxa  L            - drata montri
   *                 - malsupra    U            - malantauxa edro
   *                 - IZO (1:1:1) I            - montri centron     C
   *                 - DI (2:2:1)  D            - dimensio           X
   *                 - TRI (6:5:4) T            - anstatauxaj programoj
   *                 ---------------            - lingvo -> Esperanto
   *                 - pligrandi   +                        Esperanto X kodo
   *                 - malgrandi   -                        Deutsch
   *                 - akomodi     #                        English
   *                 ---------------
   *                 - 
   *********************************************************************
   * Datei           Ansichten                    Bewegungen   Einstellungen              ?
   * - ffnen        - Aufriss              J                  - Hintergrundfarbe
   * - speichern     - Seitenriss v. links  K                  - helle Krper
   * -----------     - Grundriss            M                  - einfache Farben
   * - Beenden  Q    - Seitenriss v. rechts H                  - openGL-Listen
   *                 - von hinten           L                  - Drahtmodell
   *                 - von unten            U                  - Flchenrckseiten
   *                 - Isometrie (1:1:1)    I                  - Mittelpunkte u.s.w.  C
   *                 - Dimetrie (2:2:1)     D                  - Abmessungen          X
   *                 - Trimetrie (6:5:4)    T                  - andere Programme
   *                 ------------------------                  - Sprachen -> Esperanto
   *                 - vergrern           +                                Esperanto X kodo
   *                 - verkleinern          -                                Deutsch
   *                 - einpassen            #                                English
   *                 ------------------------
   *                 - Objektdarstellung
   *******************************************************************************
   * File            Viewing                      Movements   Settings
   * - open          - front                J                 - background color
   * - save          - left                 K                 - light model colors
   * ----------      - top                  M                 - simplified colors
   * - quit   Q      - right                H                 - openGL lists
   *                 - back                 L                 - wireframe
   *                 - bottom               U                 - back faces
   *                 - isometric (1/1/1)    I                 - center, koordinates  C
   *                 - dimetric (2/2/1)     D                 - over all dimension   X
   *                 - trimetric (6/5/4)    T                 - other applications
   *                 ------------------------                 - languages -> Esperanto
   *                 - enlarge              +                                Esperanto X kodo
   *                 - scale down           -                                Deutsch
   *                 - fit in               #                                English
   *                 ------------------------
   *                 - object display status
   */
  oldmenu = GetMenu(hwnd);
  SetMenu(hwnd, newmenu);
  DestroyMenu(oldmenu);
  DrawMenuBar(hwnd);
  CheckMenuItem(optionsmenu, MN_SET_CS, MF_BYCOMMAND | (Disp_CS ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(optionsmenu, MN_SET_EXTEND, MF_BYCOMMAND | (Disp_Extend ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(langmenu, MN_SET_LANG_EO,  MF_BYCOMMAND | (X_CODING == 0) ? MF_CHECKED : MF_UNCHECKED);
  CheckMenuItem(langmenu, MN_SET_LANG_EOX, MF_BYCOMMAND | (X_CODING == 1) ? MF_CHECKED : MF_UNCHECKED);
  CheckMenuItem(langmenu, MN_SET_LANG_GER, MF_BYCOMMAND | (X_CODING == 2) ? MF_CHECKED : MF_UNCHECKED);
  CheckMenuItem(langmenu, MN_SET_LANG_ENG, MF_BYCOMMAND | (X_CODING == 3) ? MF_CHECKED : MF_UNCHECKED);
  CheckMenuItem(optionsmenu, MN_SET_WIREFRAME, MF_BYCOMMAND | (Wireframe ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(optionsmenu, MN_SET_LISTS, MF_BYCOMMAND | (UseLists ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(optionsmenu, MN_SET_LIGHTY, MF_BYCOMMAND | (lighty_models ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(optionsmenu, MN_SET_SIMPLCOL, MF_BYCOMMAND | (simple_color ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(optionsmenu, MN_SET_CULL, MF_BYCOMMAND | ((!CullFace) ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(mousemenu, MN_MOUSE_L_INV, MF_BYCOMMAND | ((mouse_inversion & 1) ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(mousemenu, MN_MOUSE_M_INV, MF_BYCOMMAND | ((mouse_inversion & 2) ? MF_CHECKED : MF_UNCHECKED));
  CheckMenuItem(mousemenu, MN_MOUSE_R_INV, MF_BYCOMMAND | ((mouse_inversion & 4) ? MF_CHECKED : MF_UNCHECKED));
  EnableMenuItem(filemenu, MN_FILE_SAVE, MF_BYCOMMAND | (VALID_MODELS ? MF_ENABLED : MF_GRAYED));
  EnableMenuItem(viewmenu, MN_PART_DISP, MF_BYCOMMAND | ((VALID_MODELS > 1) ? MF_ENABLED : MF_GRAYED));
  if (hwndObjectDisplayDialog != NULL) SendMessage(hwndObjectDisplayDialog, WM_COMMAND, RT_SET_LANG, 0L);
}

BOOL ChooseBackgroundColor(HWND hwnd)
{ BOOL erg;
  CHOOSECOLOR farbe;
  /* int ct; */
  farbe.lStructSize = sizeof(CHOOSECOLOR);
  farbe.hwndOwner = hwnd;
  farbe.hInstance = NULL;
  farbe.rgbResult = RGB(((int) floor(255.0 * bg_r + 0.5)),
                        ((int) floor(255.0 * bg_g + 0.5)),
			((int) floor(255.0 * bg_b + 0.5)));
  farbe.lpCustColors = Farbfeld;
  farbe.Flags = CC_RGBINIT /* | CC_PREVENTFULLOPEN */;
  farbe.lCustData = 0;
  farbe.lpfnHook = NULL;
  farbe.lpTemplateName = NULL; // X_CODING ? L"malantauxa koloro" : L"malanta" US_ux L"a koloro";
  if ((erg = ChooseColor(&farbe)) != 0) {
    bg_r = (SBG_R = GetRValue(farbe.rgbResult)) / 255.0F;
    bg_g = (SBG_G = GetGValue(farbe.rgbResult)) / 255.0F;
    bg_b = (SBG_B = GetBValue(farbe.rgbResult)) / 255.0F;
  }
  return erg;
}

int SaveVtf(wchar_t *FileName)
{ FILE *ausgabe;
  union Unu *dta;
  wchar_t Meldung[MAX_PATH + 40];
  unsigned long typ, sz;
  struct HEAD head;
  if (TDate == NULL) return -1;
  if ((ausgabe = _wfopen(FileName, L"wb")) == NULL) {
    wsprintf(Meldung,
             StrByLang(X_CODING, L"Ne konas skribi dosieron '%s'!", L"\xffff",
	                         L"Kann nicht in Datei '%s' schreiben!",
				 L"Cannot write file '%s'!",
				 NULL),
             FileName);
    MessageBox(hwndApplication, Meldung,
               StrByLang(X_CODING, L"eraro - sekurigi dosieron", L"\xffff",
	                           L"Fehler beim Abspeichern",
				   L"Error while saving",
				   NULL),
	       MB_OK | MB_ICONINFORMATION);
    return -2;
  }
  strcpy(head.t, VTF_ASCII_HEAD);
  head.us = 1;
  head.ul = 987654321L;
  head.f = 7654321.0F;
  head.d = 9876543210123456.0;
  fwrite(&head, 1, sizeof(struct HEAD), ausgabe);
  for (dta = (union Unu *) &(TDate->Data[0]);
       ((dta->dauxrigo.size_n_flags >> 28) & 0x0fL) != 0x0fL;
       ) {
    sz = dta->dauxrigo.size_n_flags & 0x0fffffffL;
    typ = (dta->dauxrigo.size_n_flags >> 28) & 0x0fL;
    switch (typ) {
      case 12: /* Jump to next memory segment */
        dta = (union Unu *) dta->dauxrigo.There;
      break;
      default:
        fwrite(dta, 8, sz, ausgabe);
	dta = (union Unu *) &(dta->Data[sz]);
      break;
    }
  }
  fclose(ausgabe);
  return 0;
}

BOOL SelectAndSaveFile(HWND hwnd)
{ BOOL erg;
  OPENFILENAME ofn;
  wchar_t FileName[MAX_PATH], BaseName[MAX_PATH];
  FileName[0] = BaseName[0] = 0;
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.hInstance = NULL;
  ofn.lpstrFilter = StrByLang(X_CODING,
                              L"duuma rigardiga dosieroj (*.vtf)\0*.vtf\0" US_cx L"iuj dosieroj (*.*)\0*.*\0",
                              L"duuma rigardiga dosieroj (*.vtf)\0*.vtf\0cxiuj dosieroj (*.*)\0*.*\0",
			      L"binre Triangulationsdatei (*.vtf)\0*.vtf\0alle Dateien (*.*)\0*.*\0",
			      L"binary viewable triangulation file (*.vtf)\0*.vtf\0all files (*.*)\0*.*\0",
			      NULL);
  ofn.lpstrCustomFilter = NULL;
  ofn.nMaxCustFilter = 0;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile = FileName;
  ofn.nMaxFile = MAX_PATH;
  ofn.lpstrFileTitle = BaseName;
  ofn.nMaxFileTitle = MAX_PATH;
  ofn.lpstrInitialDir = NULL;
  ofn.lpstrTitle = StrByLang(X_CODING, L"sekurigi triangularan dosieron", L"\xffff",
                                       L"Triangulatinsdatei abspeichern",
				       L"save the triangulation file",
				       NULL);
  ofn.Flags = OFN_EXPLORER | OFN_HIDEREADONLY | /* OFN_PATHMUSTEXIST | */ OFN_OVERWRITEPROMPT;
  ofn.nFileOffset = 0;
  ofn.nFileExtension = 0;
  ofn.lpstrDefExt = L"slp";
  ofn.lCustData = 0;
  ofn.lpfnHook = NULL;
  ofn.lpTemplateName = NULL;
  if ((erg = GetSaveFileName(&ofn)) != 0) {
    /*
    wchar_t Meldung[700];
    wsprintf(Meldung, L"FileName = '%s'\nBaseName = '%s'\nExt. = '%s'",
      FileName, BaseName, &(FileName[ofn.nFileExtension]));
    MessageBox(NULL, Meldung, L"SelectAndSaveFile()", MB_OK | MB_ICONINFORMATION);
    */
    SaveVtf(FileName);
  }
  return erg;
}

BOOL SelectAndOpenFile(HWND hwnd)
{ BOOL erg;
  OPENFILENAME ofn;
  wchar_t FileName[MAX_PATH], BaseName[MAX_PATH];
  FileName[0] = BaseName[0] = 0;
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.hInstance = NULL;
  ofn.lpstrFilter = StrByLang(X_CODING,
                    /*   0 */ L"triangularaj dosieroj (*.slp;*.stl;*.vtf)\0*.slp;*.stl;*.vtf\0"
			      L"rigardiga dosieroj (*.slp)\0*.slp\0"
			      L"litografiaj dosieroj (*.stl)\0*.stl\0"
			      L"duuma rigardiga dosieroj (*.vtf)\0*.vtf\0"
			      US_cx L"iuj dosieroj (*.*)\0*.*\0",
                    /*   1 */ L"triangularaj dosieroj (*.slp;*.stl;*.vtf)\0*.slp;*.stl;*.vtf\0"
		              L"rigardiga dosieroj (*.slp)\0*.slp\0"
			      L"litografiaj dosieroj (*.stl)\0*.stl\0"
			      L"duuma rigardiga dosieroj (*.vtf)\0*.vtf\0"
			      L"cxiuj dosieroj (*.*)\0*.*\0",
	            /*   2 */ L"Triangulationsdateien (*.slp;*.stl;*.vtf)\0*.slp;*.stl;*.vtf\0"
		              L"Rendering-Datei (*.slp)\0*.slp\0"
			      L"Stereolithographidatei (*.stl)\0*.stl\0"
			      L"binre Triangulationsdatei (*.vtf)\0*.vtf\0"
			      L"alle Dateien (*.*)\0*.*\0",
		    /*   3 */ L"triangulation files (*.slp;*.stl;*.vtf)\0*.slp;*.stl;*.vtf\0"
		              L"render file (*.slp)\0*.slp\0"
			      L"stereolithographic file (*.stl)\0*.stl\0"
			      L"binary viewable triangulation file (*.vtf)\0*.vtf\0"
			      L"all files (*.*)\0*.*\0",
                    /* EOL */ NULL);
  ofn.lpstrCustomFilter = NULL;
  ofn.nMaxCustFilter = 0;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile = FileName;
  ofn.nMaxFile = MAX_PATH;
  ofn.lpstrFileTitle = BaseName;
  ofn.nMaxFileTitle = MAX_PATH;
  ofn.lpstrInitialDir = NULL;
  ofn.lpstrTitle = StrByLang(X_CODING, L"aperti triangularan dosieron", L"\xffff",
                                       L"Triangulationsdatei ffnen",
				       L"open a triangulation file",
                                       NULL);
  ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
  ofn.nFileOffset = 0;
  ofn.nFileExtension = 0;
  ofn.lpstrDefExt = L"slp";
  ofn.lCustData = 0;
  ofn.lpfnHook = NULL;
  ofn.lpTemplateName = NULL;
  if ((erg = GetOpenFileName(&ofn)) != 0) {
    /*
    wchar_t Meldung[700];
    wsprintf(Meldung, L"FileName = '%s'\nBaseName = '%s'\nExt. = '%s'",
      FileName, BaseName, &(FileName[ofn.nFileExtension]));
    MessageBox(NULL, Meldung, L"SelectAndOpenFile()", MB_OK | MB_ICONINFORMATION);
    */
    ReadFileIn(FileName, BaseName, ofn.nFileExtension, -1);
  }
  return erg;
}

CmdLineReadFile(wchar_t *FileName, int append)
{ int ct;
  int bn, ex;
  bn = ex = 0;
  for (ct = wcslen(FileName); ct >= 0; ct--) {
    if (!ex && (FileName[ct] == L'.')) ex = ct;
    if (!bn && (ct > 0)
        && ((FileName[ct - 1] == L'\\')
	 || (FileName[ct - 1] == L'/')
	 || (FileName[ct - 1] == L':'))) bn = ct;
  }
  ReadFileIn(FileName, &(FileName[bn]), ex, append);
  if (!append) {
    CmdLineFirstFileBasenameStart = bn;
    CmdLineFirstFileExtensionStart = ex;
  }
}

int ES_Dialog_DatasetValid(struct ES_DIALOG_DATA *DD, int tc)
{ if (!DD->VtfSlpStl[tc].enabled) return 1;
  if (!DD->VtfSlpStl[tc].Program[0]) return 0;
  if (!DD->VtfSlpStl[tc].ProgramBasename[0]) return 0;
  if (!DD->VtfSlpStl[tc].with_optional_param) return 1;
  if (!DD->VtfSlpStl[tc].OptionalParam[0]) return 0;
  return 1;
}

BOOL ES_Dialog_ExecFileSelection(HWND hwnd, struct ES_DIALOG_DATA *DD, int tc)
{ BOOL erg;
  OPENFILENAME ofn;
  wchar_t FileName[MAX_PATH], BaseName[MAX_PATH];
  FileName[0] = BaseName[0] = 0;
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.hInstance = NULL;
  ofn.lpstrFilter = L"*.exe\0*.exe\0"
                    L"*.bat\0*.bat\0"
		    L"*.cmd\0*.cmd\0"
		    L"*.exe + *.bat + *.cmd\0*.exe;*.bat;*.cmd\0"
		    L"*.*\0*.*\0";
  ofn.lpstrCustomFilter = NULL;
  ofn.nMaxCustFilter = 0;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile = FileName;
  ofn.nMaxFile = MAX_PATH;
  ofn.lpstrFileTitle = BaseName;
  ofn.nMaxFileTitle = MAX_PATH;
  ofn.lpstrInitialDir = NULL;
  ofn.lpstrTitle = StrByLang(tc,
                             StrByLang(X_CODING,
			               L"anstata" US_ux L"a programo por aperti 'VTF' dosieron",
			               L"anstatauxa programo por aperti 'VTF' dosieron",
                                       L"Alternatives Programm, welches 'andere' VTF-Dateien ffnet",
				       L"program to open 'other' VTF files",
                                       NULL),
                             StrByLang(X_CODING,
			               L"anstata" US_ux L"a programo por aperti 'SLP' dosieron",
			               L"anstatauxa programo por aperti 'SLP' dosieron",
                                       L"Alternatives Programm, welches 'andere' SLP-Dateien ffnet",
				       L"program to open 'other' SLP files",
                                       NULL),
                             StrByLang(X_CODING,
			               L"anstata" US_ux L"a programo por aperti 'STL' dosieron",
			               L"anstatauxa programo por aperti 'STL' dosieron",
                                       L"Alternatives Programm, welches 'andere' STL-Dateien ffnet",
				       L"program to open 'other' STL-files",
                                       NULL),
			     NULL);
  ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
  ofn.nFileOffset = 0;
  ofn.nFileExtension = 0;
  ofn.lpstrDefExt = L"exe";
  ofn.lCustData = 0;
  ofn.lpfnHook = NULL;
  ofn.lpTemplateName = NULL;
  if ((erg = GetOpenFileName(&ofn)) != 0) {
    wcscpy(DD->VtfSlpStl[tc].Program, FileName);
    wcscpy(DD->VtfSlpStl[tc].ProgramBasename, BaseName);
  }
  return erg;
}

BOOL CALLBACK ES_DialogProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{ int ct, grp;
  static struct ES_DIALOG_DATA *DD = NULL;
  switch (msg) {
    case WM_INITDIALOG:
      DD = (struct ES_DIALOG_DATA *) lParam;
      CheckDlgButton(hwnd, 40, DD->prompt_launching ? BST_CHECKED : BST_UNCHECKED);
      CheckDlgButton(hwnd, 11, DD->VtfSlpStl[0].enabled ? BST_CHECKED : BST_UNCHECKED);
      CheckDlgButton(hwnd, 21, DD->VtfSlpStl[1].enabled ? BST_CHECKED : BST_UNCHECKED);
      CheckDlgButton(hwnd, 31, DD->VtfSlpStl[2].enabled ? BST_CHECKED : BST_UNCHECKED);
      CheckDlgButton(hwnd, 14, DD->VtfSlpStl[0].with_optional_param ? BST_CHECKED : BST_UNCHECKED);
      CheckDlgButton(hwnd, 24, DD->VtfSlpStl[1].with_optional_param ? BST_CHECKED : BST_UNCHECKED);
      CheckDlgButton(hwnd, 34, DD->VtfSlpStl[2].with_optional_param ? BST_CHECKED : BST_UNCHECKED);
      if (IsDlgButtonChecked(hwnd, 11) == BST_CHECKED) {
        for (ct = 12; ct <= 14; ct++) EnableWindow(GetDlgItem(hwnd, ct), TRUE);
        EnableWindow(GetDlgItem(hwnd, 15), (IsDlgButtonChecked(hwnd, 14) == BST_CHECKED) ? TRUE : FALSE);
      } else {
        for (ct = 12; ct <= 15; ct++) EnableWindow(GetDlgItem(hwnd, ct), FALSE);
      }
      ShowWindow(GetDlgItem(hwnd, 16), SW_HIDE); /* Saved values should be ok, do not SW_SHOW error marker */
      if (IsDlgButtonChecked(hwnd, 21) == BST_CHECKED) {
        for (ct = 22; ct <= 23; ct++) EnableWindow(GetDlgItem(hwnd, ct), TRUE);
        EnableWindow(GetDlgItem(hwnd, 25), (IsDlgButtonChecked(hwnd, 24) == BST_CHECKED) ? TRUE : FALSE);
      } else {
        for (ct = 22; ct <= 25; ct++) EnableWindow(GetDlgItem(hwnd, ct), FALSE);
      }
      ShowWindow(GetDlgItem(hwnd, 26), SW_HIDE);
      if (IsDlgButtonChecked(hwnd, 31) == BST_CHECKED) {
        for (ct = 32; ct <= 33; ct++) EnableWindow(GetDlgItem(hwnd, ct), TRUE);
        EnableWindow(GetDlgItem(hwnd, 35), (IsDlgButtonChecked(hwnd, 34) == BST_CHECKED) ? TRUE : FALSE);
      } else {
        for (ct = 32; ct <= 35; ct++) EnableWindow(GetDlgItem(hwnd, ct), FALSE);
      }
      ShowWindow(GetDlgItem(hwnd, 36), SW_HIDE);
      return TRUE;
    case WM_COMMAND:
      grp = (LOWORD(wParam) / 10) - 1;
      // { wchar_t M[100]; wsprintf(M, L"grp = %d\nDD = %lx", grp, DD); MessageBox(NULL, M, L"Gruppenkode:", MB_OK | MB_ICONINFORMATION); }
      switch (LOWORD(wParam)) {
        case 11: case 21: case 31:
	  if (DD == NULL) return FALSE;
          DD->VtfSlpStl[grp].enabled = !DD->VtfSlpStl[grp].enabled;
          CheckDlgButton(hwnd, 11 + 10 * grp, DD->VtfSlpStl[grp].enabled ? BST_CHECKED : BST_UNCHECKED);
	  if (DD->VtfSlpStl[grp].enabled) {
            for (ct = 12; ct <= 14; ct++) EnableWindow(GetDlgItem(hwnd, ct + 10 * grp), TRUE);
            EnableWindow(GetDlgItem(hwnd, 15 + 10 * grp), DD->VtfSlpStl[grp].with_optional_param ? TRUE : FALSE);
            ShowWindow(GetDlgItem(hwnd, 16 + 10 * grp), ES_Dialog_DatasetValid(DD, grp) ? SW_HIDE : SW_SHOW);
	  } else {
            for (ct = 12; ct <= 15; ct++) EnableWindow(GetDlgItem(hwnd, ct + 10 * grp), FALSE);
            ShowWindow(GetDlgItem(hwnd, 16 + 10 * grp), SW_HIDE);
	  }
          EnableWindow(GetDlgItem(hwnd, 99),
                       (ES_Dialog_DatasetValid(DD, 0) && ES_Dialog_DatasetValid(DD, 1) && ES_Dialog_DatasetValid(DD, 2))
		       ? TRUE : FALSE);
	  return TRUE;
	case 12: case 22: case 32:
	  if (DD == NULL) return FALSE;
          if (ES_Dialog_ExecFileSelection(hwnd, DD, grp)) {
	    SetDlgItemText(hwnd, 13 + 10 * grp, DD->VtfSlpStl[grp].Program);
            ShowWindow(GetDlgItem(hwnd, 16 + 10 * grp), ES_Dialog_DatasetValid(DD, grp) ? SW_HIDE : SW_SHOW);
            EnableWindow(GetDlgItem(hwnd, 99),
                         (ES_Dialog_DatasetValid(DD, 0) && ES_Dialog_DatasetValid(DD, 1) && ES_Dialog_DatasetValid(DD, 2))
	  	         ? TRUE : FALSE);
	  }
	  return TRUE;
	case 14: case 24: case 34:
	  if (DD == NULL) return FALSE;
          DD->VtfSlpStl[grp].with_optional_param = !(DD->VtfSlpStl[grp].with_optional_param);
          CheckDlgButton(hwnd, 14 + 10 * grp, DD->VtfSlpStl[grp].with_optional_param ? BST_CHECKED : BST_UNCHECKED);
          EnableWindow(GetDlgItem(hwnd, 15 + 10 * grp), DD->VtfSlpStl[grp].with_optional_param ? TRUE : FALSE);
          ShowWindow(GetDlgItem(hwnd, 16 + 10 * grp), ES_Dialog_DatasetValid(DD, grp) ? SW_HIDE : SW_SHOW);
          EnableWindow(GetDlgItem(hwnd, 99),
                       (ES_Dialog_DatasetValid(DD, 0) && ES_Dialog_DatasetValid(DD, 1) && ES_Dialog_DatasetValid(DD, 2))
		       ? TRUE : FALSE);
	  return TRUE;
	case 15: case 25: case 35:
	  if (DD == NULL) return FALSE;
	  switch (HIWORD(wParam)) {
	    case EN_CHANGE: case EN_KILLFOCUS:
	      GetWindowText((HWND) lParam, DD->VtfSlpStl[grp].OptionalParam, MAX_PATH);
	      DD->VtfSlpStl[grp].OptionalParam[MAX_PATH - 1] = 0;
      // { wchar_t M[100]; wsprintf(M, L"grp = %d\nDD = %lx", grp, DD); MessageBox(NULL, M, L"Gruppenkode Direkt:", MB_OK | MB_ICONINFORMATION); wsprintf(M, L"OptionalParam = \"%s\"", DD->VtfSlpStl[grp].OptionalParam); MessageBox(NULL, M, L"OptionalParam:", MB_OK | MB_ICONINFORMATION); }
              ShowWindow(GetDlgItem(hwnd, 16 + 10 * grp), ES_Dialog_DatasetValid(DD, grp) ? SW_HIDE : SW_SHOW);
              EnableWindow(GetDlgItem(hwnd, 99),
                           (ES_Dialog_DatasetValid(DD, 0) && ES_Dialog_DatasetValid(DD, 1) && ES_Dialog_DatasetValid(DD, 2))
		           ? TRUE : FALSE);
	    return TRUE;
	  }
	  break;
	case 40:
	  if (DD == NULL) return FALSE;
          DD->prompt_launching = !DD->prompt_launching;
          CheckDlgButton(hwnd, 40, DD->prompt_launching ? BST_CHECKED : BST_UNCHECKED);
	  return TRUE;
        case 98:
	  DD = NULL;
	  EndDialog(hwnd, 0);
	  return TRUE;
        case 99:
	  DD = NULL;
	  EndDialog(hwnd, 1);
	  return TRUE;
      }
    break;
  }
  return FALSE;
}

#ifdef DLG_DEBUG

void DlgDataList(DynDlgTemplate *ddt)
{ int ct, p, lg; unsigned short *Daten;
#define INFO_LG 5000
  wchar_t Info[INFO_LG];
  if (ddt == NULL) return;
  lg = ddt->bytes_filled / 2;
  Daten = (void *) ddt->dlg;
  wsprintf(Info, L"%d Words:\n", lg);
  p = wcslen(Info);
  for (ct = 0; ct < lg; ct++) {
    if (p + 15 < INFO_LG) {
      if (((Daten[ct] >= 0x20) && (Daten[ct] < 0x007f))
       || ((Daten[ct] >= 0xa1) && (Daten[ct] <= 0x017f)))
         wsprintf(&(Info[p]), L"0x%.4x '%c' ", Daten[ct], Daten[ct]);
	else
         wsprintf(&(Info[p]), L"0x%.4x     ", Daten[ct]);
      if ((ct % 10) == 9) wcscat(Info, L"\n");
      p = wcslen(Info);
    }
  }
  MessageBox(NULL, Info, L"Dialog Template Data", MB_OK | MB_ICONINFORMATION);
}
#endif

#define DlgW    175
#define BtnG      5
#define BtnH     18
#define WarnW    55
#define WarnH     8
#define WarnG     2
#define SelBtnW  30
#define SelBtnH  12
#define ParaCbW  80
#define ParaCbH  SelBtnH
#define TxtW     (DlgW - 5 * BtnG - SelBtnW)
#define ParaTxtW (DlgW - 5 * BtnG - ParaCbW)
#define ErgBtnW  ((DlgW - 3 * BtnG) / 2)
#define BoxH     (WarnH + SelBtnH + ParaCbH + 2 * BtnG + 2 * WarnG)
#define DlgH     (3 * BoxH + BtnH + SelBtnH + 7 * BtnG)
void CallExitSettings(HWND hwnd)
{ struct ES_DIALOG_DATA ES_Dialog_Data;
  DynDlgTemplate ES_Dialog = DynDlgTemplateNULL;
  int erg, cxChar, cyChar;
  RECT FatherWindowExt;
  /* get old values */
  memcpy( &ES_Dialog_Data, &ES_Settings, sizeof(struct ES_DIALOG_DATA));
  /*
  ES_Dialog_Data.prompt_launching = 1;
  ES_Dialog_Data.VtfSlpStl[0].enabled = 1;
  ES_Dialog_Data.VtfSlpStl[0].with_optional_param = 0;
  wcscpy(ES_Dialog_Data.VtfSlpStl[0].Program, L"E:\\a\\b\\c\\d\\e\\f\\g\\h\\i\\j\\k\\l\\m\\n\\o\\p\\q\\r\\s\\t\\u\\v\\w\\x\\y\\z.exe");
  wcscpy(ES_Dialog_Data.VtfSlpStl[0].ProgramBasename, L"z.exe");
  ES_Dialog_Data.VtfSlpStl[1].enabled = 1;
  wcscpy(ES_Dialog_Data.VtfSlpStl[0].OptionalParam, L"-abcdefghijklmnopqrstuvwxyz0123456789");
  wcscpy(ES_Dialog_Data.VtfSlpStl[1].Program, L"E:\\a\\b\\c\\d\\e\\f\\g\\h\\i\\j\\k\\l\\m\\n\\o\\p\\q\\r\\s\\t\\u\\v\\w\\x\\y\\z.exe");
  wcscpy(ES_Dialog_Data.VtfSlpStl[1].ProgramBasename, L"z.exe");
  ES_Dialog_Data.VtfSlpStl[1].with_optional_param = 1;
  wcscpy(ES_Dialog_Data.VtfSlpStl[1].OptionalParam, L"-abcdefghijklmnopqrstuvwxyz0123456789");
  ES_Dialog_Data.VtfSlpStl[2].enabled = 0;
  wcscpy(ES_Dialog_Data.VtfSlpStl[2].Program, L"E:\\a\\b\\c\\d\\e\\f\\g\\h\\i\\j\\k\\l\\m\\n\\o\\p\\q\\r\\s\\t\\u\\v\\w\\x\\y\\z.exe");
  wcscpy(ES_Dialog_Data.VtfSlpStl[2].ProgramBasename, L"z.exe");
  ES_Dialog_Data.VtfSlpStl[2].with_optional_param = 1;
  wcscpy(ES_Dialog_Data.VtfSlpStl[2].OptionalParam, L"-abcdefghijklmnopqrstuvwxyz0123456789");
  */
  /* build dialog mask */
  GetClientRect(hwnd, &FatherWindowExt);
  cxChar = LOWORD(GetDialogBaseUnits());
  cyChar = HIWORD(GetDialogBaseUnits());
  if (DynDlgSetHead(&ES_Dialog, WS_VISIBLE | DS_MODALFRAME | WS_POPUP | WS_CAPTION, 0,
                    (FatherWindowExt.right  * 4 > DlgW * cxChar) ? (FatherWindowExt.right  * 4 / cxChar - DlgW) / 2 : 0,
		    (FatherWindowExt.bottom * 8 > DlgH * cyChar) ? (FatherWindowExt.bottom * 8 / cyChar - DlgH) / 2 : 0,
		    DlgW, DlgH,
		    NULL, -1,
		    NULL, -1,
                    StrByLang(X_CODING,
			      L"rtd - anstata" US_ux L"aj programoj por aperti deviaj dosieroj",
			      L"rtd - anstatauxaj programoj por aperti deviaj dosieroj",
			      L"rtd - alternative Programme, um nicht-RTD-Dateien zu ffnen",
			      L"rtd - other applications to open non-RTD files",
			      NULL),
                    NULL, 0, 0, 0)) return;
  // MessageBox(NULL, L"Step 1", L"Dialog Build", MB_OK | MB_ICONINFORMATION);
  // DlgDataList(&ES_Dialog);
  if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON | WS_GROUP | WS_TABSTOP, 0,
                   BtnG,                      DlgH - BtnG - BtnH,
		   ErgBtnW,                   BtnH,                99,
                   NULL, DlgButton,
	           StrByLang(X_CODING, L"en ordo", L"\xffff",
			               L"OK", L"OK", NULL), 0,
                   0, NULL, 0)) return;
  // MessageBox(NULL, L"Step 2", L"Dialog Build", MB_OK | MB_ICONINFORMATION);
  // DlgDataList(&ES_Dialog);
  if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE, 0,
                   DlgW - BtnG - ErgBtnW,     DlgH - BtnG - BtnH,
		   ErgBtnW,                   BtnH,                98,
                   L"button", 0,
	           StrByLang(X_CODING, L"nuligi", L"\xffff",
			               L"Abbruch", L"Abort", NULL), 0,
                   0, NULL, 0)) return;
  for (erg = 0; erg < 3; erg++) {
    if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE | SS_BLACKFRAME, 0,
                     BtnG, BtnG + erg * (BtnG + BoxH),
		     DlgW - 2 * BtnG, BoxH, 10 + 10 * erg,
		     L"static", 0,
		     L"", 0,
		     0, NULL, 0)) return;
    if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE | BS_CHECKBOX | WS_GROUP | WS_TABSTOP, 0,
                     BtnG + WarnG, BtnG + WarnG + erg * (BtnG + BoxH),
		     DlgW - 4 * BtnG - WarnG - WarnW, WarnH, 11 + 10 * erg,
		     L"button", 0,
		     StrByLang(erg,
	                StrByLang(X_CODING, L"por \"&VTF\"aj dosieroj", L"\xffff",
		  	                    L"fr &VTF-Dateien",
				            L"for &VTF files", NULL),
	                StrByLang(X_CODING, L"por \"&SLP\"aj dosieroj", L"\xffff",
		  	                    L"fr &SLP-Dateien",
				            L"for &SLP files", NULL),
	                StrByLang(X_CODING, L"por \"S&TL\"aj dosieroj", L"\xffff",
		  	                    L"fr S&TL-Dateien",
				            L"for S&TL files", NULL),
		        NULL), 0,
		     0, NULL, 0)) return;
    if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE | WS_TABSTOP, 0,
                     2 * BtnG, BtnG + 2 * WarnG + WarnH + erg * (BtnG + BoxH),
		     SelBtnW, SelBtnH, 12 + 10 * erg,
                     L"button", 0,
	             StrByLang(X_CODING, L"elekti", L"\xffff",
			                 L"Auswahl", L"select", NULL), 0,
                     0, NULL, 0)) return;
    if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE | ES_LEFT | ES_AUTOHSCROLL | WS_BORDER | ES_READONLY, 0,
                     3 * BtnG + SelBtnW, BtnG + 2 * WarnG + WarnH + erg * (BtnG + BoxH),
		     TxtW, SelBtnH, 13 + 10 * erg,
                     L"edit", 0,
		     ES_Dialog_Data.VtfSlpStl[erg].Program, 0,
                     0, NULL, 0)) return;
    if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE | BS_CHECKBOX | WS_TABSTOP, 0,
                     2 * BtnG, BtnG + 3 * WarnG + WarnH + SelBtnH + erg * (BtnG + BoxH),
		     ParaCbW, ParaCbH, 14 + 10 * erg,
		     L"button", 0,
	             StrByLang(X_CODING, L"libervola parametro", L"\xffff",
			                 L"optionaler Parameter",
				         L"optional parameter", NULL), 0,
		     0, NULL, 0)) return;
    if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE | ES_LEFT | ES_AUTOHSCROLL | WS_BORDER, 0,
                     3 * BtnG + ParaCbW, BtnG + 3 * WarnG + WarnH + SelBtnH + erg * (BtnG + BoxH),
		     ParaTxtW, ParaCbH, 15 + 10 * erg,
                     L"edit", 0,
		     ES_Dialog_Data.VtfSlpStl[erg].OptionalParam, 0,
                     0, NULL, 0)) return;
    if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE | ES_RIGHT, 0,
                     DlgW - 2 * BtnG - WarnW, BtnG + WarnG + erg * (BtnG + BoxH),
		     WarnW, WarnH, 16 + 10 * erg,
		     L"static", 0,
	             StrByLang(X_CODING, L"*** nevalida ***", L"\xffff",
			                 L"*** ungltig ***",
				         L"*** invalid ***", NULL), 0,
		     0, NULL, 0)) return;
  }
  if (DynDlgAddItem(&ES_Dialog, WS_CHILD | WS_VISIBLE | BS_CHECKBOX | WS_GROUP | WS_TABSTOP, 0,
                   BtnG, BtnG + 2 * WarnG + 3 * (BtnG + BoxH),
	           DlgW - 2 * BtnG, SelBtnH, 40,
		   L"button", 0,
	           StrByLang(X_CODING, L"demandi anta" US_ux L" la starto",
	                               L"demandi antaux la starto",
		  	               L"Rckfrage vor dem Start",
				       L"prompt before launching", NULL), 0,
		   0, NULL, 0)) return;
  // MessageBox(NULL, L"Step 3", L"Dialog Build", MB_OK | MB_ICONINFORMATION);
  // DlgDataList(&ES_Dialog);
  erg = DialogBoxIndirectParam(hThisInstance, ES_Dialog.dlg, hwnd, ES_DialogProc, (LPARAM) &ES_Dialog_Data);
  // { wchar_t RESULT[150];
  //   wsprintf(RESULT, L"DialogBoxIndirect() = %d", erg);
  //   MessageBox(NULL, RESULT, L"Dialog Result", MB_OK | MB_ICONINFORMATION);
  // }
  if (erg) { /* Save the result */
    memcpy(&ES_Settings, &ES_Dialog_Data, sizeof(struct ES_DIALOG_DATA));
  }
  DynDlgTemplateFree(&ES_Dialog);
}

void InfoBox(void)
{ int cxChar, cyChar, Breite, Hoehe;
  HWND fenster;
  cxChar = LOWORD(GetDialogBaseUnits());
  cyChar = HIWORD(GetDialogBaseUnits());
  Breite = (int) floor(TFloatByLang(X_CODING, 79000L, 79000L, 55000L, 53000L, 0L) * cxChar)
         + 64 + 3 * cyChar + 2 * GetSystemMetrics(SM_CXBORDER);
  Hoehe = (int) floor(TFloatByLang(X_CODING, 20500L, 20500L, 15000L, 15000L, 0L) * cyChar)
        + 2 * GetSystemMetrics(SM_CYBORDER) + GetSystemMetrics(SM_CYCAPTION);
  if (Breite > GetSystemMetrics(SM_CXSCREEN)) Breite = GetSystemMetrics(SM_CXSCREEN);
   else if (Breite < GetSystemMetrics(SM_CXMIN)) Breite = GetSystemMetrics(SM_CXMIN);
  if (Hoehe > GetSystemMetrics(SM_CYSCREEN)) Hoehe = GetSystemMetrics(SM_CYSCREEN);
   else if (Hoehe < GetSystemMetrics(SM_CYMIN)) Hoehe = GetSystemMetrics(SM_CYMIN);
  fenster = CreateWindow(AboutClassName,
                         StrByLang(X_CODING,
			           L"kapableta rigardilo por triangularaj dosieroj", L"\xffff",
				   L"grundfunktionaler Betrachter fr Triangulationsdateien",
				   L"low end triangulation file viewer",
				   NULL),
                         WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_EX_TOPMOST,
	                 CW_USEDEFAULT, CW_USEDEFAULT, Breite, Hoehe,
                         hwndApplication, NULL, hThisInstance, NULL);
}

void MenuHit(HWND hwnd, WPARAM key)
{
  switch (key) {
    case MN_FILE_OPEN:
	  if (SelectAndOpenFile(hwnd)) {
		Projection = PROJ_TRI;
		DrawScene(hwnd, 0, 0, 0);
	  }
    break;
    case MN_FILE_SAVE:
	  SelectAndSaveFile(hwnd);
    break;
    case MN_VIEW_ISO:
      Projection = PROJ_ISO;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_VIEW_DI:
      Projection = PROJ_DI;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_VIEW_TRI:
      Projection = PROJ_TRI;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_VIEW_RIGHT:
      Projection = PROJ_RIGHT;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_VIEW_FRONT:
      Projection = PROJ_FRONT;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_VIEW_LEFT:
      Projection = PROJ_LEFT;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_VIEW_BACK:
      Projection = PROJ_BACK;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_VIEW_TOP:
      Projection = PROJ_TOP;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_VIEW_BOTTOM:
      Projection = PROJ_BOTTOM;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_SET_CS:
      Disp_CS = !Disp_CS;
      CheckMenuItem(optionsmenu, MN_SET_CS, MF_BYCOMMAND | (Disp_CS ? MF_CHECKED : MF_UNCHECKED));
      options_altered = 1;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_SET_EXTEND:
      Disp_Extend = !Disp_Extend;
      CheckMenuItem(optionsmenu, MN_SET_EXTEND, MF_BYCOMMAND | (Disp_Extend ? MF_CHECKED : MF_UNCHECKED));
      options_altered = 1;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_SET_WIREFRAME:
      Wireframe = !Wireframe;
      RebuildLists = 1;
      CheckMenuItem(optionsmenu, MN_SET_WIREFRAME, MF_BYCOMMAND | (Wireframe ? MF_CHECKED : MF_UNCHECKED));
      options_altered = 1;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_SET_CULL:
      CullFace = !CullFace;
      CheckMenuItem(optionsmenu, MN_SET_CULL, MF_BYCOMMAND | ((!CullFace) ? MF_CHECKED : MF_UNCHECKED));
      options_altered = 1;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_SET_SIMPLCOL:
      simple_color = !simple_color;
      if (!simple_color) UseLists = 0;
      CheckMenuItem(optionsmenu, MN_SET_SIMPLCOL, MF_BYCOMMAND | (simple_color ? MF_CHECKED : MF_UNCHECKED));
      CheckMenuItem(optionsmenu, MN_SET_LISTS, MF_BYCOMMAND | (UseLists ? MF_CHECKED : MF_UNCHECKED));
      options_altered = 1;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_SET_LIGHTY:
      lighty_models = !lighty_models;
      RebuildLists = 1;
      CheckMenuItem(optionsmenu, MN_SET_LIGHTY, MF_BYCOMMAND | (lighty_models ? MF_CHECKED : MF_UNCHECKED));
      options_altered = 1;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_SET_LISTS:
      // MessageBox(NULL, L"ne ebla", L"openGL listoj", MB_OK | MB_ICONSTOP);
      UseLists = !UseLists;
      if (UseLists) simple_color = 0;
      RebuildLists = 1;
      CheckMenuItem(optionsmenu, MN_SET_LISTS, MF_BYCOMMAND | (UseLists ? MF_CHECKED : MF_UNCHECKED));
      CheckMenuItem(optionsmenu, MN_SET_SIMPLCOL, MF_BYCOMMAND | (simple_color ? MF_CHECKED : MF_UNCHECKED));
      options_altered = 1;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_SET_BACKGRND:
      if (ChooseBackgroundColor(hwnd)) {
        options_altered = 1;
        DrawScene(hwnd, 0, 0, 0);
      }
    break;
    case MN_SET_LANG_EO:
      X_CODING = 0;
      BuildMenue(hwnd); /* CheckMenuItem() is done by BuildMenue() */
      options_altered = 1;
    break;
    case MN_SET_LANG_EOX:
      X_CODING = 1;
      BuildMenue(hwnd); /* CheckMenuItem() is done by BuildMenue() */
      options_altered = 1;
    break;
    case MN_SET_LANG_GER:
      X_CODING = 2;
      BuildMenue(hwnd); /* CheckMenuItem() is done by BuildMenue() */
      options_altered = 1;
    break;
    case MN_SET_LANG_ENG:
      X_CODING = 3;
      BuildMenue(hwnd); /* CheckMenuItem() is done by BuildMenue() */
      options_altered = 1;
    break;
    case MN_MOUSE_L_INV:
      mouse_inversion = (mouse_inversion & 1) ? mouse_inversion & 6 : mouse_inversion | 1;
      CheckMenuItem(mousemenu, MN_MOUSE_L_INV, MF_BYCOMMAND | ((mouse_inversion & 1) ? MF_CHECKED : MF_UNCHECKED));
    break;
    case MN_MOUSE_M_INV:
      mouse_inversion = (mouse_inversion & 2) ? mouse_inversion & 5 : mouse_inversion | 2;
      CheckMenuItem(mousemenu, MN_MOUSE_M_INV, MF_BYCOMMAND | ((mouse_inversion & 2) ? MF_CHECKED : MF_UNCHECKED));
    break;
    case MN_MOUSE_R_INV:
      mouse_inversion = (mouse_inversion & 4) ? mouse_inversion & 3 : mouse_inversion | 4;
      CheckMenuItem(mousemenu, MN_MOUSE_R_INV, MF_BYCOMMAND | ((mouse_inversion & 4) ? MF_CHECKED : MF_UNCHECKED));
    break;
    case MN_SET_CALLEXIT:
      CallExitSettings(hwnd);
      options_altered = 1;
    break;
    case MN_ZOOM_PLUS:
      view_scale *= DefaultZoomFaktor;
      if (view_scale > MaxZoomFaktor) view_scale = MaxZoomFaktor;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_ZOOM_MINUS:
      view_scale /= DefaultZoomFaktor;
      if (view_scale < 1.0) view_scale = 1.0;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_ZOOM_FIT:
      view_scale = 1.0;
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_PART_DISP:
      if (VALID_MODELS > 1) {
        /* wchar_t T[50];
	   wsprintf(T, L"%d objektoj", VALID_MODELS); */
        if (hwndObjectDisplayDialog == NULL) {
          /* MessageBox(NULL, L"Start ObjectDisplayDialog", T, MB_ICONINFORMATION | MB_OK); */
          hwndObjectDisplayDialog = CreateWindow(MdlDispClassName,
                                                 StrByLang(X_CODING,
			                         L"objektoj de kapableta rigardilo por triangularaj dosieroj", L"\xffff",
				                 L"Objekte des grundfunktionalen Betrachters fr Triangulationsdateien",
				                 L"object in the low end triangulation file viewer",
				                 NULL),
                                                 WS_OVERLAPPEDWINDOW | WS_VISIBLE,
	                                         CW_USEDEFAULT, CW_USEDEFAULT,
                                                 30 * LOWORD(GetDialogBaseUnits()),
						 (2 * GetSystemMetrics(SM_CYFULLSCREEN)) / 3,
                                                 hwndApplication, NULL, hThisInstance, NULL);
        }
	ShowWindow(hwndObjectDisplayDialog, SW_SHOWNORMAL);
      }
    break;
    case MN_REPAINT:
      DrawScene(hwnd, 0, 0, 0);
    break;
    case MN_INFO:
      InfoBox();
    break;
    case MN_FILE_QUIT:
      SaveParametersInRegistry();
      PostQuitMessage(0);
    break;
  }
}

void KbdHit(HWND hwnd, WPARAM key)
{
  switch (key) {
    case 033: case 'Q': case 'q':
#ifdef DUMP_MAT
      if (trail != NULL) fclose(trail);
#endif
      SaveParametersInRegistry();
      PostQuitMessage(0);
    break;
    case 'i': case 'I':
      MenuHit(hwnd, MN_VIEW_ISO);
    break;
    case 'd': case 'D':
      MenuHit(hwnd, MN_VIEW_DI);
    break;
    case 't': case 'T':
      MenuHit(hwnd, MN_VIEW_TRI);
    break;
    case 'h': case 'H':
      MenuHit(hwnd, MN_VIEW_RIGHT);
    break;
    case 'j': case 'J':
      MenuHit(hwnd, MN_VIEW_FRONT);
    break;
    case 'k': case 'K':
      MenuHit(hwnd, MN_VIEW_LEFT);
    break;
    case 'l': case 'L':
      MenuHit(hwnd, MN_VIEW_BACK);
    break;
    case 'm': case 'M':
      MenuHit(hwnd, MN_VIEW_TOP);
    break;
    case 'u': case 'U':
      MenuHit(hwnd, MN_VIEW_BOTTOM);
    break;
    case 'c': case 'C':
      MenuHit(hwnd, MN_SET_CS);
    break;
    case 'x': case 'X':
      MenuHit(hwnd, MN_SET_EXTEND);
    break;
    case '+':
      MenuHit(hwnd, MN_ZOOM_PLUS);
    break;
    case '-':
      MenuHit(hwnd, MN_ZOOM_MINUS);
    break;
    case '#':
      MenuHit(hwnd, MN_ZOOM_FIT);
    break;
  }
}

void MdlDispCheckboxPositionAdjust(int cxChar, int cyChar, int CheckBoxesStartY, int CBHight, int CheckBoxWidth,
                                   int FirstCheckBox, int CheckBoxesVisibleCount)
{ int ct;
  struct MODEL_SELECT *vm;
  ct = 0;
  for (vm = model_select_chain; vm != NULL; vm = vm->next)
    if ((vm->Name != NULL) && (vm->Checkbox != NULL)) {
      ++ct;
      if ((ct > FirstCheckBox) && (ct <= FirstCheckBox + CheckBoxesVisibleCount)) {
        MoveWindow(vm->Checkbox, cxChar, CheckBoxesStartY + (vm->Number - 1 - FirstCheckBox) * CBHight,
                   CheckBoxWidth, CBHight, TRUE);
      } else {
        MoveWindow(vm->Checkbox, 0, 0, 0, 0, FALSE);
      }
  }
}

LRESULT CALLBACK MdlDispWndProc(HWND hwnd, UINT uMsg,
                                WPARAM wParam, LPARAM lParam)
{
    static HWND wndAll, wndRP, wndSC;
    static int topmost = 0, gezeigt = 1;
    static int cxChar, cyChar, CBHight, HightBut, CheckBoxWidth, CheckBoxesStartY, CheckBoxesEndY,
	       CheckBoxesVisibleCount = 1, FirstCheckBox = 0;
    int Notification;
    struct MODEL_SELECT *vm;
    wchar_t ZL[100];
    SCROLLINFO si;

    switch(uMsg) {
      case WM_CREATE:
        cxChar = LOWORD(GetDialogBaseUnits());
        cyChar = HIWORD(GetDialogBaseUnits());
	CBHight = cyChar + 4;
        wndRP = CreateWindow(L"button",
	                     StrByLang(X_CODING, L"prezenti", L"\xffff",
			               L"zeigen", L"repaint", NULL),
	                     WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
                             0, 0, 0, 0,
                             hwnd, (HMENU) 0, hThisInstance, NULL);
        wndAll = CreateWindow(L"button",
	                     StrByLang(X_CODING, L"prezenti " US_cx L"iuj objektojn",
			                         L"prozenti cxiuj objektojn",
			                         L"alle Objekte zeigen",
						 L"show all objects", NULL),
	                     WS_CHILD | WS_VISIBLE | BS_CHECKBOX,
                             0, 0, 0, 0,
                             hwnd, (HMENU) 1, hThisInstance, NULL);
        SendMessage(wndAll, BM_SETCHECK, ObjectsShowAll ? BST_CHECKED : BST_UNCHECKED, 0L);
        wndSC = CreateWindow(L"scrollbar", NULL,
	                     WS_CHILD | WS_VISIBLE | SBS_VERT,
			     0, 0, 0, 0,
			     hwnd, (HMENU) 2, hThisInstance, NULL);
#ifdef DUMP_MODEL_SELECT_RECORDS
        DumpModelSelectRecord();
#endif
        for (vm = model_select_chain; vm != NULL; vm = vm->next)
	  if (vm->Name != NULL) {
	    _snwprintf(ZL, 100, L"%d.: %s", vm->Number, vm->Name); ZL[99] = 0;
	    vm->Checkbox = CreateWindow(L"button", ZL,
	                                WS_CHILD | WS_VISIBLE | BS_CHECKBOX,
					0, 0, 0, 0,
					hwnd, (HMENU) (MN_OBJECT_ZERO + vm->Number), hThisInstance, NULL);
	    if (vm->Checkbox == NULL) {
	      vm->Display = -1;
	    } else {
	      vm->Display = 1;
              SendMessage(vm->Checkbox, BM_SETCHECK, vm->Display ? BST_CHECKED : BST_UNCHECKED, 0L);
	      EnableWindow(vm->Checkbox, ObjectsShowAll ? FALSE : TRUE);
	    }
	}
      break;
      case WM_VSCROLL:
	// { wchar_t Zl[100]; int min, max;
	  // wsprintf(Zl, L"wParam = %.4lx\nlParam = %.8lx", (unsigned long) wParam, lParam);
	  // GetScrollRange(wndSC, SB_CTL, &min, &max);
	  // wsprintf(Zl, L"VERT range: %d .. %d", min, max);
	  // MessageBox(NULL, Zl, L"Scroll:", MB_ICONINFORMATION | MB_OK);
	// }
	switch (LOWORD(wParam)) {
	  case SB_LINEUP:
	    // MessageBox(NULL, L"LineUp", L"Scroll:", MB_ICONINFORMATION | MB_OK);
	    if (--FirstCheckBox < 0) FirstCheckBox = 0;
	  break;
	  case SB_LINEDOWN:
	    // MessageBox(NULL, L"LineDown", L"Scroll:", MB_ICONINFORMATION | MB_OK);
	    FirstCheckBox++;
            /***???  VALID_MODELS oder stored_model_references verwenden? ***/
	    if (stored_model_references < FirstCheckBox + CheckBoxesVisibleCount)
	      FirstCheckBox = stored_model_references - CheckBoxesVisibleCount;
	    if (FirstCheckBox < 0) FirstCheckBox = 0;
	  break;
	  case SB_PAGEUP:
	    // MessageBox(NULL, L"PageUp", L"Scroll:", MB_ICONINFORMATION | MB_OK);
	    FirstCheckBox -= CheckBoxesVisibleCount;
	    if (FirstCheckBox < 0) FirstCheckBox = 0;
	  break;
	  case SB_PAGEDOWN:
	    // MessageBox(NULL, L"PageDown", L"Scroll:", MB_ICONINFORMATION | MB_OK);
	    FirstCheckBox += CheckBoxesVisibleCount;
	    if (stored_model_references < FirstCheckBox + CheckBoxesVisibleCount)
	      FirstCheckBox = stored_model_references - CheckBoxesVisibleCount;
	    if (FirstCheckBox < 0) FirstCheckBox = 0;
	  break;
	  case SB_THUMBTRACK:
	  case SB_THUMBPOSITION:
	    si.cbSize = sizeof(si);
	    si.fMask = SIF_ALL;
	    GetScrollInfo(wndSC, SB_CTL, &si);
	    FirstCheckBox = si.nTrackPos;
	    if (stored_model_references < FirstCheckBox + CheckBoxesVisibleCount)
	      FirstCheckBox = stored_model_references - CheckBoxesVisibleCount;
	    if (FirstCheckBox < 0) FirstCheckBox = 0;
	    if (LOWORD(wParam) == SB_THUMBTRACK) {
              MdlDispCheckboxPositionAdjust(cxChar, cyChar, CheckBoxesStartY, CBHight, CheckBoxWidth,
                                            FirstCheckBox, CheckBoxesVisibleCount);
	      return 0;
            }
	  break;
        }
	si.cbSize = sizeof(si);
	si.fMask = SIF_POS;
	si.nPos = FirstCheckBox;
	SetScrollInfo(wndSC, SB_CTL, &si, TRUE);
        MdlDispCheckboxPositionAdjust(cxChar, cyChar, CheckBoxesStartY, CBHight, CheckBoxWidth,
                                      FirstCheckBox, CheckBoxesVisibleCount);
      break;
      case WM_COMMAND:
	Notification = HIWORD(wParam);
        switch (LOWORD(wParam)) {
	  case 0: if (IN_FILE_DIALOG) break;
	          SendMessage(hwndApplication, WM_COMMAND, MN_REPAINT, 0L);
	          gezeigt = 1;
	          SetWindowText(wndRP, StrByLang(X_CODING, L"prezenti", L"\xffff",
			                                   L"zeigen", L"repaint", NULL));
	// { wchar_t Zl[100]; int min, max;
	  // wsprintf(Zl, L"wParam = %.4lx\nlParam = %.8lx", (unsigned long) wParam, lParam);
	  /* GetScrollRange(wndSC, SB_VERT, &min, &max);
	  wsprintf(Zl, L"VERT range: %d .. %d\n", min, max); */
	  // GetScrollRange(wndSC, SB_CTL, &min, &max);
	  // wsprintf(/* &(*/ Zl /*[wcslen(Zl)])*/, L"CTL  range: %d .. %d", min, max);
	  // MessageBox(NULL, Zl, L"Scroll:", MB_ICONINFORMATION | MB_OK);
	// }
	  break;
	  case 1:
	    ObjectsShowAll = !ObjectsShowAll;
            SendMessage(wndAll, BM_SETCHECK, ObjectsShowAll ? BST_CHECKED : BST_UNCHECKED, 0L);
            for (vm = model_select_chain; vm != NULL; vm = vm->next)
	      if ((vm->Name != NULL) && (vm->Checkbox != NULL)) {
	        EnableWindow(vm->Checkbox, ObjectsShowAll ? FALSE : TRUE);
	        if (!(vm->Display)) gezeigt = 0;
	    }
	    if (!gezeigt) SetWindowText(wndRP, StrByLang(X_CODING, L"prezenti!", L"\xffff",
			                                           L"zeigen!", L"repaint!", NULL));
	  break;
	  case RT_BUILD_CHECKBOXES:
            for (vm = model_select_chain; vm != NULL; vm = vm->next)
	      if (vm->Name != NULL) {
	        _snwprintf(ZL, 100, L"%d.: %s", vm->Number, vm->Name); ZL[99] = 0;
	        if (vm->Checkbox == NULL) {
	          vm->Checkbox = CreateWindow(L"button", ZL,
	                                      WS_CHILD | WS_VISIBLE | BS_CHECKBOX,
					      0, 0, 0, 0,
					      hwnd, (HMENU) (MN_OBJECT_ZERO + vm->Number), hThisInstance, NULL);
                } else
	          SetWindowText(vm->Checkbox, ZL);
	        if (vm->Checkbox == NULL) {
	          vm->Display = -1;
	        } else {
                  ShowWindow(vm->Checkbox, SW_SHOW);
	          vm->Display = 1;
                  SendMessage(vm->Checkbox, BM_SETCHECK, vm->Display ? BST_CHECKED : BST_UNCHECKED, 0L);
	          EnableWindow(vm->Checkbox, ObjectsShowAll ? FALSE : TRUE);
	        }
	    }
	    si.cbSize = sizeof(si);
	    si.fMask = SIF_PAGE | SIF_POS | SIF_RANGE;
	    si.nPage = CheckBoxesVisibleCount; si.nMin = 0; si.nMax = stored_model_references - 1;
	    si.nPos = FirstCheckBox;
	    SetScrollInfo(wndSC, SB_CTL, &si, TRUE);
            MdlDispCheckboxPositionAdjust(cxChar, cyChar, CheckBoxesStartY, CBHight, CheckBoxWidth,
                                          FirstCheckBox, CheckBoxesVisibleCount);
	  break;
	  case RT_CLEAR_CHECKBOXES:
            for (vm = model_select_chain; vm != NULL; vm = vm->next)
	    if (vm->Checkbox != NULL) {
	      EnableWindow(vm->Checkbox, FALSE);
              ShowWindow(vm->Checkbox, SW_HIDE);
	    }
	  break;
	  case RT_SET_LANG:
	    SetWindowText(wndRP, StrByLang(X_CODING, L"prezenti", L"\xffff",
			                   L"zeigen", L"repaint", NULL));
	    SetWindowText(wndAll, StrByLang(X_CODING, L"prezenti " US_cx L"iuj objektojn",
			                              L"prozenti cxiuj objektojn",
			                              L"alle Objekte zeigen",
					              L"show all objects", NULL));
	    SetWindowText(hwnd, StrByLang(X_CODING,
			                  L"objektoj de kapableta rigardilo por triangularaj dosieroj", L"\xffff",
				          L"Objekte des grundfunktionalen Betrachters fr Triangulationsdateien",
				          L"object in the low end triangulation file viewer",
				          NULL));
	  break;
	  default:
	    if (LOWORD(wParam) > MN_OBJECT_ZERO) {
              for (vm = model_select_chain; vm != NULL; vm = vm->next)
	        if ((vm->Name != NULL) && (vm->Checkbox != NULL)) {
	          if (LOWORD(wParam) == vm->Number + MN_OBJECT_ZERO) {
		    vm->Display = !(vm->Display);
                    SendMessage(vm->Checkbox, BM_SETCHECK, vm->Display ? BST_CHECKED : BST_UNCHECKED, 0L);
	            gezeigt = 0;
	            SetWindowText(wndRP, StrByLang(X_CODING, L"prezenti!", L"\xffff",
			                                     L"zeigen!", L"repaint!", NULL));
		  }
	      }
	    }
	}
      break;
      case WM_SIZE:
        cxChar = LOWORD(GetDialogBaseUnits());
        cyChar = HIWORD(GetDialogBaseUnits());
        HightBut = (3 * cyChar) / 2 + 2 * (GetSystemMetrics(SM_CYBORDER) + GetSystemMetrics(SM_CYEDGE));
	CheckBoxesStartY = 2 * cxChar + CBHight;
	CheckBoxesEndY = (int) HIWORD(lParam) - 2 * cxChar - HightBut;
	CheckBoxWidth = (int) LOWORD(lParam) - 2 * cxChar - GetSystemMetrics(SM_CXVSCROLL);
	CheckBoxesVisibleCount = (CheckBoxesEndY - CheckBoxesStartY) / CBHight;
	if (CheckBoxesVisibleCount <= 0) CheckBoxesVisibleCount = 1;
	if (stored_model_references < FirstCheckBox + CheckBoxesVisibleCount)
	  FirstCheckBox = stored_model_references - CheckBoxesVisibleCount;
	if (FirstCheckBox < 0) FirstCheckBox = 0;
        MoveWindow(wndAll, cxChar,                             cxChar,
	                   (int) LOWORD(lParam) - 2 * cxChar,  CBHight,
			   TRUE);
        MoveWindow(wndSC,  cxChar + CheckBoxWidth,             CheckBoxesStartY,
	                   GetSystemMetrics(SM_CXVSCROLL),     CheckBoxesEndY - CheckBoxesStartY,
			   TRUE);
	si.cbSize = sizeof(si); si.fMask = SIF_PAGE | SIF_POS | SIF_RANGE;
	GetScrollInfo(wndSC, SB_CTL, &si);
	si.nPage = CheckBoxesVisibleCount; si.nMin = 0; si.nMax = stored_model_references - 1;
	SetScrollInfo(wndSC, SB_CTL, &si, TRUE);
        MdlDispCheckboxPositionAdjust(cxChar, cyChar, CheckBoxesStartY, CBHight, CheckBoxWidth,
                                      FirstCheckBox, CheckBoxesVisibleCount);
        MoveWindow(wndRP,  cxChar,                             (int) HIWORD(lParam) - cxChar - HightBut,
	                   (int) LOWORD(lParam) - 2 * cxChar,  HightBut,
			   TRUE);
      break;
      case WM_CHAR:
	if (hwndApplication != NULL) switch (wParam) {
	  case 'q': case 'Q': case '\033': break;
	  default: KbdHit(hwndApplication, wParam);
	}
      break;
      case WM_DESTROY:
        hwndObjectDisplayDialog = NULL;
	ObjectsShowAll = 1;
        UnlinkModelSelectItems();
      default:
        return DefWindowProc(hwnd, uMsg, wParam, lParam);
    }
    return 0;
}

LRESULT CALLBACK AboutWndProc(HWND hwnd, UINT uMsg,
                              WPARAM wParam, LPARAM lParam)
{
    HWND wndTx, wndOK;
    int cxChar, cyChar, HightBut;
    SCROLLINFO si;
    HDC hdc;
    PAINTSTRUCT ps;

    switch(uMsg) {
      case WM_CREATE:
        cxChar = LOWORD(GetDialogBaseUnits());
        cyChar = HIWORD(GetDialogBaseUnits());
        wndOK = CreateWindow(L"button",
	                     StrByLang(X_CODING, L"en ordo", L"\xffff",
			               L"OK", L"OK", NULL),
	                     WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
                             0, 0, 0, 0,
                             hwnd, (HMENU) 0, hThisInstance, NULL);
        wndTx = CreateWindow(L"edit",
	                     StrByLang(X_CODING,
                    /*    0 */ L"Programiga ekzerco kun \273openGL\253 kaj \273UNICODE\253\r\n"
                               L"Versio " L_Version_string L" [kompilis: " TEXT(__DATE__)
			        L"--" TEXT(__TIME__) L"]\r\n"
                               L"\r\n\251 copyright Arnold WENDL, Frth, Germanio, anno Domini 2002, 2003\r\n\r\n"
                               L"Uzo de \273Windows registry\253:\r\n"
                               L"\"HKEY_CURRENT_USER\\" RegistryDir L"\"\r\n\r\n"
                               L"Vortaroj:\r\n"
                               L"Angla-Esteranto Komputila Vortaro,"
			        L" http://www.cilea.it/~bottoni/doc/eo-note/komputila-vortaro.htm, 1999\r\n"
                               L"Taschenwrterbuch Deutsch Esperanto,"
			        L" VEB Verlag Enzyklopdie Leipzig, 1989\r\n"
                               L"J. C. Wells: Teach Yourself Esperanto Dictionary,"
			        L" Hodder and Stoughton Ltd, 1985\r\n\r\n"
                               L"Senpaga uzo, neniu garantio!\r\n"
                               L"Free to use, no warrenty at all!\r\n"
                               L"Benutzung lizenzfrei, keinerlei Garantie!",
			       L"\xffff",
	            /*    2 */ L"Programmierbung zu \"openGL\" und \"UNICODE\"\r\n"
		               L"Version " L_Version_string L" [bersetzt: " TEXT(__DATE__)
			        L"--" TEXT(__TIME__) L"]\r\n"
                               L"\r\n\251 copyright Arnold WENDL, Frth, Deutschland, anno Domini 2002, 2003\r\n\r\n"
                               L"Benutzter Bereich der \"Windows registry\":\r\n"
                               L"\"HKEY_CURRENT_USER\\" RegistryDir L"\"\r\n\r\n"
                               L"Senpaga uzo, neniu garantio!\r\n"
                               L"Free to use, no warrenty at all!\r\n"
                               L"Benutzung lizenzfrei, keinerlei Garantie!",
	            /*    3 */ L"Programing exercise of \"openGL\" and \"UNICODE\" usage\r\n"
		               L"Version " L_Version_string L" [compiled: " TEXT(__DATE__)
			        L"--" TEXT(__TIME__) L"]\r\n"
                               L"\r\n\251 copyright Arnold WENDL, Frth, Germany, anno Domini 2002, 2003\r\n\r\n"
                               L"\"Windows registry\" usage:\r\n"
                               L"\"HKEY_CURRENT_USER\\" RegistryDir L"\"\r\n\r\n"
                               L"Senpaga uzo, neniu garantio!\r\n"
                               L"Free to use, no warrenty at all!\r\n"
                               L"Benutzung lizenzfrei, keinerlei Garantie!",
			     NULL),
	                     WS_CHILD | WS_VISIBLE | WS_VSCROLL |
			     ES_LEFT | ES_READONLY | ES_MULTILINE,
                             0, 0, 0, 0,
                             hwnd, (HMENU) 1, hThisInstance, NULL);
	SetWindowLong(hwnd, 0, (long) wndTx);
	SetWindowLong(hwnd, sizeof(long), (long) wndOK);
      break;
      case WM_COMMAND:
        if (LOWORD(wParam) == 0) DestroyWindow(hwnd);
      break;
      case WM_SIZE:
        cxChar = LOWORD(GetDialogBaseUnits());
        cyChar = HIWORD(GetDialogBaseUnits());
	wndTx = (HWND) GetWindowLong(hwnd, 0);
	wndOK = (HWND) GetWindowLong(hwnd, sizeof(long));
        HightBut = (3 * cyChar) / 2 + 2 * (GetSystemMetrics(SM_CYBORDER) + GetSystemMetrics(SM_CYEDGE));
        MoveWindow(wndOK,  32 + 2 * cxChar,                         (int) HIWORD(lParam) - cxChar - HightBut,
	                   (int) LOWORD(lParam) - 32 - 3 * cxChar,  HightBut,
			   TRUE);
	ShowScrollBar(wndTx, SB_VERT, TRUE);
        MoveWindow(wndTx,  32 + 2 * cxChar,                         cxChar,
	                   (int) LOWORD(lParam) - 32 - 3 * cxChar,  (int) HIWORD(lParam) - 3 * cxChar - HightBut,
			   TRUE);
        si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_PAGE | SIF_POS | SIF_RANGE;
	GetScrollInfo(wndTx, SB_VERT, &si);
	if ((long) si.nPage > (long) si.nMax - (long) si.nMin)
	  ShowScrollBar(wndTx, SB_VERT, FALSE);
	 else
	  ShowScrollBar(wndTx, SB_VERT, TRUE);
      break;
      case WM_PAINT:
        cxChar = LOWORD(GetDialogBaseUnits());
        hdc = BeginPaint(hwnd, &ps);
        DrawIcon(hdc, cxChar, cxChar, MyIcon);
	EndPaint(hwnd, &ps);
      default:
        return DefWindowProc(hwnd, uMsg, wParam, lParam);
    }
    return 0;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT uMsg,
                         WPARAM wParam, LPARAM lParam)
{
    switch(uMsg)
    {
        case WM_PAINT:
            DrawScene(hwnd, 0, 0, 0);
            break;
        case WM_DESTROY:
#ifdef DUMP_MAT
	    if (trail != NULL) fclose(trail);
#endif
            SaveParametersInRegistry();
            PostQuitMessage(0);
            break;
	case WM_LBUTTONDOWN:
            switch(wParam & (MK_CONTROL | MK_SHIFT)) {
	      case 0:
		DrawScene(hwnd, DRAW_ADD_ROT, LOWORD(lParam), HIWORD(lParam));
	      break;
	      case MK_SHIFT:
                view_pan(LOWORD(lParam), HIWORD(lParam));
		DrawScene(hwnd, 0, 0, 0);
	      break;
	      case MK_CONTROL:
                view_zoom(HIWORD(lParam));
		DrawScene(hwnd, 0, 0, 0);
	      break;
	      default:
                return DefWindowProc(hwnd, uMsg, wParam, lParam);
	      break;
	    }
	    break;
	case WM_RBUTTONDOWN:
            switch(wParam & (MK_CONTROL | MK_SHIFT)) {
	      case 0:
                view_pan(LOWORD(lParam), HIWORD(lParam));
		DrawScene(hwnd, 0, 0, 0);
	      break;
	      default:
                return DefWindowProc(hwnd, uMsg, wParam, lParam);
	      break;
	    }
	    break;
	case WM_MBUTTONDOWN:
            switch(wParam & (MK_CONTROL | MK_SHIFT)) {
	      case 0:
                view_zoom(HIWORD(lParam));
		DrawScene(hwnd, 0, 0, 0);
	      break;
	      default:
                return DefWindowProc(hwnd, uMsg, wParam, lParam);
	      break;
	    }
	    break;
        case WM_COMMAND:
	    MenuHit(hwnd, wParam);
	    break;
	case WM_CHAR:
	    KbdHit(hwnd, wParam);
	    break;
        default:
            return DefWindowProc(hwnd, uMsg, wParam, lParam);
    }
    return 0;
}

void OptionsScan(int first)
{ int ct, do_save;
  wchar_t Titel[MAX_PATH + 100];
  do_save = 0;
  for (ct = 1; ct < Argc; ct++) {
    if (Argv[ct][0] == L'-') {
      if (!wcscmp(Argv[ct], L"-ClearReg")) {
        if (first) UnlinkAllMyRegistryKeys();
      } else
      if (!wcscmp(Argv[ct], L"-Save")) {
        if (!first) do_save = 1;
      }
    } else if (!first) {
      CmdLineReadFile(Argv[ct], CmdLineFileRead);
      if (!CmdLineFileRead && total_facet_count) CmdLineFileRead = ct;
    }
  }
  if (CmdLineFileRead) DrawScene(hwndApplication, 0, 0, 0);
  if (VALID_MODELS) {
    wsprintf(Titel, L"%s - %s", LangWindowName,
             &(Argv[CmdLineFileRead][CmdLineFirstFileBasenameStart]));
    SetWindowText(hwndApplication, Titel);
  }
}


long ICON_AND[32] = { 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
	              0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
	              0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
	              0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L };
unsigned char ICON_XOR[128] = { 0xff, 0xff, 0xff, 0xff,
         /* Spitze */           0xff, 0xfe, 0xff, 0xff,
                                0xff, 0xfe, 0x7f, 0xff,
                                0xff, 0xfd, 0x7f, 0xff,
                                0xff, 0xfd, 0xbf, 0xff,
                                0xff, 0xf9, 0xdf, 0xff,
                                0xff, 0xf9, 0x6f, 0xff,
                                0xff, 0xf3, 0xcf, 0xff,
                                0xff, 0xf2, 0xf7, 0xff,
                                0xff, 0xe3, 0xbb, 0xff,
                                0xff, 0xe9, 0xed, 0xff,
                                0xff, 0xd7, 0x79, 0xff,
                                0xff, 0xc3, 0xde, 0xff,
                                0xff, 0x96, 0xf7, 0x7f,
                                0xff, 0xa7, 0xbd, 0xbf,
         /* Mitte des */        0xff, 0x4d, 0xef, 0x3f,
         /* Bildes    */        0xff, 0x2f, 0x7b, 0xdf,
                                0xfe, 0x4b, 0xde, 0xef,
                                0xfe, 0xae, 0xf7, 0xb7,
                                0xfd, 0x57, 0xbd, 0xe7,
                                0xfc, 0x9d, 0xef, 0x7b,
         /* mittl. Horiz. */    0xf9, 0x00, 0x00, 0x01,
                                0xfa, 0xaf, 0xff, 0xfb,
                                0xf5, 0x73, 0xff, 0xf7,
                                0xf2, 0xfd, 0xff, 0xef,
                                0xe5, 0xfe, 0xff, 0xdf,
                                0xeb, 0xff, 0x7f, 0xbf,
                                0xd7, 0xff, 0xbf, 0x7f,
                                0xcf, 0xff, 0xce, 0xff,
                                0x9f, 0xff, 0xf5, 0xff,
         /* untere Horiz. */    0x80, 0x00, 0x03, 0xff,
                                0xff, 0xff, 0xff, 0xff };

short SICON_AND[16] = { 0, 0, 0, 0, 0, 0, 0, 0,
	                0, 0, 0, 0, 0, 0, 0, 0 };
unsigned char SICON_XOR[32] = { 0xff, 0xff,  0xfe, 0xff,  0xfe, 0x7f,  0xfc, 0xbf,
                                0xfd, 0xbf,  0xf9, 0xdf,  0xf9, 0xef,  0xf5, 0xf7,
                                0xf3, 0xf7,  0xeb, 0xfb,  0xe8, 0x01,  0xd5, 0xfb,
                                0xce, 0x77,  0x9f, 0xaf,  0x80, 0x1f,  0xff, 0xff };

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                                        LPSTR d3, int nCmdShow)
{
    MSG msg;
    WNDCLASSEX wndClass;
    HDC hDC;
    PIXELFORMATDESCRIPTOR pfd;
    int iPixelFormat;

    Initialize_Local_Parameters();
    hThisInstance = hInstance;
#ifdef DUMP_MAT
    trail = fopen("cube.trail", "a");
#endif

    Argv = CommandLineToArgvW(GetCommandLine(), &Argc);
    OptionsScan(1);
    LoadParametersFromRegistry();


    if (hPrevInstance == NULL)
    {
	MyIcon = CreateIcon(NULL, 32, 32, 1, 1,
	                    (void *) &(ICON_AND[0]),
			    (void *) &(ICON_XOR[0]));
	MySmallIcon = CreateIcon(NULL, 16, 16, 1, 1,
	                    (void *) &(SICON_AND[0]),
			    (void *) &(SICON_XOR[0]));
	
        memset(&wndClass, 0, sizeof(wndClass));
	wndClass.cbSize = sizeof(wndClass);
        wndClass.style = CS_HREDRAW | CS_VREDRAW;
        wndClass.lpfnWndProc = WndProc;
        wndClass.hInstance = hInstance;
	wndClass.hIcon = MyIcon;
	wndClass.hIconSm = MySmallIcon;
        wndClass.hCursor = LoadCursor(NULL, IDC_CROSS);
        wndClass.lpszClassName = ThisClassName;
	if (!RegisterClassEx(&wndClass)) {
	  MessageBox(NULL,
                     StrByLang(X_CODING, L"\273RegisterClassExW()\253 malsukcesis!\nSubtenon de \273UNICODE\253?",
		                         L"\xffff",
					 L"'RegisterClassExW()' schlug fehl!\nUngengende UNICODE-Untersttzung?",
					 L"\"RegisterClassEsW()\" failed!\nInsufficent UNICODE support?",
					 NULL),
	             StrByLang(X_CODING, L"precipa eraro", L"\xffff",
		                         L"Grundstzlicher Fehler",
					 L"general error",
					 NULL),
		     MB_ICONSTOP | MB_OK);
          return FALSE;
	}

	wndClass.style = CS_HREDRAW | CS_VREDRAW;
	wndClass.lpfnWndProc = AboutWndProc;
	wndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndClass.lpszClassName = AboutClassName;
	wndClass.hbrBackground = (struct HBRUSH__ *) (COLOR_MENU + 1);
	wndClass.cbWndExtra = 2 * sizeof(long);
	if (!RegisterClassEx(&wndClass)) {
	  MessageBox(NULL,
                     StrByLang(X_CODING, L"\273RegisterClassExW()\253 malsukcesis!\nSubtenon de \273UNICODE\253?",
		                         L"\xffff",
					 L"'RegisterClassExW()' schlug fehl!\nUngengende UNICODE-Untersttzung?",
					 L"\"RegisterClassEsW()\" failed!\nInsufficent UNICODE support?",
					 NULL),
	             StrByLang(X_CODING, L"precipa eraro", L"\xffff",
		                         L"Grundstzlicher Fehler",
					 L"general error",
					 NULL),
		     MB_ICONSTOP | MB_OK);
	  return FALSE;
        }

	wndClass.style = CS_HREDRAW | CS_VREDRAW;
	wndClass.lpfnWndProc = MdlDispWndProc;
	wndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndClass.lpszClassName = MdlDispClassName;
	wndClass.hbrBackground = (struct HBRUSH__ *) (COLOR_MENU + 1);
	wndClass.cbWndExtra = 0;
	if (!RegisterClassEx(&wndClass)) {
	  MessageBox(NULL,
                     StrByLang(X_CODING, L"\273RegisterClassExW()\253 malsukcesis!\nSubtenon de \273UNICODE\253?",
		                         L"\xffff",
					 L"'RegisterClassExW()' schlug fehl!\nUngengende UNICODE-Untersttzung?",
					 L"\"RegisterClassEsW()\" failed!\nInsufficent UNICODE support?",
					 NULL),
	             StrByLang(X_CODING, L"precipa eraro", L"\xffff",
		                         L"Grundstzlicher Fehler",
					 L"general error",
					 NULL),
		     MB_ICONSTOP | MB_OK);
	  return FALSE;
        }
    }
    hwndApplication = CreateWindow(ThisClassName, LangWindowName,
                        WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
                        CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
                        NULL, NULL, hInstance, NULL);
    BuildMenue(hwndApplication);
    hDC = GetDC(hwndApplication);
    memset(&pfd, 0, sizeof(pfd));
    pfd.nSize = sizeof(pfd);
    pfd.nVersion = 1;
    pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL;
    pfd.iPixelType = PFD_TYPE_RGBA;
    pfd.iLayerType = PFD_MAIN_PLANE;
    pfd.cDepthBits = 32;
    iPixelFormat = ChoosePixelFormat(hDC, &pfd);
    SetPixelFormat(hDC, iPixelFormat, &pfd);
    hglrc = wglCreateContext(hDC);
    ReleaseDC(hwndApplication, hDC);
    ShowWindow(hwndApplication, nCmdShow);
    UpdateWindow(hwndApplication);
#ifdef FADEN_INIT
    AllocConsole();
#endif
    OptionsScan(0);
    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    wglMakeCurrent(NULL, NULL);
    wglDeleteContext(hglrc);
    DeleteObject(MyIcon); DeleteObject(MySmallIcon);
    return msg.wParam;
}

