program Block;

{$APPTYPE CONSOLE}

uses
  SysUtils;

{ Grenkonstanten }
const
  TileCount = 12;
  TileMaxVox = 6;
  TileMaxExt = 4;

  TileMaxRot = 6*4;
  XMax = 6; YMax = 5; ZMax = 4;

type
  TMatrix= array [1..3, 1..3, 1..3] of byte;
  TVoxCoord= array [1..3] of shortint;
  TTile= record
           CVox: byte;
           Coord: array [1..TileMaxVox, 1..3] of integer;
         end;
  TElement= record
              Vox_Next: array [1..TileMaxVox] of pointer;
              Vox_NextN: array [1..TileMaxVox] of byte;
              Vox: array [1..TileMaxVox, 1..3] of integer;
              CVox: byte;
              Tile_Next: pointer;
              TileNum, StepUsed: shortint;
            end;
  PElement= ^TElement;
  TFld= array [0..TileMaxExt,0..TileMaxExt,0..TileMaxExt] of boolean;

{ Teile }
const
  Tiles: array[1..TileCount] of TTile=(
    (CVox:5; Coord:((0,0,0),(1,0,0),(2,0,0),(0,1,0),(2,1,0),(0,0,0))),
    (CVox:5; Coord:((1,0,0),(0,1,0),(1,1,0),(2,1,0),(0,2,0),(0,0,0))),
    (CVox:6; Coord:((0,0,0),(1,0,0),(2,0,0),(3,0,0),(1,1,0),(3,1,0))),
    (CVox:5; Coord:((1,0,0),(1,1,0),(0,2,0),(1,2,0),(2,2,0),(0,0,0))),
    (CVox:5; Coord:((0,0,0),(0,1,0),(0,1,1),(0,1,2),(0,2,2),(0,0,0))),
    (CVox:5; Coord:((0,0,0),(1,0,0),(2,0,0),(0,1,0),(1,1,0),(0,0,0))),
    (CVox:5; Coord:((0,0,0),(1,0,0),(0,1,0),(0,0,1),(0,1,1),(0,0,0))),
    (CVox:5; Coord:((1,0,0),(0,1,0),(1,1,0),(2,1,0),(1,2,0),(0,0,0))),
    (CVox:4; Coord:((0,1,0),(1,1,0),(0,0,1),(0,1,1),(0,0,0),(0,0,0))),
    (CVox:5; Coord:((0,0,0),(1,0,0),(2,0,0),(3,0,0),(0,1,0),(0,0,0))),
    (CVox:5; Coord:((0,0,0),(0,1,0),(1,1,0),(1,2,0),(2,2,0),(0,0,0))),
    (CVox:5; Coord:((0,0,0),(1,0,0),(2,0,0),(3,0,0),(1,1,0),(0,0,0))) );

var BlockBase: array [0..XMax, 0..YMax, 0..ZMax] of record
      Used: boolean;
      Tile: integer;
      Overlay: integer;
      Vox_First: array[1..TileCount] of pointer;
      Vox_FirstN: array[1..TileCount] of byte;
      end;
    TileBase: array [1..TileCount] of record
      Tile_First: pointer;
      Used: boolean;
      Places: integer;
      end;

{------------------------------------------------------------------------------}

procedure Dump;

var x1,x2,x3:integer;

begin
  writeln('-----------------------------');
  for x1:=0 to ZMax do
  begin
    writeln('Z: ',x1);
    for x2:=0 to YMax do
    begin
      write('|');
      for x3:=0 to XMax do
      begin
        if BlockBase[x3,x2,x1].Used then
          write('*',BlockBase[x3,x2,x1].Tile:2,'|')
        else write(BlockBase[x3,x2,x1].Overlay:3,'|');
      end;
      writeln;
    end;
    writeln;
  end;
end;

{------------------------------------------------------------------------------}

procedure CreateStructure;

function Rotate(Tile:TTile; Rot:integer):TTile;

var TMatrix: array[1..3,1..3] of shortint;
    Return: TTile;
    Min: array[1..3] of integer;
    Cnt1, Cnt2: integer;
    S1p, S1w, S2p, S2w: shortint;

begin
  { Trafo-Matrix berechnen }
  S1p:=Rot div 4; S1w:=1-(S1p mod 2)*2;
  S1p:=(S1p div 2)+1;
  S2p:=Rot mod 4; S2w:=1-(S2p mod 2)*2;
  S2p:=S1p+1+(S2p div 2);

  if S2p>3 then S2p:=S2p-3;

  for Cnt1:=1 to 3 do
    for Cnt2:=1 to 3 do
      TMatrix[Cnt1,Cnt2]:=0;
  TMatrix[1,S1p]:=S1w;
  TMatrix[2,S2p]:=S2w;

  if (TMatrix[1,1]=0)and(TMatrix[2,1]=0) then
    TMatrix[3,1]:=TMatrix[1,2]*TMatrix[2,3]-TMatrix[1,3]*TMatrix[2,2];
  if (TMatrix[1,2]=0)and(TMatrix[2,2]=0) then
    TMatrix[3,2]:=TMatrix[1,3]*TMatrix[2,1]-TMatrix[1,1]*TMatrix[2,3];
  if (TMatrix[1,3]=0)and(TMatrix[2,3]=0) then
    TMatrix[3,3]:=TMatrix[1,1]*TMatrix[2,2]-TMatrix[1,2]*TMatrix[2,1];

  { Trafo }
  Return.CVox:=Tile.CVox;
  for Cnt1:=1 to Tile.CVox do
    for Cnt2:=1 to 3 do
    begin
      Return.Coord[Cnt1,Cnt2]:=
        Tile.Coord[Cnt1,1]*TMatrix[Cnt2,1]+
        Tile.Coord[Cnt1,2]*TMatrix[Cnt2,2]+
        Tile.Coord[Cnt1,3]*TMatrix[Cnt2,3];
      if Cnt1=1 then Min[Cnt2]:=Return.Coord[Cnt1,Cnt2]
      else if Return.Coord[Cnt1,Cnt2]<Min[Cnt2] then Min[Cnt2]:=Return.Coord[Cnt1,Cnt2];
    end;

  { Normierung }
  for Cnt1:=1 to Tile.CVox do
    for Cnt2:=1 to 3 do
      Return.Coord[Cnt1,Cnt2]:=Return.Coord[Cnt1,Cnt2]-Min[Cnt2];
  Rotate:=Return;
end;

function Insert(Tile:TTile; BaseIndex:shortint; var Base:pointer):integer;

var CntX, CntY, CntZ: integer;
    Cnt1, NumInsert: integer;
    NewElement: ^TElement;

begin
  NumInsert:=0;
  for CntX:=0 to XMax do
    for CntY:=0 to YMax do
      for CntZ:=0 to ZMax do
      begin
        new(NewElement);
        with NewElement^ do
        begin
          for Cnt1:=1 to Tile.CVox do
          begin
            Vox[Cnt1,1]:=Tile.Coord[Cnt1,1]+CntX;
            Vox[Cnt1,2]:=Tile.Coord[Cnt1,2]+CntY;
            Vox[Cnt1,3]:=Tile.Coord[Cnt1,3]+CntZ;
            if (Vox[Cnt1,1]>XMax) or (Vox[Cnt1,2]>YMax) or (Vox[Cnt1,3]>ZMax) or
              BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Used=true
              then
            begin
              dispose(NewElement);
              NewElement:=nil;
              break;
            end;
          end;
          if NewElement=nil then continue;

          Tile_Next:=Base;
          Base:=NewElement;
          TileNum:=BaseIndex;
          StepUsed:=0;
          Inc(NumInsert);
          CVox:=Tile.CVox;
          for Cnt1:=1 to CVox do
          begin
            Vox_Next[Cnt1]:=BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Vox_First[BaseIndex];
            Vox_NextN[Cnt1]:=BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Vox_FirstN[BaseIndex];
            BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Vox_First[BaseIndex]:=NewElement;
            BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Vox_FirstN[BaseIndex]:=Cnt1;
            Inc(BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Overlay);
          end;
        end;
      end;
  Insert:=NumInsert;
end;

procedure FldConvert(Tile:TTile; var Fld:TFld);

var Cnt1, Cnt2, Cnt3: integer;

begin
  for Cnt1:=0 to TileMaxExt do
    for Cnt2:=0 to TileMaxExt do
      for Cnt3:=0 to TileMaxExt do
        Fld[Cnt1,Cnt2,Cnt3]:=false;
  with Tile do
  begin
    for Cnt1:=1 to CVox do
      Fld[Coord[Cnt1,1], Coord[Cnt1,2], Coord[Cnt1,3]]:=true;
  end;
end;

function FldCompare(Fld1,Fld2:TFld):boolean;

var Cnt1, Cnt2, Cnt3: integer;
    Return: boolean;

begin
  Return:=true;
  for Cnt1:=0 to TileMaxExt do
    for Cnt2:=0 to TileMaxExt do
      for Cnt3:=0 to TileMaxExt do
        if Fld1[Cnt1,Cnt2,Cnt3]<>Fld2[Cnt1,Cnt2,Cnt3] then Return:=false;
  FldCompare:=Return;
end;

var CntX, CntY, CntZ: integer;
    Cnt1, Cnt2, Cnt3: integer;
    TileStore: array [0..TileMaxRot-1] of TTile;
    RefFld, CmpFld: TFld;
    Sym: boolean;

begin
  { Initialisierung }
  for CntX:=0 to XMax do
    for CntY:=0 to YMax do
      for CntZ:=0 to ZMax do
      begin
        If (CntX=0) or (CntY=0) or (CntZ=0) or
          (CntX=XMax) or (CntY=YMax) or (CntZ=ZMax) then
          BlockBase[CntX, CntY, CntZ].Used:=true
        else
          BlockBase[CntX, CntY, CntZ].Used:=false;
      end;

  { Datenfeld }
  for Cnt1:=1 to TileCount do
  begin
    for Cnt2:=0 to TileMaxRot-1 do
    begin
      TileStore[Cnt2]:=Rotate(Tiles[Cnt1],Cnt2);
      Sym:=false;
      { Symmetrie }
      FldConvert(TileStore[Cnt2], RefFld);
      for Cnt3:=0 to Cnt2-1 do
      begin
        FldConvert(TileStore[Cnt3], CmpFld);
        if FldCompare(RefFld, CmpFld) then
        begin
          Sym:=true;
          break;
        end;
      end;
      { Teil 3 beschrnken }
      if (Cnt1=3) then
      begin
        if ((1-((Cnt2 div 4) mod 2)*2)=1) and
           ((1-((Cnt2 mod 4) mod 2)*2)=1) then
        TileBase[Cnt1].Places:=TileBase[Cnt1].Places+
        Insert(TileStore[Cnt2], Cnt1, TileBase[Cnt1].Tile_First )
      end
      else
        If Sym=false then TileBase[Cnt1].Places:=TileBase[Cnt1].Places+
        Insert(TileStore[Cnt2], Cnt1, TileBase[Cnt1].Tile_First);
    end;
  end;
end;

procedure Solve;

var PerfCnt: longint;

function GetPosition:TVoxCoord;

var Cnt1, Cnt2, Cnt3: integer;
    Min: integer;
    Return: TVoxCoord;

begin
  Min:=0;
  for Cnt1:=0 to XMax do
    for Cnt2:=0 to YMax do
      for Cnt3:=0 to ZMax do
      begin
        if (BlockBase[Cnt1,Cnt2,Cnt3].Overlay>0) and
           ((Min=0) or (BlockBase[Cnt1,Cnt2,Cnt3].Overlay<Min)) then
        begin
        Min:=BlockBase[Cnt1,Cnt2,Cnt3].Overlay;
        Return[1]:=Cnt1; Return[2]:=Cnt2; Return[3]:=Cnt3;
        end;
      end;
  GetPosition:=Return;
end;

procedure RemTile(Element:PElement; Step:integer);

var Cnt1, Cnt2, Cnt3: integer;
    Vox_Iter: PElement;
    Vox_IterN, NextN: byte;

begin
  for Cnt1:=1 to Element^.CVox do
  begin
    with(Element^) do
    begin
      BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Used:=false;
      TileBase[TileNum].Used:=false;
      for Cnt2:=1 to TileCount do
        if TileBase[Cnt2].Used=false then
        begin
          Vox_Iter:=BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Vox_First[Cnt2];
          Vox_IterN:=BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Vox_FirstN[Cnt2];
          while(Vox_Iter<>nil) do
          begin
            if Vox_Iter^.StepUsed=Step then
            begin
              for Cnt3:=1 to Vox_Iter^.CVox do
                with(Vox_Iter^) do
                  inc(BlockBase[Vox[Cnt3,1],Vox[Cnt3,2],Vox[Cnt3,3]].Overlay);
              Vox_Iter^.StepUsed:=0;
              inc(TileBase[Vox_Iter^.TileNum].Places);
            end;
            NextN:=Vox_Iter^.Vox_NextN[Vox_IterN];
            Vox_Iter:=Vox_Iter^.Vox_Next[Vox_IterN];
            Vox_IterN:=NextN;
          end;
      end;
    end;
  end;
  Vox_Iter:=TileBase[Element^.TileNum].Tile_First;
  while(Vox_Iter<>nil) do
  begin
    if Vox_Iter^.StepUsed=Step then
    begin
      for Cnt2:=1 to Vox_Iter^.CVox do
        with(Vox_Iter^) do
          inc(BlockBase[Vox[Cnt2,1],Vox[Cnt2,2],Vox[Cnt2,3]].Overlay);
      Vox_Iter^.StepUsed:=0;
      inc(TileBase[Vox_Iter^.TileNum].Places);
    end;
    Vox_Iter:=Vox_Iter^.Tile_Next;
  end;
end;

function TryTile(Element:PElement; Step:integer):boolean;

var Cnt1, Cnt2, Cnt3: integer;
    Vox_Iter: PElement;
    Vox_IterN, NextN: byte;

begin
  if Element^.StepUsed<>0 then
  begin
    TryTile:=false;
    exit;
  end;
  { Voxel markieren }
  Inc(PerfCnt);
  for Cnt1:=1 to Element^.CVox do
    with(Element^) do
    begin
      BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Used:=true;
      BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Tile:=TileNum;
    end;
  { Overlay anpassen }
  for Cnt1:=1 to Element^.CVox do
  begin
    with(Element^) do
    begin
      TileBase[TileNum].Used:=true;
      for Cnt2:=1 to TileCount do
        if TileBase[Cnt2].Used=false then
        begin
          Vox_Iter:=BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Vox_First[Cnt2];
          Vox_IterN:=BlockBase[Vox[Cnt1,1],Vox[Cnt1,2],Vox[Cnt1,3]].Vox_FirstN[Cnt2];
          while(Vox_Iter<>nil) do
          begin
            if Vox_Iter^.StepUsed=0 then
            begin
              for Cnt3:=1 to Vox_Iter^.CVox do
                with(Vox_Iter^) do
                  dec(BlockBase[Vox[Cnt3,1],Vox[Cnt3,2],Vox[Cnt3,3]].Overlay);
              Vox_Iter^.StepUsed:=Step;
              dec(TileBase[Vox_Iter^.TileNum].Places);
            end;
            NextN:=Vox_Iter^.Vox_NextN[Vox_IterN];
            Vox_Iter:=Vox_Iter^.Vox_Next[Vox_IterN];
            Vox_IterN:=NextN;
          end;
        end;
    end;
  end;
  Vox_Iter:=TileBase[Element^.TileNum].Tile_First;
  while(Vox_Iter<>nil) do
  begin
    if Vox_Iter^.StepUsed=0 then
    begin
      for Cnt2:=1 to Vox_Iter^.CVox do
        with(Vox_Iter^) do
          dec(BlockBase[Vox[Cnt2,1],Vox[Cnt2,2],Vox[Cnt2,3]].Overlay);
      Vox_Iter^.StepUsed:=Step;
      dec(TileBase[Vox_Iter^.TileNum].Places);
    end;
    Vox_Iter:=Vox_Iter^.Tile_Next;
  end;

  { Platz prfen }
  for Cnt1:=0 to XMax do
    for Cnt2:=0 to YMax do
      for Cnt3:=0 to ZMax do
        if (BlockBase[Cnt1,Cnt2,Cnt3].Overlay=0) and
          not(BlockBase[Cnt1,Cnt2,Cnt3].Used) then
        begin
          TryTile:=false;
          RemTile(Element, Step);
          exit;
        end;

  for Cnt1:=1 to TileCount do
    if not(TileBase[Cnt1].Used) and
       (TileBase[Cnt1].Places=0) then
    begin
      TryTile:=false;
      RemTile(Element, Step);
      exit;
    end;
  TryTile:=true;
end;

var Step, Sol: integer;
    Cnt1: integer;
    StepElement: array[1..TileCount] of PElement;
    StepElementN: array[1..TileCount] of byte;
    StepTile: array[1..TileCount] of shortint;
    NextN: array[1..TileCount] of byte;
    Voxel: TVoxCoord;
    Back: boolean;

begin
  Step:=1;
  Sol:=0; PerfCnt:=0;
  for Cnt1:=1 to TileCount do StepElement[Cnt1]:=nil;
  while (Step>0) do
  begin
    { Nchstes Teil }
    if StepElement[Step]=nil then
    begin
      Voxel:=GetPosition;
      StepTile[Step]:=1;
      while (BlockBase[Voxel[1],Voxel[2],Voxel[3]].Vox_First[StepTile[Step]]=nil)
        or (TileBase[StepTile[Step]].Used) do inc(StepTile[Step]);
      StepElement[Step]:=BlockBase[Voxel[1],Voxel[2],Voxel[3]].Vox_First[StepTile[Step]];
      StepElementN[Step]:=BlockBase[Voxel[1],Voxel[2],Voxel[3]].Vox_FirstN[StepTile[Step]];
    end
    else
    begin
      { Weiter (Voxel) }
      if (StepElement[Step].Vox_Next[StepElementN[Step]]<>nil) then
      begin
        NextN[Step]:=StepElement[Step].Vox_NextN[StepElementN[Step]];
        StepElement[Step]:=StepElement[Step].Vox_Next[StepElementN[Step]];
        StepElementN[Step]:=NextN[Step];
      end
      else begin
        { Weiter (Teil) }
        Back:=false;
        repeat
          { Rcksprung }
          if (StepTile[Step]=TileCount) then
          begin
            Dec(Step);
            if Step=0 then break;
            RemTile(StepElement[Step], Step);
            Back:=true;
            break;
          end;
          inc(StepTile[Step]);
        until
          (BlockBase[Voxel[1],Voxel[2],Voxel[3]].Vox_First[StepTile[Step]]<>nil)
          and (TileBase[StepTile[Step]].Used=false) ;
        if (Step=0) or Back then continue;
        StepElement[Step]:=BlockBase[Voxel[1],Voxel[2],Voxel[3]].Vox_First[StepTile[Step]];
        StepElementN[Step]:=BlockBase[Voxel[1],Voxel[2],Voxel[3]].Vox_FirstN[StepTile[Step]];
      end;
    end;

    { Teil probieren }
    if TryTile(StepElement[Step], Step) then
    begin
      { Lsung? }
      if Step=TileCount then
      begin
        Inc(Sol);
        writeln('Lsg ',Sol,' (',PerfCnt,'/Eff.:',100*Sol/PerfCnt:2:4,'%):');
        Dump;
        RemTile(StepElement[Step], Step);
      end
      else
      begin
        Inc(Step);
        StepElement[Step]:=nil;
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------}

begin
  write('Erzeuge Struktur... ');
  CreateStructure;
  writeln('done!');
  writeln('Starte Suche...');
  Solve;
end.
