{-----------------------------------------------------------------------------

    ct-puzzle: Quellcode zum Programmierwettbewerb aus c't Heft 7/2003

    Copyright (c) Andreas Zapf 2003. Alle Rechte vorbehalten.

-----------------------------------------------------------------------------}

unit solvethrd;

interface

uses ctpPuzzle;

// Anzahl der gerade laufenden Threads
function SolveThreadCount: integer;

// Wartet timeout ms auf alle laufenden Threads,
// gibt Anzahl der danach noch laufenden Threads zurck
// Wenn timeout = INFINITE, wird ewig gewartet.
function WaitForSolveThreads(timeout: integer): integer;

// Startet Lsungs-Thread, gibt Thread-Handle zurck
function StartSolveThread(Puzzles, PuzzlesDone: TPuzzleQueue): integer;

implementation

uses sysutils, classes, windows, solver;

var
    RunningThreads:    TThreadList;

type

PSolveThreadInfo = ^TSolveThreadInfo;
TSolveThreadInfo = record
    Puzzles:     TPuzzleQueue;
    PuzzlesDone: TPuzzleQueue;
    hThread:     LongWord;
    idThread:    LongWord;
end;

function SolveThreadCount: integer;
var
    Threads: TList;
begin
    Threads := RunningThreads.LockList;
    try
        result := Threads.Count;
    finally
        RunningThreads.UnlockList;
    end;
end;

function WaitForSolveThreads(timeout: integer): integer;
var
    Threads: TList;
    i, cnt: integer;
    Handles: array of THandle;
    waitres: DWORD;
begin
    result := 0;

    // Handles ins Array kopieren
    Threads := RunningThreads.LockList;
    try
        cnt := Threads.count;
        SetLength(Handles, cnt);
        for i := 0 to cnt-1 do
        begin
            Handles[i] := PSolveThreadInfo(Threads[i]).hThread;
        end;
    finally
        RunningThreads.UnlockList;
    end;

    // Auf alle Threads warten
    waitres := WaitForMultipleObjects(cnt, @Handles[0], true, timeout);

    // Ergebnis werten
    if waitres = WAIT_FAILED then
        RaiseLastWin32Error
    else result := SolveThreadCount;
end;

function ThreadProc(Parameter: Pointer): integer; forward;

function StartSolveThread(Puzzles, PuzzlesDone: TPuzzleQueue): integer;
var
    Threads: TList;
    PInfo: PSolveThreadInfo;
begin
    Threads := RunningThreads.LockList;
    try
        new(PInfo);
        PInfo.Puzzles     := Puzzles;
        PInfo.PuzzlesDone := PuzzlesDone;
        PInfo.hThread     := BeginThread(nil, 0, @ThreadProc,
                                         PInfo, CREATE_SUSPENDED,
                                         PInfo.idThread);

        if PInfo.hThread = 0 then
        begin
            dispose(PInfo);
            RaiseLastWin32Error;
        end;

        Threads.Add(PInfo);
        ResumeThread(PInfo.hThread);
        result := PInfo.hThread;
    finally
        RunningThreads.UnlockList;
    end;
end;

procedure EndSolveThread(PInfo: PSolveThreadInfo; ThreadRes: integer);
var
    Threads: TList;
begin
    Threads := RunningThreads.LockList;
    try
        CloseHandle(PInfo.hThread);
        Threads.Remove(PInfo);
        dispose(PInfo);
    finally
        RunningThreads.UnlockList;
        EndThread(ThreadRes);
    end;
end;

function ThreadProc(Parameter: Pointer): integer;
var
    PInfo: PSolveThreadInfo;
begin
    result := 0;
    PInfo := Parameter;
    try
        Solver.Solve(PInfo.Puzzles, PInfo.PuzzlesDone);
    except
        ShowException(ExceptObject, ExceptAddr);
        result := -1;
    end;
    EndSolveThread(PInfo, result);
end;

initialization

RunningThreads := TThreadList.Create;

finalization

RunningThreads.Free;

end.
