{-----------------------------------------------------------------------------

    ct-puzzle: Quellcode zum Programmierwettbewerb aus c't Heft 7/2003

    Copyright (c) Andreas Zapf 2003. Alle Rechte vorbehalten.

-----------------------------------------------------------------------------}

unit ctpUtil;

interface

uses ctpDefs, ctpPuzzleParts;

// Positionen im Wrfel als Ascii
function IdxToAsciiCube: string;

// Positionen im Puzzle als Ascii
function IdxToAsciiPuzzle: string;

// Eine Lsung als String
function PartsToAscii(const Parts: array of TPuzzlePartPos): string;

implementation

uses SysUtils, classes, windows, ctpBase;

function IdxToAsciiCube: string;
var
    fmt: string;
    line: string;
    S: TStringList;
    x, y, z: integer;
begin
    fmt := '%4s';
    S := TStringList.Create;
    try
        for z := SIZE_MAX-1 downto 0 do
        begin
            for y := SIZE_MAX-1 downto 0 do
            begin
                line := '';
                for x := SIZE_MAX-1 downto y+1 do
                    line := line
                        + Format(fmt, ['']);
                for x := 0 to SIZE_MAX - 1 do
                    line := line
                        + Format(fmt, [IntToStr(IdxCube(x,y,z))]);
                S.Add(line);
            end;
        end;
        result := S.Text;
    finally
        S.Free;
    end;
end;

function IdxToAsciiPuzzle: string;
var
    fmt: string;
    line: string;
    S: TStringList;
    x, y, z: integer;
begin
    fmt := '%3s';
    S := TStringList.Create;
    try
        for z := SIZE_Z-1 downto 0 do
        begin
            for y := SIZE_Y-1 downto 0 do
            begin
                line := '';
                for x := SIZE_Y-1 downto y+1 do
                    line := line
                        + Format(fmt, ['']);
                for x := 0 to SIZE_X - 1 do
                    line := line
                        + Format(fmt, [IntToStr(IdxPuzzle(x,y,z))]);
                S.Add(line);
            end;
        end;
        result := S.Text;
    finally
        S.Free;
    end;
end;

function PartsToAscii(const Parts: array of TPuzzlePartPos): string;
var
    fmt: string;
    line: string;
    S: TStringList;
    x, y, z: integer;
    iPart: integer;
    found: boolean;
begin
    fmt := '%3s';
    S := TStringList.Create;
    try
        for z := SIZE_Z-1 downto 0 do
            for y := SIZE_Y-1 downto 0 do
        begin
            line := '';
            for x := SIZE_Y-1 downto y+1 do
                line := line
                    + Format(fmt, ['']);
            for x := 0 to SIZE_X - 1 do
            begin
                found := false;
                for iPart := 0 to High(Parts) do
                begin
                    if Parts[iPart].At(x,y,z) then
                    begin
                        line := line
                            + Format(fmt, [IntToStr(iPart)]);
                        found := true;
                        break;
                    end;
                end;
                if not found then line := line + Format(fmt, ['-']);
            end;
            S.Add(line);
        end;
        result := S.Text;
    finally
        S.Free;
    end;
end;

end.
