{-----------------------------------------------------------------------------

    ct-puzzle: Quellcode zum Programmierwettbewerb aus c't Heft 7/2003

    Copyright (c) Andreas Zapf 2003. Alle Rechte vorbehalten.

-----------------------------------------------------------------------------}

unit ctpStdParts;

// Teile fr die c't-Wettbewerbsaufgabe

interface

procedure MakeStdParts;

implementation

uses ctpBase, ctpBaseParts, ctpGlobalData;

procedure MakeStdParts;
begin

    // XX  ("c" von "c't")
    // X
    // XX
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(1,0,0),
        Cell(0,1,0),
        Cell(0,2,0),
        Cell(1,2,0)]));

    // X  das "t" von "c't"
    // XX
    // X
    // XX
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(2,0,0),
        Cell(0,1,0),
        Cell(1,1,0),
        Cell(2,1,0),
        Cell(3,1,0)]));

    //  XX
    //  X
    // XX
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(1,0,0),
        Cell(1,1,0),
        Cell(1,2,0),
        Cell(2,2,0)]));

    //  X
    //  X
    //  X
    // XX
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(1,0,0),
        Cell(2,0,0),
        Cell(3,0,0),
        Cell(0,1,0)]));

    //  X
    // XX
    //  X
    //  X
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(1,0,0),
        Cell(2,0,0),
        Cell(3,0,0),
        Cell(1,1,0)]));

    // XX
    // XX und ein Wrfel senkrecht (der Apostroph)
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(1,0,0),
        Cell(0,1,0),
        Cell(1,1,0),
        Cell(0,0,1)]));

    // 5
    // X
    // XXX
    // X
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(1,0,0),
        Cell(2,0,0),
        Cell(1,1,0),
        Cell(1,2,0)]));

    // 6
    //  X
    // XX
    // XX
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(1,0,0),
        Cell(2,0,0),
        Cell(0,1,0),
        Cell(1,1,0)]));

    // 7
    // X
    // XX
    //  XX
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(1,0,0),
        Cell(1,1,0),
        Cell(2,1,0),
        Cell(2,2,0)]));

    // 8
    //  X
    // XX + ein Wrfel senkrecht
    AddBasePart(MakeBasePart([
        Cell(0,0,0),
        Cell(1,0,0),
        Cell(0,1,0),
        Cell(0,1,1)]));

    // 9
    //  XX
    // XX
    //  X
    AddBasePart(MakeBasePart([
        Cell(1,0,0),
        Cell(0,1,0),
        Cell(1,1,0),
        Cell(2,1,0),
        Cell(0,2,0)]));

    // 10
    //  X
    // XXX
    //  X
    AddBasePart(MakeBasePart([
        Cell(1,0,0),
        Cell(0,1,0),
        Cell(1,1,0),
        Cell(2,1,0),
        Cell(1,2,0)]));

end;

end.
