{-----------------------------------------------------------------------------

    ct-puzzle: Quellcode zum Programmierwettbewerb aus c't Heft 7/2003

    Copyright (c) Andreas Zapf 2003. Alle Rechte vorbehalten.

-----------------------------------------------------------------------------}


// Include-Datei fr Assembler-Lsungsroutine
// Kann mit diversen $DEFINEs fr mehrere Methoden
// verwendet werden

asm
@@go:
    push ebx
    // self -> ebx
    mov ebx,eax

    call @@recurse

    pop ebx
    ret

@@recurse:
    push edi
    push esi
    push ebp

    // Lokale Variablen relativ zu esp (innerhalb der Routine
    // keine Stackoperationen)
    //     [esp]             Pointer auf aktuelles Positions-Array
    //     [esp+4]           Index des nchsten freien Bits
    //     [esp+8]..[esp+12] Sicherung von FBits
{$IFDEF NEXT_BITS}
    //     [esp+16]          NextBits
    sub esp,20
{$ELSE}
    sub esp,16
{$ENDIF}

    mov eax,dword[ebx+TPuzzle.FBits]
    mov edx,dword[ebx+TPuzzle.FBits+4]
    mov [esp+8],eax
    mov [esp+12],edx

    // erste freie Position suchen (statt call TPuzzlePartPos.FirstFree)
    // Vorteil: schneller (bringt fast 10%),
    // Nachteil: undefiniertes Verhalten, wenn kein freies
    // bit mehr da ist.
    not eax
    bsf ecx,eax
    jnz @@foundFree
    not edx
    bsf ecx,edx
    add ecx,32
@@foundFree:
    mov [esp+4],ecx // [esp+4] <-NextIdx

{$IFDEF NEXT_BITS}
    // NextBits ermitteln
    lea eax,dword[ebx+TPuzzle.FBits]
    mov edx,ecx
    call TPuzzlePartPos.NextBits
    mov [esp+16],al
{$ENDIF}

    // for iPart := FPartCount-1 downto 0 do
    mov edi,[ebx].FPartCount
@@partLoop:
    mov ecx,[ebx].Fused
@@partLoop1:
    dec edi
    js @@exit
    // if not FUsed[iPart] then
    cmp byte ptr[ecx+edi],0
    jne @@partLoop1


    // Positions := FParts[iPart].GetPositions(NextIdx, BitsNextXYZ);

{$IFDEF NEXT_BITS}
    movzx ecx,byte[esp+16] // NextBits
    mov edx,[esp+4] // NextIdx
    mov eax,[ebx].FParts
    mov eax,[eax+edi*4]
    mov esi,[eax] // vmt
    call dword[esi+12] // call dword ptr[esi].TPuzzlePart.GetPositions
    // if assigned(Positions) then
    test eax,eax
    jz @@partLoop
{$ELSE}
    mov edx,[esp+4] // NextIdx
    mov eax,[ebx].FParts
    mov eax,[eax+edi*4]
//    lea eax,[eax+edx*12+TPuzzlePartStd.FPositions]
    lea edx,[edx+edx*2]
    lea eax,[eax+edx*4+TPuzzlePartStd.FPositions]
    cmp [eax+TPuzzlePartPositions.Count],0
    je @@partLoop
{$ENDIF}

    // Positions in ecx und auf dem Stack merken
    mov [esp],eax
    // for iPos := 0 to Positions.Count-1 do
    mov esi,[eax+TPuzzlePartPositions.Count]

@@positionLoop:
    mov ecx,[esp] // Positions nach ecx zurckholen
@@positionLoop1:
    dec esi
    js @@partLoop

    // ebp <- Positions.Positions[iPos]
    mov ebp,[ecx+TPuzzlePartPositions.Positions]
    lea ebp,[ebp+esi*8]
    // if Positions.Positions[iPos].Bits and FBits.Bits = 0 then
    mov eax,[ebp]
    mov edx,[ebp+4]
    and eax,dword ptr[ebx].FBits
    and edx,dword ptr[ebx+4].FBits
    or  eax,edx
    jnz @@positionLoop1

@@usePosition:
    // FUsed[iPart] := true;
    mov ecx,[ebx].FUsed
    mov byte ptr[ecx+edi],01h

    // FBits.bits := FBits.bits or Bits;
    mov eax,[ebp]
    mov edx,[ebp+4]
    or dword ptr[ebx].FBits,eax
    or dword ptr[ebx+4].FBits,edx

    // FPartLocations[iPart] := Positions.Positions[iPos];
    mov ecx,[ebx].FPartLocations
    mov dword ptr [ecx+edi*8],eax
    mov dword ptr [ecx+edi*8+4],edx

    // if FLevel = 0 then
    cmp [ebx].FLevel,0
    je @@foundSolution

@@callRecurse:
    dec [ebx].FLevel
    call @@recurse
    inc [ebx].FLevel

@@checkStopped:
    // if FStopped then exit;
    cmp byte ptr[ebx].FStopped,0
    jne @@exit

@@donePosition:

    // FUsed[iPart] := false;
    mov eax,[ebx].FUsed
    mov byte ptr[eax+edi],00h

    // FBits.bits zurckholen
    mov eax,[esp+8]
    mov edx,[esp+12]
    mov dword ptr[ebx].FBits,eax
    mov dword ptr[ebx+4].FBits,edx
    jmp @@positionLoop

@@foundSolution:
    // inc(FSolutions);
    inc [ebx].FSolutions
    cmp [ebx].FOnSolution,0
    jz @@donePosition
    // FOnSolution(self, FStopped);
    lea edx,[ebx].FStopped
    mov byte ptr[edx],0
    mov eax,ebx
    call dword ptr[ebx].FOnSolution
    jmp @@checkStopped

@@exit:
{$IFDEF NEXT_BITS}
    add esp,20
{$ELSE}
    add esp,16
{$ENDIF}
    pop ebp
    pop esi
    pop edi
end;

