{-----------------------------------------------------------------------------

    ct-puzzle: Quellcode zum Programmierwettbewerb aus c't Heft 7/2003

    Copyright (c) Andreas Zapf 2003. Alle Rechte vorbehalten.

-----------------------------------------------------------------------------}

unit ctpGlobalData;

///////////////////////////////////////////////////////////////
// Variablen fr die globalen Puzzle-Daten (Teile etc)
///////////////////////////////////////////////////////////////


interface

uses contnrs, ctpBaseParts, ctpPuzzleParts;

var
    BaseParts: array of TBasePart;
    BaseRotations: array of TBasePartRotations;

    // Alle vorhandenen Puzzle-Teile in jeder
    // mglichen Kombination. Die TPuzzle-Instanzen
    // erhalten ggf. nur Ausschnitte davon
    PuzzleParts: TObjectList;

// Ein BasePart zur Liste hinzufgen
procedure AddBasePart(const P: TBasePart);

// Die Rotationen der BaseParts erzeugen
// (Die Liste der BaseParts sollte abgeschlossen sein)
procedure MakeRotations;

// PuzzleParts erzeugen
procedure MakePuzzleParts(PartClass: TPuzzlePartClass);


implementation

procedure AddBasePart(const P: TBasePart);
begin
    SetLength(BaseParts, Length(BaseParts)+1);
    BaseParts[High(BaseParts)] := P;
    BaseParts[High(BaseParts)].Normalize;
end;

procedure MakeRotations;
var
    i: integer;
    hasMaster: boolean;
begin
    hasMaster := false;
    SetLength(BaseRotations, Length(BaseParts));

    for i := 0 to High(BaseRotations) do
    begin
        BaseRotations[i].Make(BaseParts[i], not hasMaster);
        hasMaster := hasMaster or (BaseRotations[i].count > 0);
        if BaseRotations[i].count <= 0 then
            BaseRotations[i].Make(BaseParts[i], false);
    end;
end;

procedure MakePuzzleParts(PartClass: TPuzzlePartClass);
var
    i: integer;
    Part: TPuzzlePart;
begin
    PuzzleParts.Clear;

    for i := 0 to High(BaseRotations) do
    begin
        Part := PartClass.Create;
        Part.Make(BaseRotations[i]);
        PuzzleParts.Add(Part);
    end;
end;


initialization

    PuzzleParts := TObjectList.Create;

finalization

    PuzzleParts.Free;

end.
