{-----------------------------------------------------------------------------

    ct-puzzle: Quellcode zum Programmierwettbewerb aus c't Heft 7/2003

    Copyright (c) Andreas Zapf 2003. Alle Rechte vorbehalten.

-----------------------------------------------------------------------------}

unit ctpDefs;

/////////////////////////////////////////////////////////////
//  Grundlegende Definitionen
/////////////////////////////////////////////////////////////

interface

const

    // Gemeinsame Konstanten in Include-Datei
    _NASM_INCLUDE_HACK_=0{$I ctpDefs.inc};

    // Symmetrien des Puzzles:
    // Quader:                             4
    // Quader mit 2 quadratischen Flchen: 8
    // Wrfel:                            24
    SYMMETRY_COUNT = 4; // da Quader (SIZE_X, SIZE_Y, SIZE_Z verschieden)

    // Max. mgliche Anzahl Rotationsschritte fr einen aus Wrfeln
    // zusammengesetzten Krper in einer Ebene
    ROTATIONS_MAX = 4;

    // Max. mgliche Anzahl Rotationsvarianten fr einen aus Wrfeln
    // zusammengesetzten Krper
    ROT_VARIATIONS_MAX = 24;

    // Anzahl Rotationsvarianten fr das "Master-Teil"
    // Das "Master-Teil" darf nur 1x vorkommen und muss
    // vollstndig asymmetrisch sein.
    // Dann knnen durch die Beschrnkung der Rotationsvarianten
    // symmetrische Lsungen von vornherein unbercksichtigt bleiben.
    ROT_VARIATIONS_MASTER = ROT_VARIATIONS_MAX div SYMMETRY_COUNT;

    // Anzahl Indices
    COUNT_IDX_CUBE   = SIZE_MAX*SIZE_MAX*SIZE_MAX;
    COUNT_IDX_PUZZLE = SIZE_X*SIZE_Y*SIZE_Z;

/////////////////////////////////////////////////////////////
//  Typen
/////////////////////////////////////////////////////////////
type

PLongBool = ^LongBool;

// Achse
TAxis = (xAxis, yAxis, zAxis);

// Form
TShape = (cube, squareCuboid, cuboid);

// Basis-Koordinate
TCoord = 0..SIZE_MAX-1;

// Index im Puzzle
TIdxPuzzle = 0..COUNT_IDX_PUZZLE-1;

// Index im Puzzle-umschlieenden Wrfel
TIdxCube = 0..COUNT_IDX_CUBE-1;

// Standardrotation
TStdRotationCube = 0..ROT_VARIATIONS_MAX-1;


// Basis-Zelle
PCell = ^TCell;
TCell = record
    x, y, z: TCoord;
end;

/////////////////////////////////////////////////////////////
//  Typisierte Konstanten bzw. globale Variablen
/////////////////////////////////////////////////////////////

implementation


end.
