// CTCube11.cpp : Defines the entry point for the console application.
//

#include <stdlib.h>
#include <stdio.h>
#include <tchar.h>

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>

#define	MAXFIG		12
#define	MAXPOS		60
#define	HIGHPOS		32
#define LOWPOS		(MAXPOS-HIGHPOS)

#define	MAXLOW		32
#define	MAXHIGH		32

#define	LOWCUBE(C)	((HCUBE)(C))
#define	HIGHCUBE(C)	((HCUBE)((C) >> 32))

#define	HASHSHIFT	25
#define	HASHSIZE	(1 << HASHSHIFT)
#define	HASHMASK	(HASHSIZE - 1)
#define	HASHOVR		512

typedef unsigned __int64	CUBE;
typedef unsigned int		HCUBE;
typedef	unsigned int		ISUSED;

#pragma pack(push)
#pragma pack(2)
typedef	struct {
	CUBE	Cube;
	__int16		Solved;		// min __int16
} SOLVEDHASH;
#pragma pack(pop)

typedef	struct {
	HCUBE	HCube;
	ISUSED	IsUsed;
}	POSLIST;

typedef struct {
	POSLIST* pPosList;
	HCUBE	 Mask;
}	POSINFO;

typedef struct {
	int		HashIndex;
	HCUBE	Mask;
	POSINFO	PosInfo[HIGHPOS];
}	CFGINFO;

typedef struct {
	unsigned int		b00:1;
	unsigned int		b01:1;
	unsigned int		b02:1;
	unsigned int		b03:1;
	unsigned int		b04:1;
	unsigned int		b05:1;
	unsigned int		b06:1;
	unsigned int		b07:1;
	unsigned int		b08:1;
	unsigned int		b09:1;
	unsigned int		b10:1;
	unsigned int		b11:1;
	unsigned int		b12:1;
	unsigned int		b13:1;
	unsigned int		b14:1;
	unsigned int		b15:1;
	unsigned int		b16:1;
	unsigned int		b17:1;
	unsigned int		b18:1;
	unsigned int		b19:1;
	unsigned int		b20:1;
	unsigned int		b21:1;
	unsigned int		b22:1;
	unsigned int		b23:1;
	unsigned int		b24:1;
	unsigned int		b25:1;
	unsigned int		b26:1;
	unsigned int		b27:1;
	unsigned int		b28:1;
	unsigned int		b29:1;
	unsigned int		b30:1;
	unsigned int		b31:1;
	unsigned int		b32:1;
	unsigned int		b33:1;
	unsigned int		b34:1;
	unsigned int		b35:1;
	unsigned int		b36:1;
	unsigned int		b37:1;
	unsigned int		b38:1;
	unsigned int		b39:1;
	unsigned int		b40:1;
	unsigned int		b41:1;
	unsigned int		b42:1;
	unsigned int		b43:1;
	unsigned int		b44:1;
	unsigned int		b45:1;
	unsigned int		b46:1;
	unsigned int		b47:1;
	unsigned int		b48:1;
	unsigned int		b49:1;
	unsigned int		b50:1;
	unsigned int		b51:1;
	unsigned int		b52:1;
	unsigned int		b53:1;
	unsigned int		b54:1;
	unsigned int		b55:1;
	unsigned int		b56:1;
	unsigned int		b57:1;
	unsigned int		b58:1;
	unsigned int		b59:1;
} BITS;

typedef union {
	CUBE	Q;
	BITS	Bits;
}	CUBE_U;

typedef	struct {
	int		Blocks;
	enum	PTYPE {NONE, T222, T333, T421, T3SL}	Type;
	BITS	Bits;
}	PIECE;


PIECE	StartPieces[] = {
	{6, PIECE::T421, {1,1,0, 1,0,0, 1,1,0, 1,0,0}},	//*   1  6 Bloecke 4x2x1 t
	{5, PIECE::T421, {1,1,0, 1,0,0, 1,0,0, 1,0,0}},	//*   2  5 Bloecke 4x2x1 L
	{5, PIECE::T421, {1,0,0, 1,0,0, 1,1,0, 1,0,0}},	//*   3  5 Bloecke 4x2x1 1
	{5, PIECE::T333, {1,0,0, 1,1,0, 1,1,0}},		//*   4  5 Bloecke 3x2x1 P
	{5, PIECE::T333, {1,1,0, 0,1,1, 0,1,0}},		//*   8  5 Bloecke 3x3x1 4
	{5, PIECE::T333, {1,1,0, 1,0,0, 1,1,0}},		//*   4  5 Bloecke 3x2x2 C
	{5, PIECE::T333, {1,1,0, 0,1,0, 0,1,1}},		//*   6  5 Bloecke 3x3x1 S
	{5, PIECE::T333, {1,1,0, 0,1,1, 0,0,1}},		//*   9  5 Bloecke       w
	{5, PIECE::T333, {1,0,0, 1,1,1, 1,0,0}},		//*   7  5 Bloecke		 T
	{4, PIECE::T222, {1,1,0, 0,0,0, 0,0,0, 0,0,0,	//*  12	 4 Bloecke 2x2x2 Q4
					  1,0,0, 1,0,0}},
	{5, PIECE::T333, {0,1,0, 1,1,1, 0,1,0}},		//*  10  5 Bloecke       x
	{5, PIECE::T3SL, {1,1,0, 1,1,0, 0,0,0, 0,0,0,	//*  11  5 Bloecke 2x2x2 Q5
					  1,0,0, 0,0,0}},
	{0, PIECE::NONE, {0}}
};

int	Map[MAXPOS] = {
	 0,  2,  9,  11,
	 1,	 10,			
	 3,  5,  4, 
	 6,  8,	 7, 
			   	 
	12, 14, 13,	
	21, 23, 22,	
	15, 17, 16,	
	18, 20, 19,	
			   
	24, 26,	25, 
	27, 
	36, 38, 37,	
	48, 50, 49,

	29, 28, 

	39,	51, 
	
	53, 52,	
	41, 40, 
			   
	30,	33,	
	42, 44, 43,	
	45, 46, 47,	
			
	31, 32,	34,	35, 

	54, 55, 56,	
	57, 58, 59  
};

SOLVEDHASH	SolvedHash[HASHSIZE+HASHOVR];
SOLVEDHASH	DummyHash;

int			SolutionCounter = 0;

CUBE		LowFig[LOWPOS][MAXFIG][MAXLOW];
CFGINFO		CfgInfoList[1 << MAXFIG];
 
POSLIST		PosBuffer[2000000];

CUBE MapCube (CUBE Cube)
{
	CUBE	DstCube = 0;

	for (int i = 0; (i < MAXPOS) && Cube; i++)
		DstCube |= ((Cube >> Map[i]) & 1) << i;
	return DstCube;
}

void ShiftDown (CUBE &Cube)
{
	while (!(Cube & 011111111111111111111))
		Cube = Cube >> 1;
	while (!(Cube & 000070007000700070007))
		Cube = Cube >> 3;
	while (!(Cube & 000000000000000007777))
		Cube = Cube >> 12;
}

CUBE ShiftXUp (CUBE Cube)
{
	if (Cube & 044444444444444444444)
		return 0;
	return Cube << 1;
}

CUBE ShiftYUp (CUBE Cube)
{
	if (Cube & 070007000700070007000)
		return 0;
	return Cube << 3;
}

CUBE ShiftZUp (CUBE Cube)
{
	if (Cube & 077770000000000000000)
		return 0;
	return Cube << 12;
}

int GenShifts (int Move, CUBE* pFigs)
{	
	int		j, k;
	CUBE	TmpCube;

	for (j = Move; j-- > 0; ) {
		TmpCube = pFigs[j];
		for (k = 2; (k > 0) && (TmpCube = ShiftXUp (TmpCube)); k--)
			pFigs[Move++] = TmpCube;
	}

	for (j = Move; j-- > 0; ){
		TmpCube = pFigs[j];
		for (k = 3; (k > 0) && (TmpCube = ShiftYUp (TmpCube)); k--)
			pFigs[Move++] = TmpCube;
	}

	for (j = Move; j-- > 0; ){
		TmpCube = pFigs[j];
		for (k = 4; (k > 0) && (TmpCube = ShiftZUp (TmpCube)); k--)
			pFigs[Move++] = TmpCube;
	}
	return Move;
}

CUBE RotA180_244 (CUBE Cube)
{
	CUBE_U SrcCube;
	CUBE_U DstCube;

	SrcCube.Q = Cube;
	DstCube.Q = 0;

	DstCube.Bits.b10 = SrcCube.Bits.b00;
	DstCube.Bits.b09 = SrcCube.Bits.b01;
							 
	DstCube.Bits.b07 = SrcCube.Bits.b03;
	DstCube.Bits.b06 = SrcCube.Bits.b04;

	DstCube.Bits.b04 = SrcCube.Bits.b06;
	DstCube.Bits.b03 = SrcCube.Bits.b07;

	DstCube.Bits.b09 = SrcCube.Bits.b09;
	DstCube.Bits.b00 = SrcCube.Bits.b10;

	////////////////////////////////////

	DstCube.Bits.b22 = SrcCube.Bits.b12;
	DstCube.Bits.b21 = SrcCube.Bits.b13;
							 
	DstCube.Bits.b19 = SrcCube.Bits.b15;
	DstCube.Bits.b18 = SrcCube.Bits.b16;

	DstCube.Bits.b16 = SrcCube.Bits.b18;
	DstCube.Bits.b15 = SrcCube.Bits.b19;

	DstCube.Bits.b13 = SrcCube.Bits.b21;
	DstCube.Bits.b12 = SrcCube.Bits.b22;
						 
	////////////////////////////////////

	DstCube.Bits.b34 = SrcCube.Bits.b24;
	DstCube.Bits.b33 = SrcCube.Bits.b25;
							 
	DstCube.Bits.b31 = SrcCube.Bits.b27;
	DstCube.Bits.b39 = SrcCube.Bits.b28;

	DstCube.Bits.b28 = SrcCube.Bits.b30;
	DstCube.Bits.b27 = SrcCube.Bits.b31;

	DstCube.Bits.b25 = SrcCube.Bits.b33;
	DstCube.Bits.b24 = SrcCube.Bits.b34;

	////////////////////////////////////

	DstCube.Bits.b46 = SrcCube.Bits.b36;
	DstCube.Bits.b45 = SrcCube.Bits.b37;

	DstCube.Bits.b43 = SrcCube.Bits.b39;
	DstCube.Bits.b42 = SrcCube.Bits.b40;

	DstCube.Bits.b40 = SrcCube.Bits.b42;
	DstCube.Bits.b39 = SrcCube.Bits.b43;

	DstCube.Bits.b37 = SrcCube.Bits.b45;
	DstCube.Bits.b36 = SrcCube.Bits.b46;

	ShiftDown (DstCube.Q);

	return DstCube.Q;
}

CUBE RotB90_244 (CUBE Cube)
{
	CUBE_U SrcCube;
	CUBE_U DstCube;

	SrcCube.Q = Cube;
	DstCube.Q = 0;

	DstCube.Bits.b36 = SrcCube.Bits.b00;
	DstCube.Bits.b37 = SrcCube.Bits.b01;
						 
	DstCube.Bits.b24 = SrcCube.Bits.b03;
	DstCube.Bits.b25 = SrcCube.Bits.b04;

	DstCube.Bits.b12 = SrcCube.Bits.b06;
	DstCube.Bits.b13 = SrcCube.Bits.b07;

	DstCube.Bits.b00 = SrcCube.Bits.b09;
	DstCube.Bits.b01 = SrcCube.Bits.b10;

	////////////////////////////////////

	DstCube.Bits.b39 = SrcCube.Bits.b12;
	DstCube.Bits.b40 = SrcCube.Bits.b13;
						 
	DstCube.Bits.b27 = SrcCube.Bits.b15;
	DstCube.Bits.b28 = SrcCube.Bits.b16;

	DstCube.Bits.b15 = SrcCube.Bits.b18;
	DstCube.Bits.b16 = SrcCube.Bits.b19;

	DstCube.Bits.b03 = SrcCube.Bits.b21;
	DstCube.Bits.b04 = SrcCube.Bits.b22;
					 
	////////////////////////////////////

	DstCube.Bits.b42 = SrcCube.Bits.b24;
	DstCube.Bits.b43 = SrcCube.Bits.b25;
						 
	DstCube.Bits.b30 = SrcCube.Bits.b27;
	DstCube.Bits.b31 = SrcCube.Bits.b28;

	DstCube.Bits.b18 = SrcCube.Bits.b30;
	DstCube.Bits.b19 = SrcCube.Bits.b31;

	DstCube.Bits.b06 = SrcCube.Bits.b33;
	DstCube.Bits.b07 = SrcCube.Bits.b34;

	////////////////////////////////////

	DstCube.Bits.b45 = SrcCube.Bits.b36;
	DstCube.Bits.b46 = SrcCube.Bits.b37;

	DstCube.Bits.b33 = SrcCube.Bits.b39;
	DstCube.Bits.b34 = SrcCube.Bits.b40;

	DstCube.Bits.b21 = SrcCube.Bits.b42;
	DstCube.Bits.b22 = SrcCube.Bits.b43;

	DstCube.Bits.b09 = SrcCube.Bits.b45;
	DstCube.Bits.b10 = SrcCube.Bits.b46;

	ShiftDown (DstCube.Q);

	return DstCube.Q;
}

CUBE RotC90_244 (CUBE Cube)
{
	CUBE_U SrcCube;
	CUBE_U DstCube;

	SrcCube.Q = Cube;
	DstCube.Q = 0;

	DstCube.Bits.b12 = SrcCube.Bits.b00;
	DstCube.Bits.b00 = SrcCube.Bits.b01;
						 
	DstCube.Bits.b15 = SrcCube.Bits.b03;
	DstCube.Bits.b03 = SrcCube.Bits.b04;

	DstCube.Bits.b18 = SrcCube.Bits.b06;
	DstCube.Bits.b06 = SrcCube.Bits.b07;

	DstCube.Bits.b21 = SrcCube.Bits.b09;
	DstCube.Bits.b09 = SrcCube.Bits.b10;

	////////////////////////////////////

	DstCube.Bits.b13 = SrcCube.Bits.b12;
	DstCube.Bits.b01 = SrcCube.Bits.b13;
						 
	DstCube.Bits.b16 = SrcCube.Bits.b15;
	DstCube.Bits.b04 = SrcCube.Bits.b16;

	DstCube.Bits.b19 = SrcCube.Bits.b18;
	DstCube.Bits.b07 = SrcCube.Bits.b19;

	DstCube.Bits.b22 = SrcCube.Bits.b21;
	DstCube.Bits.b10 = SrcCube.Bits.b22;
					 
	ShiftDown (DstCube.Q);

	return DstCube.Q;
}

CUBE RotA90_333(CUBE Cube)
{
	CUBE_U SrcCube;
	CUBE_U DstCube;

	SrcCube.Q = Cube;
	DstCube.Q = 0;

	DstCube.Bits.b06 = SrcCube.Bits.b00;
	DstCube.Bits.b03 = SrcCube.Bits.b01;
	DstCube.Bits.b00 = SrcCube.Bits.b02;
								 
	DstCube.Bits.b07 = SrcCube.Bits.b03;
	DstCube.Bits.b04 = SrcCube.Bits.b04;
	DstCube.Bits.b01 = SrcCube.Bits.b05;

	DstCube.Bits.b08 = SrcCube.Bits.b06;
	DstCube.Bits.b05 = SrcCube.Bits.b07;
	DstCube.Bits.b02 = SrcCube.Bits.b08;

	////////////////////////////////////
								 
	DstCube.Bits.b18 = SrcCube.Bits.b12;
	DstCube.Bits.b15 = SrcCube.Bits.b13;
	DstCube.Bits.b12 = SrcCube.Bits.b14;
								 
	DstCube.Bits.b19 = SrcCube.Bits.b15;
	DstCube.Bits.b16 = SrcCube.Bits.b16;
	DstCube.Bits.b13 = SrcCube.Bits.b17;

	DstCube.Bits.b20 = SrcCube.Bits.b18;
	DstCube.Bits.b17 = SrcCube.Bits.b19;
	DstCube.Bits.b14 = SrcCube.Bits.b20;

	////////////////////////////////////
							 
	DstCube.Bits.b30 = SrcCube.Bits.b24;
	DstCube.Bits.b27 = SrcCube.Bits.b25;
	DstCube.Bits.b24 = SrcCube.Bits.b26;
								 
	DstCube.Bits.b31 = SrcCube.Bits.b27;
	DstCube.Bits.b28 = SrcCube.Bits.b28;
	DstCube.Bits.b25 = SrcCube.Bits.b29;

	DstCube.Bits.b32 = SrcCube.Bits.b30;
	DstCube.Bits.b29 = SrcCube.Bits.b31;
	DstCube.Bits.b26 = SrcCube.Bits.b32;

	ShiftDown (DstCube.Q);

	return DstCube.Q;
}

CUBE RotB90_333(CUBE Cube)
{
	CUBE_U SrcCube;
	CUBE_U DstCube;

	SrcCube.Q = Cube;
	DstCube.Q = 0;

	DstCube.Bits.b24 = SrcCube.Bits.b00;
	DstCube.Bits.b12 = SrcCube.Bits.b01;
	DstCube.Bits.b00 = SrcCube.Bits.b02;
							 
	DstCube.Bits.b27 = SrcCube.Bits.b03;
	DstCube.Bits.b15 = SrcCube.Bits.b04;
	DstCube.Bits.b03 = SrcCube.Bits.b05;

	DstCube.Bits.b30 = SrcCube.Bits.b06;
	DstCube.Bits.b18 = SrcCube.Bits.b07;
	DstCube.Bits.b06 = SrcCube.Bits.b08;

	////////////////////////////////////
							 
	DstCube.Bits.b25 = SrcCube.Bits.b12;
	DstCube.Bits.b13 = SrcCube.Bits.b13;
	DstCube.Bits.b01 = SrcCube.Bits.b14;
							 
	DstCube.Bits.b28 = SrcCube.Bits.b15;
	DstCube.Bits.b16 = SrcCube.Bits.b16;
	DstCube.Bits.b04 = SrcCube.Bits.b17;

	DstCube.Bits.b31 = SrcCube.Bits.b18;
	DstCube.Bits.b19 = SrcCube.Bits.b19;
	DstCube.Bits.b07 = SrcCube.Bits.b20;

	////////////////////////////////////
						 
	DstCube.Bits.b26 = SrcCube.Bits.b24;
	DstCube.Bits.b14 = SrcCube.Bits.b25;
	DstCube.Bits.b02 = SrcCube.Bits.b26;
							 
	DstCube.Bits.b29 = SrcCube.Bits.b27;
	DstCube.Bits.b17 = SrcCube.Bits.b28;
	DstCube.Bits.b05 = SrcCube.Bits.b29;

	DstCube.Bits.b32 = SrcCube.Bits.b30;
	DstCube.Bits.b20 = SrcCube.Bits.b31;
	DstCube.Bits.b08 = SrcCube.Bits.b32;

	ShiftDown (DstCube.Q);

	return DstCube.Q;
}

CUBE RotC90_333(CUBE Cube)
{
	CUBE_U SrcCube;
	CUBE_U DstCube;

	SrcCube.Q = Cube;
	DstCube.Q = 0;

	DstCube.Bits.b06 = SrcCube.Bits.b00;
	DstCube.Bits.b07 = SrcCube.Bits.b01;
	DstCube.Bits.b08 = SrcCube.Bits.b02;
						 
	DstCube.Bits.b18 = SrcCube.Bits.b03;
	DstCube.Bits.b19 = SrcCube.Bits.b04;
	DstCube.Bits.b20 = SrcCube.Bits.b05;

	DstCube.Bits.b30 = SrcCube.Bits.b06;
	DstCube.Bits.b31 = SrcCube.Bits.b07;
	DstCube.Bits.b32 = SrcCube.Bits.b08;

	////////////////////////////////////
						 
	DstCube.Bits.b03 = SrcCube.Bits.b12;
	DstCube.Bits.b04 = SrcCube.Bits.b13;
	DstCube.Bits.b05 = SrcCube.Bits.b14;
						 
	DstCube.Bits.b15 = SrcCube.Bits.b15;
	DstCube.Bits.b16 = SrcCube.Bits.b16;
	DstCube.Bits.b17 = SrcCube.Bits.b17;

	DstCube.Bits.b27 = SrcCube.Bits.b18;
	DstCube.Bits.b28 = SrcCube.Bits.b19;
	DstCube.Bits.b29 = SrcCube.Bits.b20;

	////////////////////////////////////
					 
	DstCube.Bits.b00 = SrcCube.Bits.b24;
	DstCube.Bits.b01 = SrcCube.Bits.b25;
	DstCube.Bits.b02 = SrcCube.Bits.b26;
						 
	DstCube.Bits.b12 = SrcCube.Bits.b27;
	DstCube.Bits.b13 = SrcCube.Bits.b28;
	DstCube.Bits.b14 = SrcCube.Bits.b29;

	DstCube.Bits.b24 = SrcCube.Bits.b30;
	DstCube.Bits.b25 = SrcCube.Bits.b31;
	DstCube.Bits.b26 = SrcCube.Bits.b32;

	ShiftDown (DstCube.Q);

	return DstCube.Q;
}

bool TestFig (CUBE NewFig, CUBE* pFigs, int LastFig)
{
	while (LastFig-- > 0) {
		if (pFigs[LastFig] == NewFig)
			return false;
	}
	return true;
}

int InitFig442 (CUBE* pFigs)
{
	CUBE	NewFig;
	int		i;
	int		Move;

	Move = 1;

	NewFig = RotC90_244 (pFigs[0]);
	if (TestFig (NewFig, pFigs, Move)) {
		pFigs[Move] = NewFig;
		NewFig = RotC90_244 (pFigs[Move++]);
		if (TestFig (NewFig, pFigs, Move)) {
			pFigs[Move] = NewFig;
			NewFig = RotC90_244 (pFigs[Move++]);
			if (TestFig (NewFig, pFigs, Move))
				pFigs[Move++] = NewFig;
		}
	}

	for (i = Move; i-- > 0;) {
		NewFig = RotB90_244 (pFigs[i]);
		if (TestFig (NewFig, pFigs, Move)) {
			pFigs[Move] = NewFig;
			NewFig = RotB90_244 (pFigs[Move++]);
			if (TestFig (NewFig, pFigs, Move)) {
				pFigs[Move] = NewFig;
				NewFig = RotB90_244 (pFigs[Move++]);
				if (TestFig (NewFig, pFigs, Move))
					pFigs[Move++] = NewFig;
			}
		}
	}

	for (i = Move; i-- > 0;) {
		NewFig = RotA180_244 (pFigs[i]);
		if (TestFig (NewFig, pFigs, Move)) {
			pFigs[Move] = NewFig;
		}
	}
	return GenShifts (Move, pFigs);
}

int InitFig333 (CUBE* pFigs)
{
	CUBE	NewFig;
	int		i;
	int		Move;

	Move = 1;

	NewFig = RotA90_333 (pFigs[0]);
	if (TestFig (NewFig, pFigs, Move)) {
		pFigs[Move] = NewFig;
		NewFig = RotA90_333 (pFigs[Move++]);
		if (TestFig (NewFig, pFigs, Move)) {
			pFigs[Move] = NewFig;
			NewFig = RotA90_333 (pFigs[Move++]);
			if (TestFig (NewFig, pFigs, Move))
				pFigs[Move++] = NewFig;
		}
	}

	for (i = Move; i-- > 0;) {
		NewFig = RotB90_333 (pFigs[i]);
		if (TestFig (NewFig, pFigs, Move)) {
			pFigs[Move] = NewFig;
			NewFig = RotB90_333 (pFigs[Move++]);
			if (TestFig (NewFig, pFigs, Move)) {
				pFigs[Move] = NewFig;
				NewFig = RotB90_333 (pFigs[Move++]);
				if (TestFig (NewFig, pFigs, Move))
					pFigs[Move++] = NewFig;
			}
		}
	}
	for (i = Move; i-- > 0;) {
		NewFig = RotC90_333 (pFigs[i]);
		if (TestFig (NewFig, pFigs, Move)) {
			pFigs[Move] = NewFig;
			NewFig = RotC90_333 (pFigs[Move++]);
			if (TestFig (NewFig, pFigs, Move)) {
				pFigs[Move] = NewFig;
				NewFig = RotC90_333 (pFigs[Move++]);
				if (TestFig (NewFig, pFigs, Move))
					pFigs[Move++] = NewFig;
			}
		}
	}
	return GenShifts (Move, pFigs);
}

CUBE RotA180_345 (CUBE Cube)
{
	CUBE_U SrcCube;
	CUBE_U DstCube;

	SrcCube.Q = Cube;
	DstCube.Q = 0;

	DstCube.Bits.b57 = SrcCube.Bits.b00;
	DstCube.Bits.b58 = SrcCube.Bits.b01;
	DstCube.Bits.b59 = SrcCube.Bits.b02;

	DstCube.Bits.b54 = SrcCube.Bits.b03;
	DstCube.Bits.b55 = SrcCube.Bits.b04;
	DstCube.Bits.b56 = SrcCube.Bits.b05;

	DstCube.Bits.b51 = SrcCube.Bits.b06;
	DstCube.Bits.b52 = SrcCube.Bits.b07;
	DstCube.Bits.b53 = SrcCube.Bits.b08;

	DstCube.Bits.b48 = SrcCube.Bits.b09;
	DstCube.Bits.b49 = SrcCube.Bits.b10;
	DstCube.Bits.b50 = SrcCube.Bits.b11;

	DstCube.Bits.b45 = SrcCube.Bits.b12;
	DstCube.Bits.b46 = SrcCube.Bits.b13;
	DstCube.Bits.b47 = SrcCube.Bits.b14;

	DstCube.Bits.b42 = SrcCube.Bits.b15;
	DstCube.Bits.b43 = SrcCube.Bits.b16;
	DstCube.Bits.b44 = SrcCube.Bits.b17;

	DstCube.Bits.b39 = SrcCube.Bits.b18;
	DstCube.Bits.b40 = SrcCube.Bits.b19;
	DstCube.Bits.b41 = SrcCube.Bits.b20;

	DstCube.Bits.b36 = SrcCube.Bits.b21;
	DstCube.Bits.b37 = SrcCube.Bits.b22;
	DstCube.Bits.b38 = SrcCube.Bits.b23;

	DstCube.Bits.b33 = SrcCube.Bits.b24;
	DstCube.Bits.b34 = SrcCube.Bits.b25;
	DstCube.Bits.b35 = SrcCube.Bits.b26;

	DstCube.Bits.b30 = SrcCube.Bits.b27;
	DstCube.Bits.b31 = SrcCube.Bits.b28;
	DstCube.Bits.b32 = SrcCube.Bits.b29;

	DstCube.Bits.b27 = SrcCube.Bits.b30;
	DstCube.Bits.b28 = SrcCube.Bits.b31;
	DstCube.Bits.b29 = SrcCube.Bits.b32;

	DstCube.Bits.b24 = SrcCube.Bits.b33;
	DstCube.Bits.b25 = SrcCube.Bits.b34;
	DstCube.Bits.b26 = SrcCube.Bits.b35;

	DstCube.Bits.b21 = SrcCube.Bits.b36;
	DstCube.Bits.b22 = SrcCube.Bits.b37;
	DstCube.Bits.b23 = SrcCube.Bits.b38;

	DstCube.Bits.b18 = SrcCube.Bits.b39;
	DstCube.Bits.b19 = SrcCube.Bits.b40;
	DstCube.Bits.b20 = SrcCube.Bits.b41;

	DstCube.Bits.b15 = SrcCube.Bits.b42;
	DstCube.Bits.b16 = SrcCube.Bits.b43;
	DstCube.Bits.b17 = SrcCube.Bits.b44;

	DstCube.Bits.b12 = SrcCube.Bits.b45;
	DstCube.Bits.b13 = SrcCube.Bits.b46;
	DstCube.Bits.b14 = SrcCube.Bits.b47;

	DstCube.Bits.b09 = SrcCube.Bits.b48;
	DstCube.Bits.b10 = SrcCube.Bits.b49;
	DstCube.Bits.b11 = SrcCube.Bits.b50;

	DstCube.Bits.b06 = SrcCube.Bits.b51;
	DstCube.Bits.b07 = SrcCube.Bits.b52;
	DstCube.Bits.b08 = SrcCube.Bits.b53;

	DstCube.Bits.b03 = SrcCube.Bits.b54;
	DstCube.Bits.b04 = SrcCube.Bits.b55;
	DstCube.Bits.b05 = SrcCube.Bits.b56;

	DstCube.Bits.b00 = SrcCube.Bits.b57;
	DstCube.Bits.b01 = SrcCube.Bits.b58;
	DstCube.Bits.b02 = SrcCube.Bits.b59;

	return DstCube.Q;
}

CUBE RotB180_345 (CUBE Cube)
{
	CUBE_U SrcCube;
	CUBE_U DstCube;

	SrcCube.Q = Cube;
	DstCube.Q = 0;

	DstCube.Bits.b11 = SrcCube.Bits.b00;
	DstCube.Bits.b10 = SrcCube.Bits.b01;
	DstCube.Bits.b09 = SrcCube.Bits.b02;
	DstCube.Bits.b08 = SrcCube.Bits.b03;
	DstCube.Bits.b07 = SrcCube.Bits.b04;
	DstCube.Bits.b06 = SrcCube.Bits.b05;
	DstCube.Bits.b05 = SrcCube.Bits.b06;
	DstCube.Bits.b04 = SrcCube.Bits.b07;
	DstCube.Bits.b03 = SrcCube.Bits.b08;
	DstCube.Bits.b02 = SrcCube.Bits.b09;
	DstCube.Bits.b01 = SrcCube.Bits.b10;
	DstCube.Bits.b00 = SrcCube.Bits.b11;

	DstCube.Bits.b23 = SrcCube.Bits.b12;
	DstCube.Bits.b22 = SrcCube.Bits.b13;
	DstCube.Bits.b21 = SrcCube.Bits.b14;
	DstCube.Bits.b20 = SrcCube.Bits.b15;
	DstCube.Bits.b19 = SrcCube.Bits.b16;
	DstCube.Bits.b18 = SrcCube.Bits.b17;
	DstCube.Bits.b17 = SrcCube.Bits.b18;
	DstCube.Bits.b16 = SrcCube.Bits.b19;
	DstCube.Bits.b15 = SrcCube.Bits.b20;
	DstCube.Bits.b14 = SrcCube.Bits.b21;
	DstCube.Bits.b13 = SrcCube.Bits.b22;
	DstCube.Bits.b12 = SrcCube.Bits.b23;
						   
	DstCube.Bits.b35 = SrcCube.Bits.b24;
	DstCube.Bits.b34 = SrcCube.Bits.b25;
	DstCube.Bits.b33 = SrcCube.Bits.b26;
	DstCube.Bits.b32 = SrcCube.Bits.b27;
	DstCube.Bits.b31 = SrcCube.Bits.b28;
	DstCube.Bits.b30 = SrcCube.Bits.b29;
	DstCube.Bits.b29 = SrcCube.Bits.b30;
	DstCube.Bits.b28 = SrcCube.Bits.b31;
	DstCube.Bits.b27 = SrcCube.Bits.b32;
	DstCube.Bits.b26 = SrcCube.Bits.b33;
	DstCube.Bits.b25 = SrcCube.Bits.b34;
	DstCube.Bits.b24 = SrcCube.Bits.b35;

	DstCube.Bits.b47 = SrcCube.Bits.b36;
	DstCube.Bits.b46 = SrcCube.Bits.b37;
	DstCube.Bits.b45 = SrcCube.Bits.b38;
	DstCube.Bits.b44 = SrcCube.Bits.b39;
	DstCube.Bits.b43 = SrcCube.Bits.b40;
	DstCube.Bits.b42 = SrcCube.Bits.b41;
	DstCube.Bits.b41 = SrcCube.Bits.b42;
	DstCube.Bits.b40 = SrcCube.Bits.b43;
	DstCube.Bits.b39 = SrcCube.Bits.b44;
	DstCube.Bits.b38 = SrcCube.Bits.b45;
	DstCube.Bits.b37 = SrcCube.Bits.b46;
	DstCube.Bits.b36 = SrcCube.Bits.b47;
						   
	DstCube.Bits.b59 = SrcCube.Bits.b48;
	DstCube.Bits.b58 = SrcCube.Bits.b49;
	DstCube.Bits.b57 = SrcCube.Bits.b50;
	DstCube.Bits.b56 = SrcCube.Bits.b51;
	DstCube.Bits.b55 = SrcCube.Bits.b52;
	DstCube.Bits.b54 = SrcCube.Bits.b53;
	DstCube.Bits.b53 = SrcCube.Bits.b54;
	DstCube.Bits.b52 = SrcCube.Bits.b55;
	DstCube.Bits.b51 = SrcCube.Bits.b56;
	DstCube.Bits.b50 = SrcCube.Bits.b57;
	DstCube.Bits.b49 = SrcCube.Bits.b58;
	DstCube.Bits.b48 = SrcCube.Bits.b59;

	return DstCube.Q;
}

CUBE RotC180_345 (CUBE Cube)
{
	CUBE_U SrcCube;
	CUBE_U DstCube;

	SrcCube.Q = Cube;
	DstCube.Q = 0;

	DstCube.Bits.b50 = SrcCube.Bits.b00;
	DstCube.Bits.b49 = SrcCube.Bits.b01;
	DstCube.Bits.b48 = SrcCube.Bits.b02;

	DstCube.Bits.b53 = SrcCube.Bits.b03;
	DstCube.Bits.b52 = SrcCube.Bits.b04;
	DstCube.Bits.b51 = SrcCube.Bits.b05;

	DstCube.Bits.b56 = SrcCube.Bits.b06;
	DstCube.Bits.b55 = SrcCube.Bits.b07;
	DstCube.Bits.b54 = SrcCube.Bits.b08;

	DstCube.Bits.b59 = SrcCube.Bits.b09;
	DstCube.Bits.b58 = SrcCube.Bits.b10;
	DstCube.Bits.b57 = SrcCube.Bits.b11;

	DstCube.Bits.b38 = SrcCube.Bits.b12;
	DstCube.Bits.b37 = SrcCube.Bits.b13;
	DstCube.Bits.b36 = SrcCube.Bits.b14;

	DstCube.Bits.b41 = SrcCube.Bits.b15;
	DstCube.Bits.b40 = SrcCube.Bits.b16;
	DstCube.Bits.b39 = SrcCube.Bits.b17;

	DstCube.Bits.b44 = SrcCube.Bits.b18;
	DstCube.Bits.b43 = SrcCube.Bits.b19;
	DstCube.Bits.b42 = SrcCube.Bits.b20;

	DstCube.Bits.b47 = SrcCube.Bits.b21;
	DstCube.Bits.b46 = SrcCube.Bits.b22;
	DstCube.Bits.b45 = SrcCube.Bits.b23;

	DstCube.Bits.b26 = SrcCube.Bits.b24;
	DstCube.Bits.b25 = SrcCube.Bits.b25;
	DstCube.Bits.b24 = SrcCube.Bits.b26;

	DstCube.Bits.b29 = SrcCube.Bits.b27;
	DstCube.Bits.b28 = SrcCube.Bits.b28;
	DstCube.Bits.b27 = SrcCube.Bits.b29;

	DstCube.Bits.b32 = SrcCube.Bits.b30;
	DstCube.Bits.b31 = SrcCube.Bits.b31;
	DstCube.Bits.b30 = SrcCube.Bits.b32;

	DstCube.Bits.b35 = SrcCube.Bits.b33;
	DstCube.Bits.b34 = SrcCube.Bits.b34;
	DstCube.Bits.b33 = SrcCube.Bits.b35;
////
	DstCube.Bits.b14 = SrcCube.Bits.b36;
	DstCube.Bits.b13 = SrcCube.Bits.b37;
	DstCube.Bits.b12 = SrcCube.Bits.b38;

	DstCube.Bits.b17 = SrcCube.Bits.b39;
	DstCube.Bits.b16 = SrcCube.Bits.b40;
	DstCube.Bits.b15 = SrcCube.Bits.b41;

	DstCube.Bits.b20 = SrcCube.Bits.b42;
	DstCube.Bits.b19 = SrcCube.Bits.b43;
	DstCube.Bits.b18 = SrcCube.Bits.b44;

	DstCube.Bits.b23 = SrcCube.Bits.b45;
	DstCube.Bits.b22 = SrcCube.Bits.b46;
	DstCube.Bits.b21 = SrcCube.Bits.b47;
////
	DstCube.Bits.b02 = SrcCube.Bits.b48;
	DstCube.Bits.b01 = SrcCube.Bits.b49;
	DstCube.Bits.b00 = SrcCube.Bits.b50;

	DstCube.Bits.b05 = SrcCube.Bits.b51;
	DstCube.Bits.b04 = SrcCube.Bits.b52;
	DstCube.Bits.b03 = SrcCube.Bits.b53;

	DstCube.Bits.b08 = SrcCube.Bits.b54;
	DstCube.Bits.b07 = SrcCube.Bits.b55;
	DstCube.Bits.b06 = SrcCube.Bits.b56;

	DstCube.Bits.b11 = SrcCube.Bits.b57;
	DstCube.Bits.b10 = SrcCube.Bits.b58;
	DstCube.Bits.b09 = SrcCube.Bits.b59;

	return DstCube.Q;
}

void init ()
{
	int i;
	int Move;
	CUBE	FigPos[MAXFIG][580];
	HCUBE	HighFig[HIGHPOS][MAXFIG][MAXHIGH];

//	memset (LowFig,  0, sizeof HighFig);
	memset (HighFig, 0, sizeof HighFig);

	for (i = 0; i < MAXFIG; i++) {
		FigPos[i][0] = *(CUBE*)&StartPieces[i].Bits;

		switch (StartPieces[i].Type) {
			case PIECE::T222:
			case PIECE::T333:
			case PIECE::T3SL:
				Move = InitFig333 (FigPos[i]);
				break;

			case PIECE::T421:
				Move = InitFig442 (FigPos[i]);
				break;
		}

		if ( StartPieces[i].Type == PIECE::T3SL) {
			for (int j = Move; j-- > 0; ){
				CUBE	TmpCube = FigPos[i][j];
				if (TmpCube) {
					for (int k = j; k-- > 0;)
						if ((TmpCube == RotA180_345(FigPos[i][k])) ||
							(TmpCube == RotB180_345(FigPos[i][k])) ||
							(TmpCube == RotC180_345(FigPos[i][k]))) {					
								if ((TmpCube&-TmpCube) > (FigPos[i][k]&-FigPos[i][k])) {
									FigPos[i][k] = 0;
								}
								else {
									FigPos[i][j] = FigPos[i][--Move];
									break;
								}
							}
				}
				else
					FigPos[i][j] = FigPos[i][--Move];
			}
		}

		FigPos[i][Move] = 0;

		for (int j = Move; j-- > 0; )
			FigPos[i][j] = MapCube(FigPos[i][j]);

		for (j = Move; j-- > 0; ){
			CUBE	Mask;
			CUBE	TmpCube = FigPos[i][j];
			CUBE	NegMask = 0;
			int		k;

			for (k = 0, Mask = 1, NegMask = 0; k < MAXPOS; k++, Mask = Mask << 1) {
				if ((TmpCube & Mask) && !(TmpCube & NegMask)) {
					if (k < LOWPOS) {					
						CUBE	*pMove = LowFig[k][i];
						int l = 1;
						while (*pMove) {
							pMove++;
							l++;
						}
						*pMove = TmpCube;
					}
					else {
						HCUBE	*pMove = HighFig[k-LOWPOS][i];
						int l = 1;
						while (*pMove) {
							pMove++;
							l++;
						}
						*pMove = (HCUBE)(TmpCube >> LOWPOS);
					}
				}
				NegMask |= Mask;
			}
		}
	}

	HCUBE	TestMask;
	POSLIST	*pBuffer;
	pBuffer = PosBuffer;
	pBuffer->HCube  = 0;
	pBuffer++;

	for (int Pos = 0; Pos < HIGHPOS; Pos++) {
		for (ISUSED IsUsed = 1; IsUsed < (1 << MAXFIG); IsUsed++) {
			CfgInfoList[IsUsed].PosInfo[Pos].pPosList = pBuffer;
			TestMask = 0xFFFFFFFF << (Pos+1);
			Move = 0;
			for (i = 0; i < MAXFIG; i++) {
				if (!(IsUsed & (1 << i))) {
					for (int j = 0; HighFig[Pos][i][j]; j++) {
						TestMask &= HighFig[Pos][i][j];
						pBuffer->HCube = HighFig[Pos][i][j];
						pBuffer->IsUsed = IsUsed | (1 << i);
						pBuffer++;
						Move++;
					}
				}
			}
			if (Move > 0) {
				CfgInfoList[IsUsed].PosInfo[Pos].Mask = TestMask;
				pBuffer->HCube = 0;
				pBuffer++;
			}
			else
				CfgInfoList[IsUsed].PosInfo[Pos].pPosList = PosBuffer;	// = NULL
		}
	}	

	for (int j = 0x000F, SeqCounter = 1; j < (1 << (MAXFIG - 1)); j++) {
		int	BitCounter = 0;
		for (int k = 0, Mask = 1; k < (MAXFIG - 1); k++, Mask <<= 1)
			if (j & Mask)
				BitCounter++;
		if (BitCounter == 5)
			CfgInfoList[j].HashIndex = SeqCounter++;
	}
}

inline int GetNextPos (HCUBE HCube, int Pos)
{
	HCUBE	TmpMask = 1 << Pos;
	while (HCube & TmpMask) {
		Pos++; TmpMask <<= 1;
	}
	return Pos;
}

inline SOLVEDHASH *GetSolveHash1 (CUBE Cube)
{
	Cube = LOWCUBE(Cube) * (CUBE)HIGHCUBE(Cube);
	return SolvedHash + (((LOWCUBE(Cube) ^ HIGHCUBE(Cube))) & HASHMASK);
}

inline void SetSolutionCounter (SOLVEDHASH *pSolvedHash, int SolutionCounter)
{
	pSolvedHash->Solved = SolutionCounter;
}

inline SOLVEDHASH *CheckSolutionCounter (ISUSED IsUsed, CUBE Cube)
{
	Cube = ((Cube << 5) ^ CfgInfoList[IsUsed].HashIndex);
	SOLVEDHASH*	pHash = GetSolveHash1 (Cube);;

	if (!pHash->Cube)
		goto ExitNew;

	if (pHash->Cube == Cube)
		goto ExitOld;

	for (int j = 0; j < HASHOVR; j++) {
		pHash++;

		if (!pHash->Cube)
			goto ExitNew;

		if (pHash->Cube == Cube)
			goto ExitOld;

	}
	return &DummyHash;

ExitNew:
	pHash->Cube = Cube;
	return pHash;

ExitOld:
	SolutionCounter += pHash->Solved;
	return NULL;
}

inline void SolveH11 (HCUBE HighCube, int Pos, ISUSED IsUsed)
{
	Pos = GetNextPos (HighCube, Pos);
	if (!(CfgInfoList[IsUsed].PosInfo[Pos].Mask & HighCube)) {
		POSLIST	*pPosList = CfgInfoList[IsUsed].PosInfo[Pos++].pPosList;
		while (pPosList->HCube) {											
			if (!(HighCube & pPosList->HCube)) {
				SolutionCounter++;
				break;
			}
			pPosList++;													
		}																
	}
}

inline void Solve11 (CUBE Cube, int Pos, ISUSED IsUsed)
{
	Pos = GetNextPos (LOWCUBE(Cube), Pos);			
	if (Pos >= LOWPOS) {										
		SolveH11 (LOWCUBE((Cube >> LOWPOS)), Pos - LOWPOS, IsUsed);
	}
}																

/////////////////////////////////////////////////////////////////////
#define	SOLVEHIGH(NR1,NR2)											\
inline void SolveH##NR1 (HCUBE HighCube, int Pos, ISUSED IsUsed){\
	Pos = GetNextPos (HighCube, Pos);								\
	if (!(CfgInfoList[IsUsed].PosInfo[Pos].Mask & HighCube)) {		\
		POSLIST	*pPosList = CfgInfoList[IsUsed].PosInfo[Pos++].pPosList;\
		while (pPosList->HCube) {									\
			if (!(HighCube & pPosList->HCube))						\
				SolveH##NR2 (HighCube | pPosList->HCube, Pos, pPosList->IsUsed);\
			pPosList++;												\
		}															\
	}																\
}																	\
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
#define TryFig(j,Cube,pTmp,Pos,Func)							\
	if (!(IsUsed & (1 << j)))									\
		for (CUBE *pMove = pTmp; *pMove; pMove++) {				\
			if (!(Cube & *pMove))								\
				Func (Cube | *pMove, Pos, IsUsed | (1 << j));	\
		}														\
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
#define	SOLVETEST(NR1,NR2)										\
void __fastcall Solve##NR1 (CUBE Cube, int Pos, ISUSED IsUsed){	\
	Pos = GetNextPos (LOWCUBE(Cube), Pos);						\
	if (Pos >= LOWPOS) {										\
		SolveH##NR1 (LOWCUBE((Cube >> LOWPOS)), Pos - LOWPOS, IsUsed);	\
		return;													\
	}															\
	CUBE (*pTmp)[MAXLOW] = LowFig[Pos++];						\
	TryFig ( 0, Cube, pTmp[ 0], Pos, Solve##NR2);				\
	TryFig ( 1, Cube, pTmp[ 1], Pos, Solve##NR2);				\
	TryFig ( 2, Cube, pTmp[ 2], Pos, Solve##NR2);				\
	TryFig ( 3, Cube, pTmp[ 3], Pos, Solve##NR2);				\
	TryFig ( 4, Cube, pTmp[ 4], Pos, Solve##NR2);				\
	TryFig ( 5, Cube, pTmp[ 5], Pos, Solve##NR2);				\
	TryFig ( 6, Cube, pTmp[ 6], Pos, Solve##NR2);				\
	TryFig ( 7, Cube, pTmp[ 7], Pos, Solve##NR2);				\
	TryFig ( 8, Cube, pTmp[ 8], Pos, Solve##NR2);				\
	TryFig ( 9, Cube, pTmp[ 9], Pos, Solve##NR2);				\
	TryFig (10, Cube, pTmp[10], Pos, Solve##NR2);				\
}																\
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
#define	SOLVEHASH(NR1,NR2)										\
void __fastcall Solve##NR1 (CUBE Cube, int Pos, ISUSED IsUsed) {\
	SOLVEDHASH	*pHash = CheckSolutionCounter (IsUsed, Cube);	\
	if (!pHash)													\
		return;													\
	Pos = GetNextPos (LOWCUBE(Cube), Pos);						\
	CUBE (*pTmp)[MAXLOW] = LowFig[Pos++];						\
	int	LSC = SolutionCounter;									\
	TryFig ( 0, Cube, pTmp[ 0], Pos, Solve##NR2);				\
	TryFig ( 1, Cube, pTmp[ 1], Pos, Solve##NR2);				\
	TryFig ( 2, Cube, pTmp[ 2], Pos, Solve##NR2);				\
	TryFig ( 3, Cube, pTmp[ 3], Pos, Solve##NR2);				\
	TryFig ( 4, Cube, pTmp[ 4], Pos, Solve##NR2);				\
	TryFig ( 5, Cube, pTmp[ 5], Pos, Solve##NR2);				\
	TryFig ( 6, Cube, pTmp[ 6], Pos, Solve##NR2);				\
	TryFig ( 7, Cube, pTmp[ 7], Pos, Solve##NR2);				\
	TryFig ( 8, Cube, pTmp[ 8], Pos, Solve##NR2);				\
	TryFig ( 9, Cube, pTmp[ 9], Pos, Solve##NR2);				\
	TryFig (10, Cube, pTmp[10], Pos, Solve##NR2);				\
	SetSolutionCounter (pHash, SolutionCounter - LSC);			\
}																\
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
#define	SOLVE(NR1,NR2)											\
void __fastcall Solve##NR1 (CUBE Cube, int Pos, ISUSED IsUsed) {	\
	Pos = GetNextPos (LOWCUBE(Cube), Pos);						\
	CUBE (*pTmp)[MAXLOW] = LowFig[Pos++];						\
	TryFig ( 0, Cube, pTmp[ 0], Pos, Solve##NR2);				\
	TryFig ( 1, Cube, pTmp[ 1], Pos, Solve##NR2);				\
	TryFig ( 2, Cube, pTmp[ 2], Pos, Solve##NR2);				\
	TryFig ( 3, Cube, pTmp[ 3], Pos, Solve##NR2);				\
	TryFig ( 4, Cube, pTmp[ 4], Pos, Solve##NR2);				\
	TryFig ( 5, Cube, pTmp[ 5], Pos, Solve##NR2);				\
	TryFig ( 6, Cube, pTmp[ 6], Pos, Solve##NR2);				\
	TryFig ( 7, Cube, pTmp[ 7], Pos, Solve##NR2);				\
	TryFig ( 8, Cube, pTmp[ 8], Pos, Solve##NR2);				\
	TryFig ( 9, Cube, pTmp[ 9], Pos, Solve##NR2);				\
	TryFig (10, Cube, pTmp[10], Pos, Solve##NR2);				\
}																\
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
#define	SOLVE0(NR1,NR2)											\
void __fastcall Solve##NR1(CUBE Cube, int Pos, ISUSED IsUsed) {	\
	Pos = GetNextPos (LOWCUBE(Cube), Pos);						\
	CUBE (*pTmp)[MAXLOW] = LowFig[Pos++];						\
	TryFig ( 0, Cube, pTmp[ 0], Pos, Solve##NR2);				\
	TryFig ( 1, Cube, pTmp[ 1], Pos, Solve##NR2);				\
	TryFig ( 2, Cube, pTmp[ 2], Pos, Solve##NR2);				\
	TryFig ( 3, Cube, pTmp[ 3], Pos, Solve##NR2);				\
	TryFig ( 4, Cube, pTmp[ 4], Pos, Solve##NR2);				\
	TryFig ( 5, Cube, pTmp[ 5], Pos, Solve##NR2);				\
	TryFig ( 6, Cube, pTmp[ 6], Pos, Solve##NR2);				\
	TryFig ( 7, Cube, pTmp[ 7], Pos, Solve##NR2);				\
	TryFig ( 8, Cube, pTmp[ 8], Pos, Solve##NR2);				\
	TryFig ( 9, Cube, pTmp[ 9], Pos, Solve##NR2);				\
}																\
/////////////////////////////////////////////////////////////////

SOLVEHIGH(10,11)
SOLVEHIGH( 9,10)
SOLVEHIGH( 8, 9)
SOLVEHIGH( 7, 8)
SOLVEHIGH( 6, 7)

SOLVETEST(10,11)
SOLVETEST( 9,10)
SOLVETEST( 8, 9)
SOLVETEST( 7, 8)
SOLVETEST( 6, 7)
SOLVEHASH( 5, 6)
SOLVE    ( 4, 5)
SOLVE    ( 3, 4)
SOLVE    ( 2, 3)
SOLVE0   ( 1, 2)
SOLVE0   ( 0, 1)

int _tmain(void)
{
	printf ("-----------------------------------------------------\n");
	printf ("CT-CUBE 2003, Andreas Steininger (asteininger@aon.at) \n");
	printf ("-----------------------------------------------------\n");
	printf ("!!!Laufzeit auf P4 2,53GHz 512MB: ca. 200 Sekunden!!!\n");
	printf ("-----------------------------------------------------\n");

	init ();

	Solve0 (0, 0, 0);

	printf ("Anzahl der Loesungen:%d\n", SolutionCounter);
}

