@ECHO OFF
IF "%1"=="#" GOTO #

:#H#
ECHO.
ECHO -------------------------------------------------------------
ECHO 3x4x5_P.BAT  --  (c)2003, Hannes G. Kuchler
ECHO -------------------------------------------------------------
ECHO.
IF "%1"=="#" GOTO ENDOFBAT
IF "%1"==""  GOTO #XQT#
ECHO -------------------------------------------------------------
ECHO 3x4x5_P.BAT  --  3x4x5 - Parallel Processing
ECHO.
ECHO Aufruf:
ECHO   3x4x5_P.BAT
ECHO.
ECHO Aufgabe:
ECHO   DOS-Batch-Datei zum Parallelisieren der Ermittlung der
ECHO   Anzahl der Loesungen des c't-Puzzles.
ECHO   (Aufruf von 3x4x5.EXE zum parallelen Ermitteln der
ECHO    Teilergebnisse  - jeweils in einem eigenen Prozess -
ECHO    und zum abschliessenden Ermitteln des Endergebnisses)
ECHO.
ECHO Anmerkung:
ECHO   Funktioniert bei vielen Prozessen manchmal eher
ECHO   unerwartet (da findet das Betriebssystem Dateien,
ECHO   die noch gar nicht da sind, ...) ...
ECHO   bei zweien klappt es aber ganz gut
ECHO -------------------------------------------------------------
ECHO.

REM Anmerkungen:
REM   Benoetigte Ein- und Ausgabedateien werden im
REM     TEMP-Verzeichnis angelegt.
REM   Es wird kein Check vorgenommen, ob das Environment
REM     'uebergeht'.

GOTO ENDOFBAT

REM --------------------------------------------------------------
REM Ausfuehren

:#XQT#

REM -- Vorbereiten
CALL %0 # #0#
REM -- Ermitteln der einzelnen Teilergebnisse
FOR %%t IN %#L_TE#% DO CALL %0 # #1# %%t
REM -- Nachbereiten
CALL %0 # #9#

ECHO Info: Die Ermittlung aller Teilergebnisse wurde eingeleitet

REM -- Warten (falls erwuenscht)
IF NOT "%#WAIT#%"=="" PAUSE

GOTO ENDOFBAT

REM --------------------------------------------------------------
REM Vorbereiten (allgemein) fuer die interne Verarbeitung

:#
IF "%2"=="#H#" GOTO %2
IF "%2"=="#9#" GOTO %2

REM -- Umgebungsvariable, die vor dem Programmlauf
REM    zu dessen Steuerung gesetzt werden koennen
REM
REM -- Festlegen, ob die Dateien am Ende der Verarbeitung
REM    ausgegeben werden sollen
REM SET #TYPE#=#
REM
REM -- Festlegen, ob am Ende der Verarbeitung des Hauptteiles
REM    und nach dem Ermitteln der einzelnen Teilergebnisse
REM    auf einen Tastendruck gewartet werden soll
REM SET #WAIT#=#
REM
REM -- Festlegen, ob vollstaendig parallelisiert werden soll
REM    (Diese Option ist jedoch eher gewoehnungsbeduerftig,
REM     denn bei mir zumindest fuehrt sie zu einigermassen
REM     unvorhersehbaren Resultatenals 
REM SET #FULL#=#

REM -- Umgebungsvariable, die vom Programmlauf gesetzt
REM    und nach dessen Abschluss wieder geloescht werden
REM
REM -- Beschreibung der weitern verwendeten Umgebungsvariablen
REM    (diese sind alle an Anfang und Ende mit # markiert)
REM
REM CMD    - Aufruf einer Instanz der Shell zur parallelen
REM          Ausfuehrung diese Batch-Datei
REM PGM    - Programm, das ausgefuehrt werden soll
REM F_BEG  - Beginn des Dateinamens fuer TE (= Teilergebnisse) und
REM          EE (= Endergebnis)
REM F_END  - Ende des Dateinames fuer TE und EE
REM L_TE   - Liste der einzelnen Teilergebnisse
REM F_ZT   - Datei mit den Anfangs- und Endezeiten
REM F_EE   - Endergebnisdatei (Liste der Teilergebnisdateien)
REM F_TE   - Teilergebnisdatei (ermittelte Anzahl der
REM          Teilloesungen)
REM F_T$   - Datei zum Kennzeichnen, dass das Teilergebnis
REM          nun fertig vorliegt.
REM F_E$   - Datei zum Kennzeichnen, dass das Endergebnis
REM          nun ermittelt und ausgegeben wird.
REM F_X$   - Datei zum Kennzeichnen, dass ein exklusiver
REM          Zugriff auf E$ erforderlich ist
REM          
REM Fuer jedes Teilergebnis (genauere Festlegung in #1#):
REM TN_VON - Teilnummer, mit der die Ermittelung des
REM          Teilergebnisses begonnen wird
REM TN_BIS - Teilnummer, bis zu der das Teilergebnis
REM          ermittelt wird

SET #CMD#=START CMD.EXE /C
SET #PGM#=3x4x5.EXE
SET #F_BEG#=%TEMP%\3x4x5
SET #F_END#=DAT
SET #L_TE#=(P1 P2)
SET #F_ZT#=%#F_BEG#%_PZ.%#F_END#%
SET #F_EE#=%#F_BEG#%_PE.%#F_END#%
SET #F_TE#=%#F_BEG#%_%3.%#F_END#%
SET #F_T$#=%#F_BEG#%$%3.%#F_END#%
SET #F_E$#=%#F_BEG#%$PE.%#F_END#%
SET #F_X$#=%#F_BEG#%$PX.%#F_END#%

IF NOT "%#FULL#%"=="" SET #=(01 02 03 04 05 06 07 08 09 10 11 12)
IF NOT "%#FULL#%"=="" SET #L_TE#=%#%
IF NOT "%#FULL#%"=="" SET #=

GOTO %2

REM --------------------------------------------------------------
REM 0.Teil - Vorbereiten fuer das Ermitteln
REM          des Endergebnisses

:#0#

REM -- Anfangszeit nehmen (und Datei loeschen)
ECHO BEG OF COMPUTATION - %0 > %#F_ZT#%
ECHO. | DATE >> %#F_ZT#%
ECHO. | TIME >> %#F_ZT#%

REM -- Loeschen der Endergebnisdatei (falls sie existiert)
IF EXIST %#F_EE#% DEL %#F_EE#%
IF EXIST %#F_E$#% DEL %#F_E$#%
IF EXIST %#F_X$#% DEL %#F_X$#%
REM -- Loeschen der Teilergebnisdateien
FOR %%t IN %#L_TE#% DO CALL %0 # #0#DELT# %%t

GOTO ENDOFBAT

:#0#DELT#
REM -- Loeschen einer einzelnen Teilergebnisdatei
REM    (falls sie existiert) 
IF EXIST %#F_TE#% DEL %#F_TE#%
IF EXIST %#F_T$#% DEL %#F_T$#%
GOTO ENDOFBAT

REM --------------------------------------------------------------
REM 1.Teil - Einleiten der Ermittelung eines einzelnen Teilerg.

:#1#

REM -- Parameter fuer die einzelnen Teilergebnisse
IF "%3"=="P1" SET #TN_VON#=01
IF "%3"=="P1" SET #TN_BIS#=05
IF "%3"=="P2" SET #TN_VON#=06
IF "%3"=="P2" SET #TN_BIS#=12
IF NOT "%#FULL#%"=="" SET #TN_VON#=%3
IF NOT "%#FULL#%"=="" SET #TN_BIS#=%3

SET #=Teilnummern von %#TN_VON#% bis %#TN_BIS#% 
ECHO Einleiten der Ermittlung des Teilergebnisses (%3): %#%
SET #=

REM -- Ausfuehren des 2. Teiles der Batch-Datei - eigener Prozess
%#CMD#% %0 # #2# %3 %#TN_VON#% %#TN_BIS#%

GOTO ENDOFBAT

REM --------------------------------------------------------------
REM 2.Teil - Ermitteln eines einzelnen Teilergebnisses

:#2#

REM -- Ausgabe des Kopfes der Batch-Datei
CALL %0 # #H#

SET #=Teilnummern von %#TN_VON#% bis %#TN_BIS#% 
ECHO Ermitteln des Teilergebnisses (%3): %#%
SET #=

REM -- Ermitteln eines einzelnen Teilergebnisses
%#PGM#% T %4 %5 > %#F_TE#%

REM -- Eintragen des Teilergebnisses in die Datei zur Ermittlung
REM    des Endergebnisses
TYPE %#F_TE#% >> %#F_EE#%

REM -- Kennzeichnen, dass Teilergebnis fertig vorliegt
REM    (In der Theorie alles klar - in der Praxis wird
REM     aber leider manchmal diese Datei erstellt,
REM     ohne dass das vorhergehende TYPE mit dem
REM     Umkopieren des Teilergebnisses fix und ferig ist ...
ECHO %3 > %#F_T$#%

REM -- Ueberpruefen, ob alle Teilergebnisse fertig vorliegen
SET #~#=#~#
FOR %%t IN %#L_TE#% DO CALL %0 # #2#F_T$# %%t
IF     "%#~#%"=="#~#" SET #=bereits
IF NOT "%#~#%"=="#~#" SET #=noch nicht

REM -- Ermitteln des Endergebnisses (falls die Teilerg. vorliegen)
REM    Ausfuehren des 3. Teiles der Batch-Datei - eigener Prozess
IF NOT "%#~#%"=="#~#" %#CMD#% %0 # #3# %3

REM -- Warten (falls erwuenscht)
IF NOT "%#WAIT#%"=="" PAUSE

GOTO ENDOFBAT

:#2#F_T$#
REM -- Ueberpruefen, ob eine einzelnes Teilergebnis vorliegt
IF NOT EXIST %#F_T$#% SET #~#=
GOTO ENDOFBAT

REM --------------------------------------------------------------
REM 3.Teil - Ermitteln des Endergebnisses aus den Teilergebnissen

:#3#

REM -- Ueberpruefen, ob bereits ein anderer Prozess
REM    die Ermittlung des Endergebnisses angestossen hat
REM    (bereits die parallel durchgefuehrte Ueberpruefung,
REM     ob den nun alle Teilergebnisse vorliegen, kann
REM     bei der Parallelverarbeitung dazu fuehren,
REM     dass mehrere Prozesse finden, dass es nun
REM     Reif an der Zeit fuer das Ergebnis ist -
REM     da sie in einem gewissen Sinne 'gleichzeitig'
REM     fertig werden)
IF EXIST %#F_E$#% GOTO ENDOFBAT

ECHO %3 > %#F_E$#%

REM -- Ausgabe des Kopfes der Batch-Datei
CALL %0 # #H#

ECHO Ermitteln des Endergebnisses
REM -- Ermitteln des Endergebnisses (Addieren der Teilergebnisse)
ECHO.
ECHO ------------------------ %3 ---------------------------------
%#PGM#% E < %#F_EE#%
ECHO -------------------------------------------------------------
ECHO.

REM -- Endezeit nehmen
ECHO. | DATE >> %#F_ZT#%
ECHO. | TIME >> %#F_ZT#%
ECHO END OF COMPUTATION - %0 >> %#F_ZT#%
IF NOT "%#TYPE#%"=="" TYPE      %#F_ZT#%

REM -- Ausgabe der weiteren Dateien (falls Ausgabe aktiviert)
IF NOT "%#TYPE#%"=="" CALL %0 # #3#TYPE#

REM -- Und nun warten bis sich jemand ruehrt 
REM    (Bei der Standardvorgabe fuer die DOS-Box klappt diese
REM     im Nu zu und keiner man bekommt das Ergebnis gar nicht
REM     zu Gesicht)
PAUSE
GOTO ENDOFBAT

:#3#TYPE#
ECHO TEST -------- BOF "%#F_EE#%" --------
TYPE %#F_EE#%
ECHO TEST -------- EOF "%#F_EE#%" --------
FOR %%t IN %#L_TE#% DO CALL %0 # #3#TYPT# %%t
GOTO ENDOFBAT

:#3#TYPT#
ECHO TEST -------- BOF "%#F_TE#%" --------
TYPE %#F_TE#%
ECHO TEST -------- EOF "%#F_TE#%" --------
GOTO ENDOFBAT

REM --------------------------------------------------------------
REM 9. und letzter Teil - Nachbereiten (allgemein)

:#9#:

REM -- Loeschen der benutzten Umgebungsvariablen
SET #CMD#=
SET #PGM#=
SET #F_BEG#=
SET #F_END#=
SET #F_ZT#=
SET #F_EE#=
SET #L_TE#=
SET #F_TE#=
SET #F_T$#=
SET #TN_BIS#=
SET #TN_VON#=
SET #=

REM --------------------------------------------------------------

:ENDOFBAT
