//--------------------------------------------------------------//
// 3x4x5.C  --  (c)2003, Hannes G. Kuchler			//
//--------------------------------------------------------------//


/*


------------------------------------------------------------------
Teilnahme am Programmierwettbewerb aus c't 2003, Heft 7, S 230 ff
------------------------------------------------------------------





------------------------------------------------------------------

Die Aufgabe:



Gesucht ist eine schnelle Implementierung zur Ausgabe
der Anzahl der Moeglichkeiten (ohne Symmetrien) mit denen
ein 3 x 4 x 5 Quader mit den folgenden 12 Teilen
gefuellt werden kann:
  +---------------------------------------------+
  ! Tabelle der Teile				!
  +----+---+---+-----------+--------------------+
  ! nr ! id! nk! xxx / xxx ! z			!
  +----+---+---+-----------+--------------------+
  !  1 ! c ! 5 ! 057       ! mit c		!
  !  2 ! s ! 5 ! 326       ! mit ' (Apostroph)	!
  !  3 ! L ! 5 ! 01F       !			!
  !  4 ! 1 ! 5 ! 02F       !			!
  !  5 ! Q ! 5 ! 033 / 001 ! mit ' (Apostroph)	!
  !  6 ! T ! 5 ! 171       !			!
  !  7 ! d ! 5 ! 037       !			!
  !  8 ! w ! 5 ! 136       !			!
  !  9 ! ~ ! 4 ! 023 / 001 ! mit ' (Apostroph)	!
  ! 10 ! f ! 5 ! 172       !			!
  ! 11 ! + ! 5 ! 272       !			!
  ! 12 ! t ! 6 ! 05F       ! mit t		!
  +----+---+---+-----------+--------------------+
  ! Legende zur Tabelle				!
  +----+----------------------------------------+
  ! nr ! Nummer des Teiles -			!
  !    !   die Teile werden entsprechend Abb.	!
  !    !   (auf S 234 oben) von links nach	!
  !    !   rechts durchnummeriert		!
  ! id ! Identifikation des Teiles -		!
  !    !   um sich bei der Ausgabe einer	!
  !    !   Loesung leichter orientieren zu	!
  !    !   koennen, wird fuer jeden der Teile	!
  !    !   eine 'sprechende' einbuchstabige id	!
  !    !   vergeben				!
  ! nk ! Anzahl der vom Teil besetzten Kuben	!
  ! x  ! Position der vom Teil besetzten Kuben	!
  !    !   Hexadezimal-Ziffern,			!
  !    !   jede Ziffer bestimmt eine Spalte,	!
  !    !   jedes in einer Ziffer gesetzte Bit	!
  !    !     bestimmt, dass der Einheitswuerfel	!
  !    !     dieser Reihe (und der durch die	!
  !    !     Position der Ziffer bestimmten	!
  !    !     Spalte) zu	diesem Teil gehoert und	!
  !    !     von ihm besetzt wird.		!
  ! /  ! Ebenentrenner (falls erforderlich)	!
  ! z  ! Bemerkung zur Zusatzaufgabe -		!
  !    !   siehe weiter unten			!
  +----+----------------------------------------+
  ! Skizzen der Teile: siehe weiter unten	!
  +---------------------------------------------+



Zusatzaufgabe:

Entsprechend obiger Tabelle sind einige der Teile
mit Teilen des Schriftzuges c't bemalt -
das c-Teil mit dem c,
das t-Teil mit dem t,
drei weitere Teile tragen auf einer der
  zwei Quadrate grossen rechteckigen Flaechen
  jeweils ein in einer bestimmte Richtung
  ausgerichtetes Apostroph.
In der Zeitschrift auf S 234 ist eine 'Loesung' abgebildet
  (die genaue Anordnung der Teile innerhalb des Quaders
  ist jedoch nicht ersichtlich), wobei die entsprechenden
  Teile so positioniert sind, dass c't auf der 4x5-Deckflaeche
  erscheint, wobei sich (lt. Text) die anderen beiden
  Moeglichkeiten fuer das Apostroph im Inneren des Quaders
  befinden.

fixe Positionen (fuer das c- und t-Teil):
  c-Teil: 75000
  t-Teil: 000F5
moegliche Positionen (fuer die Teile mit dem Apostroph):
  s-Teil: 00C00 / 00400 / 00600
  Q-Teil: 00C00 / 00C40
  ~-Teil: 00C00 / 00880
  (s- und ~-Teil sind symmetrisch, zusammen mit dem
   Apostroph sind sie es jedoch nicht mehr - also falls
   sie zur Loesung gehoeren, dann bitte richtig herum
   einbauen)

------------------------------------------------------------------

Der Preis:



Fuer die schnellste Umsetzung von Ausgabe d. Anzahl d. Loesungen -
Symmetrien nicht mitgerechnet - (sowie fuer die nach Meinung
der c't-Redakteure schoenste graphische Oberflaeche) ist als
Preis dieses Puzzle in real ausgelobt.

------------------------------------------------------------------

Die Bedingungen:



'printf' Anzahl ist zuwenig, es ist darum auch der
  Quelltext einzureichen, damit ueberprueft werden kann,
  dass das Programm tatsaechlich das Puzzle loest -

der Testlauf findet auf einem aktuellen (Hyperthreading -> 3GHz ?)
  Pentium-4-System mit 512 MB.



Teilnahme durch Einsendung der Loesung an
  bo@ct.heise.de   (Harald Boegeholz)
bis
  2003-04-30

------------------------------------------------------------------





==================================================================
		Der Loesungsweg im Ueberblick
==================================================================



------------------------------------------------------------------

Ermitteln der Anzahl der Loesungen

Setze die Anzahl der Loesungen auf Null
Mache die Vorbereitung
Erstelle eine Liste verwendbarer Teile lv mit allen Teilen
Erstelle eine Fuellung lf mit durchwegs unbesetzten Kuben
Ermittle die Loesungen (lv, lf)
Gib die Anzahl der Loesungen aus 

------------------------------------------------------------------

Ermittle die Loesungen (lv, lf)
	(Parameter:
	 lv - Liste, die angibt, ob die einzelnen Teile bereits
	      verwendet worden sind oder aber noch zum Fuellen
	      des Quaders zur Verfuegung stehen
	 lf - Liste, die angibt, ob die einzelnen Kuben des
	      Quaders noch leer, oder aber bereits durch
	      einen der verwendeten Teile gefuellt ist
	 Funktion wird rekursiv verwendet)

Ermittle die erste zu besetzende Kubenposition k in lf
Fuer alle (noch) zur Verfuegung stehenden Teile t
	Erstelle eine neue Liste lv_neu aus lv ohne t
	Fuer alle Positionen p von t mit erstem besetzten Kubus k
	  (somit ist's gut fuer die Geschwindigkeit, wenn diese
	   Positionen nicht dynamisch zu ermitteln sind, sondern
	   bereits vorliegen und ausserdem nach dem ersten
	   gefuellten Kubus indiziert sind)
	  und deren weitere Kuben in lf noch unbesetzt sind
		Erstelle eine neue Fuellung lf_neu aus lf mit p
		Ist lv voll (dh: gibt es also keinen Teil mehr,
		  der in den Quader eingesetzt werden koennte),
		dann
			(liegt eine Loesung vor)
			Erhoehe die Anzahl der Loesungen um Eins
			Liegt eine Spezialloesung (mit passendem
			  c't) vor,
			dann
				Gib diese Spezialloesung aus
		sonst (gibt es noch einen weiteren Teil)
			Ermittle die Loesungen (lv_neu, lf_neu)

------------------------------------------------------------------

Mache die Vorbereitung

Fuer alle Teile t
	Ermittle die Liste der Grundpositionen lgp, die
	  die Anwendung der Rotationsgruppe (24 Eintraege)
	  auf t ergibt
	Erkenne und eliminiere die Symmetrien von t
	  (dh: Sortiere lpg und streiche die doppelten Eintraege)
	Ist t nicht symmetrisch (dh: hat lgp 24 Eintraege),
	dann
		Schraenke lgp derart ein, dass die Symmetrien
		  des Quaders eliminiert werden
	Fuer alle Positionen gp aus lgp
		Fuer alle moeglichen Verschiebungen v von gp
			Ermittle die Position p, die sich
			  aus der Verschiebung von gp um v ergibt
			Trage p in die Liste lp aller Positionen
			  der Teile ein
	Sortiere lp von t nach dem ersten gefuellten Kubus
	Indiziere lp von t nach dem ersten gefuellten Kubus

------------------------------------------------------------------





==================================================================
		Der Loesungsweg im Detail
		  (Implementierung in C)
==================================================================



------------------------------------------------------------------

compiliert mit BCC32.exe
  Borland C++ 5.5 for Win32 Copyright (c) 1993, 2000 Borland

gelinkt mit ILINK32.exe
  Turbo Incremental Link 5.00 Copyright (c) 1997, 2000 Borland

(diese beiden Programme, sowie die Header und Bibliotheksdateien
 sind Teil der frei erhaeltlichen
   FreeCommandLineTools.exe)

Zum Compilieren (Linken) verwendete Optionen:
  -6   : use pentium pro instructions
  -O2  : optimization: generate fastest code
  -OS  : pentium instruction scheduling
  -pr  : use fastcall for passing parms in regs
  -tWC : target is a (windows-)console application
  Zusaetzlich (zur Kontrolle der vom Compiler ausgegebenen
               Assembler-Zwischenergebnisse):
  -S   : create .asm

------------------------------------------------------------------



------------------------------------------------------------------
Einfuehrende Worte zu C und zum Coding



Allgemeines:

C ist eine konzise, leichtverstaendliche Programmiersprache -
  wenn man weiss worum's geht (und dazu gibt's Kommentare) -
  doch die kommentieren in erster Linie was gemacht werden soll
  und eben nicht wie's gemacht wird.
In diesem Programm, wie auch vielen anderen, kommt man ohne
  die Grundlagen C-typischer Pointerverarbeitung leider nicht
  sonderlich weit.
Um die Lesbarkeit fuer Nichteingeweihte jedoch nicht in
  unerreichbare Verstaendnisgefilde abgleiten zu lassen,
  werden die mittels Prae- bzw. Postfix-Operatoren
  durchgefuehrten Manipulationen meist als eigene
  Anweisungen aufgefuehrt (und nicht zuletzt, um moeglichen
  Mehrfachauswertungen beim Aufruf von Makros aus dem Weg
  zu gehen).
Weiters wird darauf geachtet, dass sich das Programm auch
  mit nur geringer Kenntnis der Prioritaetshierarchie der
  einzelnen Operatoren ganz gut nachvollziehen laesst -
  hier wirdeder Herausforderung, sich durch eine ueberdeutliche
  Klammerung zu wuehlen der Vorrang vor derjenigen gegeben,
  die beim Lesen das Blaettern in einer danebenliegenden
  operator-precedence-table erfordert.



Makros und Prozeduren:

Die Schnittstellen funktionsaehnlicher Gebilde (also die von
  Makros und Prozeduren) sind durchwegs so gestaltet, dass
  sich die manipulierten (Ein-/Ausgabe-) Parameter vor den
  (nur Eingabe-) Parametern befinden.



Makros:

Makros dienen
einerseits dazu,
  damit sich Code dort befindet wo er hingehoert (naemlich in
  die Naehe der Daten, die er manipulieren soll), jedoch
  in weiterer Folge das Programm nicht von mannigfachen
  Prozeduraufrufen ueberlastet wird,
andererseits dazu,
  um durch das Setzen von CCC_xxx (Conditional Compile Codes)
  auch ganze Funktionsgruppen einigermassen zentral
  deaktivieren zu koennen, ohne das gesammte Programm mit
  Abfolgen von
    #if defined(CCC_xxx)
          ...
    #endif
  vollzuklattern.
Die Namen der Makros bestehen durchwegs aus Grossbuchstaben
  (und zur Trennung der Namensteile aus Underscores) und
  beginnen mit dem Namen der Struktur, zu deren Manipulation
  sie ersonnen worden sind.
Auch wenn Makros Parameter manipulieren, so erwarten sie immer
  den Parameter und nicht dessen Adresse (vgl. Prozeduren).
Makros, die mit _DEF enden, dienen zum Definieren einer
  entsprechenden Struktur.



Prozeduren:

Die Namen der Prozeduren beinhalten - im Gegensatz zu den
  Makronamen - mindestens einen Kleinbuchstaben;
  und in C hilft es nichts: sollen Parameter mittels Prozedur
  manipuliert werden, so muss deren Adresse an die Prozedur
  uebergeben werden.



Variablentypen:

Diese werden wie folgt festgelegt:
  	typedef
  	struct tag_XXX {
  	}
  	XXX;   //-- Hier steht der lange Name der Struktur



Listen (Arrays):

Strukturen die (fast) ausschliesslich als Eintraege in
  Listen vorgesehen sind bekommen (per typedef) den Namen
	LXX_E;   //-- Liste ... - Eintrag
Danach wird der Speicherplatz fuer die dazugehoerige Liste
  sowie dazugehoerige (globalen) Pointer fuer einzelne
  Eintraege durch
  	#define LXX_ANZ		###
  	LXX_E	aLXX[LXX_ANZ];
  	#define pLXX_0		aLXX
  		// markiert den Anfang der Liste
  	LXX_E*	pLXX_i;
  		// zeigt auf das aktuelle Element in der Liste
  	LXX_E*	pLXX_n;
  		// markiert das Ende der Liste
  	// Wird die Liste erst im Rahmen des Programmlaufes
  	// mit Eintraegen gefuellt, so gibt's auch den
  	// folgenden Pointer
  	LXX_E*  pLXX_m = pLXX_0 + LXX_ANZ;
  		// maximal moegliche Eintraege bis hier
  bereitgestellt.

Durch die Listen fuehrt dann ein dem Zaehlen sehr aehnlicher Weg,
  naemlich:
  	for (pLXX_i = pLXX_0; pLXX_i < pLXX_n; pLXX_i++) {
  		// ...
  	}
  das macht fuer mich dann das Codieren, Testen (deswegen sind
  diese Elemente global definiert), aber dann hoffentlich auch
  das Nachvollziehen fuer andere etwas einfacher.

------------------------------------------------------------------





------------------------------------------------------------------

Die weiteren Details folgen in Kuerze - naemlich jetzt:


*/


//-------- Includes --------
#include <stdio.h>
#include <stdlib.h>
#include <search.h>
#include <string.h>
#include <ctype.h>

//-------- Funktionsprototypen --------
void puzzle_init(int argc, char* argv[]);
void puzzle_solve(void);
void puzzle_exit(void);

//-------- DIE Variable --------
long Anzahl_der_Loesungen;

//----------------------------------------------------------------
// Hier beginnt der ganze Zirkus ...

int main(int argc, char* argv[]) {

Anzahl_der_Loesungen = 0;
puzzle_init(argc, argv);
puzzle_solve();
puzzle_exit();
printf("Anzahl der Loesungen: %ld\n", Anzahl_der_Loesungen);

return 0;

}   //-- main

// ... und hier ist er wenig (?) spaeter auch schon wieder zu Ende
//----------------------------------------------------------------





//----------------------------------------------------------------
// CCC - Conditional Compile Code

#define CCC_WETTBEWERB
//#define CCC_TEST_ALLE_LOESUNGEN
//#define CCC_TEST_MIT_QUADER_SYM
//#define CCC_TEST_BIS_LOESUNG
//#define CCC_VORBEREITUNG



#if defined(CCC_WETTBEWERB)

//#define CCC_TEST_VORAUSSETZUNGEN
//#define CCC_FQK_U64
//#define CCC_MIT_ON_TST_RET
//#define CCC_MIT_QUADER_SYM
//#define CCC_MIT_PRN_LLW
#define CCC_MIT_SOLVE_3x4x5_REK_L
//#define CCC_MIT_STATISTIK
//#define CCC_BIS_ANZ_LOESUNGEN		1000

#endif   //-- CCC_WETTBEWERB



#if defined(CCC_TEST_ALLE_LOESUNGEN)

//#define CCC_TEST_VORAUSSETZUNGEN
//#define CCC_FQK_U64
//#define CCC_MIT_ON_TST_RET
//#define CCC_MIT_QUADER_SYM
#define CCC_MIT_SOLVE_3x4x5_REK_L
//#define CCC_MIT_STATISTIK
#define CCC_MIT_PRN_LLW
//#define CCC_BIS_ANZ_LOESUNGEN		1000

#endif   //-- CCC_TEST_ALLE_LOESUNGEN



#if defined(CCC_TEST_MIT_QUADER_SYM)

//#define CCC_TEST_VORAUSSETZUNGEN
//#define CCC_FQK_U64
#define CCC_MIT_ON_TST_RET
#define CCC_MIT_QUADER_SYM
#define CCC_MIT_SOLVE_3x4x5_REK_L
#define CCC_MIT_STATISTIK
#define CCC_MIT_PRN_LLW
//#define CCC_BIS_ANZ_LOESUNGEN		1000

#endif   //-- CCC_TEST_MIT_QUADER_SYM



#if defined(CCC_TEST_BIS_LOESUNG)

//#define CCC_TEST_VORAUSSETZUNGEN
//#define CCC_FQK_U64
//#define CCC_MIT_ON_TST_RET
//#define CCC_MIT_QUADER_SYM
#define CCC_MIT_SOLVE_3x4x5_REK_L
//#define CCC_MIT_STATISTIK
#define CCC_MIT_PRN_LLW
#define CCC_BIS_ANZ_LOESUNGEN		1000

#endif   //-- CCC_TEST_BIS_LOESUNG



#if defined(CCC_VORBEREITUNG)

//#define CCC_TEST_VORAUSSETZUNGEN
//#define CCC_FQK_U64
#define CCC_MIT_ON_TST_RET
//#define CCC_MIT_QUADER_SYM
//#define CCC_TEST_OUT_LF
#define CCC_MIT_SOLVE_3x4x5_REK_L
//#define CCC_MIT_STATISTIK
//#define CCC_MIT_PRN_LLW
#define CCC_BIS_ANZ_LOESUNGEN		50

#endif   //-- CCC_VORBEREITUNG

//----------------------------------------------------------------
// Behandlung von Fehlern im Programmablauf

//-------- Returncodes --------

#define RET_OK			0
#define RET_ERR			255
#define RET_ERR_TST		127

int ret_code = RET_OK;

//-------- Fehlercodes ---------

#define ERR_NONE		0
#define ERR_TST_MSK		0x80000000

unsigned long err_code = ERR_NONE;

//-------- Makros zum Fehlerhandling --------

//-- Abbrechen, falls Bedingung zutrifft
#define ON_ERR_RET(e_code, e_tst) \
	{ \
	if (e_tst) { \
		err_code = (e_code); \
		ret_code =  RET_ERR; \
		return; \
	} \
	}

//-------- Makros fuer Test --------

#if defined(CCC_MIT_ON_TST_RET)

//-- Abbrechen, falls Bedingung zutrifft
#define ON_TST_RET(e_code, e_tst) \
	{ \
	if (e_tst) { \
		err_code = (e_code); \
		err_code |= ERR_TST_MSK; \
		ret_code =  RET_ERR_TST; \
		return; \
	} \
	}

#else

#define ON_TST_RET(e_code, e_tst)	;

#endif

//----------------------------------------------------------------







//----------------------------------------------------------------
// Beginn - Puzzle initialisieren
//----------------------------------------------------------------



//----------------------------------------------------------------
// Konstante fuer das Puzzle

//-- Anzahl der Kuben in z-Richtung - Hoehe des Quaders
#define Z_ANZ		3

//-- Anzahl der Kuben in y-Richtung - Breite des Quaders
#define Y_ANZ		4
//-- Anzahl der Kuben in x-Richtung - Laenge des Quaders
#define X_ANZ		5
//-- Anzahl der Kuben des Quaders - 3 x 4 x 5
#define K_Q_ANZ		(Z_ANZ * Y_ANZ * X_ANZ)
//-- Maximalanzahl der Kuben je Teil
#define K_T_MAX		6
//-- Anzahl der Teile
#define T_ANZ		12

//----------------------------------------------------------------
// Option - mittels args festgelegt

#define OPT_NONE		'\0'
#define OPT_ALLES		'A'
#define OPT_CT_LOGO		'\''
#define OPT_GUI_CT_LOGO		'G'
#define OPT_SRC_3x4x5_P_BAT	'P'
#define OPT_TEILERGEBNIS	'T'
#define OPT_ENDERGEBNIS		'E'
#define OPT_SRC_3x4x5_C		'#'
#define OPT_USAGE		'u'

char opt = OPT_NONE;
int opt_tn_von = 0;	//-- Teilnummer von (fuer Teilergebnis)
int opt_tn_bis = 0;	//-- Teilnummer bis (fuer Teilergebnis)


//----------------------------------------------------------------
// Der Quelltext

char src_3x4x5_C[] =		//-- the illusion of infinity
#include "3x4x5.C"
;

// Hinter den Kulissen - Aufloesung des obigen Raetsels:
// (??? wusstest Du denn ueberhaupt, dass es eines ist ???)
//
// Der Tragoedie erster Teil:
// Hiesse diese Quelltextdatei - wie man vermuten koennte -
// tatsaechlich 3x4x5.C, so gaeb's jede Menge Aerger,
// denn was kann ein Compiler denn schon anderes tun,
// wenn er gebeten wird, eine Datei miteinzubinden,
// die ihn bittet, dieselbe Datei miteinzubinden,
//   die ihn bittet, dieselbe Datei miteinzubinden,
//     die ihn bittet, dieselbe Datei miteinzubinden,
//       die ihn bittet, dieselbe Datei miteinzubinden,
//         die ihn bittet, ...
// als das Handtuch zu werfen (dies laesst sich mithilfe von
// #defines ein wenig abmildern, aber dann haben wir ja nicht
// alles).
// Somit:
// Diese Datei hier muss anders heissen - eine andere sein.
//
// Der Tragoedie zweiter Teil:
// Kopierte man diese Quelltextdatei einfach um, so ist man den
// Aerger immer noch nicht los (abgesehen, dass sie ja noch immer
// dieses laestige #include enthaelt, was dann dieses laestige
// #include aktiviert, was dann dieses ...) denn dies ergibt
// weiterhin eine Datei mit C-Quelltext, die an dieser Stelle
// nicht so recht hinpasst (abgesehen, vom Aerger des Compilers
// ueber die Redefinitionen von allem, was davor bereits
// definiert worden ist, und allem, was danach noch definiert
// werden wird), denn hier wird ein C-Stringliteral erwartet.
// Somit:
// Diese Datei muss anders sein -
// sie enthaelt zwar all das was hier zu lesen ist (unter
// anderem auch genau "das", sowie all das, was davor bereits
// zu lesen gewesen ist, und auch all das, was danach noch
// zu lesen sein wird) - dies jedoch im (mittels eines kleinen
// Tools erzielten) Format eines C-Stringliterales.
//
// Epilog:
// Will man den Quelltext nutzen, so geht's nicht ohne
// Beruecksichtigung obiger Fakten ...
//
// ... apropos - Nutzung von Quelltext - und Programm:
//
//   -------- Nutzungsbedingungen --------
//   nichtkommerzielle Zwecke:
//     Die Nutzung von Programm und Quelltext wird von mir
//     (dem Verfasser des Programmes) hiermit offiziell
//     ausdruecklich gestattet
//   kommerzielle Zwecke (Veroeffentlichungen, Schulungen, ...):
//     Fuer die Nutzung von Programm und Quelltext bedarf
//     es meines schriftlichen Einverstaendnisses - um dieses
//     zu erlangen, bitte ich Sie, mich zu kontaktieren
//     (Kontaktadresse:  siehe weiter unten) -
//     Ohne dieses ist eine Nutzung unzulaessig und wird
//     von mir hiermit offiziell ausdruecklich verboten
//
// ... da faellt mir auch noch ein:
//
//   -------- Garantie --------
//   gibt's keine - aber eine Zusicherung:
//     das alles ist gedacht, unterhaltsam und lehrreich zu sein,
//     (und darum gibt's auch den Quelltext gleich mit dazu)
//     und es ist nicht gedacht, Ihre Festplatte zu formatieren
//     (denn dazu gibt's andere Programme) oder Ihren
//     Produktionsbetrieb lahmzulegen oder sonst was anzustellen,
//     das Ihnen einen Schaden zufuegt.
//   das alles ist (wie in aehnlichen Faellen auch immer):
//     provided as is, at your own risk, ...
//     ( = genau so zur Verfuegung gestellt wie's ist,
//
// ... und fuer feed-back, Fehlerberichte, Anregungen, Geschenke,
//              Einladungen, good-vibes, ...:
//
//   -------- Kontaktadresse --------
//
//   Hannes G. Kuchler
//   A-8960 Oeblarn 77
//
//----------------------------------------------------------------

//----------------------------------------------------------------
// Quelltext - Batchdatei zur Steuerung der Parallelverarbeitung

char src_3x4x5_P_BAT[] =
#include "3x4x5_P.BAT"
;

// Und wer die obigen Zeilen bereits Intus hat, dem sollte es
// jetzt daemmern: 3x4x5_P.BAT ist nicht die originale Batchdatei
// sondern ... die in ein C-Stringliteral konvertierte !

//----------------------------------------------------------------
// Ausgeben der moeglichen Argumente sowie
// einer kurzen Bedienungsanleitung

void usage(void) {

puts(
"--------------------------------------------------------------\n"
"3x4x5.EXE  --  (c)2003, Hannes G. Kuchler\n"
"--------------------------------------------------------------\n"
"Aufruf:   3x4x5.EXE args\n"
"arg - Funktion\n"
"[A] - Alles - Ermitteln und Ausgeben der Anzahl der Loesungen\n"
"c\'t - Ermitteln und Ausgeben all derjenigen Loesungen (es ist\n"
"      genau eine) mit passendem c\'t-Logo\n"
"G   - \"Graphische Benutzeroberflaeche - !3D!\" - Anleitung\n"
"      zum Aufbau des c\'t-Puzzles mit passendem c\'t-Logo\n"
"P [ > f_o] - Ausgeben der Batchdatei zur Steuerung der\n"
"      Parallelverarbeitung nach stdout (bzw. in die Datei f_o)\n"
"      3x4x5_P.BAT\n"
"T v b [> f_o] - Ermitteln und -Ausgeben eines Teilergebnisses\n"
"      von Teil-Nr. v bis b nach stdout (bzw. in die Datei f_o)\n"
"E [< f_i] [> f_o] - Ermitteln und Ausgeben des Endergebnisses\n"
"      nach stdout (bzw. in die Datei f_o)\n"
"# [ > f_o] - Ausgabe des Quelltextes nach stdout (bzw. in die\n"
"      Datei f_o) - hier gibt\'s dann jede Menge weiterer\n"
"      Details, Kontaktadresse, die Nutzungsbestimmung, ...)\n"
);

}   //-- usage

//----------------------------------------------------------------
// Initialisieren des Puzzles (mittels args)

void test_voraussetzungen(void);
void gui_ct_logo(void);
void puzzle_init_3x4x5(void);

void puzzle_init(int argc, char* argv[]) {

char* s;

#if defined(CCC_TEST_VORAUSSETZUNGEN)
test_voraussetzungen();
#endif

//-- Im Fehlerfalle die Funktion verlassen
if (err_code != 0) return;

opt = OPT_NONE;

//-- Ueberpruefen der args (argc und argv) und
//   setzen der entsprechenden Option

if (opt == OPT_NONE) {
	if (argc < 2) {
		//-- default: Alles
		opt = OPT_ALLES;
	}
}
if (opt == OPT_NONE) {
	s = argv[1];
	if ((strcmp(s, "?" ) == 0) ||
	    (strcmp(s, "-?") == 0) ||
	    (strcmp(s, "/?") == 0)) {
		opt = OPT_USAGE;
	}
}
if (opt == OPT_NONE) {
	if (strcmp(s, "c\'t") == 0) {
		//-- Loesen des c't-Puzzles mit passendem c't-Logo
		opt = OPT_CT_LOGO;
	}
}
if (opt == OPT_NONE) {
	//-- Ein sinnvoller erster Parameter
	//   hat durchwegs die Laenge 1
	ON_ERR_RET(0x1001, (strlen(s) > 2));
	switch(toupper(s[0])) {
	case 'A':
		//-- Alles
		opt = OPT_ALLES;
		ON_ERR_RET(0x1002, argc != 2);
		break;
	case 'G':
		//-- GUI zum Aufbau des c't-Puzzles mit passendem
		//   c't-Logo
		opt = OPT_GUI_CT_LOGO;
		ON_ERR_RET(0x1003, argc != 2);
		break;
	case 'P':
		//-- Parallelverarbeitungsbatchdatei
// Ausgeben der Batchdatei zur Steuerung der Parallel-
// verarbeitung - 3x4x5_P.BAT - vgl. T, vgl E.
		opt = OPT_SRC_3x4x5_P_BAT;
		ON_ERR_RET(0x1004, argc != 2);
		break;
	case 'T':
		//-- Teilergebnis
// Ein Teilergebnis ist die Anzahl derjenigen Teilloesungen,
// bei denen nur Teile mit einer Nummer von v bis b -
// 01<=v<=b<=12 - an der ersten Stelle des Quaders eingesetzt
// werden - vgl. E
		opt = OPT_TEILERGEBNIS;
		ON_ERR_RET(0x1005, argc != 4);
		opt_tn_von = atoi(argv[2]) - 1;
		opt_tn_bis = atoi(argv[3]) - 1;
		ON_ERR_RET(0x1006, (opt_tn_von < 0));
		ON_ERR_RET(0x1007, (opt_tn_von > opt_tn_bis));
		ON_ERR_RET(0x1008, (opt_tn_bis >= T_ANZ));
		break;
	case 'E':
		//-- Endergebnis
// Das Endergebnis ist die Anzahl der Loesungen - sie wird mittels
// Summieren der Teilergebnisse gebildet, diese werden von stdin
// eingelesen - vgl T, vgl. P;
		opt = OPT_ENDERGEBNIS;
		ON_ERR_RET(0x1009, argc != 2);
		break;
	case '#':
		//-- Quelltext
		opt = OPT_SRC_3x4x5_C;
		ON_ERR_RET(0x1010, argc != 2);
		break;
	}
}

if (opt == OPT_NONE) {
	opt = OPT_USAGE;
}

switch(opt) {
case OPT_GUI_CT_LOGO:
	gui_ct_logo();
	exit(0);
case OPT_CT_LOGO:
case OPT_ALLES:
case OPT_TEILERGEBNIS:
	puzzle_init_3x4x5();
	break;
case OPT_ENDERGEBNIS:
	break;
case OPT_SRC_3x4x5_C:
	puts(src_3x4x5_C);
	exit(0);
case OPT_SRC_3x4x5_P_BAT:
	puts(src_3x4x5_P_BAT);
	exit(0);
case OPT_USAGE:
	usage();
	exit(0);
	break;
}

}   //-- puzzle_init

//----------------------------------------------------------------
// Typdefinitionen fuer die Unabhaengingkeit (evtl. anpassen)

typedef unsigned char		U08, BYTE;
typedef          char		S08;
typedef unsigned short		U16;
typedef          short		S16;
typedef	unsigned long		U32;
typedef          long		S32;
typedef unsigned __int64	U64;

void test_voraussetzungen(void) {

int q_ok = 1;
int ok;
char s1[] = "ok";
char s2[] = "NOT ok";

printf("test> test_voraussetzungen - BEG\n");
q_ok &=(ok = (sizeof(U08) == 1));
printf("test> sizeof(U08)=%d - %s\n",
	      sizeof(U08),
	      ok ? s1 : s2);
q_ok &=(ok = (sizeof(S08) == 1));
printf("test> sizeof(S08)=%d - %s\n",
	      sizeof(S08),
	      ok ? s1 : s2);
q_ok &=(ok = (sizeof(U16) == 2));
printf("test> sizeof(U16)=%d - %s\n",
	      sizeof(U16),
	      ok ? s1 : s2);
q_ok &=(ok = (sizeof(S16) == 2));
printf("test> sizeof(S16)=%d - %s\n",
	      sizeof(S16),
	      ok ? s1 : s2);
q_ok &=(ok = (sizeof(U32) == 4));
printf("test> sizeof(U32)=%d - %s\n",
	      sizeof(U32),
	      ok ? s1 : s2);
q_ok &=(ok = (sizeof(S32) == 4));
printf("test> sizeof(S32)=%d - %s\n",
	      sizeof(S32),
	      ok ? s1 : s2);
q_ok &=(ok = (sizeof(U64) == 8));
printf("test> sizeof(U64)=%d - %s\n",
	      sizeof(U64),
	      ok ? s1 : s2);

printf("test> test_voraussetzungen - END\n");

ON_ERR_RET(0x1101, (!q_ok));

}   //-- test_voraussetzungen

//----------------------------------------------------------------
// Coordinaten

typedef S08
C1D;	//-- Coordinaten 1D

typedef
union tag_C3D {
	C1D a[3];		//-- Als Coordinaten - Array
	struct {		//-- Als einzelne Coordinaten
		C1D x;
		C1D y;
		C1D z;
	};
}
C3D;   //-- Struktur fuer Coordinate 3D

//-- Definieren einer Coordinate 3D
#define C3D_DEF(i_x, i_y, i_z) \
	{ (i_x), (i_y), (i_z) }

//-------- Makros fuer C3D --------

//-- Addieren des zweiten Vektors zum ersten
#define C3D_ADD(v1, v2) \
	{ \
	(v1).x += (v2).x; \
	(v1).y += (v2).y; \
	(v1).z += (v2).z; \
	}

//-- Subtrahieren des zweiten Vektors vom ersten
#define C3D_SUB(v1, v2) \
	{ \
	(v1).x -= (v2).x; \
	(v1).y -= (v2).y; \
	(v1).z -= (v2).z; \
	}

//-- Initialisieren der Grenzen
#define C3D_INI_MIN_MAX(ptmin, ptmax) \
	{ \
	(ptmin).x = (ptmin).y = (ptmin).z =  63; \
	(ptmax).x = (ptmax).y = (ptmax).z = -63; \
	}

//-- Aktualisieren der Grenzen (fuer eine Coordinate)
#define C1D_UPD_MIN_MAX(c, ptmin, ptmax, pt) \
	{ \
	if ((pt).c < (ptmin).c) { (ptmin).c = (pt).c; } \
	if ((pt).c > (ptmax).c) { (ptmax).c = (pt).c; } \
	}

//-- Aktualisieren der Grenzen
#define C3D_UPD_MIN_MAX(ptmin, ptmax, pt) \
	{ \
	C1D_UPD_MIN_MAX(x, ptmin, ptmax, pt); \
	C1D_UPD_MIN_MAX(y, ptmin, ptmax, pt); \
	C1D_UPD_MIN_MAX(z, ptmin, ptmax, pt); \
	}

//-- Ueberpruefen, ob Punkt innerhalb des Quaders liegt
#define C3D_TEST_IN_Q(pt) \
	( \
	((pt).x >= 0) && ((pt).x < X_ANZ) && \
	((pt).y >= 0) && ((pt).y < Y_ANZ) && \
	((pt).z >= 0) && ((pt).z < Z_ANZ) \
	)

//----------------------------------------------------------------
// Quader, Teil, Kubus

typedef
struct tag_QTK {
	union {
		struct {		//-- Eintrag fuer Quader
			U08 nt;		// Anzahl der Teile
		};
		struct {		//-- Eintrag fuer Teil
			U08 nr;		// Nummer
			U08 id;		// id
			U08 nk;		// Anzahl der Kuben
		};
		struct {		//-- Eintrag fuer Kubus
			C3D c;		// Coordinate
		};
	};
	U08 typ;
}
QTK;	//-- Struktur fuer Quader bzw. Teil bzw. Kubus

//-- Konstante fuer QTK.typ
#define QTK_TYP_Q	0x80
#define QTK_TYP_T	0x81
#define QTK_TYP_K	0x82

//-------- Makros fuer QTK --------

//-- Definieren des Quaders
#define QTK_DEF_Q(i_nt) \
	{ (i_nt), 0, 0, QTK_TYP_Q }

//-- Definieren eines Teiles (innerhalb des Quaders)
#define QTK_DEF_T(i_nr, i_id, i_nk) \
	{ ((i_nr) - 1), (i_id), (i_nk), QTK_TYP_T }

//-- Definieren eines Kubus (innerhalb dieses Teiles)
#define QTK_DEF_K(i_x, i_y, i_z) \
	{ (i_x), (i_y), (i_z), QTK_TYP_K }

//----------------------------------------------------------------
// Das Puzzle - Definieren von Quader, Teile, Kuben

#define  QTK_ANZ	(1 + T_ANZ + K_Q_ANZ)
QTK aQTK[QTK_ANZ] = {
	
	// Erwartete Abfolge der Eintraege in aQTK:
	//
	//	1. Eintrag:
	//		QTK_DEF_Q(nt)
	//	Folgende Eintraege (nt-mal):
	//		QTK_DEF_T(nr, id, nk)
	//		Folgende Eintraege (nk-mal):
	//			QTK_DEK_K(x, y, z)


//----------------------------------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	::::::::::::::::::::::::::::::::::::::::::::::::::::
//	::::::::::::::::::::::::::::::::::::::::::::::::::::
//	:::::::::::::+-----+-----+-----+-----+-----+::::::::
//	::::::::::::/     /     /     /     /     /!::::::::
//	:::::::::::+-----+-----+-----+-----+-----+ !::::::::
//	::::::::::/     /     /     /     /     /! !::::::::
//	:::::::::+-----+-----+-----+-----+-----+ ! +::::::::
//	::::::::/     /     /     /     /     /! !/!::::::::
//	:::::::+-----+-----+-----+-----+-----+ ! + !::::::::
//	:::::::!     !     !     !     !     ! !/! !::::::::
//	:::::::!     !     !     !     !     ! + ! !::::::::
//	:::::::!     !     !     !     !     !/! !/!::::::::
//	:::::::+-----+-----+-----+-----+-----+ ! + !::::::::
//	:::::::!     !     !     !     !     ! !/! !::::::::
//	:::::::!     !     !     !     !     ! + ! !::::::::
//	:::::::!     !     !     !     !     !/! !/!::::::::
//	:::::::+-----+-----+-----+-----+-----+ ! + !::::::::
//	:::::::!     !     !     !     !     ! !/! !::::::::
//	:::::::!     !     !     !     !     ! + ! +::::::::
//	:::::::!     !     !     !     !     !/! !/.::::::::
//	:::::::+-----+-----+-----+-----+-----+ ! +.:::::::::
//	:::::::!     !     !     !     !     ! !/.::::::::::
//	:::::::!     !     !     !     !     ! +.:::::::::::
//	:::::::!     !     !     !     !     !/.::::::::::::
//	:::::::+-----+-----+-----+-----+-----+.:::::::::::::
//	::::::::::::::::::::::::::::::::::::::::::::::::::::
//	::::::::::::::::::::::::::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_Q(T_ANZ),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=01, id='c', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	:::::::::+-----------+:::::::
//	::::::::/           /!:::::::
//	:::::::+-----------+ !:::::::
//	:::::::!    #######! !:::::::
//	:::::::!  #########! +:::::::
//	:::::::! ##########!/.:::::::
//	:::::::!#####+-----+.::::::::
//	:::::::!#### ! !:::::::::::::
//	:::::::!#### ! +-----+:::::::
//	:::::::!#### !/     /!:::::::
//	:::::::!#####+-----+ !:::::::
//	:::::::!###########! !:::::::
//	:::::::! ##########! +:::::::
//	:::::::!   ########!/.:::::::
//	:::::::+-----------+.::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	 1, 'c', 5),
QTK_DEF_K(0,0,0),
QTK_DEF_K(1,0,0),
QTK_DEF_K(0,1,0),
QTK_DEF_K(0,2,0),
QTK_DEF_K(1,2,0),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=02, id='s', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	::::::::::::+-----------+::::
//	:::::::::::/xxxxx######/!::::
//	::::::::::+-----------+ !::::
//	::::::::::!           ! !::::
//	::::::::::!           ! +::::
//	::::::::::!           !/.::::
//	::::::::::!     +-----+.:::::
//	::::::::::!     ! !::::::::::
//	::::::+---!     ! !::::::::::
//	:::::/    !     ! !::::::::::
//	::::+-----+     ! !::::::::::
//	::::!           ! !::::::::::
//	::::!           ! +::::::::::
//	::::!           !/.::::::::::
//	::::+-----------+.:::::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	 2, 's', 5),
QTK_DEF_K(1,0,0),
QTK_DEF_K(2,0,0),
QTK_DEF_K(1,1,0),
QTK_DEF_K(0,2,0),
QTK_DEF_K(1,2,0),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=03, id='L', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	:::::::::+-----+:::::::::::::
//	::::::::/     /!:::::::::::::
//	:::::::+-----+ !:::::::::::::
//	:::::::!     ! !:::::::::::::
//	:::::::!     ! !:::::::::::::
//	:::::::!     ! !:::::::::::::
//	:::::::!     ! !:::::::::::::
//	:::::::!     ! !:::::::::::::
//	:::::::!     ! !:::::::::::::
//	:::::::!     ! !:::::::::::::
//	:::::::!     ! !:::::::::::::
//	:::::::!     ! !:::::::::::::
//	:::::::!     ! +-----+:::::::
//	:::::::!     !/     /!:::::::
//	:::::::!     +-----+ !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! +:::::::
//	:::::::!           !/.:::::::
//	:::::::+-----------+.::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	 3, 'L', 5),
QTK_DEF_K(0,0,0),
QTK_DEF_K(1,0,0),
QTK_DEF_K(0,1,0),
QTK_DEF_K(0,2,0),
QTK_DEF_K(0,3,0),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=04, id='1', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	:::::::::::::::+-----+:::::::
//	::::::::::::::/     /!:::::::
//	:::::::::::::+-----+ !:::::::
//	:::::::::::::!     ! !:::::::
//	:::::::::+---!     ! !:::::::
//	::::::::/    !     ! !:::::::
//	:::::::+-----+     ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::+-----+     ! !:::::::
//	:::::::::::::!     ! !:::::::
//	:::::::::::::!     ! !:::::::
//	:::::::::::::!     ! !:::::::
//	:::::::::::::!     ! !:::::::
//	:::::::::::::!     ! !:::::::
//	:::::::::::::!     ! +:::::::
//	:::::::::::::!     !/.:::::::
//	:::::::::::::+-----+.::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	 4, '1', 5),
QTK_DEF_K(0,0,0),
QTK_DEF_K(0,1,0),
QTK_DEF_K(1,1,0),
QTK_DEF_K(0,2,0),
QTK_DEF_K(0,3,0),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=05, id='Q', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	:::::::::+-----------+:::::::
//	::::::::/xxxxx######/!:::::::
//	:::::::+-----------+ !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::+-----+     ! !:::::::
//	::::::/     /!     ! !:::::::
//	:::::+-----+ !     ! +:::::::
//	:::::!     ! !     !/.:::::::
//	:::::!     ! +-----+.::::::::
//	:::::!     !/.:::::::::::::::
//	:::::+-----+.::::::::::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	 5, 'Q', 5),
QTK_DEF_K(0,0,0),
QTK_DEF_K(0,1,0),
QTK_DEF_K(1,0,0),
QTK_DEF_K(1,1,0),
QTK_DEF_K(0,0,1),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=06, id='T', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	::::::+-----------------+::::
//	:::::/                 /!::::
//	::::+-----------------+ !::::
//	::::!                 ! !::::
//	::::!                 ! +::::
//	::::!                 !/.::::
//	::::+-----+     +-----+.:::::
//	::::::::::!     ! !::::::::::
//	::::::::::!     ! !::::::::::
//	::::::::::!     ! !::::::::::
//	::::::::::!     ! !::::::::::
//	::::::::::!     ! !::::::::::
//	::::::::::!     ! +::::::::::
//	::::::::::!     !/.::::::::::
//	::::::::::+-----+.:::::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	 6, 'T', 5),
QTK_DEF_K(0,0,0),
QTK_DEF_K(1,0,0),
QTK_DEF_K(2,0,0),
QTK_DEF_K(1,1,0),
QTK_DEF_K(1,2,0),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=07, id='d', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	:::::::::::::::+-----+:::::::
//	::::::::::::::/     /!:::::::
//	:::::::::::::+-----+ !:::::::
//	:::::::::::::!     ! !:::::::
//	:::::::::+---!     ! !:::::::
//	::::::::/    !     ! !:::::::
//	:::::::+-----+     ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! +:::::::
//	:::::::!           !/.:::::::
//	:::::::+-----------+.::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	 7, 'd', 5),
QTK_DEF_K(0,0,0),
QTK_DEF_K(1,0,0),
QTK_DEF_K(0,1,0),
QTK_DEF_K(1,1,0),
QTK_DEF_K(0,2,0),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=08, id='w', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	::::::+-----+::::::::::::::::
//	:::::/     /!::::::::::::::::
//	::::+-----+ !::::::::::::::::
//	::::!     ! !::::::::::::::::
//	::::!     ! +-----+::::::::::
//	::::!     !/     /!::::::::::
//	::::!     +-----+ !::::::::::
//	::::!           ! !::::::::::
//	::::!           ! +-----+::::
//	::::!           !/     /!::::
//	::::+-----+     +-----+ !::::
//	::::::::::!           ! !::::
//	::::::::::!           ! +::::
//	::::::::::!           !/.::::
//	::::::::::+-----------+.:::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	 8, 'w', 5),
QTK_DEF_K(1,0,0),
QTK_DEF_K(2,0,0),
QTK_DEF_K(0,1,0),
QTK_DEF_K(1,1,0),
QTK_DEF_K(0,2,0),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=09, id='~', nk=4  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	:::::::::+-----------+:::::::
//	::::::::/xxxxx######/!:::::::
//	:::::::+-----------+ !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::!           ! !:::::::
//	:::::::+-----+-----+ !:::::::
//	::::::::::::/     /  !:::::::
//	:::::::::::+-----+   +:::::::
//	:::::::::::!     !  /.:::::::
//	:::::::::::!     ! /.::::::::
//	:::::::::::!     !/.:::::::::
//	:::::::::::+-----+.::::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	 9, '~', 4),
QTK_DEF_K(0,0,0),
QTK_DEF_K(1,0,0),
QTK_DEF_K(1,1,0),
QTK_DEF_K(0,0,1),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=10, id='f', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	::::::::::::+-----------+::::
//	:::::::::::/           /!::::
//	::::::::::+-----------+ !::::
//	::::::::::!           ! !::::
//	::::::+---!           ! +::::
//	:::::/    !           !/.::::
//	::::+-----+     +-----+.:::::
//	::::!           ! !::::::::::
//	::::!           ! !::::::::::
//	::::!           ! !::::::::::
//	::::+-----+     ! !::::::::::
//	::::::::::!     ! !::::::::::
//	::::::::::!     ! +::::::::::
//	::::::::::!     !/.::::::::::
//	::::::::::+-----+.:::::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	10, 'f', 5),
QTK_DEF_K(1,0,0),
QTK_DEF_K(2,0,0),
QTK_DEF_K(0,1,0),
QTK_DEF_K(1,1,0),
QTK_DEF_K(1,2,0),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=11, id='+', nk=5  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	::::::::::::+-----+::::::::::
//	:::::::::::/     /!::::::::::
//	::::::::::+-----+ !::::::::::
//	::::::::::!     ! !::::::::::
//	::::::+---!     ! +-----+::::
//	:::::/    !     !/     /!::::
//	::::+-----+     +-----+ !::::
//	::::!                 ! !::::
//	::::!                 ! +::::
//	::::!                 !/.::::
//	::::+-----+     +-----+.:::::
//	::::::::::!     ! !::::::::::
//	::::::::::!     ! +::::::::::
//	::::::::::!     !/.::::::::::
//	::::::::::+-----+.:::::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	11, '+', 5),
QTK_DEF_K(1,0,0),
QTK_DEF_K(0,1,0),
QTK_DEF_K(1,1,0),
QTK_DEF_K(2,1,0),
QTK_DEF_K(1,2,0),

//-----------------------------------
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	XXX  nr=12, id='t', nk=6  XXX
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	:::::::::::::::::::::::::::::
//	:::::::::+-----+:::::::::::::
//	::::::::/     /!:::::::::::::
//	:::::::+-----+ !:::::::::::::
//	:::::::!#### ! !:::::::::::::
//	:::::::!#### ! +-----+:::::::
//	:::::::!#### !/     /!:::::::
//	:::::::!#### +-----+ !:::::::
//	:::::::!###########! !:::::::
//	:::::::!###########! +:::::::
//	:::::::!###########!/.:::::::
//	:::::::!#### +-----+.::::::::
//	:::::::!#### ! !:::::::::::::
//	:::::::!#### ! +-----+:::::::
//	:::::::!#### !/     /!:::::::
//	:::::::!#####+-----+ !:::::::
//	:::::::!###########! !:::::::
//	:::::::! ##########! +:::::::
//	:::::::!   ########!/.:::::::
//	:::::::+-----------+.::::::::
//	:::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXX
QTK_DEF_T(	12, 't', 6),
QTK_DEF_K(0,0,0),
QTK_DEF_K(1,0,0),
QTK_DEF_K(0,1,0),
QTK_DEF_K(0,2,0),
QTK_DEF_K(1,2,0),
QTK_DEF_K(0,3,0)

};   //-- aQTK - Das Puzzle - Quader, Teile, Kuben

#define pQTK_0		aQTK
QTK*	pQTK_i;
QTK*	pQTK_n;
QTK*	pQTK_m =	aQTK + QTK_ANZ;

//-- Liste der Teile - Kopie aus QTK
QTK	aT[T_ANZ];
#define pT_0		aT
QTK*	pT_i;
QTK*	pT_n;
QTK*	pT_m =		aT + T_ANZ;

//-- Liste der Kuben (des aktuellen Teiles) - Kopie aus QTK
QTK	aK[K_T_MAX];
#define pK_0		aK
QTK*	pK_i;
QTK*	pK_n;
QTK*	pK_m =		aK + K_T_MAX;

//-- Liste der rotierten Kuben (des aktuellen Teiles)
QTK	aKr[K_T_MAX];
#define pKr_0		aKr
QTK*	pKr_i;
QTK*	pKr_n;
QTK*	pKr_m =		aKr + K_T_MAX;

//----------------------------------------------------------------
// Fuellung des Quaders mit Kuben
//
// Bit-Array, um moeglichst speicherschonend und einigermassen
// schnell entscheiden zu koennen, ob ein Teil an einer bestimmten
// Position noch in den Quader eingesetzt werden kann

#define BNR_MAX		K_Q_ANZ

#if   (BNR_MAX > 64)
#error BNR_MAX > 64 ... anpassen: FQK
#endif

typedef
struct tag_FQK {
	//-- auch U32 a[(BNR_MAX / 32) + 1];
	U32 l;
	U32 h;
}
FQK;   //-- Struktur fuer die Fuellung des Quaders mit Kuben

//-- Definieren einer Fuellung des Quaders mit Kuben
#define FQK_DEF(i_l, i_h) \
	{ (i_l), (i_h) }

//-------- Makros fuer FQK (bis zu 64 Bit) --------

#define BNR_MAX_H	(BNR_MAX - 32)

#define FQK_ALL_L	(0xFFFFFFFF)
#define FQK_ALL_H	(0xFFFFFFFF >> (32 - BNR_MAX_H))
#define FQK_NONE_L	0
#define FQK_NONE_H	0

#define FQK_ALL		FQK_DEF(FQK_ALL_L, FQK_ALL_H)
#define FQK_NONE	FQK_DEF(0, 0)

//-- Umrechnen von 3D-Koordinaten in eine Bit-Nummer einer FQK
#define FQK_C3D_TO_BNR(pt) \
	((BNR_MAX - 1) - \
	 (((pt).y) + \
	  (Y_ANZ * (((pt).x) + \
	            X_ANZ * ((pt).z)))))
	//------------------------------------------------------//
	// Zur besseren Lesbarkeit (in Hex-Darstellung)		//
	// der gefuellten Felder in der Fuellstruktur des	//
	//   3 x 4 x 5 - Quaders				//
	// wird seine Belegung intern als			//
	//   4 x 5 x 3 - Quader					//
	// dargestellt (erst y, dann x, dann z) -		//
	// jede Belegung einer y-Spalte passt somit genau	//
	// in einen Nibble (ein Halbes Byte).			//
	//							//
	// Ausserdem wird (in Vorbereitung des weiteren		//
	// Vorgehens - Sortierung und Indizierung)		//
	// die Reihenfolge der Besetzung umgedreht -		//
	// das Kennzeichen fuer den ersten besetzte Kubus	//
	// befindet sich somit an der meist signifikanten	//
	// Bit-Position.					//
	//------------------------------------------------------//

//----------------------------------------------------------------

#if !defined(CCC_FQK_U64)

//-- Vergleichen (bestimmen der Ordnung) der beiden FQKs
#define FQK_CMP(f1, f2) \
	(((f1).h > (f2).h) \
	  ? -1 \
	  : (((f1).h < (f2).h) \
	    ? 1 \
	    : (((f1).l > (f2).l) \
	      ? -1 \
	      : (((f1).l < (f2).l) \
	        ? 1 \
	        : 0 ))))

//-- Ueberpruefen der Gleichheit der beiden FQKs
#define FQK_EQU(f1, f2) \
	(((f1).h == (f2).h) && \
	 ((f1).l == (f2).l))

//-- Loeschen aller Felder der FQK
#define FQK_CLR_ALL(f) \
	{ \
	(f).h = 0; \
	(f).l = 0; \
	}

//-- Fuellen aller Felder der FQK
#define FQK_SET_ALL(f) \
	{ \
	(f).h = FQK_ALL_L; \
	(f).l = FQK_ALL_H; \
	}

//-- Ermitteln eines Feldes der FQK entspr. Bit-Nummer
#define FQK_GET_BNR(f, i) \
	(((i) < 32) ? ((f).l & (((U32)1) <<  (i)     )) \
	            : ((f).h & (((U32)1) << ((i) - 32))))

//-- Fuellen eines Feldes in der FQK entspr. Bit-Nummer
#define FQK_SET_BNR(f, i) \
	{ \
	if ((i) < 32) { \
		(f).l |= (((U32)1) <<  (i)      ); \
	} \
	else { \
		(f).h |= (((U32)1) << ((i) - 32)); \
	} \
        }

//-- Loeschen eines Feldes aus der FQK entspr. Bit-Nummer
#define FQK_CLR_BNR(f, i) \
	{ \
	if ((i) < 32) { \
		(f).l &= ~(((U32)1) <<  (i)      ); \
	} \
	else { \
		(f).h &= ~(((U32)1) << ((i) - 32)); \
	} \
	}

//-- Ueberpruefen der beiden FQKs auf Disjunktheit
#define FQK_FILL_OK(f1, f2) \
	((((f1).h & (f2).h) == 0) && \
	 (((f1).l & (f2).l) == 0))

//-- Fuellen der ersten FQK mit der zweiten
#define FQK_FILL_IT(f1, f2) \
	{ \
	(f1).h |= (f2).h; \
	(f1).l |= (f2).l; \
	}

//-- Verschieben
#define FQK_TRN_C3D(f, v) \
	{ \
	int brsh = (BNR_MAX - 1) - FQK_C3D_TO_BNR(v) ; \
	if (brsh == 0) { \
	} \
	else { \
		if (brsh < BNR_MAX_H) { \
			U32 h2l = ((f).h << (32 - brsh)); \
			(f).h >>= brsh; \
			(f).l >>= brsh; \
			(f).l |= h2l; \
		} \
		else { \
			brsh -= 32; \
			(f).l = (brsh > 0) \
				? ((f).h >> brsh) \
				: ((brsh < 0) \
				  ? (((f).h << -brsh) | \
				     ((f).l >> (32 + brsh))) \
				  : (f).h); \
			(f).h = 0; \
		} \
	} \
	}

#endif   //-- ! CCC_FQK_U64

//----------------------------------------------------------------

#if defined(CCC_FQK_U64)

#define FQK_AS_U64(f)		(*((U64*)(&(f))))

//-- Vergleichen (bestimmen der Ordnung) der beiden FQKs
#define FQK_CMP(f1, f2) \
	((FQK_AS_U64(f1) > FQK_AS_U64(f2)) \
	  ? -1 \
	  : ((FQK_AS_U64(f1) < FQK_AS_U64(f2)) \
	    ? 1 \
	    : 0))

//-- Ueberpruefen der Gleichheit der beiden FQKs
#define FQK_EQU(f1, f2) \
	(FQK_AS_U64(f1) == FQK_AS_U64(f2))

//-- Loeschen aller Felder der FQK
#define FQK_CLR_ALL(f) \
	{ FQK_AS_U64(f) = ((U64)0); }

//-- Fuellen aller Felder der FQK
#define FQK_SET_ALL(f) \
	{ FQK_AS_U64(f) = FQK_ALL; }

//-- Ermitteln eines Feldes der FQK entspr. Bit-Nummer
#define FQK_GET_BNR(f, i) \
	(FQK_AS_U64(f) & (((U64)1) << (i)))

//-- Fuellen eines Feldes in der FQK entspr. Bit-Nummer
#define FQK_SET_BNR(f, i) \
	{ FQK_AS_U64(f) |= (((U64)1) <<  (i)); }

//-- Loeschen eines Feldes aus der FQK entspr. Bit-Nummer
#define FQK_CLR_BNR(f, i) \
	{ FQK_AS_U64(f) &= ~(((U64)1) <<  (i)); }

//-- Ueberpruefen der beiden FQKs auf Disjunktheit
#define FQK_FILL_OK(f1, f2) \
	((FQK_AS_U64(f1) & FQK_AS_U64(f2)) == 0)

//-- Fuellen der ersten FQK mit der zweiten
#define FQK_FILL_IT(f1, f2) \
	{ FQK_AS_U64(f1) |= FQK_AS_U64(f2); }

//-- Verschieben
#define FQK_TRN_C3D(f, v) \
	{ FQK_AS_U64(f) >>= ((BNR_MAX - 1) - FQK_C3D_TO_BNR(v)); }

#endif  //-- CCC_FQK_U64

//----------------------------------------------------------------

//-- Ermitteln eines Feldes der FQK entspr. 3D-Koordinaten
#define FQK_GET_C3D(f, pt) \
	FQK_GET_BNR(f, FQK_C3D_TO_BNR(pt))

//-- Fuellen eines Feldes in der FQK entspr. 3D-Koordinaten
#define FQK_SET_C3D(f, pt) \
	FQK_SET_BNR(f, FQK_C3D_TO_BNR(pt))

//-- Loeschen eines Feldes aus der FQK entspr. 3D-Koordinaten
#define FQK_CLR_C3D(f, pt) \
	FQK_CLR_BNR(f, FQK_C3D_TO_BNR(pt))

//----------------------------------------------------------------
// Ermitteln der gesetzten Bits einer FQK

int cnt_FQK(FQK f) {

int i, r = 0;

for (i = 0; i < BNR_MAX; i++) {
	if (FQK_GET_BNR(f, i))
		r++;
}
return r;

}   //-- cnt_FQK

//----------------------------------------------------------------
// Globale Variable fuer FQK

const FQK FQK_none = FQK_NONE;
const FQK FQK_all  = FQK_ALL;

//----------------------------------------------------------------
// FQKs fuer jedes Teil

//-- Liste der Fuellungen fuer jedes Teil fuer jede Position
#if defined(CCC_MIT_QUADER_SYM)
#define LF_MAX		(3132 + (T_ANZ * K_Q_ANZ))
#else
#define LF_MAX		(2700 + (T_ANZ * K_Q_ANZ))
#endif
FQK	aLF[LF_MAX + 1];	// Waechter am Ende
#define pLF_0		aLF
FQK*	pLF_i;
FQK*	pLF_n;
FQK*	pLF_m =		aLF + LF_MAX;
//-- Abschnitt des aktuellen Teiles in LF
FQK*	pLF_T_0;
FQK*	pLF_T_i;
FQK*	pLF_T_n;

//-- Index (Random Access) fuer jedes Teil fuer jede Bit-Nummer
//   (Zeigt nach LF)
#define PLF_ANZ		(T_ANZ * BNR_MAX)
FQK*	aPLF[PLF_ANZ];
#define pPLF_0		aPLF
FQK**	pPLF_i;
FQK**	pPLF_n;
FQK**	pPLF_m =	aPLF + PLF_ANZ;
//-- Erste Position des aktuellen Teiles in PLF
FQK**	pPLF_T_0;

//-- Index (Random Access) fuer jedes Teil
//   (zeigt nach PLF)
#define PPLF_ANZ	T_ANZ
FQK**	aPPLF[PPLF_ANZ];
#define pPPLF_0		aPPLF
FQK***	pPPLF_i;
FQK***	pPPLF_n;
FQK***	pPPLF_m =	aPPLF + PPLF_ANZ;

//----------------------------------------------------------------

#if defined(CCC_TEST_OUT_LF)

//----------------------------------------------------------------
// Ausgeben der Anzahl der Eintraege von LF, PLF und PPLF

void test_out_LF_ns(void) {

printf("dbg> LF_n=%d, PLF_n=%d, PPLF_n=%d\n",
	pLF_n - pLF_0, pPLF_n - pPLF_0, pPPLF_n - pPPLF_0
);

}   //-- test_out_LF_ns

//----------------------------------------------------------------
// Ausgeben von LF

void test_out_LF(void) {

FQK* pLF;

for (pLF = pLF_0; pLF < pLF_n; pLF++) {
	if (pLF == NULL) {
		printf("dbg> LF - %04d - NULL\n",
			pLF - pLF_0);
	}
	else {
		printf("dbg> LF - %04d - f=0x%0.8lX%0.8lX\n",
			pLF - pLF_0,
			pLF->h, pLF->l);
	}
}

}   //-- test_out_LF

//----------------------------------------------------------------
// Ausgeben von PLF

void test_out_PLF(void) {

FQK** pPLF;

for (pPLF = pPLF_0; pPLF < pPLF_n; pPLF++) {
	if ((*pPLF) == NULL) {
		printf("dbg> PLF - %04d - NULL\n",
			pPLF - pPLF_0);
	}
	else {
		printf("dbg> PLF - %04d - f=0x%0.8lX%0.8lX\n",
			pPLF - pPLF_0,
			(*pPLF)->h, (*pPLF)->l);
	}
}

}   //-- test_out_PLF

//----------------------------------------------------------------
// Ausgeben von PPLF

void test_out_PPLF(void) {

FQK*** pPPLF;
for (pPPLF = pPPLF_0; pPPLF < pPPLF_n; pPPLF++) {
	int i = pPPLF - pPPLF_0;
	FQK** p = *pPPLF;
	
	printf("dbg> PPLF - %0.2d (nr=%2d,id=\'%c\',nk=%d) - ",
		i, (aT+i)->nr + 1, (aT+i)->id, (aT+i)->nk);
	//-- Suchen nach der ersten Position dieses Teiles
	while ((*p) == NULL) p++;
	printf("f=0x%0.8lX%0.8lX\n",
		(*p)->h, (*p)->l);
}

}   //-- test_out_PLF

//----------------------------------------------------------------

#endif   //-- CCC_TEST_OUT_LF

//----------------------------------------------------------------





//----------------------------------------------------------------
// Permutation (evtl. mit Vorzeichenwechsel)
//
// Zur Implementierung von Rotationen im Koordinatenraster

typedef
struct tag_PVW_C3D {
	C3D pvw;
}
PVW_C3D;   //-- Permutation

//-- Definieren einer Rotation
#define PVW_C3D_DEF(i_0, i_1, i_2) \
	{ (i_0), (i_1), (i_2) }

//-------- Makros fuer PVW_C3D --------

//-- Ausfuehren der Permutation p (nur Coordinate c)
#define PVW_C3D_XQT_C1D(c, v, p, v1) \
	{ \
	S08 j; \
	(v).c = ((j = (p).pvw.c) >= 0 \
		? (   (v1).a[  j  - 1]) \
		: ( - (v1).a[(-j) - 1])); \
	}

#define PVW_C3D_XQT(v, p, v1) \
	{ \
	PVW_C3D_XQT_C1D(x, v, p, v1); \
	PVW_C3D_XQT_C1D(y, v, p, v1); \
	PVW_C3D_XQT_C1D(z, v, p, v1); \
	}

#define PVW_C3D_SYM_C1D(c, p1, p2) \
	(abs((p1).pvw.c) == abs((p2).pvw.c))

#define PVW_C3D_SYM(p1, p2) \
	(PVW_C3D_SYM_C1D(x, p1, p2) && \
	 PVW_C3D_SYM_C1D(y, p1, p2) && \
	 PVW_C3D_SYM_C1D(z, p1, p2))

//----------------------------------------------------------------
// Rotationsgruppe
//
// Das sind jene (in 3D: 24) Moeglichkeiten einen Teil
// (bzw. mit diesem jeden Kubus des Teiles) zu drehen

typedef
struct tag_LRG_E {
	PVW_C3D p;	//-- Permutation
	U08	nqs;	//-- Kennzeichen, ob diese Rotation
			//   bei Ausschluss der Quadersymmetrie
			//   beruecksichtigt wird
}
LRG_E;   //-- Rotationsgruppen - Eintrag

//-- Definieren eines Rotationsgruppeneintrages
#define LRG_E_DEF(i_nr,   i_0, i_1, i_2,  i_nqs) \
	{ PVW_C3D_DEF(    i_0, i_1, i_2), i_nqs }

#define LRG_ANZ		24
LRG_E	aLRG[LRG_ANZ] = {

LRG_E_DEF( 1,	 1, 2, 3,	1 ),
LRG_E_DEF( 2,	 2,-1, 3,	1 ),
LRG_E_DEF( 3,	-1,-2, 3,	0 ),
LRG_E_DEF( 4,	-2, 1, 3,	0 ),
LRG_E_DEF( 5,	 1, 3,-2,	1 ),
LRG_E_DEF( 6,	 2, 3, 1,	1 ),
LRG_E_DEF( 7,	-1, 3, 2,	0 ),
LRG_E_DEF( 8,	-2, 3,-1,	0 ),
LRG_E_DEF( 9,	 3,-1,-2,	1 ),
LRG_E_DEF(10,	 3,-2, 1,	1 ),
LRG_E_DEF(11,	 3, 1, 2,	0 ),
LRG_E_DEF(12,	 3, 2,-1,	0 ),
LRG_E_DEF(13,	-1,-3,-2,	0 ),
LRG_E_DEF(14,	-2,-3, 1,	0 ),
LRG_E_DEF(15,	 1,-3, 2,	0 ),
LRG_E_DEF(16,	 2,-3,-1,	0 ),
LRG_E_DEF(17,	-3, 1,-2,	0 ),
LRG_E_DEF(18,	-3, 2, 1,	0 ),
LRG_E_DEF(19,	-3,-1, 2,	0 ),
LRG_E_DEF(20,	-3,-2,-1,	0 ),
LRG_E_DEF(21,	 1,-2,-3,	0 ),
LRG_E_DEF(22,	 2, 1,-3,	0 ),
LRG_E_DEF(23,	-1, 2,-3,	0 ),
LRG_E_DEF(24,	-2,-1,-3,	0 )

};   //-- Rotationsgruppe

#define pLRG_0		aLRG
LRG_E*	pLRG_n =	aLRG + LRG_ANZ;
LRG_E*	pLRG_i;

//-- Rotieren von v1 um die pLRG_i-te Rotation aus aLRG
//   Ergebnis in v
#define LRG_XQT(v, r, v1) \
	PVW_C3D_XQT(v, (r).p, v1);

#define LRG_SYM(r1, r2) \
	PVW_C3D_SYM((r1).p, (r2).p)

//----------------------------------------------------------------
// Vorbereitung - LRG
//
// Erstellen des Kennzeichens fuer die, bei Eliminierung
// der Quadersymmetrie zu beruecksichtigenden, Eintraege
// aus der Rotationsgruppe

void prep_LRG_nqs(void) {

for (pLRG_i = pLRG_0; pLRG_i < pLRG_n; pLRG_i++) {
	int nqs = 1;
	LRG_E* pLRG_ii;
	
	//-- Ueberpruefen dieser Rotation,
	//   ob sie in Bezug auf die Symmetrie des
	//   Quaders bereits beruecksicht worden ist
	//   oder sie aber neu ist.
	for (pLRG_ii = pLRG_0; pLRG_ii < pLRG_i; pLRG_ii++) {
		if (LRG_SYM(*pLRG_i, *pLRG_ii)) {
			nqs = 0;
			break;
		}
	}
	printf("LRG_E_DEF(%2d,\t%2d,%2d,%2d,\t%d ),\n",
		1 + pLRG_i - pLRG_0,
		pLRG_i->p.pvw.x,
		pLRG_i->p.pvw.y,
		pLRG_i->p.pvw.z,
		nqs);
}

}   //-- prep_LRG_nqs

//----------------------------------------------------------------
// Liste der Grundpositionen - fuer aktuelles Teil
//
// Fuer das Eliminieren der Symmetrien eines Teiles -
// liegen Original und Bild eines Teiles buendig an allen drei
// positiven Koordinatenhalbebenen an, so ergeben Rotationen
// aus der Symmetriegruppe des Teiles identische Fuellungen.

typedef
struct tag_LGP_E {
	FQK f;		// Fuellung des Quaders mit Kuben
	C3D d;		// Groesse in x-, y- und z-Richtung
}
LGP_E;   //-- Liste der Grundpositionen - Element

// Liste der Grundpositionen
//	Steht fuer den aktuellen Teil fuer jeden der Eintraege der
//	Rotationsgruppe zur Verfuegung
#define LGP_ANZ		LRG_ANZ
LGP_E	aLGP[LGP_ANZ + 1];		// mit Waechter am Ende
#define pLGP_0		aLGP
LGP_E*	pLGP_i;
LGP_E*	pLGP_n;
LGP_E*	pLGP_m =	aLGP + LGP_ANZ;

//----------------------------------------------------------------
// Funktion zum Vergleichen zweier Grundpositionen fuer qsort

int cdecl cmp_PLGP_E(const void* p1, const void* p2) {

return FQK_CMP(((LGP_E*)p1)->f, ((LGP_E*)p2)->f);

}   //-- cmp_PLGP_E

//----------------------------------------------------------------
// Funktion zum Vergleichen zweier Fuellungen fuer qsort

int cdecl cmp_PFQK(const void* f1, const void* f2) {

return FQK_CMP(*((FQK*)f1), *((FQK*)f2));

}   //-- cmp_PFQK

//----------------------------------------------------------------
// Puzzle initialisieren

void puzzle_init_3x4x5(void) {

C3D	ptmin, ptmax;
FQK	f;
U32	m;
LGP_E*	pLGP_n1;
int	Quadersymmetrien_eliminiert;
FQK*	pLF_base;

#if defined(CCC_MIT_QUADER_SYM)
//-- Quadersymmetrien als bereits eliminiert betrachten
Quadersymmetrien_eliminiert = (1 == 1);
#else
Quadersymmetrien_eliminiert = (0 == 1);
#endif

pPPLF_i = pPPLF_0;
ON_TST_RET(0x1201, (pPPLF_i >= pPPLF_m));
pPLF_i = pPLF_0;
ON_TST_RET(0x1202, (pPLF_i >= pPLF_m));
pLF_i = pLF_0;
ON_TST_RET(0x1203, (pLF_i >= pLF_m));

pQTK_i = pQTK_0;
ON_TST_RET(0x1204, (pQTK_i >= pQTK_m));
ON_TST_RET(0x1205, (pQTK_i->typ != QTK_TYP_Q));
		
//-- Fuer alle Teile
pT_n = pT_0 + pQTK_i->nt;
ON_TST_RET(0x1206, (pT_n > pT_m));
for (pT_i = pT_0 ; pT_i < pT_n; pT_i++) {
	pQTK_i++;
	ON_TST_RET(0x1207, (pQTK_i >= pQTK_m));
	ON_TST_RET(0x1208, (pQTK_i->typ != QTK_TYP_T));
	ON_TST_RET(0x1209, (pQTK_i->nr != pT_i - pT_0));
	ON_TST_RET(0x1210, (pQTK_i->nk > K_T_MAX));
	
	//-- Umkopieren in die Teileliste
	*pT_i = *pQTK_i;
	
	//-- Fuer alle Kuben des aktuellen Teiles
	pK_n = pK_0 + pQTK_i->nk; \
	ON_TST_RET(0x1211, (pK_n > pK_m));
	for (pK_i = pK_0; pK_i < pK_n; pK_i++) {
		pQTK_i++;
		ON_TST_RET(0x1212, (pQTK_i >= pQTK_m));
		ON_TST_RET(0x1213, (pQTK_i->typ != QTK_TYP_K));
		//-- Umkopieren in die Kubenliste
		*pK_i = *pQTK_i;
	}
	
	//-- Ermitteln der Grundpositionen aLGP, die sich aus der
	//   Anwendung der einzelnen Eintraege der Rotationsgruppe
	//   auf das aktuelle Teil ergeben
	pLGP_n = pLGP_m;
	pLGP_i = pLGP_0;
	for (pLRG_i = pLRG_0; pLRG_i < pLRG_n; pLRG_i++) {
		//-- Drehen des Teiles ( = Drehen aller Kuben)
		C3D_INI_MIN_MAX(ptmin, ptmax);
		pKr_i = pKr_0;
		for (pK_i = pK_0; pK_i < pK_n; pK_i++) {
			LRG_XQT(pKr_i->c, *pLRG_i, pK_i->c);
			C3D_UPD_MIN_MAX(ptmin, ptmax, pKr_i->c);
			pKr_i++;
		}
		pKr_n = pKr_i;
		//-- Passt das gedrehte Teil in den Quader ?
		C3D_SUB(ptmax, ptmin);
		if (C3D_TEST_IN_Q(ptmax)) {
			//-- Es passt
			//-- Mache aus den Kuben eine Fuellung
			//   an der Grundposition
			FQK_CLR_ALL(f);
			for (pKr_i = pKr_0;
			     pKr_i < pKr_n;
			     pKr_i++) {
				C3D_SUB(pKr_i->c, ptmin);
				FQK_SET_C3D(f, pKr_i->c);
			}
			ON_TST_RET(0x1214, (pLGP_i >= pLGP_n));
			pLGP_i->f = f;
			pLGP_i->d = ptmax;
			pLGP_i++;
		}
		else {
			//-- Es passt nicht
		}
	}
	pLGP_n = pLGP_i;
	ON_TST_RET(0x1215, (pLGP_n <= pLGP_0));
	
	//-- Sortieren der Liste der Grundpositionen
	qsort(pLGP_0, pLGP_n - pLGP_0,
	      sizeof(*pLGP_0), cmp_PLGP_E);
	//-- Eliminieren identer Grundpositionen aus aLGP
	//   (also der Symmetrien des aktuellen Teiles)
	FQK_CLR_ALL(pLGP_n->f);		//-- Setzen des Waechters
	pLGP_n1 = pLGP_0;
	for (pLGP_i = pLGP_0; pLGP_i < pLGP_n; ) {
		*pLGP_n1 = *pLGP_i;
		//-- Ueberlesen der identischen Eintraege
		do { pLGP_i++; }
		while (FQK_EQU(pLGP_n1->f, pLGP_i->f));
		pLGP_n1++;
	}
	pLGP_n = pLGP_n1;
	
	//-- Nun steht fest, ob das Teil eine Symmetrie besitzt
	//   und welche seiner Grundpositionen zur Gaenze
	//   in den Quader passen
	//   -
	//   das erste Teil ohne Symmetrie, das mit allen
	//   seinen Grundpositionen in den Quader passt,
	//   wird zum Eliminieren der Symmetrien des Quaders
	//   verwendet
	
	//-- Wurden die Quadersymmetrien bereits elimiert,
	//   und falls nicht, ist das aktuelle Teil
	//   dazu geeignet ?
	if ((!Quadersymmetrien_eliminiert) &&
	    ((pLGP_n - pLGP_0) == LRG_ANZ)) {
		//-- Ermitteln der Grundpositionen - diesmal
		//   unter Beruecksichtigung der Quadersymmetrie
		pLGP_i = pLGP_0;
		//-- Durchforsten der Rotationsgruppe
		for (pLRG_i = pLRG_0; pLRG_i < pLRG_n; pLRG_i++) {
			if (pLRG_i->nqs) {
				// Drehen des Teiles
				// ( = Drehen aller Kuben)
				C3D_INI_MIN_MAX(ptmin, ptmax);
				pKr_i = pKr_0;
				for (pK_i = pK_0;
				     pK_i < pK_n;
				     pK_i++) {
					LRG_XQT(pKr_i->c,
					  *pLRG_i, pK_i->c);
					C3D_UPD_MIN_MAX(
					  ptmin, ptmax, pKr_i->c);
					pKr_i++;
				}
				pKr_n = pKr_i;
				C3D_SUB(ptmax, ptmin);
				// GedrehteS Teil passt in Quader
				// Mache aus Kuben eine Fuellung
				FQK_CLR_ALL(f);
				for (pKr_i = pKr_0;
				     pKr_i < pKr_n;
				     pKr_i++) {
					C3D_SUB(pKr_i->c, ptmin);
					FQK_SET_C3D(f, pKr_i->c);
				}
				pLGP_i->f = f;
				pLGP_i->d = ptmax;
				pLGP_i++;
			}
		}
		pLGP_n = pLGP_i;
		
		//-- Sortieren der Liste der Grundpositionen
		//   ist nicht mehr notwendig
		Quadersymmetrien_eliminiert = (1 == 1);
	}
	//-- Platz fuer die Waechter der einzelnen
	//   Anfangspositionen schaffen
	pLF_base = pLF_i;
	pLF_i += K_Q_ANZ;
	
	//-- Ermitteln der Fuellungen, die sich aus der
	//   Anwendung der moeglichen Verschiebungen
	//   auf jede der Grundpositionen ergeben
	pLF_T_0 = pLF_i;
	for (pLGP_i = pLGP_0; pLGP_i < pLGP_n; pLGP_i++) {
		C3D v_i;
		C3D v_n = C3D_DEF(X_ANZ, Y_ANZ, Z_ANZ);
		
		//-- Fuer alle moeglichen Verschiebungen
		C3D_SUB(v_n, pLGP_i->d);
		for (v_i.x = 0; v_i.x < v_n.x; v_i.x++) {
		for (v_i.y = 0; v_i.y < v_n.y; v_i.y++) {
		for (v_i.z = 0; v_i.z < v_n.z; v_i.z++) {
			f = pLGP_i->f;
			FQK_TRN_C3D(f, v_i);
			ON_TST_RET(0x1216, (pLF_i >= pLF_m));
			*pLF_i = f;
			pLF_i++;
		} } }
	}
	pLF_T_n = pLF_i;
	ON_TST_RET(0x1217, (pLF_T_n <= pLF_T_0));
	
	//-- Indizieren von LF ueber PLF - fuer das aktuelle Teil
	ON_TST_RET(0x1218, (pPPLF_i >= pPPLF_m));
	*pPPLF_i = pPLF_i;
	pPPLF_i++;
	
	//-- Sortieren von LF - fuer das aktuelle Teil
	qsort(pLF_T_0, pLF_T_n - pLF_T_0,
	      sizeof(*pLF_T_0), cmp_PFQK);
	//-- Indizieren von LF - fuer das aktuelle Teil
	FQK_CLR_ALL(*pLF_T_n);		//-- Setzen des Waechters
	pLF_T_i = pLF_T_0;
	//-- Erste Position in PLF - fuer das aktuelle Teil
	pPLF_T_0 = pPLF_i;
	//-- Indizieren fuer FQK.h
	for (m = (((U32)1) << (BNR_MAX_H - 1)); m != 0; m >>= 1) {
		ON_TST_RET(0x1219, (pPLF_i >= pPLF_m));
		if (m & pLF_T_i->h) {
			*pPLF_i = pLF_base;
		}
		else {
			*pPLF_i = NULL;
		}
		pPLF_i++;
		while (m & pLF_T_i->h) {
			//-- Umkopieren
			*pLF_base++ = *pLF_T_i++;
		}
		//-- Waechter am Ende setzen
		FQK_CLR_ALL(*pLF_base);
		pLF_base++;
	}
	//-- Indizieren fuer FQK.l
	for (m = (((U32)1) << (32 - 1)); m != 0; m >>= 1) {
		ON_TST_RET(0x1220, (pPLF_i >= pPLF_m));
		if (m & pLF_T_i->l) {
			*pPLF_i = pLF_base;
		}
		else {
			*pPLF_i = NULL;
		}
		pPLF_i++;
		while (m & pLF_T_i->l) {
			//-- Umkopieren
			*pLF_base++ = *pLF_T_i++;
		}
		//-- Waechter am Ende setzen
		FQK_CLR_ALL(*pLF_base);
		pLF_base++;
	}
	ON_TST_RET(0x1221, (pLF_T_i  != pLF_T_n));
	ON_TST_RET(0x1222, (pLF_base != pLF_T_n));
	
	if (opt == OPT_TEILERGEBNIS) {
		//-- Ueberpruefen, ob dieser Teil zur Ermittlung
		//   des Teilergebnisses nicht in eine Position
		//   gestellt werden darf, bei der der erste
		//   Kubus des Quaders gefuellt ist
		if ((pT_i->nr < opt_tn_von) ||
		    (pT_i->nr > opt_tn_bis)) {
			//-- die erste Position deaktivieren
			*pPLF_T_0 = NULL;
		}
	}
}

pLF_n   = pLF_i;
pPLF_n  = pPLF_i;
pPPLF_n = pPPLF_i;

ON_TST_RET(0x1222, (!Quadersymmetrien_eliminiert));

#if defined(CCC_TEST_OUT_LF)
test_out_LF_ns();
test_out_LF();
test_out_PLF();
test_out_PPLF();
#endif   //-- CCC_TEST_OUT_LF

}   //-- puzzle_init_3x4x5

//----------------------------------------------------------------



//----------------------------------------------------------------
// Ende - Puzzle initialisieren
//----------------------------------------------------------------







//----------------------------------------------------------------
// Beginn - Puzzle loesen
//----------------------------------------------------------------



//----------------------------------------------------------------
// Liste verwendeter Teile
// (schon wieder ein Bit-Vektor)

#if   (T_ANZ > 15)
#error T_ANZ > 15 ... anpassen: LVT
#endif

typedef U16
LVT;	// Waechter am Ende (Bits nach T_ANZ)

//-- Alle Teile sind verwendet
#define LVT_ALL		(0xFFFF >> (16 - T_ANZ))

//-- Alle Teile sind frei - Kein Teil wird verwendet
#define LVT_NONE	0

//-- Kennzeichnen aller Teile als frei (noch verwendbar)
#define LVT_CLR_ALL(lvt) \
	{ (lvt) = LVT_NONE; }

//-- Kennzeichnen aller Teile als bereits verwendet
#define LVT_SET_ALL(lvt) \
	{ (lvt) = LVT_ALL; }

//-- Kennzeichnen von Teil tnr als verwendet
#define LVT_SET(lvt, tnr) \
	{ (lvt) |= (((LVT)1) << (tnr)); }

//-- Kennzeichnen von Teil tnr als frei (noch verwendbar)
#define LVT_CLR(lvt, tnr) \
	{ (lvt) &= ~(((LVT)1) << (tnr)); }

//-- Ermitteln der Nummer des naechsten freien Teiles
#define LVT_GET_TNR(lvt, tnr) \
	{ \
	LVT lvt_m = (((LVT)1) << (tnr)); \
	while ((lvt) & lvt_m)) { \
		lvt_m <<= 1; \
		(tnr)++; \
	} \
	}

//----------------------------------------------------------------
// Message - zur Unterhaltung waehrend des Loesungsvorganges

#if  ((T_ANZ != 12) || (K_Q_ANZ != 60))
#error T_ANZ != 12 ... anpassen: aM, aErwAnz, ERW_ANZ ...
#endif

int mit_M = 0;		// Unterhaltung ok ?

#define ADL		409963L
#if defined(CCC_BIS_ANZ_LOESUNGEN)
#define ERW_ANZ		CCC_BIS_ANZ_LOESUNGEN
#else
#if defined(CCC_TEST_MIT_QUADER_SYM)
#define ERW_ANZ		(ADL * 4)
#else
#define ERW_ANZ		ADL
#endif
#endif

long Anzahl_der_Loesungen_erw = -1;

long aErwAnz[1 + T_ANZ] =
{
		// nr, id   (des Teiles)
      1L,	//  1, 'c'
  44911L,	//  2, 's'
  73260L,	//  3, 'L'
 125321L,	//  4, '1'
 175527L,	//  5, 'Q'
 221381L,	//  6, 'T'
 257075L,	//  7, 'd'
 295112L,	//  8, 'w'
 324970L,	//  9, '~'
 344426L,	// 10, 'f'
 359049L,	// 11, '+'
 359049L,	// 12, 't'
 409964L
};

char aM_info[] =
"                     3x4x5.EXE  --  (c)2003, Hannes G. Kuchler\n"
"\n"
;

char aM_ADL[] =
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n"
"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\n"
"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\n"
":::::::::4:::::0000::::::9999::::::9999:::::::66:::33333333:::\n"
"::::::::44 ::00 .000:::99 .999:::99 .999::::66 ..:::....33 .::\n"
":::::::444 :00 .:000 :99 .:999 :99 .:999 ::66 .::::::::33 .:::\n"
"::::::4444 :00 ::000 :99 ::999 :99 ::999 ::666666:::3333 .::::\n"
":::::44444 :00 ::000 :99 ::999 :99 ::999 :66 ..666:::..333::::\n"
"::::44 444 :00 ::000 :99 ::999 :99 ::999 :66 ::666 :::::333:::\n"
":::44 .444 :00 ::000 :99 ::999 :99 ::999 :66 ::666 :::::333 ::\n"
"::44 .:444 :00 ::000 ::999999 .::999999 .:66 ::666 :::::333 ::\n"
"::44444444 :00 ::000 ::: 999 .:::::999 .::66 ::666 :::::333 ::\n"
":::....444 :00 :000 .:::999 .XX:::999 .:::66 :666 33:::333 .::\n"
":::::::444 ::0000 .::::999 .:XX :999 .:::::6666  .:333333 .:::\n"
"::::::::...:::...:::::::..::::..::...:::::::....:::::.....::::\n"
"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\n"
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n"
;

char aM_known[] =
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n"
"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\n"
"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\n"
"::::::::::::::::::+-----+-----+-----+-----+-----+:::::::::::::\n"
":::::::::::::::::/     /     /     /     /     /!:::::::::::::\n"
"::::::::::::::::+-----+-----+-----+-----+-----+ !:::::::::::::\n"
":::::::::::::::/     /     /     /     /     /! !:::::::::::::\n"
"::::::::::::::+-----+-----+-----+-----+-----+ ! +:::::::::::::\n"
":::::::::::::/     /     /     /     /     /! !/!:::::::::::::\n"
"::::::::::::+-----+-----+-----+-----+-----+ ! + !:::::::::::::\n"
"::::::::::::!     !     !     !     !     ! !/! !:::::::::::::\n"
"::::::::::::!     !     !     !     !     ! + ! !:::::::::::::\n"
"::::::::::::!     !     !     !     !     !/! !/!:::::::::::::\n"
"::::::::::::+-----+-----+-----+-----+-----+ ! + !:::::::::::::\n"
"::::::::::::!     !     !     !     !     ! !/! !:::::::::::::\n"
"::::::::::::!     !     !     !     !     ! + ! !:::::::::::::\n"
"::::::::::::!     !     !     !     !     !/! !/!:::::::::::::\n"
"::::::::::::+-----+-----+-----+-----+-----+ ! + !:::::::::::::\n"
"::::::::::::!     !     !     !     !     ! !/! !:::::::::::::\n"
"::::::::::::!     !     !     !     !     ! + ! +:::::::::::::\n"
"::::::::::::!     !     !     !     !     !/! !/.:::::::::::::\n"
"::::::::::::+-----+-----+-----+-----+-----+ ! +.::::::::::::::\n"
"::::::::::::!     !     !     !     !     ! !/.:::::::::::::::\n"
"::::::::::::!     !     !     !     !     ! +.::::::::::::::::\n"
"::::::::::::!     !     !     !     !     !/.:::::::::::::::::\n"
"::::::::::::+-----+-----+-----+-----+-----+.::::::::::::::::::\n"
"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\n"
"::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\n"
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n"
;

char aM_unknown[] =
"work in progress ... work in progress ... work in progress ...\n"
;

char*	pM_0 =		aM_unknown;
char*	pM_i;

//-- Message waehrend des Wartens auf das naechste Zeichen
//   der eigentlichen Message
char aMw[] = "-/|\\";
#define pMw_0		aMw
char*	pMw_i =		pMw_0;

U32	Mw_max;
U32	Mw_cnt;

//----------------------------------------------------------------
// Ausgeben der Message - Vorbereitung

void out_M_init(void) {

mit_M = 1;

#if defined(CCC_MIT_PRN_LLW)
//-- Message wird nicht ausgegeben,
//   falls eine Ausgabe des Loesungsweges erfolgt und
//   stdout nicht umgeleitet worden ist
//     (denn das gibt zusammen mit den auf stderr ausgegebenen
//      Lebenszeichen einen ziemlichen Durcheinander)
if (stdout->flags & _F_TERM) {
	mit_M = 0;
}
#endif
if (opt == OPT_CT_LOGO) {
	mit_M = 0;
}

if (!mit_M) {
	return;
}

pM_0 = ((Anzahl_der_Loesungen_erw == ADL)
	? aM_ADL
	: ((Anzahl_der_Loesungen_erw >= 0)
	   ? aM_known
	   : aM_unknown));
Mw_max = Anzahl_der_Loesungen_erw / strlen(pM_0);
Mw_max += 1;
Mw_cnt = Mw_max;
pM_i = pM_0;

}   //-- out_M_init();

//----------------------------------------------------------------
// Ausgeben der Message - Nachbereitung

void out_M_exit(void) {

if (!mit_M) {
	return;
}

if (*pM_i == '\n') {
	fputc(' ', stderr);
}
// Ausgabe des Restes der Message
fputs(pM_i, stderr);
// Ausgabe der Infomessage
fputs(aM_info, stderr);

}   //-- out_M_exit

//----------------------------------------------------------------
// Ausgeben der Message

void out_M(void) {

char c;

if (!mit_M) {
	return;
}

if (--Mw_cnt <= 0) {
	//-- naechstes Zeichen der eigentlichen Message
	c = *pM_i;
	if (c == '\0') {
		if (pM_0 == aM_unknown) {
			//-- endlos
			c = *(pM_i = pM_0);
		}
		else {
			c = '?';
		}
	}
	else
		{
		if (c == '\n') {
			//-- loeschen von *pMw_i
			fputc(' ', stderr);
		}
		pM_i++;
	}
	fputc(c, stderr);
	Mw_cnt = Mw_max;
}
else {
	//-- naechstes Zeichen von Message warten
	c = *pMw_i;
	if (c == '\0') { pMw_i = pMw_0; }
	fputc(*pMw_i, stderr);
	fputc('\b',   stderr);
	pMw_i++;
}

}   //-- out_M

//----------------------------------------------------------------
// Liste fuer Loesungsweg

typedef
struct tag_LLW_E {
	U16 v;		//-- Liste bereits verwendeter Teile
	int t;		//-- Nummer des hier verwendeten Teiles
	int k;		//-- bis zu dieser Kubusposition gefuellt
	U32 m_k;	//-- Maske fuer diese Kubusposition
	FQK f;		//-- Fuellung (insgesammt)
	FQK ft;		//-- Fuellung (nur von diesem Teil)
}
LLW_E;   //-- Liste fuer Loesungsweg - Eintrag

#define LLW_ANZ		T_ANZ
LLW_E	aLLW[1 + LLW_ANZ + 1];
#define pLLW_ini	aLLW
#define pLLW_0		(pLLW_ini + 1)
LLW_E*	pLLW_i;
#define	pLLW_solved	(pLLW_0 + T_ANZ - 1)
LLW_E*	pLLW_m =	pLLW_0 + LLW_ANZ + 1;

#define LLW_INI() \
	{ \
	pLLW_ini->v = LVT_NONE; \
	pLLW_ini->t = -1; \
	pLLW_ini->k = BNR_MAX; \
	pLLW_ini->m_k = (pLLW_ini->k >= 32) \
		? (((U32)1) << (pLLW_ini->k - 32)) \
		: (((U32)1) << (pLLW_ini->k     )); \
	pLLW_ini->f  = FQK_none; \
	pLLW_ini->ft = FQK_none; \
	pLLW_i = pLLW_ini; \
	}

#define LLW_INI_NXT(i_t, i_ft) \
	{ \
	pLLW_i++; \
	ON_TST_RET(0x1301, (pLLW_i <  pLLW_0)); \
	ON_TST_RET(0x1302, (pLLW_i >= pLLW_m)); \
	pLLW_i->v   = (pLLW_i - 1)->v | (1 << (i_t)); \
	pLLW_i->t   = (i_t); \
	pLLW_i->k   = (pLLW_i - 1)->k; \
	pLLW_i->m_k = (pLLW_i - 1)->m_k; \
	pLLW_i->f   = (pLLW_i - 1)->f; \
	pLLW_i->ft  = (i_ft); \
	ON_TST_RET(0x1303, !FQK_FILL_OK(pLLW_i->f, (i_ft))); \
	FQK_FILL_IT(pLLW_i->f, (i_ft)); \
	}

//----------------------------------------------------------------
// Umwandeln von LLW in einen String

char* LLWtoa(LLW_E* pl_n) {

static char s[BNR_MAX + 1];
LLW_E* pl;
int i;
char c;
FQK  f;
int j;

memset(s, '$', BNR_MAX);
s[BNR_MAX] = '\0';
for (pl = pLLW_0; pl < pl_n; pl++) {
	c = (aT + pl->t)->id;
	f = pl->ft;
	for (i = 0; i < BNR_MAX; i++) {
		if (FQK_GET_BNR(f, i)) {
			s[i] = c;
		}
	}
}
return s;

}   //-- LLWtoa

//----------------------------------------------------------------
// Ausgeben eines Eintrages fuer den Loesungsweg

void prn_LLW_E(LLW_E* pl) {

printf("n=%3d - v=%d,t=%d,k=%d,m_k=0x%0.8lX\n",
	pl - pLLW_0, pl->v, pl->t, pl->k, pl->m_k);
printf("        f =0x%0.8lX%0.8lX\n",
	pl->f.h, pl->f.l);
printf("        ft=0x%0.8lX%0.8lX\n",
	pl->ft.h, pl->ft.l);

}   //-- prn_LLW_E

//----------------------------------------------------------------
// Ausgabe einer Loesung in 3D

#if !defined(CCC_MIT_LLW_3D_GRID)

void prn_LLW_3D(LLW_E* pl) {

C3D pt;
C1D yy;
char*	s = LLWtoa(pl);
char	s1[80 + 1];
char*	p1;

printf("\n");
for (pt.z = 0; pt.z < Z_ANZ; pt.z++) {
	for (pt.y = 0; pt.y < Y_ANZ; pt.y++) {
		p1 = s1;
		for (yy = Y_ANZ - 1; yy > pt.y; yy--) {
			*p1++ = ' ';
		}
		for (pt.x = 0; pt.x < X_ANZ; pt.x++) {
			*p1++ = s[FQK_C3D_TO_BNR(pt)];
		}
		*p1++ = '\n';
		*p1++ = '\0';
		//-- Anmerkung:
		// Der Compiler warnt (W8004) sinnloserweise,
		// dass p1 ein Wert zugewiesen wird,
		// der aber nicht benutzt werden wuerde -
		// Zur Deaktivierung wird p1 nun an printf
		// mituebergeben, was - da s1 ohne Format ist -
		// auch nichts weiter macht ...
		printf(s1, p1);
	}
	printf("\n");
}
printf("\n");

}   //-- prn_LLW_s3D

#else

void prn_LLW_3D(LLW_E* pl) {

C3D pt;
C1D yy;
char*	s = LLWtoa(pl);
char	s1[80 + 1];
char*	p1;
char	s2[80 + 1];
char*	p2;

printf("\n");
for (pt.z = 0; pt.z < Z_ANZ; pt.z++) {
	for (pt.y = 0; pt.y < Y_ANZ; pt.y++) {
		p1 = s1; p2 = s2;
		for (yy = Y_ANZ - 1; yy > pt.y; yy--) {
			*p1++ = *p2++ = ' ';
			*p1++ = *p2++ = ' ';
		}
		*p1++ = ' ';
		*p1++ = '/'; *p2++ = '+';
		for (pt.x = 0; pt.x < X_ANZ; pt.x++) {
			*p1++ = ' '; *p2++ = '-';
			*p1++ = s[FQK_C3D_TO_BNR(pt)];
			*p2++ = '-';
			*p1++ = ' '; *p2++ = '-';
			*p1++ = '/'; *p2++ = '+';
		}
		*p1++ = *p2++ = '\n';
		*p1++ = *p2++ = '\0';
		if (pt.y == 0) {
			printf("  ");
			printf(s2);
		}
		//-- Anmerkung:
		// siehe voriger Funktion
		printf(s1, p1);
		printf(s2, p2);
	}
	printf("\n");
}
printf("\n");

}   //-- prn_LLW_s3D

#endif   //-- CCC_MIT_LLW_3D_GRID

//----------------------------------------------------------------
// Liste fuer Loesungsweg F2

typedef
struct tag_LLW2_E {
	U16 v;		//-- Liste bereits verwendeter Teile
	int tp;		//-- Nummer des verwendeten Teilepaares
	int k;		//-- bis zu dieser Kubusposition gefuellt
	U32 m_k;	//-- Maske fuer diese Kubusposition
	FQK f;		//-- Fuellung (insgesammt)
	FQK ftp;	//-- Fuellung (nur von diesem Teilepaar)
}
LLW2_E;   //-- Liste fuer Loesungsweg - Eintrag

#define LLW2_ANZ	(T_ANZ / 2)
LLW2_E	aLLW2[1 + LLW2_ANZ + 1];
#define pLLW2_ini	aLLW2
#define pLLW2_0		(pLLW2_ini + 1)
LLW2_E*	pLLW2_i;
#define	pLLW2_solved	(pLLW2_0 + (T_ANZ / 2) - 1)
LLW2_E*	pLLW2_m =	pLLW2_0 + LLW2_ANZ + 1;

#define LLW2_INI() \
	{ \
	pLLW2_ini->v = LVT_NONE; \
	pLLW2_ini->tp = -1; \
	pLLW2_ini->k = BNR_MAX; \
	pLLW2_ini->m_k = (pLLW2_ini->k >= 32) \
		? (((U32)1) << (pLLW2_ini->k - 32)) \
		: (((U32)1) << (pLLW2_ini->k     )); \
	pLLW2_ini->f = FQK_none; \
	pLLW2_ini->ftp = FQK_none; \
	pLLW2_i = pLLW2_ini; \
	}

//----------------------------------------------------------------
// Umwandeln von LLW2 in einen String

char* LLW2toa(LLW2_E* pl_n) {

static char s[BNR_MAX + 1];
LLW2_E* pl;
int i;
char c;
FQK  f;
int j;

memset(s, '$', BNR_MAX);
s[BNR_MAX] = '\0';
for (pl = pLLW2_0; pl < pl_n; pl++) {
	//-- Es werden die einzelnen Teile dzt. nicht ermittelt
	//   (stattdessen wird die id des ersten Teiles
	//    zur Kennzeichung des Teilepaares hergenommen)
	c = (aT + (pl->tp & 0xF))->id;
	f = pl->ftp;
	for (i = 0; i < BNR_MAX; i++) {
		if (FQK_GET_BNR(f, i)) {
			s[i] = c;
		}
	}
}
return s;

}   //-- LLW2toa

//----------------------------------------------------------------
// Suchliste - zum Loesen des c't-Puzzles mit c't-Logo

typedef
struct tag_LSU_E {
	U08 b;		//-- Beschriftung des Teiles
	U08 t;		//-- Nummer des Teiles
	U08 id;		//-- ID des Teiles
	FQK f;		//-- Fuellung an Position
}
LSU_E;   //-- Struktur fuer Suchliste - Eintrag

#define LSU_E_DEF(i_c, i_t, i_id, i_f) \
	{ \
	i_c, ((i_t) - 1), i_id, \
	FQK_DEF((i_f) & 0xFFFFFFFF, (i_f) >> 32) \
	}

//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//	::::::::::::::::::::::::::::::::::::::::::::::::::::
//	::::::::::::::::::::::::::::::::::::::::::::::::::::
//	:::::::::::::+-----+-----+-----+-----+-----+::::::::
//	::::::::::::/  ?  .  ?  .  ?  .  ?  .  ?  /!::::::::
//	:::::::::::+.....+.....+.....+.....+.....+ !::::::::
//	::::::::::/  ?  .  ?  .  ?  .  ?  .  ?  /:?!::::::::
//	:::::::::+.....+.....+.....+-----+.....+ : +::::::::
//	::::::::/  ?  .  ?  /  ?  /  t  /  ?  /:?:.!::::::::
//	:::::::+-----+-----+-----+-----+-----+ : + !::::::::
//	:::::::!     :     :#### !#### !     !?:.:?!::::::::
//	:::::::!  ?  :  ?  :#### !#### !  ?  ! + : +::::::::
//	:::::::!     :     :#### !#### !     !/!?:.!::::::::
//	:::::::+-----------+ ### !#### +-----+ ! + !::::::::
//	:::::::!    #######! ### !###########!t!.:?!::::::::
//	:::::::!  #########! ### !###########! + : +::::::::
//	:::::::! ##########! ### !###########!/:?:.!::::::::
//	:::::::!#####+-----+-----+#### +-----+ : + !::::::::
//	:::::::!#### !     :     !#### !     !?:.:?!::::::::
//	:::::::!#### !  ?  :  ?  !#### !  ?  ! + : +::::::::
//	:::::::!#### !     :     !#### !     !/!?:/.::::::::
//	:::::::!#####+-----+.....!#####+-----+ ! +.:::::::::
//	:::::::!###########:     !###########!t!/.::::::::::
//	:::::::! ##########:  ?  ! ##########! +.:::::::::::
//	:::::::!   ########!     !   ########!/.::::::::::::
//	:::::::+-----------+-----+-----------+.:::::::::::::
//	::::::::::::::::::::::::::::::::::::::::::::::::::::
//	::::::::::::::::::::::::::::::::::::::::::::::::::::
//	XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

#define LSU_FIX_ANZ	2
LSU_E	aLSU_fix[LSU_FIX_ANZ] = {

LSU_E_DEF('c', 1, 'c', 0x750000000000000),
LSU_E_DEF('t',12, 't', 0x000F50000000000)

};   //-- Suchliste - fixe Teile (fuer c't-Logo)
#define pLSU_fix_0	aLSU_fix
#define pLSU_fix_n	(pLSU_fix_0 + LSU_FIX_ANZ)

#define LSU_ALT_ANZ	3
LSU_E	aLSU_alt[LSU_ALT_ANZ] = {

LSU_E_DEF('\'', 2, 's', 0x00C000040000600),
LSU_E_DEF('\'', 5, 'Q', 0x00C0000C4000000),
LSU_E_DEF('\'', 9, '~', 0x00C000088000000)

};   //-- suchliste - alternativ verwendbare Teile (fuer c't-Logo)
#define pLSU_alt_0	aLSU_alt
#define pLSU_alt_n	(pLSU_alt_0 + LSU_ALT_ANZ)

	//----------------------//
	// einzige Loesung	//
	// fuer c't-Logo	//
	//			//
	//	   wTQtd	//
	//	  ccQtt		//
	//	 cfft+		//
	//	ccstt		//
	//			//
	//	   wTQdd	//
	//	  wLQQ+		//
	//	 ff~~+		//
	//	sss~+		//
	//			//
	//	   TTTdd	//
	//	  wLLLL		//
	//	 wf~1+		//
	//	s1111		//
	//			//
	//----------------------//


//----------------------------------------------------------------
// Belegen von LLW mit den fixierten Teilen (des c't-Logos)

void ini_ct_logo(void) {

LSU_E* p;

for (p = pLSU_fix_0; p < pLSU_fix_n; p++) {
	LLW_INI_NXT(p->t, p->f);
}

}   //-- ini_ct_logo

//----------------------------------------------------------------
// Ueberpruefen, ob diese Loesung einen der alternativen
// Teile (des c't-Logos) in einer der angegebenen Positionen
// verwendet

int chk_ct_logo(LLW_E* pl_n) {

LLW_E* pl;
LSU_E* p;

//-- Durchsuchen des Loesungsweges, ob eines der alternativen
//   Teile in der angegebenen Position darin vorkommt

for (pl = pLLW_0; pl < pl_n; pl++) {
	for (p = pLSU_alt_0; p < pLSU_alt_n; p++) {
		if (FQK_EQU(p->f, pl->ft)) {
			return 1;
		}
	}
}
return 0;

}   //-- chk_ct_logo

//----------------------------------------------------------------
// Graphische Benutzeroberflaeche -
// Anleitung zur Loesung des c't-Puzzles mit passendem c't-Logo

#include <conio.h>

// B: Beginn, E: Ende
// U: Usage, T: Teil, F: Fuellung
//                       B   U   T         F         E
#define SCR_ANZ		(1 + 1 + 12 + (1 + 12 + 1) + 1)
char* aSCR[SCR_ANZ] = {

//----------------------------------------------------------------
//------------------------------BEG ------------------------------

"                    -----------------------------------------\n"
"                    3x4x5.EXE  --  (c)2003, Hannes G. Kuchler\n"
"                    -----------------------------------------\n"
"\n"
"                                   Anleitung\n"
"                           zur Loesung des c\'t-Puzzles\n"
"                             mit passendem c\'t-Logo\n"
"\n"
"                    !!!   Graphische Benutzeroberflaeche  !!!\n"
"                    !!!      im retro-extreme Design      !!!\n"
"                    !!!           und sogar 3D            !!!\n"
"\n"
"                                     +-----+\n"
"                                    /     /!\n"
"                                   +-----+ !\n"
"                                   !     ! !\n"
"                                   !     ! +\n"
"                                   !     !/\n"
"                                   +-----+\n"
"\n"
"                                   jeweils\n"
"                              Escape, um abzubrechen\n"
"                         Tastendruck, um fortzusetzen \n"
,

//----------------------------------------------------------------
//----------------------------- U-01 -----------------------------

"U-01\n"
"\n"
"\n"
"\n"
"+-----+ +---+       +----------------------------+\n"
"!  vt ! ! fq!       ! Legende zu den Tabellen    !\n"
"+=====+ +===+       +====+=======================+\n"
"!  c  ! !   !       ! vt ! Verwendung der Teile  !\n"
"!  s  ! !   !       ! fq ! Fuellung des Quaders  !\n"
"!  L  ! !   !       +----+-----------------------+\n"
"!  1  ! !   !\n"
"!  Q  ! !   !\n"
"!  T  ! !   !\n"
"!  d  ! !   !               +--------------------+\n"
"!  w  ! !   !               !    Cursortasten    !\n"
"!  ~  ! !   !               +====================+\n"
"!  f  ! !   !               ! vorige / naechste  !\n"
"!  +  ! !   !               !   erste / letzte   !\n"
"!  t  ! !   !               !      Ansicht       !\n"
"+-----+ +---+               +--------------------+\n"
"\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-01 -----------------------------

"T-01 - Teil (nr=01, id=\'c\', nk=5)\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+               +-----------+\n"
"!- c -! ! c !              /           /!\n"
"!  s  ! !   !             +-----------+ !\n"
"!  L  ! !   !             !    #######! !\n"
"!  1  ! !   !             !  #########! +\n"
"!  Q  ! !   !             ! ##########!/\n"
"!  T  ! !   !             !#####+-----+\n"
"!  d  ! !   !             !#### ! !\n"
"!  w  ! !   !             !#### ! +-----+\n"
"!  ~  ! !   !             !#### !/     /!\n"
"!  f  ! !   !             !#####+-----+ !\n"
"!  +  ! !   !             !###########! !\n"
"!  t  ! !   !             ! ##########! +\n"
"+-----+ +---+             !   ########!/\n"
"                          +-----------+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-02 -----------------------------

"T-02 - Teil (nr=02, id=\'s\', nk=5)\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+                     +-----------+\n"
"!  c  ! ! s !                    /xxxxx######/!\n"
"!- s -! !   !                   +-----------+ !\n"
"!  L  ! !   !                   !           ! !\n"
"!  1  ! !   !                   !           ! +\n"
"!  Q  ! !   !                   !           !/\n"
"!  T  ! !   !                   !     +-----+\n"
"!  d  ! !   !                   !     ! !\n"
"!  w  ! !   !               +---!     ! !\n"
"!  ~  ! !   !              /    !     ! !\n"
"!  f  ! !   !             +-----+     ! !\n"
"!  +  ! !   !             !           ! !\n"
"!  t  ! !   !             !           ! +\n"
"+-----+ +---+             !           !/\n"
"                          +-----------+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-03 -----------------------------

"T-03 - Teil (nr=03, id=\'L\', nk=5)\n"
"\n"
"                                  +-----+\n"
"                                 /     /!\n"
"+-----+ +---+                   +-----+ !\n"
"!  vt ! ! fq!                   !     ! !\n"
"+=====+ +===+                   !     ! !\n"
"!  c  ! ! L !                   !     ! !\n"
"!  s  ! !   !                   !     ! !\n"
"!- L -! !   !                   !     ! !\n"
"!  1  ! !   !                   !     ! !\n"
"!  Q  ! !   !                   !     ! !\n"
"!  T  ! !   !                   !     ! !\n"
"!  d  ! !   !                   !     ! !\n"
"!  w  ! !   !                   !     ! +-----+\n"
"!  ~  ! !   !                   !     !/     /!\n"
"!  f  ! !   !                   !     +-----+ !\n"
"!  +  ! !   !                   !           ! !\n"
"!  t  ! !   !                   !           ! +\n"
"+-----+ +---+                   !           !/\n"
"                                +-----------+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-04 -----------------------------

"T-04 - Teil (nr=04, id=\'1\', nk=5)\n"
"\n"
"                                  +-----+\n"
"                                 /     /!\n"
"+-----+ +---+                   +-----+ !\n"
"!  vt ! ! fq!                   !     ! !\n"
"+=====+ +===+               +---!     ! !\n"
"!  c  ! ! 1 !              /    !     ! !\n"
"!  s  ! !   !             +-----+     ! !\n"
"!  L  ! !   !             !           ! !\n"
"!- 1 -! !   !             !           ! !\n"
"!  Q  ! !   !             !           ! !\n"
"!  T  ! !   !             +-----+     ! !\n"
"!  d  ! !   !                   !     ! !\n"
"!  w  ! !   !                   !     ! !\n"
"!  ~  ! !   !                   !     ! !\n"
"!  f  ! !   !                   !     ! !\n"
"!  +  ! !   !                   !     ! !\n"
"!  t  ! !   !                   !     ! +\n"
"+-----+ +---+                   !     !/\n"
"                                +-----+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-05 -----------------------------

"T-05 - Teil (nr=05, id=\'Q\', nk=5)\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+\n"
"!  c  ! ! Q !\n"
"!  s  ! !   !                 +-----------+\n"
"!  L  ! !   !                /xxxxx######/!\n"
"!  1  ! !   !               +-----------+ !\n"
"!- Q -! !   !               !           ! !\n"
"!  T  ! !   !               !           ! !\n"
"!  d  ! !   !               !           ! !\n"
"!  w  ! !   !               +-----+     ! !\n"
"!  ~  ! !   !              /     /!     ! !\n"
"!  f  ! !   !             +-----+ !     ! !\n"
"!  +  ! !   !             !     ! !     !/\n"
"!  t  ! !   !             !     ! +-----+\n"
"+-----+ +---+             !     !/\n"
"                          +-----+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-06 -----------------------------

"T-06 - Teil (nr=06, id=\'T\', nk=5)\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+               +-----------------+\n"
"!  c  ! ! T !              /                 /!\n"
"!  s  ! !   !             +-----------------+ !\n"
"!  L  ! !   !             !                 ! !\n"
"!  1  ! !   !             !                 ! +\n"
"!  Q  ! !   !             !                 !/\n"
"!- T -! !   !             +-----+     +-----+\n"
"!  d  ! !   !                   !     ! !\n"
"!  w  ! !   !                   !     ! !\n"
"!  ~  ! !   !                   !     ! !\n"
"!  f  ! !   !                   !     ! !\n"
"!  +  ! !   !                   !     ! !\n"
"!  t  ! !   !                   !     ! +\n"
"+-----+ +---+                   !     !/\n"
"                                +-----+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-07 -----------------------------

"T-07 - Teil (nr=07, id=\'d\', nk=5)\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+                     +-----+\n"
"!  c  ! ! d !                    /     /!\n"
"!  s  ! !   !                   +-----+ !\n"
"!  L  ! !   !                   !     ! !\n"
"!  1  ! !   !               +---!     ! !\n"
"!  Q  ! !   !              /    !     ! !\n"
"!  T  ! !   !             +-----+     ! !\n"
"!- d -! !   !             !           ! !\n"
"!  w  ! !   !             !           ! !\n"
"!  ~  ! !   !             !           ! !\n"
"!  f  ! !   !             !           ! !\n"
"!  +  ! !   !             !           ! !\n"
"!  t  ! !   !             !           ! +\n"
"+-----+ +---+             !           !/\n"
"                          +-----------+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-08 -----------------------------

"T-08 - Teil (nr=08, id=\'w\', nk=5)\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+               +-----+\n"
"!  c  ! ! w !              /     /!\n"
"!  s  ! !   !             +-----+ !\n"
"!  L  ! !   !             !     ! !\n"
"!  1  ! !   !             !     ! +-----+\n"
"!  Q  ! !   !             !     !/     /!\n"
"!  T  ! !   !             !     +-----+ !\n"
"!  d  ! !   !             !           ! !\n"
"!- w -! !   !             !           ! +-----+\n"
"!  ~  ! !   !             !           !/     /!\n"
"!  f  ! !   !             +-----+     +-----+ !\n"
"!  +  ! !   !                   !           ! !\n"
"!  t  ! !   !                   !           ! +\n"
"+-----+ +---+                   !           !/\n"
"                                +-----------+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-09 -----------------------------

"T-09 - Teil (nr=09, id=\'~\', nk=4)\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+\n"
"!  c  ! ! ~ !\n"
"!  s  ! !   !                 +-----------+\n"
"!  L  ! !   !                /xxxxx######/!\n"
"!  1  ! !   !               +-----------+ !\n"
"!  Q  ! !   !               !           ! !\n"
"!  T  ! !   !               !           ! !\n"
"!  d  ! !   !               !           ! !\n"
"!  w  ! !   !               +-----+-----+ !\n"
"!- ~ -! !   !                    /     /  !\n"
"!  f  ! !   !                   +-----+   +\n"
"!  +  ! !   !                   !     !  /\n"
"!  t  ! !   !                   !     ! /\n"
"+-----+ +---+                   !     !/\n"
"                                +-----+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-10 -----------------------------

"T-10 - Teil (nr=10, id=\'f\', nk=5)\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+                     +-----------+\n"
"!  c  ! ! f !                    /           /!\n"
"!  s  ! !   !                   +-----------+ !\n"
"!  L  ! !   !                   !           ! !\n"
"!  1  ! !   !               +---!           ! +\n"
"!  Q  ! !   !              /    !           !/\n"
"!  T  ! !   !             +-----+     +-----+\n"
"!  d  ! !   !             !           ! !\n"
"!  w  ! !   !             !           ! !\n"
"!  ~  ! !   !             !           ! !\n"
"!- f -! !   !             +-----+     ! !\n"
"!  +  ! !   !                   !     ! !\n"
"!  t  ! !   !                   !     ! +\n"
"+-----+ +---+                   !     !/\n"
"                                +-----+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-11 -----------------------------

"T-11 - Teil (nr=11, id=\'+\', nk=5)\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+                     +-----+\n"
"!  c  ! ! + !                    /     /!\n"
"!  s  ! !   !                   +-----+ !\n"
"!  L  ! !   !                   !     ! !\n"
"!  1  ! !   !               +---!     ! +-----+\n"
"!  Q  ! !   !              /    !     !/     /!\n"
"!  T  ! !   !             +-----+     +-----+ !\n"
"!  d  ! !   !             !                 ! !\n"
"!  w  ! !   !             !                 ! +\n"
"!  ~  ! !   !             !                 !/\n"
"!  f  ! !   !             +-----+     +-----+\n"
"!- + -! !   !                   !     ! !\n"
"!  t  ! !   !                   !     ! +\n"
"+-----+ +---+                   !     !/\n"
"                                +-----+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- T-12 -----------------------------

"T-12 - Teil (nr=12, id=\'t\', nk=6)\n"
"\n"
"                                  +-----+\n"
"                                 /     /!\n"
"+-----+ +---+                   +-----+ !\n"
"!  vt ! ! fq!                   !#### ! !\n"
"+=====+ +===+                   !#### ! +-----+\n"
"!  c  ! ! t !                   !#### !/     /!\n"
"!  s  ! !   !                   !#### +-----+ !\n"
"!  L  ! !   !                   !###########! !\n"
"!  1  ! !   !                   !###########! +\n"
"!  Q  ! !   !                   !###########!/\n"
"!  T  ! !   !                   !#### +-----+\n"
"!  d  ! !   !                   !#### ! !\n"
"!  w  ! !   !                   !#### ! +-----+\n"
"!  ~  ! !   !                   !#### !/     /!\n"
"!  f  ! !   !                   !#####+-----+ !\n"
"!  +  ! !   !                   !###########! !\n"
"!- t -! !   !                   ! ##########! +\n"
"+-----+ +---+                   !   ########!/\n"
"                                +-----------+\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- F-00 -----------------------------

"F-00\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+\n"
"!  c  ! !   !\n"
"!  s  ! !   !\n"
"!  L  ! !   !\n"
"!  1  ! !   !\n"
"!  Q  ! !   !\n"
"!  T  ! !   !\n"
"!  d  ! !   !\n"
"!  w  ! !   !\n"
"!  ~  ! !   !\n"
"!  f  ! !   !\n"
"!  +  ! !   !\n"
"!  t  ! !   !\n"
"+-----+ +---+\n"
"\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- F-01 -----------------------------

"F-01\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+\n"
"!  c  ! !-1-!\n"
"!  s  ! !   !                               +-----+\n"
"!  L  ! !   !                              /  1  /!\n"
"!-*1*-! !   !                             +-----+ !\n"
"!  Q  ! !   !                             !     !1!\n"
"!  T  ! !   !                   +---------!  1  ! +-----+\n"
"!  d  ! !   !                  /  1     1 !     !/  1  /!\n"
"!  w  ! !   !                 +-----------+     +-----+ !\n"
"!  ~  ! !   !                 !                       !1!\n"
"!  f  ! !   !                 !  1     1     1     1  ! +\n"
"!  +  ! !   !                 !                       !/\n"
"!  t  ! !   !                 +-----------------------+\n"
"+-----+ +---+\n"
"\n"
"\n"
"\n"
,

//----------------------------------------------------------------
//----------------------------- F-02 -----------------------------

"F-02\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+\n"
"!  c  ! ! 1 !\n"
"!-*s*-! !-s-!                               +-----+\n"
"!  L  ! !   !                              /  1  /!\n"
"! *1* ! !   !                             +-----+ !\n"
"!  Q  ! !   !                             !     !1!\n"
"!  T  ! !   !             +-----+---------!  1  ! +-----+\n"
"!  d  ! !   !            /  s  /  1     1 !     !/  1  /!\n"
"!  w  ! !   !           /     +-----------+     +-----+ !\n"
"!  ~  ! !   !          /  s     s     s  /!           !1!\n"
"!  f  ! !   !         +-----------+     /#!  1     1  ! +\n"
"!  +  ! !   !         !          /  s  /##!           !/\n"
"!  t  ! !   !         !  s     s+-----+## +-----------+\n"
"+-----+ +---+         !         !     !##/\n"
"                      +---------!  s  !#/\n"
"                                !     !/\n"
"                                +-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-03 -----------------------------

"F-03\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+\n"
"!  c  ! ! 1 !\n"
"! *s* ! ! s !                         +-----+-----+\n"
"!  L  ! !-~-!                        /  ~  /  1  /!\n"
"! *1* ! !   !                       /     +-----+ !\n"
"!  Q  ! !   !                      /  ~     ~  /!1!\n"
"!  T  ! !   !             +-----+-+-----------+#! +-----+\n"
"!  d  ! !   !            /  s  /  !           !#!/  1  /!\n"
"!  w  ! !   !           /     +---!  ~     ~  !#!-----+ !\n"
"!-*~*-! !   !          /  s       !           !#!     !1!\n"
"!  f  ! !   !         +-----------+-----+     !x!  1  ! +\n"
"!  +  ! !   !         !          /  s  /!     !x!     !/\n"
"!  t  ! !   !         !  s     s+-----+#!  ~  !x+-----+\n"
"+-----+ +---+         !         !     !#!     !/\n"
"                      +---------!  s  !#+-----+\n"
"                                !     !/\n"
"                                +-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-04 -----------------------------

"F-04\n"
"\n"
"\n"
"\n"
"+-----+ +---+\n"
"!  vt ! ! fq!\n"
"+=====+ +===+\n"
"!  c  ! ! 1 !\n"
"! *s* ! ! s !                   +-----+-----+-----+\n"
"!  L  ! ! ~ !                  /  f  /  ~  /  1  /!\n"
"! *1* ! !-f-!           +-----+     /     +-----+ !\n"
"!  Q  ! !   !          /  f     f  /  ~     ~  /!1!\n"
"!  T  ! !   !         +-----+     +-----+-----+#! +-----+\n"
"!  d  ! !   !         !    /  f     f  /!     !#!/  1  /!\n"
"!  w  ! !   !         !  f+-----------+ !  ~  !#!-----+ !\n"
"! *~* ! !   !         !   !           !f!     !#!     !1!\n"
"!-*f*-! !   !         +---!  f     f  ! +     !x!  1  ! +\n"
"!  +  ! !   !         !   !           !/!     !x!     !/\n"
"!  t  ! !   !         !  s+-----------+#!  ~  !x+-----+\n"
"+-----+ +---+         !         !     !#!     !/\n"
"                      +---------!  s  !#+-----+\n"
"                                !     !/\n"
"                                +-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-05 -----------------------------

"F-05\n"
"\n"
"                        +-----+\n"
"                       /  w  /!\n"
"+-----+ +---+         /     / !-+\n"
"!  vt ! ! fq!        /  w  / w!/!\n"
"+=====+ +===+       +-----+   + !\n"
"!  c  ! ! 1 !       !     !w   w!\n"
"! *s* ! ! s !       !  w  ! +   +-----+-----+-----+\n"
"!  L  ! ! ~ !       !     !/!w /  f  /  ~  /  1  /!\n"
"! *1* ! ! f !       +-----+ ! +     /     +-----+ !\n"
"!  Q  ! !-w-!         !     !/  f  /  ~     ~  /!1!\n"
"!  T  ! !   !         +-----+     +-----+-----+#! +-----+\n"
"!  d  ! !   !         !    /  f     f  /!     !#!/  1  /!\n"
"!-*w*-! !   !         !  f+-----------+ !  ~  !#!-----+ !\n"
"! *~* ! !   !         !   !           !f!     !#!     !1!\n"
"! *f* ! !   !         +---!  f     f  ! +     !x!  1  ! +\n"
"!  +  ! !   !         !   !           !/!     !x!     !/\n"
"!  t  ! !   !         !  s+-----------+#!  ~  !x+-----+\n"
"+-----+ +---+         !         !     !#!     !/\n"
"                      +---------!  s  !#+-----+\n"
"                                !     !/\n"
"                                +-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-06 -----------------------------

"F-06\n"
"\n"
"                        +-----+\n"
"                       /  w  /!\n"
"+-----+ +---+         /     / !-+-----------------------+\n"
"!  vt ! ! fq!        /  w  / w!/  L     L     L     L  /!\n"
"+=====+ +===+       +-----+   /     +-----------------+ !\n"
"!  c  ! ! 1 !       !     !w /  L  /!                 !L!\n"
"! *s* ! ! s !       !  w  ! +-----+ !  L     L     L  ! +\n"
"!-*L*-! ! ~ !       !     !/!     !L!                 !/\n"
"! *1* ! ! f !       +-----+ !  L  ! +-----------+-----+\n"
"!  Q  ! ! w !         !     !     !/  ~     ~  /!1!\n"
"!  T  ! !-L-!         +-----+-----+-----+-----+#! +-----+\n"
"!  d  ! !   !         !    /  f     f  /!     !#!/  1  /!\n"
"! *w* ! !   !         !  f+-----------+ !  ~  !#!-----+ !\n"
"! *~* ! !   !         !   !           !f!     !#!     !1!\n"
"! *f* ! !   !         +---!  f     f  ! +     !x!  1  ! +\n"
"!  +  ! !   !         !   !           !/!     !x!     !/\n"
"!  t  ! !   !         !  s+-----------+#!  ~  !x+-----+\n"
"+-----+ +---+         !         !     !#!     !/\n"
"                      +---------!  s  !#+-----+\n"
"                                !     !/\n"
"                                +-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-07 -----------------------------

"F-07                      +-----------------+\n"
"                         /  T     T     T  /!\n"
"                        +-----+     +-----+ !\n"
"                       /  w  /  T  /!     !T!\n"
"+-----+ +---+         /     /     / !  T  ! +-----------+\n"
"!  vt ! ! fq!        /  w  /  T  / T!     !/  L     L  /!\n"
"+=====+ +===+       +-----+-----+   +-----+-----------+ !\n"
"!  c  ! ! 1 !       !     !     !T /!                 !L!\n"
"! *s* ! ! s !       !  w  !  T  ! / !  L     L     L  ! +\n"
"! *L* ! ! ~ !       !     !     !/!L!                 !/\n"
"! *1* ! ! f !       +-----+-----+ ! +-----------+-----+\n"
"!  Q  ! ! w !         !     !     !/  ~     ~  /!1!\n"
"!-*T*-! ! L !         +-----+-----+-----+-----+#! +-----+\n"
"!  d  ! !-T-!         !    /  f     f  /!     !#!/  1  /!\n"
"! *w* ! !   !         !  f+-----------+ !  ~  !#!-----+ !\n"
"! *~* ! !   !         !   !           !f!     !#!     !1!\n"
"! *f* ! !   !         +---!  f     f  ! +     !x!  1  ! +\n"
"!  +  ! !   !         !   !           !/!     !x!     !/\n"
"!  t  ! !   !         !  s+-----------+#!  ~  !x+-----+\n"
"+-----+ +---+         !         !     !#!     !/\n"
"                      +---------!  s  !#+-----+\n"
"                                !     !/\n"
"                                +-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-08 -----------------------------

"F-08                      +-----------------+\n"
"                         /  T     T     T  /!\n"
"                        +-----+     +-----+ !\n"
"                       /  w  /  T  /!     !T!\n"
"+-----+ +---+         /     /     / !  T  ! +-----------+\n"
"!  vt ! ! fq!        /  w  /  T  / T!     !/  L     L  /!\n"
"+=====+ +===+       +-----+-----+   +-----+-----+-----+ !\n"
"!  c  ! ! 1 !       !     !     !T /!          /  +  /!L!\n"
"! *s* ! ! s !       !  w  !  T  ! / !  L     L+-----+ ! +\n"
"! *L* ! ! ~ !       !     !     !/!L!         !     !+!/!\n"
"! *1* ! ! f !       +-----+-----+ ! +---------!  +  ! + !\n"
"!  Q  ! ! w !         !     !     !/  ~     ~ !     !  +!\n"
"! *T* ! ! L !         +-----+-----+-----+-----+-----+   +\n"
"!  d  ! ! T !         !    /  f     f  /!    /  +  / + /!\n"
"! *w* ! !-+-!         !  f+-----------+ !  ~+-----+   + !\n"
"! *~* ! !   !         !   !           !f!   !     !+  !1!\n"
"! *f* ! !   !         +---!  f     f  ! +   !  +  ! + ! +\n"
"!-*+*-! !   !         !   !           !/!   !     !/!+!/\n"
"!  t  ! !   !         !  s+-----------+#!  ~+-----+ ! +\n"
"+-----+ +---+         !         !     !#!     !     !/\n"
"                      +---------!  s  !#+-----+-----+\n"
"                                !     !/\n"
"                                +-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-09 -----------------------------

"F-09                      +-----------------+-----------+\n"
"                         /  T     T     T  /  d     d  /!\n"
"                        +-----+     +-----/           / !\n"
"                       /  w  /  T  /!    /  d     d  / d!\n"
"+-----+ +---+         /     /     / !  T+-----+     /   +\n"
"!  vt ! ! fq!        /  w  /  T  / T!   !    /  d  / d /!\n"
"+=====+ +===+       +-----+-----+   +---!  d+-----+   / !\n"
"!  c  ! ! 1 !       !     !     !T /!   !   !     !d /!L!\n"
"! *s* ! ! s !       !  w  !  T  ! / !  L+---!  d  ! / ! +\n"
"! *L* ! ! ~ !       !     !     !/!L!       !     !/!+!/!\n"
"! *1* ! ! f !       +-----+-----+ ! +-------+-----+ ! + !\n"
"!  Q  ! ! w !         !     !     !/  ~     ~ !     !  +!\n"
"! *T* ! ! L !         +-----+-----+-----+-----+-----+   +\n"
"!-*d*-! ! T !         !    /  f     f  /!    /  +  / + /!\n"
"! *w* ! ! + !         !  f+-----------+ !  ~+-----+   + !\n"
"! *~* ! !-d-!         !   !           !f!   !     !+  !1!\n"
"! *f* ! !   !         +---!  f     f  ! +   !  +  ! + ! +\n"
"! *+* ! !   !         !   !           !/!   !     !/!+!/\n"
"!  t  ! !   !         !  s+-----------+#!  ~+-----+ ! +\n"
"+-----+ +---+         !         !     !#!     !     !/\n"
"                      +---------!  s  !#+-----+-----+\n"
"                                !     !/\n"
"                                +-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-10 -----------------------------

"F-10                      +-----------------+-----------+\n"
"                         /  T     T     T  /  d     d  /!\n"
"                        +-----+     +-----/           / !\n"
"                       /  w  /  T  /!    /  d     d  / d!\n"
"+-----+ +---+         /     /     / !  T+-----+     /   +\n"
"!  vt ! ! fq!        /  w  /  T  / T!   !    /  d  / d /!\n"
"+=====+ +===+       +-----+-----+   +---!  d+-----+   / !\n"
"!-*c*-! ! 1 !       !     !     !T /!   !   !     !d /!L!\n"
"! *s* ! ! s !       !  w  !  T  ! / !  L+---!  d  ! / ! +\n"
"! *L* ! ! ~ !       !     !     !/!L!       !     !/!+!/!\n"
"! *1* ! ! f !       +-----+-----+ ! +-------+-----+ ! + !\n"
"!  Q  ! ! w !       !    #######!c!/  ~     ~ !     !  +!\n"
"! *T* ! ! L !       !  #########! +-----+-----+-----+   +\n"
"! *d* ! ! T !       ! ##########!/  f  /!    /  +  / + /!\n"
"! *w* ! ! + !       !#####+-----+-----+ !  ~+-----+   + !\n"
"! *~* ! ! d !       !#### !           !f!   !     !+  !1!\n"
"! *f* ! !-c-!       !#### !  f     f  ! +   !  +  ! + ! +\n"
"! *+* ! !   !       !#### !           !/!   !     !/!+!/\n"
"!  t  ! !   !       !#####+-----------+#!  ~+-----+ ! +\n"
"+-----+ +---+       !###########!     !#!     !     !/\n"
"                    ! ##########!  s  !#+-----+-----+\n"
"                    !   ########!     !/\n"
"                    +-----------+-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-11 -----------------------------

"F-11                      +-----------------+-----------+\n"
"                         /  T     T     T  /  d     d  /!\n"
"                        +-----+     +-----/           / !\n"
"                       /  w  /  T  /  Q  /  d     d  / d!\n"
"+-----+ +---+         /     /     /     +-----+     /   +\n"
"!  vt ! ! fq!        /  w  /  T  /  Q  /!    /  d  / d /!\n"
"+=====+ +===+       +-----+-----+-----+ !  d+-----+   / !\n"
"! *c* ! ! 1 !       !     !     !#### !Q!   !     !d /!L!\n"
"! *s* ! ! s !       !  w  !  T  !#### ! +---!  d  ! / ! +\n"
"! *L* ! ! ~ !       !     !     !#### ! !   !     !/!+!/!\n"
"! *1* ! ! f !       +-----+-----! ### ! !  Q+-----+ ! + !\n"
"!-*Q*-! ! w !       !    #######! ### !Q!     !     !  +!\n"
"! *T* ! ! L !       !  #########! ### ! +-----+-----+   +\n"
"! *d* ! ! T !       ! ##########! ### !/!    /  +  / + /!\n"
"! *w* ! ! + !       !#####+-----+-----+ !  ~+-----+   + !\n"
"! *~* ! ! d !       !#### !           !f!   !     !+  !1!\n"
"! *f* ! ! c !       !#### !  f     f  ! +   !  +  ! + ! +\n"
"! *+* ! !-Q-!       !#### !           !/!   !     !/!+!/\n"
"!  t  ! !   !       !#####+-----------+#!  ~+-----+ ! +\n"
"+-----+ +---+       !###########!     !#!     !     !/\n"
"                    ! ##########!  s  !#+-----+-----+\n"
"                    !   ########!     !/\n"
"                    +-----------+-----+\n"
,

//----------------------------------------------------------------
//----------------------------- F-12 -----------------------------

"F-12                      +-----------------+-----------+\n"
"                         /  T     T     T  /  d     d  /!\n"
"                        +-----+     +-----/           / !\n"
"                       /  w  /  T  /  Q  /  d     d  / d!\n"
"+-----+ +---+         /     /     /     +-----+     /   +\n"
"!  vt ! ! fq!        /  w  /  T  /  Q  /  t  /  d  / d /!\n"
"+=====+ +===+       +-----+-----+-----+-----+-----+   / !\n"
"! *c* ! ! 1 !       !     !     !#### !#### !     !d /!L!\n"
"! *s* ! ! s !       !  w  !  T  !#### !#### !  d  ! / ! +\n"
"! *L* ! ! ~ !       !     !     !#### !#### !     !/!+!/!\n"
"! *1* ! ! f !       +-----+-----! ### !#### +-----+ ! + !\n"
"! *Q* ! ! w !       !    #######! ### !###########!t!  +!\n"
"! *T* ! ! L !       !  #########! ### !###########! +   +\n"
"! *d* ! ! T !       ! ##########! ### !###########!/ + /!\n"
"! *w* ! ! + !       !#####+-----+-----!#### +-----+   + !\n"
"! *~* ! ! d !       !#### !           !#### !     !+  !1!\n"
"! *f* ! ! c !       !#### !  f     f  !#### !  +  ! + ! +\n"
"! *+* ! ! Q !       !#### !           !#### !     !/!+!/\n"
"!-*t*-! !-t-!       !#####+-----------!#####+-----+ ! +\n"
"+-----+ +---+       !###########!     !###########!t!/\n"
"                    ! ##########!  s  ! ##########! +\n"
"                    !   ########!     !   ########!/\n"
"                    +-----------+-----+-----------+\n"
,

//----------------------------------------------------------------
//----------------------------- F-XX -----------------------------

"F-XX                      +-----------------+-----------+\n"
"                         /  T     T     T  /  d     d  /!\n"
"                        +-----+     +-----/           / !\n"
"                       /  w  /  T  /  Q  /  d     d  / d!\n"
"+-----+ +---+         /     /     /     +-----+     /   +\n"
"!  vt ! ! fq!        /  w  /  T  /  Q  /  t  /  d  / d /!\n"
"+=====+ +===+       +-----+-----+-----+-----+-----+   / !\n"
"! *c* ! ! 1 !       !     !     !#### !#### !     !d /!L!\n"
"! *s* ! ! s !       !  w  !  T  !#### !#### !  d  ! / ! +\n"
"! *L* ! ! ~ !       !     !     !#### !#### !     !/!+!/!\n"
"! *1* ! ! f !       +-----+-----! ### !#### +-----+ ! + !\n"
"! *Q* ! ! w !       !    #######! ### !###########!t!  +!\n"
"! *T* ! ! L !       !  #########! ### !###########! +   +\n"
"! *d* ! ! T !       ! ##########! ### !###########!/ + /!\n"
"! *w* ! ! + !       !#####+-----+-----!#### +-----+   + !\n"
"! *~* ! ! d ! +---------------------------------------------+\n"
"! *f* ! ! c ! ! Der 3 x 4 x 5 - Quader aus den 12 Teilen    !\n"
"! *+* ! ! Q ! ! nun so zusammengestellt, dass das c\'t-Logo  !\n"
"! *t* ! ! t ! ! auf der Vorderseite erscheint               !\n"
"+-----+ +---+ +---------------------------------------------+\n"
"                    ! ##########!  s  ! ##########! +\n"
"                    !   ########!     !   ########!/\n"
"                    +-----------+-----+-----------+\n"
,

//----------------------------------------------------------------
//----------------------------- END ------------------------------

"                          +-----------------+-----------+\n"
"                         /                 /           /!\n"
"                        +-----+     +-----/           / !\n"
"                       /     /     /     /           /  !\n"
"                      /     /     /     +-----+     /   +\n"
"                     /     /     /     /     /     /   /!\n"
"                    +-----+-----+-----+-----+-----+   / !\n"
"                    !     !     !#### !#### !     !  /! !\n"
"                    !     !     !#### !#### !     ! / ! +\n"
"                    !     !     !#### !#### !     !/! !/!\n"
"                    +-----+-----! ### !#### +-----+ ! + !\n"
"                    !    #######! ### !###########! !   !\n"
"                    !  #########! ### !###########! +   +\n"
"                    ! ##########! ### !###########!/   /!\n"
"                    !#####+-----+-----!#### +-----+   + !\n"
"                    !#### !           !#### !     !   ! !\n"
"                    !#### !           !#### !     ! + ! +\n"
"                    !#### !           !#### !     !/! !/\n"
"                    !#####+-----------!#####+-----+ ! +\n"
"                    !###########!     !###########! !/\n"
"                    ! ##########!     ! ##########! +\n"
"                    !   ########!     !   ########!/\n"
"                    +-----------+-----+-----------+"

};

//----------------------------------------------------------------

#define pSCR_ini	aSCR
#define pSCR_0		(pSCR_ini + 1)
#define pSCR_n		(pSCR_ini + SCR_ANZ)

//----------------------------------------------------------------

void gui_ct_logo(void) {

int c;
char** p = pSCR_ini;

for ( ; ; ) {
	clrscr();
	puts(*p);
	c = getch();
	if (c == 27) {
		//-- fertig
		break;
	}
	switch(c) {
	case 0:
		switch(c = getch()) {
		case 71:	//-- pos1
			p = pSCR_0;
			break;
		case 79:	//-- end
			p = pSCR_n - 1;
			break;
		case 72:	//-- up
		case 73:	//-- page up
		case 75:	//-- left
			p--;
			break;
		case 77:	//-- right
		case 80:	//-- down
		case 81:	//-- page down
			p++;
			break;
		}
		break;
	default:
		p++;
		break;
	}
	if (p < pSCR_0) {
		// Vor dem ersten Bild: stopp
		p = pSCR_0;
	}
	if (p >= pSCR_n) {
		//-- Nach dem letzten Bild: fertig
		break;
	}
}

clrscr();
puts(*(pSCR_n - 1));

}   //-- gui_ct_logo

//----------------------------------------------------------------
// Statistik

#if defined(CCC_MIT_STATISTIK)

U64 puzzle_solve_rek_cnt;
U64 puzzle_solve_rek_cnt_l;
U32 puzzle_solved_cnt;
U32 puzzle_solved_cnt_l;
U64 stat_no_fill_h;
U64 stat_no_fill_l;
U64 stat_no_fill_h_and_l;

#define STATISTIK_BEG() \
	{ \
	puzzle_solve_rek_cnt   = 0; \
	puzzle_solve_rek_cnt_l = 0; \
	puzzle_solved_cnt   = 0; \
	puzzle_solved_cnt_l = 0; \
	stat_no_fill_h = 0; \
	stat_no_fill_l = 0; \
	stat_no_fill_h_and_l = 0; \
	}

#define STATISTIK_END() \
	{ \
	printf("stat> puzzle_solve_rek_cnt=%ld(%ld)/" \
		"_l=%ld(%ld)\n", \
		(*(((U32*)(&puzzle_solve_rek_cnt  ))  )), \
		(*(((U32*)(&puzzle_solve_rek_cnt  ))+1)), \
		(*(((U32*)(&puzzle_solve_rek_cnt_l))  )), \
		(*(((U32*)(&puzzle_solve_rek_cnt_l))+1))); \
	printf("stat> puzzle_solved_cnt=%ld/_l=%ld\n", \
		puzzle_solved_cnt, \
		puzzle_solved_cnt_l); \
	printf("stat> no_fill_h=%ld(%ld)/" \
		"_l=%ld(%ld)/_h_and_l=%ld(%ld)\n", \
		(*(((U32*)(&stat_no_fill_h      ))  )), \
		(*(((U32*)(&stat_no_fill_h      ))+1)), \
		(*(((U32*)(&stat_no_fill_l      ))  )), \
		(*(((U32*)(&stat_no_fill_l      ))+1)), \
		(*(((U32*)(&stat_no_fill_h_and_l))  )), \
		(*(((U32*)(&stat_no_fill_h_and_l))+1))); \
	printf("stat> Anzahl der Loesungen: %ld\n", \
		Anzahl_der_Loesungen); \
	}

#define STATISTIK_INC_SOLVED() \
	{ puzzle_solved_cnt++; }
#define STATISTIK_INC_SOLVED_L() \
	{ puzzle_solved_cnt_l++; }
#define STATISTIK_INC_REK() \
	{ puzzle_solve_rek_cnt++; }
#define STATISTIK_INC_REK_L() \
	{ puzzle_solve_rek_cnt_l++; }
#define STATISTIK_FQK_FILL_OK(f1, f2) \
	{ \
	if (((f1).h & (f2).h) != 0) { \
		stat_no_fill_h++; \
	} \
	if (((f1).l & (f2).l) != 0) { \
		stat_no_fill_l++;\
	} \
	if ((((f1).h & (f2).h) != 0) && \
	    (((f1).l & (f2).l) != 0)) { \
		stat_no_fill_h_and_l++; \
	} \
	}

#else

#define STATISTIK_BEG()			;
#define STATISTIK_END()			;
#define STATISTIK_INC_SOLVED()		;
#define STATISTIK_INC_SOLVED_L()	;
#define STATISTIK_INC_REK()		;
#define STATISTIK_INC_REK_L()		;
#define STATISTIK_FQK_FILL_OK(f1, f2)	;

#endif

//----------------------------------------------------------------
// Loesen des Puzzles (Endergebnis)

void puzzle_solve_E(void) {

char ln[81];

while (fgets(ln, sizeof(ln) - 1, stdin) > 0) {
	if (isdigit(ln[0])) {
		Anzahl_der_Loesungen += atol(ln);
	}
	else {
		ON_ERR_RET(0x1401,
			 (strncmp(ln, "Fehler", 6) == 0));
	}
}

}   //-- puzzle_solve_E

//----------------------------------------------------------------
// Loesen des Puzzles

void puzzle_solve_3x4x5_rek(LLW_E* pl);

void puzzle_solve_3x4x5(void) {
	
STATISTIK_BEG();

//-- Initialisieren fuer das Ermitteln der Loesungen
LLW_INI();
if (opt == OPT_CT_LOGO) {
	ini_ct_logo();
}

out_M_init();
puzzle_solve_3x4x5_rek(pLLW_i + 1);
out_M_exit();

STATISTIK_END();

}   //-- puzzle_solve_3x4x5

//----------------------------------------------------------------
// Loesen des Puzzles (entsprechend Option)

void puzzle_solve(void) {

//-- Im Fehlerfalle die Funktion verlassen
if (err_code != 0) return;

Anzahl_der_Loesungen_erw =
	((opt == OPT_TEILERGEBNIS)
	 ? (aErwAnz[opt_tn_bis + 1] -
	    aErwAnz[opt_tn_von])
	 : ((opt == OPT_CT_LOGO)
	    ? 1
	    : ERW_ANZ));
#if defined(CCC_BIS_ANZ_LOESUNGEN)
if (opt == OPT_TEILERGEBNIS) {
	if (Anzahl_der_Loesungen_erw > ERW_ANZ) {
		Anzahl_der_Loesungen_erw = ERW_ANZ;
	}
}
if (opt == OPT_ENDERGEBNIS) {
	//-- Summieren der Teilergebnisse
	int i;
	Anzahl_der_Loesungen_erw = 0;
	for (i = 0; i < T_ANZ; i++) {
		int adle = (aErwAnz[i + 1] -
		            aErwAnz[i]);
		Anzahl_der_Loesungen_erw +=
			(adle < ERW_ANZ)
			  ? adle
			  : ERW_ANZ;
	}
	//-- Da obiges nur funktioniert, falls in einem
	//   vorhergehenden Durchgang von den Teilergebnissen
	//   keine Gruppen gebildet (und das weiss man
	//   an dieser Stelle leider nicht), habe ich
	//   es wieder deaktiviert
 	Anzahl_der_Loesungen_erw = -1;
}
#endif

switch(opt) {
	
case OPT_ALLES:
case OPT_CT_LOGO:
case OPT_TEILERGEBNIS:
	puzzle_solve_3x4x5();
	break;
	
case OPT_ENDERGEBNIS:
	puzzle_solve_E();
	break;
}

}   //-- puzzle_solve

//----------------------------------------------------------------
// Falls eine Loesung gefunden worden ist

void puzzle_solved(LLW_E* pl) {

if (opt == OPT_CT_LOGO) {
	if (chk_ct_logo(pl)) {
		// Hier zaehlen nur die Loesungen,
		// bei denen auch einer der als alternativ
		// angegebenen Teile seine entsprechende
		// Position hat
		Anzahl_der_Loesungen++;
		prn_LLW_3D(pl);
	}
}
else {
	Anzahl_der_Loesungen++;
	out_M();
#if defined(CCC_MIT_PRN_LLW)
	printf("\"%s\"\t// <- %ld\n",
		LLWtoa(pl), Anzahl_der_Loesungen);
#endif   //-- CCC_MIT_PRN_LLW
}
ON_TST_RET(0x1501, !FQK_EQU(FQK_all, (pl - 1)->f));

#if defined(CCC_BIS_ANZ_LOESUNGEN)
if (Anzahl_der_Loesungen >= CCC_BIS_ANZ_LOESUNGEN) {
	err_code = 0xDEAD;
	return;
}
#endif

}   //-- puzzle_solved

//----------------------------------------------------------------
// Ermitteln der Loesungen - Rekursionsteil

void puzzle_solve_3x4x5_rek_l(LLW_E* pl);

void puzzle_solve_3x4x5_rek(LLW_E* pl) {

int	k_idx;

STATISTIK_INC_REK();

ON_TST_RET(0x1601, (pl >= pLLW_m));
ON_TST_RET(0x1602, ((pl - 1) < pLLW_ini));
ON_TST_RET(0x1603, ((pl - 1)->v == LVT_ALL))

{
//-- Ermitteln des neuen k
register int	reg_k;
register U32	reg_m_k;
reg_k   = (pl - 1)->k - 1;
reg_m_k = (pl - 1)->m_k >> 1;

if (reg_m_k == 0) {
	goto label_k_crossed_32;
}
if (reg_k >= 32) {
	{
	register U32 reg_f_h = (pl - 1)->f.h;
	while (reg_f_h & reg_m_k) {
		reg_k--;
		reg_m_k >>= 1;
	}
	}   //-- reg_f_h
	if (reg_k < 32) {
label_k_crossed_32:
		reg_m_k = 0x80000000;
		{
		register U32 reg_f_l = (pl - 1)->f.l;
		while (reg_f_l & reg_m_k) {
			reg_k--;
			reg_m_k >>= 1;
		}
		}   //-- reg_f_l
		k_idx = (K_Q_ANZ - 1) - (pl->k = reg_k);
		pl->m_k = reg_m_k;
		goto label_k_lt_32;
	}
	else {
		k_idx = (K_Q_ANZ - 1) - (pl->k = reg_k);
		pl->m_k = reg_m_k;
		goto label_k_ge_32;
	}
}
else {
	{
	register U32 reg_f_l = (pl - 1)->f.l;
	while (reg_f_l & reg_m_k) {
		reg_k--;
		reg_m_k >>= 1;
	}
	}   //-- reg_f_l
	k_idx = (K_Q_ANZ - 1) - (pl->k = reg_k);
	pl->m_k = reg_m_k;
	goto label_k_lt_32;
}
}   //-- reg_k, reg_m_k

{
register int reg_t;
register LVT reg_m_v;

//if (pl->k >= 32)	//-- Ueberpruefung wird uebersprungen
{
	
label_k_ge_32:
	
	//-- QFK.h und QFK.l
	reg_t = 0;
	reg_m_v = 1;
	
	for ( ; ; ) {
		//-- Naechsten verfuegbaren Teil ermitteln
		//   (vielleicht ist es ja schon dieser)
		{
		register LVT reg_v1 = (pl - 1)->v;
		while (reg_v1 & reg_m_v) {
			reg_m_v <<= 1; reg_t++;
		}
		}   //-- reg_v1;
		
		//-- Gibt es noch einen Teil zum Fuellen ?
		if (reg_t < T_ANZ) {
			//-- Gibt es zu diesem Teil Positionen,
			//   die den aktuellen Kubus als
			//   ersten besetzen ?
			//   (und davor nichts, denn das ist
			//    alles ja bereits vollgefuellt)
			register FQK*
			reg_p = pPPLF_0[reg_t][k_idx];
			if (reg_p != NULL) {
				//-- Fuer alle in Frage kommenden
				//   Positionen diese Teiles
				do {
//-------- >> 5 - BEG --------
STATISTIK_FQK_FILL_OK((pl - 1)->f, *reg_p);
//-- Ueberpruefen, ob Fuellung ok
if ((((pl - 1)->f.l & reg_p->l) == 0) &&
    (((pl - 1)->f.h & reg_p->h) == 0)) {
	//-- Dieser Teil kann an dieser Position in den
	//   Quader eingesetzt werden
	pl->t = reg_t;
	//-- Ermitteln des neuen f
	pl->f.h = ((pl - 1)->f.h | (pl->ft.h = reg_p->h));
	pl->f.l = ((pl - 1)->f.l | (pl->ft.l = reg_p->l));
	//-- Ermitteln des neuen v
	pl->v = (pl - 1)->v | reg_m_v;
	if (pl->v == LVT_ALL) {
	//if (pl == pLLW_solved) {
		STATISTIK_INC_SOLVED();
		puzzle_solved(pl + 1);
		//-- An diese Stelle passt beim c't-Puzzle
		//   keiner der anderen Teil mehr - also
		return;
	}
	else {
		//-- Auf ein neues ...
		puzzle_solve_3x4x5_rek(pl + 1);
#if defined(CCC_BIS_ANZ_LOESUNGEN)
		ON_ERR_RET(err_code, (err_code != 0));
#else
		ON_TST_RET(err_code, (err_code != 0));
#endif
	}
}
//-------- >> 5 - END --------
				//-- Naechste Position in Liste
				reg_p++;
				//-- Pruefen der Position
				//   mittels Waechter
				} while (reg_p->h);
			}
		}
		else {
			//-- Bereits alle Teile versucht
			break;
		}
		//-- Naechster Teil
		reg_m_v <<= 1; reg_t++;
	}
return;
}
//else	//-- Ueberpruefung wird uebersprungen
{
	
label_k_lt_32:
	//-- Ausschliesslich QFK.l
	reg_t = 0;
	reg_m_v = 1;
	
	ON_TST_RET(0x1604, ((pl - 1)->f.h != FQK_ALL_H));
	pl->f.h  = FQK_ALL_H;
	pl->ft.h = FQK_NONE_H;
	for ( ; ; ) {
		//-- Naechsten verfuegbaren Teil ermitteln
		//   (vielleicht ist es ja schon dieser)
		{
		register LVT reg_v1 = (pl - 1)->v;
		while (reg_v1 & reg_m_v) {
			reg_m_v <<= 1; reg_t++;
		}
		}   //-- reg_v1;
		
		//-- Gibt es noch einen Teil zum Fuellen ?
		if (reg_t < T_ANZ) {
			//-- Gibt es zu diesem Teil Positionen,
			//   die den aktuellen Kubus als
			//   ersten besetzen ?
			//   (und davor nichts, denn das ist
			//    alles ja bereits vollgefuellt)
			register FQK*
			reg_p = pPPLF_0[reg_t][k_idx];
			if (reg_p != NULL) {
				//-- Fuer alle in Frage kommenden
				//   Positionen diese Teiles
				do {
//-------- >> 5 - BEG --------
if (((pl - 1)->f.l & reg_p->l) == 0) {
	//-- Dieser Teil kann an dieser Position in den
	//   Quader eingesetzt werden
	pl->t = reg_t;
	//-- Ermitteln des neuen f
	pl->f.l = ((pl - 1)->f.l | (pl->ft.l = reg_p->l));
	//-- Ermitteln des neuen v
	pl->v = (pl - 1)->v | reg_m_v;
	if (pl->v == LVT_ALL) {
	//if (pl == pLLW_solved) {
		STATISTIK_INC_SOLVED();
		puzzle_solved(pl + 1);
		//-- An diese Stelle passt beim c't-Puzzle
		//   keiner der anderen Teil mehr - also
		return;
	}
	else {
		//-- Auf ein neues ...
#if defined(CCC_MIT_SOLVE_3x4x5_REK_L)
		puzzle_solve_3x4x5_rek_l(pl + 1);
#else
		puzzle_solve_3x4x5_rek(pl + 1);
#endif
#if defined(CCC_BIS_ANZ_LOESUNGEN)
		ON_ERR_RET(err_code, (err_code != 0));
#else
		ON_TST_RET(err_code, (err_code != 0));
#endif
	}
}
//-------- >> 5 - END --------
				//-- Naechste Position in Liste
				reg_p++;
				//-- Pruefen der Position
				//   mittels Waechter
				} while (reg_p->l);
			}
		}
		else {
			//-- Bereits alle Teile versucht
			break;
		}
		//-- Naechster Teil
		reg_m_v <<= 1; reg_t++;
	}
return;
}
}   //-- reg_t, reg_m_v

}   //-- puzzle_solve_3x4x5_rek

//----------------------------------------------------------------

#if defined(CCC_MIT_SOLVE_3x4x5_REK_L)

void puzzle_solve_3x4x5_rek_l(LLW_E* pl) {

int	k_idx;

STATISTIK_INC_REK_L();

ON_TST_RET(0x2001, (pl >= pLLW_m));
ON_TST_RET(0x2002, ((pl - 1) < pLLW_ini));
ON_TST_RET(0x2003, ((pl - 1)->v == LVT_ALL))

{
//-- Ermitteln des neuen k
register int	reg_k;
register U32	reg_m_k;
register U32	reg_f_l;

reg_k   = (pl - 1)->k - 1;
reg_m_k = (pl - 1)->m_k >> 1;
reg_f_l = (pl - 1)->f.l;
while (reg_f_l & reg_m_k) {
	reg_k--;
	reg_m_k >>= 1;
}
k_idx = (K_Q_ANZ - 1) - (pl->k = reg_k);
pl->m_k = reg_m_k;
}   //-- reg_k, reg_m_k. reg_f_l

{
register int reg_t;
register LVT reg_m_v;

//-- Ausschliesslich QFK.l
reg_t = 0;
reg_m_v = 1;

ON_TST_RET(0x2104, ((pl - 1)->f.h != FQK_ALL_H));
pl->f.h  = FQK_ALL_H;
pl->ft.h = FQK_NONE_H;
for ( ; ; ) {
	//-- Naechsten verfuegbaren Teil ermitteln
	//   (vielleicht ist es ja schon dieser)
	{
	register LVT reg_v1 = (pl - 1)->v;
	while (reg_v1 & reg_m_v) {
		reg_m_v <<= 1; reg_t++;
	}
	}   //-- reg_v1;
	
	//-- Gibt es noch einen Teil zum Fuellen ?
	if (reg_t < T_ANZ) {
		//-- Gibt es zu diesem Teil Positionen,
		//   die den aktuellen Kubus als
		//   ersten besetzen ?
		//   (und davor nichts, denn das ist alles ja
		//    bereits vollgefuellt)
		register FQK*
		reg_p = pPPLF_0[reg_t][k_idx];
		if (reg_p != NULL) {
			do {
			//-- Fuer alle in Frage kommenden
			//   Positionen diese Teiles
//-------- >> 4 - BEG --------
if (((pl - 1)->f.l & reg_p->l) == 0) {
	//-- Dieser Teil kann an dieser Position in den
	//   Quader eingesetzt werden
	pl->t = reg_t;
	//-- Ermitteln des neuen f
	pl->f.l = ((pl - 1)->f.l | (pl->ft.l = reg_p->l));
	//-- Ermitteln des neuen v
	pl->v = (pl - 1)->v | reg_m_v;
	if (pl->v == LVT_ALL) {
	//if (pl == pLLW_solved) {
		STATISTIK_INC_SOLVED_L();
		puzzle_solved(pl + 1);
		//-- An diese Stelle passt beim c't-Puzzle
		//   keiner der anderen Teil mehr - also
		return;
	}
	else {
		//-- Auf ein neues ...
		puzzle_solve_3x4x5_rek_l(pl + 1);
#if defined(CCC_BIS_ANZ_LOESUNGEN)
		ON_ERR_RET(err_code, (err_code != 0));
#else
		ON_TST_RET(err_code, (err_code != 0));
#endif
	}
}
//-------- >> 4 - END --------
			//-- Naechste Position in Liste
			reg_p++;
			//-- Pruefen der Position
			//   mittels Waechter
			} while (reg_p->l);
		}
	}
	else {
		break;
	}
	//-- Naechster Teil
	reg_m_v <<= 1; reg_t++;
}
}   //-- reg_t, reg_m_v

}   //-- puzzle_solve_3x4x5_rek_l

#endif   //-- CCC_MIT_SOLVE_3x4x5_REK_L

//----------------------------------------------------------------



//----------------------------------------------------------------
// Ende - Puzzle loesen
//----------------------------------------------------------------





//----------------------------------------------------------------
// Nachbereitung - Fehlerbehandlung und Spezialausgaben

void puzzle_exit(void) {

if ((err_code == 0) ||
    (err_code == 0xDEAD)) {
	if ((Anzahl_der_Loesungen_erw > 0) &&
	    (Anzahl_der_Loesungen !=
	     Anzahl_der_Loesungen_erw)) {
		printf("(??? erwartet: %ld ???)",
			Anzahl_der_Loesungen_erw);
	}
	if (opt == OPT_TEILERGEBNIS) {
		//-- Ausgabe in entspr. Format,
		//   um sie fuer die Ermittlung des
		//   Endergebnisses durch Summenbildung
		//   dann wieder komfortabel verwenden
		//   zu koennen
		printf("%ld Loesungen (Teilnummern "
			"von %0.2d bis %0.2d)\n",
			Anzahl_der_Loesungen,
			opt_tn_von + 1, opt_tn_bis + 1);
		exit(ret_code);
	}
}
else {
	printf("Fehler - Code=0x%0.8lX\n", err_code);
	exit(ret_code);
}

}   //-- puzzle_exit

//----------------------------------------------------------------





//--------------------------------------------------------------//
// 3x4x5.C  --  (c)2003, Hannes G. Kuchler			//
//--------------------------------------------------------------//

// EOF