program ctflash;   

{ (C) Heise Zeitschriftenverlag GmbH & Co. KG, Hannover, Germany }
{ Beachten Sie unbedingt die Hinweise in LIZENZ.TXT und LIESMICH.TXT }

{ EINBAUEN: AMIC 29040 (VID: $37 DID: $86) == AMD 29F040 }
{ EINBAUEN: AMIC 290021 == AT29C020} 

{ EINBAUEN: AS29F010/002/040, MX29F001/004/020, V29C5001/004, W49F020 }
{ einbauen:  = ATMEL AT29C020 mit J5 auf 12V, J4 normal }

{ BAUSTELLE: AT49F010/020 (Muster fehlen) }

{ mit neuen Chips checken: Pin 1 = /RESET? -> Ident-Funktion! }

{$DEFINE noDEBUG} { Debug-Informationen anzeigen }

{ noch nicht mit Chips getestet: 
  HY29F002T/B,
  V29C51002B, 
  M28F512, 
  W29C010, kompatibel zu W29EE011, 
  AT49F001/2/40T, kompatibel zu /B-Typen
  AMIC 29040 (== AMD 29F040) }

{$A+$B+$D-$E-$F+$G+$I-$N+$O-$R-$S-$V-$X-}

{ neu in 1.64: Macronix MX29F040, STM M29F040 }
{ neu in 1.63: Winbond  W49F002 }

uses CRT {,GO32}; { Readkey, I/O-Zugriff }

const version = '1.64a, ct-ea-20021023';

const UnknownMfg =   0; { unbekannter Hersteller }
      UnknownDev =   0; { unbekannter Bausteintyp }
      AMD        = $01;
      AS         = $52; { Alliance Semiconductor }
      Atmel      = $1F;
      CSI        = $31; { Catalyst Semiconductor Inc. }
      Hyundai    = $AD;
      Intel      = $89;
      MV         = $40; { Mosel-Vitelic }
      MX         = $C2; { Macronix International Co. Ltd. }
      SST        = $BF; { Silicon Storage Technology }
      STM        = $20; { SGS-Thomson Microelectronics}
      Winbond    = $DA;
      filler     = $FF; { Fuellbyte, wenn Datei kuerzer als Baustein }

type page = array[0..2047] of byte;

var sprache  : char;         { 'D'eutsch/Default, 'E'nglish, 'N'ederlands }
    IO       : word;         { I/O-Adresse Flasher }
    filename : string;       { Dateiname zu schreibende Binaerdatei }
    lesen    : boolean;      { nur auslesen }
    datsize  : longint;      { Groesse Binaerdatei }
    segment  : word;         { Segmentadresse 2K-Memory-Block }
    offset   : word;         { Offset... }
    latch    : byte;         { Zustand des Adresslatches }
    mfg,dev  : byte;         { Hersteller- und Typcode }
    lockout  : boolean;      { Boot Block Lockout bei manchen Chips }
    memsize  : longint;      { Kapazitaet des Bausteins in Byte }
    typ      : string;       { Typenbezeichnung des Bausteins }
    infile   : file of byte; { Datei fuer's Einlesen... }
    outfile  : file of page; { ...und fuer's Ausgeben }
    puffer   : page;         { und Puffer fuer BIOS-Inhalt }
    adr      : longint;      { fortlaufende Zieladresse im Flash }
    ok,                      { solange alles gutgeht... }
    autodetect,              { Baustein automatisch erkennen? }
    autoident,               { wurde auch automatisch erkannt }
    protected,               { Boot Block ist geschuetzt }
    verify,
    J4,J5,RESPIN
             : boolean;      { 12-V-Rangierung, true -> Jx=12V, bzw. Pin 1 = /Reset }
    dummy    : byte;
    i        : word;
    d        : char;

    boot,para1,para2,main : longint; { bausteinspezifische Variablen }

function Tick:longint;
begin
  Tick:=meml[$40:$6C];
end;

procedure fread;
var i : word;
begin
  for i:=0 to 2047 do if not EOF(infile) then read(infile,puffer[i])
                                         else puffer[i]:=filler;
end;

procedure Pause(n:longint); { wartet n * 15,6 us }
var t : byte;
    i : longint;
begin
  t:=port[$61] AND $10;
  repeat until t<>(port[$61] AND $10);
  for i:=1 to n do begin { einen Refresh-Toggle (15,6 us) abwarten }
    t:=port[$61] AND $10;
    repeat until t<>(port[$61] AND $10);
  end;
end;

function NTH(data:Byte):char;
var h:char;
begin
  case data of
    0..9:h:=chr(48+data);
    else h:=chr(55+data);
  end;
  NTH:=h;
end; {NTH}

function BTH(data:Byte):string;
var h:string;
begin
  h:=NTH(data shr 4)+NTH(data and $F);
  BTH:=h;
end; {BTH}

function WTH(data:word):string;
var h:string;
begin
  H:=BTH(Byte(data shr 8))+BTH(Byte(data and $FF));
  WTH:=h;
end; {WTH}

function ATH(data:longint):string;
var h:string;
begin
  H:=BTH(Byte(data shr 16))+WTH(Word(data and $FFFF));
  ATH:=h;
end; {ATH}

function HTN(data:char):byte;
var c : byte;
begin
  if (data<'0') or (data>'F') or ((data>'9') and (data<'A')) then begin
    case sprache of 'D' : writeln('Ungltiges Hex-Zeichen: ',data); 
                    'N' : writeln('Ongeldig hexadecimaal karakter: ',data);
                     else writeln('Invalid hex character: ',data);
    end{case};
    ok:=false;
  end;
  if ok then begin
    c:=Ord(data)-$30;
    if (c>$9) then c:=c-$7;
    end
   else c:=0;
  HTN:=c;
end;

function HTB(data:string):byte;
begin
  HTB:=HTN(data[1]) SHL 4 + HTN(data[2]);
end;

function HTW(data:string):word;
begin
  HTW:=HTB(copy(data,1,2)) SHL 8 + HTB(copy(data,3,2));
end;

procedure SetAdr(a:longint);
begin
  Latch:=a SHR 11;
  if RESPIN then Latch:=Latch or $80; { A18 = 1 fr ICs mit /RESET-Pin }
  port[IO]:=Latch;
  offset:=a AND $7FF;
end;

procedure WMem(a:longint;d:byte);
begin
  SetAdr(a);
  Mem[segment:offset]:=d;
end;

function RMem(a:longint):byte;
begin
  SetAdr(a);
  RMem:=Mem[segment:offset];
end;

procedure GetKey(s:string);
begin
  repeat until KeyPressed;
  d:=ReadKey; writeln(s,d); if d=#0 then begin d:=ReadKey; d:=#0; end;
end;



{ *** Chip-Identifizierung *********************************************** }

procedure IdentAMD1;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($5555,$AA); { Reset/Read }
  WMem($2AAA,$55);
  WMem($5555,$F0);
  Pause(1);        { 15us warten }
  WMem($5555,$AA); { Autoselect }
  WMem($2AAA,$55);
  WMem($5555,$90);
  Pause(1);        { 15us warten }
  mfg:=RMem($0);
  dev:=RMem($1);
  if (mfg<>AMD) then mfg:=UnknownMfg;
  WMem($5555,$AA); { Reset/Read }
  WMem($2AAA,$55);
  WMem($5555,$F0);
  asm STI end; {enable}
end;

procedure IdentAMD2;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($0,$FF);    { Reset/Read }
  Pause(1);        { 15us warten }
  WMem($0,$90);    { Autoselect }
  Pause(1);        { 15us warten }
  mfg:=RMem($0);
  dev:=RMem($1);
  if (mfg<>AMD) then mfg:=UnknownMfg;
  WMem($0,$FF);    { Reset/Read }
  asm STI end; {enable}
end;

procedure IdentAS; { !!! } { AS29F002: Reset = Pin 1 = J5 = A18 = High setzen }
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($45555,$AA); { Reset }
  WMem($42AAA,$55);
  WMem($45555,$00);
  Pause(17);        { 250 us warten }
  WMem($45555,$AA); { ID Read Code }
  WMem($42AAA,$55);
  WMem($45555,$02);
  Pause(17);        { 250 us warten }
  mfg:=RMem($40000);
  dev:=RMem($40001);
  if (mfg<>AS) then mfg:=UnknownMfg;
  WMem($45555,$AA); { Reset }
  WMem($42AAA,$55);
  WMem($45555,$00);
  Pause(17);        { 250 us warten }
  asm STI end; {enable}
end;

procedure IdentAtmel; { AT49F001/2: Reset = Pin 1 = J5 = A18 = High setzen }
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($45555,$AA);
  WMem($42AAA,$55);
  WMem($45555,$90);
  Pause(10*67); { 10ms warten }
  mfg := RMem($0);
  dev := RMem($1);
  case dev of $05,$07,$17,$0B,$13 : lockout:=(RMem($2) AND 1)=1; { Boot Block Lockout? }
              $04 : lockout:=(RMem($1C002) AND 1)=1; { AT49F001T }
              $08 : lockout:=(RMem($3C002) AND 1)=1; { AT49F002T }
              $12 : lockout:=(RMem($7C002) AND 1)=1; { AT49F040T }
               else lockout:=false;
  end{case};
  if (mfg<>Atmel) then mfg:=UnknownMfg;
  WMem($45555,$AA);
  WMem($42AAA,$55);
  WMem($45555,$F0);
  Pause(10*67); { 10ms warten }
  asm STI end; {enable}
end;

procedure IdentCatalyst;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
  WMem($0,$90); { Identify }
  mfg:=RMem($0);
  dev:=RMem($1);
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
  if (mfg<>CSI) then mfg:=UnknownMfg;
  asm STI end; {enable}
end;

procedure IdentHyundai; { HY29F002: Reset = Pin 1 = J5 = A18 = High setzen }
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($45555,$AA); { Reset }
  WMem($42AAA,$55);
  WMem($45555,$F0);
  Pause(1);         { 10us warten }

  WMem($45555,$AA); { Chip-ID }
  WMem($42AAA,$55);
  WMem($45555,$90);
  Pause(1);         { 10us warten }
  mfg:=RMem($40000);
  dev:=RMem($40001);

  WMem($45555,$AA); { Reset }
  WMem($42AAA,$55);
  WMem($45555,$F0);
  Pause(1);         { 10us warten }

  if (mfg<>Hyundai) then mfg:=UnknownMfg;
  asm CLI end; {disable}
end;

procedure IdentIntel;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
  WMem($0,$90); { Identify }
  mfg:=RMem($0);
  dev:=RMem($1);
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
  if (mfg<>Intel) then mfg:=UnknownMfg;
  asm STI end; {enable}
end;

procedure IdentMV;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($5555,$AA);
  WMem($2AAA,$55);
  WMem($5555,$90);
  Pause(10*67); { 10ms warten }
  mfg:=RMem($0);
  dev:=RMem($1);
  if (mfg=MV) then
    case dev of $02 : protected:=(RMem($3C002)=1); { V29C5002T, Boot Block protected? }
                $A2 : protected:=(RMem($0C002)=1); { V29C5002B }
    end{case};
  if (mfg<>MV) then mfg:=UnknownMfg;
  WMem($5555,$AA);
  WMem($2AAA,$55);
  WMem($5555,$F0);
  Pause(10*67); { 10ms warten }
  asm STI end; {enable}
end;

procedure IdentMX1;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
  WMem($0,$90); { Identify }
  mfg:=RMem($0);
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
  WMem($0,$90); { Identify }
  dev:=RMem($1);
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
  if (mfg<>MX) then mfg:=UnknownMfg;
  asm STI end; {enable}
end;

procedure IdentMX2; { MX29F002: Reset = Pin 1 = J5 = A18 = High setzen }
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($45555,$F0); { Reset }
  Pause(1);       { 15us warten }
  WMem($45555,$AA); { Autoselect }
  WMem($422AA,$55);
  WMem($45555,$90);
  Pause(1);        { 15us warten }
  mfg:=RMem($0);
  dev:=RMem($1);
  if (mfg<>MX) then mfg:=UnknownMfg;
  WMem($555,$F0); { Reset }
  asm STI end; {enable}
end;

procedure IdentSST1;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($5555,$AA); { Reset }
  WMem($2AAA,$55);
  WMem($5555,$F0);
  Pause(1);        { 15us warten }

  WMem($5555,$AA); { Chip-ID }
  WMem($2AAA,$55);
  WMem($5555,$80);
  WMem($5555,$AA);
  WMem($2AAA,$55);
  WMem($5555,$60);
  Pause(1);        { 15us warten }
  mfg:=RMem($0);
  dev:=RMem($1);

  WMem($5555,$AA); { Reset }
  WMem($2AAA,$55);
  WMem($5555,$F0);
  Pause(1);        { 15us warten }

  if (mfg<>SST) then mfg:=UnknownMfg;
  asm STI end; {enable}
end;

procedure IdentSST2;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($0,$FF);    { Reset }
  Pause(1);        { 15us warten }

  WMem($0,$90);    { Identify }
  Pause(1);        { 15us warten }
  mfg:=RMem($0);
  dev:=RMem($1);

  WMem($0000,$FF); { Reset }
  Pause(1);        { 15us warten }

  if (mfg<>SST) then mfg:=UnknownMfg;
  asm STI end; {enable}
end;

procedure IdentSST3;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($5555,$AA);
  WMem($2AAA,$55);
  WMem($5555,$90);
  Pause(10*67); { 10ms warten }
  mfg:=RMem($0);
  dev:=RMem($1);
  if (mfg<>SST) then mfg:=UnknownMfg;
  WMem($5555,$AA);
  WMem($2AAA,$55);
  WMem($5555,$F0);
  Pause(10*67); { 10ms warten }
  asm STI end; {enable}
end;

procedure IdentST1;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($0,$90);    { Chip-ID }
  Pause(1);        { 15us warten }
  mfg:=RMem($0);
  dev:=RMem($1);
  WMem($0,$FF);    { Reset }
  Pause(1);        { 15us warten }
  if (mfg<>STM) then mfg:=UnknownMfg;
  asm STI end; {enable}
end;

procedure IdentST2; { M29F002: Reset = Pin 1 = J5 = A18 = High setzen }
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($45555,$AA); { Reset/Read }
  WMem($42AAA,$55);
  WMem($45555,$F0);
  Pause(1);       { 15us warten }
  WMem($45555,$AA); { Autoselect }
  WMem($42AAA,$55);
  WMem($45555,$90);
  Pause(1);       { 15us warten }
  mfg:=RMem($0);
  dev:=RMem($1);
  if (mfg<>STM) then mfg:=UnknownMfg;
  WMem($45555,$AA); { Reset/Read }
  WMem($42AAA,$55);
  WMem($45555,$F0);
  asm STI end; {enable}
end;

procedure IdentWin;
begin
  Pause(10*67); { 10ms warten } { ASK, NEW: wait first, otherwise no autodetection! }
  asm CLI end; {disable}
  WMem($5555,$AA); { Reset }
  WMem($2AAA,$55);
  WMem($5555,$F0);
  Pause(1);        { 10us warten }

  WMem($5555,$AA); { Chip-ID }
  WMem($2AAA,$55);
  WMem($5555,$80);
  WMem($5555,$AA);
  WMem($2AAA,$55);
  WMem($5555,$60);
  Pause(1);        { 10us warten }
  mfg:=RMem($0);
  dev:=RMem($1);

{ !!! Boot-Block-Lockout-Erkennung einbauen }

  WMem($5555,$AA); { Reset }
  WMem($2AAA,$55);
  WMem($5555,$F0);
  Pause(1);        { 10us warten }

  if (mfg<>Winbond) then mfg:=UnknownMfg;
  asm CLI end; {disable}
end;

procedure EvalSize(m,d:byte);
begin
  memsize:=0; typ:='Unbekannt'; J5:=false; J4:=false; RESPIN:=false;
  case m of AMD      : case d of $A7 : begin memsize:=128; typ:='Am28F010'; J5:=true;                end;
                                 $A2 : begin memsize:=128; typ:='Am28F010A'; J5:=true;               end;
                                 $2A : begin memsize:=256; typ:='Am28F020'; J5:=true;                end;
                                 $29 : begin memsize:=256; typ:='Am28F020A'; J5:=true;               end;
                                 $20 : begin memsize:=128; typ:='Am29F010';                          end;
                                 $B0 : begin memsize:=256; typ:='Am29F002(N)T';                      end;
                                 $34 : begin memsize:=256; typ:='Am29F002(N)B';                      end;
                                 $A4 : begin memsize:=512; typ:='Am29F040B';                         end;
                       end;
            AS       : case d of $03, 
                                 $04,
                                 $06 : begin memsize:=128; typ:='AS29F010';                          end;
                       end;
            Atmel    : case d of $5D : begin memsize:= 64; typ:='AT29C512';                          end;
                                 $D5 : begin memsize:=128; typ:='AT29C010A';                         end;
                                 $DA : begin memsize:=256; typ:='AT29C020';                          end;
                                 $A4 : begin memsize:=512; typ:='AT29C040A';                         end;
                                 $05 : begin memsize:=128; typ:='AT49F001(N)'; J5:=true; RESPIN:=true; end;
                                 $04 : begin memsize:=128; typ:='AT49F001(N)T'; J5:=true; RESPIN:=true; end;
                                 $07 : begin memsize:=256; typ:='AT49F002(N)'; J5:=true; RESPIN:=true; end;
                                 $08 : begin memsize:=256; typ:='AT49F002(N)T'; J5:=true; RESPIN:=true; end;
                                 $17 : begin memsize:=128; typ:='AT49F010';                          end;
                                 $0B : begin memsize:=256; typ:='AT49F020';                          end;
                                 $13 : begin memsize:=512; typ:='AT49F040';                          end;
                                 $12 : begin memsize:=512; typ:='AT49F040T';                         end;
                       end;
            CSI      : case d of $94 : begin memsize:=128; typ:='CAT28F001Bx-T'; J5:=true; J4:=true; end;
                                 $95 : begin memsize:=128; typ:='CAT28F001Bx-B'; J5:=true; J4:=true; end;
                                 $B4 : begin memsize:=128; typ:='CAT28F010'; J5:=true;               end;
                                 $BD : begin memsize:=256; typ:='CAT28F020'; J5:=true;               end;
                       end;
            Hyundai  : case d of $B0 : begin memsize:=256; typ:='HY29F002T'; RESPIN:=true;           end;
                                 $34 : begin memsize:=256; typ:='HY29F002B'; RESPIN:=true;           end;
                       end;
            Intel    : case d of $94 : begin memsize:=128; typ:='i28F001Bx-T'; J5:=true; J4:=true;   end;
                                 $95 : begin memsize:=128; typ:='i28F001Bx-B'; J5:=true; J4:=true;   end;
                                 $B4 : begin memsize:=128; typ:='i28F010'; J5:=true;                 end;
                                 $BD : begin memsize:=256; typ:='i28F020'; J5:=true;                 end;
                       end;
            MX       : case d of $1A : begin memsize:=128; typ:='MX28F1000(P)'; J5:=true;            end;
                                 $2A : begin memsize:=256; typ:='MX28F2000P'; J5:=true;              end;
                                 $3C : begin memsize:=256; typ:='MX28F2000T'; J5:=true;              end;
                                 $18 : begin memsize:=128; typ:='MX29F001T';                         end;
                                 $19 : begin memsize:=128; typ:='MX29F001B';                         end;
                                 $B0 : begin memsize:=256; typ:='MX29F002(N)T'; RESPIN:=true;        end;
                                 $34 : begin memsize:=256; typ:='MX29F002(N)B'; RESPIN:=true;        end;
                                 $A4 : begin memsize:=512; typ:='MX29F040';                          end;
                       end;
            MV       : case d of $02 : begin memsize:=256; typ:='F/V29C51002T';                      end;
                                 $A2 : begin memsize:=256; typ:='F/V29C51002B';                      end;
                       end;
            SST      : case d of $07 : begin memsize:=128; typ:='PH29EE010';                         end;
                                 $10 : begin memsize:=256; typ:='PH29EE020';                         end;
                                 $04 : begin memsize:=512; typ:='PH28SF040';                         end;
                                 $B5 : begin memsize:=128; typ:='PH39SF010';                         end;
                                 $B6 : begin memsize:=256; typ:='PH39SF020';                         end;
                       end;
            STM      : case d of $07 : begin memsize:=128; typ:='M28F101'; J5:=true;                 end;
                                 $A8 : begin memsize:= 32; typ:='M28F256'; J5:=true;                 end;
                                 $AA : begin memsize:= 32; typ:='M28F256A'; J5:=true;                end;
                                 $02 : begin memsize:= 64; typ:='M28F512'; J5:=true;                 end; 
                                 $B0 : begin memsize:=256; typ:='M29F002T/NT'; RESPIN:=true;         end;
                                 $34 : begin memsize:=256; typ:='M29F002B'; RESPIN:=true;            end;
                                 $E2 : begin memsize:=512; typ:='M29F040B';                          end;
                 end;

            Winbond  : case d of $C1 : begin memsize:=128; typ:='W29EE011/W29C010/11';               end;
                                 $45 : begin memsize:=256; typ:='W29C020';                           end;
                                 $46 : begin memsize:=512; typ:='W29C040';                           end;
                                 $0B : begin memsize:=256; typ:='W49F002'; J5:=true;                 end;
                       end;
  end;
  memsize:=memsize SHL 10;

end;

function MfgStr(m:byte):string;
var s : string;
begin
  case m of AMD     : s:='AMD';
            AS      : s:='Alliance';
            Atmel   : s:='Atmel';
            CSI     : s:='Catalyst';
            Hyundai : s:='Hyundai';
            Intel   : s:='Intel';
            MV      : s:='Mosel-Vitelic';
            MX      : s:='Macronix';
            SST     : s:='SST';
            STM     : s:='STM';
            Winbond : s:='Winbond';
                 else s:='unbekannt';
  end;
  MfgStr:=s;
end;

procedure Identify;
begin
  IdentAMD1;
  if (mfg=UnknownMfg) then IdentAMD2;
{  if (mfg=UnknownMfg) then IdentAS; }
  if (mfg=UnknownMfg) then IdentAtmel;
  if (mfg=UnknownMfg) then IdentCatalyst;
  if (mfg=UnknownMfg) then IdentHyundai;
  if (mfg=UnknownMfg) then IdentIntel;
  if (mfg=UnknownMfg) then IdentMX1;
  if (mfg=UnknownMfg) then IdentMX2;
  if (mfg=UnknownMfg) then IdentMV;
  if (mfg=UnknownMfg) then IdentSST1;
  if (mfg=UnknownMfg) then IdentSST2;
  if (mfg=UnknownMfg) then IdentSST3;
  if (mfg=UnknownMfg) then IdentST1;
  if (mfg=UnknownMfg) then IdentST2;
  if (mfg=UnknownMfg) then IdentWin;
  EvalSize(mfg,dev);
{$IFDEF DEBUG}
        write('Identify: mfg=$',BTH(mfg),' dev=$',BTH(dev));
        if lockout then write(' LOCKOUT');
        writeln(' Memsize=',memsize);
{$ENDIF}
end;

procedure ManualSelect;
begin
  if (mfg=UnknownMfg) then begin
    writeln;
    case sprache of 'D' : writeln('Bitte whlen Sie den Hersteller:');
                    'N' : writeln('Selecteer het merk aub:');
                     else writeln('Please select the manufacturer:');
    end{case};
    writeln('(1) AMD');
{ !!! } {    writeln('(2) Alliance'); }
    writeln('(2) Atmel');
    writeln('(3) CSI');
    writeln('(4) Hyundai');
    writeln('(5) Intel');
    writeln('(6) Macronix');
    writeln('(7) Mosel-Vitelic');
    writeln('(8) SST');
    writeln('(9) ST Microelectronics');
    writeln('(A) Winbond');
    GetKey(' ');
    if (d in ['a'..'z']) then d:=chr(ord(d)-32);
    case d of '1' : mfg:=AMD;
{              '2' : mfg:=AS; }
              '2' : mfg:=Atmel;
              '3' : mfg:=CSI;
              '4' : mfg:=Hyundai;
              '5' : mfg:=Intel;
              '6' : mfg:=MX;
              '7' : mfg:=MV;
              '8' : mfg:=SST;
              '9' : mfg:=STM;
              'A' : mfg:=Winbond;
              else  mfg:=UnknownMfg;
    end;
  end;

  dev:=UnknownDev;
  if (mfg<>UnknownMfg) then begin
    writeln;
    case sprache of 'D' : writeln('Bitte whlen Sie den Bausteintyp:');
                    'N' : writeln('Selecteer het type chip aub:');
                     else writeln('Please select the chip type:');
    end{case};
    case mfg of AMD   : begin
                          writeln('(1) Am28F010');
                          writeln('(2) Am28F010A');
                          writeln('(3) Am28F020');
                          writeln('(4) Am28F020A');
                          writeln('(5) Am29F010');
                          writeln('(6) Am29F002(N)T/B');
                          writeln('(7) Am29F040');
                        end;
                AS    : begin
                          writeln('(1) AS29F010');
                        end;
                Atmel : begin
                          writeln('(1) AT29C512');
                          writeln('(2) AT29C010A');
                          writeln('(3) AT29C020');
                          writeln('(4) AT29C040A');
                          writeln('(5) AT49F001(N)[T]');
                          writeln('(6) AT49F002(N)[T]');
(*                          writeln('(7) AT49F010'); *)
(*                          writeln('(7) AT49F020'); *)
                          writeln('(7) AT49F040[T]');
                        end;
                CSI   : begin
                          writeln('(1) CAT28F001Bx-T');
                          writeln('(2) CAT28F001Bx-B');
                          writeln('(3) CAT28F010');
                          writeln('(4) CAT28F020');
                        end;
              Hyundai : begin
                          writeln('(1) HY29F002T');
                          writeln('(2) HY29F002B');
                        end;
                Intel : begin
                          writeln('(1) i28F001Bx-T');
                          writeln('(2) i28F001Bx-B');
                          writeln('(3) i28F010/Z28F010');
                          writeln('(4) i28F020');
                        end;
                MX    : begin
                          writeln('(1) M28F1000P');
                          writeln('(2) M28F2000P');
                          writeln('(3) M28F2000T');
                          writeln('(4) MX29F001(N)T/B');
                          writeln('(5) MX29F002(N)T/B');
                          writeln('(6) MX29F040');
                        end;
                MV    : begin
                          writeln('(1) F/V29C51002T');
                          writeln('(2) F/V29C51002B');
                        end;
                SST   : begin
                          writeln('(1) PH29EE010');
                          writeln('(2) PH29EE020');
                          writeln('(3) PH28SF040');
                          writeln('(4) PH39SF010');
                          writeln('(5) PH39SF020');
                        end;
                STM   : begin
                          writeln('(1) M28F256(A)');
                          writeln('(2) M28F512');
                          writeln('(3) M28F101');
                          writeln('(4) M29F002T/NT/B');
                          writeln('(5) M29F040B');
                        end;
              Winbond : begin
                          writeln('(1) W29EE011, W29C010/11');
                          writeln('(2) W29C020');
                          writeln('(3) W29C040');
                          writeln('(4) W49F002');
                        end;
    end;
    GetKey(' ');
    if (d in ['a'..'z']) then d:=chr(ord(d)-32);
    case mfg of AMD   : case d of '1' : dev:=$A7; { Am28F010 }
                                  '2' : dev:=$A2; { Am28F010A }
                                  '3' : dev:=$2A; { Am28F020 }
                                  '4' : dev:=$29; { Am28F020A }
                                  '5' : dev:=$20; { Am29F010 }
                                  '6' : dev:=$B0; { Am29F002NT, NB=$34 }
                                  '7' : dev:=$A4; { Am29F040 }
                        end;
                AS    : case d of '1' : dev:=$04; { AS29F010 }
                        end;
                Atmel : case d of '1' : dev:=$5D; { AT29C512 }
                                  '2' : dev:=$D5; { AT29C010A }
                                  '3' : dev:=$DA; { AT29C020 }
                                  '4' : dev:=$A4; { AT29C040A }
                                  '5' : dev:=$05; { AT49F001 }
                                  '6' : dev:=$07; { AT49F002 = F002T }
(*                                  '7' : dev:=$17; { AT49F010 } *)
(*                                  '7' : dev:=$0B; { AT49F020 } *)
                                  '7' : dev:=$13; { AT49F040 = F040T }
                        end;
                CSI   : case d of '1' : dev:=$94; { CAT28F001Bx-T }
                                  '2' : dev:=$95; { CAT28F001Bx-B }
                                  '3' : dev:=$B4; { CAT28F010 }
                                  '4' : dev:=$BD; { CAT28F020 }
                        end;
              Hyundai : case d of '1' : dev:=$B0; { HY29F002T }
                                  '2' : dev:=$34; { HY29F002B }
                        end;
                Intel : case d of '1' : dev:=$94; { i28F001Bx-T }
                                  '2' : dev:=$95; { i28F001Bx-B }
                                  '3' : dev:=$B4; { i28F010 }
                                  '4' : dev:=$BD; { i28F020 }
                        end;
                MX    : case d of '1' : dev:=$1A; { MX28F1000P }
                                  '2' : dev:=$2A; { MX28F2000P }
                                  '3' : dev:=$3C; { MX28F2000T }
                                  '4' : dev:=$18; { MX29F001(N)T, B=$19 }
                                  '5' : dev:=$B0; { MX29F002(N)T, B=$34 }
                                  '6' : dev:=$A4; { MX29F040 }
                        end;
                MV    : case d of '1' : dev:=$02; { F/V29C51002T }
                                  '2' : dev:=$A2; { F/V29C51002B }
                        end;
                SST   : case d of '1' : dev:=$07; { PH29EE010 }
                                  '2' : dev:=$10; { PH29EE020 }
                                  '3' : dev:=$04; { PH28SF040 }
                                  '4' : dev:=$B5; { PH39SF010 }
                                  '5' : dev:=$B6; { PH39SF020 }
                        end;
                STM   : case d of '1' : dev:=$A8; { M28F256 }
                                  '2' : dev:=$02; { M28F512 }
                                  '3' : dev:=$07; { M28F101 }
                                  '4' : dev:=$B0; { M29F002T/NT, B=$34 }
                                  '5' : dev:=$E2; { M29F040B }
                        end;
              Winbond : case d of '1' : dev:=$C1; { W29EE011/W29C010/11 }
                                  '2' : dev:=$45; { W29C020 }
                                  '3' : dev:=$46; { W29C040 }
                                  '4' : dev:=$0B; { W49F002 }
                        end;
    end;
    if (mfg<>UnknownMfg) and (dev<>UnknownDev) then EvalSize(mfg,dev);
    writeln;
  end;
end;



{ *** globale Teilprozeduren fr alle Chiptypen ************************** }

procedure EraseFailure(grund:string);
begin
  case sprache of 'D' : write('Chip Erase fehlgeschlagen');
                  'N' : write('Het wissen van de chip is mislukt');
                   else write('Chip Erase failure');
  end{case};
  if length(grund)>0 then write(' ',grund);
  writeln('.');
end{EraseFailure};

procedure EraseAMD1; { Am29Fxxx und kompatible }
var t : longint;
begin
  Pause(10*67); { 10ms warten }
  asm CLI end; {disable}

  WMem($5555,$AA); { Reset/Read }
  WMem($2AAA,$55);
  WMem($5555,$F0);
  Pause(1);        { 15us warten }

  WMem($5555,$AA); { Chip Erase }
  WMem($2AAA,$55);
  WMem($5555,$80);
  WMem($5555,$AA);
  WMem($2AAA,$55);
  WMem($5555,$10);
  asm STI end; {enable}
  t:=tick+541; { ca. 30s Time-Out fuer ChipErase }
  repeat until ((RMem($0000) AND $80)=$80) or (tick>t);
  if (tick>t) then ok:=false;
  Pause(1);        { 15us warten }

  WMem($5555,$AA); { Reset/Read }
  WMem($2AAA,$55);
  WMem($5555,$F0);
  Pause(1);        { 15us warten }
end{EraseAMD1};

procedure WriteFailure(grund:string);
begin
  case sprache of 'D' : write('Schreiben fehlgeschlagen');
                  'N' : write('Schrijf fout');
                   else write('Write failure');
  end{case};
  if length(grund)>0 then write(' ',grund);
  writeln('.');
end{WriteFailure};

procedure ChipErase28F0x0;
var cyc     : word;
    EraseOK : boolean;
begin
  cyc:=0;
  adr:=0;
  repeat
    asm CLI end; {disable}
    WMem(adr,$20);   { Erase Setup }
    WMem(adr,$20);   { Erase Start }
    asm STI end; {enable}
    Pause(667);      { 10ms warten }
    repeat
      asm CLI end; {disable}
      WMem(adr,$A0); { Erase Verify }
      Pause(1);      { 15us warten  }
      EraseOK:=(RMem(adr)=$FF);
      if EraseOK then inc(adr) else inc(cyc);
      asm STI end; {enable}
    until (adr>=memsize) or not(EraseOK);
  until (adr>=memsize) or (cyc>1000);
  ok:=not(cyc>1000);
  if not ok then EraseFailure('Cycle limit exceeded at $'+ATH(adr));
  WMem($0,$00); { Read }
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
end{ChipErase28F0x0};

procedure Erase28F001;
  procedure EraseBlock(a:longint);
  var t   : longint;
      wsm : byte; { Status Write State Machine }
  begin
    asm CLI end; {disable}
    WMem(a,$FF); { Reset }
    WMem(a,$50); { Clear Status Register }
    WMem(a,$20); { EraseSetup }
    WMem(a,$D0); { EraseConfirm }
    asm STI end; {enable}
    t:=tick+379; { Time-Out max. 21s }
    repeat
      asm CLI end; {disable}
      WSM:=RMem(a); { Read Status Register }
      asm STI end; {enable}
    until ((WSM and $80)=$80) or (tick>t);
    asm CLI end; {disable}
    WSM:=RMem(a); { Read Status Register }
    WMem(a,$FF);  { Reset }
    asm STI end; {enable}
    if ((WSM and $38)<>$0) then ok:=false;
    if (tick>t) then ok:=false;
    if not ok then begin
      case sprache of 'D' : write(', Fehler:');
                      'N' : write(', Fout:');
                       else write(', Error:');
      end{case};
      if (WSM AND $08)=$08 then write(' Vpp Range (WSM=$',BTH(WSM),')');
      if (WSM AND $30)=$30 then write(' Command Sequence (WSM=$',BTH(WSM),')');
      if (WSM AND $20)=$20 then write(' Block Erase (WSM=$',BTH(WSM),')');
      if (WSM AND $38)=$0  then write(' Time-Out.');
    end;
    writeln;
    if (WSM AND $08)=$08 then writeln('Jumper J4 & J5 = +12V?');
  end;
begin { Erase28F001 }
  write('Erase: Boot');   EraseBlock(boot);
  write('Erase: Para1');  EraseBlock(para1);
  write('Erase: Para2');  EraseBlock(para2);
  write('Erase: Main');   EraseBlock(main);
end{Erase28F001};

procedure WriteByte28F0x0(a:longint;d:byte);
var o       : byte;
    cyc,max : word;
begin
  asm CLI end; {disable}
  cyc:=0;
  max:=25;       { max. Anzahl Schreibversuche }
  repeat
    WMem(a,$40); { Program Setup  }
    WMem(a,d);   { Write Data     }
    Pause(1);    { 15us warten    }
    WMem(a,$C0); { Program Verify }
    Pause(1);    { 15us warten    }
    o:=RMem(a);
    inc(cyc);
  until (o=d) or (cyc>max);
  asm STI end; {enable}
  ok:=not(cyc>max);
  WMem(0,0);     { Read }
end{WriteByte28F0x0};

procedure Zap28F0x0; { Baustein mit $00 vollschreiben }
begin { ZapI28F0x0 }
  adr:=0;
  while ok and (adr<memsize) do begin
    write(ATH(adr));
    i:=0;
    while ok and (i<sizeof(puffer)) do begin
      WriteByte28F0x0(adr,$00);
      inc(i); inc(adr);
      if not ok then dec(adr);
    end;
    write(#8#8#8#8#8#8);
  end;
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
  write(ATH(adr)); writeln;
  if not ok then case sprache of 'D' : writeln('$00-Schreiben fehlgeschlagen (Cycle limit exceeded).');
                                 'N' : writeln('$00-Schrijf fout (Cyclus limiet overschreden).');
                                  else writeln('$00-Write failure (Cycle limit exceeded).');
                 end{case};
end{Zap28F0x0};

procedure Erase28F0x0;
begin
  case sprache of 'D' : write('$00-Schreiben: $'); 
                  'N' : write('$00-Schrijven: $');
                   else write('$00-Writing: $');
  end{case};
  Zap28F0x0;
    if ok then begin
    writeln('Chip-Erase...');
    ChipErase28F0x0;
  end;
end{Erase28F0x0};

procedure WriteByte28F0x0A(a:longint;d:byte);
var t       : longint;
begin
  asm CLI end; {disable}
  WMem(a,$50); { Program Setup  }
  WMem(a,d);   { Write Data     }
  Pause(1);    { 15us warten    }
  asm STI end; {enable}
  t:=tick+2;   { ca. 50ms Time-Out, jenseits von gut und boese... }
  repeat until (RMem(a)=d) or (tick>t);
  if (tick>t) then ok:=false;
end{WriteByte28F0x0A};

procedure WriteByteAMD; { Am28Fxxx; Am29Fxxx und kompatible }
{ Achtung: Anpassung der Device-Typen in [] !!! }
var timex,bytewise,byte28f0 : boolean;
    msb : byte;
  procedure WriteByte(a:longint;d:byte);
  var t : longint;
  begin
    msb:=(d and $80);
    asm CLI end; {disable}
    WMem($5555,$AA);
    WMem($2AAA,$55);
    WMem($5555,$A0);
    WMem(a,d);
    Pause(1); { kleine Schreibpause }
    if (mfg=Winbond) and (dev=$0B) then Pause(3); { W49F002 braucht Schreibpause }
    asm STI end; {enable}
    t:=tick+2; { ca. 50ms Time-Out }
    while not (((RMem(a) and $80)=msb) or (tick>t) or timex) do begin
      if ((RMem(a) and $20)=$20) then timex:=((RMem(a) and $80)<>msb);
    end;
    if (tick>t) then ok:=false;
  end;
begin { WriteByteAMD }
  timex:=false;
  while ok and (adr<memsize) do begin
    if (adr<=(memsize-sizeof(puffer))) then fread;
    write(ATH(adr));
    i:=0;
    bytewise:=dev in [$20,$B0,$34,$A4,$0B,$E2];
    byte28f0:=dev in [$A2,$29];
    while ok and (i<sizeof(puffer)) do begin
      if bytewise then WriteByte(adr,puffer[i]);
      if byte28f0 then WriteByte28F0x0A(adr,puffer[i]);
      inc(i); inc(adr);
      if not ok then dec(adr);
    end;
    write(#8#8#8#8#8#8);
  end;
  write(ATH(adr)); writeln;
  if not ok then if timex then WriteFailure('(Time limit exceeded)') else WriteFailure('(Time-Out)');
end{WriteByteAMD};

procedure Write28F001;
  procedure WriteByte28F001(a:longint;d:byte);
  var t   : longint;
      WSM : byte;
  begin
    asm CLI end; {disable}
    WMem(a,$40);
    WMem(a,d);
    asm STI end; {enable}
    t:=tick+2; { ca. 50ms Time-Out }
    repeat
      asm CLI end; {disable}
      WSM:=RMem(a); { Read Status Register }
      asm STI end; {enable}
    until ((WSM and $80)=$80) or (tick>t);
    asm CLI end; {disable}
    WSM:=RMem(a); { Read Status Register }
    WMem(a,$FF);  { Reset }
    asm STI end; {enable}
    if ((WSM and $38)<>$0) then ok:=false;
    if (tick>t) then ok:=false;
    if not ok then begin
      case sprache of 'D' : write(', Fehler:');
                      'N' : write(', Fout:');
                       else write(', Error:');
      end{case};
      if (WSM AND $08)=$08 then write(' Vpp Range (WSM=$',BTH(WSM),')');
      if (WSM AND $30)=$30 then write(' Command Sequence (WSM=$',BTH(WSM),')');
      if (WSM AND $20)=$20 then write(' Block Erase (WSM=$',BTH(WSM),')');
      if (WSM AND $38)=$0  then write(' Time-Out.');
      writeln;
      if (WSM AND $08)=$08 then writeln('Jumper J4 & J5 = +12V?');
    end;
  end;
begin { Write28F001 }
  WMem(adr,$FF); { Reset }
  WMem(adr,$50); { Clear Status Register }
  while ok and (adr<memsize) do begin
    if (adr<=(memsize-sizeof(puffer))) then fread;
    write(ATH(adr));
    i:=0;
    while ok and (i<sizeof(puffer)) do begin
      WriteByte28F001(adr,puffer[i]);
      inc(i); inc(adr);
      if not ok then dec(adr);
    end;
    write(#8#8#8#8#8#8);
  end;
  write(ATH(adr)); writeln;
  if not ok then WriteFailure('(Time-Out)');
end{Write28F001};

procedure Write28F0x0;
begin { Write28F0x0 }
  while ok and (adr<memsize) do begin
    if (adr<=(memsize-sizeof(puffer))) then fread;
    write(ATH(adr));
    i:=0;
    while ok and (i<sizeof(puffer)) do begin
      WriteByte28F0x0(adr,puffer[i]);
      inc(i); inc(adr);
      if not ok then dec(adr);
    end;
    write(#8#8#8#8#8#8);
  end;
  write(ATH(adr)); writeln;
  if not ok then WriteFailure('(Time-Out)');
  WMem($0,$FF); { Reset }
  WMem($0,$FF); { Reset }
end{Write28F0x0};

{ *** Ende globale Teilprozeduren **************************************** }



procedure Loeschen;

  procedure EraseAMD;
    procedure ChipErase; { Am28F010A/020A }
    var t : longint;
    begin
      asm CLI end; {disable}
      WMem($0,$FF);      { Reset }
      Pause(1);          { 15 us warten }
      WMem($0,$30);      { Chip Erase }
      WMem($0,$30);
      asm STI end; {enable}
      t:=tick+181;       { ca. 10s Time-Out fuer ChipErase }
      repeat until ((RMem($0000) AND $80)=$80) or (tick>t);
      if (tick>t) then ok:=false;
    end;
  begin
    if not(dev in [$A7,$2A]) then writeln('Chip-Erase...');
    if dev in [$20,$B0,$34,$A4] then EraseAMD1;
    if dev in [$A7,$2A] then Erase28F0x0;
    if dev in [$A2,$29] then ChipErase;
  end;

  procedure EraseAS; { !!! }
    procedure ChipErase;
    begin
      asm CLI end; {disable}
      WMem($5555,$AA); { Chip Erase }
      WMem($2AAA,$55);
      WMem($5555,$80);
      WMem($0000,$FF);
      Pause(1333);     { 20ms warten }
      asm STI end; {enable}
    end;
  begin
    writeln('Chip-Erase...');
    ChipErase;
  end;

  procedure EraseAtmel;
    procedure ChipErase;
    var t : longint;
    begin
      asm CLI end; {disable}
      WMem($5555,$AA); { Chip Erase }
      WMem($2AAA,$55);
      WMem($5555,$80);
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$10);
      Pause(1333);     { 20ms warten }
      asm STI end; {enable}
      t:=tick+181;     { ca. 10s Time-Out fuer Chip-Erase }
      repeat until ((RMem($0000) AND $80)=$80) or (tick>t);
      if (tick>t) then ok:=false;
      if not ok then EraseFailure('Time-Out');
    end;
  begin
    writeln('Chip-Erase...');
    ChipErase;
  end;


  procedure EraseCatalyst;
  begin { EraseCatalyst }
    { Block-Adressen setzen }
    case dev of $94 : begin boot:=$1E000; para1:=$1C000; para2:=$1D000; main:=$0; end;
                $95 : begin main:=$04000; para1:=$02000; para2:=$01000; boot:=$0; end;
    end;
    case dev of $94,$95 : Erase28F001;
                $B4,$BD : Erase28F0x0;
    end;
  end;


  procedure EraseHyundai;
    procedure ChipErase; { HY29F002T/B }
    var t : longint;
    begin
      asm CLI end; {disable}
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$80);
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$10);
      asm STI end; {enable}
      t:=tick+1900; { ca. 105s Time-Out fuer ChipErase }
      repeat until ((RMem($40000) AND $80)=$80) or (tick>t);
      if (tick>t) then ok:=false;
    end;
  begin { EraseHyundai }
    case dev of $B0,$34 : begin { HY29F002T/B }
                            writeln('Chip-Erase...');
                            ChipErase; 
                          end;
    end;
  end;


  procedure EraseIntel;
  begin { EraseIntel }
    { Block-Adressen setzen }
    case dev of $94 : begin boot:=$1E000; para1:=$1C000; para2:=$1D000; main:=$0; end;
                $95 : begin main:=$04000; para1:=$02000; para2:=$01000; boot:=$0; end;
    end;
    case dev of $94,$95 : Erase28F001;
                $B4,$BD : Erase28F0x0;
    end;
  end;


  procedure EraseMacronix;
  begin { EraseMacronix }
    case dev of $1A,$2A,$3C : Erase28F0x0; { MX28F1000/2000[P|T] }
                $18,$19,$B0,$34,$A4 : begin    { MX29F001/2(N)T/B, MX29F040 }
                                      writeln('Chip-Erase...');
                                        EraseAMD1;
                                      end;
    end;
  end;


  procedure EraseMV;
    procedure ChipErase;
    begin
      asm CLI end; {disable}
      WMem($5555,$AA); { Chip Erase }
      WMem($2AAA,$55);
      WMem($5555,$80);
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$10);
      Pause(133300);   { 2s warten }
      asm STI end; {enable}
    end;
  begin
    if not protected then begin
      writeln('Chip-Erase...');
      ChipErase;
      end
     else begin
      ok:=false;
      case sprache of 'D' : writeln('Boot Block ist geschtzt, kann nicht lschen -- siehe Datenblatt.');
                      'N' : writeln('Boot block is beveiligd, wissen lukt niet -- zie datasheet.');
                       else writeln('Boot block is protected, can''t erase -- see datasheet.');
      end{case};
    end;
  end;


  procedure EraseSST;
    procedure ChipErase1;
    begin
      asm CLI end; {disable}
      WMem($5555,$AA); { Chip Erase }
      WMem($2AAA,$55);
      WMem($5555,$80);
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$10);
      Pause(6666);      { 100ms warten statt 20ms wg. 39SF020A }
      asm STI end; {enable}
    end;
    procedure ChipErase2;
    begin
      asm CLI end; {disable}
      WMem($0,$FF);     { Reset }
      dummy:=RMem($1823);   { Software Data Unprotect }
      dummy:=RMem($1820);
      dummy:=RMem($1822);
      dummy:=RMem($0418);
      dummy:=RMem($041B);
      dummy:=RMem($0419);
      dummy:=RMem($041A);
      WMem($0,$30);     { Chip Erase }
      WMem($0,$30);
      Pause(1333);      { 20ms warten }
      asm STI end; {enable}
    end;
  begin
    writeln('Chip-Erase...');
    if dev in [$07,$10,$B5,$B6] then ChipErase1;
    if dev in [$04] then ChipErase2;
  end;

  procedure EraseSTM;
  begin
    case dev of $A8,$AA,$02,$07 : begin 
                                    case sprache of 'D' : write('$00-Schreiben: $');
                                                    'N' : write('$00-Schrijven: $');
                                                     else write('Writing $00:   $');
                                    end{case};
                                    Zap28F0x0;
                                    if ok then begin
                                      writeln('Chip-Erase...');
                                      ChipErase28F0x0;
                                    end;
                                  end;
                $B0,$34,$E2     : begin { M29F002/040 }
                                    writeln('Chip-Erase...');
                                    EraseAMD1;
                                  end;
    end;
  end;

  procedure EraseWinbond;
    procedure ChipErase;
    begin
      asm CLI end; {disable}
      if (dev<>$0B) then begin
        WMem($5555,$AA); { Software Data Protection Disable }
        WMem($2AAA,$55);
        WMem($5555,$80);
        WMem($5555,$AA);
        WMem($2AAA,$55);
        WMem($5555,$20);
      end;
      Pause(667);      { 10 ms Pause }
      WMem($5555,$AA); { Chip Erase }
      WMem($2AAA,$55);
      WMem($5555,$80);
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$10);
      Pause(66700);     { 1s warten (W49F002) }
      asm STI end; {enable}
    end;
  begin
    writeln('Chip-Erase...');
    ChipErase;
  end;


{ procedure Loeschen }
begin
  Pause(100*67); { 100ms warten }
  case mfg of AMD      : EraseAMD;
              AS       : EraseAS;
              Atmel    : EraseAtmel;
              CSI      : EraseCatalyst;
              Intel    : EraseIntel;
              MX       : EraseMacronix;
              MV       : EraseMV;
              SST      : EraseSST;
              STM      : EraseSTM;
              Winbond  : EraseWinbond;
  end;
end;



procedure Leertest;
begin
  case sprache of 'D' : write('Leer-Test:     $000000');
                  'N' : write('Wis-controle:  $000000');
                   else write('Erasure check: $000000');
  end{case};
  adr:=0;
  while (adr<memsize) and ok do begin
    if (adr and $7FF)=0 then write(#8#8#8#8#8#8,ATH(adr));
    ok:=(RMem(adr)=$FF);
    if ok then inc(adr);
  end;
  write(#8#8#8#8#8#8,ATH(adr)); writeln;
  if not ok then case sprache of 'D' : writeln('Baustein ist nicht komplett gelscht, bitte nochmal versuchen.');
                                 'N' : writeln('Chip is niet geheel gewist, probeer het nog eens aub.');
                                  else writeln('Chip didn''t erase completely, please try again.');
                 end{case};
end;



procedure Schreiben;

  procedure WriteAMD;
  begin { WriteAMD }
    case dev of $A2,$29,$20,$B0,$34,$A4 : WriteByteAMD;
                $A7,$2A                 : Write28F0x0;
    end;
  end;

  procedure WriteAS; { !!! }
  begin { WriteAS }
  end;

  procedure WriteAtmel;
  var s,pagesize : word;
    procedure WritePage;
    var n : word;
        t : longint;
    begin
      asm CLI end; {disable}
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$A0);
      for n:=1 to pagesize do begin
        WMem(adr,puffer[i]);
        inc(adr); inc(i);
      end;
      Pause(20); { 330 us warten }
      asm STI end; {enable}
      t:=tick+2; { ca. 50ms Time-Out fuer Page-Write }
      repeat until (RMem(adr-1)=puffer[i-1]) or (tick>t);
      if (tick>t) then ok:=false;
      asm CLI end; {disable}
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$F0);
      asm STI end; {enable}
    end;
    procedure WritePuffer;
    var t : longint;
    begin
      while ok and (i<s) do begin
        asm CLI end; {disable}
        WMem($5555,$AA);
        WMem($2AAA,$55);
        WMem($5555,$A0);
        WMem(adr,puffer[i]);
        asm STI end; {enable}
        t:=tick+2; { ca. 50ms Time-Out (jenseits von gut und boese) fuer Byte-Write }
        repeat until (RMem(adr)=puffer[i]) or (tick>t);
        if (tick>t) then ok:=false;
        inc(adr); inc(i);
      end;
    end;
  begin { WriteAtmel }
    case dev of $5D,$D5         : pagesize:=128; { AT29C512/C010A }
                $DA,$A4         : pagesize:=256; { AT29C020/40A }
    end{case};
    i:=sizeof(puffer); s:=sizeof(puffer);
    while ok and (adr<memsize) do begin
      if (i>=s) and (adr<=(memsize-s)) then begin
        fread;
        i:=0;
      end;
      write(ATH(adr));
      case dev of $5D,$D5,$DA,$A4 : WritePage;   { AT29C512/C010/20/40A }
                  $05,$04,$07,$08,
                  $17,$0B,$13,$12 : WritePuffer; { AT49F001/2, AT49F010/20/40 }
      end{case};
      write(#8#8#8#8#8#8);
    end;
    write(ATH(adr)); writeln;
    if not ok then WriteFailure('');
  end;

  procedure WriteCatalyst;
  begin { WriteCatalyst, same as WriteIntel, Second Source }
    case dev of $94,$95 : Write28F001;
                $B4,$BD : Write28F0x0;
    end;
  end;

  procedure WriteHyundai;
  begin { WriteHyundai }
    case dev of $B0,$34 : WriteByteAMD;
    end;
  end;

  procedure WriteIntel;
  begin { WriteIntel }
    case dev of $94,$95 : Write28F001;
                $B4,$BD : Write28F0x0;
    end;
  end;

  procedure WriteMacronix;
  begin { WriteMacronix }
    case dev of $1A,$2A,$3C         : Write28F0x0;
                $18,$19,$B0,$34,$A4 : WriteByteAMD;
    end;
  end;

  procedure WriteMV;
  var s : word;
    procedure WritePage;
    var t : longint;
        b : byte;
    begin
      while ok and (i<s) do begin
        b:=puffer[i];
        asm CLI end; {disable}
        WMem($5555,$AA);
        WMem($2AAA,$55);
        WMem($5555,$A0);
        WMem(adr,b);
        asm STI end; {enable}
        t:=tick+2; { ca. 50ms Time-Out fuer Byte-Write }
        repeat until (RMem(adr)=b) or (tick>t);
        asm CLI end; {disable}
        WMem($5555,$AA);
        WMem($2AAA,$55);
        WMem($5555,$F0);
        asm STI end; {enable}
        if (tick>t) then ok:=false;
        inc(adr); inc(i);
      end;
    end;
  begin { WriteMV }
    s:=sizeof(puffer); i:=s;
    while ok and (adr<memsize) do begin
      if (i>=s) and (adr<=(memsize-s)) then begin
        fread;
        i:=0;
      end;
      write(ATH(adr));
      WritePage;
      write(#8#8#8#8#8#8);
    end;
    write(ATH(adr)); writeln;
    if not ok then WriteFailure('');
  end;

  procedure WriteSST;
    procedure WritePage128;
    var n : word;
        t : longint;
    begin
      asm CLI end; {disable}
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$A0);
      for n:=0 to 127 do begin
        WMem(adr,puffer[i]);
        inc(adr); inc(i);
      end;
      Pause(20); { 330 us warten }
      asm STI end; {enable}
      t:=tick+2; { ca. 50ms Time-Out fuer Page-Write }
      repeat until (RMem(adr-1)=puffer[i-1]) or (tick>t);
      if (tick>t) then ok:=false;
      asm CLI end; {disable}
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$F0);
      asm STI end; {enable}
    end;
    procedure WritePuffer;
    var t : longint;
    begin
      while ok and (i<sizeof(puffer)) do begin
        asm CLI end; {disable}
        case dev of $04     : WMem(adr,$10); { Byte Program }
                    $B5,$B6 : begin 
                                WMem($5555,$AA);
                                WMem($2AAA,$55);
                                WMem($5555,$A0);
                              end; 
        end;
        WMem(adr,puffer[i]);
        asm STI end; {enable}
        t:=tick+2; { ca. 50ms Time-Out (jenseits von gut und boese) fuer Byte-Write }
        repeat until (RMem(adr)=puffer[i]) or (tick>t);
        if (tick>t) then ok:=false;
        inc(adr); inc(i);
      end;
    end;
  begin { WriteSST }
    i:=sizeof(puffer);
    while ok and (adr<memsize) do begin
      if (i>=sizeof(puffer)) and (adr<=(memsize-sizeof(puffer))) then begin
        fread;
        i:=0;
      end;
      write(ATH(adr));
      case dev of $07,$10     : WritePage128; { PH29EE010/020 }
                  $04,$B5,$B6 : WritePuffer;  { PH28SF040, PH39SF010/20 }
      end;
      write(#8#8#8#8#8#8);
    end;
    write(ATH(adr)); writeln;
    if not ok then WriteFailure('');
    if ok and (dev in [$04]) then begin
      dummy:=RMem($1823);   { Software Data Protect }
      dummy:=RMem($1820);
      dummy:=RMem($1822);
      dummy:=RMem($0418);
      dummy:=RMem($041B);
      dummy:=RMem($0419);
      dummy:=RMem($040A);
    end;
  end;

  procedure WriteSTM;
  begin { WriteSTM }
    case dev of $A8,$AA,$02,$07 : Write28F0x0;  { M28F256(A)/512, M28F101 }
                $B0,$34,$E2     : WriteByteAMD; { M29F002T/NT/B, M29F040 }
    end;
  end;

  procedure WriteWinbond;
  var pagesize : word;
    procedure WritePage;
    var n : word;
        t : longint;
    begin
      asm CLI end; {disable}
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$A0);
      for n:=1 to pagesize do begin
        WMem(adr,puffer[i]);
        inc(adr); inc(i);
      end;
      Pause(667); { 10ms warten }
      asm STI end; {enable}
      t:=tick+2; { ca. 50ms Time-Out fuer Page-Write }
      repeat until (RMem(adr-1)=puffer[i-1]) or (tick>t);
      if (tick>t) then ok:=false;
      asm CLI end; {disable}
      WMem($5555,$AA);
      WMem($2AAA,$55);
      WMem($5555,$F0);
      asm STI end; {enable}
    end;
    procedure WriteWinPage;
    begin
      case dev of $C1,$45 : pagesize:=128;
                  $46     : pagesize:=256;
      end{case};
      i:=sizeof(puffer);
      while ok and (adr<memsize) do begin
        if (i>=sizeof(puffer)) and (adr<=(memsize-sizeof(puffer))) then begin
          fread;
          i:=0;
        end;
        write(ATH(adr));
        WritePage;
        write(#8#8#8#8#8#8);
      end;
      write(ATH(adr)); writeln;
      if not ok then WriteFailure('');
    end;
  begin { WriteWinbond }
    case dev of $C1,$45,$46 : WriteWinPage;
                $0B         : WriteByteAMD; { W49F002 }
    end;
  end;

{ procedure Schreiben }
begin
  reset(infile);
  adr:=0;
  case sprache of 'D' : write('Programmiere:  $');
                  'N' : write('Programmeren:  $');
                   else write('Programming:   $');
  end{case};
  case mfg of AMD      : WriteAMD;
              Atmel    : WriteAtmel;
              AS       : WriteAS;
              CSI      : WriteCatalyst;
              Hyundai  : WriteHyundai;
              Intel    : WriteIntel;
              MX       : WriteMacronix;
              MV       : WriteMV;
              SST      : WriteSST;
              STM      : WriteSTM;
              Winbond  : WriteWinbond;
  end;
  close(infile);
end;

procedure Pruefen;
begin
  reset(infile);
  verify:=true;
  adr:=0;
  case sprache of 'D' : write('Verifiziere:   $');
                  'N' : write('Controleren:   $');
                   else write('Verifying:     $');
  end{case};
  while (adr<datsize) and verify do begin
    fread;
    write(ATH(adr));
    i:=0;
    while (i<sizeof(puffer)) and verify do begin
      verify:=(RMem(adr)=puffer[i]);
      inc(adr); inc(i);
      if not verify then dec(adr);
    end;
    write(#8#8#8#8#8#8);
  end;
  write(ATH(adr)); writeln;
  if not verify then case sprache of 'D' : writeln('Verify fehlgeschlagen, bitte nochmal probieren.');
                                     'N' : writeln('Controle mislukt, probeer het nog eens aub.');
                                      else writeln('Verify mismatch, please try again.');
                     end{case};
  close(infile);
end;

procedure Auslesen;
begin
  assign(outfile,filename);
  rewrite(outfile);
  adr:=0;
  case sprache of 'D' : write('Auslesen:  $',ATH(adr));
                  'N' : write('Lezen:     $',ATH(adr));
                   else write('Reading:   $',ATH(adr));
  end{case};
  while (adr<memsize) do begin
    i:=0;
    write(#8#8#8#8#8#8,ATH(adr)); 
    while (i<sizeof(puffer)) do begin
      puffer[i]:=RMem(adr);
      inc(i); inc(adr);
    end;
    write(outfile,puffer); 
  end;
  write(#8#8#8#8#8#8,ATH(adr));
  close(outfile);
  writeln;
  case sprache of 'D' : writeln('Fertig.');
                  'N' : writeln('Klaar.');
                   else writeln('Ready.');
  end{case};
end;



begin { Hauptprogramm }

  autodetect:=true;
  autoident:=true;
  sprache:='D';
  if (ParamCount>0) then begin
    for i:=ParamCount downto 1 do begin
      filename:=ParamStr(i); 
      if filename[1] in ['-','/'] then begin
        d:=filename[2];
        if d in ['n','N'] then sprache:='N';
        if d in ['e','E'] then sprache:='E';
        if d in ['m','M'] then autodetect:=false;
      end;
    end{for};
  end;

  case sprache of 'D' : writeln('CTFLASH -- c''t-Flash-Schreiber, Version ',version);
                  'N' : writeln('CTFLASH -- c''t-Flash-Programmer, Versie ',version);
                   else writeln('CTFLASH -- c''t-Flash-Writer, Version ',version)
  end{case};
  case sprache of 'D' : writeln('Niederlndische bersetzung+Verbesserung: A.S. Kerkmeester, www.flashbios.org');
                  'N' : writeln('Nederlandse vertaling en verbeteringen: A.S. Kerkmeester, www.flashbios.org');
                   else writeln('Dutch translation and improvement: A.S. Kerkmeester, www.flashbios.org')
  end{case};

(*
  if get_run_mode in [rm_xms,rm_vcpi] then begin
    case sprache of 'D' : begin
                            writeln('ctflash muss direkten Hardware-Zugriff haben und kann deshalb nicht mit');
                            writeln('DPMI-Treibern (HIMEM.SYS, EMM386.EXE oder hnliche) oder in einer DOS-Box');
                            writeln('laufen. Starten Sie ein "nacktes" DOS, damit ctflash sicher funktioniert.');
                          end;
                    'N' : begin
                            writeln('ctflash moet direct toegang hebben tot de hardware. Het kan niet samenwerken met');
                            writeln('DPMI drivers zoals HIMEM.SYS, EMM386.EXE, etc. Tevens functioneert het niet');
                            writeln('in een DOS box. Start op met standaard DOS zodat ctflash betrouwbaar werkt.');
                          end;
                     else begin
                            writeln('ctflash requires direct hardware access. It can''t cooperate with');
                            writeln('DPMI drivers like HIMEM.SYS, EMM386.EXE or similar and doesn''t run'); 
                            writeln('in a DOS box. Start a plain DOS so that ctflash works reliably.');
                          end;
    end{case};
    writeln;

{$IFDEF DEBUG}
    writeln('get_run_mode = ',get_run_mode);
{$ENDIF}
    exit;
  end;
*)

  if (ParamCount>=3) and (ParamCount<=5) then begin
    ok:=true;

    typ:=ParamStr(1);
    while (Length(typ)<4) do typ:='0'+typ;
    IO:=HTW(typ);
    if (IO<$200) or (IO>$3FF) then begin
      ok:=false;
      case sprache of 'D' : writeln('I/O-Adresse muss im Bereich $200...$3FF liegen.');
                      'N' : writeln('Het I/O adres moet liggen tussen $200 en $3FF.');
                       else writeln('I/O address must be in the range of $200 to $3FF.')
      end{case};
    end;

    Lesen:=(ParamStr(2)<>'W') and (ParamStr(2)<>'w');
    filename:=ParamStr(3);
    datsize:=0;

    if not Lesen then begin
      assign(infile,filename);
      {$I-}
      reset(infile);
      {$I+}
      if (IOResult<>0) then begin
        ok:=false;
        case sprache of 'D' : writeln('Konnte Datei ',filename,' nicht ffnen.');
                        'N' : writeln('Kon het bestand ',filename,' niet openen.');
                        else writeln('Couldn''t open file ',filename,'.')
        end{case};
        end
       else begin
        datsize:=filesize(infile);
        close(infile);
      end;
    end;

    if ok then begin
      latch:=0;
      mfg:=UnknownMfg; dev:=UnknownDev;

      if (port[IO]<$80) or (port[IO]>$B8) then begin
        ok:=false;
        case sprache of 'D' : writeln('Flasher nicht gefunden, I/O-Adresse korrekt eingestellt?');
                        'N' : writeln('Kon de flasher niet vinden, is het I/O adres correct opgegeven?');
                         else writeln('Couldn''t find flasher, I/O address correctly set?')
        end{case};
       end
      else begin
        segment:=$C000 OR (word(port[IO] AND $3F) SHL 7);
        ok:=(segment>=$C800) and (segment<=$DC000);
        if not ok then case sprache of 'D' : writeln('Korrekte Speicheradresse eingestellt ($C8000...$DC000)?');
                                       'N' : writeln('Is het geheugenbereik correct ingesteld ($C8000...$DC000)?');
                                        else writeln('Memory range correctly set ($C8000...$DC000)?')
                       end{case};
      end;

      if ok then begin
        case sprache of 'D' : writeln('Flasher auf Segment $',WTH(segment),'.');
                        'N' : writeln('Flasher gevonden op geheugen segment $',WTH(segment),'.');
                         else writeln('Flasher at memory segment $',WTH(segment),'.')
        end{case};

        if autodetect then Identify;

        if (mfg=UnknownMfg) or (dev=UnknownDev) or (memsize=0) then begin

          if autodetect and (mfg=UnknownMfg) then begin
            autoident:=false;
            case sprache of 'D' : begin
                                    write('Baustein wurde nicht automatisch erkannt: ');
                                    writeln('Hersteller=$',BTH(mfg),', Device=$',BTH(dev));
                                    writeln('Manche Bausteine bentigen +12V, damit die automatische Erkennung');
                                    writeln('funktioniert. Stecken Sie probehalber J5 und ggf. J4 zustzlich');
                                    writeln('auf +12V und versuchen Sie es noch einmal.');
                                  end;
                            'N' : begin
                                    write('Kon de chip niet automatisch detecteren: ');
                                    writeln('Fabrikant=$',BTH(mfg),', Device=$',BTH(dev));
                                    writeln('Sommige chips hebben +12V nodig om automatisch te kunnen worden herkend.');
                                    writeln('Zet J5 en eventueel J4 op +12V en probeer het nog eens.');
                                  end;
                             else begin
                                    write('Could''nt identify chip automatically: ');
                                    writeln('Manufacturer=$',BTH(mfg),', Device=$',BTH(dev));
                                    writeln('Some chips need +12V in order to be automatically recognizable.');
                                    writeln('Set J5 and eventually J4 to +12V and try again.');
                                  end;
            end{case};
            end
           else if autodetect then begin
            case sprache of 'D' : write('Baustein wurde nicht vollstndig erkannt: Hersteller ',MfgStr(mfg),' ');
                            'N' : write('De chip is niet geheel herkent: Merk ',MfgStr(mfg),' ');
                             else write('Chip wasn''t recognized completely: Manufacturer ',MfgStr(mfg),' ')
            end{case};
            writeln(', Device=$',BTH(dev));
          end;
          if not Lesen then ManualSelect else begin
            case sprache of 'D' : writeln('Bitte geben Sie die Kapazitt vor:');
                            'N' : writeln('Geef de te lezen capaciteit op:');
                             else writeln('Please select capacity to be read:')
            end{case};
            writeln('(1)  32 KByte');
            writeln('(2)  64 KByte');
            writeln('(3) 128 KByte');
            writeln('(4) 256 KByte');
            writeln('(5) 512 KByte');
            GetKey('');
            case d of '1' : memsize:= 32*1024;
                      '2' : memsize:= 64*1024;
                      '3' : memsize:=128*1024;
                      '4' : memsize:=256*1024;
                      '5' : memsize:=512*1024;
                       else memsize:=0;
            end;
            mfg:=UnknownMfg; dev:=0;
          end;
        end;

        if (mfg<>UnknownMfg) and (dev<>UnknownDev) then
          case sprache of 'D' : writeln('Bausteintyp ',typ,' von ',MfgStr(mfg),', Kapazitt: ',memsize SHR 10,' KByte');
                          'N' : writeln('Chip type ',typ,' van ',MfgStr(mfg),', capaciteit: ',memsize SHR 10,' KByte');
                           else writeln('Chip type ',typ,' from ',MfgStr(mfg),', capacity: ',memsize SHR 10,' KByte')
          end{case};

        if not Lesen and (mfg<>UnknownMfg) and (memsize>0) and (memsize<>datsize) then begin
          ok:=false;
          case sprache of 'D' : writeln('Gren von Binrdatei und Flash-Baustein passen nicht zusammen:');
                          'N' : writeln('De grootte van het binaire bestand en de chip komen niet overeen:');
                           else writeln('Sizes of binary file and chip don''t match:')
          end{case};
          case sprache of 'D' : write('Datei: ',(datsize SHR 10),' KByte ');
                          'N' : write('Bestand: ',(datsize SHR 10),' KByte ');
                           else write('File: ',(datsize SHR 10),' KByte ')
          end{case};
          if (datsize>memsize) then write('>') else write('<');
          case sprache of 'D' : writeln(' Baustein: ',(memsize SHR 10),' KByte.');
                          'N' : writeln(' Chip: ',(memsize SHR 10),' KByte.');
                           else writeln(' Chip: ',(memsize SHR 10),' KByte.')
          end{case};
          if (datsize<memsize) then begin
            case sprache of 'D' : write('Baustein trotzdem schreiben (wird mit $FF aufgefllt) (J/N)? ');
                            'N' : write('De chip in elk geval beschrijven (in het geheel met $FF) (J/N)? ');
                             else write('Write chip anyway (will be filled up with $FF) (Y/N)? ')
            end{case};
            GetKey('');
            ok:=(d in ['j','J','y','Y']);
            writeln;
          end;
        end;

        if ok and not Lesen and (mfg<>UnknownMfg) and (memsize>0) then begin

          if (J5 or J4) and not autoident then begin
            case sprache of 'D' : write('Beim ',typ,' ');
                            'N' : write('Bij het ',typ,' ');
                             else write('With the ',typ,' ')
            end{case};
            if J5 and J4 then case sprache of 'D' : write('mssen ');
                                              'N' : write('moeten ');
                              end{case}


              else case sprache of 'D' : write('muss ');
                                   'N' : write('moet ');
                   end{case};
            if J5 then write('J5 ');
            if J5 and J4 then case sprache of 'D' : write('und ');
                                              'N' : write('en ');
                                               else write('and ')
                              end{case};
            if J4 then write('J4 ');
            case sprache of 'D' : writeln('auf +12V gesteckt sein.');
                            'N' : writeln('op +12V gezet zijn.');
                             else begin 
                                    if J4 then write('have ') else write('has ');
                                    writeln('to be set to +12V.');
                                  end
            end{case};
            case sprache of 'D' : write('Fortfahren (J/N)? ');
                            'N' : write('Verder gaan (J/N)? ');
                             else write('Continue (Y/N)? ')
            end{case};
            GetKey('');
            if not (d in ['J','j','y','Y']) then ok:=false;
          end;

          if ok then Loeschen;
          if ok then Leertest;
          if ok then Schreiben;
          if ok then Pruefen;
          if ok then case sprache of 'D' : writeln('Fertig.');
                                     'N' : writeln('Klaar.');
                                      else writeln('Complete.')
                     end{case};
          if J5 or J4 then case sprache of 'D' : writeln('Vergessen Sie nicht, J5/J4 zurckzustecken.');
                                           'N' : writeln('Vergeet niet J5/J4 terug te zetten op hun originele posities.');
                                            else writeln('Don''t forget to set J5/J4 back to their original positions.')
                                end{case};

        end;

        if ok and (memsize>0) and Lesen then Auslesen;

      end;
    end;
   end

   else begin
      case sprache of 'D' : writeln('CTFLASH schreibt eine Binrdatei mit dem c''t-Flasher in BIOS-Bausteine.');
                      'N' : writeln('CTFLASH schrijft binaire bestanden in BIOS chips m.b.v. de c''t-Flasher.');
                       else writeln('CTFLASH writes a binary file into BIOS chips using the c''t-Flasher PCB.')
      end{case};

      case sprache of 'D' : begin
      writeln('Aufruf: ctflash IO R/W FILE [/M] [/N|E]');
      writeln('                IO                     - eingestellte I/O-Adresse im Hex-Format');
      writeln('                   R/W                 - ''R'': auslesen, ''W'': schreiben');
      writeln('                       FILE            - kompletter Pfad zur Binrdatei');
      writeln('                             /M        - manuelle Auswahl des Bausteintyps');
      writeln('                                  /N|E - Nederlands|English');
      writeln('Also beispielsweise: ctflash 340 W A:\BIOS\VER0108.BIN');
      writeln('Diese Version beherrscht folgende EEPROM- bzw. Flash-Chips:');
      end;

      'N' : begin
      writeln('Gebruik:  ctflash IO R/W FILE [/M] [/N|E]');
      writeln('                  IO                     - I/O address in hexadecimaal formaat');
      writeln('                     R/W                 - ''R'': uitlezen, ''W'': beschrijven');
      writeln('                         FILE            - volledig path van binaire bestand');
      writeln('                               /M        - forceer handmatige chip selectie');
      writeln('                                    /N|E - Nederlands|English');
      writeln('Voorbeeld: ctflash 340 W A:\BIOS\VER0108.BIN');
      writeln('Deze versie kan de volgende EEPROM en flash chips aan:');
      end;

      else begin
      writeln('Usage:  ctflash IO R/W FILE [/M] [/N|E]');
      writeln('                IO                     - preset I/O address in hex format');
      writeln('                   R/W                 - ''R'': read into, ''W'': write from file');
      writeln('                       FILE            - full path to binary file');
      writeln('                             /M        - force manual chip selection');
      writeln('                                  /N|E - Nederlands|English');
      writeln('For example: ctflash 340 W A:\BIOS\VER0108.BIN');
      writeln('This version handles the following EEPROM and flash chips:');
      end
      end{case};

      writeln('AMD            Am28F010(A)/20(A), Am29F010/02/40(=A29040)');
      writeln('Atmel          AT29C512/010A/20(=A290021)/40A, AT49F001/02/40');
      writeln('Catalyst (CSI) CAT28F001Bx-T/B, CAT28F010/20');
      writeln('Hyundai        HY29F002T/B');
      writeln('Intel          i28F001Bx-T/B, i28F010(Z28F010)/20');
      writeln('Macronix       MX28F1000P (=H.T.M21xxx), MX28F2000P/T, MX29F002(N)T/B/040');
      writeln('Mosel-Vitelic  F/V29C51002T/B (Boot Block unprotected!)');
      writeln('SST            PH29EE010/20, PH28SF040, PH39SF010/20');
      writeln('ST Microelec.  M28F256(A)/512, M28F101, M29F002T/NT/B/040');
      writeln('Winbond        W29EE011 (=AE29F1008), W29C010/11/20(=AE29F2008)/40, W49F002');
      writeln;
      case sprache of 'D' : write('Mehr ber den : ');
                      'N' : write('Meer info over de c''t-Flasher: ')
                       else write('More about the c''t-Flasher: ')
      end{case};
      write('www.heise.de/ct/ftp/projekte/flasher/');
      case sprache of 'D' : writeln;
                      'N' : writeln(' (Duits)');
                       else writeln(' (German)');
      end{case};
    end;

end.

