VERSION 5.00
Begin VB.UserControl tob 
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   3600
   ScaleWidth      =   4800
End
Attribute VB_Name = "tob"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Type SECURITY_ATTRIBUTES
    nLength              As Long
    lpSecurityDescriptor As Long
    bInheritHandle       As Boolean
End Type

Private Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
End Type

Private Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion As Long
    dwMinorVersion As Long
    dwBuildNumber As Long
    dwPlatformID As Long
    szCSDVersion As String * 128
End Type

Private Const MAX_SIZE = 2048
Private Const MAX_INISIZE = 8192

Private Const HKEY_CURRENT_USER = &H80000001
Private Const HKEY_LOCAL_MACHINE = &H80000002
Private Const HKEY_USERS = &H80000003
Private Const HKEY_DYN_DATA = &H80000006
Private Const HKEY_CURRENT_CONFIG = &H80000005
Private Const HKEY_CLASSES_ROOT = &H80000000

Private Const ERROR_SUCCESS = 0&
Private Const ERROR_FILE_NOT_FOUND = 2&
Private Const ERROR_MORE_DATA = 234
Private Const ERROR_NO_MORE_ITEMS = 259&

Private Const REG_OPTION_NON_VOLATILE = 0

Private Const REG_CREATED_NEW_KEY = &H1
Private Const REG_OPENED_EXISTING_KEY = &H2

Private Const REG_NONE = 0
Private Const REG_SZ = 1
Private Const REG_EXPAND_SZ = 2
Private Const REG_BINARY = 3
Private Const REG_DWORD = 4

Private Const KEY_QUERY_VALUE = &H1
Private Const KEY_SET_VALUE = &H2
Private Const KEY_CREATE_SUB_KEY = &H4
Private Const KEY_ENUMERATE_SUB_KEYS = &H8
Private Const KEY_ALL_ACCESS = &HF003F

Const HWND_BROADCAST = &HFFFF&
Const WM_SETTINGCHANGE = &H1A&
Const SPI_SETNONCLIENTMETRICS = 42&
Const SMTO_NORMAL = 0&
Const SMTO_ABORTIFHUNG = 2&

Private Declare Function SendMessageTimeout Lib "user32" Alias "SendMessageTimeoutA" (ByVal hwnd As Long, ByVal msg As Long, ByVal wParam As Long, ByVal lParam As Long, ByVal fuFlags As Long, ByVal uTimeout As Long, lpdwResult As Long) As Long

Private Declare Function RegEnumValue Lib "advapi32.dll" _
        Alias "RegEnumValueA" (ByVal hKey As Long, ByVal dwIndex As Long, _
        ByVal lpValueName As String, lpcbValueName As Long, ByVal lpReserved As Long, _
        lpType As Long, lpData As Any, lpcbData As Long) As Long

Private Declare Function RegDeleteValue Lib "advapi32.dll" _
        Alias "RegDeleteValueA" _
        (ByVal hKey As Long, ByVal lpValueName As String) _
        As Long

Private Declare Function RegDeleteKey Lib "advapi32.dll" _
        Alias "RegDeleteKeyA" _
        (ByVal hKey As Long, ByVal lpSubKey As String) As Long

Private Declare Function RegOpenKeyEx Lib "advapi32.dll" _
        Alias "RegOpenKeyExA" _
        (ByVal hKey As Long, ByVal lpSubKey As String, _
        ByVal ulOptions As Long, ByVal samDesired As Long, _
        phkResult As Long) As Long

Private Declare Function RegCreateKeyEx Lib "advapi32.dll" _
        Alias "RegCreateKeyExA" _
        (ByVal hKey As Long, ByVal lpSubKey As String, _
        ByVal Reserved As Long, ByVal lpClass As String, _
        ByVal dwOptions As Long, ByVal samDesired As Long, _
        lpSecurityAttributes As SECURITY_ATTRIBUTES, phkResult As Long, _
        lpdwDisposition As Long) As Long

Private Declare Function RegQueryValueEx Lib "advapi32.dll" _
        Alias "RegQueryValueExA" _
        (ByVal hKey As Long, ByVal lpszValueName As String, _
        ByVal lpdwReserved As Long, lpdwType As Long, _
        lpData As Any, lpcbData As Long) As Long

Private Declare Function RegSetValueEx Lib "advapi32.dll" _
        Alias "RegSetValueExA" _
        (ByVal hKey As Long, ByVal lpValueName As String, _
        ByVal Reserved As Long, ByVal dwType As Long, _
        lpData As Any, ByVal cbData As Long) As Long


Private Declare Function RegEnumKeyEx Lib "advapi32.dll" _
        Alias "RegEnumKeyExA" (ByVal hKey As Long, ByVal dwIndex _
        As Long, ByVal lpName As String, lpcbName As Long, _
        ByVal lpReserved As Long, ByVal lpClass As String, _
        lpcbClass As Long, lpftLastWriteTime As FILETIME) As Long

Private Declare Function RegCloseKey Lib "advapi32.dll" _
        (ByVal hKey As Long) As Long


Private Declare Function GetVersionEx Lib "kernel32" _
        Alias "GetVersionExA" (ByRef lpVersionInformation _
        As OSVERSIONINFO) As Long

Private Declare Function GetSystemMetrics Lib "user32.dll" (ByVal nIndex As Long) As Long

Public Function RegDelete(ByVal key As String) As Long
    Dim pos1 As Long
    Dim parentkey As String
    Dim childkey As String
    Dim handle As Long
    Dim keydelete As Boolean
    

    If Right(key, 1) = "\" Then
        ' delete subkey
        key = Left(key, Len(key) - 1)
        keydelete = True
    Else
        ' delete value
        keydelete = False
    End If
    
    pos1 = InstrRev(key, "\")
    If pos1 = 0 Then
        Err.Raise vbObjectError + 2, "RegDelete", "key invalid."
    End If

    parentkey = Left(key, pos1 - 1)
    childkey = Mid(key, pos1 + 1)
    handle = OpenKey(parentkey)
    If keydelete Then
        ' delete key
        RegDelete = RegDeleteKey(handle, childkey)
    Else
        ' delete value
        RegDelete = RegDeleteValue(handle, childkey)
    End If
End Function


Public Function RegEnum(ByVal key As String) As Collection
    Dim keylist As New Collection
    Dim handle As Long
    Dim storage As String
    Dim result As Long
    Dim index As Long
    Dim storagesize As Long
    Dim LastWriteTime As FILETIME
    Dim pos1 As Long
    
    
    index = 0

    If Right(key, 1) = "\" Then
       ' enum keys
    
        handle = OpenKey(key)

        Do
            storage = Space(MAX_SIZE)
            storagesize = MAX_SIZE
            result = RegEnumKeyEx(handle, index, storage, storagesize, 0&, 0&, 0&, LastWriteTime)
            If result <> ERROR_NO_MORE_ITEMS Then
                keylist.Add Left(storage, storagesize)
                index = index + 1
            End If
        Loop Until result = ERROR_NO_MORE_ITEMS
    Else
        ' enum values
        handle = OpenKey(key)
        Do
            storage = Space(MAX_SIZE)
            storagesize = MAX_SIZE
            result = RegEnumValue(handle, index, storage, storagesize, ByVal 0&, ByVal 0&, ByVal 0&, ByVal 0&)
            If result <> ERROR_NO_MORE_ITEMS Then
                keylist.Add Left(storage, storagesize)
                index = index + 1
            End If
        Loop While result <> ERROR_NO_MORE_ITEMS
    End If
    Call RegCloseKey(handle)
    Set RegEnum = keylist
End Function


Public Function RegRead(ByVal key As String, Optional ValueType As Variant = "REG_SZ") As Variant

    Dim datalength As Long
    Dim binvalue As Long
    Dim mainkey As String
    Dim subkey As String
    Dim pos1 As Long
    Dim handle As Long
    Dim result As Long
    Dim storage As String
    Dim datavalue As Long
    Dim vartype As Long
    Dim x As Long
    Dim charcode As Integer
    

    ' split key:

    If Right(key, 1) = "\" Then
        ' read default value
        mainkey = Left(key, Len(key) - 1)
        subkey = vbNullString
    Else
        ' read specific value
        pos1 = InstrRev(key, "\")
        If pos1 = 0 Then
            Err.Raise vbObjectError + 7, "RegRead", "invalid key: """ & key & """"
        End If
        
        mainkey = Left(key, pos1 - 1)
        subkey = Mid(key, pos1 + 1)
    End If
    
    handle = OpenKey(mainkey)
    
    result = RegQueryValueEx(handle, subkey, 0, vartype, "", datalength)
    Select Case vartype
        Case 1
            ValueType = "REG_SZ"
        Case 2
            ValueType = "REG_EXPAND_SZ"
        Case 3
            ValueType = "REG_BINARY"
        Case 4
            ValueType = "REG_DWORD"
        Case Else
            ValueType = ""
    End Select
    
    If result = ERROR_MORE_DATA Then
        If vartype = REG_SZ Or vartype = REG_EXPAND_SZ Then
            storage = Space(datalength)
            result = RegQueryValueEx(handle, subkey, 0, vartype, ByVal storage, datalength)
            If datalength = 0 Then
                storage = ""
            Else
                storage = Left(storage, datalength - 1)
            End If
        ElseIf vartype = REG_BINARY Then
            ReDim bytearray(datalength) As Byte
            result = RegQueryValueEx(handle, subkey, 0, vartype, bytearray(0), datalength)
            For x = 1 To datalength
                'charcode = Asc(Mid(storage, x, 1))
                charcode = bytearray(x - 1)
                RegRead = RegRead & Right("0" & Hex(charcode), 2) & " "
            Next
            storage = Trim(RegRead)
        ElseIf vartype = REG_DWORD Then
            result = RegQueryValueEx(handle, subkey, 0, vartype, datavalue, 4)
            storage = CStr(datavalue)
        End If
    End If
    If result = ERROR_SUCCESS Then
            RegRead = storage
    Else
        Err.Raise vbObjectError + 8, "RegRead", "couldn't read key """ & key & """"
    End If
    Call RegCloseKey(handle)
End Function


Public Function RegWrite(ByVal key As String, ByVal storage As String, Optional ByVal vartype As String = "REG_SZ") As Boolean
    Dim mainkey As String
    Dim ValueName As String
    Dim pos1 As Long
    Dim pos2 As Long
    Dim handle As Long
    Dim datalength As Long
    Dim result As Long
    Dim bytecount As Long
    Dim bytechar As String
    Dim bytevals As String
    Dim x As Long
    Dim singchar As String
    Dim singval As Integer
    Dim datastore As Long
    Dim rootkey As String
    Dim newkey As String
    Dim temphandle As Long
    Dim secAttribs As SECURITY_ATTRIBUTES
    Dim disposition As Long
    Dim storageansi As String
    

    If Right(key, 1) = "\" Then
        ' (standard) value
        mainkey = Left(key, Len(key) - 1)
        ValueName = vbNullString
    Else
        ' named value
        pos2 = InstrRev(key, "\")
        mainkey = Left(key, pos2 - 1)
        ValueName = Mid(key, pos2 + 1)
    End If
    
    If InStr(mainkey, "\") = 0 Then
        ' main key
        handle = OpenKey(mainkey)
    Else
        ' named key, may be necessary to create
        rootkey = Left(mainkey, InStr(mainkey, "\") - 1)
        newkey = Mid(mainkey, InStr(mainkey, "\") + 1)
        temphandle = OpenKey(rootkey)
        result = RegCreateKeyEx(temphandle, newkey, 0, "", REG_OPTION_NON_VOLATILE, KEY_CREATE_SUB_KEY Or KEY_SET_VALUE, secAttribs, handle, disposition)
    End If
    
    If handle = 0 Then
        Err.Raise vbObjectError + 15, "RegWrite", "Error creating/accessing key """ & key & """ Error #: " & result
    End If
    
    Select Case UCase(vartype)
        Case "REG_SZ"
            datalength = Len(storage) + 1
            result = RegSetValueEx(handle, ValueName, 0, REG_SZ, ByVal storage, datalength)
        Case "REG_BINARY"
            storage = Trim(storage) & " "
            bytecount = 0
            bytevals = ""
            bytechar = ""
            For x = 1 To Len(storage)
                singchar = Mid(storage, x, 1)
                If singchar = " " Then
                    singval = Fix("&H" & bytechar)
                    If singval > 255 Then
                        Err.Raise vbObjectError + 12, "RegWrite", "Invalid binary (greater than 255): """ & storage & """"
                    End If
                    bytevals = bytevals & Chr(singval)
                    bytecount = bytecount + 1
                    bytechar = ""
                Else
                    bytechar = bytechar & singchar
                End If
            Next
            
            storageansi = StrConv(bytevals, vbFromUnicode)
            result = RegSetValueEx(handle, ValueName, 0, REG_BINARY, ByVal StrPtr(storageansi), bytecount)
        
        Case "REG_DWORD"
            datalength = 4
            datastore = CLng(storage)
            result = RegSetValueEx(handle, ValueName, 0, REG_DWORD, datastore, datalength)
    End Select
    Call RegCloseKey(handle)
    If result = ERROR_SUCCESS Then
        RegWrite = True
    Else
        RegWrite = False
    End If
End Function

Private Function GetMainKey(ByVal key As String) As Long
    Dim tempkey As String
    
    Select Case UCase(key)
        Case "HKCU"
            GetMainKey = HKEY_CURRENT_USER
        Case "HKEY_CURRENT_USER"
            GetMainKey = HKEY_CURRENT_USER
        Case "HKLM"
            GetMainKey = HKEY_LOCAL_MACHINE
        Case "HKEY_LOCAL_MACHINE"
            GetMainKey = HKEY_LOCAL_MACHINE
        Case "HKU"
            GetMainKey = HKEY_USERS
        Case "HKEY_USERS"
            GetMainKey = HKEY_USERS
        Case "HKDD"
            GetMainKey = HKEY_DYN_DATA
        Case "HKEY_DYN_DATA"
            GetMainKey = HKEY_DYN_DATA
        Case "HKCC"
            GetMainKey = HKEY_CURRENT_CONFIG
        Case "HKEY_CURRENT_CONFIG"
            GetMainKey = HKEY_CURRENT_CONFIG
        Case "HKCR"
            GetMainKey = HKEY_CLASSES_ROOT
        Case "HKEY_CLASSES_ROOT"
            GetMainKey = HKEY_CLASSES_ROOT
        Case "WINUSER"
            tempkey = "HKCU\Software\Microsoft\" & GetWinVer & "\CurrentVersion\"
            GetMainKey = OpenKey(tempkey)
        Case "WINMACHINE"
            tempkey = "HKLM\Software\Microsoft\" & GetWinVer & "\CurrentVersion\"
            GetMainKey = OpenKey(tempkey)
        Case Else
            Err.Raise vbObjectError + 3, "GetMainKey", "unknown main key: """ & key & """"
    End Select
End Function

Private Function OpenKey(ByVal key As String) As Long
    Dim pos1 As Long
    Dim pos2 As Long
    Dim mainkey As String
    Dim subkey As String
    Dim result As Long
    
    If InStr(key, "\") = 0 Then
        ' main key
        OpenKey = GetMainKey(key)
    Else
        mainkey = Left(key, InStr(key, "\") - 1)
        subkey = Mid(key, InStr(key, "\") + 1)
        result = RegOpenKeyEx(GetMainKey(mainkey), subkey, 0, KEY_ALL_ACCESS, OpenKey)
        If result <> ERROR_SUCCESS Then
            Err.Raise vbObjectError + 4, "OpenKey", "unable to open key """ & key & """, Error # " & result
        End If
    End If
End Function

Public Function KeyExists(ByVal key As String) As Boolean
    Dim handle As Long
    
    On Error Resume Next
    If Right(key, 1) = "\" Then
        ' a key
        handle = OpenKey(key)
        KeyExists = Not (handle = 0)
        Err.Clear
        If Not handle = 0 Then RegCloseKey (handle)
    Else
        On Error Resume Next
        Call RegRead(key)
        KeyExists = (Err.Number = 0)
        Err.Clear
    End If
    On Error GoTo 0
End Function

Private Function InstrRev(text, such)
    Dim pos As Long
    Do
        InstrRev = pos
        pos = InStr(pos + 1, text, such)
    Loop Until pos = 0
End Function

Public Function GetWinVer() As String
    Dim osinfo As OSVERSIONINFO
    osinfo.dwOSVersionInfoSize = Len(osinfo)
    GetVersionEx osinfo
    If osinfo.dwPlatformID = 2 Then
        GetWinVer = "Windows NT"
    Else
        GetWinVer = "Windows"
    End If
End Function

Public Sub FlushIconCache()
    Dim iconsize As Long
    iconsize = GetMetrics(11)
    If iconsize < 10 Then iconsize = 32
    RegWrite "HKEY_CURRENT_USER\Control Panel\Desktop\WindowMetrics\Shell Icon Size", iconsize + 1
    RefreshWindowMetrics
    RegWrite "HKEY_CURRENT_USER\Control Panel\Desktop\WindowMetrics\Shell Icon Size", iconsize
    RefreshWindowMetrics
End Sub

Public Function GetMetrics(ByVal index As Long) As Long
    GetMetrics = GetSystemMetrics(index)
End Function

Public Sub RefreshWindowMetrics()
    Dim result As Long
    Dim stringdata As String
    stringdata = "WindowMetrics" & Chr(0)
    result = SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, SPI_SETNONCLIENTMETRICS, StrPtr(stringdata), SMTO_NORMAL Or SMTO_ABORTIFHUNG, 10000&, 0&)
End Sub

Public Function Search(ByVal key As String, ByVal searchtext As String, Optional ByVal mode As Long = 7) As String
    Dim subkeys As Collection
    Dim subkey As Variant
    
    On Error Resume Next
    
    ' get subkeys
    Set subkeys = RegEnum(key)
    
    If (mode And 1) Then Search = Search & SearchForKey(key, searchtext, mode)
    If (mode And 2) Then Search = Search & SearchForName(key, searchtext, mode)
    If (mode And 4) Then Search = Search & SearchForVal(key, searchtext, mode)

    For Each subkey In subkeys
        Search = Search & Search((key & subkey & "\"), searchtext, mode)
    Next
End Function

Public Function SearchForKey(ByVal key As String, ByVal searchtext As String, ByVal mode As Long) As String
    On Error Resume Next
    
    If (mode And 8) Then
        If InStr(LCase(searchtext), LCase(key)) > 0 Then
           SearchForKey = SearchForKey & "KEY" & vbTab & key & vbCr
        End If
    ElseIf (mode And 16) Then
        If Left(LCase(key), Len(searchtext)) = LCase(searchtext) Then
            SearchForKey = SearchForKey & "KEY" & vbTab & key & vbCr
        End If
    ElseIf (mode And 32) Then
        If Right(LCase(key), Len(searchtext)) = LCase(searchtext) Then
            SearchForKey = SearchForKey & "KEY" & vbTab & key & vbCr
        End If
    End If
End Function

Public Function SearchForName(ByVal key As String, ByVal searchtext As String, ByVal mode As Long) As String
    Dim subvals As Collection
    Dim subval As Variant
    
    On Error Resume Next
    
    Set subvals = RegEnum(Left(key, Len(key) - 1))
    For Each subval In subvals
        If (mode And 8) Then
            If InStr(LCase(searchtext), LCase(subval)) > 0 Then
                SearchForName = SearchForName & "NAME" & vbTab & key & vbCr
            End If
        ElseIf (mode And 16) Then
            If Left(LCase(subval), Len(searchtext)) = LCase(searchtext) Then
                SearchForName = SearchForName & "NAME" & vbTab & key & vbCr
            End If
        ElseIf (mode And 32) Then
            If Right(LCase(subval), Len(searchtext)) = LCase(searchtext) Then
                SearchForName = SearchForName & "NAME" & vbTab & key & vbCr
            End If
        End If
    Next
End Function

Public Function SearchForVal(ByVal key As String, ByVal searchtext As String, ByVal mode As Long) As String
    Dim subvals As Collection
    Dim subval As Variant
    Dim retval As String
    
    On Error Resume Next
    
    Set subvals = RegEnum(Left(key, Len(key) - 1))
    For Each subval In subvals
        retval = RegRead(key & subval)
        If (mode And 8) Then
            If InStr(LCase(searchtext), LCase(retval)) > 0 Then
                SearchForVal = SearchForVal & "VALUE" & vbTab & key & vbCr
            End If
        ElseIf (mode And 16) Then
            If Left(LCase(retval), Len(searchtext)) = LCase(searchtext) Then
                SearchForVal = SearchForVal & "VALUE" & vbTab & key & vbCr
            End If
        ElseIf (mode And 32) Then
            If Right(LCase(retval), Len(searchtext)) = LCase(searchtext) Then
                SearchForVal = SearchForVal & "VALUE" & vbTab & key & vbCr
            End If
        End If
    Next
End Function
