Unit NWDos;

{ Netzwerkfhige DOS-Dateifunktionen unter Borland-Pascal
  (C) Copyright 1994 Alexander Schulze }

Interface

Uses
 Dos;

Const
 am_ReadOnly   = $00;                  { Zugriffs-Modi }
 am_WriteOnly  = $01;                  { am = AccessMode }
 am_ReadWrite  = $02;

 sm_compatible = $00;                  { Share-Modi }
 sm_denyAll    = $01;                  { sm = ShareMode }
 sm_denyWrite  = $02;
 sm_denyRead   = $03;
 sm_denyNone   = $04;

Function ShareInstalled: Boolean;

Function NetSeek
          (Var FileVar; Posi: LongInt): Integer;
Function NetReset
          (Var FileVar; BlockSize: Word;
           AccessMode, ShareMode: Byte): Integer;
Function NetRewrite
          (Var FileVar; BlockSize: Word;
           AccessMode, ShareMode: Byte): Integer;
Function NetRead
          (Var FileVar; Var Buff;
           Soll: Word; Var Ist: Word): Integer;
Function NetWrite
          (Var FileVar; Var Buff;
           Soll: Word; Var Ist: Word): Integer;

Function NetTruncate
          (Var FileVar): Integer;
Function NetClose
          (Var FileVar): Integer;
Function NetErase
          (Var FileVar): Integer;
Function NetFilePos
          (Var FileVar): LongInt;
Function NetFileSize
          (Var FileVar): LongInt;

Function NetLock
          (Var FileVar; Posi,Anz : LongInt): Integer;
Function NetUnlock
          (Var FileVar; Posi,Anz : LongInt): Integer;

Function NetLockFileArea
          (Var FileVar; Posi,Anz : LongInt): Integer;
Function NetUnlockFileArea
          (Var FileVar; Posi,Anz : LongInt): Integer;

Implementation

{ Ist SHARE.EXE resident geladen ? }
Function ShareInstalled: Boolean;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ax:= $1000;                         { 1000h = Funktionsnummer }
   Intr($2F,Regs);                     { 2Fh   = Multiplex-Interrupt }
   ShareInstalled:= al = $FF           { FFh   = Share geladen }
  End
End;


{ bestimmten Datensatz anspringen }
Function NetSeek(Var FileVar; Posi: LongInt): Integer;
Var
 Regs: Registers;
Begin
 With FileRec(FileVar),Regs do
  Begin
   ah:= $42;                             { 42h = File Seek }
   al:= $00;                             { 00h = relativ zum Dateianfang }
   bx:= Handle;
   Posi:= Posi * RecSize;                { Byte Position errrechnen }
   cx:= Posi shr 16;                     { und nach [CX:DX] bertragen }
   dx:= Posi and $FFFF;
   MsDos(Regs);                          { DOS-Funktion ausfhren }
   If (Flags and fCarry) = 0             { Falls kein Fehler }
    then NetSeek:= 0                     { Ergebnis O.K. }
    else NetSeek:= ax                    { sonst Fehlercode zurck }
  End
End;

{ Datei ffnen mit Netzwerkfunktionalitt }
Function NetReset
         (Var FileVar; BlockSize: Word;
          AccessMode, ShareMode: Byte): Integer;
Var
 Regs: Registers;
Begin
 With FileRec(FileVar), Regs do
  Begin
   ah:= $3D;                           { 3Dh = File Open }
   al:= (AccessMode and $03) or        { Zugriffs- und Sharemode bergeben }
        ((ShareMode and $07) shl 4);
   ds:= Seg(Name);                     { Zeiger auf den Dateinamen }
   dx:= Ofs(Name);
   RecSize:= BlockSize;                { Block-/Datensatzgre }
   Case AccessMode of
     am_ReadOnly : Mode:= fmOutput;    { Borland-Datei-Modi }
     am_WriteOnly: Mode:= fmInput;
     am_ReadWrite: Mode:= fmInOut;
     else          Mode:= fmInOut
    End;
   MsDos(Regs);                        { DOS-Funktion ausfhren }
   If (Flags and fCarry) = 0           { Falls kein Fehler aufgetreten }
    then
     Begin
      Handle:= ax;                     { Handle bertragen }
      NetReset:= 0                     { und Ergebis O.K. }
     End
    else NetReset:= ax                 { sonst Fehlercode zurck }
  End;

 NetSeek(FileVar,0)                    { zur Sicherheit }
End;

{ Datei schlieen }
Function NetClose(Var FileVar): Integer;
Var
 Regs: Registers;
Begin
 With FileRec(FileVar), Regs do
  Begin
   NetClose:= 0;                       { Bisher kein Fehler }
   If Handle = 0                       { Falls ungltiges Handle }
    then Exit;                         { gefunden, Funktion verlassen }

   ah:= $3E;                           { 3Eh = File Close }
   bx:= Handle;
   Mode:= fmClosed;                    { Borland Datei-Modus setzen }
   MsDos(Regs);                        { und DOS-Funktion aufrufen }
   If (Flags and fCarry) <> 0          { Falls Fehler }
    then NetClose:= ax                 { Code bergeben }
  End
End;

{ Erstellen einer Datei und ffnen mit Netzwerkfunktionalitt }
Function NetRewrite(Var FileVar; BlockSize: Word; AccessMode, ShareMode: Byte): Integer;
Var
 Regs: Registers;
Begin
 With FileRec(FileVar),Regs do
  Begin
   ah:= $3C;                           { 3Ch = File Create }
   cx:= 0;                             { Attr = Normal }
   ds:= Seg(Name);                     { Dateinamen adressieren }
   dx:= Ofs(Name);
   MsDos(Regs);                        { DOS-Funktion ausfhren }
   If (Flags and fCarry) = 0           { Falls kein Fehler aufgetreten }
    then
     Begin
      NetClose(FileVar);               { Datei wieder schlieen }
      NetRewrite:=                     { und mit zustzlichen Parametern }
       NetReset                        { wieder ffnen }
        (FileVar,BlockSize,
         AccessMode,ShareMode)
     End
    else
     NetRewrite:= ax                   { sonst Fehlercode zurck }
  End
End;

{ Lesen von Datenstzen }
Function NetRead
 (Var FileVar; Var Buff; Soll: Word; Var Ist: Word): Integer;
Var
 Regs: Registers;
Begin
 NetRead:= 0;                          { Bisher kein Fehler }
 Ist:= 0;                              { und nichts gelesen }
 If Soll <= 0 then Exit;               { gibt's berhaupt was zu lesen }

 With FileRec(FileVar),Regs do
  Begin
   ah:= $3F;                           { 3Fh = File Read }
   bx:= Handle;                        { Handle bertragen }
   cx:= RecSize * Soll;                { Lnge berechnen }
   ds:= Seg(Buff);                     { Zeiger auf Puffer setzen }
   dx:= Ofs(Buff);
   MsDos(Regs);                        { DOS-Funktion ausfhren }
   If (Flags and fCarry) = 0           { Falls alles O.K. }
    then
     Begin
      Ist:= ax div RecSize;            { Anz. gelesener Datenstze erm. }
      NetRead:= 0                      { Ergebnis O.K. }
     End
    else                               { Sonst... }
     Begin
      NetRead:= ax;                    { Fehlercode zurckliefern }
      Ist:= 0                          { es wurde nichts verwertbares gel. }
     End
  End
End;

{ Schreiben von Datenstzen }
Function NetWrite
 (Var FileVar; Var Buff; Soll: Word; Var Ist: Word): Integer;
Var
 Regs: Registers;
Begin
 NetWrite:= 0;                         { Bisher kein Fehler }
 Ist:= 0;                              { und nichts geschrieben }
 If Soll <= 0 then Exit;               { gibt's berhaupt etwas zu schr. }

 With FileRec(FileVar), Regs do
  Begin
   ah:= $40;                           { 40h = File Write }
   bx:= Handle;                        { Handle bertragen }
   cx:= RecSize * Soll;                { Lnge berechnen }
   ds:= Seg(Buff);                     { Zeiger auf Puffer setzen }
   dx:= Ofs(Buff);
   MsDos(Regs);                        { DOS-Funktion ausfhren }
   If (Flags and fCarry) = 0           { Falls kein Fehler aufgetreten }
    then
     Begin
      Ist:= ax div RecSize;            { Anzahl geschr. Datenstze erm. }
      NetWrite:= 0                     { Ergebnis O.K. }
     End
    else
     Begin
      NetWrite:= ax;                   { sonst Fehlercode zurckliefern }
      Ist:= 0                          { nichts verwertbares geschrieben }
     End
  End
End;

{ Datei an der aktuellen Position abschneiden }
Function NetTruncate(Var FileVar): Integer;
Var
 Regs: Registers;
 Buff: Integer;
Begin
 NetTruncate:= 0;                      { Bisher kein Fehler }
 With FileRec(FileVar), Regs do
  Begin
   ah:= $40;                           { 40h = File Write }
   bx:= Handle;                        { Handle bertragen }
   cx:= 0;                             { 0 Bytes = Truncate-Funktion }
   ds:= Seg(Buff);                     { Register zur Sicherheit }
   dx:= Ofs(Buff);                     { definiert setzen }
   MsDos(Regs);                        { DOS-Funktion ausfhren }
   If (Flags and fCarry) <> 0          { Falls Fehler aufgetreten }
    then NetTruncate:= ax              { Fehlercode zurckliefern }
  End
End;

{ Lschen einer mit Assign zugewiesenen Datei, darf nicht geffnet sein }
Function NetErase(Var FileVar): Integer;
Var
 Regs: Registers;
Begin
 NetErase:= 0;
 With FileRec(FileVar), Regs do
  Begin
   ah:= $41;                           { 41h = File Erase }
   ds:= Seg(Name);                     { Zeiger auf Dateinamen }
   dx:= Ofs(Name);
   MsDos(Regs);                        { DOS-Funktion ausfhren }
   If (Flags and fCarry) <> 0          { Falls Fehler aufgetreten }
    then NetErase:= ax                 { Fehlercode zurckliefern }
  End
End;

{ Aktuelle Position des Dateizeigers ermitteln }
Function NetFilePos(Var FileVar): LongInt;
Var
 Regs: Registers;
Begin
 With FileRec(FileVar), Regs do
  Begin
   ah:= $42;                           { 42h = File Position }
   al:= $01;                           { von aktueller Position an }
   bx:= Handle;                        { Handle betragen }
   cx:= 0;                             { 0 Bytes }
   dx:= 0;                             { => aktuelle Position nach dx:ax }
   MsDos(Regs);                        { DOS-Funktion ausfhren }
   If (Flags and fCarry) = 0           { Falls kein Fehler aufgetreten }
    then
     NetFilePos:=                      { Position errechnen }
      (LongInt(ax) or
       (LongInt(dx) shl 16)) div RecSize
    else
     NetFilePos:= 0
  End
End;

{ Aktuelle Lnge einer Datei ermitteln }
Function NetFileSize(Var FileVar): LongInt;
Var
 Regs: Registers;
 Alt: LongInt;
Begin
 Alt:= NetFilePos(FileVar);            { Alte Datei Position sichern }

 With FileRec(FileVar), Regs do
  Begin
   ah:= $42;                           { 42h = File Position }
   al:= $02;                           { vom Datei-Ende an }
   bx:= Handle;                        { Handle betragen }
   cx:= 0;                             { 0 Bytes }
   dx:= 0;
   MsDos(Regs);                        { DOS-Funktion ausfhren }
   If (Flags and fCarry) = 0           { Falls kein Fehler aufgetreten }
    then
     NetFileSize:=                     { Lnge berechnen }
      (LongInt(ax) or
       (LongInt(dx) shl 16)) div RecSize
    else
     NetFileSize:= 0
  End;

 NetSeek(FileVar,Alt)                  { Alte Datei Position wiederherst. }
End;

{ Sperren und freigeben eines Dateibereiches, Angaben in Bytes! }
Function DosLock(Var FileVar; Posi,Anz: LongInt; ZugrErl: Boolean): Integer;
Var
 Register: Registers;
Begin
 With Register, FileRec(FileVar) do
  Begin
   ah:= $5C;                           { 5Ch = Lock File }
   al:= Byte(ZugrErl);                 { 00h = Sperren, 01h = Freigabe }
   bx:= Handle;                        { Handle betragen }
   cx:= Posi shr 16;                   { Start nach [CX:DX] }
   dx:= Posi and $FFFF;
   si:= Anz shr 16;                    { Lnge nach [SI:DI] }
   di:= Anz and $FFFF;
   MsDos(Register);                    { DOS-Funktion ausfhren }
   If (Flags and fCarry) <> 0          { Falls Fehler aufgetreten }
    then DosLock:= ax                  { Fehlercode zurckliefern }
    else DosLock:= 0                   { sonst Ergebnis O.K. }
  End
End;

{ Diese Funktion sperrt die Datei FileVar ab der Byte-Position Posi
  fr Anz Byte Lnge  }
Function NetLockFileArea(Var FileVar; Posi,Anz : LongInt): Integer;
Begin
 NetLockFileArea:= DosLock(FileVar,Posi,Anz,false)
End;

{ Diese Funktion gibt die Datei FileVar ab der Byte-Position Posi
  fr Anz Byte Lnge wieder frei }
Function NetUnlockFileArea(Var FileVar; Posi,Anz : LongInt): Integer;
Begin
 NetUnlockFileArea:= DosLock(FileVar,Posi,Anz,true)
End;

{ Diese Funktion sperrt die Datei FileVar ab Datensatz Posi
  fr Anz Datenstze }
Function NetLock(Var FileVar; Posi,Anz : LongInt): Integer;
Begin
 With FileRec(FileVar) do
  NetLock:= DosLock(FileVar,Posi*RecSize,Anz*RecSize,false)
End;

{ Diese Funktion gibt die Datei FileVar ab Datensatz Posi
  fr Anz Datenstze wieder frei }
Function NetUnlock(Var FileVar; Posi,Anz : LongInt): Integer;
Begin
 With FileRec(FileVar) do
  NetUnlock:= DosLock(FileVar,Posi*RecSize,Anz*RecSize,true)
End;

End.
