;   Mini-Tastaturtreiber, J. Tucht, 31.10.1990
;
;   Assemblierung fr Aufruf von der COMMAND-Ebene:
;
;     masm keyboard;
;     link keyboard;
;     exe2bin keyboard keyboard.com
;
;   Assemblierung fr Einbindung in CONFIG.SYS:
;
;     masm keyboard /dConfigSys;
;     link keyboard;
;     exe2bin keyboard
;
;   MASM 3.0 schluckt den /D-Switch nicht.
;   Ggf. am Anfang des Quelltextes "ConfigSys EQU 1" einfgen!
;

CapsLockBit EQU 40h    ;im Tastatur-Status-Register

;-----------------------------------------------------------------
;Makros fr bersetzungstabellen.
;-----------------------------------------------------------------

Primary MACRO
Key 29h,'^'
Key 0Ch,''
Key 0Dh,"'"
Key 2Bh,'#'
Key 1Bh,'+'
Key 35h,'-'
Key 56h,'<'
ENDM

Shift MACRO
Key 29h,''
Key 03h,'"'
Key 04h,15h ;Paragraph (Ctrl-U) - bevorzugen Sie hier '@'?
Key 07h,'&'
Key 08h,'/'
Key 09h,'('
Key 0Ah,')'
Key 0Bh,'='
Key 0Ch,'?'
Key 0Dh,'`'
Key 2Bh,'`'
Key 1Bh,'*'
Key 33h,';'
Key 34h,':'
Key 35h,'_'
Key 56h,'>'
ENDM

Ctrl MACRO
Key 2Ch,19h ;Ctrl-Y (darf bei deutschem ROM-BIOS entfernt werden)
Key 15h,1Ah ;Ctrl-Z (darf bei deutschem ROM-BIOS entfernt werden)
ENDM

Alt MACRO
Key 08h,''
ENDM

CtrlAlt MACRO
Key 1Eh,''
Key 12h,''
Key 17h,''
Key 18h,''
Key 16h,''
Key 03h,''
Key 04h,''
Key 10h,'@'
Key 08h,'{'
Key 09h,'['
Key 0Ah,']'
Key 0Bh,'}'
Key 0Ch,'\'
Key 1Bh,'~'
Key 56h '|'
ENDM

ShiftAlt MACRO
Key 1Eh,''
Key 12h,''
Key 17h,''
Key 18h,''
Key 16h,''
Key 03h,'' ;Shift-Alt-2
Key 05h,'' ;Shift-Alt-4
ENDM

CtrlShift MACRO
Key 2Ch,19h ;Ctrl-Shift-Y wie Ctrl-Y
Key 15h,1Ah ;Ctrl-Shift-Z wie Ctrl-Z
Key 1Eh,'' ;Ctrl-Shift-A
Key 30h,'' ;Ctrl-Shift-B
Key 2Eh,'' ;Ctrl-Shift-C
Key 22h,'' ;Ctrl-Shift-G
Key 20h,'' ;Ctrl-Shift-D
Key 19h,'' ;Ctrl-Shift-P
Key 1Fh,'' ;Ctrl-Shift-S
Key 32h,'' ;Ctrl-Shift-M
Key 18h,'' ;Ctrl-Shift-O
Key 21h,'' ;Ctrl-Shift-F
Key 12h,'' ;Ctrl-Shift-E
Key 14h,'' ;Ctrl-Shift-T
Key 10h,'' ;Ctrl-Shift-Q
ENDM

CtrlShiftAlt MACRO
Key 1Eh,''
Key 12h,''
Key 17h,''
Key 18h,''
Key 16h,''
ENDM


LowerCase MACRO
Key 28h,''
Key 27h,''
Key 1Ah,''
Key 2Ch,'y'
Key 15h,'z'
ENDM

UpperCase MACRO
Key 28h,''
Key 27h,''
Key 1Ah,''
Key 2Ch,'Y'
Key 15h,'Z'
ENDM


ScanXchg MACRO
Key 2Ch,15h
Key 15h,2Ch
Key 79h,03h
ENDM

;nur bei deutschem ROM-BIOS:
;PURGE LowerCase,UpperCase

;Sollen Scan-Codes unangetastet bleiben:
;PURGE ScanXchg

;-----------------------------------------------------------------
;Vereinbarungen zum Thema Dezimalkomma - Dezimalpunkt
;-----------------------------------------------------------------

;Begriffliche Klrung:
;Das "Dezimal-Dings" ist das Zeichen, das man erhlt, wenn man
;bei eingeschalteter Num-Lock-Taste auf die Delete-Taste des
;Ziffernblocks drckt. Alles klar?

DezimalDings        EQU '.,' ;Liefere je nach CapsLock "." oder ","!
RomDezimalDings     EQU '.'  ;Mein ROM liefert "." - ggf. anpassen!


;-----------------------------------------------------------------
;Allgemeine Makros
;-----------------------------------------------------------------

SetInt          MACRO Num,Ofs
                MOV AX,2500H+Num
                MOV DX,OFFSET Ofs
                INT 21H
                ENDM

GetInt          MACRO Num,Vector
                MOV AX,3500H+Num
                INT 21H
                MOV WORD PTR [Vector],BX
                MOV WORD PTR [Vector+2],ES
                ENDM

CODE            SEGMENT
                ASSUME CS:CODE,DS:CODE

;-----------------------------------------------------------------
                IFDEF ConfigSys
;-----------------------------------------------------------------

EntryLabel      PROC FAR

;Device Header

                DD -1           ;Es folgen keine weiteren Treiber
                DW 8004h        ;NUL-Gert ohne Zusatzfunktionen
StrategyTrap    DW Strategy
InstallTrap     DW Install
                ;   12345678
                DB "NUL     "   ;Gertename
Ignore:         RET
EntryLabel      ENDP

;-----------------------------------------------------------------
                ELSE ;IFNDEF ConfigSys
;-----------------------------------------------------------------

                ORG 100h
EntryLabel:     JMP Install

;-----------------------------------------------------------------
                ENDIF
;-----------------------------------------------------------------

;-----------------------------------------------------------------
;residenter Datenbereich
;-----------------------------------------------------------------

                EVEN ;gerade Adresse erzwingen


Setup MACRO Table
Table&Size=0
Key MACRO Key,Symbol
DB LOW Symbol,Key
Table&Size=Table&Size+1
ENDM
Table&Addr:
ENDM

                ; Ŀ
Setup Primary   ;     
                ;     
LowerCase       ;      CapsLock nicht aktiv
                ; ͻ     Shift nicht gedrckt
Primary         ;    
                ; ĺ
Setup Shift     ;   CapsLock aktiv
                ; ĺĿ  Shift nicht gedrckt
UpperCase       ;    
                ; ͼ  
                ; ͻ  
Shift           ;     CapsLock nicht aktiv
                ; ĺ   Shift gedrckt
Setup Caps      ;  
                ;  
LowerCase       ;   CapsLock aktiv
                ; ͼ   Shift gedrckt

IRP X,<Ctrl,Alt,CtrlShift,CtrlAlt,ShiftAlt,CtrlShiftAlt,ScanXchg>
Setup X
X
ENDM

AddrIndex       DW PrimaryAddr,ShiftAddr
                DW CtrlAddr,CtrlShiftAddr
                DW AltAddr,ShiftAltAddr
                DW CtrlAltAddr,CtrlShiftAltAddr

SizeIndex       DB PrimarySize,ShiftSize
                DB CtrlSize,CtrlShiftSize
                DB AltSize,ShiftAltSize
                DB CtrlAltSize,CtrlShiftAltSize

E0Flag          DB 0

;-----------------------------------------------------------------
;residenter Codebereich
;-----------------------------------------------------------------

KbdEvent:       CLD
                IRP XX,<DS,BX,AX,CX,ES,DI>
                PUSH XX
                ENDM
                PUSH CS
                POP ES
                MOV CX,40h      ;CH bleibt ab hier 0
                MOV DS,CX

                XOR BX,BX

                TEST BYTE PTR DS:[96h],8  ;RightAlt gedrckt?
                MOV AL,4+8                ;CtrlAlt vortuschen
                JNZ $+5

                MOV AL,DS:[17h] ;Flags fr Shift/Ctrl/Alt/Caps

                MOV DI,AX
                SHR AL,1
                JNC $+4
                OR AL,1
                AND AX,7

                IF CapsSize
                TEST AL,6       ;setzt Z-Flag fr Tabellen
                ENDIF           ;"Primary" und "Shift"

                XCHG DI,AX
                MOV CL,CS:[SizeIndex+DI]
                ROL DI,1        ;ROL lt Z-Flag unberhrt!
                MOV DI,CS:[AddrIndex+DI]

                IF CapsSize
                JNZ Scan
                TEST AL,CapsLockBit
                JZ Scan
                ADD DI,2*CapsSize   ;Ja, Versatz addieren!
                ENDIF

Scan:           IN AL,60h
                MOV AH,AL
                CMP CS:E0Flag,0E0h
                MOV CS:E0Flag,AL
                JZ ChainOld

                JCXZ ChainOld   ;Schleife ggf. berspringen
                MOV AL,ES:[DI]
                SCASW
                LOOPNZ $-4
                JNZ ChainOld
                MOV BX,AX
ChainOld:
                IF ScanXchgSize
                MOV DI,OFFSET ScanXchgAddr
                MOV CL,ScanXchgSize
                MOV AL,ES:[DI]
                SCASW
                LOOPNZ $-4
                JNZ $+4
                MOV BH,AL
                ENDIF

                MOV AX,DS:[1Ch]
                PUSHF
                DB 9Ah          ;Intersegment Call
OldKbdEvent     DD ?
                XCHG BX,AX

                IF DezimalDings NE RomDezimalDings
                CMP WORD PTR [BX],5300h+RomDezimalDings
                JNZ Skip5
                MOV BYTE PTR [BX],LOW DezimalDings

                IF DezimalDings/100h
                TEST BYTE PTR DS:[17h],CapsLockBit
                JZ Skip5
                MOV BYTE PTR [BX],HIGH DezimalDings
                ENDIF
Skip5:
                ENDIF

                OR AX,AX        ;Scan-Code oder Zeichen ndern?
                JZ Exit         ;Nein: Exit
                MOV [BX],AX     ;Ja: Zeichen im Puffer ablegen
                LEA AX,[BX+2]
                CMP AL,3Eh
                JNZ $+4
                MOV AL,1Eh
                CMP AX,DS:[1Ah]
                JZ Exit
                MOV DS:[1Ch],AX
Exit:
                IRP XX,<DI,ES,CX,AX,BX,DS>
                POP XX
                ENDM

                IRET
;-----------------------------------------------------------------
                IFDEF ConfigSys
;-----------------------------------------------------------------

Install         PROC FAR
                PUSH AX
                PUSH BX
                PUSH DX
                PUSH DS
                PUSH ES

                PUSH CS
                POP DS

                GetInt 9h,OldKbdEvent
                SetInt 9h,KbdEvent

;Regulren Eintrittspunkt im Device-Header vermerken

                MOV AX,OFFSET Ignore
                MOV StrategyTrap,AX
                MOV InstallTrap,AX
                MOV DX,OFFSET OkMsg
                MOV AH,9
                INT 21h

;Treiber-Ende und Status im Request Header vermerken

                LDS BX,RequestPtr
                MOV WORD PTR [BX+14],OFFSET Install
                MOV [BX+16],CS
                MOV WORD PTR [BX+3],300h
                POP ES
                POP DS
                POP DX
                POP BX
                POP AX
                RET

Strategy:       MOV WORD PTR CS:RequestPtr,BX
                MOV WORD PTR CS:RequestPtr+2,ES
                RET

RequestPtr      DD ?          ;Zeiger auf Request-Header

Install         ENDP

;-----------------------------------------------------------------
                ELSE ;IFNDEF ConfigSys
;-----------------------------------------------------------------

Install:        MOV DX,OFFSET OkMsg
                MOV AH,9
                INT 21h

                GetInt 9h,OldKbdEvent
                SetInt 9h,KbdEvent

                MOV DX,OFFSET Install
                INT 27h      ;resident bleiben

;-----------------------------------------------------------------
                ENDIF
;-----------------------------------------------------------------

OkMsg           DB 13,10,'Tastaturtreiber geladen...'
                DB 13,10,'$'

CODE            ENDS
END             EntryLabel ;Return nicht vergessen!


