unit DDEnumU;  // Abzhlen der DDraw-Gerte und Auswahl, wenn
// mehr als ein Gert. Trivial, fehlt aber fast immer.
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DDraw;
type
  TDDrawSelectDlg = class(TForm)
    ListBox1: TListBox;
    bCancel: TButton;
    bOK: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure bOKClick(Sender: TObject);
  public
    SelectedDDrawDevice: PGUID;  // nil frs primre Gert
    function ShowModal: Integer;
  end;

var DDrawSelectDlg: TDDrawSelectDlg;

implementation
{$R *.DFM}
function TDDrawSelectDlg.ShowModal: Integer;
begin
  if ListBox1.Items.Count = 1 then Result := mrOK
   else if ListBox1.Items.Count = 0 then Result := mrCancel
   else Result := inherited ShowModal;
end;

// Rckruffunktion zum Abzhlen
function EnumDDCallback(lpGUID: PGUID; lpDriverDescription,
  lpDriverName: LPSTR; lpContext: Pointer): Bool; stdcall;
var NewGUID: PGUID;
begin
  NewGUID := nil; Result := True; // weitermachen, bitte
  if lpGUID <> nil then
  begin
    New(NewGUID); NewGUID^ := lpGUID^;
  end;
  with TListBox(lpContext) do
    Items.AddObject(lpDriverDescription,Pointer(NewGUID));
end;

procedure TDDrawSelectDlg.FormCreate(Sender: TObject);
begin
  // Abzhlen der Gerte
  DirectDrawEnumerate(EnumDDCallback, ListBox1);
  with ListBox1 do
    if Items.Count > 0 then ItemIndex := 0;
  bCancel.ModalResult := mrCancel;
end;

procedure TDDrawSelectDlg.FormDestroy(Sender: TObject);
var x: Integer;
begin  { GUIDs in der Listbox abrumen }
  with ListBox1.Items do
    for x := 0 to Count-1 do
      if Objects[x] <> nil then Dispose(PGUID(Objects[x]));
end;

procedure TDDrawSelectDlg.ListBox1DblClick(Sender: TObject);
begin  // Doppelklick wie Einfachklick mit OK danach
  bOKClick(Self);
end;

procedure TDDrawSelectDlg.bOKClick(Sender: TObject);
begin
  with ListBox1, ListBox1.Items do
    SelectedDDrawDevice := PGUID(Objects[ItemIndex]);
  ModalResult := mrOK;
end;

end.
