unit DDrawDemoHiroyukiU;  // Alphablending mit DelphiX
// So einfach - aber leider auch langsam - kann DirectDraw-
// Programmierung sein. Baut auf der Package "DelphiX" von
// Hiroyuki Hori (http://www.ingjapan.ne.jp/hori/index-e.html) auf.
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls,
  MMSystem, JPEG, // Zeitmessung, JPG-Decoding
  DXClass, DXDraws;  // Hiroyuki-Units

type
  TDelphiXForm = class(TDXForm)
    DXDraw: TDXDraw;
    DXImageList: TDXImageList;
    ScrollBar1: TScrollBar;
    bPic1ToPic2: TButton;
    bPic2ToPic1: TButton;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
       Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure bPic1ToPic2Click(Sender: TObject);
    procedure bPic2ToPic1Click(Sender: TObject);
  private
    Alpha: Integer;
  end;

var DelphiXForm: TDelphiXForm;

implementation
{$R *.DFM}

procedure TDelphiXForm.FormKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin  // Umschaltung Fenster/Vollbild
  if (ssAlt in Shift) and (Key=VK_RETURN) then
  begin
    DXDraw.Finalize;
    if doFullScreen in DXDraw.Options then
    begin
      RestoreWindow;
      BorderStyle := bsSizeable; DXDraw.Cursor := crDefault;
      DXDraw.Options := DXDraw.Options - [doFullScreen];
    end else
    begin
      StoreWindow;
      BorderStyle := bsNone; DXDraw.Cursor := crDefault;
      DXDraw.Options := DXDraw.Options + [doFullScreen];
    end;
    DXDraw.Initialize;  // Reinitialisierung
  end;
  Invalidate;
end;

procedure TDelphiXForm.FormCreate(Sender: TObject);
var Path: String;

  procedure JPGToDXImage(FName: String);
  var JPGDec: TJPEGImage; NewItem: TPictureCollectionItem;
  begin  // das ginge sicher auch noch ein bichen einfacher
    JPGDec := TJPEGImage.Create; JPGDec.LoadFromFile(FName);
    NewItem := TPictureCollectionItem.Create(DXImageList.Items);
    NewItem.Picture.Assign(JPGDec);
    JPGDec.Free;
  end;

begin
  KeyPreview := True;  // wg. Umschaltung per ALT+Tab
  Path := ExtractFilePath(ParamStr(0));
  // Bilder nicht als DIB-Ressourcen, sondern extern als
  // JPGs - spart ungefhr 1,4 MByte in Form und EXE 
  JPGToDXImage(Path+'Milena1.jpg');
  JPGToDXImage(Path+'m&m.jpg');
end;

procedure TDelphiXForm.FormPaint(Sender: TObject);
var STime: Integer;
begin
  STime := timeGetTime;
  if not DXDraw.CanDraw then Exit;
  DXDraw.Surface.Fill(0);
  DXImageList.Items[1].Draw(DXDraw.Surface, 0, 100, 0);
  with DXImageList.Items[0] do DrawAlpha(DXDraw.Surface,
    Rect(0,100,Width,Height+100),
    0, Trunc(Cos256(Alpha)*126+127));  // <- Blending

  with DXDraw.Surface.Canvas do
  begin  // TextOut geht nicht ins Timing ein!
    Brush.Style := bsSolid; Brush.Color := clBlack;
    Font.Color := clWhite; Font.Size := 12;
    // mit Labels tut man sich hier etwas schwer...
    TextOut(ScrollBar1.Left, ScrollBar1.Top-25,
       'FrameTime (msec): '+IntToStr(timeGetTime-STime));
    if doFullScreen in DXDraw.Options
       then PaintControls(Handle,nil);  // hilft etwas
    Release; // lebensnotwendig!
  end;
  DXDraw.Flip;  // auch im Fensterbetrieb
end;

procedure TDelphiXForm.ScrollBar1Change(Sender: TObject);
begin
  Alpha := ScrollBar1.Position; Refresh;
end;

procedure TDelphiXForm.bPic1ToPic2Click(Sender: TObject);
begin
  with ScrollBar1 do
    while Position < Max do Position := Position+1;
end;

procedure TDelphiXForm.bPic2ToPic1Click(Sender: TObject);
begin
  with ScrollBar1 do
    while Position > Min do Position := Position-1;
end;

end.
