unit DX3SoundDemoU; // 10-AUG-98 as (Arne Schpers)
{ Statische Soundpuffer im Stil von DirectX 3;
  setzt die DirectX-Header von Erik Unger voraus }

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, MMSystem,  // wg. TWaveFormatEx
  ExtCtrls, DSound,  // Erik Ungers umgesetzte DirectX-Header
  DXWaveUtils;  // Laden und WAV-Dateien  la WAVE.C

type
  TDS3DemoForm = class(TForm)
    bCreateSoundObject: TButton;  // damit fngt's an
    bPlayStatic: TButton;    // "boboing"
    bPlayLooping: TButton;   // "didam, didam, didam..."
    GroupBox1: TGroupBox;    // bMultiStatic, beide Label
    bMultiStatic: TButton;   // "boboboinginginging"
    Label1: TLabel;
    lActiveSounds: TLabel;
    MSTimer: TTimer;
    cUseWalk: TCheckBox;         // Aufrumer fr Abgespieltes
    procedure bCreateSoundObjectClick(Sender: TObject);
    procedure bPlayStaticClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bPlayLoopingClick(Sender: TObject);
    procedure bMultiStaticClick(Sender: TObject);
    procedure MSTimerTimer(Sender: TObject);
  protected
    // zeigt eine Fehlermeldung an, wenn Res <> DS_OK
    function ErrCheck(Action: String; Res: HResult): Boolean;
    // legt einen Soundpuffer an, liest Datei WAVName ein
    function LoadStaticSound(WAVName: String;
      var SoundBuf: IDirectSoundBuffer): Boolean;
  public
    DirectSound: IDirectSound;  // zentrales Objekt
    JumpSound: IDirectSoundBuffer;  // JUMP.WAV
    WalkSound: IDirectSoundBuffer;  // WALK.WAV
    JumpList: TList;  // Kopien von JUMP.WAV
  end;

var DS3DemoForm: TDS3DemoForm;

implementation
{$R *.DFM}

procedure TDS3DemoForm.FormCreate(Sender: TObject);
var x: Integer;
begin
  // Erst mal alle Buttons bis auf bCreateSoundObject aus
  for x := 0 to ComponentCount-1  do
    if Components[x] is TButton then
      TButton(Components[x]).Enabled := False;
  bCreateSoundObject.Enabled := True;
  JumpList := TList.Create;  // Liste fr kopierte Sounds
  MSTimer.Interval := 200;   // Aufrum-Intervall
end;

procedure TDS3DemoForm.FormDestroy(Sender: TObject);
var x: Integer;
begin
  // Alle Sounds in JumpList anhalten, der direkte
  // Aufruf der Timer-Prozedur rumt sie dann ab
  for x := 0 to JumpList.Count-1 do
    IDirectSoundBuffer(JumpList[x]).Stop;
  MSTimerTimer(Self);
  JumpList.Free;
  JumpSound := nil; Walksound := nil;  // implizites Stop
  // "DirectSoundUninitialize". Wenn zu diesem Zeitpunkt noch
  // ein Sound mit DSBPLAY_LOOPING luft, hngt die Maschine
  DirectSound := nil;
end;

// Gibt im Fehlerfall die Meldung von DirectSound aus und
// liefert False. XRef: Alle DirectX-Aufrufe
function TDS3DemoForm.ErrCheck(Action: String;
             Res: HResult): Boolean;
begin
  Result := SUCCEEDED(Res);
  if not Result then ShowMessage(
     Format('%s: %s',[Action,ErrorString(Res)]));
end;

// Initialisierung von DirectSound (siehe Text)
procedure TDS3DemoForm.bCreateSoundObjectClick(Sender: TObject);
var
  Res: HResult;
  BufDesc: TDSBufferDesc;  // Soundpuffer-Beschreibung
  WaveFmt: TWaveFormatEx;  // gewnschtes Audioformat
  PrimBuffer: IDirectSoundBuffer;
  Caps: TDSCaps;  // Abfrage der Hardware-Puffer (rein Info)
begin
  // 1. IDirectSound-Variable anlegen
  Res := DirectSoundCreate(nil, DirectSound, nil);
  if not ErrCheck('DirectSound-Objekt anlegen',Res) then Exit;

  // 2. Kooperationsebene: Formatnderungen ja, direkte Schreib-
  // aktionen in den primren Puffer nein
  Res := DirectSound.SetCooperativeLevel(Handle,DSSCL_PRIORITY);
  if not ErrCheck('Setzen der Kooperationsebene',Res) then Exit;

  // Hardware-Puffer: Gesamtzahl, freie Puffer
  Caps.dwSize := SizeOf(Caps);
  Res := DirectSound.GetCaps(Caps);
  if ErrCheck('Abfrage HW-Puffer',Res) then
    with Caps do
      Caption := Caption + Format(' - HW-Buffers: %d of %d',
       [dwFreeHwMixingAllBuffers, dwMaxHwMixingAllBuffers]);

  // 3. Versuch, das Format des primren Soundpuffers zu setzen.
  // Erst mal einen primren Soundpuffer anlegen:
  FillChar(BufDesc,SizeOf(BufDesc),0);
  with BufDesc do
  begin
    // das erwartet DirectX bei den meisten Strukturen
    dwSize := SizeOf(BufDesc);
    dwFlags := DSBCAPS_PRIMARYBUFFER;  // primrer Soundpuffer
    // dwBufferBytes und lpwfxFormat bleiben 0 bzw. nil
  end;
  Res := DirectSound.CreateSoundBuffer(BufDesc, PrimBuffer, nil);
  if ErrCheck('Anlegen des primren Soundpuffers',Res) then
  begin
    // Primren Puffer auf 22 KHz Stereo, 16 Bit setzen
    FillChar(WaveFmt,SizeOf(WaveFmt),0);
    with WaveFmt do
    begin
      wFormatTag := WAVE_FORMAT_PCM; // was anderes geht eh nicht
      nChannels := 2; wBitsPerSample := 16;  // Stereo, 16 Bit
      nSamplesPerSec := 22050;  // (pro Kanal)
      nBlockAlign := wBitsPerSample div 8 * nChannels;
      nAvgBytesPerSec := nSamplesPerSec * nBlockAlign;
    end;
    Res := PrimBuffer.SetFormat(WaveFmt);
    ErrCheck('Format primrer Soundpuffer (unkrititisch)',Res);
  end;

  // 4 .. 7:  WAV-Datei ffnen, Gre des 'data'-Chunks bestimmen,
  // statischen Soundpuffer anlegen, Sperren, Audiodaten rein-
  // schreiben und wieder entsperren (hier fr 2 Objekte)
  bPlayStatic.Enabled := LoadStaticSound('jump',JumpSound);
  bPlayLooping.Enabled := LoadStaticSound('walk',WalkSound);
  // MultiStatic arbeitet mit Kopien von JumpSound
  bMultiStatic.Enabled := bPlayStatic.Enabled;
end;

// Legt einen statischen Soundpuffer an und fllt ihn
// komplett mit Audiodaten
function TDS3DemoForm.LoadStaticSound(WAVName: String;
  var SoundBuf: IDirectSoundBuffer): Boolean;
var IOCB: TWaveIOCB; BufDesc: TDSBufferDesc;
    AudioSize, ASize2: Integer; AudioData, AData2: Pointer;
    Res: HResult;
begin
  Result := False;
  // WAV-Dateien im EXE-Verzeichnis
  WAVName := ExtractFilePath(ParamStr(0))+WAVName+'.WAV';
  if not WaveOpenFile(WAVName,IOCB) then  // <- setzt IOCB
  begin
    ShowMessage('Datei nicht gefunden: '+WAVName); Exit;
  end;
  // Pufferbeschreibung initialisieren
  FillChar(BufDesc,SizeOf(BufDesc),0);
  with BufDesc do
  begin
   dwSize := SizeOf(BufDesc);
   dwFlags := DSBCAPS_STATIC;  // or DSBCAPS_LOCSOFTWARE;
   dwBufferBytes := IOCB.dwDataBytes;
   lpwfxFormat := @IOCB.WaveFormat;
  end;

  Res := DirectSound.CreateSoundBuffer(BufDesc,SoundBuf,nil);
  try
    if not ErrCheck('CreateSoundBuffer',Res) then Exit;
    // den gesamten Puffer (dwBufferBytes) fr eine nachfolgende
    // Schreibaktion sperren - setzt Audiodata, Audiosize
    Res := SoundBuf.Lock(0,BufDesc.dwBufferBytes,AudioData,
      AudioSize,AData2,ASize2,0);
    if not ErrCheck('LoadStaticSound: Lock',Res) then Exit;
    // den 'data'-Chunk in den Puffer einlesen
    if WaveReadFile(IOCB,AudioSize,AudioData) < AudioSize then
    begin
      ShowMessage('LoadStaticSound: EOF bei '+WAVName);
      SoundBuf.Unlock(AudioData, AudioSize, nil, 0);
      Exit;
    end;
    // Puffer wieder komplett entsperren
    Res := SoundBuf.Unlock(AudioData, AudioSize, nil, 0);
    Result := ErrCheck('LoadStaticSound: Unlock', Res);
  finally
    WaveCloseReadFile(IOCB);
  end;
end;

// Statischer Sound, bei jedem Klick von Anfang an neu abspielen
procedure TDS3DemoForm.bPlayStaticClick(Sender: TObject);
begin
  JumpSound.SetCurrentPosition(0);
  JumpSound.Play(0,0,0);
end;

// Statischer Sound, bis zum nchsten Klick wiederholt
procedure TDS3DemoForm.bPlayLoopingClick(Sender: TObject);
begin
  if bPlayLooping.Caption = 'Stop looping' then
  begin
    WalkSound.Stop;
    bPlayLooping.Caption := 'bPlayLooping (didam, didam...)';
  end else
  begin
    WalkSound.SetCurrentPosition(0);
    WalkSound.Play(0,0,DSBPLAY_LOOPING);
    bPlayLooping.Caption := 'Stop looping';
  end;
end;

// Kopie eines statischen Puffers, Einbau in JumpList
// und abspielen
procedure TDS3DemoForm.bMultiStaticClick(Sender: TObject);
var Buf, OrgSound: IDirectSoundBuffer; Res: HResult;
begin
  // Auswahl des zu kopierenden Sounds
  if cUseWalk.Checked then OrgSound := WalkSound
    else OrgSound := JumpSound;
  Res := DirectSound.DuplicateSoundBuffer(OrgSound,Buf);
  if not ErrCheck('DuplicateSoundBuffer',Res) then Exit;
  // Hier entsteht *keine* zustzliche Referenz, weshalb
  // das zu Fu nachgeholt werden mu
  JumpList.Add(Pointer(Buf)); Buf._AddRef;
  Buf.Play(0,0,0);
end;

// Alle 200 msec nachgucken, welche der kopierten Sounds
// noch spielen; abgespielte Sounds abrumen
procedure TDS3DemoForm.MSTimerTimer(Sender: TObject);
var x: Integer; Buf: IDirectSoundBuffer; Status: Integer;
begin
  for x := JumpList.Count-1 downto 0 do
  begin
    Buf := IDirectSoundBuffer(JumpList[x]);  // 2. Referenz
    Buf.GetStatus(Status);
    if Status and DSBSTATUS_PLAYING = 0 then
    begin
      JumpList.Delete(x);
      Buf._Release;  // lscht 1. Referenz
      Buf := nil;    // lscht 2. Referenz
    end;
  end;
  lActiveSounds.Caption := IntToStr(JumpList.Count);
end;

end.



