import java.awt.Component;
import com.sun.java.swing.*;
import com.sun.java.swing.table.*;
import java.io.Serializable;
import java.awt.Color;
import com.sun.java.swing.border.*;

/**
  * TableCellRenderer, der passend zum LookUpCellEditor zu einer Zahl
  * das entsprechende Image anzeigt.
  */

public class LookUpCellRenderer implements TableCellRenderer, Serializable {
  protected JLabel rendererComponent;
  protected ImageIcon[] images;

  // Im JTable knnen die Zellenelemente markiert sein
  // Wir mssen uns daher die ursprnglichen Farben merken
  private Color unselectedForeground; 
  private Color unselectedBackground; 
  protected static Border noFocusBorder  = new EmptyBorder(1, 2, 1, 2);
  public LookUpCellRenderer(JLabel label, ImageIcon[] icons) {
    rendererComponent = label;
    images = icons;
  }

  // Implementation des TableCellRenderer Interface
  
  public Component getTableCellRendererComponent(JTable table, Object value,
           boolean isSelected, boolean hasFocus, int row, int column) {
  
    // Im Label den Wert setzen
    setValue(value);
    
    // nun noch Farben und Rand richtig setzen
    if (isSelected) {
      rendererComponent.setForeground(table.getSelectionForeground());
      rendererComponent.setBackground(table.getSelectionBackground());
    }
    // falls Zelle nicht markiert ist, mit den
    // ursprnglichen Farben zeichnen
     else {
        rendererComponent.setForeground(
          (unselectedForeground != null) ? 
             unselectedForeground : table.getForeground());
        rendererComponent.setBackground(
           (unselectedBackground != null) ? 
             unselectedBackground : table.getBackground());
    }
    rendererComponent.setFont(table.getFont());
    
     // ggf. Rand fr Focus zeichnen
    if (hasFocus) {
      rendererComponent.setBorder( UIManager.getBorder("Table.focusCellHighlightBorder") );
      if (table.isCellEditable(row, column)) {
         rendererComponent.setForeground( UIManager.getColor("Table.focusCellForeground") );
         rendererComponent.setBackground( UIManager.getColor("Table.focusCellBackground") );
      }
    } else {
      rendererComponent.setBorder(noFocusBorder);
    }
    rendererComponent.setOpaque(true);
    return rendererComponent;         
  }

  protected void setValue(Object x) {
    if (x instanceof Number) {
      int index = ((Number) x).intValue();
      if (index >= images.length) index = 0;
      rendererComponent.setText(images[index].getDescription());
      rendererComponent.setIcon(images[index]); 
    } else {
      rendererComponent.setText( (x == null) ? "" : x.toString() );
    }
  }
}

