import com.sun.java.swing.table.*;
import java.awt.event.*;
import java.awt.*;
import com.sun.java.swing.event.*;
import java.util.*;
import com.sun.java.swing.*;
import com.sun.java.swing.tree.*;
import java.io.Serializable;
    
/** 
 * CellEditor fr die neue ImageDropDownBox, ist auerdem
 * fr LookUp-Funktionalitt zustndig.
 * Kann sowohl in JTable als auch in JTree verwendet werden
 */

public class LookUpCellEditor implements TableCellEditor , TreeCellEditor, 
   ActionListener, Serializable {

  /** Event listeners */
  protected EventListenerList listenerList = new EventListenerList();
  transient protected ChangeEvent changeEvent = null;

  protected ImageDropDownBox box;

  // Die Liste soll nach einem Klick aufklappen
  protected int clickCountToStart = 1;

  public LookUpCellEditor(ImageDropDownBox box) {
     this.box = box;
     box.addActionListener(this);
  }

//
//  Implementation des CellEditor Interface
//

  public Object getCellEditorValue() {
      return new Integer(box.getSelectedIndex());
  }

  public boolean isCellEditable(EventObject anEvent) {
    if (anEvent instanceof MouseEvent) {
      if (((MouseEvent)anEvent).getClickCount() < clickCountToStart)
	      return false;
    }
    return true;
  }
    
  public boolean shouldSelectCell(EventObject anEvent) {
    return true;
  }

  public boolean stopCellEditing() {
    fireEditingStopped();
    return true;
  }


  public void cancelCellEditing() {
   fireEditingCanceled();
  }

//
//  Listener-Liste fhren
//
  public void addCellEditorListener(CellEditorListener l) {
   listenerList.add(CellEditorListener.class, l);
  }

  public void removeCellEditorListener(CellEditorListener l) {
   listenerList.remove(CellEditorListener.class, l);
  }

  /** Alle angemeldeteten Listener benachrichtigen */
  protected void fireEditingStopped() {
    Object[] listeners = listenerList.getListenerList();
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i]==CellEditorListener.class) {
        // Lazily create the event:
        if (changeEvent == null)
          changeEvent = new ChangeEvent(this);
        ((CellEditorListener)listeners[i+1]).editingStopped(changeEvent);
      }	       
    }
  }

  /** Alle angemeldeteten Listener benachrichtigen */
  protected void fireEditingCanceled() {
    Object[] listeners = listenerList.getListenerList();
	 for (int i = listeners.length-2; i>=0; i-=2) {
	   if (listeners[i]==CellEditorListener.class) {
		  if (changeEvent == null)
		    changeEvent = new ChangeEvent(this);
		  ((CellEditorListener)listeners[i+1]).editingCanceled(changeEvent);
	   }	       
	 }
  }

//
//  Implementation des TreeCellEditor Interface
//

  public Component getTreeCellEditorComponent(JTree tree, Object value,
						boolean isSelected,
						boolean expanded,
						boolean leaf, int row) {
     setValue(value);
	  return box;
  }

//
//  Implementation des CellEditor Interface
//

  public Component getTableCellEditorComponent(JTable table, Object value,
					 boolean isSelected,
					 int row, int column) {
    setValue(value);
	 return box;
  }

  // Hier geschieht automatische Umsetzung Int[] <-> String[]
  public void setValue(Object value) {
    if ( (value instanceof Number) && ( ((Number) value).intValue() <=  box.getItemCount() ) )
       box.setSelectedIndex(((Number) value).intValue());
     else box.setSelectedIndex(0);
  }

	// Damit die Liste wieder verschwindet, nachdem man etwas ausgewaehlt hat
  public void actionPerformed(ActionEvent e) {
    fireEditingStopped();
  }
} 

