import com.sun.java.swing.*;
import java.util.Vector;

/** Implementierung unseres editierbaren Listenmodells */

public class BeispielListModel extends AbstractListModel implements EditableListModel {
   
  // Speichern der Listendaten in einem Vector
  private Vector daten = new Vector();

  public int getSize() {
     return daten.size();
  }

  public Object getElementAt(int index) {
    return daten.elementAt(index);
  }
 
  // nun die Methoden aus dem EditableListModel Interface
  
  public void addElement(Object element) {
    daten.addElement(element);

    // Daten haben sich gendert, also nun Event feuern, die fireXXX-Methode 
    // aus dem AbstractListModel feuert ein Event an alle Listener
    fireIntervalAdded(this, daten.size()-1, daten.size()-1);
  }
  public void removeElementAt(int index) {
    daten.removeElementAt(index);

    // Daten haben sich gendert, also nun Event feuern, die fireXXX-Methode 
    // aus dem AbstractListModel feuert ein Event an alle Listener
    fireIntervalRemoved(this, index, index);
  }

}

