unit Unit1;

{$INCLUDE COMSWITCH.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DXControls, Menus,d3dtypes;

const
  PaletteFilename = 'psp256.pal';
  DeviceMenuGroupIndex = 1;
  DisplaymodeMenuGroupIndex = 4;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    Datei: TMenuItem;
    Beenden1: TMenuItem;
    ffnen1: TMenuItem;
    N1: TMenuItem;
    Renderoptionen: TMenuItem;
    N2: TMenuItem;
    Wireframe1: TMenuItem;
    Flat1: TMenuItem;
    Gouraud1: TMenuItem;
    Phong1: TMenuItem;
    ColorDialog1: TColorDialog;
    Beleuchtung: TMenuItem;
    Streulichthelligkeit1: TMenuItem;
    sun0: TMenuItem;
    sun1: TMenuItem;
    sun2: TMenuItem;
    sun3: TMenuItem;
    sun4: TMenuItem;
    sun5: TMenuItem;
    sun6: TMenuItem;
    sun7: TMenuItem;
    sun8: TMenuItem;
    sun9: TMenuItem;
    sun10: TMenuItem;
    Streulichtfarbe1: TMenuItem;
    N3: TMenuItem;
    Sonnenlichhelligkeit1: TMenuItem;
    amb0: TMenuItem;
    amb1: TMenuItem;
    amb2: TMenuItem;
    amb3: TMenuItem;
    amb4: TMenuItem;
    amb5: TMenuItem;
    amb6: TMenuItem;
    amb7: TMenuItem;
    amb8: TMenuItem;
    amb9: TMenuItem;
    amb10: TMenuItem;
    Sonnenlichfarbe1: TMenuItem;
    N4: TMenuItem;
    Frontlichthelligkeit1: TMenuItem;
    Frontlichfarbe1: TMenuItem;
    Frontlichtart1: TMenuItem;
    KeinFrontlicht1: TMenuItem;
    ParallelesLicht1: TMenuItem;
    Punktlicht1: TMenuItem;
    Scheinwerfer1: TMenuItem;
    front0: TMenuItem;
    front1: TMenuItem;
    front2: TMenuItem;
    front3: TMenuItem;
    front4: TMenuItem;
    front5: TMenuItem;
    front6: TMenuItem;
    front7: TMenuItem;
    front8: TMenuItem;
    front9: TMenuItem;
    front10: TMenuItem;
    ussererLichtkegelwinkel1: TMenuItem;
    InnererLichtkegelwinkel1: TMenuItem;
    N5: TMenuItem;
    usserenLichtkegelwinkelerhhen1: TMenuItem;
    InnerenLichtkelwinkelerhhen1: TMenuItem;
    A1: TMenuItem;
    Umbra1: TMenuItem;
    Kamera: TMenuItem;
    ffnungswinkel1: TMenuItem;
    FOV1: TMenuItem;
    FOV2: TMenuItem;
    N6: TMenuItem;
    Linkrotieren1: TMenuItem;
    Rechtsrotieren1: TMenuItem;
    Nachobenrotieren1: TMenuItem;
    Nachuntenrotieren1: TMenuItem;
    N7: TMenuItem;
    Nachvornebewegen1: TMenuItem;
    Nachhintenbewegen1: TMenuItem;
    Nachlinksbewegen1: TMenuItem;
    Nachrechtsbewegen1: TMenuItem;
    Nachlinksrollen1: TMenuItem;
    Nachrechtsrollen1: TMenuItem;
    N8: TMenuItem;
    Nachobenbewegen1: TMenuItem;
    Nachuntenbewegen1: TMenuItem;
    N9: TMenuItem;
    ZumZentrumblicken1: TMenuItem;
    Entfernunganpassen1: TMenuItem;
    Objekt: TMenuItem;
    Objektzentrieren1: TMenuItem;
    Objektgreanpassen1: TMenuItem;
    N10: TMenuItem;
    Vollbild: TMenuItem;
    Fenstermodus: TMenuItem;
    Vollbildaufloesungen: TMenuItem;
    D3DBrowser1: TD3DBrowser;
    Dithering1: TMenuItem;
    UnlitFlat1: TMenuItem;
    N11: TMenuItem;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Wireframe1Click(Sender: TObject);
    procedure Flat1Click(Sender: TObject);
    procedure Gouraud1Click(Sender: TObject);
    procedure Phong1Click(Sender: TObject);
    procedure ffnen1Click(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure amb0Click(Sender: TObject);
    procedure amb1Click(Sender: TObject);
    procedure amb3Click(Sender: TObject);
    procedure amb4Click(Sender: TObject);
    procedure amb5Click(Sender: TObject);
    procedure amb6Click(Sender: TObject);
    procedure amb7Click(Sender: TObject);
    procedure amb8Click(Sender: TObject);
    procedure amb9Click(Sender: TObject);
    procedure amb10Click(Sender: TObject);
    procedure BeleuchtungClick(Sender: TObject);
    procedure RenderoptionenClick(Sender: TObject);
    procedure sun0Click(Sender: TObject);
    procedure sun1Click(Sender: TObject);
    procedure sun2Click(Sender: TObject);
    procedure sun3Click(Sender: TObject);
    procedure sun4Click(Sender: TObject);
    procedure sun5Click(Sender: TObject);
    procedure sun6Click(Sender: TObject);
    procedure sun7Click(Sender: TObject);
    procedure sun8Click(Sender: TObject);
    procedure sun9Click(Sender: TObject);
    procedure sun10Click(Sender: TObject);
    procedure front0Click(Sender: TObject);
    procedure front1Click(Sender: TObject);
    procedure front2Click(Sender: TObject);
    procedure front3Click(Sender: TObject);
    procedure front4Click(Sender: TObject);
    procedure front5Click(Sender: TObject);
    procedure front6Click(Sender: TObject);
    procedure front7Click(Sender: TObject);
    procedure front8Click(Sender: TObject);
    procedure front9Click(Sender: TObject);
    procedure front10Click(Sender: TObject);
    procedure KeinFrontlicht1Click(Sender: TObject);
    procedure ParallelesLicht1Click(Sender: TObject);
    procedure Punktlicht1Click(Sender: TObject);
    procedure Scheinwerfer1Click(Sender: TObject);
    procedure Streulichtfarbe1Click(Sender: TObject);
    procedure Sonnenlichfarbe1Click(Sender: TObject);
    procedure Frontlichfarbe1Click(Sender: TObject);
    procedure ussererLichtkegelwinkel1Click(Sender: TObject);
    procedure InnererLichtkegelwinkel1Click(Sender: TObject);
    procedure usserenLichtkegelwinkelerhhen1Click(Sender: TObject);
    procedure A1Click(Sender: TObject);
    procedure InnerenLichtkelwinkelerhhen1Click(Sender: TObject);
    procedure Umbra1Click(Sender: TObject);
    procedure ffnungswinkel1Click(Sender: TObject);
    procedure FOV1Click(Sender: TObject);
    procedure FOV2Click(Sender: TObject);
    procedure Linkrotieren1Click(Sender: TObject);
    procedure Rechtsrotieren1Click(Sender: TObject);
    procedure Nachobenrotieren1Click(Sender: TObject);
    procedure Nachuntenrotieren1Click(Sender: TObject);
    procedure Nachvornebewegen1Click(Sender: TObject);
    procedure Nachhintenbewegen1Click(Sender: TObject);
    procedure Nachlinksbewegen1Click(Sender: TObject);
    procedure Nachrechtsbewegen1Click(Sender: TObject);
    procedure Nachlinksrollen1Click(Sender: TObject);
    procedure Nachrechtsrollen1Click(Sender: TObject);
    procedure Objektzentrieren1Click(Sender: TObject);
    procedure Entfernunganpassen1Click(Sender: TObject);
    procedure ZumZentrumblicken1Click(Sender: TObject);
    procedure Objektgreanpassen1Click(Sender: TObject);
    procedure Nachobenbewegen1Click(Sender: TObject);
    procedure Nachuntenbewegen1Click(Sender: TObject);
    procedure VollbildClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FenstermodusClick(Sender: TObject);
    procedure Dithering1Click(Sender: TObject);
    procedure UnlitFlat1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure DisplaymodeMenuClick(Sender: TObject); virtual;
    procedure DeviceMenuClick(Sender: TObject); virtual;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

const
  DeltaRotate : TD3DValue = 0.05;
  DeltaAngle  : TD3DValue = 0.05;
  DeltaMove   : TD3DValue = 0.05;

implementation

uses DXTools,Unit2, Unit3;

{$R *.DFM}

procedure TForm1.FormResize(Sender: TObject);
begin
  with D3DBrowser1 do if ResizeToParentWindow then ResizeToParentWindow := true;
end;

procedure TForm1.DisplaymodeMenuClick(Sender: TObject);
var
  i : integer;
begin
  with Sender as TMenuItem do i := ComponentIndex;
  Vollbildaufloesungen.Items[i].Checked := true;
  D3DBrowser1.DisplaymodeIndex := i;
end;

procedure TForm1.DeviceMenuClick(Sender: TObject);
var
  i : integer;
begin
  with Sender as TMenuItem do i := ComponentIndex;
  Renderoptionen.Items[i].Checked := true;
  D3DBrowser1.D3DDeviceIndex := i;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  NewItem: TMenuItem;
  i : integer;
begin
  with D3DBrowser1 do
  begin
    PaletteFilename := Unit1.PaletteFilename;
    AdjustDistance(1.5);
    LookAtCenter;
    CenterMesh;

    NewItem := nil;
    for i := 0 to DisplaymodeList.Count-1 do
    try
      NewItem := TMenuItem.Create(Vollbildaufloesungen);
      with NewItem do
      begin
        Caption := DisplaymodeList.Items[i].Name;
        GroupIndex := DisplaymodeMenuGroupIndex;
        RadioItem := true;
        OnClick := DisplaymodeMenuClick;
      end;
      Vollbildaufloesungen.Insert(i, NewItem);
    except
      NewItem.Free;
      raise;
    end;
    Vollbildaufloesungen.Items[DisplaymodeIndex].Checked := true;
    for i := 0 to D3DDeviceList.Count-1 do
    try
      NewItem := TMenuItem.Create(Renderoptionen);
      with NewItem do
      begin
        Caption := D3DDeviceList.Items[i].Name;
        GroupIndex := DeviceMenuGroupIndex;
        RadioItem := true;
        OnClick := DeviceMenuClick;
      end;
      NewItem.ShortCut := ShortCut(i + ord('1'), [ssCtrl]);
      Renderoptionen.Insert(i, NewItem);
    except
      NewItem.Free;
      raise;
    end;
    Renderoptionen.Items[D3DDeviceIndex].Checked := true;
  end;
end;

procedure TForm1.Wireframe1Click(Sender: TObject);
begin
  D3DBrowser1.ShadeMode := Wireframe;
end;

procedure TForm1.UnlitFlat1Click(Sender: TObject);
begin
  D3DBrowser1.ShadeMode := UnlitFlat;
end;

procedure TForm1.Flat1Click(Sender: TObject);
begin
  D3DBrowser1.ShadeMode := Flat;
end;

procedure TForm1.Gouraud1Click(Sender: TObject);
begin
  D3DBrowser1.ShadeMode := Gouraud;
end;

procedure TForm1.Phong1Click(Sender: TObject);
begin
  D3DBrowser1.ShadeMode := Phong;
end;

procedure TForm1.ffnen1Click(Sender: TObject);
begin
  D3DBrowser1.Displaying := false;
  if OpenDialog1.Execute then with D3DBrowser1 do begin
    XFile := OpenDialog1.FileName;
    Displaying := true;
    CenterMesh;
    LookAtCenter;
    AdjustDistance(1.5);
  end;
  D3DBrowser1.Displaying := true;
end;

procedure TForm1.Beenden1Click(Sender: TObject);
begin
  Application.Terminate;
end;


procedure TForm1.amb0Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 0.0;
end;

procedure TForm1.amb1Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 0.1;
end;

procedure TForm1.amb3Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 0.3;
end;

procedure TForm1.amb4Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 0.4;
end;

procedure TForm1.amb5Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 0.5;
end;

procedure TForm1.amb6Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 0.6;
end;

procedure TForm1.amb7Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 0.7;
end;

procedure TForm1.amb8Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 0.8;
end;

procedure TForm1.amb9Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 0.9;
end;

procedure TForm1.amb10Click(Sender: TObject);
begin
  D3DBrowser1.AmbientBrightness := 1.0;
end;

procedure TForm1.BeleuchtungClick(Sender: TObject);
var
  i : integer;
begin
  i := round(D3DBrowser1.AmbientBrightness * 10.0);
  case i of
     0 : amb0.Checked := true;
     1 : amb1.Checked := true;
     2 : amb2.Checked := true;
     3 : amb3.Checked := true;
     4 : amb4.Checked := true;
     5 : amb5.Checked := true;
     6 : amb6.Checked := true;
     7 : amb7.Checked := true;
     8 : amb8.Checked := true;
     9 : amb9.Checked := true;
    10 : amb10.Checked := true;
  end;
  i := round(D3DBrowser1.SunlightBrightness * 10.0);
  case i of
     0 : sun0.Checked := true;
     1 : sun1.Checked := true;
     2 : sun2.Checked := true;
     3 : sun3.Checked := true;
     4 : sun4.Checked := true;
     5 : sun5.Checked := true;
     6 : sun6.Checked := true;
     7 : sun7.Checked := true;
     8 : sun8.Checked := true;
     9 : sun9.Checked := true;
    10 : sun10.Checked := true;
  end;
  i := round(D3DBrowser1.FrontlightBrightness * 10.0);
  case i of
     0 : front0.Checked := true;
     1 : front1.Checked := true;
     2 : front2.Checked := true;
     3 : front3.Checked := true;
     4 : front4.Checked := true;
     5 : front5.Checked := true;
     6 : front6.Checked := true;
     7 : front7.Checked := true;
     8 : front8.Checked := true;
     9 : front9.Checked := true;
    10 : front10.Checked := true;
  end;
  case D3DBrowser1.FrontlightType of
    None        : KeinFrontlicht1.Checked := true;
    Directional : ParallelesLicht1.Checked := true;
    Pointlight  : Punktlicht1.Checked := true;
    Spotlight   : Scheinwerfer1.Checked := true;
  end;
end;

procedure TForm1.RenderoptionenClick(Sender: TObject);
begin
  with D3DBrowser1 do
  begin
    Renderoptionen.Items[D3DDeviceIndex].Checked := true;
    case ShadeMode of
      Wireframe : Wireframe1.Checked := true;
      UnlitFlat : UnlitFlat1.Checked := true;
      Flat      : Flat1.Checked := true;
      Gouraud   : Gouraud1.Checked := true;
      Phong     : Phong1.Checked := true;
    end;
    if FullScreen then
      VollBild.Checked := true
    else
      Fenstermodus.Checked := true;
  end;
end;

procedure TForm1.sun0Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.0;
end;

procedure TForm1.sun1Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.1;
end;

procedure TForm1.sun2Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.2;
end;

procedure TForm1.sun3Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.3;
end;

procedure TForm1.sun4Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.4;
end;

procedure TForm1.sun5Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.5;
end;

procedure TForm1.sun6Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.6;
end;

procedure TForm1.sun7Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.7;
end;

procedure TForm1.sun8Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.8;
end;

procedure TForm1.sun9Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 0.9;
end;

procedure TForm1.sun10Click(Sender: TObject);
begin
  D3DBrowser1.SunlightBrightness := 1.0;
end;

procedure TForm1.front0Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.0;
end;

procedure TForm1.front1Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.1;
end;

procedure TForm1.front2Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.2;
end;

procedure TForm1.front3Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.3;
end;

procedure TForm1.front4Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.4;
end;

procedure TForm1.front5Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.5;
end;

procedure TForm1.front6Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.6;
end;

procedure TForm1.front7Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.7;
end;

procedure TForm1.front8Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.8;
end;

procedure TForm1.front9Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 0.9;
end;

procedure TForm1.front10Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightBrightness := 1.0;
end;

procedure TForm1.KeinFrontlicht1Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightType := None;
end;

procedure TForm1.ParallelesLicht1Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightType := Directional;
end;

procedure TForm1.Punktlicht1Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightType := Pointlight;
end;

procedure TForm1.Scheinwerfer1Click(Sender: TObject);
begin
  D3DBrowser1.FrontlightType := Spotlight;
end;

procedure TForm1.Streulichtfarbe1Click(Sender: TObject);
begin
  if ColorDialog1.Execute then
     with TTrueColor(ColorDialog1.Color) do
     begin
       D3DBrowser1.AmbientColor.Red := (R / 255.0);
       D3DBrowser1.AmbientColor.Green := (G / 255.0);
       D3DBrowser1.AmbientColor.Blue := (B / 255.0);
     end;
end;

procedure TForm1.Sonnenlichfarbe1Click(Sender: TObject);
begin
  if ColorDialog1.Execute then
     with TTrueColor(ColorDialog1.Color) do begin
       D3DBrowser1.SunlightColor.Red := (R / 255.0);
       D3DBrowser1.SunlightColor.Green := (G / 255.0);
       D3DBrowser1.SunlightColor.Blue := (B / 255.0);
     end;
end;

procedure TForm1.Frontlichfarbe1Click(Sender: TObject);
begin
  D3DBrowser1.Displaying := false;
  if ColorDialog1.Execute then
     with TTrueColor(ColorDialog1.Color) do begin
       D3DBrowser1.FrontlightColor.Red := (R / 255.0);
       D3DBrowser1.FrontlightColor.Green := (G / 255.0);
       D3DBrowser1.FrontlightColor.Blue := (B / 255.0);
     end;
  D3DBrowser1.Displaying := true;
end;

procedure TForm1.ussererLichtkegelwinkel1Click(Sender: TObject);
var
  v : TD3DValue;
  Code : integer;
label
  Anfang;
begin
Anfang:
  Form2.ShowModal;
  if Form2.ModalResult = mrOK then begin
    val(Form2.Edit1.Text,v,Code);
    if Code <> 0 then begin
      Application.MessageBox('Ungltige Eingabe','Fehler',MB_APPLMODAL);
      goto Anfang;
    end;
    D3DBrowser1.FrontlightPenumbra := v;
  end;
end;

procedure TForm1.InnererLichtkegelwinkel1Click(Sender: TObject);
var
  v : TD3DValue;
  Code : integer;
label
  Anfang;
begin
Anfang:
  Form2.ShowModal;
  if Form2.ModalResult = mrOK then begin
    val(Form2.Edit1.Text,v,Code);
    if Code <> 0 then begin
      Application.MessageBox('Ungltige Eingabe','Fehler',MB_APPLMODAL);
      goto Anfang;
    end;
    D3DBrowser1.FrontlightUmbra := v;
  end;
end;

procedure TForm1.usserenLichtkegelwinkelerhhen1Click(Sender: TObject);
begin
  with D3DBrowser1 do FrontlightPenumbra := FrontlightPenumbra + 0.05;
end;

procedure TForm1.A1Click(Sender: TObject);
begin
  with D3DBrowser1 do FrontlightPenumbra := FrontlightPenumbra - 0.05;
end;

procedure TForm1.InnerenLichtkelwinkelerhhen1Click(Sender: TObject);
begin
  with D3DBrowser1 do FrontlightUmbra := FrontlightUmbra + 0.05;
end;

procedure TForm1.Umbra1Click(Sender: TObject);
begin
  with D3DBrowser1 do FrontlightUmbra := FrontlightUmbra - 0.05;
end;

procedure TForm1.ffnungswinkel1Click(Sender: TObject);
var
  v : TD3DValue;
  Code : integer;
label
  Anfang;
begin
Anfang:
  Form2.ShowModal;
  if Form2.ModalResult = mrOK then begin
    val(Form2.Edit1.Text,v,Code);
    if Code <> 0 then begin
      Application.MessageBox('Ungltige Eingabe','Fehler',MB_APPLMODAL);
      goto Anfang;
    end;
    D3DBrowser1.FOV := v;
  end;
end;

procedure TForm1.FOV1Click(Sender: TObject);
begin
  with D3DBrowser1 do FOV := FOV + DeltaAngle;
end;

procedure TForm1.FOV2Click(Sender: TObject);
begin
  with D3DBrowser1 do FOV := FOV - DeltaAngle;
end;

procedure TForm1.Linkrotieren1Click(Sender: TObject);
begin
  D3DBrowser1.RotateLeft(DeltaRotate);
end;

procedure TForm1.Rechtsrotieren1Click(Sender: TObject);
begin
  D3DBrowser1.RotateRight(DeltaRotate);
end;

procedure TForm1.Nachobenrotieren1Click(Sender: TObject);
begin
  D3DBrowser1.RotateUp(DeltaRotate);
end;

procedure TForm1.Nachuntenrotieren1Click(Sender: TObject);
begin
  D3DBrowser1.RotateDown(DeltaRotate);
end;

procedure TForm1.Nachvornebewegen1Click(Sender: TObject);
begin
  with D3DBrowser1 do MoveForward(Meshsize * DeltaMove);
end;

procedure TForm1.Nachhintenbewegen1Click(Sender: TObject);
begin
  with D3DBrowser1 do MoveBackward(Meshsize * DeltaMove);
end;

procedure TForm1.Nachlinksbewegen1Click(Sender: TObject);
begin
  with D3DBrowser1 do MoveLeft(Meshsize * DeltaMove);
end;

procedure TForm1.Nachrechtsbewegen1Click(Sender: TObject);
begin
  with D3DBrowser1 do MoveRight(Meshsize * DeltaMove);
end;

procedure TForm1.Nachlinksrollen1Click(Sender: TObject);
begin
  D3DBrowser1.RollLeft(DeltaRotate);
end;

procedure TForm1.Nachrechtsrollen1Click(Sender: TObject);
begin
  D3DBrowser1.RollRight(DeltaRotate);
end;

procedure TForm1.Objektzentrieren1Click(Sender: TObject);
begin
  D3DBrowser1.CenterMesh;
end;

procedure TForm1.Entfernunganpassen1Click(Sender: TObject);
begin
  D3DBrowser1.AdjustDistance(1.0);
end;

procedure TForm1.ZumZentrumblicken1Click(Sender: TObject);
begin
  D3DBrowser1.LookAtCenter;
end;

procedure TForm1.Objektgreanpassen1Click(Sender: TObject);
begin
  D3DBrowser1.AdjustMeshsize(1.0);
end;

procedure TForm1.Nachobenbewegen1Click(Sender: TObject);
begin
  with D3DBrowser1 do MoveUp(Meshsize * DeltaMove);
end;

procedure TForm1.Nachuntenbewegen1Click(Sender: TObject);
begin
  with D3DBrowser1 do MoveDown(Meshsize * DeltaMove);
end;

procedure TForm1.VollbildClick(Sender: TObject);
begin
  with Form3 do
  begin
    Visible := true;
    WindowState := wsMaximized;
    Position := poScreenCenter;
  end;
  with D3DBrowser1 do
  begin
    Fullscreen := not Fullscreen;
    if Fullscreen then
    begin
      with Sender as TMenuItem do Checked := true;
      Form1.Visible := false;
    end
    else
    begin
      Fenstermodus.Checked := true;
      Form3.Visible := false;
      Form1.Visible := true;
    end;
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  D3DBrowser1.Displaying := true;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  D3DBrowser1.Displaying := false;
end;

procedure TForm1.FenstermodusClick(Sender: TObject);
begin
  with Sender as TMenuItem do Checked := true;
  D3DBrowser1.Fullscreen := false;
end;

procedure TForm1.Dithering1Click(Sender: TObject);
begin
  with D3DBrowser1 do Dither := not Dither;
  with Sender as TMenuItem do Checked := D3DBrowser1.Dither;
end;

end.
