unit ctapfelw;
{ Apfelmnnchen-Demo  fr das Einbinden von
  Assemblerroutinen  unter Delphi }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls;
type paratyp=integer;
type
  TForm1 = class(TForm)
    Image1: TImage;
    StatusBar1: TStatusBar;
    procedure showapfel;
    procedure OnCreate(Sender: TObject);
    procedure OnMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure OnMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OnResize(Sender: TObject);
    procedure SetSize (x,y:integer);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  MaxX,Maxy:integer;
  R0,I0:single;
  grenze,Tiefe:paratyp;
  zoom,del:single;
  Centerx,Centery:integer;
  working:boolean;
  stopapfel:boolean;
  Bitmap: TBitmap;
  adr:pointer;
  HDC,Fensterhandle:Longint;
  ThreadId:integer;
  Thandle:word;
  Fhandle:word;
  Tstart, Tend: longint;
  iter:longint;
  end;

var
  Form1: TForm1;
  colortab:array[0..255] of longint;

implementation

{$R *.DFM}

{$L man32.obj}

Function Iterasm87
    (I,R :single; Grenze, Tiefe :Paratyp):Paratyp; Pascal; external;

Function Iterasm487
    (I,R :single; Grenze, Tiefe :Paratyp):Paratyp; Pascal; external;

Function IterPasS
     (I,R :single; Grenze, Tiefe :Paratyp):Paratyp;
  var A,B,C:Single; Count:Paratyp;
  Begin
   Count:= 0;
   A:=0; B:=0;
   Repeat
            C:= SQR(A) - SQR(B) + R;
      B:= 2*A*B + I;
      A:= C;
      INC (Count);
   Until (abs (A) >Grenze) or (Abs (B) > Grenze)
           or (Count>=Tiefe);
  IterpasS:=Count;
  End;


Procedure Tform1.ShowApfel;
Var I,R:Single;
    Color:integer;
    x,y:integer;
begin
 image1.canvas.handle:=hdc;
 del:=1/zoom;
  y:=0;
  iter:=0;
  I:=I0-MaxY/2*del+Y*del;
    Repeat
       X:=0;
       R:=R0-MaxX/2*del+x*del;
       Repeat
         Color := Iterasm487 (I,R,Grenze,tiefe);
         image1.canvas.pixels [X, Y]:= Colortab[color];
         inc (iter,color);
         INC (X);
         R:=R+del;
       Until X>=MaxX;
       Windows.Paintdesktop(fhandle);
       INC (Y);
       I:=I+del;
    Until Y>=MaxY;
    tend:=gettickcount;
    StatusBar1.Panels[3].Text := Format('time: (%4.2f s)  %4.2f Mio Iterations/s ', [(tend-tstart)/1e3,iter/(tend-tstart)/1e3]);
    statusbar1.repaint;
end;

Function apfelthread (p:pointer):integer;
 begin
 form1.showapfel;
 endthread (77);
 apfelthread:=77;
 end;


Procedure TForm1.SetSize (x,y:integer);
begin
  Maxx:=X;
  MaxY:=Y;
  width:=MaxX;
  Height:=MaxY;
  Bitmap.Width := MaxX;
  Bitmap.Height := MaxY;
  Image1.width:=ClientWidth -40;
  Image1.height:=Clientheight-60;
  Centerx:=image1.width div 2;
  Centery:=image1.height div 2;
 end;

procedure TForm1.OnCreate(Sender: TObject);
var i:integer;
begin
  top:=0;
  left:=0;
  Bitmap := TBitmap.Create;
  Image1.Picture.Graphic := Bitmap;
  Image1.top:=top+10;
  Image1.left:=left+20;
  SetSize(640,350);
  Image1.canvas.Onchange:=nil;
  Image1.canvas.OnChanging:=nil;
  HDC:=GetDeviceContext (FensterHandle);
  R0:=0;I0:=0; grenze:=3; tiefe:=256; zoom:=100;
  for i:=0 to 255 do
   colortab[i]:=random(256) shl 16 + random (256) shl 8 +random(256);
  Threadid:=0;
  Fhandle:=image1.canvas.handle;
  tstart:=gettickcount;
  Thandle:=beginthread  (nil,0, apfelthread, @form1,0, ThreadId);
  StatusBar1.Panels[1].Text := Format('New: (%8.5f, %8.5f)', [R0, I0]);
  statusbar1.repaint;
  end;


procedure TForm1.OnMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
begin
 StatusBar1.Panels[0].Text := Format('(%8.5f, %8.5f)', [R0-(MaxX/2-X)/zoom,I0-(MaxY/2-Y)/zoom]);
end;

procedure TForm1.OnMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
  var para:longint;

begin
StatusBar1.Panels[1].Text := Format('(%8.5f, %8.5f)', [R0-(MaxX/2-X)/zoom,I0-(MaxY/2-Y)/zoom]);
 statusbar1.repaint;
 if threadid <> 0 then
  begin
  If getexitCodeThread (Thandle, exitcode) then
    begin
     if exitcode=still_active then Terminatethread (Thandle,70);
     closehandle (Thandle)
     end;
   I0:=I0-(MAXY/2-Y)*del;
   R0:=R0-(MAXX/2-X)*del;
   If Button= mbleft then Zoom:=zoom*2
   else if Button=mbright then Zoom:=zoom/2;


  end;
  tstart:=gettickcount;
  Thandle:=beginthread  (nil,0, apfelthread, @para,0, ThreadId);
end;

procedure TForm1.OnResize(Sender: TObject);
begin
setsize (width,height);
end;

end.

