// Installationsberwachung fr Windows 95/NT
// iwatchex.cpp   IWatch Extension
// 1998 by c't / Matthias Withopf

#if defined(_MSC_VER)
#pragma auto_inline(off)
#pragma optimize("s",on)
#endif

#include "iwatchsu.h"
#include "iwatchex.h"
#include <winsock.h>

Boolean   IsWin95                    = False;
HINSTANCE IWatchExtensionDllInstance = 0;
DWORD     IWatchProcessId            = 0;
HANDLE    WatchSema                  = 0;
HANDLE    SharedMemMapping           = 0;
Pointer   SharedMem                  = NULL;
HANDLE    WatchEvent                 = 0;
HANDLE    WatchEventR                = 0;

// Funktionen, die berwacht werden sollen

// Dateioperationen
typedef FARPROC (WINAPI *TGetProcAddress)(HMODULE hModule,LPCSTR lpProcName);
typedef HANDLE (WINAPI *TCreateFileA)(LPCSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,
                                      LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,
                                      DWORD dwFlagsAndAttributes,HANDLE hTemplateFile);
typedef HANDLE (WINAPI *TCreateFileW)(LPCWSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,
                                      LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,
                                      DWORD dwFlagsAndAttributes,HANDLE hTemplateFile);
typedef HFILE (WINAPI *T_lcreat)(LPCSTR lpPathName,int iAttribute);
typedef HFILE (WINAPI *T_lopen)(LPCSTR lpPathName,int iReadWrite);
typedef HFILE (WINAPI *TOpenFile)(LPCSTR lpFileName,LPOFSTRUCT lpReOpenBuff,UINT uStyle);
typedef BOOL (WINAPI *TDeleteFileA)(LPCSTR lpFileName);
typedef BOOL (WINAPI *TDeleteFileW)(LPCWSTR lpFileName);
typedef BOOL (WINAPI *TMoveFileA)(LPCSTR lpExistingFileName,LPCSTR lpNewFileName);
typedef BOOL (WINAPI *TMoveFileW)(LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName);
typedef BOOL (WINAPI *TMoveFileExA)(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,DWORD dwFlags);
typedef BOOL (WINAPI *TMoveFileExW)(LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName,DWORD dwFlags);
typedef BOOL (WINAPI *TCopyFileA)(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,BOOL bFailIfExists);
typedef BOOL (WINAPI *TCopyFileW)(LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName,BOOL bFailIfExists);
typedef BOOL (WINAPI *TCopyFileExA)(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,Pointer lpProgressRoutine,
                                    LPVOID lpData,LPBOOL pbCancel,DWORD dwCopyFlags);
typedef BOOL (WINAPI *TCopyFileExW)(LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName,Pointer lpProgressRoutine,
                                    LPVOID lpData,LPBOOL pbCancel,DWORD dwCopyFlags);
typedef INT (APIENTRY *TLZOpenFileA)(LPSTR lpFileName,LPOFSTRUCT lpReOpenBuf,WORD wStyle);
typedef INT (APIENTRY *TLZOpenFileW)(LPWSTR lpFileName,LPOFSTRUCT lpReOpenBuf,WORD wStyle);
typedef BOOL (WINAPI *TCreateDirectoryA)(LPCSTR lpPathName,LPSECURITY_ATTRIBUTES lpSecurityAttributes);
typedef BOOL (WINAPI *TCreateDirectoryW)(LPCWSTR lpPathName,LPSECURITY_ATTRIBUTES lpSecurityAttributes);
typedef BOOL (WINAPI *TRemoveDirectoryA)(LPCSTR lpPathName);
typedef BOOL (WINAPI *TRemoveDirectoryW)(LPCWSTR lpPathName);
typedef BOOL (WINAPI *TCreateProcessA)(LPCSTR lpApplicationName,LPSTR lpCommandLine,LPSECURITY_ATTRIBUTES lpProcessAttributes,
                                       LPSECURITY_ATTRIBUTES lpThreadAttributes,BOOL bInheritHandles,DWORD dwCreationFlags,
                                       LPVOID lpEnvironment,LPCSTR lpCurrentDirectory,LPSTARTUPINFOA lpStartupInfo,
                                       LPPROCESS_INFORMATION lpProcessInformation);
typedef BOOL (WINAPI *TCreateProcessW)(LPCWSTR lpApplicationName,LPWSTR lpCommandLine,LPSECURITY_ATTRIBUTES lpProcessAttributes,
                                       LPSECURITY_ATTRIBUTES lpThreadAttributes,BOOL bInheritHandles,DWORD dwCreationFlags,
                                       LPVOID lpEnvironment,LPCWSTR lpCurrentDirectory,LPSTARTUPINFOW lpStartupInfo,
                                       LPPROCESS_INFORMATION lpProcessInformation);
typedef UINT (WINAPI *TWinExec)(LPCSTR lpCmdLine,UINT uCmdShow);

// Registry-Operationen
typedef LONG (APIENTRY *TRegCreateKeyExA)(HKEY hKey,LPCSTR lpSubKey,DWORD Reserved,LPSTR lpClass,DWORD dwOptions,
                                          REGSAM samDesired,LPSECURITY_ATTRIBUTES lpSecurityAttributes,
                                          PHKEY phkResult,LPDWORD lpdwDisposition);
typedef LONG (APIENTRY *TRegCreateKeyExW)(HKEY hKey,LPCWSTR lpSubKey,DWORD Reserved,LPWSTR lpClass,DWORD dwOptions,
                                          REGSAM samDesired,LPSECURITY_ATTRIBUTES lpSecurityAttributes,
                                          PHKEY phkResult,LPDWORD lpdwDisposition);
typedef LONG (APIENTRY *TRegOpenKeyExA)(HKEY hKey,LPCSTR lpSubKey,DWORD ulOptions,REGSAM samDesired,PHKEY phkResult);
typedef LONG (APIENTRY *TRegOpenKeyExW)(HKEY hKey,LPCWSTR lpSubKey,DWORD ulOptions,REGSAM samDesired,PHKEY phkResult);
typedef LONG (APIENTRY *TRegQueryValueExA)(HKEY hKey,LPCSTR lpValueName,LPDWORD lpReserved,LPDWORD lpType,LPBYTE lpData,LPDWORD lpcbData);
typedef LONG (APIENTRY *TRegQueryValueExW)(HKEY hKey,LPCWSTR lpValueName,LPDWORD lpReserved,LPDWORD lpType,LPBYTE lpData,LPDWORD lpcbData);

// TCP-Operationen
typedef int (PASCAL FAR *Tconnect)(SOCKET s,const struct sockaddr FAR *name,int namelen);

// Installations-Operationen
typedef DWORD (APIENTRY *TVerInstallFileA)(DWORD uFlags,LPSTR szSrcFileName,LPSTR szDestFileName,LPSTR szSrcDir,
                                           LPSTR szDestDir,LPSTR szCurDir,LPSTR szTmpFile,PUINT lpuTmpFileLen);
typedef DWORD (APIENTRY *TVerInstallFileW)(DWORD uFlags,LPWSTR szSrcFileName,LPWSTR szDestFileName,LPWSTR szSrcDir,
                                           LPWSTR szDestDir,LPWSTR szCurDir,LPWSTR szTmpFile,PUINT lpuTmpFileLen);

TGetProcAddress    OrigGetProcAddress    = NULL;
TCreateFileA       OrigCreateFileA       = NULL;
TCreateFileW       OrigCreateFileW       = NULL;
T_lcreat           Orig_lcreat           = NULL;
T_lopen            Orig_lopen            = NULL;
TOpenFile          OrigOpenFile          = NULL;
TDeleteFileA       OrigDeleteFileA       = NULL;
TDeleteFileW       OrigDeleteFileW       = NULL;
TMoveFileA         OrigMoveFileA         = NULL;
TMoveFileW         OrigMoveFileW         = NULL;
TMoveFileExA       OrigMoveFileExA       = NULL;
TMoveFileExW       OrigMoveFileExW       = NULL;
TCopyFileA         OrigCopyFileA         = NULL;
TCopyFileW         OrigCopyFileW         = NULL;
TCopyFileExA       OrigCopyFileExA       = NULL;
TCopyFileExW       OrigCopyFileExW       = NULL;
TLZOpenFileA       OrigLZOpenFileA       = NULL;
TLZOpenFileW       OrigLZOpenFileW       = NULL;
TCreateDirectoryA  OrigCreateDirectoryA  = NULL;
TCreateDirectoryW  OrigCreateDirectoryW  = NULL;
TRemoveDirectoryA  OrigRemoveDirectoryA  = NULL;
TRemoveDirectoryW  OrigRemoveDirectoryW  = NULL;
TCreateProcessA    OrigCreateProcessA    = NULL;
TCreateProcessW    OrigCreateProcessW    = NULL;
TWinExec           OrigWinExec           = NULL;
TRegCreateKeyExA   OrigRegCreateKeyExA   = NULL;
TRegCreateKeyExW   OrigRegCreateKeyExW   = NULL;
TRegOpenKeyExA     OrigRegOpenKeyExA     = NULL;
TRegOpenKeyExW     OrigRegOpenKeyExW     = NULL;
TRegQueryValueExA  OrigRegQueryValueExA  = NULL;
TRegQueryValueExW  OrigRegQueryValueExW  = NULL;
Tconnect           Origconnect           = NULL;
TVerInstallFileA   OrigVerInstallFileA   = NULL;
TVerInstallFileW   OrigVerInstallFileW   = NULL;

LongWord GetProcAddressAddr   = 0;
LongWord CreateFileAAddr      = 0;
LongWord CreateFileWAddr      = 0;
LongWord _lcreatAddr          = 0;
LongWord _lopenAddr           = 0;
LongWord OpenFileAddr         = 0;
LongWord DeleteFileAAddr      = 0;
LongWord DeleteFileWAddr      = 0;
LongWord MoveFileAAddr        = 0;
LongWord MoveFileWAddr        = 0;
LongWord MoveFileExAAddr      = 0;
LongWord MoveFileExWAddr      = 0;
LongWord CopyFileAAddr        = 0;
LongWord CopyFileWAddr        = 0;
LongWord CopyFileExAAddr      = 0;
LongWord CopyFileExWAddr      = 0;
LongWord LZOpenFileAAddr      = 0;
LongWord LZOpenFileWAddr      = 0;
LongWord CreateDirectoryAAddr = 0;
LongWord CreateDirectoryWAddr = 0;
LongWord RemoveDirectoryAAddr = 0;
LongWord RemoveDirectoryWAddr = 0;
LongWord CreateProcessAAddr   = 0;
LongWord CreateProcessWAddr   = 0;
LongWord WinExecAddr          = 0;
LongWord RegCreateKeyExAAddr  = 0;
LongWord RegCreateKeyExWAddr  = 0;
LongWord RegOpenKeyExAAddr    = 0;
LongWord RegOpenKeyExWAddr    = 0;
LongWord RegQueryValueExAAddr = 0;
LongWord RegQueryValueExWAddr = 0;
LongWord connectAddr          = 0;
LongWord VerInstallFileAAddr  = 0;
LongWord VerInstallFileWAddr  = 0;

TWatchAction ShowDlgBox(TWatchLevel ThisLevel,Boolean IgnorePossible,PChar Action,PChar FuncCall,PChar Arg,Boolean ChangeArg = False,int ArgSize = 0)
{
  WaitForSingleObject(WatchSema,INFINITE);
  int R = wa_Error;
  if (SharedMem)
    {
      static LongWord Count = 0;
      PByte p = (PByte)SharedMem;
      LongWord x = (LongWord)ThisLevel;
      int l = sizeof x; MemCpy(p,&x,l); p += l;
      x = (LongWord)IgnorePossible;
      l = sizeof x; MemCpy(p,&x,l); p += l;
      x = (LongWord)ChangeArg;
      l = sizeof x; MemCpy(p,&x,l); p += l;
      x = (LongWord)GetCurrentThreadId();
      l = sizeof x; MemCpy(p,&x,l); p += l;
      Char AppName[256];
      if (!GetModuleFileName(0,(Pchar)AppName,sizeof AppName)) StrCpy(AppName,(PChar)"?");
      if (!Action)   Action   = (PChar)"";
      if (!FuncCall) FuncCall = (PChar)"";
      if (!Arg)      Arg      = (PChar)"";
      l = StrLen(AppName)  + 1; MemCpy(p,AppName,l);  p += l;
      Char tmp[80]; wsprintf((Pchar)tmp,(Pchar)"%lu: ",++Count);
      l = StrLen(tmp);          MemCpy(p,tmp,l);      p += l;
      l = StrLen(Action)   + 1; MemCpy(p,Action,l);   p += l;
      l = StrLen(FuncCall) + 1; MemCpy(p,FuncCall,l); p += l;
      l = StrLen(Arg)      + 1; MemCpy(p,Arg,l);

      SetEvent(WatchEvent);
      WaitForSingleObject(WatchEventR,INFINITE);
      ResetEvent(WatchEventR);

      p = (PByte)SharedMem;
      l = sizeof x; MemCpy(&x,p,l); p += l;
      R = (int)x;
      PChar NewArg = p; //p += StrLen(p) + 1;
      if (ChangeArg && NewArg[0])
        StrCopy(Arg,NewArg,ArgSize);
    }
  ReleaseSemaphore(WatchSema,1,NULL);
  return (TWatchAction)R;
}

Boolean FileExistsAnsi(PChar FileName)
{
  DWORD l = GetFileAttributesA((Pchar)FileName);
  if (l == (DWORD)-1)
    {
      switch(GetLastError())
        {
          case ERROR_FILE_NOT_FOUND:
          case ERROR_PATH_NOT_FOUND:
            return False;
        }
    }
  return True;
}

Boolean FileExistsUnicode(PWord FileName)
{
  DWORD l = GetFileAttributesW(FileName);
  if (l == (DWORD)-1)
    {
      switch(GetLastError())
        {
          case ERROR_FILE_NOT_FOUND:
          case ERROR_PATH_NOT_FOUND:
            return False;
        }
    }
  return True;
}

Boolean FileIsInWindowsDirAnsi(PChar FileName)
{
  if (!FileName) return False;
  Char tmp[512];
#if 1
  lstrcpy((Pchar)tmp,(Pchar)FileName);
#else
  GetFullPathNameA((Pchar)FileName,sizeof tmp,(Pchar)tmp,NULL);
#endif
  Char tmp1[256];
  GetWindowsDirectoryA((Pchar)tmp1,sizeof tmp1);
  int l1 = StrLen(tmp1);
  int l2 = StrLen(tmp);
  int l = l1 < l2 ? l1 : l2;
  if (CompareStringA(LOCALE_USER_DEFAULT,NORM_IGNORECASE,(Pchar)tmp,l,(Pchar)tmp1,l) == 2)
    return True;
  return False;
}

int StrLenUnicode(PWord s)
{
  int l = 0;
  while (*s++) ++l;
  return l;
}

Boolean FileIsInWindowsDirUnicode(PWord FileName)
{
  if (!FileName) return False;
  Word tmp[512];
#if 1
  lstrcpyW(tmp,FileName);
#else
  if (!GetFullPathNameW(FileName,sizeof tmp,tmp,NULL)) return False;
#endif
  Word tmp1[256];
  if (!GetWindowsDirectoryW(tmp1,sizeof tmp1)) return False;
  int l1 = StrLenUnicode(tmp1);
  int l2 = StrLenUnicode(tmp);
  int l = l1 < l2 ? l1 : l2;
  if (!l) return False;
  if (CompareStringW(LOCALE_USER_DEFAULT,NORM_IGNORECASE,tmp,l,tmp1,l) == 2)
    return True;
  return False;
}

Boolean AllocStrings(int Sizes[],PChar P[],int Count)
{
  MemSet(P,0,Count * sizeof P[0]);
  for (int i = 0;i < Count;++i)
    {
      P[i] = new Char[Sizes[i]];
      if (!P[i])
        {
          for (int j = 0;j < Count;++j)
            if (P[j])
              delete [] P[j];
          MemSet(P,0,Count * sizeof P[0]);
          return False;
        }
      P[i][0] = '\0';
    }
  return True;
}

void FreeStrings(PChar P[],int Count)
{
  for (int i = 0;i < Count;++i)
    if (P[i])
      delete [] P[i];
  MemSet(P,0,Count * sizeof P[0]);
}

Boolean AllocUStrings(int Sizes[],PWord P[],int Count)
{
  MemSet(P,0,Count * sizeof P[0]);
  for (int i = 0;i < Count;++i)
    {
      P[i] = new Word[Sizes[i]];
      if (!P[i])
        {
          for (int j = 0;j < Count;++j)
            if (P[j])
              delete [] P[j];
          MemSet(P,0,Count * sizeof P[0]);
          return False;
        }
      P[i][0] = '\0';
    }
  return True;
}

void FreeUStrings(PWord P[],int Count)
{
  for (int i = 0;i < Count;++i)
    if (P[i])
      delete [] P[i];
  MemSet(P,0,Count * sizeof P[0]);
}

void UStr2Str(PWord UStr,PChar Str,int MaxSize)
{
  if (!UStr || !Str)
    {
      if (Str) *Str = '\0';
      return;
    }
  for (--MaxSize;*UStr && (MaxSize > 0);--MaxSize)
    *Str++ = (*UStr <= 0xFF ? (Char)*UStr++ : '?');
  *Str = '\0';
}

void Str2UStr(PChar Str,PWord UStr,int MaxSize)
{
  if (!Str || !UStr)
    {
      if (UStr) *UStr = (Word)'\0';
      return;
    }
  for (--MaxSize;*Str && (MaxSize > 0);--MaxSize)
    *UStr++ = (Word)*Str++;
  *UStr = (Word)'\0';
}

void DecodeParam_CreateFile(PChar tmp,PChar Title,PWatchLevel ThisLevel,PChar FuncName,Boolean Exists,Boolean InWindowsDir,PChar FileName,DWORD dwDesiredAccess,DWORD dwShareMode,
                            LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,
                            DWORD dwFlagsAndAttributes,HANDLE hTemplateFile)
{
  *ThisLevel = wl_NoInfo;
  Boolean WriteAccess = False;
  Char tmp1[80];
  StrCpy(tmp,FuncName);
  StrCat(tmp,(PChar)"(");
  if (FileName)
    {
      StrCat(tmp,(PChar)"\"");
      StrCat(tmp,FileName);
      StrCat(tmp,(PChar)"\"");
    }
  else
    StrCat(tmp,(PChar)"NULL");
  StrCat(tmp,(PChar)",");
  if (!dwDesiredAccess)
    StrCat(tmp,(PChar)"0");
  else
    {
      Boolean f = False;
      if (dwDesiredAccess & GENERIC_READ)  { StrCat(tmp,(PChar)"GENERIC_READ"); f = True; }
      if (dwDesiredAccess & GENERIC_WRITE) { WriteAccess = True; if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"GENERIC_WRITE"); }
    }
  StrCat(tmp,(PChar)",");
  if (!dwShareMode)
    StrCat(tmp,(PChar)"0");
  else
    {
      Boolean f = False;
      if (dwShareMode & FILE_SHARE_READ)  { StrCat(tmp,(PChar)"FILE_SHARE_READ"); f = True; }
      if (dwShareMode & FILE_SHARE_WRITE) { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_SHARE_WRITE"); }
    }
  StrCat(tmp,(PChar)",");
  if (lpSecurityAttributes)
    {
      wsprintf((Pchar)tmp1,(Pchar)"0x%lX",lpSecurityAttributes);
      StrCat(tmp,tmp1);
    }
  else
    StrCat(tmp,(PChar)"NULL");
  StrCat(tmp,(PChar)",");
  switch(dwCreationDisposition)
    {
      case CREATE_NEW:
        StrCat(tmp,(PChar)"CREATE_NEW");
        StrCpy(Title,(PChar)"Datei erzeugen, falls sie noch nicht existiert");
        if (InWindowsDir)
          {
            *ThisLevel = wl_VeryImportant;
            StrCat(Title,(PChar)" SYSTEMVERZEICHNIS!");
          }
        break;

      case CREATE_ALWAYS:
        StrCat(tmp,(PChar)"CREATE_ALWAYS");
        StrCpy(Title,(PChar)"Datei erzeugen, ggf. berschreiben");
        if (InWindowsDir)
          {
            *ThisLevel = wl_VeryImportant;
            StrCat(Title,(PChar)" SYSTEMVERZEICHNIS!");
          }
        if (Exists)
          {
            *ThisLevel = wl_VeryImportant;
            StrCat(Title,(PChar)" WIRD BERSCHRIEBEN!");
          }
        break;

      case OPEN_EXISTING:
        StrCat(tmp,(PChar)"OPEN_EXISTING");
        StrCpy(Title,(PChar)"Bestehende Datei ffnen");
        if (InWindowsDir)
          {
            if (WriteAccess) *ThisLevel = wl_VeryImportant;
            StrCat(Title,(PChar)" SYSTEMVERZEICHNIS!");
          }
        break;

      case OPEN_ALWAYS:
        StrCat(tmp,(PChar)"OPEN_ALWAYS");
        StrCpy(Title,(PChar)"Datei ffnen, ggf. erzeugen, falls sie noch nicht existiert");
        if (InWindowsDir)
          {
            *ThisLevel = wl_VeryImportant;
            StrCat(Title,(PChar)" SYSTEMVERZEICHNIS!");
          }
        if (Exists)
          {
            *ThisLevel = wl_VeryImportant;
            StrCat(Title,(PChar)" WIRD BERSCHRIEBEN!");
          }
        break;

      case TRUNCATE_EXISTING:
        StrCat(tmp,(PChar)"TRUNCATE_EXISTING");
        StrCpy(Title,(PChar)"Bestehende Datei ffnen und Inhalt lschen");
        if (InWindowsDir)
          {
            *ThisLevel = wl_VeryImportant;
            StrCat(Title,(PChar)" SYSTEMVERZEICHNIS!");
          }
        if (Exists)
          {
            *ThisLevel = wl_VeryImportant;
            StrCat(Title,(PChar)" WIRD BERSCHRIEBEN!");
          }
        break;

      default:
        {
          Char tmp1[80];
          wsprintf((Pchar)tmp1,(Pchar)"0x%lX",dwCreationDisposition);
          StrCat(tmp,(PChar)"?");
          StrCat(tmp,tmp1);
          StrCat(tmp,(PChar)"?");
        }
        StrCpy(Title,(PChar)"Unbekannte Dateioperation!");
        *ThisLevel = wl_VeryImportant;
        break;
    }
  StrCat(tmp,(PChar)",");
  if (!dwFlagsAndAttributes)
    StrCat(tmp,(PChar)"0");
  else
    {
#if !defined(FILE_ATTRIBUTE_OFFLINE)
#define FILE_ATTRIBUTE_OFFLINE          0x00001000
#endif
      Boolean f = False;
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_ARCHIVE)     { StrCat(tmp,(PChar)"FILE_ATTRIBUTE_ARCHIVE"); f = True; }
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_COMPRESSED)  { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_ATTRIBUTE_COMPRESSED"); f = True; }
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_NORMAL)      { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_ATTRIBUTE_NORMAL"); f = True; }
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_HIDDEN)      { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_ATTRIBUTE_HIDDEN"); f = True; }
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_READONLY)    { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_ATTRIBUTE_READONLY"); f = True; }
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_SYSTEM)      { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_ATTRIBUTE_SYSTEM"); f = True; }
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_DIRECTORY)   { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_ATTRIBUTE_DIRECTORY"); f = True; }
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_TEMPORARY)   { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_ATTRIBUTE_TEMPORARY"); f = True; }
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_COMPRESSED)  { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_ATTRIBUTE_COMPRESSED"); f = True; }
      if (dwFlagsAndAttributes & FILE_ATTRIBUTE_OFFLINE)     { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_ATTRIBUTE_OFFLINE"); f = True; }
      if (dwFlagsAndAttributes & FILE_FLAG_WRITE_THROUGH)    { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_FLAG_WRITE_THROUGH"); f = True; }
      if (dwFlagsAndAttributes & FILE_FLAG_OVERLAPPED)       { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_FLAG_OVERLAPPED"); f = True; }
      if (dwFlagsAndAttributes & FILE_FLAG_NO_BUFFERING)     { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_FLAG_NO_BUFFERING"); f = True; }
      if (dwFlagsAndAttributes & FILE_FLAG_RANDOM_ACCESS)    { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_FLAG_RANDOM_ACCESS"); f = True; }
      if (dwFlagsAndAttributes & FILE_FLAG_SEQUENTIAL_SCAN)  { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_FLAG_SEQUENTIAL_SCAN"); f = True; }
      if (dwFlagsAndAttributes & FILE_FLAG_DELETE_ON_CLOSE)  { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_FLAG_DELETE_ON_CLOSE"); f = True; }
      if (dwFlagsAndAttributes & FILE_FLAG_BACKUP_SEMANTICS) { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_FLAG_BACKUP_SEMANTICS"); f = True; }
      if (dwFlagsAndAttributes & FILE_FLAG_POSIX_SEMANTICS)  { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"FILE_FLAG_POSIX_SEMANTICS"); f = True; }
    //if (dwFlagsAndAttributes & SECURITY_ANONYMOUS)         { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"SECURITY_ANONYMOUS"); f = True; }
      if (dwFlagsAndAttributes & SECURITY_IDENTIFICATION)    { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"SECURITY_IDENTIFICATION"); f = True; }
      if (dwFlagsAndAttributes & SECURITY_IMPERSONATION)     { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"SECURITY_IMPERSONATION"); f = True; }
      if (dwFlagsAndAttributes & SECURITY_DELEGATION)        { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"SECURITY_DELEGATION"); f = True; }
      if (dwFlagsAndAttributes & SECURITY_CONTEXT_TRACKING)  { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"SECURITY_CONTEXT_TRACKING"); f = True; }
      if (dwFlagsAndAttributes & SECURITY_EFFECTIVE_ONLY)    { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"SECURITY_EFFECTIVE_ONLY"); f = True; }
    }
  StrCat(tmp,(PChar)",");
  if (hTemplateFile)
    {
      wsprintf((Pchar)tmp1,(Pchar)"0x%lX",hTemplateFile);
      StrCat(tmp,tmp1);
    }
  else
    StrCat(tmp,(PChar)"NULL");
  StrCat(tmp,(PChar)")");
  if (WriteAccess)
    {
      if (InWindowsDir && (*ThisLevel < wl_VeryImportant))
        {
          *ThisLevel = wl_Important;
          StrCat(Title,(PChar)" SYSTEMVERZEICHNIS!");
        }
      if (*ThisLevel < wl_Important) *ThisLevel = wl_Important;
      StrCat(Title,(PChar)": Schreibzugriff!");
    }
  if (FileName)
    if ((FileName[0] == '\\') && (FileName[1] == '\\') && (FileName[2] == '.'))
      {
        StrCat(Title,(PChar)"; direkter Zugriff auf Treiber/Laufwerk!");
        if (*ThisLevel < wl_VeryImportant) *ThisLevel = wl_VeryImportant;
      }
}

HANDLE WINAPI MyCreateFileA(LPCSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,
                            LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,
                            DWORD dwFlagsAndAttributes,HANDLE hTemplateFile)
{
  HANDLE R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,1024};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return INVALID_HANDLE_VALUE; }
  Boolean Exists = FileExistsAnsi((PChar)lpFileName);
  Boolean InWindowsDir = FileIsInWindowsDirAnsi((PChar)lpFileName);
  Char Title[256];
  TWatchLevel ThisLevel;
  DecodeParam_CreateFile(P[0],Title,&ThisLevel,(PChar)"CreateFileA",Exists,InWindowsDir,(PChar)lpFileName,dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
  StrCopy(P[1],(PChar)lpFileName,S[1]);
  switch(ShowDlgBox(ThisLevel,False,Title,P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = OrigCreateFileA((Pchar)P[1],dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
        OldError = GetLastError();
        break;

      default:
      case wa_Ignore:
      case wa_No:
        R = INVALID_HANDLE_VALUE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

HANDLE WINAPI MyCreateFileW(LPCWSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,
                            DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,HANDLE hTemplateFile)
{
  HANDLE R;
  DWORD  OldError;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return INVALID_HANDLE_VALUE; }
  UStr2Str((PWord)lpFileName,P[1],S[1]);
  Boolean Exists = FileExistsUnicode((PWord)lpFileName);
  Boolean InWindowsDir = FileIsInWindowsDirUnicode((PWord)lpFileName);
  Char Title[256];
  TWatchLevel ThisLevel;
  DecodeParam_CreateFile(P[0],Title,&ThisLevel,(PChar)"CreateFileW",Exists,InWindowsDir,P[1],dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
  switch(ShowDlgBox(ThisLevel,False,Title,P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        {
          PWord PU[1];
          int   SU[] = {4096};
          if (!AllocUStrings(SU,PU,sizeof PU / sizeof PU[0])) { OldError = ERROR_NOT_ENOUGH_MEMORY; R = INVALID_HANDLE_VALUE; break; }
          Str2UStr(P[1],PU[0],SU[0]);
          R = OrigCreateFileW(PU[0],dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
          FreeUStrings(PU,sizeof PU / sizeof PU[0]);
        }
        OldError = GetLastError();
        break;

      default:
      case wa_Ignore:
      case wa_No:
        R = INVALID_HANDLE_VALUE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

HFILE WINAPI My_lcreat(LPCSTR lpPathName,int iAttribute)
{
  HFILE R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,1024};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return HFILE_ERROR; }
  wsprintf((Pchar)P[0],(Pchar)"_lcreat(\"%s\",0x%lX)",(PChar)(lpPathName ? lpPathName : "NULL"),iAttribute);
  Boolean Exists = FileExistsAnsi((PChar)lpPathName);
  Boolean InWindowsDir = FileIsInWindowsDirAnsi((PChar)lpPathName);
  Char Title[256];
  StrCpy(Title,(PChar)"Datei erzeugen, ggf. berschreiben");
  TWatchLevel ThisLevel = wl_Important;
  if (Exists)
    {
      ThisLevel = wl_VeryImportant;
      StrCat(Title,(PChar)" WIRD BERSCHRIEBEN!");
    }
  if (InWindowsDir)
    {
      ThisLevel = wl_VeryImportant;
      StrCat(Title,(PChar)" SYSTEMVERZEICHNIS!");
    }
  StrCopy(P[1],(PChar)lpPathName,S[1]);
  switch(ShowDlgBox(wl_Important,False,Title,P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = Orig_lcreat((Pchar)P[1],iAttribute);
        OldError = GetLastError();
        break;

      default:
      case wa_Ignore:
      case wa_No:
        R = HFILE_ERROR;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

HFILE WINAPI My_lopen(LPCSTR lpPathName,int iReadWrite)
{
  HFILE R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,1024};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return HFILE_ERROR; }
  wsprintf((Pchar)P[0],(Pchar)"_lopen(\"%s\",0x%lX)",(PChar)(lpPathName ? lpPathName : "NULL"),iReadWrite);
  Boolean Exists = FileExistsAnsi((PChar)lpPathName);
  Boolean InWindowsDir = FileIsInWindowsDirAnsi((PChar)lpPathName);
  Char Title[256];
  StrCpy(Title,(PChar)"Bestehende Datei ffnen");
  TWatchLevel ThisLevel = wl_Important;
  if (Exists && (iReadWrite & 3))     // Schreibzugriff
    {
      ThisLevel = wl_VeryImportant;
      StrCat(Title,(PChar)" Schreibzugriff!");
    }
  if (InWindowsDir)
    {
      if (iReadWrite & 3) ThisLevel = wl_VeryImportant; // Schreibzugriff in Windows-Verzeichnis
      StrCat(Title,(PChar)" SYSTEMVERZEICHNIS!");
    }
  StrCopy(P[1],(PChar)lpPathName,S[1]);
  switch(ShowDlgBox(wl_Important,False,Title,P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = Orig_lopen((Pchar)P[1],iReadWrite);
        OldError = GetLastError();
        break;

      default:
      case wa_Ignore:
      case wa_No:
        R = HFILE_ERROR;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

void DecodeParam_OpenFile(PChar tmp,PChar Title,PWatchLevel ThisLevel,PChar FuncName,Boolean Exists,Boolean InWindowsDir,PChar FileName,LPOFSTRUCT lpReOpenBuff,UINT uStyle)
{
  *ThisLevel = wl_Important;
  Boolean WriteAccess = False;
  Char tmp1[80];
  StrCpy(tmp,FuncName);
  StrCat(tmp,(PChar)"(");
  if (FileName)
    {
      StrCat(tmp,(PChar)"\"");
      StrCat(tmp,FileName);
      StrCat(tmp,(PChar)"\"");
    }
  else
    StrCat(tmp,(PChar)"NULL");
  StrCat(tmp,(PChar)",");
  if (lpReOpenBuff)
    {
      wsprintf((Pchar)tmp1,(Pchar)"0x%lX",lpReOpenBuff);
      StrCat(tmp,tmp1);
    }
  else
    StrCat(tmp,(PChar)"NULL");
  StrCat(tmp,(PChar)",");
  StrCpy(Title,(PChar)"Datei ffnen");
  if (!uStyle)
    StrCat(tmp,(PChar)"0");
  else
    {
      Boolean f = False;
//    if (uStyle & OF_READ)             { StrCat(tmp,(PChar)"OF_READ"); f = True; }
      if (uStyle & OF_WRITE)            { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_WRITE"); f = True; WriteAccess = True; }
      if (uStyle & OF_READWRITE)        { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_READWRITE"); f = True; WriteAccess = True; }
//    if (uStyle & OF_SHARE_COMPAT)     { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_SHARE_COMPAT"); f = True; }
      if (uStyle & OF_SHARE_EXCLUSIVE)  { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_SHARE_EXCLUSIVE"); f = True; }
      if (uStyle & OF_SHARE_DENY_WRITE) { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_SHARE_DENY_WRITE"); f = True; }
      if (uStyle & OF_SHARE_DENY_READ)  { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_SHARE_DENY_READ"); f = True; }
      if (uStyle & OF_SHARE_DENY_NONE)  { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_SHARE_DENY_NONE"); f = True; }
      if (uStyle & OF_PARSE)            { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_PARSE"); f = True; }
      if (uStyle & OF_DELETE)           { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_DELETE"); f = True; WriteAccess = True; StrCpy(Title,(PChar)"Datei lschen"); *ThisLevel = wl_VeryImportant; }
      if (uStyle & OF_VERIFY)           { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_VERIFY"); f = True; }
      if (uStyle & OF_CANCEL)           { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_CANCEL"); f = True; }
      if (uStyle & OF_CREATE)           { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_CREATE"); f = True; WriteAccess = True; StrCpy(Title,(PChar)"Datei anlegen"); if (Exists) { StrCat(Title,(PChar)" WIRD BERSCHRIEBEN!"); *ThisLevel = wl_VeryImportant; } }
      if (uStyle & OF_PROMPT)           { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_PROMPT"); f = True; }
      if (uStyle & OF_EXIST)            { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_EXIST"); f = True; }
      if (uStyle & OF_REOPEN)           { if (f) StrCat(tmp,(PChar)"|"); StrCat(tmp,(PChar)"OF_REOPEN"); f = True; }
    }
  StrCat(tmp,(PChar)")");
  if (WriteAccess)
    {
      if (InWindowsDir)
        {
          *ThisLevel = wl_VeryImportant;
          StrCat(Title,(PChar)" SYSTEMVERZEICHNIS!");
        }
      if (*ThisLevel < wl_Important) *ThisLevel = wl_Important;
      StrCat(Title,(PChar)": Schreibzugriff!");
    }
}

HFILE WINAPI MyOpenFile(LPCSTR lpFileName,LPOFSTRUCT lpReOpenBuff,UINT uStyle)
{
  HFILE R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,1024};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return HFILE_ERROR; }
  Boolean Exists = FileExistsAnsi((PChar)lpFileName);
  Boolean InWindowsDir = FileIsInWindowsDirAnsi((PChar)lpFileName);
  Char Title[256];
  TWatchLevel ThisLevel;
  DecodeParam_OpenFile(P[0],Title,&ThisLevel,(PChar)"OpenFile",Exists,InWindowsDir,(PChar)lpFileName,lpReOpenBuff,uStyle);
  StrCopy(P[1],(PChar)lpFileName,S[1]);
  switch(ShowDlgBox(ThisLevel,False,Title,P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = OrigOpenFile((Pchar)P[1],lpReOpenBuff,uStyle);
        OldError = GetLastError();
        break;

      default:
      case wa_Ignore:
      case wa_No:
        R = HFILE_ERROR;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyDeleteFileA(LPCSTR lpFileName)
{
  BOOL R;
  DWORD OldError;
  PChar P[1];
  int   S[] = {4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  wsprintf((Pchar)P[0],(Pchar)"DeleteFileA(\"%s\")",lpFileName);
  Char Title[256];
  StrCpy(Title,(PChar)"Datei lschen");
  Boolean InWindowsDir = FileIsInWindowsDirAnsi((PChar)lpFileName);
  if (InWindowsDir) StrCat(Title,(PChar)" SYSTEMVERZEICHNIS");
  switch(ShowDlgBox(wl_VeryImportant,True,Title,P[0],(PChar)lpFileName))
    {
      case wa_Yes:
        R = OrigDeleteFileA(lpFileName);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyDeleteFileW(LPCWSTR lpFileName)
{
  BOOL R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,1024};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  UStr2Str((PWord)lpFileName,P[1],S[1]);
  wsprintf((Pchar)P[0],(Pchar)"DeleteFileW(\"%s\")",P[1]);
  Char Title[256];
  StrCpy(Title,(PChar)"Datei lschen");
  Boolean InWindowsDir = FileIsInWindowsDirUnicode((PWord)lpFileName);
  if (InWindowsDir) StrCat(Title,(PChar)" SYSTEMVERZEICHNIS");
  switch(ShowDlgBox(wl_VeryImportant,True,Title,P[0],P[1]))
    {
      case wa_Yes:
        R = OrigDeleteFileW(lpFileName);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyMoveFileA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName)
{
  BOOL R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  wsprintf((Pchar)P[0],(Pchar)"MoveFileA(\"%s\",\"%s\")",lpExistingFileName,lpNewFileName);
  StrCopy(P[1],(PChar)lpNewFileName,S[1]);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Datei umbenennen/verschieben",P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = OrigMoveFileA(lpExistingFileName,(Pchar)P[1]);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyMoveFileW(LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName)
{
  BOOL R;
  DWORD OldError;
  PChar P[3];
  int   S[] = {4096,4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  UStr2Str((PWord)lpExistingFileName,P[1],S[1]);
  UStr2Str((PWord)lpNewFileName,P[2],S[2]);
  wsprintf((Pchar)P[0],(Pchar)"MoveFileW(\"%s\",\"%s\")",P[1],P[2]);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Datei umbenennen/verschieben",P[0],P[2],True,S[2]))
    {
      case wa_Yes:
        {
          PWord PU[1];
          int   SU[] = {4096};
          if (!AllocUStrings(SU,PU,sizeof PU / sizeof PU[0])) { OldError = ERROR_NOT_ENOUGH_MEMORY; R = FALSE; break; }
          Str2UStr(P[2],PU[0],SU[0]);
          R = OrigMoveFileW(lpExistingFileName,PU[0]);
          FreeUStrings(PU,sizeof PU / sizeof PU[0]);
        }
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyMoveFileExA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,DWORD dwFlags)
{
  BOOL R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  wsprintf((Pchar)P[0],(Pchar)"MoveFileExA(\"%s\",\"%s\",0x%lX)",lpExistingFileName,lpNewFileName,dwFlags);
  StrCopy(P[1],(PChar)lpNewFileName,S[1]);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Datei umbenennen/verschieben",P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = OrigMoveFileExA(lpExistingFileName,(Pchar)P[1],dwFlags);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyMoveFileExW(LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName,DWORD dwFlags)
{
  BOOL R;
  DWORD OldError;
  PChar P[3];
  int   S[] = {4096,4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  UStr2Str((PWord)lpExistingFileName,P[1],S[1]);
  UStr2Str((PWord)lpNewFileName,P[2],S[2]);
  wsprintf((Pchar)P[0],(Pchar)"MoveFileExW(\"%s\",\"%s\",0x%lX)",P[1],P[2],dwFlags);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Datei umbenennen/verschieben",P[0],P[2],True,S[2]))
    {
      case wa_Yes:
        {
          PWord PU[1];
          int   SU[] = {4096};
          if (!AllocUStrings(SU,PU,sizeof PU / sizeof PU[0])) { OldError = ERROR_NOT_ENOUGH_MEMORY; R = FALSE; break; }
          Str2UStr(P[2],PU[0],SU[0]);
          R = OrigMoveFileExW(lpExistingFileName,PU[0],dwFlags);
          FreeUStrings(PU,sizeof PU / sizeof PU[0]);
        }
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyCopyFileA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,BOOL bFailIfExists)
{
  BOOL R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  wsprintf((Pchar)P[0],(Pchar)"CopyFileA(\"%s\",\"%s\",%s)",lpExistingFileName,lpNewFileName,bFailIfExists ? "TRUE" : "FALSE");
  StrCopy(P[1],(PChar)lpNewFileName,S[1]);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Datei kopieren",P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = OrigCopyFileA(lpExistingFileName,(Pchar)P[1],bFailIfExists);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyCopyFileW(LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName,BOOL bFailIfExists)
{
  BOOL R;
  DWORD OldError;
  PChar P[3];
  int   S[] = {4096,4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  UStr2Str((PWord)lpExistingFileName,P[1],S[1]);
  UStr2Str((PWord)lpNewFileName,P[2],S[2]);
  wsprintf((Pchar)P[0],(Pchar)"CopyFileW(\"%s\",\"%s\",%s)",P[1],P[2],bFailIfExists ? "TRUE" : "FALSE");
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Datei kopieren",P[0],P[2],True,S[2]))
    {
      case wa_Yes:
        {
          PWord PU[1];
          int   SU[] = {4096};
          if (!AllocUStrings(SU,PU,sizeof PU / sizeof PU[0])) { OldError = ERROR_NOT_ENOUGH_MEMORY; R = FALSE; break; }
          Str2UStr(P[2],PU[0],SU[0]);
          R = OrigCopyFileW(lpExistingFileName,PU[0],bFailIfExists);
          FreeUStrings(PU,sizeof PU / sizeof PU[0]);
        }
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyCopyFileExA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,Pointer lpProgressRoutine,LPVOID lpData,LPBOOL pbCancel,DWORD dwCopyFlags)
{
  BOOL R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  wsprintf((Pchar)P[0],(Pchar)"CopyFileExA(\"%s\",\"%s\",0x%lX,0x%lX,0x%lX,0x%lX)",lpExistingFileName,lpNewFileName,lpProgressRoutine,lpData,pbCancel,dwCopyFlags);
  StrCopy(P[1],(PChar)lpNewFileName,S[1]);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Datei kopieren",P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = OrigCopyFileExA(lpExistingFileName,(Pchar)P[1],lpProgressRoutine,lpData,pbCancel,dwCopyFlags);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyCopyFileExW(LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName,Pointer lpProgressRoutine,LPVOID lpData,LPBOOL pbCancel,DWORD dwCopyFlags)
{
  BOOL R;
  DWORD OldError;
  PChar P[3];
  int   S[] = {4096,4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  UStr2Str((PWord)lpExistingFileName,P[1],S[1]);
  UStr2Str((PWord)lpNewFileName,P[2],S[2]);
  wsprintf((Pchar)P[0],(Pchar)"CopyFileExW(\"%s\",\"%s\",0x%lX,0x%lX,0x%lX,0x%lX)",P[1],P[2],lpProgressRoutine,lpData,pbCancel,dwCopyFlags);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Datei kopieren",P[0],P[2],True,S[2]))
    {
      case wa_Yes:
        {
          PWord PU[1];
          int   SU[] = {4096};
          if (!AllocUStrings(SU,PU,sizeof PU / sizeof PU[0])) { OldError = ERROR_NOT_ENOUGH_MEMORY; R = FALSE; break; }
          Str2UStr(P[2],PU[0],SU[0]);
          R = OrigCopyFileExW(lpExistingFileName,PU[0],lpProgressRoutine,lpData,pbCancel,dwCopyFlags);
          FreeUStrings(PU,sizeof PU / sizeof PU[0]);
        }
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

INT APIENTRY MyLZOpenFileA(LPSTR lpFileName,LPOFSTRUCT lpReOpenBuf,WORD wStyle)
{
  INT R;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return -5/*LZERROR_GLOBALLOC*/;
  Boolean Exists = FileExistsAnsi((PChar)lpFileName);
  Boolean InWindowsDir = FileIsInWindowsDirAnsi((PChar)lpFileName);
  Char Title[256];
  TWatchLevel ThisLevel;
  DecodeParam_OpenFile(P[0],Title,&ThisLevel,(PChar)"LZOpenFileA",Exists,InWindowsDir,(PChar)lpFileName,lpReOpenBuf,wStyle);
  StrCopy(P[1],(PChar)lpFileName,S[1]);
  switch(ShowDlgBox(ThisLevel,False,Title,P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = OrigLZOpenFileA((Pchar)P[1],lpReOpenBuf,wStyle);
        break;

      default:
      case wa_Ignore:
      case wa_No:
        R = -1/*LZERROR_BADINHANDLE*/;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

INT APIENTRY MyLZOpenFileW(LPWSTR lpFileName,LPOFSTRUCT lpReOpenBuf,WORD wStyle)
{
  INT R;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return -5/*LZERROR_GLOBALLOC*/;
  UStr2Str((PWord)lpFileName,P[1],S[1]);
  Boolean Exists = FileExistsUnicode((PWord)lpFileName);
  Boolean InWindowsDir = FileIsInWindowsDirUnicode((PWord)lpFileName);
  Char Title[256];
  TWatchLevel ThisLevel;
  DecodeParam_OpenFile(P[0],Title,&ThisLevel,(PChar)"LZOpenFileW",Exists,InWindowsDir,P[1],lpReOpenBuf,wStyle);
  switch(ShowDlgBox(ThisLevel,False,Title,P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        {
          PWord PU[1];
          int   SU[] = {4096};
          if (!AllocUStrings(SU,PU,sizeof PU / sizeof PU[0])) { R = -5/*LZERROR_GLOBALLOC*/; break; }
          Str2UStr(P[2],PU[0],SU[0]);
          R = OrigLZOpenFileW(PU[0],lpReOpenBuf,wStyle);
          FreeUStrings(PU,sizeof PU / sizeof PU[0]);
        }
        break;

      default:
      case wa_Ignore:
      case wa_No:
        R = -1/*LZERROR_BADINHANDLE*/;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

BOOL WINAPI MyCreateDirectoryA(LPCSTR lpPathName,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
  BOOL R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  wsprintf((Pchar)P[0],(Pchar)"CreateDirectoryA(\"%s\",0x%08lX)",lpPathName,lpSecurityAttributes);
  StrCopy(P[1],(PChar)lpPathName,S[1]);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Verzeichnis anlegen",P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = OrigCreateDirectoryA((Pchar)P[1],lpSecurityAttributes);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyCreateDirectoryW(LPCWSTR lpPathName,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
  BOOL R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  UStr2Str((PWord)lpPathName,P[1],S[1]);
  wsprintf((Pchar)P[0],(Pchar)"CreateDirectoryW(\"%s\",%08lX)",P[1],lpSecurityAttributes);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Verzeichnis anlegen",P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        {
          PWord PU[1];
          int   SU[] = {4096};
          if (!AllocUStrings(SU,PU,sizeof PU / sizeof PU[0])) { OldError = ERROR_NOT_ENOUGH_MEMORY; R = FALSE; break; }
          Str2UStr(P[2],PU[0],SU[0]);
          R = OrigCreateDirectoryW(PU[0],lpSecurityAttributes);
          FreeUStrings(PU,sizeof PU / sizeof PU[0]);
        }
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyRemoveDirectoryA(LPCSTR lpPathName)
{
  BOOL R;
  DWORD OldError;
  PChar P[1];
  int   S[] = {4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  wsprintf((Pchar)P[0],(Pchar)"RemoveDirectoryA(\"%s\")",lpPathName);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Verzeichnis entfernen",P[0],(PChar)lpPathName))
    {
      case wa_Yes:
        R = OrigRemoveDirectoryA(lpPathName);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyRemoveDirectoryW(LPCWSTR lpPathName)
{
  BOOL R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  UStr2Str((PWord)lpPathName,P[1],S[1]);
  wsprintf((Pchar)P[0],(Pchar)"RemoveDirectoryW(\"%s\")",P[1]);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Verzeichnis entfernen",P[0],P[1]))
    {
      case wa_Yes:
        R = OrigRemoveDirectoryW(lpPathName);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyCreateProcessA(LPCSTR lpApplicationName,LPSTR lpCommandLine,LPSECURITY_ATTRIBUTES lpProcessAttributes,LPSECURITY_ATTRIBUTES lpThreadAttributes,BOOL bInheritHandles,DWORD dwCreationFlags,LPVOID lpEnvironment,LPCSTR lpCurrentDirectory,LPSTARTUPINFOA lpStartupInfo,LPPROCESS_INFORMATION lpProcessInformation)
{
  BOOL R;
  DWORD OldError;
  PChar P[1];
  int   S[] = {4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  wsprintf((Pchar)P[0],(Pchar)"CreateProcessA(\"%s\",\"%s\",0x%lX,0x%lX,%s,0x%lX,0x%lX,\"%s\",0x%08lX,0x%08lX)",
           lpApplicationName ? lpApplicationName : "NULL",lpCommandLine ? lpCommandLine : "NULL",lpProcessAttributes,lpThreadAttributes,bInheritHandles ? "TRUE" : "FALSE",dwCreationFlags,
           lpEnvironment,lpCurrentDirectory ? lpCurrentDirectory : "NULL",lpStartupInfo,lpProcessInformation);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Anwendung starten",P[0],(PChar)(lpApplicationName ? lpApplicationName : lpCommandLine)))
    {
      case wa_Yes:
        R = OrigCreateProcessA(lpApplicationName,lpCommandLine,lpProcessAttributes,lpThreadAttributes,bInheritHandles,dwCreationFlags,lpEnvironment,lpCurrentDirectory,lpStartupInfo,lpProcessInformation);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

BOOL WINAPI MyCreateProcessW(LPCWSTR lpApplicationName,LPWSTR lpCommandLine,LPSECURITY_ATTRIBUTES lpProcessAttributes,LPSECURITY_ATTRIBUTES lpThreadAttributes,BOOL bInheritHandles,DWORD dwCreationFlags,LPVOID lpEnvironment,LPCWSTR lpCurrentDirectory,LPSTARTUPINFOW lpStartupInfo,LPPROCESS_INFORMATION lpProcessInformation)
{
  BOOL R;
  DWORD OldError;
  PChar P[3];
  int   S[] = {4096,4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return FALSE; }
  UStr2Str((PWord)lpApplicationName,P[1],S[1]);
  UStr2Str((PWord)lpCommandLine,    P[2],S[2]);
  wsprintf((Pchar)P[0],(Pchar)"CreateProcessW(\"%s\",\"%s\",0x%lX,0x%lX,%s,0x%lX,0x%lX,0x%lX,0x%08lX,0x%08lX)",
           lpApplicationName ? P[1] : (PChar)"NULL",lpCommandLine ? P[2] : (PChar)"NULL",lpProcessAttributes,lpThreadAttributes,bInheritHandles ? "TRUE" : "FALSE",dwCreationFlags,
           lpEnvironment,lpCurrentDirectory,lpStartupInfo,lpProcessInformation);
  switch(ShowDlgBox(wl_VeryImportant,True,(PChar)"Anwendung starten",P[0],lpApplicationName ? P[1] : P[2]))
    {
      case wa_Yes:
        R = OrigCreateProcessW(lpApplicationName,lpCommandLine,lpProcessAttributes,lpThreadAttributes,bInheritHandles,dwCreationFlags,lpEnvironment,lpCurrentDirectory,lpStartupInfo,lpProcessInformation);
        OldError = GetLastError();
        break;

      case wa_Ignore:
        R = TRUE;
        OldError = 0;
        break;

      default:
      case wa_No:
        R = FALSE;
        OldError = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

UINT WINAPI MyWinExec(LPCSTR lpCmdLine,UINT uCmdShow)
{
  BOOL R;
  PChar P[1];
  int   S[] = {4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return 0;
  wsprintf((Pchar)P[0],(Pchar)"WinExec(\"%s\",0x%lX)",lpCmdLine ? lpCmdLine : "",uCmdShow);
  switch(ShowDlgBox(wl_VeryImportant,False,(PChar)"Anwendung starten",P[0],(PChar)lpCmdLine))
    {
      case wa_Yes:
        R = OrigWinExec(lpCmdLine,uCmdShow);
        break;

      default:
      case wa_No:
      case wa_Ignore:
        R = 0;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

LONG APIENTRY MyRegCreateKeyExA(HKEY hKey,LPCSTR lpSubKey,DWORD Reserved,LPSTR lpClass,DWORD dwOptions,REGSAM samDesired,LPSECURITY_ATTRIBUTES lpSecurityAttributes,PHKEY phkResult,LPDWORD lpdwDisposition)
{
  LONG R;
  PChar P[1];
  int   S[] = {4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return FALSE;
  wsprintf((Pchar)P[0],(Pchar)"RegCreateKeyExA(0x%lX,\"%s\",0x%lX,0x%lX,0x%lX,0x%lX,0x%lX,0x%lX,0x%lX)",hKey,lpSubKey ? lpSubKey : "NULL",Reserved,lpClass,dwOptions,samDesired,lpSecurityAttributes,phkResult,lpdwDisposition);
  switch(ShowDlgBox(wl_Important,False,(PChar)"Registryeintrag anlegen/abfragen",P[0],(PChar)lpSubKey))
    {
      case wa_Yes:
        R = OrigRegCreateKeyExA(hKey,lpSubKey,Reserved,lpClass,dwOptions,samDesired,lpSecurityAttributes,phkResult,lpdwDisposition);
        break;

      default:
      case wa_No:
      case wa_Ignore:
        R = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

LONG APIENTRY MyRegCreateKeyExW(HKEY hKey,LPCWSTR lpSubKey,DWORD Reserved,LPWSTR lpClass,DWORD dwOptions,REGSAM samDesired,LPSECURITY_ATTRIBUTES lpSecurityAttributes,PHKEY phkResult,LPDWORD lpdwDisposition)
{
  LONG R;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return FALSE;
  UStr2Str((PWord)lpSubKey,P[1],S[1]);
  wsprintf((Pchar)P[0],(Pchar)"RegCreateKeyExW(0x%lX,\"%s\",0x%lX,0x%lX,0x%lX,0x%lX,0x%lX,0x%lX,0x%lX)",hKey,lpSubKey ? P[1] : (PChar)"NULL",Reserved,lpClass,dwOptions,samDesired,lpSecurityAttributes,phkResult,lpdwDisposition);
  switch(ShowDlgBox(wl_Important,False,(PChar)"Registryeintrag anlegen/abfragen",P[0],P[1]))
    {
      case wa_Yes:
        R = OrigRegCreateKeyExW(hKey,lpSubKey,Reserved,lpClass,dwOptions,samDesired,lpSecurityAttributes,phkResult,lpdwDisposition);
        break;

      default:
      case wa_No:
      case wa_Ignore:
        R = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

LONG APIENTRY MyRegOpenKeyExA(HKEY hKey,LPCSTR lpSubKey,DWORD ulOptions,REGSAM samDesired,PHKEY phkResult)
{
  LONG R;
  PChar P[1];
  int   S[] = {4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return FALSE;
  wsprintf((Pchar)P[0],(Pchar)"RegOpenKeyExA(0x%lX,\"%s\",0x%lX,0x%lX,0x%lX)",hKey,lpSubKey ? lpSubKey : "NULL",ulOptions,samDesired,phkResult);
  switch(ShowDlgBox(wl_Verbose,False,(PChar)"Registry abfragen",P[0],(PChar)lpSubKey))
    {
      case wa_Yes:
        R = OrigRegOpenKeyExA(hKey,lpSubKey,ulOptions,samDesired,phkResult);
        break;

      default:
      case wa_No:
      case wa_Ignore:
        R = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

LONG APIENTRY MyRegOpenKeyExW(HKEY hKey,LPCWSTR lpSubKey,DWORD ulOptions,REGSAM samDesired,PHKEY phkResult)
{
  LONG R;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return FALSE;
  UStr2Str((PWord)lpSubKey,P[1],S[1]);
  wsprintf((Pchar)P[0],(Pchar)"RegOpenKeyExW(0x%lX,\"%s\",0x%lX,0x%lX,0x%lX)",hKey,lpSubKey ? P[1] : (PChar)"NULL",ulOptions,samDesired,phkResult);
  switch(ShowDlgBox(wl_Verbose,False,(PChar)"Registry abfragen",P[0],P[1]))
    {
      case wa_Yes:
        R = OrigRegOpenKeyExW(hKey,lpSubKey,ulOptions,samDesired,phkResult);
        break;

      default:
      case wa_No:
      case wa_Ignore:
        R = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

LONG APIENTRY MyRegQueryValueExA(HKEY hKey,LPCSTR lpValueName,LPDWORD lpReserved,LPDWORD lpType,LPBYTE lpData,LPDWORD lpcbData)
{
  LONG R;
  PChar P[1];
  int   S[] = {4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return FALSE;
  wsprintf((Pchar)P[0],(Pchar)"RegQueryValueExA(0x%lX,\"%s\",0x%lX,0x%lX,0x%lX,0x%lX)",hKey,lpValueName ? lpValueName : "NULL",lpReserved,lpType,lpData,lpcbData);
  switch(ShowDlgBox(wl_Verbose,False,(PChar)"Registry abfragen",P[0],(PChar)lpValueName))
    {
      case wa_Yes:
        R = OrigRegQueryValueExA(hKey,lpValueName,lpReserved,lpType,lpData,lpcbData);
        break;

      default:
      case wa_No:
      case wa_Ignore:
        R = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

LONG APIENTRY MyRegQueryValueExW(HKEY hKey,LPCWSTR lpValueName,LPDWORD lpReserved,LPDWORD lpType,LPBYTE lpData,LPDWORD lpcbData)
{
  LONG R;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return FALSE;
  UStr2Str((PWord)lpValueName,P[1],S[1]);
  wsprintf((Pchar)P[0],(Pchar)"RegQueryValueExW(0x%lX,\"%s\",0x%lX,0x%lX,0x%lX,0x%lX)",hKey,lpValueName ? P[1] : (PChar)"NULL",lpReserved,lpType,lpData,lpcbData);
  switch(ShowDlgBox(wl_Verbose,False,(PChar)"Registry abfragen",P[0],P[1]))
    {
      case wa_Yes:
        R = OrigRegQueryValueExW(hKey,lpValueName,lpReserved,lpType,lpData,lpcbData);
        break;

      default:
      case wa_No:
      case wa_Ignore:
        R = ERROR_ACCESS_DENIED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

DWORD APIENTRY MyVerInstallFileA(DWORD uFlags,LPSTR szSrcFileName,LPSTR szDestFileName,LPSTR szSrcDir,LPSTR szDestDir,LPSTR szCurDir,LPSTR szTmpFile,PUINT lpuTmpFileLen)
{
  LONG R;
  PChar P[2];
  int   S[] = {4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return VIF_OUTOFMEMORY;
  wsprintf((Pchar)P[0],(Pchar)"VerInstallFileA(0x%lX,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",0x%lX,0x%lX)",uFlags,szSrcFileName ? szSrcFileName : "NULL",szDestFileName ? szDestFileName : "NULL",szSrcDir ? szSrcDir : "NULL",szDestDir ? szDestDir : "NULL",szCurDir ? szCurDir : "szCurDir",szTmpFile,lpuTmpFileLen);
  StrCopy(P[1],(PChar)szDestDir,S[1]);
  switch(ShowDlgBox(wl_VeryImportant,False,(PChar)"Datei installieren",P[0],P[1],True,S[1]))
    {
      case wa_Yes:
        R = OrigVerInstallFileA(uFlags,szSrcFileName,szDestFileName,szSrcDir,(Pchar)P[1],szCurDir,szTmpFile,lpuTmpFileLen);
        break;

      default:
      case wa_No:
      case wa_Ignore:
        R = VIF_ACCESSVIOLATION;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

DWORD APIENTRY MyVerInstallFileW(DWORD uFlags,LPWSTR szSrcFileName,LPWSTR szDestFileName,LPWSTR szSrcDir,LPWSTR szDestDir,LPWSTR szCurDir,LPWSTR szTmpFile,PUINT lpuTmpFileLen)
{
  LONG R;
  PChar P[6];
  int   S[] = {4096,4096,4096,4096,4096,4096};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) return VIF_OUTOFMEMORY;
  UStr2Str((PWord)szSrcFileName, P[1],S[1]);
  UStr2Str((PWord)szDestFileName,P[2],S[2]);
  UStr2Str((PWord)szSrcDir,      P[3],S[3]);
  UStr2Str((PWord)szDestDir,     P[4],S[4]);
  UStr2Str((PWord)szCurDir,      P[5],S[5]);
  wsprintf((Pchar)P[0],(Pchar)"VerInstallFileW(0x%lX,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",0x%lX,0x%lX)",uFlags,szSrcFileName ? P[1] : (PChar)"NULL",szDestFileName ? P[2] : (PChar)"NULL",szSrcDir ? P[3] : (PChar)"NULL",szDestDir ? P[4] : (PChar)"NULL",szCurDir ? P[5] : (PChar)"szCurDir",szTmpFile,lpuTmpFileLen);
  switch(ShowDlgBox(wl_VeryImportant,False,(PChar)"Datei installieren",P[0],P[4],True,S[4]))
    {
      case wa_Yes:
        {
          PWord PU[1];
          int   SU[] = {4096};
          if (!AllocUStrings(SU,PU,sizeof PU / sizeof PU[0])) { R = VIF_OUTOFMEMORY; break; }
          Str2UStr(P[4],PU[0],SU[0]);
          R = OrigVerInstallFileW(uFlags,szSrcFileName,szDestFileName,szSrcDir,PU[0],szCurDir,szTmpFile,lpuTmpFileLen);
          FreeUStrings(PU,sizeof PU / sizeof PU[0]);
        }
        break;

      default:
      case wa_No:
      case wa_Ignore:
        R = VIF_ACCESSVIOLATION;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  return R;
}

int PASCAL FAR Myconnect(SOCKET s,const struct sockaddr FAR *name,int namelen)
{
  int R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,256};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return SOCKET_ERROR; }
  if (name && namelen && (name->sa_family == AF_INET))
    {
      wsprintf((Pchar)P[1],(Pchar)"IPAddr:%d.%d.%d.%d, Port:%d",(Byte)name->sa_data[2],(Byte)name->sa_data[3],(Byte)name->sa_data[4],(Byte)name->sa_data[5],
                           ((Word)(Byte)name->sa_data[0] << 8) | (Byte)name->sa_data[1]);
      wsprintf((Pchar)P[0],(Pchar)"connect(%ld,{%s},%d)",s,P[1],namelen);
    }
  else
    wsprintf((Pchar)P[0],(Pchar)"connect(%ld,0x%08lX,%d)",s,name,namelen);
  switch(ShowDlgBox(wl_VeryImportant,False,(PChar)"TCP/IP-Verbindung starten",P[0],P[1]))
    {
      case wa_Yes:
        R = Origconnect(s,name,namelen);
        OldError = GetLastError();
        break;

      default:
      case wa_Ignore:
      case wa_No:
        R = SOCKET_ERROR;
        OldError = WSAECONNREFUSED;
        break;
    }
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

FARPROC WINAPI MyGetProcAddress(HMODULE hModule,LPCSTR lpProcName)
{
  FARPROC R;
  DWORD OldError;
  PChar P[2];
  int   S[] = {4096,256};
  if (!AllocStrings(S,P,sizeof P / sizeof P[0])) { SetLastError(ERROR_NOT_ENOUGH_MEMORY); return NULL; }
  if ((LongWord)lpProcName > 0x0000FFFF)
    {
      wsprintf((Pchar)P[0],(Pchar)"GetProcAddress(0x%08lX,\"%s\")",hModule,lpProcName);
      StrCopy(P[1],(PChar)lpProcName,S[1]);
    }
  else
    {
      wsprintf((Pchar)P[0],(Pchar)"GetProcAddress(0x%08lX,\"0x%lX\")",hModule,lpProcName);
      wsprintf((Pchar)P[1],(Pchar)"0x%lX",lpProcName);
    }
  switch(ShowDlgBox(wl_Verbose,False,(PChar)"Funktion abfragen",P[0],P[1]))
    {
      case wa_Yes:
        R = OrigGetProcAddress(hModule,lpProcName);
        break;

      default:
      case wa_Ignore:
      case wa_No:
        R = NULL;
        break;
    }
  if (R)
    {
      if      (R == (FARPROC)GetProcAddressAddr)   R = (FARPROC)MyGetProcAddress;
      else if (R == (FARPROC)CreateFileAAddr)      R = (FARPROC)MyCreateFileA;
      else if (R == (FARPROC)CreateFileWAddr)      R = (FARPROC)MyCreateFileW;
      else if (R == (FARPROC)_lcreatAddr)          R = (FARPROC)My_lcreat;
      else if (R == (FARPROC)_lopenAddr)           R = (FARPROC)My_lopen;
      else if (R == (FARPROC)OpenFileAddr)         R = (FARPROC)MyOpenFile;
      else if (R == (FARPROC)DeleteFileAAddr)      R = (FARPROC)MyDeleteFileA;
      else if (R == (FARPROC)DeleteFileWAddr)      R = (FARPROC)MyDeleteFileW;
      else if (R == (FARPROC)MoveFileAAddr)        R = (FARPROC)MyMoveFileA;
      else if (R == (FARPROC)MoveFileWAddr)        R = (FARPROC)MyMoveFileW;
      else if (R == (FARPROC)MoveFileExAAddr)      R = (FARPROC)MyMoveFileExA;
      else if (R == (FARPROC)MoveFileExWAddr)      R = (FARPROC)MyMoveFileExW;
      else if (R == (FARPROC)CopyFileAAddr)        R = (FARPROC)MyCopyFileA;
      else if (R == (FARPROC)CopyFileWAddr)        R = (FARPROC)MyCopyFileW;
      else if (R == (FARPROC)CopyFileExAAddr)      R = (FARPROC)MyCopyFileExA;
      else if (R == (FARPROC)CopyFileExWAddr)      R = (FARPROC)MyCopyFileExW;
      else if (R == (FARPROC)LZOpenFileAAddr)      R = (FARPROC)MyLZOpenFileA;
      else if (R == (FARPROC)LZOpenFileWAddr)      R = (FARPROC)MyLZOpenFileW;
      else if (R == (FARPROC)CreateDirectoryAAddr) R = (FARPROC)MyCreateDirectoryA;
      else if (R == (FARPROC)CreateDirectoryWAddr) R = (FARPROC)MyCreateDirectoryW;
      else if (R == (FARPROC)RemoveDirectoryAAddr) R = (FARPROC)MyRemoveDirectoryA;
      else if (R == (FARPROC)RemoveDirectoryWAddr) R = (FARPROC)MyRemoveDirectoryW;
      else if (R == (FARPROC)CreateProcessAAddr)   R = (FARPROC)MyCreateProcessA;
      else if (R == (FARPROC)CreateProcessWAddr)   R = (FARPROC)MyCreateProcessW;
      else if (R == (FARPROC)WinExecAddr)          R = (FARPROC)MyWinExec;
      else if (R == (FARPROC)RegCreateKeyExAAddr)  R = (FARPROC)MyRegCreateKeyExA;
      else if (R == (FARPROC)RegCreateKeyExWAddr)  R = (FARPROC)MyRegCreateKeyExW;
      else if (R == (FARPROC)RegOpenKeyExAAddr)    R = (FARPROC)MyRegOpenKeyExA;
      else if (R == (FARPROC)RegOpenKeyExWAddr)    R = (FARPROC)MyRegOpenKeyExW;
      else if (R == (FARPROC)RegQueryValueExAAddr) R = (FARPROC)MyRegQueryValueExA;
      else if (R == (FARPROC)RegQueryValueExWAddr) R = (FARPROC)MyRegQueryValueExW;
      else if (R == (FARPROC)connectAddr)          R = (FARPROC)Myconnect;
      else if (R == (FARPROC)VerInstallFileAAddr)  R = (FARPROC)MyVerInstallFileA;
      else if (R == (FARPROC)VerInstallFileWAddr)  R = (FARPROC)MyVerInstallFileW;
    }
  OldError = GetLastError();
  FreeStrings(P,sizeof P / sizeof P[0]);
  SetLastError(OldError);
  return R;
}

// Funktionsaufrufe patchen

typedef enum
  {
    iwh_Ok = 0,
    iwh_UnknownError,
    iwh_NoExeBase,
    iwh_BadExeBase,
    iwh_BadDosSignature,
    iwh_BadNTSignature,
    iwh_BadImportDescriptor,
    iwh_IllegalImportDescriptor,
  } THookErrorCode,* PHookErrorCode;

LongWord SkipW95Thunk(LongWord FuncAddr)
{
#if defined(CPU_INTEL)
  if (IsWin95)
    if (FuncAddr >= 0x80000000)
      {
        if (!IsBadReadPtr((Pointer)FuncAddr,10))
          if (*(PBYTE)FuncAddr == 0x68)
            {
              LongWord RealAddress = *(PDWORD)((PBYTE)FuncAddr + 1);
              return RealAddress;
            }
      }
#endif
  return FuncAddr;
}

Boolean HookFunctions(Pointer ExeBase,PHookErrorCode ErrorCode)
{
  *ErrorCode = iwh_UnknownError;
  if (!ExeBase) { *ErrorCode = iwh_NoExeBase; return False; }
  if (IsBadReadPtr(ExeBase,sizeof(IMAGE_NT_HEADERS))) { *ErrorCode = iwh_BadExeBase; return False; }
  PIMAGE_DOS_HEADER DOSHeader = (PIMAGE_DOS_HEADER)ExeBase;
  if (DOSHeader->e_magic != IMAGE_DOS_SIGNATURE) { *ErrorCode = iwh_BadDosSignature; return False; }
  PIMAGE_NT_HEADERS NTHeader = (PIMAGE_NT_HEADERS)((PByte)DOSHeader + DOSHeader->e_lfanew);
  if (NTHeader->Signature != IMAGE_NT_SIGNATURE) { *ErrorCode = iwh_BadNTSignature; return False; }
  PIMAGE_IMPORT_DESCRIPTOR ImportDesc = (PIMAGE_IMPORT_DESCRIPTOR)((PByte)ExeBase + NTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].VirtualAddress);

  Boolean RestoreProtection = False;
  DWORD   OldProtection;
  // Tabelle mit Funktionsadresse
  // Bei Programmen, die mit Visual C++ erzeugt wurden, ist diese Tabelle ReadOnly.
  // Da sie gepatched werden soll, mu zuvor auf Read/Write gendert werden.
  Pointer  FuncTab     = (Pointer)NTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IAT].VirtualAddress;
  LongWord FuncTabSize = NTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IAT].Size;
  if (FuncTab && FuncTabSize)
    {
      FuncTab = (PByte)ExeBase + (LongWord)FuncTab;
      MEMORY_BASIC_INFORMATION MI;
      VirtualQuery(FuncTab,&MI,sizeof MI);
      if (MI.Protect == PAGE_READONLY)
        {
          VirtualProtect(FuncTab,FuncTabSize,PAGE_READWRITE,&OldProtection);
          RestoreProtection = True;
        }
    }
  if (ImportDesc == (PIMAGE_IMPORT_DESCRIPTOR)NTHeader) { *ErrorCode = iwh_BadImportDescriptor; return False; }
  if (IsBadReadPtr(ImportDesc,1)) { *ErrorCode = iwh_IllegalImportDescriptor; return False; }

  HMODULE KernelModule = GetModuleHandle("KERNEL32.DLL");
  if (KernelModule)
    {
      GetProcAddressAddr   = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"GetProcAddress"));
      CreateFileAAddr      = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CreateFileA"));
      CreateFileWAddr      = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CreateFileW"));
      _lcreatAddr          = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"_lcreat"));
      _lopenAddr           = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"_lopen"));
      OpenFileAddr         = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"OpenFile"));
      DeleteFileAAddr      = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"DeleteFileA"));
      DeleteFileWAddr      = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"DeleteFileW"));
      MoveFileAAddr        = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"MoveFileA"));
      MoveFileWAddr        = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"MoveFileW"));
      MoveFileExAAddr      = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"MoveFileExA"));
      MoveFileExWAddr      = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"MoveFileExW"));
      CopyFileAAddr        = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CopyFileA"));
      CopyFileWAddr        = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CopyFileW"));
      CopyFileExAAddr      = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CopyFileExA"));
      CopyFileExWAddr      = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CopyFileExW"));
      CreateDirectoryAAddr = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CreateDirectoryA"));
      CreateDirectoryWAddr = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CreateDirectoryW"));
      RemoveDirectoryAAddr = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"RemoveDirectoryA"));
      RemoveDirectoryWAddr = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"RemoveDirectoryW"));
      CreateProcessAAddr   = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CreateProcessA"));
      CreateProcessWAddr   = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"CreateProcessW"));
      WinExecAddr          = SkipW95Thunk((LongWord)GetProcAddress(KernelModule,"WinExec"));
    }
  HMODULE LZModule = GetModuleHandle("LZ32.DLL");
  if (LZModule)
    {
      LZOpenFileAAddr = SkipW95Thunk((LongWord)GetProcAddress(LZModule,"LZOpenFileA"));
      LZOpenFileWAddr = SkipW95Thunk((LongWord)GetProcAddress(LZModule,"LZOpenFileW"));
    }
  HMODULE AdvApiModule = GetModuleHandle("advapi32.dll");
  if (AdvApiModule)
    {
      RegCreateKeyExAAddr  = SkipW95Thunk((LongWord)GetProcAddress(AdvApiModule,"RegCreateKeyExA"));
      RegCreateKeyExWAddr  = SkipW95Thunk((LongWord)GetProcAddress(AdvApiModule,"RegCreateKeyExW"));
      RegOpenKeyExAAddr    = SkipW95Thunk((LongWord)GetProcAddress(AdvApiModule,"RegOpenKeyExA"));
      RegOpenKeyExWAddr    = SkipW95Thunk((LongWord)GetProcAddress(AdvApiModule,"RegOpenKeyExW"));
      RegQueryValueExAAddr = SkipW95Thunk((LongWord)GetProcAddress(AdvApiModule,"RegQueryValueExA"));
      RegQueryValueExWAddr = SkipW95Thunk((LongWord)GetProcAddress(AdvApiModule,"RegQueryValueExW"));
    }
  HMODULE WinSockModule = GetModuleHandle("wsock32.dll");
  if (WinSockModule)
    {
      connectAddr = SkipW95Thunk((LongWord)GetProcAddress(WinSockModule,"connect"));
    }
  HMODULE VersionModule = GetModuleHandle("version.dll");
  if (VersionModule)
    {
      VerInstallFileAAddr = SkipW95Thunk((LongWord)GetProcAddress(VersionModule,"VerInstallFileA"));
      VerInstallFileWAddr = SkipW95Thunk((LongWord)GetProcAddress(VersionModule,"VerInstallFileW"));
    }
  for (;ImportDesc->Name;++ImportDesc)
    {
      for (PIMAGE_THUNK_DATA Thunk = (PIMAGE_THUNK_DATA)((PByte)ExeBase + (LongWord)ImportDesc->FirstThunk);Thunk->u1.Function;++Thunk)
        {
          LongWord F       = (LongWord)Thunk->u1.Function;
          LongWord F1      = SkipW95Thunk(F);
          DWORD    NewAddr = 0;
          if (F1 == CreateFileAAddr)
            {
              OrigCreateFileA = (TCreateFileA)F; NewAddr = (DWORD)MyCreateFileA;
L_PatchFunc:  DWORD Result  = 0;
              BOOL f = WriteProcessMemory(GetCurrentProcess(),Thunk,&NewAddr,sizeof NewAddr,&Result);
              if (!f)
                { Char tmp[256]; wsprintf((Pchar)tmp,(Pchar)"Error patching function at 0x%08lX, GetLastError() -> %ld",Thunk,GetLastError()); OutputDebugString((Pchar)tmp); }
            }
          else if (F1 == CreateFileWAddr)      { OrigCreateFileW       = (TCreateFileW)F;      NewAddr = (DWORD)MyCreateFileW;       goto L_PatchFunc; }
          else if (F1 == GetProcAddressAddr)   { OrigGetProcAddress    = (TGetProcAddress)F;   NewAddr = (DWORD)MyGetProcAddress;    goto L_PatchFunc; }
          else if (F1 == _lcreatAddr)          { Orig_lcreat           = (T_lcreat)F;          NewAddr = (DWORD)My_lcreat;           goto L_PatchFunc; }
          else if (F1 == _lopenAddr)           { Orig_lopen            = (T_lopen)F;           NewAddr = (DWORD)My_lopen;            goto L_PatchFunc; }
          else if (F1 == OpenFileAddr)         { OrigOpenFile          = (TOpenFile)F;         NewAddr = (DWORD)MyOpenFile;          goto L_PatchFunc; }
          else if (F1 == DeleteFileAAddr)      { OrigDeleteFileA       = (TDeleteFileA)F;      NewAddr = (DWORD)MyDeleteFileA;       goto L_PatchFunc; }
          else if (F1 == DeleteFileWAddr)      { OrigDeleteFileW       = (TDeleteFileW)F;      NewAddr = (DWORD)MyDeleteFileW;       goto L_PatchFunc; }
          else if (F1 == MoveFileAAddr)        { OrigMoveFileA         = (TMoveFileA)F;        NewAddr = (DWORD)MyMoveFileA;         goto L_PatchFunc; }
          else if (F1 == MoveFileWAddr)        { OrigMoveFileW         = (TMoveFileW)F;        NewAddr = (DWORD)MyMoveFileW;         goto L_PatchFunc; }
          else if (F1 == MoveFileExAAddr)      { OrigMoveFileExA       = (TMoveFileExA)F;      NewAddr = (DWORD)MyMoveFileExA;       goto L_PatchFunc; }
          else if (F1 == MoveFileExWAddr)      { OrigMoveFileExW       = (TMoveFileExW)F;      NewAddr = (DWORD)MyMoveFileExW;       goto L_PatchFunc; }
          else if (F1 == CopyFileAAddr)        { OrigCopyFileA         = (TCopyFileA)F;        NewAddr = (DWORD)MyCopyFileA;         goto L_PatchFunc; }
          else if (F1 == CopyFileWAddr)        { OrigCopyFileW         = (TCopyFileW)F;        NewAddr = (DWORD)MyCopyFileW;         goto L_PatchFunc; }
          else if (F1 == CopyFileExAAddr)      { OrigCopyFileExA       = (TCopyFileExA)F;      NewAddr = (DWORD)MyCopyFileExA;       goto L_PatchFunc; }
          else if (F1 == CopyFileExWAddr)      { OrigCopyFileExW       = (TCopyFileExW)F;      NewAddr = (DWORD)MyCopyFileExW;       goto L_PatchFunc; }
          else if (F1 == LZOpenFileAAddr)      { OrigLZOpenFileA       = (TLZOpenFileA)F;      NewAddr = (DWORD)MyLZOpenFileA;       goto L_PatchFunc; }
          else if (F1 == LZOpenFileWAddr)      { OrigLZOpenFileW       = (TLZOpenFileW)F;      NewAddr = (DWORD)MyLZOpenFileW;       goto L_PatchFunc; }
          else if (F1 == CreateDirectoryAAddr) { OrigCreateDirectoryA  = (TCreateDirectoryA)F; NewAddr = (DWORD)MyCreateDirectoryA;  goto L_PatchFunc; }
          else if (F1 == CreateDirectoryWAddr) { OrigCreateDirectoryW  = (TCreateDirectoryW)F; NewAddr = (DWORD)MyCreateDirectoryW;  goto L_PatchFunc; }
          else if (F1 == RemoveDirectoryAAddr) { OrigRemoveDirectoryA  = (TRemoveDirectoryA)F; NewAddr = (DWORD)MyRemoveDirectoryA;  goto L_PatchFunc; }
          else if (F1 == RemoveDirectoryWAddr) { OrigRemoveDirectoryW  = (TRemoveDirectoryW)F; NewAddr = (DWORD)MyRemoveDirectoryW;  goto L_PatchFunc; }
          else if (F1 == CreateProcessAAddr)   { OrigCreateProcessA    = (TCreateProcessA)F;   NewAddr = (DWORD)MyCreateProcessA;    goto L_PatchFunc; }
          else if (F1 == CreateProcessWAddr)   { OrigCreateProcessW    = (TCreateProcessW)F;   NewAddr = (DWORD)MyCreateProcessW;    goto L_PatchFunc; }
          else if (F1 == WinExecAddr)          { OrigWinExec           = (TWinExec)F;          NewAddr = (DWORD)MyWinExec;           goto L_PatchFunc; }
          else if (F1 == RegCreateKeyExAAddr)  { OrigRegCreateKeyExA   = (TRegCreateKeyExA)F;  NewAddr = (DWORD)MyRegCreateKeyExA;   goto L_PatchFunc; }
          else if (F1 == RegCreateKeyExWAddr)  { OrigRegCreateKeyExW   = (TRegCreateKeyExW)F;  NewAddr = (DWORD)MyRegCreateKeyExW;   goto L_PatchFunc; }
          else if (F1 == RegOpenKeyExAAddr)    { OrigRegOpenKeyExA     = (TRegOpenKeyExA)F;    NewAddr = (DWORD)MyRegOpenKeyExA;     goto L_PatchFunc; }
          else if (F1 == RegOpenKeyExWAddr)    { OrigRegOpenKeyExW     = (TRegOpenKeyExW)F;    NewAddr = (DWORD)MyRegOpenKeyExW;     goto L_PatchFunc; }
          else if (F1 == RegQueryValueExAAddr) { OrigRegQueryValueExA  = (TRegQueryValueExA)F; NewAddr = (DWORD)MyRegQueryValueExA;  goto L_PatchFunc; }
          else if (F1 == RegQueryValueExWAddr) { OrigRegQueryValueExW  = (TRegQueryValueExW)F; NewAddr = (DWORD)MyRegQueryValueExW;  goto L_PatchFunc; }
          else if (F1 == connectAddr)          { Origconnect           = (Tconnect)F;          NewAddr = (DWORD)Myconnect;           goto L_PatchFunc; }
          else if (F1 == VerInstallFileAAddr)  { OrigVerInstallFileA   = (TVerInstallFileA)F;  NewAddr = (DWORD)MyVerInstallFileA;   goto L_PatchFunc; }
          else if (F1 == VerInstallFileWAddr)  { OrigVerInstallFileW   = (TVerInstallFileW)F;  NewAddr = (DWORD)MyVerInstallFileW;   goto L_PatchFunc; }
        }
    }
  if (RestoreProtection)
    {
      DWORD Dummy;
      VirtualProtect(FuncTab,FuncTabSize,OldProtection,&Dummy);
    }
  *ErrorCode = iwh_Ok;
  return True;
}

#if defined(__BORLANDC__)
extern "C" LongWord _export _cdecl Init(LongWord Action,Pointer Param)
#else
extern "C" __declspec(dllexport) LongWord _cdecl _Init(LongWord Action,Pointer Param)
#endif
{
  LongWord Result = False;
  switch(Action)
    {
      case iwa_SetProcessId:
        IWatchProcessId = (DWORD)Param;
        Result = True;
        break;

      case iwa_SetDllBase:
        {
          IWatchExtensionDllInstance = (HINSTANCE)Param;
          DisableThreadLibraryCalls((HINSTANCE)Param);
          IsWin95 = (Boolean)((GetVersion() & 0xC0000000) == 0xC0000000);
          WatchSema = CreateSemaphore(NULL,1,1,NULL);
          if (!WatchSema) OutputDebugString("Cannot create sempahore!");
          Char tmp[80];
          wsprintf((Pchar)tmp,(Pchar)"IWatchSharedMem-%08lX",IWatchProcessId);
          if (SharedMemMapping = CreateFileMapping((HANDLE)0xFFFFFFFF,NULL,PAGE_READWRITE,0,32768,(Pchar)tmp))
            {
              SharedMem = MapViewOfFile(SharedMemMapping,FILE_MAP_WRITE,0,0,0);
              if (!SharedMem) OutputDebugString("Cannot create shared memory!");
            }
          else
            OutputDebugString("Cannot create file mapping!");

          wsprintf((Pchar)tmp,(Pchar)"IWatchEvent-%08lX",IWatchProcessId);
          if (WatchEvent = OpenEvent(EVENT_ALL_ACCESS,FALSE,(Pchar)tmp))
            {
              if (!WatchEvent) OutputDebugString("Cannot open event 1!");
            }
          wsprintf((Pchar)tmp,(Pchar)"IWatchEventR-%08lX",IWatchProcessId);
          if (WatchEventR = OpenEvent(EVENT_ALL_ACCESS,FALSE,(Pchar)tmp))
            {
              if (!WatchEventR) OutputDebugString("Cannot open event 2!");
            }
          SYSTEM_INFO SI;
          GetSystemInfo(&SI);
          LongWord StackSize = 2 * SI.dwPageSize;
          Pointer p = VirtualAlloc(NULL,StackSize,MEM_COMMIT,PAGE_READWRITE);
          Result = (LongWord)p + StackSize - 16;
          break;
        }

      case iwa_PatchFunctions:
        {
          if (!Param) Param = GetModuleHandle(NULL);
          THookErrorCode ErrorCode;
          Result = HookFunctions(Param,&ErrorCode);
          break;
        }
    }
  return Result;
}

//

Boolean LibraryProcessAttach(HINSTANCE /*Instance*/)
{
  InitHeap(128);
  return True;
}

Boolean LibraryProcessDetach(HINSTANCE /*Instance*/)
{
  if (WatchSema)        CloseHandle(WatchSema);        WatchSema        = 0;
  if (SharedMemMapping) CloseHandle(SharedMemMapping); SharedMemMapping = 0;
  if (SharedMem)        UnmapViewOfFile(SharedMem);    SharedMem        = NULL;
  if (WatchEvent)       CloseHandle(WatchEvent);       WatchEvent       = 0;
  if (WatchEventR)      CloseHandle(WatchEventR);      WatchEventR      = 0;
  DoneHeap();
  return True;
}

Boolean LibraryThreadAttach(HINSTANCE /*Instance*/)
{
  return True;
}

Boolean LibraryThreadDetach(HINSTANCE /*Instance*/)
{
  return True;
}

extern "C" BOOL WINAPI _startup/*DllEntryPoint*/(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID /*lpvReserved*/)
{
  switch(fdwReason)
    {
      case DLL_PROCESS_ATTACH: return (BOOL)LibraryProcessAttach(hinstDLL);
      case DLL_PROCESS_DETACH: return (BOOL)LibraryProcessDetach(hinstDLL);
      case DLL_THREAD_ATTACH:  return (BOOL)LibraryThreadAttach(hinstDLL);
      case DLL_THREAD_DETACH:  return (BOOL)LibraryThreadDetach(hinstDLL);
    }
  return FALSE;
}

