// Installationsberwachung fr Windows 95/NT
// iwatch.cpp
// 1998 by c't / Matthias Withopf

#if defined(__BORLANDC__)
#pragma option -a4  // DWORD-Alignment. Wichtig, sonst schlgt GetThreadContext feht, wenn Context-Struktur nicht korrekt aligned ist.
#endif

#if defined(_MSC_VER)
#pragma auto_inline(off)
#pragma optimize("s",on)
#endif

#include "iwatchsu.h"
#include "iwatchex.h"
#include <commdlg.h>

HINSTANCE AppInstance = 0;
Boolean   IsWin95 = False;

void Alert(PChar s)
{
  MessageBox((HWND)0,(Pchar)s,"IWatch",MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
}

// Ampel

#define TrafficLightClassName  "__TRL__"

#define TLM_SETSTATE    (WM_USER + 1)

LRESULT CALLBACK TrafficLightWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
  switch(message)
    {
      case WM_CREATE:
        {
          HBITMAP B = LoadBitmap(AppInstance,MAKEINTRESOURCE(1000));
          SetWindowLong(hwnd,4,(LONG)B);
          B = LoadBitmap(AppInstance,MAKEINTRESOURCE(1001));
          SetWindowLong(hwnd,8,(LONG)B);
        }
        break;

      case WM_DESTROY:
        {
          HBITMAP B = (HBITMAP)GetWindowLong(hwnd,4); if (B) DeleteObject(B);
          B = (HBITMAP)GetWindowLong(hwnd,8); if (B) DeleteObject(B);
        }
        break;

      case WM_PAINT:
        {
          PAINTSTRUCT ps;
          HDC hdc = BeginPaint(hwnd,&ps);
          HBITMAP B = (HBITMAP)GetWindowLong(hwnd,GetWindowLong(hwnd,0) ? 4 : 8);
          if (B)
            {
              BITMAP bm; GetObject(B,sizeof(BITMAP),&bm);
              HDC     MemDC  = CreateCompatibleDC(hdc);
              HBITMAP BmpOld = (HBITMAP)SelectObject(MemDC,B);
              BitBlt(hdc,0,0,bm.bmWidth,bm.bmHeight,MemDC,0,0,SRCCOPY);
              SelectObject(MemDC,BmpOld);
              DeleteDC(MemDC);
            }
          EndPaint(hwnd,&ps);
        }
        break;

      case TLM_SETSTATE:
        SetWindowLong(hwnd,0,wParam);
        break;

      default:
        return DefWindowProc(hwnd,message,wParam,lParam);
    }
  return 0;
}

void Register_TrafficLight(HINSTANCE Instance)
{
  WNDCLASS C = {CS_HREDRAW | CS_VREDRAW,TrafficLightWndProc,0,2 * sizeof(HBITMAP) + sizeof(LongWord),Instance,0,
                LoadCursor(0,IDC_ARROW),(HBRUSH)(COLOR_BACKGROUND + 1),NULL,TrafficLightClassName};
  RegisterClass(&C);
}

//

typedef struct
  {
    TWatchLevel wr_WatchLevel;
    TWatchLevel wr_ThisLevel;
    Boolean     wr_IgnorePossible;
    Boolean     wr_ChangeArg;
    PBoolean    wr_ArgChanged;
    PChar       wr_Title;
    PChar       wr_Action;
    PChar       wr_Arg;
    int         wr_ArgSize;
    PChar       wr_FuncCall;
    HANDLE      wr_BoldFont;
  } TWatchRec,* PWatchRec;

void CenterDialog(HWND hdlg)
{
  RECT R; GetWindowRect(hdlg,&R);
  OffsetRect(&R,-R.left,-R.top);
  int X = ((GetSystemMetrics(SM_CXSCREEN) - R.right ) / 2 + 4) & ~7;
  int Y =  (GetSystemMetrics(SM_CYSCREEN) - R.bottom) / 2;
  if (X < 0) X = 0;
  if (Y < 0) Y = 0;
  MoveWindow(hdlg,X,Y,R.right,R.bottom,FALSE);
}

BOOL CALLBACK WatchDlgProc(HWND hdlg,UINT wMsg,WPARAM wParam,LPARAM lParam)
{
  PWatchRec WR;
  switch(wMsg)
    {
      case WM_INITDIALOG:
        if (WR = (PWatchRec)lParam)
          {
            SetActiveWindow(hdlg);
            SetWindowPos(hdlg,HWND_TOPMOST,0,0,0,0,SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE | SWP_NOREDRAW);
            CenterDialog(hdlg);
            SetWindowLong(hdlg,DWL_USER,(LONG)WR);
            if (WR->wr_Title)      SetDlgItemText(hdlg,100,(Pchar)WR->wr_Title);
            if (WR->wr_Action)     SetDlgItemText(hdlg,101,(Pchar)WR->wr_Action);
            if (WR->wr_BoldFont)   SendDlgItemMessage(hdlg,101,WM_SETFONT,(WPARAM)WR->wr_BoldFont,0);
            if (WR->wr_Arg)        SetDlgItemText(hdlg,102,(Pchar)WR->wr_Arg);
            if (!WR->wr_ChangeArg) SendDlgItemMessage(hdlg,102,EM_SETREADONLY,TRUE,0);
            if (WR->wr_FuncCall)   SetDlgItemText(hdlg,103,(Pchar)WR->wr_FuncCall);
            SendDlgItemMessage(hdlg,200,TLM_SETSTATE,(WPARAM)(WR->wr_ThisLevel >= wl_VeryImportant),0);
            if (!WR->wr_IgnorePossible) EnableWindow(GetDlgItem(hdlg,3),FALSE);
            SendDlgItemMessage(hdlg,300,CB_ADDSTRING,0,(LPARAM)"1: Alles");
            SendDlgItemMessage(hdlg,300,CB_ADDSTRING,0,(LPARAM)"2: Keine Info");
            SendDlgItemMessage(hdlg,300,CB_ADDSTRING,0,(LPARAM)"3: Wichtiges");
            SendDlgItemMessage(hdlg,300,CB_ADDSTRING,0,(LPARAM)"4: Sehr wichtiges");
            SendDlgItemMessage(hdlg,300,CB_ADDSTRING,0,(LPARAM)"5: Keine Anzeige");
            SendDlgItemMessage(hdlg,300,CB_SETCURSEL,(WPARAM)(WR->wr_WatchLevel - 1),0);
            SetFocus(GetDlgItem(hdlg,/*WR->wr_Dangerous ? 2 : */1));
          }
        return FALSE;

      case WM_COMMAND:
        {
          WR = (PWatchRec)GetWindowLong(hdlg,DWL_USER);
          switch(LOWORD(wParam))
            {
              case 1: // Ausfhren
                if (WR)
                  {
                    if (SendDlgItemMessage(hdlg,102,EM_GETMODIFY,0,0))
                      if (WR->wr_ArgChanged && WR->wr_ChangeArg)
                        {
                          *WR->wr_ArgChanged = True;
                          SendDlgItemMessage(hdlg,102,WM_GETTEXT,(WPARAM)WR->wr_ArgSize,(LPARAM)WR->wr_Arg);
                        }
                    WR->wr_WatchLevel = (TWatchLevel)(SendDlgItemMessage(hdlg,300,CB_GETCURSEL,0,0) + 1);
                  }
                EndDialog(hdlg,wa_Yes);
                return TRUE;

              case 2: // Verhindern
                if (WR) WR->wr_WatchLevel = (TWatchLevel)(SendDlgItemMessage(hdlg,300,CB_GETCURSEL,0,0) + 1);
                EndDialog(hdlg,wa_No);
                return TRUE;

              case 3: // Ignorieren
                if (WR) WR->wr_WatchLevel = (TWatchLevel)(SendDlgItemMessage(hdlg,300,CB_GETCURSEL,0,0) + 1);
                EndDialog(hdlg,wa_Ignore);
                return TRUE;
            }
        }
        break;

      case WM_CLOSE:
        EndDialog(hdlg,wa_No);
        return TRUE;
    }
  return FALSE;
}

Boolean GetDLLName(HANDLE hProcess,HANDLE hFile,LongWord BaseOfDll,Pointer ThreadLocalBase,PChar DllName,int DllNameSize,PLongWord EntryPoint)
{
  const int EntryPointOfs          = 0x28;
  const int ImageBaseOfs           = 0x34;
  const int ImageSecondHeaderOfs   = 0x3C;
  const int ImageExportTableRVAOfs = 0x78;
  if (!DllNameSize) return False;
  DllName[0] = '\0';
  if (EntryPoint) *EntryPoint = 0;
  Boolean NameOk = False;

  // Bestimme voll qualifizierten DLL-Namen; undokumentierte Methode, von SDK-Tools abgeschaut
  if (!IsWin95 && ThreadLocalBase)
    {
      DWORD   Result;
      Pointer DLLNamePtr;
      if (ReadProcessMemory(hProcess,(PByte)ThreadLocalBase + 0x14,&DLLNamePtr,sizeof DLLNamePtr,&Result) && (Result == sizeof DLLNamePtr))
        if (DLLNamePtr)
          {
            Word tmp[256];
            if (ReadProcessMemory(hProcess,DLLNamePtr,tmp,sizeof tmp,&Result) && (Result > 0))
              {
                PWord p1 = tmp;
                PChar p2 = DllName;
                while (*p1 && (DllNameSize-- > 0))
                  *p2++ = (Char)*p1++;
                *p2 = '\0';
                NameOk = True;
              }
          }
    }
  if (!hFile) return False;
  if (GetFileType(hFile) != FILE_TYPE_DISK) return False;
  if (SetFilePointer(hFile,0L,NULL,FILE_BEGIN) != 0) return False;
  WORD  DosSignature;
  DWORD dwNumberOfBytesRead = 0;
  if (!ReadFile(hFile,&DosSignature,sizeof DosSignature,&dwNumberOfBytesRead,NULL)) return False;
  if (DosSignature != IMAGE_DOS_SIGNATURE) return False;
  if (SetFilePointer(hFile,ImageSecondHeaderOfs,NULL,FILE_BEGIN) != ImageSecondHeaderOfs) return False;
  DWORD PeHeader;
  if (!ReadFile(hFile,&PeHeader,sizeof PeHeader,&dwNumberOfBytesRead,NULL)) return False;
  if (SetFilePointer(hFile,PeHeader,NULL,FILE_BEGIN) != PeHeader) return False;
  DWORD NtSignature;
  if (!ReadFile(hFile,&NtSignature,sizeof NtSignature,&dwNumberOfBytesRead,NULL)) return False;
  if (NtSignature != IMAGE_NT_SIGNATURE) return False;
  if (EntryPoint)
    {
      if (SetFilePointer(hFile,PeHeader + EntryPointOfs,NULL,FILE_BEGIN) != PeHeader + EntryPointOfs) return False;
      if (!ReadFile(hFile,EntryPoint,sizeof *EntryPoint,&dwNumberOfBytesRead,NULL)) return False;
      if (*EntryPoint) *EntryPoint += (LongWord)BaseOfDll;
    }
  if (NameOk) return True;
  if (SetFilePointer(hFile,PeHeader + ImageBaseOfs,NULL,FILE_BEGIN) != PeHeader + ImageBaseOfs) return False;
  DWORD ImageBase;
  if (!ReadFile(hFile,&ImageBase,sizeof(ImageBase),&dwNumberOfBytesRead,NULL)) return False;
  if (SetFilePointer(hFile,PeHeader + ImageExportTableRVAOfs,NULL,FILE_BEGIN) != PeHeader + ImageExportTableRVAOfs) return False;
  IMAGE_DATA_DIRECTORY ExportTable;
  if (!ReadFile(hFile,&ExportTable,sizeof ExportTable,&dwNumberOfBytesRead,NULL)) return False;
  if (ExportTable.VirtualAddress && ExportTable.Size)
    {
      PByte ET = new Byte[ExportTable.Size];
      if (!ET) return False;
      if (!ReadProcessMemory(hProcess,(LPVOID)(BaseOfDll + ExportTable.VirtualAddress),ET,ExportTable.Size,&dwNumberOfBytesRead)) return False;
      IMAGE_EXPORT_DIRECTORY *E = (IMAGE_EXPORT_DIRECTORY *)ET;
      StrCopy(DllName,ET + E->Name - ExportTable.VirtualAddress,DllNameSize);
      if (ET) delete [] ET;
    }
  else
    StrCopy(DllName,(PChar)"???",DllNameSize);
  return True;
}

////////////////////////////////////////////////////////////////////////////////

#if defined(CPU_INTEL)
typedef Byte     TBreakpointType;
TBreakpointType  BreakpointInstr = 0xcc;         // INT 3
#elif defined(CPU_ALPHA)
typedef LongWord TBreakpointType;
TBreakpointType  BreakpointInstr = 0x00000080;   // CALLPAL BPT
#endif

typedef struct
  {
    LongWord de_BaseAddr;
    LongWord de_EntryAddr;
    Boolean  de_Patched;
  } TDllEntry,* PDllEntry;

typedef struct
  {
    DWORD  te_ThreadId;
    HANDLE te_ThreadHandle;
  } TThreadEntry,* PThreadEntry;

typedef struct
  {
    Pointer         dse_CodeStart;
    CONTEXT         dse_Context;
    TBreakpointType dse_EntryCode;
  } TDllStartEntry;

class TProcessWatcher
  {
  public:
    TProcessWatcher(TWatchLevel AWatchLevel,Boolean AVerbose,Boolean ADebug,Boolean ASkipAllDlls,Boolean ASkipDynDlls,PChar *SkipDlls,int SkipDllsCount,PChar AExtensionDllName,PChar InstDir,PChar LogName);
    ~TProcessWatcher();
    Boolean Run(PChar CmdLine,int *ReturnCode);
    Boolean Run(LongWord ProcessId,int *ReturnCode);
  private:
    Boolean                   Verbose;
    Boolean                   Debug;
    Boolean                   SkipAllDlls;
    Boolean                   SkipDynDlls;
    PChar                    *SkipDlls;
    int                       SkipDllsCount;
    PChar                     ExtensionDllName;
    LongWord                  ExtensionDllBase;
    LongWord                  ExtensionDllInitFunc;
    LongWord                  ExtensionStack;
    STARTUPINFO               StartupInfo;
    PROCESS_INFORMATION       ProcessInfo;
    CREATE_PROCESS_DEBUG_INFO ProcessDebugInfo;
    typedef enum
      {
        ps_Unknown,
        ps_FirstBreak,
        ps_PatchProcess,
        ps_PatchStaticDlls,
        ps_ProcessComplete,
        ps_PatchDynamicDll,
        ps_PatchDynamicDllNoInit,
      } TProcessState;
    TProcessState             ProcessState;
    Boolean                   ProcessPatchedDone;
    CONTEXT                   Context1;
    enum { CodeFragmentSize = 512 };
    BYTE                      OrigCodeFragment[CodeFragmentSize],MyCodeFragment[CodeFragmentSize];
    DWORD                     NewCodeSize;
    TBreakpointType           OrigCodeStart;
    Pointer                   CodeFragmentAddr;
    enum { MaxNestedDllCount = 32 };
    TDllStartEntry            DllEntryTab[MaxNestedDllCount];
    Pointer                   LastDllEntryBreakAddr;
    enum { MaxDllCount = 256 };
    TDllEntry                 DllTab[MaxDllCount];
    enum { MaxThreadCount = 1024 };
    TThreadEntry              ThreadTab[MaxThreadCount];
    HANDLE                    SharedMemMapping;
    Pointer                   SharedMem;
    HANDLE                    WatchEvent;
    HANDLE                    WatchEventR;
    HANDLE                    WatchThread;
    TWatchLevel               WatchLevel;
    Boolean                   Attached;
    PChar                     InstDir;
    HANDLE                    LogFile;
    HFONT                     BoldFont;
    Boolean SetStartBreak(void);
    Boolean PatchProcess(void);
    Boolean PatchDll(LongWord DllBaseAddr,HANDLE ThreadHandle);
    Boolean ProcessPatched(void);
    Boolean RestoreProcess(Boolean f,HANDLE ThreadHandle,Boolean ResetContext);
    Boolean AddDll(LongWord BaseAddr,LongWord EntryAddr);
    Boolean RemoveDll(LongWord BaseAddr);
    Boolean PatchDlls(HANDLE ThreadHandle,Boolean ASuspendThreads,Pointer DllEntryAddr);
    Boolean AddThread(DWORD ThreadId,HANDLE ThreadHandle);
    Boolean RemoveThread(DWORD ThreadId);
    void    SuspendThreads(HANDLE ThreadHandle);
    void    ResumeThreads(HANDLE ThreadHandle);
    HANDLE  ThreadId2Handle(DWORD ThreadId);
    DWORD   HandleDebugEvent(LPDEBUG_EVENT Event);
    friend LongWord __stdcall WatchThreadFunc(Pointer Param);
    int     WatchFuncCalls(void);
    Boolean PatchDllEntry(Pointer DllEntryPoint);
    Boolean RestoreDllEntry(HANDLE ThreadHandle,Pointer BreakAddr,PBoolean MoreBPs);
    Boolean IsDllEntryBreak(HANDLE ThreadHandle,Pointer BreakAddr);
  };
typedef TProcessWatcher * PProcessWatcher;

TWatchAction ShowDlgBox(Boolean InInstDir,PChar AppName,LongWord ThreadId,PWatchLevel WatchLevel,TWatchLevel ThisLevel,Boolean IgnorePossible,Boolean ChangeArg,PChar Action,PChar FuncCall,PChar Arg,int ArgSize,HANDLE LogFile,HANDLE BoldFont,PBoolean ArgChanged)
{
  if (LogFile)
    {
      DWORD R;
      WriteFile(LogFile,Action,StrLen(Action),&R,NULL);
      WriteFile(LogFile," ",1,&R,NULL);
      WriteFile(LogFile,FuncCall,StrLen(FuncCall),&R,NULL);
      WriteFile(LogFile,"\x0D\x0A",2,&R,NULL);
    }
  if (InInstDir && (ThisLevel <= wl_Important))
    ThisLevel = wl_Verbose;
  if (*WatchLevel > ThisLevel) return wa_Yes;
  Char tmp[256];
  wsprintf((Pchar)tmp,(Pchar)"Die Anwendung '%s', Thread 0x%lX versucht folgendes (Level %d):",AppName,ThreadId,ThisLevel);
  TWatchRec WR = {*WatchLevel,ThisLevel,IgnorePossible,ChangeArg,ArgChanged,tmp,Action,Arg,ArgSize,FuncCall,BoldFont};
  int R = DialogBoxParam(AppInstance,MAKEINTRESOURCE(100),(HWND)0,WatchDlgProc,(LPARAM)&WR);
  *WatchLevel = WR.wr_WatchLevel;
  if (R < 0)
    {
      { Char tmp[256]; wsprintf((Pchar)tmp,(Pchar)"DialogBoxParam() -> %d, GetLastError(): %d",R,GetLastError()); MessageBox((HWND)0,(Pchar)tmp,NULL,MB_OK | MB_ICONSTOP | MB_SETFOREGROUND); }
      return wa_Error;
    }
  return (TWatchAction)R;
}

int TProcessWatcher::WatchFuncCalls(void)
{
  if (WatchEvent && WatchEventR)
    for (;;)
      {
        WaitForSingleObject(WatchEvent,INFINITE);     // oder Programmende
        PByte p = (PByte)SharedMem;
        LongWord x;
        int l = sizeof x; MemCpy(&x,p,l); p += l;
        TWatchLevel ThisLevel = (TWatchLevel)x;
        l = sizeof x; MemCpy(&x,p,l); p += l;
        Boolean IgnorePossible = (Boolean)x;
        l = sizeof x; MemCpy(&x,p,l); p += l;
        Boolean ChangeArg = (Boolean)x;
        l = sizeof x; MemCpy(&x,p,l); p += l;
        LongWord ThreadId = x;
        PChar AppName   = p; p += StrLen(p) + 1;
        PChar ActionStr = p; p += StrLen(p) + 1;
        PChar FuncCall  = p; p += StrLen(p) + 1;
        PChar Arg       = p; //p += StrLen(p) + 1;
        Boolean ArgChanged = False;
        Boolean InInstDir  = False;
        if (InstDir[0] && Arg[0])
          {
            l = StrLen(InstDir);
            if (!StrNICmp(Arg,InstDir,l))
              InInstDir = True;
          }
        Char Arg1[512];
        StrCopy(Arg1,Arg,sizeof Arg1);
        TWatchAction Action = ShowDlgBox(InInstDir,AppName,ThreadId,&WatchLevel,ThisLevel,IgnorePossible,ChangeArg,ActionStr,FuncCall,Arg1,sizeof Arg1,LogFile,BoldFont,&ArgChanged);
        p = (PByte)SharedMem;
        x = (LongWord)Action;
        l = sizeof x; MemCpy(p,&x,l); p += l;
        if (ArgChanged)
          {
            l = StrLen(Arg1) + 1;
            MemCpy(p,Arg1,l);
          }
        else
          {
            //l = 1;
            *p = '\0';
          }
        //p += l;
        ResetEvent(WatchEvent);
        SetEvent(WatchEventR);
      }
  return 0;
}

DWORD __stdcall WatchThreadFunc(Pointer Param)
{
  PProcessWatcher This = (PProcessWatcher)Param;
  return (DWORD)This->WatchFuncCalls();
}

TProcessWatcher::TProcessWatcher(TWatchLevel AWatchLevel,Boolean AVerbose,Boolean ADebug,Boolean ASkipAllDlls,Boolean ASkipDynDlls,PChar ASkipDlls[],int ASkipDllsCount,PChar AExtensionDllName,PChar AInstDir,PChar LogName)
{
  Verbose              = AVerbose;
  Debug                = ADebug;
  SkipAllDlls          = ASkipAllDlls;
  SkipDynDlls          = ASkipDynDlls;
  SkipDlls             = ASkipDlls;
  SkipDllsCount        = ASkipDllsCount;
  ExtensionDllName     = AExtensionDllName;
  ExtensionDllBase     = 0;
  ExtensionDllInitFunc = 0;
  ExtensionStack       = 0;
  MemSet(&StartupInfo,0,sizeof StartupInfo);
  StartupInfo.cb = sizeof StartupInfo;
  MemSet(&ProcessInfo,0,sizeof ProcessInfo);
  MemSet(&ProcessDebugInfo,0,sizeof ProcessDebugInfo);
  ProcessState         = ps_FirstBreak;
  ProcessPatchedDone   = False;
  NewCodeSize          = 0;
  MemSet(DllEntryTab,0,sizeof DllEntryTab);
  LastDllEntryBreakAddr = NULL;
  MemSet(DllTab,0,sizeof DllTab);
  MemSet(ThreadTab,0,sizeof ThreadTab);
  SharedMemMapping     = 0;
  SharedMem            = NULL;
  WatchEvent           = 0;
  WatchEventR          = 0;
  WatchLevel           = AWatchLevel;
  Attached             = False;
  InstDir              = AInstDir;
  LogFile              = 0;
  BoldFont             = 0;
  Char tmp[80];
  wsprintf((Pchar)tmp,(Pchar)"IWatchSharedMem-%08lX",GetCurrentProcessId());
  if (SharedMemMapping = CreateFileMapping((HANDLE)0xFFFFFFFF,NULL,PAGE_READWRITE,0,32768,(Pchar)tmp))
    {
      if (!(SharedMem = MapViewOfFile(SharedMemMapping,FILE_MAP_WRITE,0,0,0)))
        Write((PChar)"Cannot create shared memory!\n");
    }
  else
    Write((PChar)"Cannot create file mapping!\n");
  wsprintf((Pchar)tmp,(Pchar)"IWatchEvent-%08lX",GetCurrentProcessId());
  if (!(WatchEvent = CreateEvent(NULL,TRUE,FALSE,(Pchar)tmp)))
    Write((PChar)"Cannot create watch event 1!\n");
  wsprintf((Pchar)tmp,(Pchar)"IWatchEventR-%08lX",GetCurrentProcessId());
  if (!(WatchEventR = CreateEvent(NULL,TRUE,FALSE,(Pchar)tmp)))
    Write((PChar)"Cannot create watch event 2!\n");
  DWORD ThreadId;   // wird nicht benutzt, NULL als Argument geht aber nur bei NT, nicht aber Win95!
  WatchThread = CreateThread(NULL,8192,WatchThreadFunc,this,0,&ThreadId);
  if (!WatchThread) { Char tmp[80]; wsprintf((Pchar)tmp,(Pchar)"Cannot create watch thread, error code=%ld!\n",GetLastError()); Write(tmp); }
  Register_TrafficLight(AppInstance);
  {
    HDC hdc = GetDC(0);
    int Height = MulDiv(10,GetDeviceCaps(hdc,LOGPIXELSY),72);
    BoldFont = CreateFont(-Height,0,0,0,FW_BOLD,0,0,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH | FF_SWISS,"Arial");
    ReleaseDC(0,hdc);
  }
  if (LogName && LogName[0])
    {
      LogFile = CreateFile((Pchar)LogName,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);
      if (LogFile == INVALID_HANDLE_VALUE) LogFile = 0;
    }
}

TProcessWatcher::~TProcessWatcher()
{
  if (SharedMemMapping) CloseHandle(SharedMemMapping); SharedMemMapping = 0;
  if (SharedMem)        UnmapViewOfFile(SharedMem);    SharedMem        = NULL;
  if (WatchEvent)       CloseHandle(WatchEvent);       WatchEvent       = 0;
  if (WatchEventR)      CloseHandle(WatchEventR);      WatchEventR      = 0;
  if (BoldFont)         DeleteObject(BoldFont);        BoldFont         = 0;
  if (LogFile)          CloseHandle(LogFile);          LogFile          = 0;
}

Boolean TProcessWatcher::SetStartBreak(void)
{
  const int EntryPointOfs        = 0x28;
  const int ImageSecondHeaderOfs = 0x3C;
  CodeFragmentAddr = ProcessDebugInfo.lpStartAddress;
  if (!CodeFragmentAddr)
    {
      // Process wurde attached.
      PByte    ProcessBase = (PByte)ProcessDebugInfo.lpBaseOfImage;
      DWORD    Result;
      LongWord PEOfs;
      BOOL f = ReadProcessMemory(ProcessInfo.hProcess,ProcessBase + ImageSecondHeaderOfs,&PEOfs,sizeof PEOfs,&Result);
      if (!f || (Result != sizeof PEOfs)) return False;
      LongWord EntryRVA;
      f = ReadProcessMemory(ProcessInfo.hProcess,ProcessBase + PEOfs + EntryPointOfs,&EntryRVA,sizeof EntryRVA,&Result);
      if (!f || (Result != sizeof EntryRVA)) return False;
      ProcessDebugInfo.lpStartAddress = (LPTHREAD_START_ROUTINE)(ProcessBase + EntryRVA);
      CodeFragmentAddr = ProcessDebugInfo.lpStartAddress;
      if (!CodeFragmentAddr) return False;
    }

  // originales Code-Fragment sichern
  DWORD Result;
  BOOL f = ReadProcessMemory(ProcessInfo.hProcess,CodeFragmentAddr,&OrigCodeStart,sizeof OrigCodeStart,&Result);
  if (!f || (Result != sizeof OrigCodeStart)) return False;
  if (!Attached)
    {
      // neues Code-Fragment in laufenden Proze patchen
      f = WriteProcessMemory(ProcessInfo.hProcess,CodeFragmentAddr,&BreakpointInstr,sizeof BreakpointInstr,&Result);
      if (!f || (Result != sizeof BreakpointInstr)) { Write((PChar)"Couldn't patch!!!\n"); return False; }
      FlushInstructionCache(ProcessInfo.hProcess,CodeFragmentAddr,sizeof BreakpointInstr);
    }
  return True;
}

Boolean TProcessWatcher::PatchProcess(void)
{
  HMODULE KernelModule = GetModuleHandle("KERNEL32.DLL");
  if (!KernelModule) return False;
  FARPROC LoadLibraryProc = GetProcAddress(KernelModule,"LoadLibraryA");
  if (!LoadLibraryProc) return False;
  FARPROC GetLastErrorProc = GetProcAddress(KernelModule,"GetLastError");
  if (!GetLastErrorProc) return False;
  FARPROC GetProcAddressProc = GetProcAddress(KernelModule,"GetProcAddress");
  if (!GetProcAddressProc) return False;
  CodeFragmentAddr = ProcessDebugInfo.lpStartAddress;
  if (!CodeFragmentAddr) return False;

  Context1.ContextFlags = CONTEXT_FULL;
  if (!GetThreadContext(ProcessInfo.hThread,&Context1)) return False;

  // originales Code-Fragment sichern
  DWORD Result;
  BOOL f = ReadProcessMemory(ProcessInfo.hProcess,CodeFragmentAddr,OrigCodeFragment,sizeof OrigCodeFragment,&Result);
  if (!f || (Result != sizeof OrigCodeFragment)) return False;
  MemCpy(OrigCodeFragment,&OrigCodeStart,sizeof OrigCodeStart);

  // neues Code-Fragment in laufenden Proze patchen
  PBYTE p = (PBYTE)MyCodeFragment;
#if defined(CPU_INTEL)
  *((BYTE  * &)p)++ =  0x68;          // PUSH L_DllName       ; Zeiger auf DLL-Dateinamen
  *((DWORD * &)p)++ = (DWORD)CodeFragmentAddr + 0x57;
  *((BYTE  * &)p)++ =  0xE8;          // CALL LoadLibraryA
  *((DWORD * &)p)++ = (DWORD)LoadLibraryProc - (DWORD)CodeFragmentAddr - (int)(p - MyCodeFragment) - 4;
  *((BYTE  * &)p)++ =  0x09;          // OR   EAX,EAX         ; konnte DLL geladen werden ?
  *((BYTE  * &)p)++ =  0xC0;
  *((BYTE  * &)p)++ =  0x75;          // JNZ  L_Ok            ; ja -> EAX enthlt HMODULE
  *((BYTE  * &)p)++ =  0x08;
  *((BYTE  * &)p)++ =  0xE8;          // CALL GetLastError
  *((DWORD * &)p)++ = (DWORD)GetLastErrorProc - (DWORD)CodeFragmentAddr - (int)(p - MyCodeFragment) - 4;
  *((BYTE  * &)p)++ =  0xB3;          // MOV  BL,1            ; BL = 1 (Fehler beim Laden)
  *((BYTE  * &)p)++ =  0x01;
  *((BYTE  * &)p)++ =  0xCC;          // INT  3               ; Breakpoint
  *((BYTE  * &)p)++ =  0x8B;          // MOV  ESI,EAX         ; rette HMODULE in ESI
  *((BYTE  * &)p)++ =  0xF0;
  *((BYTE  * &)p)++ =  0x68;          // PUSH L_Init          ; Zeiger auf '_Init'
  *((DWORD * &)p)++ = (DWORD)CodeFragmentAddr + 0x51;
  *((BYTE  * &)p)++ =  0x56;          // PUSH ESI
  *((BYTE  * &)p)++ =  0xE8;          // CALL GetProcAddress
  *((DWORD * &)p)++ = (DWORD)GetProcAddressProc - (DWORD)CodeFragmentAddr - (int)(p - MyCodeFragment) - 4;
  *((BYTE  * &)p)++ =  0x09;          // OR   EAX,EAX         ; konnte Funktion gefunden werden ?
  *((BYTE  * &)p)++ =  0xC0;
  *((BYTE  * &)p)++ =  0x75;          // JNZ  L_Ok1           ; ja -> EAX enthlt Adresse
  *((BYTE  * &)p)++ =  0x03;
  *((BYTE  * &)p)++ =  0xB3;          // MOV  BL,2            ; BL = 2 (Fehler beim Ermitteln der Startfunktion)
  *((BYTE  * &)p)++ =  0x02;
  *((BYTE  * &)p)++ =  0xCC;          // INT  3               ; Breakpoint
  *((BYTE  * &)p)++ =  0x8B;          // MOV  EDI,EAX         ; rette Funktionsadresse
  *((BYTE  * &)p)++ =  0xF8;
  *((BYTE  * &)p)++ =  0x68;          // PUSH xxxxxxxx        ; bergebe Process-Id
  *((DWORD * &)p)++ =  GetCurrentProcessId();
  *((BYTE  * &)p)++ =  0x6A;          // PUSH iwa_SetProcessId; iwa_SetProcessId
  *((BYTE  * &)p)++ = (BYTE)iwa_SetProcessId;
  *((BYTE  * &)p)++ =  0xFF;          // CALL EDI             ; rufe Funktion auf
  *((BYTE  * &)p)++ =  0xD7;
  *((BYTE  * &)p)++ =  0x83;          // ADD  ESP,8
  *((BYTE  * &)p)++ =  0xC4;
  *((BYTE  * &)p)++ =  0x08;
  *((BYTE  * &)p)++ =  0x56;          // PUSH ESI             ; bergebe DLL-Basisadresse
  *((BYTE  * &)p)++ =  0x6A;          // PUSH 1               ; iwa_SetDllBase
  *((BYTE  * &)p)++ =  0x01;
  *((BYTE  * &)p)++ =  0xFF;          // CALL EDI             ; rufe Funktion auf
  *((BYTE  * &)p)++ =  0xD7;
  *((BYTE  * &)p)++ =  0x83;          // ADD  ESP,8
  *((BYTE  * &)p)++ =  0xC4;
  *((BYTE  * &)p)++ =  0x08;
  *((BYTE  * &)p)++ =  0x50;          // PUSH EAX             ; Zeiger auf eigenen Stackbereich retten
  *((BYTE  * &)p)++ =  0x68;          // PUSH xxxxxxxx        ; bergebe Module-Adresse
  *((DWORD * &)p)++ = (DWORD)0;
  *((BYTE  * &)p)++ =  0x6A;          // PUSH 2               ; iwa_PatchFunctions
  *((BYTE  * &)p)++ =  0x02;
  *((BYTE  * &)p)++ =  0xFF;          // CALL EDI             ; rufe Funktion auf
  *((BYTE  * &)p)++ =  0xD7;
  *((BYTE  * &)p)++ =  0x83;          // ADD  ESP,8
  *((BYTE  * &)p)++ =  0xC4;
  *((BYTE  * &)p)++ =  0x08;
  *((BYTE  * &)p)++ =  0x31;          // XOR  EBX,EBX         ; BL = 0 (Laden ok)
  *((BYTE  * &)p)++ =  0xDB;
  *((BYTE  * &)p)++ =  0x59;          // POP  ECX             ; Zeiger auf eigenen Stackbereich
  *((BYTE  * &)p)++ =  0xCC;          // INT  3               ; Breakpoint
#elif defined(CPU_ALPHA)
  LongWord InitFuncOfs = (LongWord)CodeFragmentAddr + 35 * sizeof(DWORD);
  LongWord DLLNameOfs  = InitFuncOfs + 6;
  LongWord LoadLibFunc = (LongWord)LoadLibraryProc;
  LongWord GetProcFunc = (LongWord)GetProcAddressProc;
  LongWord GetErrFunc  = (LongWord)GetLastErrorProc;
  LongWord ProcessId   = (LongWord)GetCurrentProcessId();
  *((DWORD * &)p)++ =  0x221F0000 | (Word)DLLNameOfs;                     // LDA     A0,xxxx(ZERO)     ; lese Zeiger auf DLL-Namen in A0
  *((DWORD * &)p)++ =  0x26100000 | (Word)((DLLNameOfs + 0x8000) >> 16);  // LDAH    A0,xxxx(A0)
  *((DWORD * &)p)++ =  0x201F0000 | (Word)LoadLibFunc;                    // LDA     V0,xxxx(ZERO)     ; lese Funktionsadresse von LoadLibraryA()
  *((DWORD * &)p)++ =  0x24000000 | (Word)((LoadLibFunc + 0x8000) >> 16); // LDAH    V0,xxxx(V0)
  *((DWORD * &)p)++ =  0x6B404000;                                        // JSR     RA,(V0),0         ; LoadLibraryA() aufrufen
  *((DWORD * &)p)++ =  0xF4000005;                                        // BNE     V0,L_Ok           ; falls ok -> weiter
  *((DWORD * &)p)++ =  0x201F0000 | (Word)GetErrFunc;                     // LDA     V0,xxxx(ZERO)     ; lese Funktionsadresse von GetLastError()
  *((DWORD * &)p)++ =  0x24000000 | (Word)((GetErrFunc + 0x8000) >> 16);  // LDAH    V0,xxxx(V0)
  *((DWORD * &)p)++ =  0x6B404000;                                        // JSR     RA,(V0),0         ; GetLastError() aufrufen
  *((DWORD * &)p)++ =  0x213F0001;                                        // MOV     1,S0              ; S0 = 1 (Fehler beim Laden)
  *((DWORD * &)p)++ =  0x00000080;                                        // CALLPAL BPT               ; Breakpoint
  *((DWORD * &)p)++ =  0x4400040A;                                        // MOV     V0,S1             ; rette HMODULE in S1
  *((DWORD * &)p)++ =  0x44000410;                                        // MOV     V0,A0             ; HMODULE als 1. Argument
  *((DWORD * &)p)++ =  0x223F0000 | (Word)InitFuncOfs;                    // LDA     A1,xxxx(ZERO)     ; lese Zeiger auf '_Init'
  *((DWORD * &)p)++ =  0x26310000 | (Word)((InitFuncOfs + 0x8000) >> 16); // LDAH    A1,xxxx(A1)       ; als 2. Argument
  *((DWORD * &)p)++ =  0x201F0000 | (Word)GetProcFunc;                    // LDA     V0,xxxx(ZERO)     ; lese Funktionsadresse von GetProcAddressProc()
  *((DWORD * &)p)++ =  0x24000000 | (Word)((GetProcFunc + 0x8000) >> 16); // LDAH    V0,xxxx(V0)
  *((DWORD * &)p)++ =  0x6B404000;                                        // JSR     RA,(V0),0         ; GetProcAddressProc() aufrufen
  *((DWORD * &)p)++ =  0xF4000002;                                        // BNE     V0,L_Ok1          ; falls ok -> weiter
  *((DWORD * &)p)++ =  0x213F0002;                                        // MOV     2,S0              ; S0 = 2 (Fehler beim Ermitteln der Startfunktion)
  *((DWORD * &)p)++ =  0x00000080;                                        // CALLPAL BPT               ; Breakpoint
  *((DWORD * &)p)++ =  0x4400040B;                                        // MOV     V0,S2             ; rette Funktionsadresse in S2
  *((DWORD * &)p)++ =  0x221F0000 | iwa_SetProcessId;                     // MOV     3,A0              ; iwa_SetProcessId als 1. Argument
  *((DWORD * &)p)++ =  0x223F0000 | (Word)ProcessId;                      // LDA     A1,xxxx(ZERO)     ; GetCurrentProcessId()
  *((DWORD * &)p)++ =  0x26310000 | (Word)((ProcessId + 0x8000) >> 16);   // LDAH    A1,xxxx(A1)       ; als 2. Argument
  *((DWORD * &)p)++ =  0x6B4B4000;                                        // JSR     RA,(S2),0         ; _Init() aufrufen
  *((DWORD * &)p)++ =  0x221F0000 | iwa_SetDllBase;                       // MOV     1,A0              ; iwa_SetDllBase als 1. Argument
  *((DWORD * &)p)++ =  0x454A0411;                                        // MOV     S1,A1             ; DLL-Basisadresse als 2. Argument
  *((DWORD * &)p)++ =  0x6B4B4000;                                        // JSR     RA,(S2),0         ; _Init() aufrufen
  *((DWORD * &)p)++ =  0x4400040C;                                        // MOV     V0,S3             ; rette Zeiger auf eigenen Stackbereich in S3
  *((DWORD * &)p)++ =  0x221F0000 | iwa_PatchFunctions;                   // MOV     2,A0              ; iwa_PatchFunctions als 1. Argument
  *((DWORD * &)p)++ =  0x223F0000;                                        // MOV     0,A1
  *((DWORD * &)p)++ =  0x6B4B4000;                                        // JSR     RA,(S2),0         ; _Init() aufrufen
  *((DWORD * &)p)++ =  0x213F0000;                                        // MOV     0,S0              ; S0 = 0 (Laden ok)
  *((DWORD * &)p)++ =  0x00000080;                                        // CALLPAL BPT               ; Breakpoint
#endif
  int l = StrLen((PChar)"_Init") + 1;
  MemCpy(p,"_Init",l);                // DB   "_Init",0
  p += l;
  l = StrLen(ExtensionDllName) + 1;
  MemCpy(p,ExtensionDllName,l);       // DB   "...",0         ; DLL-Name
  p += l;
  NewCodeSize = (DWORD)(p - MyCodeFragment);
  f = WriteProcessMemory(ProcessInfo.hProcess,CodeFragmentAddr,&MyCodeFragment,NewCodeSize,&Result);
  if (!f || (Result != NewCodeSize)) { Write((PChar)"Couldn't patch!!!\n"); return False; }
  FlushInstructionCache(ProcessInfo.hProcess,CodeFragmentAddr,NewCodeSize);
  CONTEXT Context2 = Context1;
#if defined(CPU_INTEL)
  Context2.Eip = (DWORD)CodeFragmentAddr;
#elif defined(CPU_ALPHA)
  Context2.Fir = (DWORDLONG)CodeFragmentAddr;
#endif
  if (!SetThreadContext(ProcessInfo.hThread,&Context2)) { Write((PChar)"SetThreadContext() failed!\n"); return False; }
  return True;
}

Boolean TProcessWatcher::PatchDll(LongWord DllBaseAddr,HANDLE ThreadHandle)
{
  // neues Code-Fragment in laufenden Proze patchen
  PBYTE p = (PBYTE)MyCodeFragment;
#if defined(CPU_INTEL)
  *((BYTE  * &)p)++ = 0x68;          // PUSH xxxxxxxx        ; bergebe Dll-Basisadresse
  *((DWORD * &)p)++ = DllBaseAddr;
  *((BYTE  * &)p)++ = 0x6A;          // PUSH 2               ; iwa_PatchFunctions
  *((BYTE  * &)p)++ = 0x02;
  *((BYTE  * &)p)++ = 0xFF;          // CALL EDI             ; rufe Funktion auf
  *((BYTE  * &)p)++ = 0xD7;
  *((BYTE  * &)p)++ = 0x83;          // ADD  ESP,8
  *((BYTE  * &)p)++ = 0xC4;
  *((BYTE  * &)p)++ = 0x08;
  *((BYTE  * &)p)++ = 0xCC;          // INT  3               ; Breakpoint
#elif defined(CPU_ALPHA)
  *((DWORD * &)p)++ = 0x221F0000 | iwa_PatchFunctions;                   // MOV     3,A0              ; iwa_PatchFunctions als 1. Argument
  *((DWORD * &)p)++ = 0x223F0000 | (Word)DllBaseAddr;                    // LDA     A1,xxxx(ZERO)     ; DllBaseAddr
  *((DWORD * &)p)++ = 0x26310000 | (Word)((DllBaseAddr + 0x8000) >> 16); // LDAH    A1,xxxx(A1)       ; als 2. Argument
  *((DWORD * &)p)++ = 0x6B4B4000;                                        // JSR     RA,(S2),0         ; _Init() aufrufen
  *((DWORD * &)p)++ = 0x00000080;                                        // CALLPAL BPT
#endif
  DWORD CodeSize = (DWORD)(p - MyCodeFragment);
  DWORD Result;
  BOOL f = WriteProcessMemory(ProcessInfo.hProcess,CodeFragmentAddr,&MyCodeFragment,CodeSize,&Result);
  if (!f || (Result != CodeSize)) { Write((PChar)"Couldn't patch!!!\n"); return False; }
  FlushInstructionCache(ProcessInfo.hProcess,CodeFragmentAddr,CodeSize);
  CONTEXT Context2 = Context1;
#if defined(CPU_INTEL)
  Context2.Edi    = ExtensionDllInitFunc;
  Context2.Ebp    = 0;
  Context2.Esp    = ExtensionStack;
  Context2.Eip    = (DWORD)CodeFragmentAddr;
  Context2.EFlags = 0x0216;
#elif defined(CPU_ALPHA)
  Context2.IntS2 = (DWORDLONG)ExtensionDllInitFunc;
  Context2.IntSp = (DWORDLONG)ExtensionStack;
  Context2.Fir   = (DWORDLONG)CodeFragmentAddr;
#endif
  if (!SetThreadContext(ThreadHandle,&Context2)) { Write((PChar)"SetThreadContext() failed!\n"); return False; }
  return True;
}

Boolean TProcessWatcher::ProcessPatched(void)
{
  if (ProcessPatchedDone) return True;
  ProcessPatchedDone = True;
  CONTEXT C;
  C.ContextFlags = CONTEXT_FULL;
  if (!GetThreadContext(ProcessInfo.hThread,&C)) { Write((PChar)"GetThreadContext failed!\n"); return False; }
  Char tmp[256];
#if defined(CPU_INTEL)
  if (C.Ebx & 255)
    {
      wsprintf((Pchar)tmp,(Pchar)"Error loading '%s', error code = %08lX\n",ExtensionDllName,C.Ebx); Write(tmp);
      wsprintf((Pchar)tmp,(Pchar)"EIP: %08lX\n",C.Eip); Write(tmp);
      wsprintf((Pchar)tmp,(Pchar)"EAX: %08lX\n",C.Eax); Write(tmp);    // Rckgabewert von _Init()
      wsprintf((Pchar)tmp,(Pchar)"EBX: %08lX\n",C.Ebx); Write(tmp);    // Fehlercode, 0 = ok
      wsprintf((Pchar)tmp,(Pchar)"ESI: %08lX\n",C.Esi); Write(tmp);    // DLL-Basisadresse
      wsprintf((Pchar)tmp,(Pchar)"EDI: %08lX\n",C.Edi); Write(tmp);    // Adresse von _Init()
    }
  else
    if (Verbose) { wsprintf((Pchar)tmp,(Pchar)"Dll '%s' loaded, base: %08lX, _Init: %08lX, OwnStack: %08lX\n",ExtensionDllName,C.Esi,C.Edi,C.Ecx); Write(tmp); }
  ExtensionDllBase     = C.Esi;
  ExtensionDllInitFunc = C.Edi;
  ExtensionStack       = C.Ecx;
#elif defined(CPU_ALPHA)
  if (C.IntS0)
    {
      wsprintf((Pchar)tmp,(Pchar)"Error loading '%s', error code = %08lX\n",ExtensionDllName,C.IntS0); Write(tmp);
      wsprintf((Pchar)tmp,(Pchar)"FIR: %08lX\n",C.Fir);   Write(tmp);
      wsprintf((Pchar)tmp,(Pchar)"V0:  %08lX\n",C.IntV0); Write(tmp);  // Rckgabewert von _Init()
      wsprintf((Pchar)tmp,(Pchar)"S0:  %08lX\n",C.IntS0); Write(tmp);  // Fehlercode, 0 = ok
      wsprintf((Pchar)tmp,(Pchar)"S1:  %08lX\n",C.IntS1); Write(tmp);  // DLL-Basisadresse
      wsprintf((Pchar)tmp,(Pchar)"S2:  %08lX\n",C.IntS2); Write(tmp);  // Adresse von _Init()
    }
  else
    if (Verbose) { wsprintf((Pchar)tmp,(Pchar)"Dll '%s' loaded, base: %08lX, _Init: %08lX, OwnStack: %08lX\n",ExtensionDllName,C.IntS1,C.IntS2,C.IntS3); Write(tmp); }
  ExtensionDllBase     = (LongWord)C.IntS1;
  ExtensionDllInitFunc = (LongWord)C.IntS2;
  ExtensionStack       = (LongWord)C.IntS3;
#endif
  return True;
}

Boolean TProcessWatcher::RestoreProcess(Boolean f,HANDLE ThreadHandle,Boolean ResetContext)
{
  DWORD Result;
  BOOL f1 = WriteProcessMemory(ProcessInfo.hProcess,CodeFragmentAddr,OrigCodeFragment,NewCodeSize,&Result);
  if (!f1 || (Result != NewCodeSize)) return False;
  FlushInstructionCache(ProcessInfo.hProcess,CodeFragmentAddr,NewCodeSize);
  if (ResetContext)
    {
      if (f && !Attached)
#if defined(CPU_INTEL)
        Context1.Eip = (DWORD)CodeFragmentAddr;
#elif defined(CPU_ALPHA)
        Context1.Fir = (DWORDLONG)CodeFragmentAddr;
#endif
      if (!SetThreadContext(ThreadHandle,&Context1)) { Write((PChar)"SetThreadContext() failed!\n"); return False; }
    }
  return True;
}

Boolean TProcessWatcher::AddDll(LongWord BaseAddr,LongWord EntryAddr)
{
  if (!BaseAddr) return False;
  for (int i = 0;i < MaxDllCount;++i)
    if (DllTab[i].de_BaseAddr == BaseAddr)
      return True;
  for (i = 0;i < MaxDllCount;++i)
    if (!DllTab[i].de_BaseAddr)
      {
        MemSet(&DllTab[i],0,sizeof DllTab[i]);
        DllTab[i].de_BaseAddr  = BaseAddr;
        DllTab[i].de_EntryAddr = EntryAddr;
        return True;
      }
  return False;
}

Boolean TProcessWatcher::RemoveDll(LongWord BaseAddr)
{
  if (!BaseAddr) return False;
  for (int i = 0;i < MaxDllCount;++i)
    if (DllTab[i].de_BaseAddr == BaseAddr)
      {
        MemSet(&DllTab[i],0,sizeof DllTab[i]);
        return True;
      }
  return False;
}

Boolean TProcessWatcher::PatchDlls(HANDLE ThreadHandle,Boolean ASuspendThreads,Pointer DllEntryAddr)
{
  LongWord BaseAddr;
  for (int i = 0;i < MaxDllCount;++i)
    if (BaseAddr = DllTab[i].de_BaseAddr)
      if (!DllTab[i].de_Patched)
        {
          if (DllEntryAddr)
            if ((DllEntryAddr != (Pointer)BaseAddr) && (DllEntryAddr != (Pointer)DllTab[i].de_EntryAddr))
              continue;
          if (IsWin95 && (BaseAddr >= 0x80000000)) continue;
          if (BaseAddr == ExtensionDllBase) continue;
          if (Verbose) { Char tmp[80]; wsprintf((Pchar)tmp,(Pchar)"Patching Dll at %08lX\n",BaseAddr); Write(tmp); }
          DllTab[i].de_Patched = True;
          PatchDll(BaseAddr,ThreadHandle);
          if (ASuspendThreads) SuspendThreads(ThreadHandle);
          return True;
        }
  return False;
}

Boolean TProcessWatcher::AddThread(DWORD ThreadId,HANDLE ThreadHandle)
{
  for (int i = 0;i < MaxThreadCount;++i)
    if (ThreadTab[i].te_ThreadId == ThreadId)
      return True;
  for (i = 0;i < MaxThreadCount;++i)
    if (!ThreadTab[i].te_ThreadId)
      {
        MemSet(&ThreadTab[i],0,sizeof ThreadTab[i]);
        ThreadTab[i].te_ThreadId     = ThreadId;
        ThreadTab[i].te_ThreadHandle = ThreadHandle;
        return True;
      }
  return False;
}

Boolean TProcessWatcher::RemoveThread(DWORD ThreadId)
{
  for (int i = 0;i < MaxThreadCount;++i)
    if (ThreadTab[i].te_ThreadId == ThreadId)
      {
        MemSet(&ThreadTab[i],0,sizeof ThreadTab[i]);
        return True;
      }
  return False;
}

void TProcessWatcher::SuspendThreads(HANDLE ThreadHandle)
{
  HANDLE T;
  for (int i = 0;i < MaxThreadCount;++i)
    if ((T = ThreadTab[i].te_ThreadHandle) != ThreadHandle)
      if (T)
        {
          if (Verbose) { Char tmp[80]; wsprintf((Pchar)tmp,(Pchar)"Suspending thread %lX\n",T); Write(tmp); }
          SuspendThread(T);
        }
}

void TProcessWatcher::ResumeThreads(HANDLE ThreadHandle)
{
  HANDLE T;
  for (int i = 0;i < MaxThreadCount;++i)
    if ((T = ThreadTab[i].te_ThreadHandle) != ThreadHandle)
      if (T)
        {
          if (Verbose) { Char tmp[80]; wsprintf((Pchar)tmp,(Pchar)"Resuming thread %lX\n",T); Write(tmp); }
          ResumeThread(T);
        }
}

HANDLE TProcessWatcher::ThreadId2Handle(DWORD ThreadId)
{
  for (int i = 0;i < MaxThreadCount;++i)
    if (ThreadTab[i].te_ThreadId == ThreadId)
      return ThreadTab[i].te_ThreadHandle;
  return 0;
}

Boolean TProcessWatcher::PatchDllEntry(Pointer DllEntryPoint)
{
  Boolean Result = True;
  Boolean Ok     = False;
  int i;
  for (i = 0;i < MaxNestedDllCount;++i)
    if (!DllEntryTab[i].dse_CodeStart)
      {
        Ok = True;
        break;
      }
  if (!Ok) return False;
  MemSet(&DllEntryTab[i],0,sizeof DllEntryTab[i]);
  DllEntryTab[i].dse_CodeStart = (Pointer)DllEntryPoint;
  DWORD ResultSize;
  BOOL f = ReadProcessMemory(ProcessInfo.hProcess,(Pointer)DllEntryPoint,&DllEntryTab[i].dse_EntryCode,sizeof DllEntryTab[i].dse_EntryCode,&ResultSize);
  if (!f || (ResultSize != sizeof DllEntryTab[i].dse_EntryCode)) { Result = False; Write((PChar)"Couldn't read code to patch!!!\n"); }
  f = WriteProcessMemory(ProcessInfo.hProcess,(Pointer)DllEntryPoint,&BreakpointInstr,sizeof BreakpointInstr,&ResultSize);
  if (!f || (ResultSize != sizeof BreakpointInstr)) { Result = False; Write((PChar)"Couldn't patch!!!\n"); }
  FlushInstructionCache(ProcessInfo.hProcess,(Pointer)DllEntryPoint,sizeof BreakpointInstr);
  return Result;
}

Boolean TProcessWatcher::RestoreDllEntry(HANDLE ThreadHandle,Pointer BreakAddr,PBoolean MoreBPs)
{
  Boolean  Result    = True;
  LongWord CodeDelta = 64;
  int i;
  for (i = 0;i < MaxNestedDllCount;++i)
    if (((LongWord)BreakAddr - (LongWord)DllEntryTab[i].dse_CodeStart) < CodeDelta)
      {
        DWORD ResultSize;
        BOOL f = WriteProcessMemory(ProcessInfo.hProcess,DllEntryTab[i].dse_CodeStart,&DllEntryTab[i].dse_EntryCode,sizeof DllEntryTab[i].dse_EntryCode,&ResultSize);
        if (!f || (ResultSize != sizeof DllEntryTab[i].dse_EntryCode)) { Result = False; Write((PChar)"Couldn't patch!!!\n"); }
        FlushInstructionCache(ProcessInfo.hProcess,DllEntryTab[i].dse_CodeStart,sizeof DllEntryTab[i].dse_EntryCode);
        if (!SetThreadContext(ThreadHandle,&DllEntryTab[i].dse_Context)) { Write((PChar)"SetThreadContext() failed!\n"); return False; }
        MemSet(&DllEntryTab[i],0,sizeof DllEntryTab[i]);
        break;
      }
  // stehen noch weitere Breakpoints von DllEntries aus?
  if (MoreBPs)
    for (i = 0;i < MaxNestedDllCount;++i)
      if (DllEntryTab[i].dse_CodeStart)
        {
          *MoreBPs = True;
          break;
        }
  return Result;
}

Boolean TProcessWatcher::IsDllEntryBreak(HANDLE ThreadHandle,Pointer BreakAddr)
{
  for (int i = 0;i < MaxNestedDllCount;++i)
    if (DllEntryTab[i].dse_CodeStart == BreakAddr)
      {
#if defined(CPU_INTEL)
        DllEntryTab[i].dse_Context.ContextFlags = CONTEXT_FULL | CONTEXT_FLOATING_POINT;
#elif defined(CPU_ALPHA)
        DllEntryTab[i].dse_Context.ContextFlags = CONTEXT_FULL;
#endif
        if (!GetThreadContext(ThreadHandle,&DllEntryTab[i].dse_Context)) ;
#if defined(CPU_INTEL)
        --DllEntryTab[i].dse_Context.Eip;
#endif
        LastDllEntryBreakAddr = BreakAddr;
        return True;
      }
  return False;
}

DWORD TProcessWatcher::HandleDebugEvent(LPDEBUG_EVENT Event)
{
  if ((Event->dwDebugEventCode == CREATE_PROCESS_DEBUG_EVENT) && !ProcessInfo.hProcess)
    {
      ProcessInfo.dwProcessId = Event->dwProcessId;     // Process wurde attached
      ProcessInfo.dwThreadId  = Event->dwThreadId;
      ProcessInfo.hProcess    = Event->u.CreateProcessInfo.hProcess;
      ProcessInfo.hThread     = Event->u.CreateProcessInfo.hThread;
    }
  HANDLE ThreadHandle = ThreadId2Handle(Event->dwThreadId);
  Char     DllName[256]  = {'\0'};
  LongWord DllEntryPoint = 0;
  if (Event->dwDebugEventCode == LOAD_DLL_DEBUG_EVENT)
    {
      if (!GetDLLName(ProcessInfo.hProcess,Event->u.LoadDll.hFile,(DWORD)Event->u.LoadDll.lpBaseOfDll,ProcessDebugInfo.lpThreadLocalBase,DllName,sizeof DllName,&DllEntryPoint))
        DllName[0] = '\0';
    }
  if (Verbose || LogFile)
    {
      PChar EventStr = (PChar)"???";
      Char  tmp[512] = {'\0'};
      switch(Event->dwDebugEventCode)
        {
          case EXCEPTION_DEBUG_EVENT:
            if (!Debug && (Event->u.Exception.ExceptionRecord.ExceptionCode == STATUS_BREAKPOINT)) goto L_Skip;
            EventStr = (PChar)"Exception";
            wsprintf((Pchar)tmp,(Pchar)"%08lX at %08lX",Event->u.Exception.ExceptionRecord.ExceptionCode,Event->u.Exception.ExceptionRecord.ExceptionAddress);
            {
              Char tmp1[256];
              CONTEXT C;
              C.ContextFlags = CONTEXT_FULL;
              GetThreadContext(ThreadHandle,&C);
#if defined(CPU_INTEL)
              wsprintf((Pchar)tmp1,(Pchar)" (EAX:%08lX EBX:%08lX ECX:%08lX EDX:%08lX ESI:%08lX EDI:%08lX EBP:%08lX ESP:%08lX DS:%04lX ES:%04lX)",C.Eax,C.Ebx,C.Ecx,C.Edx,C.Esi,C.Edi,C.Ebp,C.Esp,C.SegDs,C.SegEs);
#elif defined(CPU_ALPHA)
              wsprintf((Pchar)tmp1,(Pchar)" (V0:%08lX FP:%08lX RA:%08lX SP:%08lX)",C.IntV0,C.IntFp,C.IntRa,C.IntSp);
#endif
              StrConcat(tmp,tmp1,sizeof tmp);
            }
            break;

          case CREATE_THREAD_DEBUG_EVENT:
            EventStr = (PChar)"Thread created";
            wsprintf((Pchar)tmp,(Pchar)"%lX",Event->u.CreateThread.hThread);
            break;

          case CREATE_PROCESS_DEBUG_EVENT:
            EventStr = (PChar)"Process created";
            wsprintf((Pchar)tmp,(Pchar)"loaded at %08lX, Thread: %lX, ThreadLocalBase at %08lX",Event->u.CreateProcessInfo.lpBaseOfImage,Event->u.CreateProcessInfo.hThread,Event->u.CreateProcessInfo.lpThreadLocalBase);
            break;

          case EXIT_THREAD_DEBUG_EVENT:
            EventStr = (PChar)"Thread exit";
            break;

          case EXIT_PROCESS_DEBUG_EVENT:
            EventStr = (PChar)"Process exit";
            break;

          case LOAD_DLL_DEBUG_EVENT:
            EventStr = (PChar)"Load dll";
            wsprintf((Pchar)tmp,(Pchar)"'%s' at %08lX, entry at %08lX",DllName,Event->u.LoadDll.lpBaseOfDll,DllEntryPoint);
            break;

          case UNLOAD_DLL_DEBUG_EVENT:
            EventStr = (PChar)"Unload dll";
            wsprintf((Pchar)tmp,(Pchar)"at %08lX",Event->u.UnloadDll.lpBaseOfDll);
            break;

          case OUTPUT_DEBUG_STRING_EVENT:
            EventStr = (PChar)"Debug output";
            {
              PChar p  = (PChar)Event->u.DebugString.lpDebugStringData;
              int   l  = Event->u.DebugString.nDebugStringLength;
              PChar p1 = tmp;

              for (;(l-- > 0) && (p1 < tmp + sizeof tmp - 2);++p,++p1)
                {
                  DWORD r;
                  if (!ReadProcessMemory(ProcessInfo.hProcess,p,p1,sizeof *p1,&r) || (r != sizeof *p1))
                    break;
                }
              while ((p1 > tmp) && ((p1[-1] == '\0') || (p1[-1] == '\x0A') || (p1[-1] == '\x0D')))
                --p1;
              *p1 = '\0';
            }
            break;

          case RIP_EVENT:
            EventStr = (PChar)"RIP";
            break;
        }
      Char tmp1[512];
      if (Verbose) { wsprintf((Pchar)tmp1,(Pchar)"Process %lX, Thread %lX: %s %s\n",Event->dwProcessId,ThreadHandle,EventStr,tmp); Write(tmp1); }
      if (LogFile)
        {
          wsprintf((Pchar)tmp1,(Pchar)"Process %lX, Thread %lX: ",Event->dwProcessId,ThreadHandle);
          DWORD R;
          WriteFile(LogFile,tmp1,StrLen(tmp1),&R,NULL);
          WriteFile(LogFile," ",1,&R,NULL);
          WriteFile(LogFile,EventStr,StrLen(EventStr),&R,NULL);
          WriteFile(LogFile," ",1,&R,NULL);
          WriteFile(LogFile,tmp,StrLen(tmp),&R,NULL);
          WriteFile(LogFile,"\x0D\x0A",2,&R,NULL);
        }
    }
L_Skip:
  switch(Event->dwDebugEventCode)
    {
      case CREATE_PROCESS_DEBUG_EVENT:
        ProcessDebugInfo = Event->u.CreateProcessInfo;
        AddThread(Event->dwThreadId,Event->u.CreateProcessInfo.hThread);
        break;

      case CREATE_THREAD_DEBUG_EVENT:
        AddThread(Event->dwThreadId,Event->u.CreateThread.hThread);
        break;

      case EXIT_THREAD_DEBUG_EVENT:
        RemoveThread(Event->dwThreadId);
        break;

      case EXCEPTION_DEBUG_EVENT:
        if (Event->u.Exception.ExceptionRecord.ExceptionCode == EXCEPTION_BREAKPOINT)
          {
            switch(ProcessState)
              {
                case ps_FirstBreak:
                  ProcessState = ps_PatchProcess;
                  SetStartBreak();
                  if (Attached)
                    {
                      ProcessInfo.hThread = ThreadHandle;
                      SuspendThreads(ThreadHandle);
                      goto L1;
                    }
#if defined(CPU_ALPHA)
                  break;
#else
                  return DBG_CONTINUE;
#endif

                case ps_PatchProcess:
L1:               ProcessState = ps_PatchStaticDlls;
                  PatchProcess();
                  return DBG_CONTINUE;

                case ps_PatchStaticDlls:
                  ProcessPatched();
                  if (SkipAllDlls || !PatchDlls(ProcessInfo.hThread,False,NULL))
                    {
                      RestoreProcess(True,ProcessInfo.hThread,True);
                      if (Attached) ResumeThreads(ThreadHandle);
                      ProcessState = ps_ProcessComplete;
                    }
                  return DBG_CONTINUE;

                case ps_ProcessComplete:
                  break;

                case ps_PatchDynamicDll:
                  // prfe, ob Breakpoint von DllEntry oder von CodeFragment kommt
                  if (IsDllEntryBreak(ThreadHandle,Event->u.Exception.ExceptionRecord.ExceptionAddress))
                    {
                      // Context wurde gesichert
                      PatchDlls(ThreadHandle,False,Event->u.Exception.ExceptionRecord.ExceptionAddress);
                    }
                  else
                    {
                      Boolean MoreBPs;
                      RestoreDllEntry(ThreadHandle,LastDllEntryBreakAddr,&MoreBPs);
                      RestoreProcess(False,ThreadHandle,False);
                      ResumeThreads(ThreadHandle);
                      if (!MoreBPs)
                        ProcessState = ps_ProcessComplete;
                    }
                  return DBG_CONTINUE;

                case ps_PatchDynamicDllNoInit:
                  RestoreProcess(False,ThreadHandle,True);
                  ResumeThreads(ThreadHandle);
                  ProcessState = ps_PatchDynamicDll;
                  return DBG_CONTINUE;
              }
          }
#if defined(CPU_ALPHA)
        {
          CONTEXT C;
          C.ContextFlags = CONTEXT_FULL;
          if (GetThreadContext(ThreadHandle,&C))
            {
              C.Fir += sizeof(DWORD);             // Breakpoint-Instruktion berspringen
              SetThreadContext(ThreadHandle,&C);
            }
        }
        return DBG_CONTINUE;
#else
        return DBG_EXCEPTION_NOT_HANDLED;
#endif

      case LOAD_DLL_DEBUG_EVENT:
        if (SkipAllDlls || SkipDynDlls) break;
        {
          Char Name[128],Ext[80];
          FileSplit(DllName,NULL,Name,Ext);
          StrCat(Name,Ext);
          Boolean Skip = False;
          for (int i = 0;i < SkipDllsCount;++i)
            if (!StrICmp(Name,SkipDlls[i]))
              {
                if (Verbose) { Char tmp[80]; wsprintf((Pchar)tmp,(Pchar)"Skipping Dll '%s'\n",DllName); Write(tmp); }
                Skip = True;
                break;
              }
          if (Skip) break;
        }
        AddDll((LongWord)Event->u.LoadDll.lpBaseOfDll,DllEntryPoint);
        if (ProcessState >= ps_ProcessComplete)
          {
            if (IsWin95)
              {
                if (DllEntryPoint)
                  {
                    if (IsWin95 && ((LongWord)Event->u.LoadDll.lpBaseOfDll >= 0x80000000))
                      ;
                    else
                      {
                        PatchDllEntry((Pointer)DllEntryPoint);
                        SuspendThreads(ThreadHandle);
                        if (ProcessState == ps_ProcessComplete)
                          ProcessState = ps_PatchDynamicDll;
                      }
                  }
              }
            else
              {
#if defined(CPU_INTEL)
                Context1.ContextFlags = CONTEXT_FULL | CONTEXT_FLOATING_POINT;
#elif defined(CPU_ALPHA)
                Context1.ContextFlags = CONTEXT_FULL;
#endif
                if (!GetThreadContext(ThreadHandle,&Context1)) ;
                if (PatchDlls(ThreadHandle,True,Event->u.LoadDll.lpBaseOfDll))
                  ProcessState = ps_PatchDynamicDllNoInit;
              }
          }
        break;

      case UNLOAD_DLL_DEBUG_EVENT:
        RemoveDll((LongWord)Event->u.UnloadDll.lpBaseOfDll);
        break;
    }
  return DBG_CONTINUE;
}

Boolean TProcessWatcher::Run(PChar CmdLine,int *ReturnCode)
{
  if (CreateProcess(NULL,(Pchar)CmdLine,NULL,NULL,FALSE,DEBUG_ONLY_THIS_PROCESS,NULL,NULL,&StartupInfo,&ProcessInfo))
    {
      for (;;)
        {
          DEBUG_EVENT Event;
          if (WaitForDebugEvent(&Event,INFINITE))
            {
              DWORD continueStatus = HandleDebugEvent(&Event);
              if (Event.dwDebugEventCode == EXIT_PROCESS_DEBUG_EVENT)
                {
                  *ReturnCode = Event.u.ExitProcess.dwExitCode;
                  break;
                }
              ContinueDebugEvent(Event.dwProcessId,Event.dwThreadId,continueStatus);
            }
        }
    }
  else
    return False;
  return True;
}

Boolean TProcessWatcher::Run(LongWord ProcessId,int *ReturnCode)
{
  if (DebugActiveProcess(ProcessId))
    {
      Attached = True;
      for (;;)
        {
          DEBUG_EVENT Event;
          if (WaitForDebugEvent(&Event,INFINITE))
            {
              DWORD continueStatus = HandleDebugEvent(&Event);
              if (Event.dwDebugEventCode == EXIT_PROCESS_DEBUG_EVENT)
                {
                  *ReturnCode = Event.u.ExitProcess.dwExitCode;
                  break;
                }
              ContinueDebugEvent(Event.dwProcessId,Event.dwThreadId,continueStatus);
            }
        }
    }
  else
    return False;
  return True;
}

////////////////////////////////////////////////////////////////////////////////

void GetAppFileName(PChar AppName,int AppNameSize)
{
  if (!AppNameSize) return;
  AppName[0] = '\0';
  OPENFILENAME ofn;
  Char         szFile[256],szFileTitle[256];
  Char         szFilter[256];
  int          i;
  Char         chReplace;
  szFile[0] = '\0';
  StrCpy(szFilter,(PChar)"Anwendung (*.exe)|*.exe|");
  chReplace = szFilter[StrLen(szFilter) - 1];
  for (i = 0;szFilter[i] != '\0';i++) if (szFilter[i] == chReplace) szFilter[i] = '\0';
  MemSet(&ofn,0,sizeof ofn);
  ofn.lStructSize     = sizeof ofn;
  ofn.lpstrFilter     = (Pchar)szFilter;
  ofn.nFilterIndex    = 1;
  ofn.lpstrFile       = (Pchar)szFile;
  ofn.nMaxFile        = sizeof szFile;
  ofn.lpstrFileTitle  = (Pchar)szFileTitle;
  ofn.nMaxFileTitle   = sizeof szFileTitle;
  Char TitleStr[256];
  StrCpy(TitleStr,(PChar)"Zu berwachendes Programm ffnen");
  ofn.lpstrTitle      = (Pchar)TitleStr;
  ofn.lpstrInitialDir = "";
  ofn.Flags           = OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
  if (GetOpenFileName(&ofn)) StrCopy(AppName,(PChar)ofn.lpstrFile,AppNameSize);
}

int Main(int argc,PChar argv[])
{
  AppInstance = GetModuleHandle(NULL);
  Char        CmdLine[2048] = {'\0'};
  Char        AppName[256]  = {'\0'};
  Char        LogName[256]  = {'\0'};
  Char        InstDir[256]  = {'\0'};
  Boolean     Verbose       = False;
  Boolean     Debug         = False;
  Boolean     SkipAllDlls   = False;
  Boolean     SkipDynDlls   = False;
  TWatchLevel WatchLevel    = wl_Verbose;
  LongWord    ProcessId     = 0;
  const int   MaxSkipDlls   = 32;
  int         SkipDllsCount = 0;
  PChar       SkipDlls[MaxSkipDlls];
  int i;
  for (i = 1;i < argc;++i)
    {
      if (!StrCmp(argv[i],(PChar)"-v"))
        Verbose = True;
      else if (!StrCmp(argv[i],(PChar)"-d"))
        Debug = True;
      else if (!StrNCmp(argv[i],(PChar)"-skipdll:",9))
        {
          if (SkipDllsCount < MaxSkipDlls - 1)
            {
              Char DllName[128],DllExt[128];
              FileSplit(argv[i] + 9,NULL,DllName,DllExt);
              StrCat(DllName,DllExt);
              SkipDlls[SkipDllsCount++] = NewStr(DllName);
            }
        }
      else if (!StrCmp(argv[i],(PChar)"-skipalldlls"))
        SkipAllDlls = True;
      else if (!StrCmp(argv[i],(PChar)"-skipdyndlls"))
        SkipDynDlls = True;
      else if (!StrNCmp(argv[i],(PChar)"-p:",3))
        ProcessId = StrToLongWord(argv[i] + 3);
      else if (!StrNCmp(argv[i],(PChar)"-l:",3))
        WatchLevel = (TWatchLevel)StrToLongWord(argv[i] + 3);
      else if (!StrNCmp(argv[i],(PChar)"-log:",5))
        StrCopy(LogName,argv[i] + 5,sizeof LogName);
      else if (!StrNCmp(argv[i],(PChar)"-instdir:",9))
        {
          StrCopy(InstDir,argv[i] + 9,sizeof InstDir);
          int l = StrLen(InstDir);
          if ((l > 0) && (InstDir[l - 1] != '\\'))
            StrConcat(InstDir,(PChar)"\\",sizeof InstDir);
        }
      else
        {
          StrCopy(AppName,argv[i],sizeof AppName);
          break;
        }
    }
  if (!AppName[0] && !ProcessId) GetAppFileName(AppName,sizeof AppName);
  if (!AppName[0] && !ProcessId) { wsprintf((Pchar)CmdLine,(Pchar)"Aufruf: %s [-v] [-skipdll:<dllname>] [-skipalldlls]  [-skipdyndlls] [-l:<level> [-log:<filename>] (<Programmname> | -p:xxx) [<Arg1> <Arg2>...]\n",argv[0]); Alert(CmdLine); return 10; }
  if (!ProcessId)
    { // GetBinaryType() wre geeignet, funktioniert aber unter Win95 nicht richtig
      HANDLE f = CreateFile((Pchar)AppName,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
      if (f == INVALID_HANDLE_VALUE) { wsprintf((Pchar)CmdLine,(Pchar)"Die Anwendung '%s' wurde nicht gefunden!\n",AppName); Alert(CmdLine); return 11; }
      Boolean IsOk = False;
      DWORD D;
      CHAR  Signature[2];
      DWORD Result;
      if (SetFilePointer(f,0x3C,NULL,FILE_BEGIN))
        if (ReadFile(f,&D,sizeof D,&Result,NULL))
          if (D)
            if (SetFilePointer(f,D,NULL,FILE_BEGIN))
              if (ReadFile(f,Signature,sizeof Signature,&Result,NULL))
                if ((Signature[0] == 'P') && (Signature[1] == 'E'))
                  IsOk = True;
      if (f) CloseHandle(f);
      if (!IsOk) { wsprintf((Pchar)CmdLine,(Pchar)"'%s' ist keine Win32-Anwendung und kann daher nicht berwacht ausgefhrt werden!\n",AppName); Alert(CmdLine); return 13; }
    }
  Char IWatchExtensionDllName[256];
  FileSplit(argv[0],IWatchExtensionDllName,NULL,NULL);
  StrCat(IWatchExtensionDllName,(PChar)"iwatchex.dll");
  if (!ProcessId)
    {
      StrConcat(CmdLine,AppName,sizeof CmdLine);
      for (++i;i < argc;++i)
        {
          if (i < argc) StrConcat(CmdLine,(PChar)" ",sizeof CmdLine);
          StrConcat(CmdLine,argv[i],sizeof CmdLine);
        }
    }
  int ReturnCode = 13;
  PProcessWatcher W = new TProcessWatcher(WatchLevel,Verbose,Debug,SkipAllDlls,SkipDynDlls,SkipDlls,SkipDllsCount,IWatchExtensionDllName,InstDir,LogName);
  Boolean f = False;
  if (W)
    {
      if (ProcessId)
        f = W->Run(ProcessId,&ReturnCode);
      else
        f = W->Run(CmdLine,&ReturnCode);
      delete W;
    }
  for (int j = 0;j < SkipDllsCount;++j)
    if (SkipDlls[j])
      DisposeStr(SkipDlls[j]);
  if (!W || !f)
    {
      Char tmp[512]; wsprintf((Pchar)tmp,(Pchar)"Unable to start program: '%s', error code = %d\n",CmdLine,GetLastError()); Write(tmp);
      return ReturnCode;
    }
  return 0;
}

#if defined(_MSC_VER)
extern "C" void __stdcall startup(void)
#else
extern "C" void _cdecl startup(void)
#endif
{
  IsWin95 = (Boolean)((GetVersion() & 0xC0000000) == 0xC0000000);
  InitHeap(1024);
  int   argc = 0;
  PChar argv[100];
  MemSet(argv,0,sizeof argv);
  PChar CmdLine = (PChar)GetCommandLine();
  if (CmdLine)
    for (;;)
      {
        while ((*CmdLine == ' ') || (*CmdLine == '\t')) ++CmdLine;
        if (!*CmdLine) break;
        PChar p = CmdLine;
        Boolean HasQuote = False;
        if (*p == '"') { ++CmdLine; ++p; while (*p && (*p != '"')) ++p; if (*p == '"') ++p; HasQuote = True; }
        else { while (*p && (*p != ' ') && (*p != '\t')) ++p; }
        int l = (int)(p - CmdLine);
        if (!l) break;
        if (HasQuote) --l;
        if (!l) break;
        PChar p1 = new Char[l + 1];
        if (!p1) break;
        MemCpy(p1,CmdLine,l);
        p1[l] = '\0';
        argv[argc++] = p1;
        while ((*p == ' ') || (*p == '\t')) ++p;
        CmdLine = p;
      }
  if (argv[0]) DisposeStr(argv[0]);
  Char tmp[512];
  GetModuleFileName(GetModuleHandle(NULL),(Pchar)tmp,sizeof tmp);
  argv[0] = NewStr(tmp);
  int ExitCode = Main(argc,argv);
  DoneHeap();
  ExitProcess(ExitCode);
}

