procedure THyperlinkForm1.Frameanalyse;
VAR cols, rows, proz:           String;
    Frameborder, Framespacing:  String;
    frame:                      String;
    anzc, anzr, i, j:           Integer;
    co, ro:                     Integer;
    FRSLen:                     Integer;
begin
  FRSLen := EditSelected.GetTextLen; 
  Frameborder := getArg (EditSelected, 0,
                         'frameborder', FRSLen, TRUE);
  IF (Frameborder <> '') THEN BEGIN
    IF (Frameborder = '0') OR (Frameborder = 'no') THEN
      CheckBoxFrameborder.Checked := FALSE
    ELSE IF (Frameborder = '1') OR (Frameborder = 'yes') THEN
      CheckBoxFrameborder.Checked := TRUE;
  END (* IF Frameborder *);

  Framespacing := getArg (EditSelected, 0,
                          'framespacing', FRSLen, TRUE);
  IF Framespacing = '' THEN
    Framespacing := getArg (EditSelected, 0, 'border', FRSLen, TRUE);
  IF Framespacing <> '' THEN
    UpDownFrameSpacing.Position := StrToInt (Framespacing);

//Anzahl Spalten ermitteln:
  FRSLen := EditSelected.findText ('>', 0,
                 EditSelected.getTextLen, []) + 1;
  cols := getArg (EditSelected, 0, 'cols', FRSLen, TRUE);
  anzc := 1;
  IF cols <> '' THEN BEGIN
    i := 1;
    WHILE i < Length (cols) DO BEGIN
      INC (i);
      IF cols [i] = ',' THEN INC (anzc);
    END (* WHILE *);
  END (* IF *);
  UpDownSpalten.Position := anzc;
  StringGridFrameset.ColCount := anzc + 2;

// Anzahl Zeilen ermitteln:
  rows := getArg (EditSelected, 0, 'rows', FRSLen, TRUE);
  anzr := 1;
  IF rows <> '' THEN BEGIN
    i := 1;
    WHILE i < Length (rows) DO BEGIN
      INC (i);
      IF rows [i] = ',' THEN INC (anzr);
    END (* WHILE *);
  END (* IF *);
  UpDownReihen.Position := anzr;
  StringGridFrameset.RowCount := anzr + 2;

// Breitenwerte der Spalten bertragen
  IF cols <> '' THEN BEGIN
    i := 1;
    FOR j := 1 TO anzc DO BEGIN
      proz := '';
      WHILE (i < Length (cols)) AND NOT
             (cols [i] IN ['0'..'9', '%', '*']) DO
        INC (i);
      WHILE (i <= Length (cols)) AND
             (cols [i] IN ['0'..'9', '%', '*']) DO BEGIN
        proz := proz + cols [i]; INC (i);
      END (* WHILE *);
      StringGridFrameSet.Cells [j + 1, 1] := proz;
    END (* FOR *);
  END (* IF cols *);

// Hhenwerte der Zeilen bertragen
  IF rows <> '' THEN BEGIN
    i := 1;
    FOR j := 1 TO anzr DO BEGIN
      proz := '';
      WHILE (i < Length (rows)) AND NOT
             (rows [i] IN ['0'..'9', '%', '*']) DO
        INC (i);
      WHILE (i <= Length (rows)) AND
             (rows [i] IN ['0'..'9', '%', '*']) DO BEGIN
        proz := proz + rows [i]; INC (i);
      END (* WHILE *);
      StringGridFrameSet.Cells [1, j + 1] := proz;
    END (* FOR *);
  END (* IF cols *);

  WITH StringgridFrameset DO BEGIN
RowCount: ' + IntToStr (RowCount));
    lastArgEnd := EditSelected.FindText ('>', 0, 
EditSelected.GetTextLen, []);

    frame := getFrame (lastArgEnd + 1);
    IF frame <> '' THEN BEGIN
      FOR ro := 2 TO RowCount - 1 DO BEGIN
        FOR co := 2 TO ColCount - 1 DO BEGIN
          Cells [co, ro] := frame;
          frame := getFrame (lastArgEnd + 1);
        END (* FOR col *);
      END (* FOR row *);
    END (* IF *);
  END (* WITH *);

  WITH StringGridFrameset DO BEGIN
    Col := 1; Row := 1;
  END;
  StringGridFramesetClick (Self);

end (* Frameanalyse *);
