Program ECCDemo;  {as, c't Mai 98}
const H:array [0..7] of array[0..63] of char =

( { Matrix fr binren Hamming Code fr 64-Bit Speicherworte
   mit SECDED und optimierte Erkennung (45 %) fr Tripple-Errors }
'1010011101010010100001000100001111101101110001111110101001100000',
'1101000000001101011000100010001111011011101101101101010101010001',
'0100110000100011000100010000001110111111011111111000110010101101',
'0011101011100000110010000001001101110110111011010011101110011011',
'1111100110011000001110001000101011111110000110110111011110000111',
'0000011110000100000001111000010111110001111110001111000001111111',
'0000000001111100000000000111110000001111111110000000111111111111',
'0000000000000011111111111111110000000000000001111111111111111111'
);

Type Mementry=record   { 72 Bit Memory-Eintrag }
              mhi,mlo:longint;
              mecc:byte;
              end;
var m0,m:Mementry;
var Ht:array[0..71] of byte; { = h-Matrix transponiert und binr}

Function ECC(xhi,xlo:longint):byte;
var b:byte; i,j:integer;
begin
b:=0;
 for j:=0 to 31 do
  begin
  if odd (xlo shr j) then b:=b xor Ht[j];
  if odd (xhi shr j) then b:=b xor Ht[j+32];
  end;
ECC:=b;
end;

Procedure SetHtMatrix;
var i,j:longint;
begin
fillchar (Ht,sizeof(Ht),#0);
for j:=0 to 63 do
 for i:=0 to 7 do if H[i][j] >'0' then Ht[j]:=Ht[j] or (1 shl i);
 for i:=0 to 7 do HT[64+i]:= (1 shl i)
end;

Procedure Storemem (xhi,xlo:longint);
begin
 m.mhi:=xhi; m.mlo:=xlo; m.mecc:=ECC(xhi,xlo);
end;

Procedure Disturb (n:longint);
begin
if n < 32 then m.mlo:=m.mlo xor (1 shl n)
 else if n < 64 then m.mhi:=m.mhi xor (1 shl (n-32))
  else if n < 72 then m.mecc :=m.mecc xor (1 shl (n-64))
end;

Procedure Readmem (var xhi,xlo:longint; var res:integer);
var i:longint; xecc, Delta:byte;

begin
{
Return mit res=
  0: keinen Fehler entdeckt
  1: Fehler in Hiword, korrigiert
  2: Fehler in Loword, korrigiert
  3: Fehler in ECC-Bit
  4: 2,3,4.. Bit Fehler
}

xhi:=m.mhi; xlo:=m.mlo; xecc:=ECC(xhi,xlo);
res:=0;
Delta:=xecc xor m.mecc;
If Delta=0 then exit;
for i:=00 to 31 do if Ht[i]=Delta then
    begin Res:=1; xlo:=xlo  xor (1 shl i); exit end;
for i:=32 to 63 do if Ht[i]=Delta then
    begin Res:=2; xhi:=xhi  xor (1 shl (i-32)); exit end;
for i:=64 to 71 do if Ht[i]=Delta then
    begin Res:=3; exit end;
res:=4;
end;

var xhi,xlo,yhi,ylo:longint;
var i,j,k:integer;
var res:integer;
var anz,notdetected:longint;
begin
xhi:=$55AA55AA;Xlo:=$55AA55AA;  { Datenwort }
SetHtMatrix;                    { Matrix setzen }
notdetected:=0;
For i:=0 to 71 do
 begin
 Storemem (xhi,xlo);             { Datenwort Speichern}
 disturb(i);                     { Single Bit Fehler erzeugen }
 Readmem (yhi,ylo,res);          { auslesen mit ECC-Korrektur }
 Write (' Bit',i:2,':');
 if (yhi=xhi) and (xlo=ylo) Then Write ('ok ') else
  begin Write ('err'); inc (notdetected); end;
 end;

Writeln ('Unentdeckte Singlebitfehler:',notdetected);
notdetected:=0;
For i:=0 to 71 do
 for j:=i+1 to 71 do
 begin
 Storemem (xhi,xlo);             { Datenwort Speichern}
 disturb(i);disturb(j);          { Double Bit Fehler erzeugen }
 Readmem (yhi,ylo,res);          { auslesen mit ECC-Korrektur }
 if res <> 4 then   inc (notdetected);
 end;
 Writeln ('Unentdeckte Doppelbitfehler:',notdetected);

notdetected:=0;
anz:=0;
For i:=0 to 71 do
 for j:=i+1 to 71 do
  for k:=j+1 to 71 do
 begin
 Storemem (xhi,xlo);              { Datenwort Speichern}
 disturb(i);disturb(j);disturb(k);{ Triple Bit Fehler erzeugen }
 Readmem (yhi,ylo,res);           { auslesen mit ECC-Korrektur }
 if res <> 4 then   inc (notdetected);
 inc (anz);
 end;
 Writeln ('Unentdeckte Triplebitfehler:',notdetected,' von ', anz,' =',notdetected/anz*100:4:1,'%');


end.


