unit HyperlinkForm;

(* 01. 11. 1997 *)
{The Little Richard Editor
 (C) 1996, 1997, 1998 by Johannes Leckebusch
Stand: 10. 03. 1978}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, SLREdit, Buttons, Grids, Mask, Menus;

type
  THyperlinkForm1 = class(TForm)
    Panel1: TPanel;
    PanelButtons: TPanel;
    PageControlHyperlinks: TPageControl;
    TabSheetHyperlinks: TTabSheet;
    PanelEditSelected: TPanel;
    Ok: TButton;
    Uebernehmen: TButton;
    Abbrechen: TButton;
    TabSheetAnker: TTabSheet;
    TabSheetGrafik: TTabSheet;
    GroupBoxLinkziel: TGroupBox;
    Label1: TLabel;
    EditLinkziel: TEdit;
    ButtonLinkErzeugen: TButton;
    ButtonDateibrowser: TButton;
    ButtonUndo: TButton;
    GroupBoxGrafik: TGroupBox;
    GroupBox1: TGroupBox;
    Label5: TLabel;
    EditLokalesLinkziel: TEdit;
    ButtonSprungziel: TButton;
    Button4: TButton;
    TabSheetLinien: TTabSheet;
    GroupBoxHorizontalLine: TGroupBox;
    EditLiniendicke: TEdit;
    UpDownLinie: TUpDown;
    ButtonHorizontalLine: TButton;
    EditLinienbreite: TEdit;
    UpDownLinienbreite: TUpDown;
    Label8: TLabel;
    Label9: TLabel;
    CheckBoxNoshade: TCheckBox;
    TabSheetFont: TTabSheet;
    GroupBoxFont: TGroupBox;
    TabSheetZeichen: TTabSheet;
    GroupBoxZeichen: TGroupBox;
    CheckBoxBold: TCheckBox;
    CheckBoxItalic: TCheckBox;
    CheckBoxTeletype: TCheckBox;
    CheckBoxBig: TCheckBox;
    CheckBoxSmall: TCheckBox;
    ButtonZeichenattribute: TButton;
    TabSheetParagraph: TTabSheet;
    GroupBoxParagraph: TGroupBox;
    TabSheetHead: TTabSheet;
    GroupBoxHead: TGroupBox;
    RadioGroupSize: TRadioGroup;
    RadioGroupHeadAlignement: TRadioGroup;
    ButtonHead: TButton;
    TabSheetListing: TTabSheet;
    GroupBoxListing: TGroupBox;
    TabSheetBreak: TTabSheet;
    GroupBoxUmbruch: TGroupBox;
    RadioGroupClear: TRadioGroup;
    ButtonBreak: TButton;
    TabSheetFrames: TTabSheet;
    GroupBoxFrames: TGroupBox;
    RadioGroupLinkart: TRadioGroup;
    EditSelektierterText: TEdit;
    Label16: TLabel;
    Label17: TLabel;
    EditSprungziel: TEdit;
    Label18: TLabel;
    EditUeberschrift: TEdit;
    PopupMenuDefFrameset: TPopupMenu;
    Frameeditieren1: TMenuItem;
    Frameseteditieren1: TMenuItem;
    TabSheetTables: TTabSheet;
    TabSheetBase: TTabSheet;
    TabSheetSeite: TTabSheet;
    TabSheetKommentar: TTabSheet;
    PanelFramegrid: TPanel;
    PanelFramegridTop: TPanel;
    PanelFrameGridLeft: TPanel;
    Label13: TLabel;
    MaskEditReihen: TMaskEdit;
    UpDownReihen: TUpDown;
    ButtonFrameSetDef: TButton;
    Label12: TLabel;
    MaskEditSpalten: TMaskEdit;
    UpDownSpalten: TUpDown;
    StringGridFrameset: TStringGrid;
    SplitterFrameset: TSplitter;
    ButtonFrameedit: TButton;
    ButtonFramesetEdit: TButton;
    GroupBoxKommentar: TGroupBox;
    RichEditKommentar: TRichEdit;
    Label19: TLabel;
    ButtonKommentar: TButton;
    PanelAbsatzdef: TPanel;
    ButtonParagraph: TButton;
    RadioGroupIndent: TRadioGroup;
    RichEditAbsatz: TRichEdit;
    TabSheetTitle: TTabSheet;
    GroupBoxTitel: TGroupBox;
    Label20: TLabel;
    EditTitle: TEdit;
    ButtonTitle: TButton;
    GroupBoxSeite: TGroupBox;
    Splitter2: TSplitter;
    RichEditSeite: TRichEdit;
    ScrollBoxSeite: TScrollBox;
    Label21: TLabel;
    EditSeitentitel: TEdit;
    ButtonSeitentitel: TButton;
    Label22: TLabel;
    ButtonMeta: TButton;
    ButtonSeite: TButton;
    Panel2: TPanel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    ButtonTargetNewbrowser: TButton;
    ButtonTargetBeforeframe: TButton;
    ButtonTargetTop: TButton;
    Label14: TLabel;
    EditTarget: TEdit;
    Label26: TLabel;
    EditLokallink: TEdit;
    ComboBoxMeta: TComboBox;
    PopupMenuMeta: TPopupMenu;
    Metaanweisungeinfgen1: TMenuItem;
    Metaanweisunglschen1: TMenuItem;
    NeueMetaschablone1: TMenuItem;
    Metaanweisungunteneinfgen1: TMenuItem;
    ButtonSeitenanalyse: TButton;
    N1: TMenuItem;
    Metaanweisungberschreiben1: TMenuItem;
    ColorDialog1: TColorDialog;
    RichEditFont: TRichEdit;
    Panel3: TPanel;
    Label10: TLabel;
    EditFontgroesse: TEdit;
    UpDownFontgroesse: TUpDown;
    CheckBoxRelativ: TCheckBox;
    CheckBoxKeineGroesse: TCheckBox;
    ButtonFont: TButton;
    Label33: TLabel;
    PanelFontColor: TPanel;
    Splitter3: TSplitter;
    ButtonNurDateiname: TButton;
    Panel4: TPanel;
    Panel5: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    Label11: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    EditHorizontal: TEdit;
    EditVertikal: TEdit;
    UpDownHorizontal: TUpDown;
    UpDownVertikal: TUpDown;
    EditRahmen: TEdit;
    UpDownRahmen: TUpDown;
    RadioGroupAusrichtung: TRadioGroup;
    EditBreite: TEdit;
    EditHoehe: TEdit;
    UpDownBreite: TUpDown;
    UpDownHoehe: TUpDown;
    Panel6: TPanel;
    Label2: TLabel;
    Label27: TLabel;
    Label35: TLabel;
    EditGrafikdatei: TEdit;
    ButtonGrafikLink: TButton;
    ButtonGrafikBrowser: TButton;
    Button3: TButton;
    ButtonNurDatei: TButton;
    EditGrafikAlternativ: TEdit;
    EditLowRes: TEdit;
    ButtonLowResBrowser: TButton;
    ButtonLowNurDatei: TButton;
    PanelGrafikvorschau: TPanel;
    CheckBoxEinpassen: TCheckBox;
    ScrollBoxGrafik: TScrollBox;
    ImageGrafiklink: TImage;
    SplitterVGrafikdisplay: TSplitter;
    Splitter4: TSplitter;
    ProgressBarGrafik: TProgressBar;
    ButtonBildgroesse: TButton;
    ButtonKeineBildgroesse: TButton;
    PanelHintergrund: TPanel;
    Label34: TLabel;
    EditHintergrund: TEdit;
    ButtonDateiHintergrund: TButton;
    ButtonHintergrundNurDatei: TButton;
    ButtonHintergrund: TButton;
    Panel7: TPanel;
    ImageHintergrund: TImage;
    Label38: TLabel;
    PanelBodyFarbe: TPanel;
    Label28: TLabel;
    PanelBodyColor: TPanel;
    Label29: TLabel;
    PanelTextColor: TPanel;
    Label30: TLabel;
    PanelLinkColor: TPanel;
    Label31: TLabel;
    PanelVLinkColor: TPanel;
    Label32: TLabel;
    PanelALinkColor: TPanel;
    ButtonColorDefine: TButton;
    CheckBoxFrameborder: TCheckBox;
    Label39: TLabel;
    EditFramespacing: TEdit;
    UpDownFrameSpacing: TUpDown;
    CheckBoxBackFix: TCheckBox;
    SplitterKopfTags: TSplitter;
    EditSelected: TRichEdit;
    PopupMenuEditor: TPopupMenu;
    Einfuegen: TMenuItem;
    Kopieren1: TMenuItem;
    Ausschneiden1: TMenuItem;
    Loeschen1: TMenuItem;
    Allesauswaehlen1: TMenuItem;
    N2: TMenuItem;
    Zeilenumbruchumschalten1: TMenuItem;
    TimerSetup: TTimer;
    Label6: TLabel;
    N3: TMenuItem;
    Suchen1: TMenuItem;
    Tauschen1: TMenuItem;
    FindDialog1: TFindDialog;
    ReplaceDialog1: TReplaceDialog;
    SpeedButtonSyntax: TSpeedButton;
    Label7: TLabel;
    EditSubject: TEdit;
    Panel8: TPanel;
    Panel9: TPanel;
    RadioGroupBlockade: TRadioGroup;
    ButtonListe: TButton;
    SplitterListing: TSplitter;
    RichEditListing: TRichEdit;
    RadioGroupListentyp: TRadioGroup;
    EditListingstart: TEdit;
    UpDownListingStart: TUpDown;
    Label40: TLabel;
    RadioGroupNumerierung: TRadioGroup;
    TabSheetLinkliste: TTabSheet;
    GroupBoxLinkliste: TGroupBox;
    Panel10: TPanel;
    Panel11: TPanel;
    SplitterLinklist: TSplitter;
    RichEditLinklist: TRichEdit;
    GroupBoxListoptionen: TGroupBox;
    CheckBoxLinktext: TCheckBox;
    CheckBoxPrefix: TCheckBox;
    Label41: TLabel;
    EditLinkprefix: TEdit;
    ButtonLinkliste: TButton;
    CheckBoxLinkbreaks: TCheckBox;
    Label42: TLabel;
    EditUnmarkedPrefix: TEdit;
    CheckBoxURLPrefix: TCheckBox;
    Label43: TLabel;
    EditURLPrefix: TEdit;
    GroupBoxForms: TGroupBox;
    SplitterTabellenEditor: TSplitter;
    Panel12: TPanel;
    PanelFormsTop: TPanel;
    PanelFormsLeft: TPanel;
    StringGridTables: TStringGrid;
    PopupMenuForms: TPopupMenu;
    Spaltenbreiteeinstellen1: TMenuItem;
    Zeilenhoeheeinstellen1: TMenuItem;
    PanelFormSummary: TPanel;
    PanelFormTopLeft: TPanel;
    Label44: TLabel;
    MaskEditFormSpalten: TMaskEdit;
    UpDownFormSpalten: TUpDown;
    Label45: TLabel;
    EditFormborder: TEdit;
    UpDownFormborder: TUpDown;
    RichEditTabSummary: TRichEdit;
    Label48: TLabel;
    Label49: TLabel;
    MaskEditSpanCols: TMaskEdit;
    UpDownSpanCols: TUpDown;
    Label51: TLabel;
    MaskEditSpanRows: TMaskEdit;
    UpDownSpanRows: TUpDown;
    TabSheetForms: TTabSheet;
    ButtonTables: TButton;
    CheckBoxEmphasized: TCheckBox;
    Label50: TLabel;
    EditZelltyp: TEdit;
    ButtonTH: TButton;
    ButtonTD: TButton;
    EditFormCaption: TEdit;
    Label46: TLabel;
    Label52: TLabel;
    EditTabellenbreite: TEdit;
    RadioGroupTableAlign: TRadioGroup;
    PanelTabCellEditor: TPanel;
    PanelCellEditSchalter: TPanel;
    RichEditTabCell: TRichEdit;
    ButtonTabCellEditor: TButton;
    Label53: TLabel;
    Label54: TLabel;
    Label47: TLabel;
    MaskEditFormReihen: TMaskEdit;
    UpDownFormReihen: TUpDown;
    Label55: TLabel;
    PanelFrameZelleditor: TPanel;
    PanelFrameZellEditorRechts: TPanel;
    RichEditFrameset: TRichEdit;
    Label56: TLabel;
    ButtonFrameZellEditor: TButton;
    RadioGroupAutoLinkart: TRadioGroup;
    ButtonAnchors: TButton;
    Label15: TLabel;
    EditLinkListTarget: TEdit;
    ButtonNeuBrowser: TButton;
    ButtonWieVorFrames: TButton;
    ButtonGanzFenster: TButton;
    Label57: TLabel;
    EditX: TEdit;
    EditY: TEdit;
    procedure ButtonLinkErzeugenClick(Sender: TObject);
    procedure ButtonUndoClick(Sender: TObject);
    procedure ButtonDateibrowserClick(Sender: TObject);
    procedure UebernehmenClick(Sender: TObject);
    procedure ButtonGrafikLinkClick(Sender: TObject);
    procedure ButtonGrafikBrowserClick(Sender: TObject);
    procedure ButtonSprungzielClick(Sender: TObject);
    procedure ButtonRemoveLinkClick(Sender: TObject);
    procedure ButtonHorizontalLineClick(Sender: TObject);
    procedure ButtonFontClick(Sender: TObject);
    procedure ButtonZeichenattributeClick(Sender: TObject);
    procedure ButtonParagraphClick(Sender: TObject);
    procedure ButtonHeadClick(Sender: TObject);
    procedure ButtonListeClick(Sender: TObject);
    procedure ButtonBreakClick(Sender: TObject);
    procedure MaskEditSpaltenChange(Sender: TObject);
    procedure MaskEditReihenChange(Sender: TObject);
    procedure StringGridFramesetGetEditMask(Sender: TObject; ACol,
      ARow: Integer; var Value: String);
    procedure ButtonFrameSetDefClick(Sender: TObject);
    procedure StringGridFramesetDblClick(Sender: TObject);
    procedure OkClick(Sender: TObject);
    procedure PageControlHyperlinksChange(Sender: TObject);
    procedure Frameseteditieren1Click(Sender: TObject);
    procedure ButtonKommentarClick(Sender: TObject);
    procedure ButtonTitleClick(Sender: TObject);
    procedure ButtonSeiteClick(Sender: TObject);
    procedure ButtonSeitentitelClick(Sender: TObject);
    procedure ButtonMetaClick(Sender: TObject);
    procedure ButtonTargetNewbrowserClick(Sender: TObject);
    procedure ButtonTargetBeforeframeClick(Sender: TObject);
    procedure ButtonTargetTopClick(Sender: TObject);
    procedure ButtonNurDateiClick(Sender: TObject);
    procedure Metaanweisungeinfgen1Click(Sender: TObject);
    procedure Metaanweisungunteneinfgen1Click(Sender: TObject);
    procedure Metaanweisunglschen1Click(Sender: TObject);
    procedure NeueMetaschablone1Click(Sender: TObject);
    procedure Metaanweisungberschreiben1Click(Sender: TObject);
    procedure ButtonSeitenanalyseClick(Sender: TObject);
    procedure ButtonColorClick(Sender: TObject);
    procedure ButtonColorDefineClick(Sender: TObject);
    procedure CheckBoxKeineGroesseClick(Sender: TObject);
    procedure ColorDialog1Close(Sender: TObject);
    procedure ButtonHintergrundClick(Sender: TObject);
    procedure ButtonHintergrundNurDateiClick(Sender: TObject);
    procedure ButtonDateiHintergrundClick(Sender: TObject);
    procedure ButtonNurDateinameClick(Sender: TObject);
    procedure ButtonLowResBrowserClick(Sender: TObject);
    procedure ButtonLowNurDateiClick(Sender: TObject);
    procedure CheckBoxEinpassenClick(Sender: TObject);
    procedure ImageGrafiklinkProgress(Sender: TObject;
      Stage: TProgressStage; PercentDone: Byte; RedrawNow: Boolean;
      const R: TRect; const Msg: String);
    procedure UpDownRahmenClick(Sender: TObject; Button: TUDBtnType);
    procedure ButtonBildgroesseClick(Sender: TObject);
    procedure ButtonKeineBildgroesseClick(Sender: TObject);
    procedure EinfuegenClick(Sender: TObject);
    procedure Kopieren1Click(Sender: TObject);
    procedure Ausschneiden1Click(Sender: TObject);
    procedure Loeschen1Click(Sender: TObject);
    procedure Allesauswaehlen1Click(Sender: TObject);
    procedure Zeilenumbruchumschalten1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure AbbrechenClick(Sender: TObject);
    procedure EditSelectedKeyPress(Sender: TObject; var Key: Char);
    procedure TimerSetupTimer(Sender: TObject);
    procedure StringGridFramesetGetEditText(Sender: TObject; ACol,
      ARow: Integer; var Value: String);
    procedure StringGridFramesetSetEditText(Sender: TObject; ACol,
      ARow: Integer; const Value: String);
    procedure StringGridFramesetSelectCell(Sender: TObject; Col,
      Row: Integer; var CanSelect: Boolean);
    procedure Suchen1Click(Sender: TObject);
    procedure Tauschen1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure ReplaceDialog1Replace(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure RichEditAbsatzChange(Sender: TObject);
    procedure SpeedButtonSyntaxClick(Sender: TObject);
    procedure RadioGroupListentypClick(Sender: TObject);
    procedure ButtonLinklisteClick(Sender: TObject);
    procedure MaskEditFormSpaltenChange(Sender: TObject);
    procedure MaskEditFormReihenChange(Sender: TObject);
    procedure MaskEditSpanColsChange(Sender: TObject);
    procedure MaskEditSpanRowsChange(Sender: TObject);
    procedure StringGridTablesClick(Sender: TObject);
    procedure StringGridTablesDrawCell(Sender: TObject; Col, Row: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure ButtonTablesClick(Sender: TObject);
    procedure ButtonTHClick(Sender: TObject);
    procedure ButtonTDClick(Sender: TObject);
    procedure EditZelltypChange(Sender: TObject);
    procedure RichEditTabCellKeyPress(Sender: TObject; var Key: Char);
    procedure ButtonTabCellEditorClick(Sender: TObject);
    procedure StringGridFramesetClick(Sender: TObject);
    procedure ButtonFrameZellEditorClick(Sender: TObject);
    procedure ButtonAnchorsClick(Sender: TObject);
    procedure ButtonNeuBrowserClick(Sender: TObject);
    procedure ButtonWieVorFramesClick(Sender: TObject);
    procedure ButtonGanzFensterClick(Sender: TObject);
    procedure RichEditFramesetKeyPress(Sender: TObject; var Key: Char);
    procedure StringGridTablesTopLeftChanged(Sender: TObject);
    procedure StringGridTablesSelectCell(Sender: TObject; Col, Row: Integer;
      var CanSelect: Boolean);
    procedure StringGridTablesKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private-Deklarationen }
    tagstart, tagend:        Integer;
    pairstart, pairend:      Integer;
    OldSelStart:             Integer;
    OldSelLength:            Integer;
    Setup:                   Boolean;
    ChangeCell:              Boolean;
    UndoText:                String;
    StartTag:                String;
    EndTag:                  String;
    lastArgpos:              Integer;
    lastArgEnd:              Integer;
    definiert:               BOOLEAN;
    AktiverEditor:           TRichEdit;
    pressedKey:              WORD;
    procedure warte (ms: Integer);
    procedure setFrameStringGrid;
    procedure setTableStringGrid;
    function getArg (Edit: TRichEdit; Start: Integer; Argname: String; Laen: Integer; Lowercase: Boolean): String;
    function getFrame (Start: Integer; VAR between: String): String;

    function SelectSingleTag (Editor: TRichEdit; Start: Integer; tagname: String;
                                         var tagcontent: String): Integer;
    function SelectTag (Editor: TRichEdit; Start: Integer; tagname: String;
                        var tagbody: String): Integer;
    function SelectCellCont (Editor: TRichedit; Start: Integer; tagname: String;
                             var tagcontent: String): Integer;
    procedure SeitenAnalyse (erneut: Boolean);
    procedure TitelAnalyse;
    procedure TabellenAnalyse;
    procedure FrameAnalyse;
    procedure LinkAnalyse;
    procedure LinkListenAnalyse;
    procedure ZielAnalyse;
    procedure GrafikAnalyse;
    procedure LinienAnalyse;
    procedure FontAnalyse;
    procedure ZeichenAnalyse;
    procedure ParagraphAnalyse;
    procedure ListingAnalyse;
    procedure HeadAnalyse;
    procedure BreakAnalyse;
    procedure KommentarAnalyse;
    procedure GrafikLaden (FileName: String);
  public
    { Public-Deklarationen }
    MeinEditor: TEditForm;
    constructor create (AOwner: TComponent); override;
    function winColor (bodycolor: String): TColor;
    function webColor (color: TColor): String;
    procedure selectTab;
  end;

var
  HyperlinkForm1: THyperlinkForm1;

function upPos (Substr: string; S: string): Integer;

implementation

uses SmallLittleFrame, SDateimanager, Frameedit, {xGif,} Clipbrd;

{$R *.DFM}

(*************************** allgemeine Utilities **************************)

function upPos (Substr: string; S: string): Integer;
begin
  Result := pos (AnsiUpperCase (Substr), AnsiUpperCase (S));
end;

function THyperlinkForm1.getArg (Edit: TRichEdit; Start: Integer; Argname: String;
                                 Laen: Integer; Lowercase: Boolean): String;
VAR argpos:   Integer;
    i:        Integer;
    arg:      String;
    quoted:   BOOLEAN;
CONST Tokenset: SET OF CHAR = [' '..#255] - [' ', '=', '"', '<', '>'];
BEGIN
  Result := '';
  WITH Edit DO BEGIN
    argpos := findtext (Argname, Start, Laen, [stWholeWord]);
    IF argpos > 0 THEN BEGIN
      lastArgpos := argpos;
      i := argpos + Length (Argname) + 1;
      WHILE (Text [i] IN [' ', '=']) AND (i < Start + Laen) DO
        INC (i);
      IF Text [i] = '"' THEN BEGIN
        quoted := TRUE; INC (i);
        WHILE Text [i] = ' ' DO INC (i);
      END (* IF quoted *)
      ELSE quoted := FALSE;
      IF Text [i] IN Tokenset THEN BEGIN
        arg := ''; SelStart := i - 1;
//showMessage (Copy (Text, i, Laen));
//showMessage ('Argname: ' + Argname + '; Text [i]: "' + Text [i] + '"');
        WHILE ((Text [i] IN Tokenset) OR (quoted AND (Text [i] <> '"')))
               AND (i <= Start + Laen) DO BEGIN
          arg := arg + Text [i]; INC (i);
        END (* WHILE *);
        IF quoted AND (Text [i] <> '"') THEN
          showMessage ('Bei Argument von ' + Argname +
            ' fehlt schliessendes ("), gefunden: (' + Text [i-1] + ')');
        IF Lowercase THEN Result := ANSILowerCase (arg)
        ELSE Result := arg;
        SelLength := Length (arg);
      END (* IF Text [i] *);
      lastArgEnd := i;
    END (* IF argpos > 0 *);
//showMessage ('getArg ' + Argname + ', ' + IntToStr (argpos) + '; Start: ' +
//             IntToStr (Start) + '; Laen: ' + IntToStr (Laen) +
//             '; arg: ' + arg);
  END (* WITH *);
END (* getArg *);

procedure THyperlinkForm1.ButtonUndoClick(Sender: TObject);
begin
  EditSelected.Text := UndoText;
  definiert := FALSE;
end;

procedure THyperlinkForm1.ButtonDateibrowserClick(Sender: TObject);
VAR  mr:      TModalResult;
     DatMan:  TDateiManagerForm;
begin
  DatMan := TDateiManagerForm.ECreate (Self, FALSE, 'Hyperlink suchen', 'Link laden', '', '',
             LRFrame.Konfig.DateifilterIndex, TRUE, TRUE, FALSE, FALSE);
  WITH DatMan AS TDateiManagerForm DO BEGIN
{    Caption := 'Hyperlink suchen';
    DateiFilterComboBox.ItemIndex := LRFrame.DateiFilterIndex;
    ButtonLaden.Enabled := TRUE; (* hm ... *)
    ButtonLaden.Default := TRUE;}
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      LRFrame.Konfig.DateiFilterIndex := DateiFilterComboBox.ItemIndex;
//showMessage (ComboBoxDateiauswahlHistory.Text);
      EditLinkZiel.Text := ComboBoxDateiauswahlHistory.Text;
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end (* ButtonDateibrowserClick *);

procedure THyperlinkForm1.UebernehmenClick(Sender: TObject);
VAR Start:  Integer;
begin
  IF MeinEditor <> NIL THEN BEGIN
//showMessage (MeinEditor.Classname);
    WITH MeinEditor DO BEGIN
      Editor.SelStart := OldSelStart;
      Editor.SelLength := OldSelLength;
      Start := Editor.SelStart;
      Editor.ReadOnly := FALSE;
//      Editor.SelText := EditSelected.Text;
      EditSelected.SelectAll;
      IF EditSelected.SelLength <= 2 THEN Exit;
      EditSelected.SelLength := EditSelected.SelLength - 2;
      warte (600);
      EditSelected.CopyToClipboard;
      Editor.PasteFromClipboard;
      Editor.SelStart := Start;
      Editor.SelLength := Length (EditSelected.Text); //???
      Editor.ReadOnly := TRUE;
      UndoText := EditSelected.Text;
    END (* WITH *);
  END
  ELSE;
end (* UebernehmenClick *);

(******************************** Hyperlink-Form *****************************)

constructor THyperlinkForm1.create;
begin
//IF AOwner = NIL THEN showMessage ('HLFormcreate Owner NIL')
//ELSE showMessage ('HLFormcreate: ' + AOwner.Classname);
  IF AOwner IS TEditForm THEN MeinEditor := AOwner AS TEditForm;
  inherited create (AOwner);
end;

procedure THyperlinkForm1.SelectTab;
begin
  IF LRFrame.ActiveMDIChild IS TEditForm THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
        WITH PageControlHyperlinks DO BEGIN
//showMessage ('tagname: "' + tagname + '"');
          IF tagname = 'a' THEN BEGIN
            IF upPos ('name', EditSelected.Text) > 0 THEN
              ActivePage := TabSheetAnker
            ELSE
              ActivePage := TabSheetHyperlinks;
          END
          ELSE IF tagname = 'img' THEN BEGIN
            ActivePage := TabSheetGrafik;
          END
          ELSE IF tagname = 'hr' THEN BEGIN
            ActivePage := TabSheetLinien;
          END
          ELSE IF tagname = 'font' THEN BEGIN
            ActivePage := TabSheetFont;
          END
          ELSE IF tagname = 'p' THEN BEGIN
            ActivePage := TabSheetParagraph;
          END
          ELSE IF ((tagname [1] = 'h') AND (tagname [2] IN ['1'..'9']))
                  THEN BEGIN
            ActivePage := TabSheetHead;
          END
          ELSE IF (tagname = 'ul') OR (tagname = 'ol') THEN BEGIN
            ActivePage := TabSheetListing;
          END
          ELSE IF tagname = 'br' THEN BEGIN
            ActivePage := TabSheetBreak;
          END
          ELSE IF tagname = 'table' THEN BEGIN
            ActivePage := TabSheetTables
          END
          ELSE IF tagname = 'frameset' THEN BEGIN
            ActivePage := TabSheetFrames;
          END
          ELSE IF tagname = 'html' THEN BEGIN
            ActivePage := TabSheetSeite;
          END
          ELSE IF tagname = 'title' THEN BEGIN
            ActivePage := TabSheetTitle;
          END
          ELSE IF tagname = 'base' THEN BEGIN
            ActivePage := TabSheetBase;
          END
          ELSE IF tagname = '!--' THEN BEGIN
            ActivePage := TabSheetKommentar;
          END
          ELSE IF (tagname = 'b') OR (tagname = 'i') OR (tagname = 'tt') OR
                  (tagname = 'big') OR (tagname = 'small') OR (tagname = 'em')
          THEN BEGIN
            ActivePage := TabSheetZeichen;
          END
          ELSE BEGIN
            ActivePage := TabSheetZeichen;
          END;
        END (* WITH *);
    END (* WITH *);
    warte (1000);
    PageControlHyperlinksChange (Self)
  END
  ELSE;
end (* SelectTab *);

procedure THyperlinkForm1.OkClick(Sender: TObject);
begin
  IF NOT definiert THEN BEGIN
    WITH PageControlHyperlinks DO BEGIN
      IF ActivePage = TabSheetSeite THEN
        ButtonSeiteClick (Sender)
      ELSE IF ActivePage = TabSheetTitle THEN
        ButtonTitleClick (Sender)
      ELSE IF ActivePage = TabSheetHyperlinks THEN
        ButtonLinkErzeugenClick(Sender)
      ELSE IF ActivePage = TabSheetAnker THEN
        ButtonSprungzielClick(Sender)
      ELSE IF ActivePage = TabSheetGrafik THEN
        ButtonGrafikLinkClick(Sender)
      ELSE IF ActivePage = TabSheetLinien THEN
        ButtonHorizontalLineClick(Sender)
      ELSE IF ActivePage = TabSheetFont THEN
        ButtonFontClick(Sender)
      ELSE IF ActivePage = TabSheetZeichen THEN
        ButtonZeichenattributeClick(Sender)
      ELSE IF ActivePage = TabSheetBreak THEN
        ButtonBreakClick(Sender)
      ELSE IF ActivePage = TabSheetParagraph THEN
        ButtonParagraphClick(Sender)
      ELSE IF ActivePage = TabSheetHead THEN
        ButtonHeadClick(Sender)
      ELSE IF ActivePage = TabSheetListing THEN
        ButtonListeClick(Sender)
      ELSE IF ActivePage = TabSheetTables THEN
        ButtonTablesClick(Sender)
      ELSE IF ActivePage = TabSheetFrames THEN
        ButtonFrameSetDefClick(Sender)
      ELSE IF ActivePage = TabSheetForms THEN
      ELSE IF ActivePage = TabSheetBase THEN
      ELSE IF ActivePage = TabSheetKommentar THEN
        ButtonKommentarClick (Sender)
      ELSE IF ActivePage = TabSheetLinkListe THEN
        ButtonLinkListeClick (Sender);
    END (* WITH *);
  END (* IF NOT definiert *);
  LRFrame.SyntaxHighlight (EditSelected);
  warte (600);
  UebernehmenClick(Sender);
  Close;
end (* OkClick *);

procedure THyperlinkForm1.PageControlHyperlinksChange(Sender: TObject);
begin
// Werte in neuem Register setzen
// showMessage ('HyperlinksChange');
// Exit;
    WITH PageControlHyperlinks DO BEGIN
      IF ActivePage = TabSheetSeite THEN
        SeitenAnalyse (FALSE)
      ELSE IF ActivePage = TabSheetTitle THEN
        TitelAnalyse
     ELSE IF ActivePage = TabSheetHyperlinks THEN BEGIN
        LinkAnalyse;
        ZielAnalyse;
      END
      ELSE IF ActivePage = TabSheetAnker THEN BEGIN
        LinkAnalyse;
        ZielAnalyse;
      END
      ELSE IF ActivePage = TabSheetLinkListe THEN
        LinkListenAnalyse
      ELSE IF ActivePage = TabSheetGrafik THEN
        GrafikAnalyse
      ELSE IF ActivePage = TabSheetLinien THEN
        LinienAnalyse
      ELSE IF ActivePage = TabSheetFont THEN
        FontAnalyse
      ELSE IF ActivePage = TabSheetZeichen THEN
        ZeichenAnalyse
      ELSE IF ActivePage = TabSheetBreak THEN
        BreakAnalyse
      ELSE IF ActivePage = TabSheetParagraph THEN
        ParagraphAnalyse
      ELSE IF ActivePage = TabSheetHead THEN
        HeadAnalyse
      ELSE IF ActivePage = TabSheetListing THEN
        ListingAnalyse
      ELSE IF ActivePage = TabSheetTables THEN
        TabellenAnalyse
      ELSE IF ActivePage = TabSheetFrames THEN
        FrameAnalyse
      ELSE IF ActivePage = TabSheetForms THEN
        //FormAnalyse
      ELSE IF ActivePage = TabSheetBase THEN
        //BaseAnalyse
      ELSE IF ActivePage = TabSheetKommentar THEN
        KommentarAnalyse;
      ;
    END (* WITH *);
end;

(************************************ Seite ************************************)

procedure THyperLinkForm1.SeitenAnalyse (erneut: Boolean);
VAR HeadStart, TitleStart, MetaStart:   Integer;
    BodyStart, BodyLen, i:              Integer;
    BodyColor, DialogColor:             String;
    TitleEnd:                           Integer;
    tagbody:                            String;
begin
  IF NOT erneut THEN BEGIN //RichEditSeite.Text := EditSelected.Text;
// showMessage ('Seitenanalyse');
    EditSelected.SelectAll; EditSelected.CopyToClipboard;
    RichEditSeite.Clear; RichEditSeite.PasteFromClipboard;
  END (* IF NOT *);
  WITH RichEditSeite DO BEGIN
    HeadStart := selectTag (RichEditSeite, 0, 'head', tagbody);
    IF HeadStart >= 0 THEN BEGIN
      TitleStart := selectTag (RichEditSeite, Headstart + Length ('<head>'),
                               'title', tagbody);
      IF tagbody <> '' THEN EditSeitenTitel.Text := tagbody;
      MetaStart := Headstart + Length ('<head>');
      ComboBoxMeta.Clear;
      REPEAT
        MetaStart := selectSingleTag (RicheditSeite, Metastart,
                                 'meta', tagbody);
        IF tagbody <> '' THEN BEGIN
          ComboBoxMeta.Items.Append (tagbody);
          INC (Metastart, Length (tagbody) + Length ('<meta>'));
        END;
        ComboBoxMeta.Itemindex := 0;
      UNTIL tagbody = '';
    END (* IF HeadStart *);
    BodyStart := selectSingleTag (RichEditSeite, 0, 'body', tagbody);
    BodyLen := Length (tagbody) + Length ('<body>');
    IF BodyStart >= 0 THEN BEGIN
      EditHintergrund.Text := getArg (RichEditSeite, BodyStart, 'background', BodyLen, false);

      IF FileExists (EditHintergrund.Text) {AND ()} THEN BEGIN
        TRY
          WITH ImageHintergrund.Picture DO BEGIN
            LoadFromFile (EditHintergrund.Text);
          END (* WITH *);
        EXCEPT
          showMessage ('Kann Datei "' + EditHintergrund.Text + '" nicht als Grafik laden!');
        END;
      END (* IF versuche Grafikdatei fr Hintergrund zu laden *);

//showMessage (getArg (RichEditSeite, BodyStart, 'bgproperties', BodyLen, TRUE));
      CheckBoxBackFix.Checked := getArg (RichEditSeite, BodyStart, 'bgproperties', BodyLen, TRUE) = 'fixed';

      BodyColor := getArg (RichEditSeite, BodyStart, 'bgcolor', BodyLen, false);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        PanelBodyColor.Color := winColor (BodyColor);
      END (* IF BodyColor *);
      BodyColor := getArg (RichEditSeite, BodyStart, 'text', BodyLen, false);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        PanelTextColor.Color := winColor (BodyColor);
      END (* IF BodyColor *);
      BodyColor := getArg (RichEditSeite, BodyStart, 'link', BodyLen, false);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        PanelLinkColor.Color := winColor (BodyColor);
      END (* IF BodyColor *);
      BodyColor := getArg (RichEditSeite, BodyStart, 'vlink', BodyLen, false);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        PanelVLinkColor.Color := winColor (BodyColor);
      END (* IF BodyColor *);
      BodyColor := getArg (RichEditSeite, BodyStart, 'alink', BodyLen, false);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        PanelALinkColor.Color := winColor (BodyColor);
      END (* IF BodyColor *);
    END (* IF *);
  END (* WITH *);
end (* SeitenAnalyse *);

procedure THyperlinkForm1.ButtonSeitentitelClick(Sender: TObject);
VAR HeadStart, TitleStart:              Integer;
    TitleEnd:                           Integer;
    tagbody:                            String;
begin
  WITH RichEditSeite DO BEGIN
    HeadStart := selectTag (RichEditSeite, 0, 'head', tagbody);
    IF HeadStart >= 0 THEN BEGIN
      TitleStart := selectTag (RichEditSeite, Headstart + Length ('<head>'),
                               'title', tagbody);
//showMessage ('TitleStart: ' + IntToStr (TitleStart) + ', tagbody: ' + tagbody);
      IF TitleStart < 0 THEN BEGIN
        SelStart := HeadStart + Length ('<head>'); SelLength := 0;
        SelText := '<title>' + EditSeitenTitel.Text + '</title>';
      END
      ELSE
        SelText := EditSeitenTitel.Text;
    END (* IF HeadStart *);
  END (* WITH *);
end;

procedure THyperlinkForm1.ButtonMetaClick(Sender: TObject);
VAR HeadStart, MetaStart:              Integer;
    MetaEnd:                           Integer;
    tagcontent, metatag:               String;
    i:                                 Integer;
begin
  WITH RichEditSeite DO BEGIN
    HeadStart := selectTag (RichEditSeite, 0, 'head', tagcontent);
    IF HeadStart >= 0 THEN BEGIN
      MetaStart := selectSingleTag (RichEditSeite, Headstart + Length ('<head>'),
                               'meta', tagcontent);
//showMessage ('TitleStart: ' + IntToStr (TitleStart) + ', tagbody: ' + tagbody);
      IF MetaStart < 0 THEN BEGIN
        MetaStart := HeadStart + Length ('<head>'); SelLength := 0;
        MetaEnd := MetaStart;
      END
      ELSE BEGIN
        MetaEnd := findText ('>', MetaStart + 1, GetTextLen, []);
      END (* ELSE *);
      FOR i := 0 TO ComboBoxMeta.Items.Count - 1 DO BEGIN
        SelStart := MetaStart; SelLength := MetaEnd - MetaStart + 1;
        metatag := '<meta ' + ComboBoxMeta.Items [i] + '>';
        IF tagcontent = '' THEN metatag := #13#10 + metatag;
        SelText := metatag;
        MetaEnd := SelStart + SelLength;
        MetaStart := selectSingleTag (RichEditSeite, MetaEnd, 'meta', tagcontent);
        IF MetaStart < 0 THEN MetaStart := MetaEnd + 2
        ELSE
          MetaEnd := findText ('>', Metastart + 1, GetTextLen, []);
      END (* FOR *);
// berzhlige Metatags entfernen:
      WHILE tagcontent <> '' DO BEGIN
        IF MetaStart >= 0 THEN BEGIN
          MetaEnd := findText ('>', Metastart + 1, GetTextLen, []);
          IF Text [MetaEnd + 2] = #13 THEN INC (MetaEnd);
          IF Text [MetaEnd + 2] = #10 THEN INC (MetaEnd);
          SelStart := MetaStart; SelLength := MetaEnd - MetaStart + 1;
          SelText := '';
        END (* IF *);
        MetaStart := selectSingleTag (RichEditSeite, MetaEnd, 'meta', tagcontent);
      END (* WHILE *);
    END (* IF HeadStart *);
  END (* WITH *);
end (* ButtonMetaClick *);

(**************************************** Titel *******************************)

procedure THyperLinkForm1.TitelAnalyse;
VAR  Itemstart, Itemend: Integer;
begin
  WITH EditSelected DO BEGIN
    Itemstart := upPos ('>', Text) + 1;
    IF Itemstart > 0 THEN BEGIN
      EditTitle.Text := Copy (Text, Itemstart, Length (Text));
//      Itemend := upPos ('<', EditTitle.Text);
      Itemend := upPos (Endtag, EditTitle.Text);
      IF Itemend > 0 THEN
        EditTitle.Text :=
          Copy (EditTitle.Text, 1, Itemend - 1);
    END (* IF Itemstart *)
    ELSE EditTitle.Text := Text;
  END (* WITH *);
end (* TitelAnalyse *);

procedure THyperlinkForm1.ButtonTitleClick(Sender: TObject);
begin
  EditSelected.Text := '<title>' + EditTitle.Text + '</title>';
  definiert := TRUE;
end;

procedure THyperlinkForm1.ButtonSeiteClick(Sender: TObject);
begin
  ButtonSeitentitelClick (Sender);
  ButtonMetaClick (Sender);
  ButtonColorDefineClick (Sender);
  ButtonHintergrundClick(Sender);
//  EditSelected.Text := RichEditSeite.Text;
  RichEditSeite.SelectAll; RichEditSeite.CopyToClipboard;
  EditSelected.Clear; EditSelected.PasteFromClipboard;
end;

(****************************** Hyperlinks ***********************************)

procedure THyperlinkForm1.Linkanalyse;
VAR  Itemstart, Itemend: Integer;
     Crossstart:         Integer;
     subjectstart:       Integer;
begin
  WITH EditSelected DO BEGIN
    EditLinkZiel.Text := getArg (EditSelected, 0, 'href', getTextLen, FALSE);
    IF (EditLinkZiel.Text <> '') THEN BEGIN
      Crossstart := pos ('#', EditLinkZiel.Text);
//      IF (EditLinkZiel.Text [1] = '#') THEN BEGIN
      IF Crossstart > 0 THEN BEGIN
        RadiogroupLinkart.Itemindex := 1;
        EditLokalLink.Text := Copy (EditLinkZiel.Text, Crossstart + 1, Length (EditLinkZiel.Text));
        EditLinkZiel.Text := Copy (EditLinkZiel.Text, 1, Crossstart - 1);
      END (* IF '#' *)
      ELSE IF upPos ('mailto:', EditLinkZiel.Text) = 1 THEN BEGIN
        RadiogroupLinkart.Itemindex := 2;
        EditLinkZiel.Text := Copy (EditLinkZiel.Text, Length ('mailto:') + 1, Length (EditLinkZiel.Text));
        subjectstart := upPos ('?subject=', EditLinkZiel.Text);
        IF subjectstart > 0 THEN BEGIN
          EditSubject.Text :=
            Copy (EditLinkZiel.Text, subjectstart + Length ('?subject='),
              Length (EditLinkZiel.Text));
          EditLinkZiel.Text := Copy (EditLinkZiel.Text, 1, subjectstart - 1);
        END (* IF subject *);
      END;
    END (* IF <> '' *)
    ELSE EditLinkZiel.Text := (LRFrame.ActiveMDIChild AS TEditForm).lastUrl;
    EditTarget.Text := getArg (EditSelected, 0, 'target', getTextLen, FALSE);
    IF EditTarget.Text = '' THEN
      EditTarget.Text := (LRFrame.ActiveMDIChild AS TEditForm).lastTarget;

    Itemstart := upPos ('>', Text) + 1;
    IF Itemstart > 0 THEN BEGIN
      EditSelektierterText.Text := Copy (Text, Itemstart, Length (Text));
//      Itemend := upPos ('<', EditSelektierterText.Text);
      Itemend := upPos (Endtag, EditSelektierterText.Text);
      IF Itemend > 0 THEN BEGIN
        EditSelektierterText.Text :=
          Copy (EditSelektierterText.Text, 1, Itemend - 1);
      END (* IF *);
    END (* IF Itemstart *)
    ELSE EditSelektierterText.Text := Text;
  END (* WITH *);
end (* Linkanalyse *);

procedure THyperlinkForm1.Zielanalyse;
VAR  Itemstart, Itemend: Integer;
begin
  WITH EditSelected DO BEGIN
    EditLokalesLinkZiel.Text := getArg (EditSelected, 0, 'name', getTextLen, FALSE);
//    EditTarget1.Text := getArg (EditSelected, 0, 'target', getTextLen, FALSE);
    Itemstart := upPos ('>', Text) + 1;
    IF Itemstart > 0 THEN BEGIN
      EditSprungziel.Text := Copy (Text, Itemstart, Length (Text));
//      Itemend := upPos ('<', EditSprungziel.Text);
      Itemend := upPos (Endtag, EditSprungziel.Text);
      IF Itemend > 0 THEN
        EditSprungziel.Text :=
          Copy (EditSprungziel.Text, 1, Itemend - 1);
    END (* IF Itemstart *)
    ELSE EditSprungziel.Text := Text;
  END (* WITH *);
end (* Zielalyse *);

procedure THyperlinkForm1.ButtonLinkErzeugenClick(Sender: TObject);
VAR target:  String;
    subject: String;
begin
  MeinEditor.LastUrl := EditLinkZiel.Text;
  CASE RadioGroupLinkart.ItemIndex OF
    0: BEGIN // Normaler Link
      IF EditTarget.Text <> '' THEN target := ' target="' + EditTarget.Text + '"';
      EditSelected.Text := '<a href="' + EditLinkZiel.Text + '"' + target + '>' +
        EditSelektierterText.Text +
        '</a>';
//        EditStarttag.Text := '<a>'; EditEndtag.Text := '</a>';
      END;
    1: BEGIN // Lokaler Link
      IF (EditTarget.Text <> '') AND (EditTarget.Text [1] <> '_') THEN
        MeinEditor.lastTarget := EditTarget.Text;
      IF EditTarget.Text <> '' THEN target := ' target="' + EditTarget.Text + '"';
      EditSelected.Text := '<a href="' + EditLinkZiel.Text + '#' + EditLokalLink.Text +
                           '"' + target + '>' +
        EditSelektierterText.Text +
        '</a>';
       END;
    2: BEGIN // Mail-Link
      IF EditSubject.Text <> '' THEN
        subject := '?subject=' + EditSubject.Text
      ELSE subject := '';
      EditSelected.Text := '<a href="mailto:' + EditLinkZiel.Text + subject + '">' +
        EditSelektierterText.Text +
        '</a>';
       END;
  END (* CASE *);
  definiert := TRUE;
end (* ButtonLinkerzeugenClick *);

procedure THyperlinkForm1.ButtonSprungzielClick(Sender: TObject);
//VAR target: String;
begin
//  IF EditTarget1.Text <> '' THEN
//    target := ' target="' + EditTarget1.Text + '"';

  EditSelected.Text := '<a name="' + EditLokalesLinkZiel.Text + '"'
    + '>' +
    EditSprungziel.Text +
    '</a>';
//    EditStarttag.Text := '<a>'; EditEndtag.Text := '</a>';
  definiert := TRUE;
end;

procedure THyperlinkForm1.ButtonRemoveLinkClick(Sender: TObject);
begin
  IF (ActiveMDIChild <> NIL) AND (ActiveMDIChild IS TEditForm) THEN BEGIN
    WITH ActiveMDIChild AS TEditForm DO BEGIN
      IF NOT TagSelected THEN BEGIN
        showMessage ('Bitte zuerst Tag selektieren und prfen');
        EXIT;
      END (* NOT TagSelected *);
    END (* WITH *);
  END (* IF *);
end;

(*********************************** Linkliste *******************************)


procedure THyperlinkForm1.ButtonNeuBrowserClick(Sender: TObject);
begin
  EditLinkListTarget.Text := '_new';
end;

procedure THyperlinkForm1.ButtonWieVorFramesClick(Sender: TObject);
begin
  EditLinkListTarget.Text := '_parent';
end;

procedure THyperlinkForm1.ButtonGanzFensterClick(Sender: TObject);
begin
  EditLinkListTarget.Text := '_top';
end;

procedure THyperlinkForm1.LinkListenAnalyse;
VAR hstart, hend, lineStart:     Integer;
    tagbody:                     String;
begin
  WITH EditSelected DO BEGIN
    SelectAll;
    IF SelLength <= 2 THEN Exit;
    SelLength := SelLength - 2;
    CopyToClipboard;
    WITH RichEditLinklist DO BEGIN
      Clear; PasteFromClipboard;
      warte (600);
//  Die Frage ist: Wieweit knnen wir die Linktags in einer Liste automatisch
// entfernen ... hm, wenn SpeedButtonRemoveTagsClick das kann ...
      hstart := SelectTag (RichEditLinkList, 0, 'a', tagbody);
      IF (hstart >= 0) AND (upPos ('<br', Text) > 0) THEN
        CheckBoxLinkbreaks.Checked := FALSE; // sind schon drin!
      lineStart := 0;
      WHILE hstart >= 0 DO BEGIN
        IF upPos ('<a href="', Text) = tagstart + 1 THEN BEGIN
// Prefix entfernen:
          SelStart := lineStart; // tagstart;
          SelLength := tagstart - lineStart;
          IF SelLength > 0 THEN BEGIN
            EditUnmarkedPrefix.Text := SelText;
            SelText := '';
          END (* IF *);
// Starttag entfernen:
          SelStart := linestart;
          tagstart := upPos ('">', Text);
          SelLength := Length ('<a href""');
          SelText := '';
          IF (pairstart > 0) AND (tagstart < pairstart) THEN BEGIN
            hstart := upPos ('">', Text) - 1;
            SelStart := hstart;
            SelLength := Length ('">');
            SelText := '';
          END (* IF *);

// Endtag entfernen:
          IF hstart < 0 THEN hstart := upPos ('</a>', Text);// DEC (hstart);
          IF hstart > 0 THEN BEGIN
            hend := FindText ('<br>', hstart, GetTextLen, []);
            IF hend < 0 THEN hend := FindText (#10#13, hstart, GetTextLen, []);
            IF hend < 0 THEN hend := hstart + Length ('</a>');
            SelStart := hstart; SelLength := hend - hstart;
            SelText := '';
          END (* Endtag entfernen *);
        END (* IF *)
        ELSE Break;
        hstart := SelectTag (RichEditLinkList, 0, 'a', tagbody);
        lineStart := FindText (#13#10, lineStart + 1, GetTextLen, []) + 2;
      END (* WHILE *);
    END (* WITH RichEditLinkList *);
  END (* WITH EditSelected *);
end (* LinkListenAnalyse *);

procedure THyperlinkForm1.RadioGroupListentypClick(Sender: TObject);
begin
  CASE RadioGroupListentyp.ItemIndex OF
    0:  BEGIN
          EditListingstart.Enabled := FALSE;
          UpDownListingstart.Enabled := FALSE;
          RadioGroupBlockade.Enabled := TRUE;
          RadioGroupNumerierung.Enabled := FALSE;
        END;
    1:  BEGIN
          EditListingstart.Enabled := TRUE;
          UpDownListingstart.Enabled := TRUE;
          RadioGroupBlockade.Enabled := FALSE;
          RadioGroupNumerierung.Enabled := TRUE;
        END;
  END (* CASE *);
end (* RadioGroupListentypClick *);

procedure THyperlinkForm1.ButtonLinklisteClick(Sender: TObject);
VAR  ST:                      TSearchTypes;
     pref, suff, under:       String;
     start, ende, neuende:    Integer;
     target:                  String;

  procedure einfuege (vorn, hinten, underline: String);
  VAR findpos:       Integer;
      Linktext, br:  String;
      Linkstart:     Integer;
      tstart, tend:  Integer;
  begin
    WITH EditSelected DO BEGIN
      findpos := start; neuende := ende;
      WHILE findpos < neuende DO BEGIN
        SelStart := findpos; SelLength := 0;
        SelText := vorn;
        INC (findpos, LENGTH (vorn));
        INC (neuende, LENGTH (vorn));
        Linkstart := findpos;
        WHILE NOT (Text [findpos + 1] IN [#10, #13]) AND
              (findpos < neuende) DO
          INC (findpos);
        IF Text [findpos + 1] IN [#10, #13] THEN BEGIN
          IF CheckBoxLinktext.Checked THEN BEGIN
            SelStart := Linkstart; SelLength := findpos - Linkstart;
            Linktext := SelText;
          END
          ELSE BEGIN
            Linktext := '';
            tstart := findText ('{', Linkstart + 1, findpos - Linkstart - 1, []);
            tend := findText ('}', Linkstart + 1, findpos - Linkstart - 1, []);
            IF (tstart >= 0) AND (tend >= 0) THEN BEGIN
              SelStart := tstart; SelLength := tend - tstart + 1;
              Linktext := Copy (SelText, 2, SelLength - 2);
              DEC (neuende, Length (Linktext) + 2); SelText := '';
              DEC (findpos, Length (Linktext) + 2);
            END;
          END (* Nicht CheckboxLinktext *);
          IF CheckBoxPrefix.Checked THEN
            Linktext := underline + Linktext;
          IF CheckBoxLinkbreaks.Checked THEN br := '<br>'
          ELSE br := '';
          SelStart := findpos;
          SelText := '"' + target + '>' + Linktext + hinten + br;
          INC (neuende, LENGTH (target) + LENGTH (hinten) + Length (Linktext) + Length (br) + 2);
          findpos := SelStart + SelLength;
          WHILE (Text [findpos + 1] IN [#10, #13]) AND (findpos < neuende) DO
            INC (findpos);
        END (* IF *)
        ELSE break;
      END (* WHILE *);
//      SelStart := GetTextLen; SelLength := 0;
//      SelText := '">' + hinten;
    END (* WITH RichEditListing *);
  end (* einfuege *);

begin (* ButtonLinklisteClick *)
  UndoText := EditSelected.Text;
  WITH RichEditLinklist DO BEGIN
    ST := [];
    start := 0; ende := GetTextLen;
    SelectAll; SelLength := SelLength - 2;
    warte (600);
    CopyToClipboard;
    EditSelected.Clear; EditSelected.PasteFromClipboard;
    warte (600);
    StartTag := '<a href="'; EndTag := '</a>';
    IF CheckBoxPrefix.Checked THEN pref := EditUnmarkedPrefix.Text + StartTag
    ELSE pref := StartTag;

    IF CheckBoxURLPrefix.Checked THEN pref := pref + EditURLPrefix.Text;
     CASE RadioGroupAutoLinkart.ItemIndex OF
       1: pref := pref + '#';
       2: pref := pref + 'mailto:';
     END (* CASE *);

     IF EditLinkListTarget.Text <> '' THEN target := ' target="' +
       EditLinkListTarget.Text + '"';

    einfuege (pref, EndTag, EditLinkPrefix.Text);
  END (* WITH RichEditLinkList *);
  definiert := TRUE;
end (* ButtonLinklisteClick *);

procedure THyperlinkForm1.ButtonAnchorsClick(Sender: TObject);
VAR  dok:                  TRichEdit;
     blstart, blend:       Integer;
     astart, aend:         Integer;
     aname, body:          String;
begin
  IF LRFrame.ActiveMDIChild IS TEditForm THEN BEGIN
    WITH LRFrame.ActiveMDIChild AS TEditForm DO BEGIN
      dok := Editor;
      EditURLPrefix.Text := ExtractFileName (Pfadname);
    END (* WITH *);
    IF dok.SelText <> '' THEN BEGIN
      blstart := dok.SelStart; blend := dok.SelLength - dok.SelStart;
    END
    ELSE BEGIN
      blstart := 0; blend := dok.GetTextLen;
    END;
    WITH RichEditLinklist DO BEGIN
      astart := blstart;
      WHILE astart >= 0 DO BEGIN
        astart := SelectTag (dok, astart, 'a', body);
        IF astart >= 0 THEN
          aname := getArg (dok, astart, 'name', pairend - astart, FALSE)
        ELSE aname := '';
        IF aname <> '' THEN RichEditLinklist.Lines.Append (aname + '{' + body + '}');
        astart := astart + Length (aname) + Length (body);
      END (* WHILE *);
    END (* WITH *);
  END (* IF Textdokument on top *);
end (* ButtonAnchorsClick *);

(***************************** Grafik **********************************)

procedure THyperlinkForm1.GrafikLaden (Filename: String);
begin
    IF FileExists (EditGrafikDatei.Text) {AND ()} THEN BEGIN
      TRY
        WITH ImageGrafiklink.Picture DO BEGIN
          LoadFromFile (EditGrafikDatei.Text);
          UpDownHoehe.Position := Height;
          UpDownBreite.Position := Width;
          ImageGrafiklink.Stretch := CheckBoxEinpassen.Checked;
          IF NOT CheckBoxEinpassen.Checked THEN BEGIN
            ScrollBoxGrafik.HorzScrollBar.Range := Width;
            ScrollBoxGrafik.VertScrollBar.Range := Height;
          END
          ELSE BEGIN
            ScrollBoxGrafik.HorzScrollBar.Range := 0;
            ScrollBoxGrafik.VertScrollBar.Range := 0;
          END (* ELSE *);
        END (* WITH *);
      EXCEPT
        showMessage ('Kann Datei "' + EditGrafikDatei.Text + '" nicht als Grafik laden!');
      END;
    END (* IF versuche Grafikdatei zu laden *);
end (* GrafikLaden *);

procedure THyperlinkForm1.Grafikanalyse;
VAR aligns: String;
    updown: String;
begin
  WITH EditSelected DO BEGIN
    EditGrafikDatei.Text := getArg (EditSelected, 0, 'src', getTextLen, TRUE);
    IF EditGrafikDatei.Text = '' THEN EditGrafikDatei.Text := EditSelected.Text;
    GrafikLaden (EditGrafikDatei.Text);

    EditGrafikAlternativ.Text := getArg (EditSelected, 0, 'alt', getTextLen, FALSE);
    EditLowres.Text := getArg (EditSelected, 0, 'lowsrc', getTextLen, TRUE);

    updown := getArg (EditSelected, 0, 'vspace', getTextLen, TRUE);
    IF updown <> '' THEN
      UpDownHorizontal.Position := StrToInt (updown);

    updown := getArg (EditSelected, 0, 'vspace', getTextLen, TRUE);
    IF updown <> '' THEN
      UpDownVertikal.Position := StrToInt (updown);

    updown := getArg (EditSelected, 0, 'border', getTextLen, TRUE);
    IF updown <> '' THEN BEGIN
      UpDownRahmen.Position := StrToInt (updown);
      PanelGrafikVorschau.BorderWidth := UpDownRahmen.Position;
    END (* IF *);

    updown := getArg (EditSelected, 0, 'height', getTextLen, TRUE);
    IF updown <> '' THEN
      UpDownHoehe.Position := StrToInt (updown);

    updown := getArg (EditSelected, 0, 'width', getTextLen, TRUE);
    IF updown <> '' THEN
      UpDownBreite.Position := StrToInt (updown);

    aligns := getArg (EditSelected, 0, 'align', getTextLen, TRUE);
    IF aligns = 'left' THEN
      RadioGroupAusrichtung.ItemIndex := 0
    ELSE if aligns = 'center' THEN
      RadioGroupAusrichtung.ItemIndex := 1
    ELSE if aligns = 'right' THEN
      RadioGroupAusrichtung.ItemIndex := 2;
  END (* WITH *);
end (* Grafikanalyse *);

procedure THyperlinkForm1.ButtonGrafikLinkClick(Sender: TObject);
VAR  Ausrichtung:   String;
     alt:           String;
     low:           String;
     breite, hoehe: String;
begin
  CASE RadioGroupAusrichtung.ItemIndex OF
    0: Ausrichtung := 'left';
    1: Ausrichtung := 'center';
    2: Ausrichtung := 'right';
    ELSE Ausrichtung := '';
  END (* CASE *);
  WITH EditGrafikAlternativ DO BEGIN
    IF Text <> '' THEN alt := 'alt="' + text + '" '
    ELSE alt := '';
  END (* WITH *);
  WITH EditLowres DO BEGIN
    IF Text <> '' THEN low := 'lowsrc="' + text + '"'
    ELSE low := '';
  END (* WITH *);
  IF EditBreite.Text <> '0' THEN
    breite := ' width="' + EditBreite.Text + '"'
  ELSE breite := '';
  IF EditHoehe.Text <> '0' THEN
    hoehe := ' height="' + EditHoehe.Text + '"'
  ELSE hoehe := '';
  EditSelected.Text := '<img src="' + EditGrafikDatei.Text + '" ' +
    low + alt +
    'hspace="' + EditHorizontal.Text +
    '" vspace="' + EditVertikal.Text +
    '" border="' + EditRahmen.Text +
    '" align="' + Ausrichtung + '"' +
    breite + hoehe +
    '>';
  definiert := TRUE;
end (* ButtonGrafikLinkClick *);

procedure THyperlinkForm1.ButtonGrafikBrowserClick(Sender: TObject);
VAR  mr:      TModalResult;
     DatMan:  TDateiManagerForm;
begin
  DatMan := TDateiManagerForm.ECreate (Self, FALSE, 'Hyperlink suchen', 'Link laden', '',
             '*.GIF',
             LRFrame.Konfig.DateifilterIndex, TRUE, TRUE, FALSE, FALSE);
  WITH DatMan AS TDateiManagerForm DO BEGIN
{    Caption := 'Hyperlink suchen';
    DateiFilterComboBox.ItemIndex := LRFrame.DateiFilterIndex;
    ButtonLaden.Enabled := TRUE; (* hm ... *)
    ButtonLaden.Default := TRUE;}
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      LRFrame.Konfig.DateiFilterIndex := DateiFilterComboBox.ItemIndex;
//showMessage (ComboBoxDateiauswahlHistory.Text);
      EditGrafikDatei.Text := Dateiauswahl; //ComboBoxDateiauswahlHistory.Text;

      GrafikLaden (EditGrafikDatei.Text);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end (* ButtonGrafikBrowserClick *);


(****************************** Horizontale Linie ******************************)

procedure THyperlinkForm1.ButtonHorizontalLineClick(Sender: TObject);
VAR schatten: String;
begin
  IF CheckBoxNoshade.Checked THEN schatten := ' noshade' ELSE schatten := '';
  EditSelected.Text := '<hr' + schatten + ' size="' + EditLiniendicke.Text +
    '" width="' + EditLinienbreite.Text + '%">';
//  EditStarttag.Text := '<hr>'; EditEndtag.Text := '';
  definiert := TRUE;
end;

procedure THyperlinkForm1.Linienanalyse;
VAR  upDown: String;
begin
  WITH EditSelected DO BEGIN
    upDown := getArg (EditSelected, 0, 'size', getTextLen, TRUE);
    IF upDown <> '' THEN UpDownLinie.Position := StrToInt (upDown);
    upDown := getArg (EditSelected, 0, 'width', getTextLen, TRUE);
    IF pos ('%', upDown) > 0 THEN Delete (upDown, pos ('%', upDown), 1);
    IF upDown <> '' THEN UpDownLinienbreite.Position := StrToInt (upDown);
    CheckBoxNoshade.Checked := upPos ('noshade', Text) > 0;
  END (* WITH *);
end (* Linienalyse *);

(********************************** Font *************************************)

procedure THyperlinkForm1.ButtonFontClick(Sender: TObject);
VAR relativ, size:    String;
    FontColor:        String;
    Fontbody:         String;
begin
  IF checkboxRelativ.checked THEN
    IF UpDownFontgroesse.position > 0 THEN relativ := '+'
    ELSE relativ := '';

  FontColor := 'color="' + webColor (PanelFontColor.Color) + '"';
  SelectTag (RichEditFont, 0, 'font', Fontbody);
  IF Fontbody = '' then Fontbody := RichEditFont.Text;
  IF EditFontgroesse.Enabled THEN
    size := 'size="' + relativ + EditFontgroesse.Text + '" '
  ELSE size := '';
  EditSelected.Text := '<font ' + size +
                        FontColor + '>' + Fontbody + '</font>';
//  EditStarttag.Text := '<font>'; EditEndtag.Text := '</font>';
  definiert := TRUE;
end (* ButtonFontClick *);

procedure THyperlinkForm1.Fontanalyse;
VAR FontColor: String;
    upDown:    String;
    FontBody:  String;
begin
  WITH EditSelected DO BEGIN
//    RichEditFont.Text := Text;
    SelectAll; CopyToClipboard;
    RichEditFont.Clear;
    RichEditFont.PasteFromClipboard;
    upDown := getArg (EditSelected, 0, 'size', getTextLen, TRUE);
    IF upDown <> '' THEN BEGIN
      CheckBoxKeineGroesse.checked := FALSE;
      EditFontgroesse.Enabled := TRUE; UpDownFontgroesse.Enabled := TRUE;
      UpDownFontgroesse.Position := StrToInt (updown);
    END
    ELSE BEGIN
      CheckBoxKeineGroesse.checked := TRUE;
      EditFontgroesse.Enabled := FALSE; UpDownFontgroesse.Enabled := FALSE;
    END (* ELSE *);
    FontColor := getArg (EditSelected, 0, 'color', getTextLen, FALSE);
    IF FontColor <> '' THEN BEGIN
      PanelFontColor.Color := winColor (FontColor);
      SelectTag (RichEditFont, 0, 'font', Fontbody);
      RichEditFont.SelAttributes.Color := PanelFontColor.Color;
      RichEditFont.SelLength := 0;
    END (* IF FontColor *);
  END (* WITH *);
end (* Fontanalyse *);

(*********************************** Zeichen **********************************)

procedure THyperlinkForm1.ButtonZeichenattributeClick(Sender: TObject);
VAR attributStart, attributEnd: String;
    attribut:                   Integer;
    astr:                       String;

  function remtag (tagstring: String): Integer;
  begin
    WITH EditSelected DO BEGIN
      attribut := findText (tagstring, 0, getTextLen, []);
      Result := attribut;
      IF attribut >= 0 THEN BEGIN
        SelStart := attribut; SelLength := Length (tagstring); SelText := '';
      END (* IF *);
    END (* WITH EditSelected *);
  end (* remtag *);

begin
  attributStart := ''; attributEnd := '';
  IF checkboxBold.checked THEN BEGIN
    attributStart := attributStart + '<b>';
    attributEnd := attributEnd + '</b>';
  END (* IF *);
  IF checkboxItalic.checked THEN BEGIN
    attributStart := attributStart + '<i>';
    attributEnd := attributEnd + '</i>';
  END (* IF *);
  IF checkboxTeletype.checked THEN BEGIN
    attributStart := attributStart + '<tt>';
    attributEnd := attributEnd + '</tt>';
  END (* IF *);
  IF checkboxBig.checked THEN BEGIN
    attributStart := attributStart + '<big>';
    attributEnd := attributEnd + '</big>';
  END (* IF *);
  IF checkboxSmall.checked THEN BEGIN
    attributStart := attributStart + '<small>';
    attributEnd := attributEnd + '</small>';
  END (* IF *);
  IF checkboxEmphasized.checked THEN BEGIN
    attributStart := attributStart + '<em>';
    attributEnd := attributEnd + '</em>';
  END (* IF *);

  WHILE remtag ('<b>') >= 0 DO;
  WHILE remtag ('</b>') >= 0 DO;
  WHILE remtag ('<i>') >= 0 DO;
  WHILE remtag ('</i>') >= 0 DO;
  WHILE remtag ('<tt>') >= 0 DO;
  WHILE remtag ('</tt>') >= 0 DO;
  WHILE remtag ('<big>') >= 0 DO;
  WHILE remtag ('</big>') >= 0 DO;
  WHILE remtag ('<small>') >= 0 DO;
  WHILE remtag ('</small>') >= 0 DO;
  WHILE remtag ('<em>') >= 0 DO;
  WHILE remtag ('</em>') >= 0 DO;

  EditSelected.Text := attributStart +
    EditSelected.Text + attributEnd;
//  EditStarttag.Text := attributStart; EditEndtag.Text := attributEnd;
  definiert := TRUE;
end (* ButtonZeichenAttributeClick *);

procedure THyperlinkForm1.Zeichenanalyse;
begin
  WITH EditSelected DO BEGIN
    CheckBoxBold.checked := findText ('<b>', 0, GetTextLen, []) >= 0;
    CheckBoxItalic.checked := findText ('<i>', 0, GetTextLen, []) >= 0;
    CheckBoxTeletype.checked := findText ('<tt>', 0, GetTextLen, []) >= 0;
    CheckBoxBig.checked := findText ('<big>', 0, GetTextLen, []) >= 0;
    CheckBoxSmall.checked := findText ('<small>', 0, GetTextLen, []) >= 0;
    CheckBoxEmphasized.checked := findText ('<em>', 0, GetTextLen, []) >= 0;
  END (* WITH *);
end (* Zeichenanalyse *);

(************************************ Absatz *********************************)

procedure THyperlinkForm1.ButtonParagraphClick(Sender: TObject);
VAR  Ausrichtung:      String;
begin
  CASE RadioGroupIndent.ItemIndex OF
    0: Ausrichtung := 'left';
    1: Ausrichtung := 'center';
    2: Ausrichtung := 'right';
    3: Ausrichtung := 'justify';
    ELSE Ausrichtung := '';
  END (* CASE *);
  IF Ausrichtung <> '' THEN
    StartTag := '<p align="' + Ausrichtung + '">'
  ELSE
    StartTag := '<p>';
  EndTag := '</p>';
  RichEditAbsatz.SelectAll;
  RichEditAbsatz.SelLength := RichEditAbsatz.SelLength - 2;
  RichEditAbsatz.CopyToClipboard;
  EditSelected.Clear;
  EditSelected.PasteFromClipboard;
  warte (600);
  EditSelected.Selstart := 0; EditSelected.SelLength := 0;
  EditSelected.SelText := StartTag;
  EditSelected.Selstart := EditSelected.GetTextLen; EditSelected.SelLength := 0;
  EditSelected.SelText := EndTag;
  definiert := TRUE;
end (* ButtonParagraphClick *);

procedure THyperlinkForm1.Paragraphanalyse;
VAR  Ausrichtung: String;
     endstart:    Integer;
begin
  WITH EditSelected DO BEGIN
    Ausrichtung := getArg (EditSelected, 0, 'align', getTextLen, TRUE);
    IF Ausrichtung = 'left' THEN RadiogroupIndent.ItemIndex := 0
    ELSE IF Ausrichtung = 'center' THEN RadiogroupIndent.ItemIndex := 1
    ELSE IF Ausrichtung = 'right' THEN RadiogroupIndent.ItemIndex := 2
    ELSE IF Ausrichtung = 'justify' THEN RadiogroupIndent.ItemIndex := 3
    ELSE RadiogroupIndent.ItemIndex := 4;
  END (* WITH *);
  WITH RichEditAbsatz DO BEGIN
//    Text := EditSelected.Text;
    EditSelected.SelectAll;
    IF EditSelected.SelLength <= 2 THEN Exit;
    EditSelected.SelLength := EditSelected.SelLength - 2;
    EditSelected.CopyToClipboard;
    Clear; PasteFromClipboard;
    IF (findText ('<p', 0, GetTextLen, []) = 0) THEN BEGIN
      endstart := findtext ('>', 0, GetTextLen, []);
      Selstart := 0; Sellength := endstart + 1; SelText := '';
      endstart := findtext ('</p>', 0, GetTextLen, []);
      IF endstart >= 0 THEN BEGIN
        Selstart := endstart; Sellength := Length ('</p>');
        SelText := '';
      END (* IF endtag *)
      ELSE showMessage ('Endtag </p> nicht vorhanden');
    END (* IF *);
  END (* WITH *);
end (* Paragraphanalyse *);

(********************************** berschriften ****************************)

procedure THyperlinkForm1.ButtonHeadClick(Sender: TObject);
VAR  Ausrichtung:       String;
     Head:              String;
begin
  CASE RadioGroupHeadAlignement.ItemIndex OF
    0: Ausrichtung := 'left';
    1: Ausrichtung := 'center';
    2: Ausrichtung := 'right';
    3: Ausrichtung := 'justify'
    ELSE Ausrichtung := '';
  END (* CASE *);
  CASE RadioGroupSize.ItemIndex OF
    0: Head := 'h1';
    1: Head := 'h2';
    2: Head := 'h3';
    3: Head := 'h4';
    4: Head := 'h5';
    5: Head := 'h6';
  END (* CASE *);
  StartTag := '<' + Head + ' align="' + Ausrichtung + '">';
  EndTag := '</' + Head + '>';
  EditSelected.Text := StartTag + EditUeberschrift.Text +
    EndTag;
  definiert := TRUE;
end (* ButtonHeadClick *);

procedure THyperlinkForm1.Headanalyse;
VAR  Ausrichtung:        String;
     Itemstart, Itemend: Integer;
begin
  WITH EditSelected DO BEGIN
    Ausrichtung := getArg (EditSelected, 0, 'align', getTextLen, TRUE);
    IF Ausrichtung = 'left' THEN RadiogroupHeadAlignement.ItemIndex := 0
    ELSE IF Ausrichtung = 'center' THEN RadiogroupHeadAlignement.ItemIndex := 1
    ELSE IF Ausrichtung = 'right' THEN RadiogroupHeadAlignement.ItemIndex := 2
    ELSE IF Ausrichtung = 'justify' THEN RadiogroupHeadAlignement.ItemIndex := 3;

    Itemstart := upPos ('>', Text) + 1;
    IF Itemstart > 0 THEN BEGIN
      EditUeberschrift.Text := Copy (Text, Itemstart, Length (Text));
//      Itemend := upPos ('<', EditUeberschrift.Text);
      Itemend := upPos (Endtag, EditUeberschrift.Text);
      IF Itemend > 0 THEN
        EditUeberschrift.Text :=
          Copy (EditUeberschrift.Text, 1, Itemend - 1);
    END (* IF Itemstart *)
    ELSE EditUeberschrift.Text := Text;
  END (* WITH *);
  IF upPos ('h1', StartTag) > 0 THEN RadioGroupSize.ItemIndex := 0
  ELSE IF upPos ('h2', StartTag) > 0 THEN RadioGroupSize.ItemIndex := 1
  ELSE IF upPos ('h3', StartTag) > 0 THEN RadioGroupSize.ItemIndex := 2
  ELSE IF upPos ('h4', StartTag) > 0 THEN RadioGroupSize.ItemIndex := 3
  ELSE IF upPos ('h5', StartTag) > 0 THEN RadioGroupSize.ItemIndex := 4
  ELSE IF upPos ('h6', StartTag) > 0 THEN RadioGroupSize.ItemIndex := 5
end (* Headanalyse *);

(************************************* Listings *******************************)

procedure THyperlinkForm1.ListingAnalyse;
VAR lstart, lend: Integer;
    Blockade:     String;
    tagbody:      String;
    UpDown:       String;
begin
  WITH EditSelected DO BEGIN

    updown := getArg (EditSelected, 0, 'start', getTextLen, TRUE);
    IF updown <> '' THEN
      UpDownListingStart.Position := StrToInt (updown);

    IF (findText ('<ul', 0, GetTextLen, [])= 0) THEN BEGIN
      StartTag := 'ul'; RadioGroupListentyp.Itemindex := 0;
      EndTag := '</ul>';
      EditListingstart.Enabled := FALSE;
      UpDownListingstart.Enabled := FALSE;
      RadioGroupBlockade.Enabled := TRUE;
      RadioGroupNumerierung.Enabled := FALSE;
      Blockade := getArg (EditSelected, 0, 'type', getTextLen, TRUE);
      IF Blockade = 'disc' THEN RadioGroupBlockade.ItemIndex := 0
      ELSE IF Blockade = 'square' THEN RadioGroupBlockade.ItemIndex := 1
      ELSE IF Blockade = 'circle' THEN RadioGroupBlockade.ItemIndex := 2
      ELSE RadioGroupBlockade.ItemIndex := 3;
    END
    ELSE IF (findText ('<ol', 0, GetTextLen, []) = 0) THEN BEGIN
      StartTag := 'ol'; RadioGroupListentyp.Itemindex := 1;
      EndTag := '</ol>';
      EditListingstart.Enabled := TRUE;
      UpDownListingstart.Enabled := TRUE;
      RadioGroupBlockade.Enabled := FALSE;
      RadioGroupNumerierung.Enabled := TRUE;
      Blockade := getArg (EditSelected, 0, 'type', getTextLen, FALSE);
      IF Blockade = '1' THEN RadioGroupNumerierung.ItemIndex := 0
      ELSE IF Blockade = 'a' THEN RadioGroupNumerierung.ItemIndex := 1
      ELSE IF Blockade = 'A' THEN RadioGroupNumerierung.ItemIndex := 2
      ELSE IF Blockade = 'i' THEN RadioGroupNumerierung.ItemIndex := 3
      ELSE IF Blockade = 'I' THEN RadioGroupNumerierung.ItemIndex := 4;
    END
    ELSE BEGIN
//      showMessage ('Kein gltiges Listentag'); Exit;
    END;
  END (* WITH EditSelected *);

  WITH RichEditListing DO BEGIN
    lstart := selectTag (EditSelected, 0, StartTag, tagbody);
    IF lstart < 0 THEN BEGIN
      EditSelected.SelectAll;
      IF EditSelected.SelLength <= 2 THEN Exit;
      EditSelected.SelLength := EditSelected.SelLength - 2;
    END (* IF lstart *);
    EditSelected.CopyToClipboard;
    Clear; PasteFromClipboard;

    lstart := findText ('<li>', 0, GetTextLen, []);
    WHILE lstart >= 0 DO BEGIN
      SelStart := lstart; SelLength := Length ('<li>'); SelText := '';
      lstart := findText ('<li>', 0, GetTextLen, []);
    END (* WHILE *);

    lstart := findText ('</li>', 0, GetTextLen, []);
    WHILE lstart >= 0 DO BEGIN
      SelStart := lstart; SelLength := Length ('</li>'); SelText := '';
      lstart := findText ('</li>', 0, GetTextLen, []);
    END (* WHILE *);
  END (* WITH RichEditListing *);
end (* ListingAnalyse *);

procedure THyperlinkForm1.ButtonListeClick(Sender: TObject);
VAR  blockade:        String;
VAR  ST:              TSearchTypes;
     start, ende:     Integer;
     neuende:         Integer;
     liststart:       String;

  procedure einfuege (vorn, hinten: String);
  VAR findpos:  Integer;
  begin
    WITH EditSelected DO BEGIN
      findpos := start; neuende := ende;
      WHILE findpos < neuende DO BEGIN
        SelStart := findpos; SelLength := 0;
        SelText := vorn;
        INC (findpos, LENGTH (vorn));
        INC (neuende, LENGTH (vorn));
        WHILE NOT (Text [findpos + 1] IN [#10, #13]) AND
              (findpos < neuende) DO
          INC (findpos);
        IF Text [findpos + 1] IN [#10, #13] THEN BEGIN
          SelStart := findpos;
          SelText := hinten;
          INC (neuende, LENGTH (hinten));
          findpos := SelStart + SelLength;
          WHILE (Text [findpos + 1] IN [#10, #13]) AND (findpos < neuende) DO
            INC (findpos);
        END (* IF *)
        ELSE break;
      END (* WHILE *);
      SelStart := GetTextLen; SelLength := 0;
      SelText := hinten;
    END (* WITH RichEditListing *);
  end (* einfuege *);

begin (* ButtonListeClick *)
  blockade := '';
  CASE RadioGroupListenTyp.ItemIndex OF
    0:  BEGIN StartTag := 'ul'; liststart := '';
              CASE RadioGroupBlockade.ItemIndex OF
                0:  blockade := ' type="disc"';
                1:  blockade := ' type="square"';
                2:  blockade := ' type="circle"';
                3:  blockade := '';
              END (* CASE *);
        END;
    1:  BEGIN
          StartTag := 'ol'; blockade := '';
          liststart := ' start="' + EditListingStart.Text + '"';
          CASE RadioGroupNumerierung.ItemIndex OF
            0: blockade := ' type="1"';
            1: blockade := ' type="a"';
            2: blockade := ' type="A"';
            3: blockade := ' type="i"';
            4: blockade := ' type="I"';
          END (* CASE *);
        END;
  END (* CASE *);

  UndoText := EditSelected.Text;
  WITH RichEditListing DO BEGIN
// Listing-Zeilen erzeugen:
    ST := [];
    start := 0; ende := GetTextLen;
    SelectAll; SelLength := SelLength - 2;
    warte (600);
    CopyToClipboard;
    EditSelected.Clear; EditSelected.PasteFromClipboard;
    warte (600);
    einfuege ('<li>', '</li>');
  END (* WITH *);

  EndTag := '</' + Starttag + '>';
  StartTag := '<' + Starttag + blockade + liststart + '>';
  EditSelected.Text := StartTag + EditSelected.Text +
    EndTag; // + #13#10;
  definiert := TRUE;
end (* ButtonListeClick *);

(************************************ Breaks - Umbruch ************************)

procedure THyperlinkForm1.ButtonBreakClick(Sender: TObject);
VAR  clear:  String;
begin
  CASE RadioGroupClear.ItemIndex OF
    0:  clear := ' clear="left"';
    1:  clear := ' clear="right"';
    2:  clear := ' clear="all"';
    ELSE clear := '';
  END (* CASE *);

  StartTag := '<br' + clear + '>';
  EditSelected.Text := StartTag;
  definiert := TRUE;
end;

procedure THyperlinkForm1.Breakanalyse;
VAR  Ausrichtung: String;
begin
  WITH EditSelected DO BEGIN
    Ausrichtung := getArg (EditSelected, 0, 'clear', getTextLen, TRUE);
    IF Ausrichtung = 'left' THEN RadiogroupClear.ItemIndex := 0
    ELSE IF Ausrichtung = 'right' THEN RadiogroupClear.ItemIndex := 1
    ELSE IF Ausrichtung = 'all' THEN RadiogroupClear.ItemIndex := 2;
  END (* WITH *);
end (* BreakAnalyse *);

procedure THyperlinkForm1.ButtonKommentarClick(Sender: TObject);
VAR sb, eb: String;
begin
  WITH RichEditKommentar DO BEGIN
    IF Text [1] <> ' ' THEN sb := ' ';
    IF Text [GetTextLen] <> ' ' THEN eb := ' ';
    EditSelected.Text := '<!--' + sb + RichEditKommentar.Text + eb + '-->';
  END (* WITH *);
  definiert := TRUE;
end;

function THyperLinkForm1.SelectSingleTag (Editor: TRichEdit; Start: Integer; tagname: String;
                                         var tagcontent: String): Integer;
VAR tagstart, tagend: Integer;
    ST:               TSearchTypes;

  procedure keinTag;
  BEGIN
    showMessage ('Kein Tag "' + tagname + '" gefunden');
    tagcontent := ''; Result := -1;
  END;

begin
  WITH Editor DO BEGIN
    ST := [stWholeWord]; Result := -1; tagcontent := '';
    tagstart := findText ('<' + tagname, Start, GetTextLen, ST);
    IF tagstart >= 0 THEN BEGIN
        Result := tagstart;
        tagend := tagstart;
        tagend := findText ('>', tagend, GetTextLen, []);
        IF tagend < 0 THEN BEGIN keinTag; EXIT; END;

        SelStart := tagstart;
        DEC (tagstart);
        SelLength := tagend - tagstart;
        INC (tagstart, Length (tagname) + 4);
        tagcontent := Copy (Text, tagstart, tagend - tagstart + 1);
    END (* IF tagstart *);
  END (* WITH Editor *);
end (* SelectSingleTag *);

function THyperLinkForm1.SelectTag (Editor: TRichEdit; Start: Integer; tagname: String;
                                    var tagbody: String): Integer;
VAR ltagstart, ltagend,
    otagend:                   Integer;
    Level:                     Integer;
    //pairstart, pairend: Integer;
    ST:                        TSearchTypes;

  procedure keinTag;
  BEGIN
    showMessage ('Kein Tag "' + tagname + '" gefunden');
    tagbody := ''; Result := -1;
  END;

begin
  WITH Editor DO BEGIN
    ST := [stWholeWord]; Result := -1; tagbody := '';
    ltagstart := findText ('<' + tagname, Start, GetTextLen, ST);
    IF ltagstart >= 0 THEN BEGIN
        Result := ltagstart; tagstart := ltagstart;

        (* Versuche, ein Endtag zu finden *)
//        IF tagname [1] = '/' THEN BEGIN keinTag; Exit; END;
// showMessage (tagname);

        ltagend := ltagstart + 1;
        WHILE (Text [ltagend] <> '>') AND (ltagend < GetTextLen) DO
          INC (ltagend);
        IF (Text [ltagend] <> '>') THEN BEGIN keinTag; EXIT; END;
        tagend := ltagend;
        Level := 1;
        pairstart := 0; pairend := 0; otagend := ltagend;
//showMessage (tagname);
        WHILE (Level > 0) DO BEGIN
          pairstart := FindText (tagname, ltagend + 1, GetTextLen, ST);
          IF pairstart < 0 THEN BEGIN
//showMessage (tagname + ' nicht gefunden, Level: ' + IntToStr (Level));
            ltagend := otagend; Break;
          END (* IF *);
          IF (Text [pairstart] = '/') AND (Text [pairstart-1] = '<')
            THEN DEC (Level)
          ELSE IF
            (Text [pairstart + Length (tagname)] = '>') THEN INC (Level);
          ltagend := pairstart + Length (tagname);
          IF Level = 0 THEN BEGIN
            pairend := pairstart + Length (tagname + '>');
            DEC (pairstart, 2);
// ups - bercksichtigt nicht ev. Leerzeichen zwischen endtagname und >
          END (* IF Level = 0 *);
        END (* WHILE Level > 0 *);

        Selstart := otagend;
        DEC (ltagstart);
        IF pairend > 0 THEN BEGIN
          Sellength := pairstart - otagend;
          tagbody := Copy (Text, otagend + 1, pairstart - otagend);
{showMessage ('otagend: ' + IntToStr (otagend) +
             ', pairstart: ' + IntToStr (pairstart) + ', p-o: ' + IntToStr (pairstart - otagend));
}
        END
        ELSE BEGIN
          Sellength := ltagend - ltagstart;
          tagbody := '';
        END (* ELSE kein paariges Tag *);
    END (* IF startTag *);
  END (* WITH *);
end (* SelectTag *);


procedure THyperlinkForm1.ButtonTargetNewbrowserClick(Sender: TObject);
begin
  EditTarget.Text := '_new';
end;

procedure THyperlinkForm1.ButtonTargetBeforeframeClick(Sender: TObject);
begin
  EditTarget.Text := '_parent';
end;

procedure THyperlinkForm1.ButtonTargetTopClick(Sender: TObject);
begin
  EditTarget.Text := '_top';
end;

procedure THyperlinkForm1.ButtonNurDateiClick(Sender: TObject);
begin
  EditGrafikdatei.Text := ExtractFileName (EditGrafikdatei.Text);
end;

procedure THyperlinkForm1.Metaanweisungeinfgen1Click(Sender: TObject);
begin
  ComboBoxMeta.Items.Insert (0, ComboBoxMeta.Text);
end;

procedure THyperlinkForm1.Metaanweisungunteneinfgen1Click(Sender: TObject);
begin
  ComboBoxMeta.Items.Add (ComboBoxMeta.Text);
end;

procedure THyperlinkForm1.Metaanweisunglschen1Click(Sender: TObject);
begin
  ComboBoxMeta.Items.Delete (ComboBoxMeta.ItemIndex);
  ComboBoxMeta.ItemIndex := 0;
  ButtonMetaClick (Sender);
end;

procedure THyperlinkForm1.NeueMetaschablone1Click(Sender: TObject);
begin
  ComboBoxMeta.Text := 'name="Propertyname" content="Inhalt"';
  ButtonMetaClick (Sender);
end;

procedure THyperlinkForm1.Metaanweisungberschreiben1Click(Sender: TObject);
begin
  ComboBoxMeta.Items [ComboBoxMeta.ItemIndex] := ComboBoxMeta.Text;
  ButtonMetaClick (Sender);
end;

procedure THyperlinkForm1.ButtonSeitenanalyseClick(Sender: TObject);
begin
  SeitenAnalyse (TRUE);
end;

procedure THyperlinkForm1.ButtonColorClick(Sender: TObject);
VAR  Fontbody:  String;
begin
  WITH Sender AS TPanel DO BEGIN
    ColorDialog1.Color := Color;
    IF ColorDialog1.Execute THEN BEGIN
      Color := ColorDialog1.Color;
      SelectTag (RichEditFont, 0, 'font', Fontbody);
      RichEditFont.SelAttributes.Color := Color;
      RichEditFont.SelLength := 0;
    END (* IF *);
  END (* WITH *);
end;

function THyperlinkForm1.winColor (BodyColor: String): TColor;
VAR  DialogColor: String;
begin
  Result := $FFFFFF;
  IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
    BodyColor [1] := '$';
    DialogColor := BodyColor;
    DialogColor [2] := BodyColor [6]; DialogColor [3] := BodyColor [7];
    DialogColor [6] := BodyColor [2]; DialogColor [7] := BodyColor [3];
    Result := StrToInt (DialogColor);
  END (* IF *);
end (* winColor *);

function THyperlinkForm1.webColor (Color: TColor): String;
VAR DialogColor, BodyColor: String;
begin
//  Result := '#FFFFFF';
  DialogColor := IntToHex (Color, 6);
  BodyColor := DialogColor;
  BodyColor [1] := DialogColor [5]; BodyColor [2] := DialogColor [6];
  BodyColor [5] := DialogColor [1]; BodyColor [6] := DialogColor [2];
  BodyColor := '#' + BodyColor;
  Result := BodyColor;
end (* webColor *);

procedure THyperlinkForm1.ButtonColorDefineClick(Sender: TObject);
VAR  BodyStart, BodyLen:        Integer;
     DialogColor, BodyColor:    String;
     tagbody:                   String;
begin
  WITH RichEditSeite DO BEGIN
    BodyStart := selectSingleTag (RichEditSeite, 0, 'body', tagbody);
    BodyLen := Length (tagbody) + Length ('<body>');
// showMessage ('Tagbody: ' + tagbody);
    IF BodyStart >= 0 THEN BEGIN
      BodyColor := getArg (RichEditSeite, BodyStart, 'bgcolor', BodyLen, false);
// showMessage ('BodyStart: ' + IntToStr (BodyStart) + '; BodyColor: ' + BodyColor);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        SelText := webColor (PanelBodyColor.Color);
      END (* IF BodyColor *)
      ELSE BEGIN
        SelStart := BodyStart + Length ('<body'); SelLength := 0;
        SelText := ' bgcolor="' + webColor (PanelBodyColor.Color) + '"';
      END (* ELSE *);

      BodyColor := getArg (RichEditSeite, BodyStart, 'text', BodyLen, false);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        SelText := webColor (PanelTextColor.Color);
      END (* IF BodyColor *)
      ELSE BEGIN
        SelStart := BodyStart + Length ('<body'); SelLength := 0;
        SelText := ' text="' + webColor (PanelTextColor.Color) + '"';
      END (* ELSE *);

      BodyColor := getArg (RichEditSeite, BodyStart, 'link', BodyLen, false);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        SelText := webColor (PanelLinkColor.Color);
      END (* IF BodyColor *)
      ELSE BEGIN
        SelStart := BodyStart + Length ('<body'); SelLength := 0;
        SelText := ' link="' + webColor (PanelLinkColor.Color) + '"';
      END (* ELSE *);

      BodyColor := getArg (RichEditSeite, BodyStart, 'vlink', BodyLen, false);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        SelText := webColor (PanelVLinkColor.Color);
      END (* IF BodyColor *)
      ELSE BEGIN
        SelStart := BodyStart + Length ('<body'); SelLength := 0;
        SelText := ' vlink="' + webColor (PanelVLinkColor.Color) + '"';
      END (* ELSE *);

      BodyColor := getArg (RichEditSeite, BodyStart, 'alink', BodyLen, false);
      IF (BodyColor <> '') AND (BodyColor [1] = '#') THEN BEGIN
        SelText := webColor (PanelALinkColor.Color);
      END (* IF BodyColor *)
      ELSE BEGIN
        SelStart := BodyStart + Length ('<body'); SelLength := 0;
        SelText := ' alink="' + webColor (PanelALinkColor.Color) + '"';
      END (* ELSE *);
    END (* IF *);

  END (* WITH *);
end (* ButtonColorDefineClick *);

procedure THyperlinkForm1.CheckBoxKeineGroesseClick(Sender: TObject);
begin
  IF CheckBoxKeineGroesse.checked THEN BEGIN
    EditFontgroesse.Enabled := FALSE; UpDownFontgroesse.Enabled := FALSE;
  END
  ELSE BEGIN
    EditFontgroesse.Enabled := TRUE; UpDownFontgroesse.Enabled := TRUE;
  END (* ELSE *);
end;


procedure THyperlinkForm1.ColorDialog1Close(Sender: TObject);
begin
  IF ColorDialog1.CustomColors.Count > 0 THEN BEGIN
    ColorDialog1.CustomColors.SaveToFile (ChangeFileExt (Application.ExeName, '.COL'));
  END;
end;

procedure THyperlinkForm1.ButtonHintergrundClick(Sender: TObject);
VAR  tagbody:                String;
     BodyStart, BodyLen:     Integer;
     Hintergrund:            String;
     Fix:                    String;
begin
  WITH RichEditSeite DO BEGIN
    BodyStart := selectSingleTag (RichEditSeite, 0, 'body', tagbody);
    BodyLen := Length (tagbody) + Length ('<body>');

    IF BodyStart >= 0 THEN BEGIN
//      IF CheckBoxBackFix.Checked THEN Fix := ' bgproperties = fixed'
//      ELSE Fix := '';
      Hintergrund := getArg (RichEditSeite, BodyStart, 'bgproperties', BodyLen, false);
      IF CheckBoxBackFix.Checked THEN BEGIN
        IF (Hintergrund <> '') THEN BEGIN
          SelText := 'fixed';
        END (* IF Hintergrund *)
        ELSE BEGIN
          SelStart := BodyStart + Length ('<body'); SelLength := 0;
          SelText := ' bgproperties=fixed';
        END (* ELSE *);
      END (* IF Fix *);

      Hintergrund := getArg (RichEditSeite, BodyStart, 'background', BodyLen, false);
      IF (Hintergrund <> '') THEN BEGIN
        SelText := EditHintergrund.Text;
      END (* IF Hintergrund *)
      ELSE BEGIN
        IF EditHintergrund.Text <> '' THEN BEGIN
          SelStart := BodyStart + Length ('<body'); SelLength := 0;
          SelText := ' background="' + EditHintergrund.Text + '"';
        END (* IF Hintergrund *);
      END (* ELSE *);
    END (* IF *);
  END (* WITH RichEditSeite *);
end (* ButtonHintergrundClick *);

procedure THyperlinkForm1.ButtonHintergrundNurDateiClick(Sender: TObject);
begin
  EditHintergrund.Text := ExtractFileName (EditHintergrund.Text);
end;

procedure THyperlinkForm1.ButtonDateiHintergrundClick(Sender: TObject);
VAR  mr:      TModalResult;
     DatMan:  TDateiManagerForm;
begin
//  DatMan := TDateiManagerForm.Create (Self);
  DatMan := TDateiManagerForm.ECreate (Self, FALSE, 'Hintergrundgrafik suchen', 'Link laden', '',
             '*.GIF',
             LRFrame.Konfig.DateifilterIndex, TRUE, TRUE, FALSE, FALSE);
  WITH DatMan AS TDateiManagerForm DO BEGIN
{    Caption := 'Hintergrundgrafik suchen';
    DateiFilterComboBox.ItemIndex := LRFrame.DateiFilterIndex;
    ButtonLaden.Enabled := TRUE; (* hm ... *)
    ButtonLaden.Default := TRUE;}
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      LRFrame.Konfig.DateiFilterIndex := DateiFilterComboBox.ItemIndex;
//showMessage (ComboBoxDateiauswahlHistory.Text);
      EditHintergrund.Text := ComboBoxDateiauswahlHistory.Text;
      IF FileExists (EditHintergrund.Text) {AND ()} THEN BEGIN
        TRY
          WITH ImageHintergrund.Picture DO BEGIN
            LoadFromFile (EditHintergrund.Text);
          END (* WITH *);
        EXCEPT
          showMessage ('Kann Datei "' + EditHintergrund.Text + '" nicht als Grafik laden!');
        END;
      END (* IF versuche Grafikdatei fr Hintergrund zu laden *);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure THyperlinkForm1.ButtonNurDateinameClick(Sender: TObject);
begin
  EditLinkziel.Text := ExtractFileName (EditLinkziel.Text);
end;

procedure THyperlinkForm1.ButtonLowResBrowserClick(Sender: TObject);
VAR  mr:      TModalResult;
     DatMan:  TDateiManagerForm;
begin
//  DatMan := TDateiManagerForm.Create (Self);
  DatMan := TDateiManagerForm.ECreate (Self, FALSE, 'Hyperlink Lowres suchen', 'Link laden', '',
             '*.GIF',
             LRFrame.Konfig.DateifilterIndex, TRUE, TRUE, FALSE, FALSE);
  WITH DatMan AS TDateiManagerForm DO BEGIN
{    Caption := 'Hyperlink Lowres suchen';
    DateiFilterComboBox.ItemIndex := LRFrame.DateiFilterIndex;
    ButtonLaden.Enabled := TRUE; (* hm ... *)
    ButtonLaden.Default := TRUE;}
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      LRFrame.Konfig.DateiFilterIndex := DateiFilterComboBox.ItemIndex;
//showMessage (ComboBoxDateiauswahlHistory.Text);
      EditLowRes.Text := ComboBoxDateiauswahlHistory.Text;
      GrafikLaden (EditLowRes.Text);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure THyperlinkForm1.ButtonLowNurDateiClick(Sender: TObject);
begin
  EditLowRes.Text := ExtractFileName (EditLowRes.Text);
end;

procedure THyperlinkForm1.CheckBoxEinpassenClick(Sender: TObject);
begin
  ImageGrafiklink.Stretch := CheckBoxEinpassen.Checked;
  IF NOT CheckBoxEinpassen.Checked THEN BEGIN
    WITH ImageGrafiklink.Picture DO BEGIN
      ScrollBoxGrafik.HorzScrollBar.Range := Width;
      ScrollBoxGrafik.VertScrollBar.Range := Height;
    END (* WITH *);
  END
  ELSE BEGIN
    ScrollBoxGrafik.HorzScrollBar.Range := 0;
    ScrollBoxGrafik.VertScrollBar.Range := 0;
  END (* ELSE *);
end;

procedure THyperlinkForm1.ImageGrafiklinkProgress(Sender: TObject;
  Stage: TProgressStage; PercentDone: Byte; RedrawNow: Boolean;
  const R: TRect; const Msg: String);
begin
  IF Stage = psStarting THEN ProgressBarGrafik.Visible := TRUE;
  ProgressBarGrafik.Position := PercentDone;
  IF Stage = psEnding THEN ProgressBarGrafik.Visible := FALSE;
end;

procedure THyperlinkForm1.UpDownRahmenClick(Sender: TObject;
  Button: TUDBtnType);
begin
  PanelGrafikVorschau.BorderWidth := UpDownRahmen.Position;
end;

procedure THyperlinkForm1.ButtonBildgroesseClick(Sender: TObject);
begin
  WITH ImageGrafiklink.Picture DO BEGIN
    UpDownHoehe.Position := Height;
    UpDownBreite.Position := Width;
  END (* WITH *);
end;

procedure THyperlinkForm1.ButtonKeineBildgroesseClick(Sender: TObject);
begin
  UpDownHoehe.Position := 0;
  UpDownBreite.Position := 0;
end;

procedure THyperlinkForm1.EinfuegenClick(Sender: TObject);
begin
  WITH PopupMenuEditor.PopupComponent AS TRichEdit DO
    PasteFromClipboard;
end;

procedure THyperlinkForm1.Kopieren1Click(Sender: TObject);
begin
  WITH PopupMenuEditor.PopupComponent AS TRichEdit DO
    CopyToClipboard;
end;

procedure THyperlinkForm1.Ausschneiden1Click(Sender: TObject);
begin
  WITH PopupMenuEditor.PopupComponent AS TRichEdit DO
    CutToClipboard;
end;

procedure THyperlinkForm1.Loeschen1Click(Sender: TObject);
begin
  WITH PopupMenuEditor.PopupComponent AS TRichEdit DO
    ClearSelection;
end;

procedure THyperlinkForm1.Allesauswaehlen1Click(Sender: TObject);
begin
  WITH PopupMenuEditor.PopupComponent AS TRichEdit DO
    SelectAll;
end;

procedure THyperlinkForm1.Zeilenumbruchumschalten1Click(Sender: TObject);
begin
  WITH PopupMenuEditor.PopupComponent AS TRichEdit DO
    WordWrap := NOT WordWrap;
end;

procedure THyperlinkForm1.warte (ms: Integer);
VAR Msg: TMsg;
begin
  Setup := TRUE;
  TimerSetup.Interval := ms; TimerSetup.Enabled := TRUE;
  while Setup DO
    while PeekMessage (Msg, 0, 0, 0, pm_Remove) do begin
      TranslateMessage (Msg);
      DispatchMessage (Msg);
    end (* while *);
  TimerSetup.Enabled := FALSE;
end (* warte *);

procedure THyperlinkForm1.FormShow(Sender: TObject);
begin

  SetFrameStringGrid;
  SetTableStringGrid; ChangeCell := FALSE;

  PanelGrafikVorschau.BorderWidth := UpDownRahmen.Position;
  IF FileExists (ChangeFileExt (Application.ExeName, '.COL')) THEN BEGIN
    ColorDialog1.CustomColors.LoadFromFile (ChangeFileExt (Application.ExeName, '.COL'));
  END;

  warte (600);

  IF MeinEditor <> NIL THEN BEGIN
//showMessage (MeinEditor.Classname);
    WITH MeinEditor DO BEGIN
      Editor.ReadOnly := TRUE;
      OldSelstart := Editor.SelStart;
      OldSelLength := Editor.SelLength;
      IF Editor.SelLength > 0 THEN BEGIN
        Editor.CopyToClipboard;
        EditSelected.PasteFromClipboard;
        warte (600);
        UndoText := EditSelected.Text;
        LRFrame.SyntaxHighlight (EditSelected);
      END (* IF *);
      IF TagSelected THEN BEGIN
        Starttag := '<' + tagname + '>';
        IF pairstart > 0 THEN
          Endtag := '</' + tagname + '>';
        SelectTab;
      END (* IF TagSelected *)
      ELSE BEGIN
        PageControlHyperlinks.ActivePage := TabSheetZeichen;
{        PageControlHyperlinks.ActivePage := TabSheetHyperlinks;
        LinkAnalyse;
        ZielAnalyse;}
      END (* ELSE *);
    END (* WITH *);
  END
  ELSE
  {showMessage ('MeinEditor ist NIL')};
end (* FormShow *);

procedure THyperlinkForm1.AbbrechenClick(Sender: TObject);
begin
  Close;
end;

CONST esc = #27;

procedure THyperlinkForm1.EditSelectedKeyPress(Sender: TObject;
  var Key: Char);
begin
  IF Key = esc THEN Close;
end;

procedure THyperlinkForm1.ButtonFrameZellEditorClick(Sender: TObject);
begin
  WITH StringGridFrameset DO Cells [Col, Row] := RichEditFrameset.Text;
end;

procedure THyperlinkForm1.TimerSetupTimer(Sender: TObject);
begin
  Setup := FALSE;
end;

procedure THyperlinkForm1.Suchen1Click(Sender: TObject);
begin
  AktiverEditor := PopupMenuEditor.PopupComponent AS TRichEdit;
  FindDialog1.Execute;
end;

procedure THyperlinkForm1.Tauschen1Click(Sender: TObject);
begin
  AktiverEditor := PopupMenuEditor.PopupComponent AS TRichEdit;
  ReplaceDialog1.Execute;
end;

procedure THyperlinkForm1.FindDialog1Find(Sender: TObject);
VAR
  ST:    TSearchTypes;
  Rslt:  Integer;
begin
  IF AktiverEditor = NIL THEN EXIT;
  ST := [];
  WITH Sender AS TFindDialog DO BEGIN
    IF frWholeWord IN Options THEN ST := [stWholeWord];
    IF frMatchCase IN Options THEN ST := ST + [stMatchCase];
    Rslt := AktiverEditor.FindText(FindText, AktiverEditor.SelStart +
      AktiverEditor.SelLength, AktiverEditor.GetTextLen, ST);
    IF Rslt > -1 THEN
      BEGIN
        AktiverEditor.SelStart := Rslt;
        AktiverEditor.SelLength := Length(FindText);
      END
    ELSE BEGIN
      IF NOT (Sender IS TReplaceDialog) THEN
        ShowMessage ('Suchbegriff "' + FindDialog1.FindText +
        '" nicht gefunden!');
    END (* ELSE *);
  END (* WITH Sender *);
end;

procedure THyperlinkForm1.ReplaceDialog1Replace(Sender: TObject);
CONST i: Integer = 0;
begin
  WITH Sender AS TReplaceDialog DO
//      IF frWholeWord IN Options THEN ST := [stWholeWord];
//      IF frMatchCase IN Options THEN ST := ST + [stMatchCase];
    WHILE True DO BEGIN
      IF AktiverEditor.SelText <> FindText THEN
        FindDialog1Find (Sender);
      IF AktiverEditor.SelLength = 0 THEN Break;
      AktiverEditor.SelText := ReplaceText; INC (i);
      IF NOT (frReplaceAll IN Options) THEN Break;
    END (* WHILE *);
    ShowMessage (IntToStr (i) + ' Vorkommen von "' + ReplaceDialog1.FindText +
                 '" durch "' + ReplaceDialog1.ReplaceText + '" ersetzt.');
end (* ReplaceDialog1Replace *);

procedure THyperlinkForm1.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  IF MeinEditor <> NIL THEN BEGIN
    MeinEditor.Editor.ReadOnly := FALSE;
    MeinEditor.Tagassistent := NIL;
    Action := caFree;
    Release;
  END (* IF *)
  ELSE modalResult := mrOK;
end (* FormClose *);

procedure THyperlinkForm1.RichEditAbsatzChange(Sender: TObject);
begin
  definiert := FALSE;
end;

procedure THyperlinkForm1.SpeedButtonSyntaxClick(Sender: TObject);
begin
  LRFrame.SyntaxHighlight (EditSelected);
end (* SpeedButtonSyntaxClick *);

(***************************** Frames **********************************)
TYPE
     TComment = Class (TObject)
       comm: String;
     END (* TComment *);

procedure THyperlinkForm1.StringGridFramesetGetEditText(Sender: TObject;
  ACol, ARow: Integer; var Value: String);
begin
  IF (ACol = 1) AND (ARow = 1) THEN Value := '';
end;

procedure THyperlinkForm1.StringGridFramesetSetEditText(Sender: TObject;
  ACol, ARow: Integer; const Value: String);
begin
  IF (ACol = 1) AND (ARow = 1) THEN StringGridFrameset.Cells [1, 1] := '';
end;

procedure THyperlinkForm1.StringGridFramesetSelectCell(Sender: TObject;
  Col, Row: Integer; var CanSelect: Boolean);
begin
  IF (Col = 1) AND (Row = 1) THEN CanSelect := FALSE;
end;

procedure THyperlinkForm1.SetFrameStringGrid;
// Initialisieren des StringGrid-Displays StringGridFrameset
VAR co, ro:  Integer;
    commob:  TComment;
begin
// showMessage ('SetFrameStringGrid');
  WITH StringGridFrameSet DO BEGIN
    Cells [0, 0] := 'Frameset';
    Cells [1, 0] := 'Breite:';
    Cells [0, 1] := 'Hhe:';
    Cells [1, 1] := '';

    FOR co := 2 TO ColCount -1 DO BEGIN
      ColWidths [co] := 150;
      Cells [co, 0] := 'Spalte ' + IntToStr (co-1);
    END (* FOR *);
    FOR co := 2 TO ColCount -1 DO BEGIN
      IF Cells [co, 1] = '' THEN
        Cells [co, 1] := IntToStr (100 DIV (ColCount - 2));
    END (* FOR *);

    FOR ro := 2 TO RowCount -1 DO BEGIN
      Cells [0, ro] := 'Zeile ' + IntToStr (ro-1);
    END (* FOR *);
    FOR ro := 2 TO RowCount -1 DO BEGIN
      IF Cells [1, ro] = '' THEN
        Cells [1, ro] := IntToStr (100 DIV (RowCount - 2));
    END (* FOR *);

    FOR co := 2 TO ColCount -1 DO BEGIN
      FOR ro := 2 TO RowCount -1 DO BEGIN
        IF Objects [co, ro] = NIL THEN BEGIN
          commob := TComment.Create;
          commob.comm := '';
          Objects [co, ro] := commob;
        END (* IF = NIL *);
        IF Cells [co, ro] = '' THEN
          Cells [co, ro] := 'src="Frame' + IntToStr (co-1) + IntToStr (ro-1) + '.html"';
      END (* FOR Row *);
    END (* FOR Col *);
    Col := 2; Row := 2;
  END (* WITH *);
end (* SetFrameStringGrid *);

procedure THyperlinkForm1.MaskEditSpaltenChange(Sender: TObject);
begin
  StringgridFrameset.ColCount := StrToInt (MaskEditSpalten.Text) + 2;
  SetFrameStringGrid;
end;

procedure THyperlinkForm1.MaskEditReihenChange(Sender: TObject);
begin
  StringgridFrameset.RowCount := StrToInt (MaskEditReihen.Text) + 2;
  SetFrameStringGrid;
end;

procedure THyperlinkForm1.StringGridFramesetGetEditMask(Sender: TObject;
  ACol, ARow: Integer; var Value: String);
begin
  IF (ACol >=2) AND (ARow >= 2) THEN
    Value := ''
  ELSE
    IF (ACol = 1) OR (ARow = 1) THEN
      Value := '';
//    Value := '99999';
end;

procedure THyperlinkForm1.StringGridFramesetClick(Sender: TObject);
begin
  WITH StringGridFrameset DO BEGIN
    RichEditFrameset.Text := Cells [Col, Row];
  END (* WITH *);
end;

function THyperlinkForm1.getFrame (Start: Integer; Var between: String): String;
VAR  fr, frarg:      String;
     frpos, frspos,
     tagend:         Integer;
     Level:          Integer;
begin
//  WITH RichEditFrameset DO BEGIN
  WITH EditSelected DO BEGIN
    fr := ''; between := '';

// Auf lokales Frameset prfen:
    frspos := findtext ('<frameset', Start, getTextLen, [stWholeWord]);
    frpos := findtext ('<frame', Start, getTextLen, [stWholeWord]);

    IF (frpos >=0) AND (frspos >=0) AND (frpos < frspos) THEN BEGIN
      frspos := -1; // Es kommt zuerst eine Frame-Deklaration
    END;

// Es war zuerst ein Frameset:
    if frspos >= 0 then begin
      Selstart := Start + 4;
      SelLength := frspos - Start - 4; between := SelText;
      Level := 1;
// Wir mssen das zugehrige Endtag des Framesets finden, wobei eine
// beliebige Schachtelungstiefe erlaubt ist!
      Start := frspos + Length ('<frameset');
      WHILE (Level > 0) DO BEGIN
        Start := findtext ('frameset', Start + 1, getTextLen, [stWholeWord]);
        IF Text [Start] = '/' THEN DEC (Level)
        ELSE INC (Level);
        Start := Start + Length ('frameset');
      END (* WHILE Level > 0 *);
      tagend := Start + 1;
      Selstart := frspos; SelLength := tagend - Selstart;
      fr := SelText;
// showMessage (fr);
      Result := fr;
      lastArgEnd := tagend + 1;
      SelStart := 0; SelLength := 0;
      Exit;
    end (* if lokales Frameset *);

// Es war eine Framedefinition:
    if frpos >= 0 then begin
      Selstart := Start + 2;
      SelLength := frpos - Start - 2; between := SelText;
      Start := frpos + Length ('<frame') + 1;
      tagend := findtext ('>', Start, getTextLen, []);

      frarg := getArg (EditSelected, Start, 'name', tagend - Start, TRUE);
      if frarg <> '' then fr := fr + 'name="' + frarg + '" ';

      frarg := getArg (EditSelected, Start, 'src', tagend - Start, TRUE);
      if frarg <> '' then fr := fr + 'src="' + frarg + '" ';

      frpos := findtext ('noresize', Start, tagend - Start, [stWholeWord]);
      if frpos >= 0 then begin
        fr := fr + 'noresize ';
      end (* if *);

      frarg := getArg (EditSelected, Start, 'scrolling', tagend - Start, TRUE);
      if frarg <> '' then fr := fr + 'scrolling="' + frarg + '" ';

      frarg := getArg (EditSelected, Start, 'frameborder', tagend - Start, TRUE);
      if frarg <> '' then fr := fr + 'frameborder="' + frarg + '" ';

      frarg := getArg (EditSelected, Start, 'marginwidth', tagend - Start, TRUE);
      if frarg <> '' then fr := fr + 'marginwidth="' + frarg + '" ';

      frarg := getArg (EditSelected, Start, 'marginheight', tagend - Start, TRUE);
      if frarg <> '' then fr := fr + 'marginheight="' + frarg + '" ';

      Result := fr;
// showMessage (fr);
    END (* if frpos *);
  END (* WITH *);
end (* getFrame *);

procedure THyperlinkForm1.Frameanalyse;
VAR cols, rows, proz:           String;
    Frameborder, Framespacing:  String;
    frame, comment:             String;
    anzc, anzr, i, j:           Integer;
    co, ro:                     Integer;
    FRSLen:                     Integer;
begin
// showMessage ('Frameanalyse BEGIN');
//  RichEditFrameset.Text := EditSelected.Text;
{  EditSelected.SelectAll; EditSelected.CopyToClipboard;
  RichEditFrameset.Clear; RichEditFrameset.PasteFromClipboard;
}

  FRSLen := EditSelected.GetTextLen; // Ups - fehlte! ???
  Frameborder := getArg (EditSelected, 0, 'frameborder', FRSLen, TRUE);
  IF (Frameborder <> '') THEN BEGIN
    IF (Frameborder = '0') OR (Frameborder = 'no') THEN
      CheckBoxFrameborder.Checked := FALSE
    ELSE IF (Frameborder = '1') OR (Frameborder = 'yes') THEN
      CheckBoxFrameborder.Checked := TRUE;
  END (* IF Frameborder *);

  Framespacing := getArg (EditSelected, 0, 'framespacing', FRSLen, TRUE);
  IF Framespacing = '' THEN
    Framespacing := getArg (EditSelected, 0, 'border', FRSLen, TRUE);
  IF Framespacing <> '' THEN
    UpDownFrameSpacing.Position := StrToInt (Framespacing);

//Anzahl Spalten ermitteln:
  FRSLen := EditSelected.findText ('>', 0, EditSelected.getTextLen, []) + 1;
  cols := getArg (EditSelected, 0, 'cols', FRSLen, TRUE);
  anzc := 1;
  IF cols <> '' THEN BEGIN
    i := 1;
    WHILE i < Length (cols) DO BEGIN
      INC (i);
      IF cols [i] = ',' THEN INC (anzc);
    END (* WHILE *);
  END (* IF *);
  UpDownSpalten.Position := anzc;
  StringGridFrameset.ColCount := anzc + 2;

// Anzahl Zeilen ermitteln:
  rows := getArg (EditSelected, 0, 'rows', FRSLen, TRUE);
  anzr := 1;
  IF rows <> '' THEN BEGIN
    i := 1;
    WHILE i < Length (rows) DO BEGIN
      INC (i);
      IF rows [i] = ',' THEN INC (anzr);
    END (* WHILE *);
  END (* IF *);
  UpDownReihen.Position := anzr;
  StringGridFrameset.RowCount := anzr + 2;

// Breitenwerte der Spalten bertragen
  IF cols <> '' THEN BEGIN
    i := 1;
    FOR j := 1 TO anzc DO BEGIN
      proz := '';
      WHILE (i < Length (cols)) AND NOT (cols [i] IN ['0'..'9', '%', '*']) DO
        INC (i);
      WHILE (i <= Length (cols)) AND (cols [i] IN ['0'..'9', '%', '*']) DO BEGIN
        proz := proz + cols [i]; INC (i);
      END (* WHILE *);
// showMessage ('Zellenbreite: ' + proz);
      StringGridFrameSet.Cells [j + 1, 1] := proz;
    END (* FOR *);
  END (* IF cols *);

// Hhenwerte der Zeilen bertragen
  IF rows <> '' THEN BEGIN
    i := 1;
    FOR j := 1 TO anzr DO BEGIN
      proz := '';
      WHILE (i < Length (rows)) AND NOT (rows [i] IN ['0'..'9', '%', '*']) DO
        INC (i);
      WHILE (i <= Length (rows)) AND (rows [i] IN ['0'..'9', '%', '*']) DO BEGIN
        proz := proz + rows [i]; INC (i);
      END (* WHILE *);
// showMessage ('Zellenhhe: ' + proz);
      StringGridFrameSet.Cells [1, j + 1] := proz;
    END (* FOR *);
  END (* IF cols *);

  WITH StringgridFrameset DO BEGIN
//showMessage ('ColCount: ' + IntToStr (ColCount) + ', RowCount: ' + IntToStr (RowCount));
    lastArgEnd := EditSelected.FindText ('>', 0, EditSelected.GetTextLen, []);

    frame := getFrame (lastArgEnd + 1, comment);
    IF frame <> '' THEN BEGIN
      FOR ro := 2 TO RowCount - 1 DO BEGIN
        FOR co := 2 TO ColCount - 1 DO BEGIN
 showMessage ('Cells [' + IntToStr (co) + ',' + IntToStr (ro) + '] = ' + frame +
 '; comment: "' + comment + '"');
          Cells [co, ro] := frame;
          IF Objects [co, ro] <> NIL THEN
            (Objects [co, ro] AS TComment).comm := comment
          ELSE showMessage ('Kein Kommentarobjekt');
          frame := getFrame (lastArgEnd + 1, comment);
        END (* FOR col *);
      END (* FOR row *);
    END (* IF *);
  END (* WITH *);

  WITH StringGridFrameset DO BEGIN
    Col := 1; Row := 1;
  END;
  StringGridFramesetClick (Self);

// showMessage ('Frameanalyse END');
end (* Frameanalyse *);

procedure THyperlinkForm1.ButtonFrameSetDefClick(Sender: TObject);
VAR  colstring, rowstring:      String;
     co, ro:                    Integer;
     FrameStr:                  String;
     Frameborder, Framespacing,
     Border:                    String;
begin
  IF CheckBoxFrameborder.Checked THEN
    Frameborder := ' frameborder="1"'
  ELSE
    Frameborder := ' frameborder="0"';
  IF EditFramespacing.Text <> '' THEN BEGIN
    Framespacing := ' framespacing="' + EditFramespacing.Text + '"';
    Border := ' border="' + EditFramespacing.Text + '"';
  END (* IF *);

  WITH StringgridFrameset DO BEGIN
    IF ColCount > 3 THEN BEGIN
      colstring := ' cols="';
      co := 2;
      WHILE (co < ColCount) DO BEGIN
        colstring := colstring + Cells [co, 1] {+ '%'};
        INC (co);
        IF co < ColCount THEN colstring := colstring + ', ';
      END (* WHILE *);
      colstring := colstring + '"';
    END
    ELSE colstring := '';

    IF RowCount > 3 THEN BEGIN
      rowstring := ' rows="';
      ro := 2;
      WHILE (ro < RowCount) DO BEGIN
        rowstring := rowstring + Cells [1, ro] {+ '%'};
        INC (ro);
        IF ro < RowCount THEN rowstring := rowstring + ', ';
      END (* WHILE *);
      rowstring := rowstring + '"';
    END
    ELSE rowstring := '';

    FrameStr := '';
    FOR ro := 2 TO RowCount - 1 DO BEGIN
      FOR co := 2 TO ColCount - 1 DO BEGIN
        FrameStr := FrameStr + (Objects [co, ro] AS TComment).comm;
        IF upPos ('<frameset', Cells [co, ro]) > 0 THEN
          FrameStr := FrameStr + Cells [co, ro] + #13#10
        ELSE
          FrameStr := FrameStr + '<frame ' + Cells [co, ro] + '>' + #13#10;
      END (* FOR Col *);
    END (* FOR Row *);

  END (* WITH StringgridFrameset *);

  WITH EditSelected DO BEGIN
    Text := '<frameset' + colstring + rowstring +
    Frameborder + Framespacing + Border + '>' + #13#10
    + FrameStr
    + '</frameset>';
    EditSelected.Text := Text;
// Das unten geht auch schon wieder nicht zuverlssig - warum?
{    warte (600);
    SelectAll;
    CopyToClipboard;
    EditSelected.Clear;
    warte (600);
    EditSelected.PasteFromClipboard;
}
//    EditStartTag.Text := '<frameset>';
//    EditEndTag.Text := '</frameset>';
  END (* WITH *);
  definiert := TRUE;
end (* ButtonFrameSetDefClick *);

procedure THyperlinkForm1.StringGridFramesetDblClick(Sender: TObject);
VAR mr:            TModalResult;
begin
  WITH StringGridFrameset DO BEGIN
    IF (col < 2) OR (row < 2) OR ((col = 1) AND (row = 1)) THEN Exit;
//    showMessage (cells [col, row]);
    IF upPos ('<frameset', cells [col, row]) > 0 THEN BEGIN
      WITH THyperLinkForm1.Create (Self) DO BEGIN
        Caption := 'Lokales Frameset';
        EditSelected.Clear;
        EditSelected.DefAttributes := Self.EditSelected.DefAttributes;
        EditSelected.Text := cells [col, row];
        PageControlHyperlinks.ActivePage := TabSheetFrames;
        Frameanalyse;
        mr := ShowModal;
        IF mr = mrOK THEN BEGIN
          cells [col, row] := EditSelected.Text;
        END (* IF *);
//        Release;
      END (* WITH *);
    END
    ELSE BEGIN
      WITH TFrameEditForm.Create (Self) DO BEGIN
        EditFrameDefinition.Text := cells [col, row];
        mr := ShowModal;
        IF mr = mrOk THEN BEGIN
          cells [col, row] := EditFrameDefinition.Text;
        END (* IF *);
//        Release;
      END (* WITH *);
    END (* ELSE *);
  END (* WITH *);
end (* StringGridFramesetDblClick *);

procedure THyperlinkForm1.Frameseteditieren1Click(Sender: TObject);
VAR modr:          TModalResult;
    s:             String;
begin
  WITH StringGridFrameset DO BEGIN
//showMessage ('Frameseteditieren1Click von: ' + cells [col, row]);
    IF (upPos ('<frameset', cells [col, row]) > 0) THEN
      s := cells [col, row]
    ELSE s := '';
  END (* WITH *);
    WITH THyperLinkForm1.Create (Self) DO BEGIN
      Caption := 'Lokales Frameset editieren';
      EditSelected.Text := s; //'Donald Duck'; //s;
      PageControlHyperlinks.ActivePage := TabSheetFrames;
      Frameanalyse;
//      SelectTab;
//showMessage ('showModal');
      modr := ShowModal;
//showMessage ('mr <> mrOK');
//      Release;
    END (* WITH *);
  WITH StringGridFrameset DO BEGIN
      IF modr = mrOK THEN BEGIN
//showMessage (EditSelected.Text);
        cells [col, row] := EditSelected.Text;
      END (* IF *)
      ELSE
  END (* WITH *);
end (* Frameseteditieren1Click *);


(******************************* Tables - Tabellen ****************************)

TYPE TCellAttribs = Class (TObject)
       rowspan: Integer;
       colspan: Integer;
       celltype: String;
     End (* TCellAttribs *);

procedure THyperlinkForm1.StringGridTablesTopLeftChanged(Sender: TObject);
begin
  StringGridTables.Update;
end;

procedure THyperlinkForm1.StringGridTablesKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  pressedKey := Key;
end;

procedure THyperlinkForm1.SetTableStringGrid;
VAR co, ro:  Integer;
    cellAttr: TCellAttribs;
begin
// showMessage ('SetTableStringGrid');
  WITH StringGridTables DO BEGIN
    FOR co := 0 TO ColCount -1 DO BEGIN
      FOR ro := 0 TO RowCount -1 DO BEGIN
        IF Objects [co, ro] = NIL THEN BEGIN
          cellAttr := TCellAttribs.Create;
          cellAttr.rowspan := 1; cellAttr.colspan := 1;
          cellAttr.celltype := 'th';
          Objects [co, ro] := cellAttr;
//          Cells [co, ro] := 'Test ' + IntToStr (co) + ':' + IntToStr (ro);
        END (* IF = NIL *);
      END (* FOR Row *);
    END (* FOR Col *);
    Col := 0; Row := 0;
  END (* WITH *);
end (* SetTableStringGrid *);

procedure THyperlinkForm1.MaskEditFormSpaltenChange(Sender: TObject);
begin
  StringGridTables.ColCount := StrToInt (MaskEditFormSpalten.Text);
  SetTableStringGrid;
end;

procedure THyperlinkForm1.MaskEditFormReihenChange(Sender: TObject);
begin
  StringGridTables.RowCount := StrToInt (MaskEditFormReihen.Text);
  SetTableStringGrid;
end;

procedure THyperlinkForm1.MaskEditSpanColsChange(Sender: TObject);
VAR i, j: Integer;
begin
  IF NOT ChangeCell THEN
    WITH StringGridTables DO BEGIN
      IF Objects [col, row] <> NIL THEN BEGIN
        FOR i := 1 TO (Objects [col, row] AS TCellAttribs).colspan - 1 DO BEGIN
          FOR j := 0 TO (Objects [col, row] AS TCellAttribs).rowspan - 1 DO BEGIN
            IF (ColCount >= col + i) AND (RowCount >= row + j) AND (Objects [col + i, row + j] <> NIL) THEN
              (Objects [col + i, row + j] AS TCellAttribs).colspan := 1;
          END (* FOR *);
        END (* FOR *);
        WITH Objects [col, row] AS TCellAttribs DO
          colspan := StrToInt (MaskEditSpanCols.Text);
        FOR i := 1 TO (Objects [col, row] AS TCellAttribs).colspan - 1 DO BEGIN
          FOR j := 0 TO (Objects [col, row] AS TCellAttribs).rowspan - 1 DO BEGIN
            IF (ColCount >= col + i) AND (RowCount >= row + j) AND (Objects [col + i, row + j] <> NIL) THEN
              (Objects [col + i, row + j] AS TCellAttribs).colspan := 0;
          END (* FOR *);
        END (* FOR *);
      END (* IF <> NIL *);
      Repaint;
    END (* WITH *);
  ChangeCell := FALSE;
end;

procedure THyperlinkForm1.MaskEditSpanRowsChange(Sender: TObject);
VAR i, j: Integer;
begin
  IF NOT ChangeCell THEN
    WITH StringGridTables DO BEGIN
      IF Objects [col, row] <> NIL THEN BEGIN
        FOR i := 1 TO (Objects [col, row] AS TCellAttribs).rowspan - 1 DO BEGIN
          FOR j := 0 TO (Objects [col, row] AS TCellAttribs).colspan - 1 DO BEGIN
            IF (RowCount >= row + i) AND (ColCount >= col + j) AND (Objects [col + j, row + i] <> NIL) THEN
              (Objects [col + j, row + i] AS TCellAttribs).rowspan := 1;
          END (* FOR *);
        END (* FOR *);
        WITH Objects [col, row] AS TCellAttribs DO
          rowspan := StrToInt (MaskEditSpanRows.Text);
        FOR i := 1 TO (Objects [col, row] AS TCellAttribs).rowspan - 1 DO BEGIN
          FOR j := 0 TO (Objects [col, row] AS TCellAttribs).colspan - 1 DO BEGIN
            IF (RowCount >= row + i) AND (ColCount >= col + j) AND (Objects [col + j, row + i] <> NIL) THEN
              (Objects [col + j, row + i] AS TCellAttribs).rowspan := 0;
          END (* FOR *);
        END (* FOR *);
      END (* IF <> NIL *);
      Repaint;
    END (* WITH *);
  ChangeCell := FALSE;
end;

procedure THyperlinkForm1.StringGridTablesClick(Sender: TObject);
begin
// Zuerst wollte ich das in OnSelectCell einbauen, aber da dieser Event
// vor(!) dem Selektieren der Zelle aufgerufen wird, fhrt das zu einer
// Menge von Komplikationen. Hier ist es problemlos - und funktioniert
// auch beim Wechsel der selektierten Zelle ber die Tastatur!
  WITH StringGridTables DO BEGIN

    IF pressedKey = VK_Right THEN BEGIN
      WHILE ((Objects [Col, Row] AS TCellAttribs).colspan <= 0) AND (Col < ColCount - 1) DO BEGIN
        WITH Objects [Col, Row] AS TCellAttribs DO BEGIN
          IF (colspan <= 0) AND (Col < ColCount - 1) THEN Col := Col + 1;
        END (* WITH *);
      END (* WHILE *);
    END;

    IF pressedKey = VK_Down THEN BEGIN
      WHILE ((Objects [Col, Row] AS TCellAttribs).rowspan <= 0) AND (Row < RowCount - 1) DO BEGIN
        WITH Objects [Col, Row] AS TCellAttribs DO BEGIN
          IF (rowspan <= 0) AND (Row < RowCount - 1) THEN Row := Row + 1;
        END (* WITH *);
      END (* WHILE *);
    END;

    PressedKey := 0;

    WHILE ((Objects [Col, Row] AS TCellAttribs).colspan <= 0) OR
          ((Objects [Col, Row] AS TCellAttribs).rowspan <= 0) DO BEGIN
      WITH Objects [Col, Row] AS TCellAttribs DO BEGIN
        IF (colspan <= 0) AND (Col > 0) THEN Col := Col - 1;
        IF (rowspan <= 0) AND (Row > 0) THEN Row := Row - 1;
      END (* WITH *);
    END (* WHILE *);

    IF Objects [Col, Row] <> NIL THEN BEGIN
      WITH Objects [Col, Row] AS TCellAttribs DO BEGIN
        UpDownSpanCols.Position := colspan;
        UpDownSpanRows.Position := rowspan;
        EditZellTyp.Text := celltype;
        EditX.Text := IntToStr (Col);
        EditY.Text := IntToStr (Row);
      END (* WITH TCellAttribs *);
      RichEditTabCell.Text := Cells [Col, Row];
    END (* IF *);
  END (* WITH StringGridTables *);
end;

procedure THyperlinkForm1.StringGridTablesSelectCell(Sender: TObject; Col,
  Row: Integer; var CanSelect: Boolean);
begin
{ CanSelect := ((StringGridTables.Objects [Col, Row] AS TCellAttribs).colspan > 0) AND
              ((StringGridTables.Objects [Col, Row] AS TCellAttribs).rowspan > 0);
}
end;

procedure THyperlinkForm1.StringGridTablesDrawCell(Sender: TObject; Col,
  Row: Integer; Rect: TRect; State: TGridDrawState);
var  Box: TRect;
     cellAttr: TCellAttribs;
begin
  cellAttr := StringGridTables.Objects [Col, Row] AS TCellAttribs;
  IF cellAttr = NIL THEN Exit;
  IF (cellAttr.rowspan = 0) OR (cellAttr.colspan = 0) THEN EXIT;
  Box := Rect;
  WITH Box DO BEGIN
    Right := Left + (Right - Left + 1) * cellAttr.colspan - 1;
    Bottom := Top + (Bottom - Top + 1) * cellAttr.rowspan - 1;
  END (* WITH Box *);
  StringGridTables.Canvas.FillRect (Box);
//  StringGridTables.Canvas.Pen.Width := UpDownFormborder.Position;
  IF (Col = StringGridTables.Col) AND (Row = StringGridTables.Row) THEN BEGIN
    IF StringGridTables.Focused THEN
      StringGridTables.Canvas.Brush.Color := clred
    ELSE
      StringGridTables.Canvas.Brush.Color := clmaroon;

    StringGridTables.Canvas.FrameRect (Box);
//    StringGridTables.Canvas.Rectangle (Box.Left, Box.Top, Box.Bottom, Box.Right);
//    StringGridTables.Canvas.DrawFocusRect (Box);
    StringGridTables.Canvas.Brush.Color := clwhite;
  END
  ELSE BEGIN
    StringGridTables.Canvas.Brush.Color := clblack;
    StringGridTables.Canvas.FrameRect (Box);
    StringGridTables.Canvas.Brush.Color := clwhite;
  END (* ELSE *);
  StringGridTables.Canvas.TextOut (Box.Left + 2, Box.Top + 2, StringGridTables.Cells [Col, Row]);
end;

procedure THyperlinkForm1.ButtonTablesClick(Sender: TObject);
VAR tabstring, rowstring, cellstring:  String;
    co, ro:                            Integer;
begin
  // Tabellensyntax generieren
  WITH StringGridTables DO BEGIN
    // Starttag zusammenbasteln:
    tabstring := '<table';
    IF (EditFormBorder.Text <> '') THEN
      tabstring := tabstring + ' border="' + EditFormBorder.Text + '"';
    IF (EditTabellenbreite.Text <> '') THEN
      tabstring := tabstring + ' width="' + EditTabellenbreite.Text + '"';
    CASE RadioGroupTableAlign.ItemIndex OF
      0: tabstring := tabstring + ' align="left"';
      1: tabstring := tabstring + ' align="center"';
      2: tabstring := tabstring + ' align="right"';
    END (* CASE *);
    IF (RichEditTabSummary.Text <> '') THEN
      tabstring := tabstring + #13#10 + '  summary="' + RichEditTabSummary.Text + '"';
    tabstring := tabstring + '>'+#13#10;
    IF (EditFormCaption.Text <> '') THEN
      tabstring := tabstring + '  <caption>' + EditFormCaption.Text + '</caption>' + #13#10;

    // Tabellenzeilen generieren:
    FOR ro := 0 TO RowCount - 1 DO BEGIN
      rowstring := '';
      FOR co := 0 TO ColCount - 1 DO BEGIN
        cellstring := '';
        IF (((Objects [co, ro] AS TCellAttribs).colspan <> 0) AND
            ((Objects [co, ro] AS TCellAttribs).rowspan <> 0)) THEN BEGIN
          WITH (Objects [co, ro] AS TCellAttribs) DO BEGIN
            IF celltype <> '' THEN cellstring := '<' + celltype
            ELSE cellstring := '<th';
          END (* WITH *);
          IF ((Objects [co, ro] AS TCellAttribs).rowspan > 1) THEN
            cellstring := cellstring + ' rowspan="' +
              IntToStr ((Objects [co, ro] AS TCellAttribs).rowspan) + '"';
          IF ((Objects [co, ro] AS TCellAttribs).colspan > 1) THEN
            cellstring := cellstring + ' colspan="' +
              IntToStr ((Objects [co, ro] AS TCellAttribs).colspan) + '"';
          cellstring := cellstring + '>' + Cells [co, ro];
        END (* IF *);
        IF cellstring <> '' THEN rowstring := rowstring + cellstring;
      END (* FOR co *);
      IF rowstring <> '' THEN tabstring := tabstring + '<tr>' + rowstring + #13#10;
    END (* FOR ro *);
    tabstring := tabstring + '</table>';
  END (* WITH *);
//  RichEditForms.Text := tabstring;
  EditSelected.Text := tabstring;
  definiert := TRUE;
end (* ButtonTablesClick *);

function THyperLinkForm1.SelectCellCont (Editor: TRichEdit; Start: Integer; tagname: String;
                                         var tagcontent: String): Integer;
VAR tgstart, tgend:   Integer;
    cellend:          BOOLEAN;

  procedure keinTag;
  BEGIN
    showMessage ('Kein Tag "' + tagname + '" gefunden');
    tagcontent := ''; Result := -1;
  END;

begin (* SelectCellCont *)
  WITH Editor DO BEGIN
    Result := -1; tagcontent := '';
// Hier darf keine Option "[stWholeWord]" stehen - das hat irgend eine abstruse Macke
    tgstart := findText ('<' + tagname, Start, GetTextLen, []);
    IF tgstart >= 0 THEN BEGIN
{showMessage ('SelectCellCont: Start(' + IntToStr (Start) + ') = "' + Copy (Text, Start + 1, 30) + '.."' + #13#10 +
'tagname: "' + tagname + '", tgstart(' + IntToStr (tgstart) + ') = "'
 + Copy (Text, tgstart + 1, 30) + '.."');}
        Result := tgstart;
        tgend := tgstart + 1;
        tgend := findText ('>', tgend, GetTextLen, []);
        IF tgend < 0 THEN BEGIN keinTag; EXIT; END;

        tgstart := tgend + 1; // Position nach ...>, Offset String [1]

        cellend := FALSE; tgend := tgstart;
        WHILE (NOT cellend) AND (tgend < GetTextLen) DO BEGIN
          INC (tgend);
          IF text [tgend] = '<' THEN BEGIN
            cellend := ((UpCase (text [tgend+1]) = 'T') AND (UpCase (text [tgend + 2]) = 'H'))
                    OR ((UpCase (text [tgend+1]) = 'T') AND (UpCase (text [tgend + 2]) = 'D'))
                    OR ((UpCase (text [tgend+1]) = 'T') AND (UpCase (text [tgend + 2]) = 'R'))
                    OR ((text [tgend+1] = '/') AND (findText ('TABLE', tgend + 1, GetTextLen, []) = tgend + 1));
          END (* IF *);
        END (* WHILE *);

        IF cellend THEN BEGIN
          SelStart := tgstart;
          SelLength := tgend - tgstart - 1;
          tagcontent := SelText;
        END
        ELSE showMessage ('selectCellCont: Ende Zelleintrag nicht gefunden');
    END (* IF tgstart *)
    ELSE keinTag;
  END (* WITH Editor *);
end (* SelectCellCont *);

procedure THyperlinkForm1.Tabellenanalyse;
VAR     border, summary, tabAlign,
        tabWidth, cell:         String;
        celltag, tagbody:       String;
        FLen:                   Integer;
        tagpos,
        coltagpos, celloff,
        colarg, colargend:      Integer;
        cols, rows:             Integer;
        maxcols:                Integer;
        i:                      Integer;

  function findCellTag (start: Integer; var celltag: String): Integer;
  VAR ctp: Integer;
  begin
    WITH EditSelected DO BEGIN
      ctp := findText ('<t', start, FLen, []);
      IF ctp >= 0 THEN BEGIN
        IF ((upCase (Text [ctp + 3]) = 'H') OR (upCase (Text [ctp + 3]) = 'D'))
           AND ((Text [ctp + 4] = '>') OR (Text [ctp + 4] = ' '))  THEN BEGIN
          Result := ctp;
          celltag := Copy (text, ctp + 2, 2);
        END
        ELSE Result := -1;
      END (* IF *)
      ELSE Result := ctp;
    END (* WITH *);
  end (* findCellTag *);

begin (* Tabellenanalyse *)
  FLen := EditSelected.GetTextLen;
  border := getArg (EditSelected, 0, 'border', FLen, TRUE);
  IF border <> '' THEN
    UpDownFormborder.Position := StrToInt (border);

  summary := getArg (EditSelected, 0, 'summary', FLen, FALSE);
  RichEditTabSummary.Text := summary;

  tabWidth := getArg (EditSelected, 0, 'width', FLen, FALSE);
  EditTabellenbreite.Text := tabWidth;

  tabAlign := getArg (EditSelected, 0, 'align', FLen, TRUE);
  IF tabAlign = 'left' THEN RadioGroupTableAlign.ItemIndex := 0
  ELSE IF tabAlign = 'center' THEN RadioGroupTableAlign.ItemIndex := 1
  ELSE IF tabAlign = 'right' THEN RadioGroupTableAlign.ItemIndex := 2
  ELSE RadioGroupTableAlign.ItemIndex := 3;

  WITH EditSelected DO BEGIN
    tagpos := findText ('<caption>', 0, FLen, []);
  END (* WITH *);

  IF tagpos >= 0 THEN
    tagpos := SelectTag (EditSelected, tagpos, 'caption', tagbody);
  EditFormCaption.Text := tagbody;

  // Jetzt mu die Anzahl Zeilen und Spalten der Tabelle ermittelt werden,
  // damit das Display-Grid auf die erforderliche Gre gebracht werden kann.
  // Probleme gibt es, wenn die Tabelle entartet ist, dh. eine Reihe lauter
  // Zellen enthlt, die mehr als eine Reihe hoch sind - dann fehlt uns
  // eine Reihe!
//showMessage ('First Pass');

  WITH EditSelected DO BEGIN
    rows := 0; maxcols := 0; // maxrows := 0;
    tagpos := findText ('<tr>', 0, FLen, []);
    WHILE tagpos >= 0 DO BEGIN
      INC (rows);
      coltagpos := tagpos + Length ('<tr>');
      coltagpos := findCellTag (coltagpos, celltag);
      cols := 0;
      WHILE coltagpos >= 0 DO BEGIN

        colargend := findText ('>', coltagpos + 3, FLen, []) - coltagpos - 3;
        cell := getArg (EditSelected, coltagpos + 3, 'colspan', colargend, TRUE);
        IF cell <> '' THEN BEGIN
          INC (cols, StrToInt (cell));
        END
        ELSE INC (cols);

        coltagpos := findCellTag (coltagpos + Length ('<th>'), celltag);
      END (* WHILE coltagpos *);
      IF cols > maxCols THEN maxCols := cols;

      tagpos := findText ('<tr>', tagpos + Length ('<tr>'), FLen, []);
    END (* WHILE *);
  END (* WITH *);
  StringGridTables.RowCount := rows;
  StringGridTables.ColCount := maxCols;
  SetTableStringGrid;
  UpdownFormReihen.Position := rows;
  UpdownFormSpalten.Position := maxCols;
//showMessage ('RowCount: ' + IntToStr (rows) + ', ColCount: ' + IntToStr (maxCols));
  // Jetzt mssen wir die Definition nochmal scannen, um die Zellendefinitionen
  // zu ermitteln.

//showMessage ('Second Pass');
  WITH EditSelected DO BEGIN
    rows := 0; maxcols := 0; // maxrows := 0;
    tagpos := findText ('<tr>', 0, FLen, []);
    WHILE tagpos >= 0 DO BEGIN
      INC (rows);
      coltagpos := tagpos + Length ('<tr>');
      coltagpos := findCellTag (coltagpos, celltag);
      cols := 0; celloff := 0;
      WHILE coltagpos >= 0 DO BEGIN
        INC (cols);
        WHILE (cols + celloff < StringGridTables.ColCount) AND
           (((StringGridTables.Objects [cols - 1 + celloff, rows - 1] AS TCellAttribs).colspan = 0)
         OR ((StringGridTables.Objects [cols - 1 + celloff, rows - 1] AS TCellAttribs).rowspan = 0))
            DO
          INC (celloff);
{showMessage ('cols: ' + IntToStr (cols) + ', celloff: ' + IntToStr (celloff) +
', rows: ' + IntToStr (rows));
}
        StringGridTables.Col := cols - 1 + celloff;
        StringGridTables.Row := rows - 1;

        colargend := findText ('>', coltagpos + 3, FLen, []) - coltagpos - 3;
        cell := getArg (EditSelected, coltagpos + 3, 'colspan', colargend, TRUE);
        IF cell <> '' THEN BEGIN
          UpDownSpanCols.Position := StrToInt (cell);
{showMessage ('cols: ' + IntToStr (cols) + ', celloff: ' + IntToStr (celloff) +
', rows: ' + IntToStr (rows) + ', colspan: ' + cell);
}
        END (* IF cell *);

        cell := getArg (EditSelected, coltagpos + 3, 'rowspan', colargend, TRUE);
        IF cell <> '' THEN BEGIN
          UpDownSpanRows.Position := StrToInt (cell);
{showMessage ('cols: ' + IntToStr (cols) + ', celloff: ' + IntToStr (celloff) +
', rows: ' + IntToStr (rows) + ', rowspan: ' + cell);
}
        END (* IF cell *);

        WITH StringGridTables DO (Objects [col, row] AS TCellAttribs).celltype := celltag;

        colarg := selectCellCont (EditSelected, coltagpos, celltag, tagbody);
{showMessage ('coltagpos: ' + IntToStr (coltagpos) +
' "' + Copy (Text, coltagpos + 1, GetTextLen) + '"' + #13#10 +
', celltag: ' + celltag + ', tagbody: ' + tagbody);
}
        FOR i := 1 TO 2 DO
          IF (Length (tagbody) > 0) AND (tagbody [Length (tagbody)] IN [#10, #13]) THEN
            Delete (tagbody, Length (tagbody), 1);

        WITH StringGridTables DO Cells [col, row] := tagbody;

        coltagpos := findCellTag (coltagpos + Length ('<th>'), celltag);
      END (* WHILE coltagpos *);
      IF cols > maxCols THEN maxCols := cols;

      tagpos := findText ('<tr>', tagpos + Length ('<tr>'), FLen, []);
    END (* WHILE *);
  END (* WITH EditSelected *);
  WITH StringGridTables DO BEGIN
    Col := 0; Row := 0;
  END;
  StringGridTablesClick (Self);
  StringGridTables.Repaint;
end (* TabellenAnalyse *);

procedure THyperlinkForm1.ButtonTHClick(Sender: TObject);
begin
  EditZellTyp.Text := 'th';
end;

procedure THyperlinkForm1.ButtonTDClick(Sender: TObject);
begin
  EditZellTyp.Text := 'td';
end;

procedure THyperlinkForm1.EditZelltypChange(Sender: TObject);
begin
  IF Length (EditZelltyp.Text) >= 2 THEN
    WITH StringGridTables DO BEGIN
      IF Objects [col, row] <> NIL THEN BEGIN
        (Objects [col, row] AS TCellAttribs).celltype := EditZelltyp.Text;
      END (* IF *);
    END (* WITH *);
end;

procedure THyperlinkForm1.RichEditTabCellKeyPress(Sender: TObject;
  var Key: Char);
begin
  IF Key = Esc THEN
    WITH StringGridTables DO Cells [Col, Row] := RichEditTabCell.Text;
end;

procedure THyperlinkForm1.ButtonTabCellEditorClick(Sender: TObject);
begin
  WITH StringGridTables DO Cells [Col, Row] := RichEditTabCell.Text;
end;

(***************************** Kommentare ****************************)

procedure THyperlinkForm1.KommentarAnalyse;
VAR closepos: Integer;
begin
  WITH RichEditKommentar DO BEGIN
//    Text := EditSelected.Text;
    EditSelected.SelectAll; EditSelected.CopyToClipboard;
    Clear; PasteFromClipboard;
    IF findText ('<!--', 0, GetTextLen, []) = 0 THEN BEGIN
      SelStart := 0; SelLength := Length ('<!--'); SelText := '';
    END (* Starttag entfernen *)
    {ELSE showMessage ('Kommentareinleitung "<!--" nicht korrekt oder fehlend')};
    closepos := findtext ('-->', 0, GetTextLen, []);
    IF closepos >= 0 THEN BEGIN
      SelStart := closepos; SelLength := Length ('-->'); SelText := '';
    END
    {ELSE showMessage ('Kommentarabschlu "-->" fehlt!')};
  END (* WITH *);
end (* KommentarAnalyse *);

(**************************************** Forms *******************************)

(*************************************** Base *********************************)

procedure THyperlinkForm1.RichEditFramesetKeyPress(Sender: TObject;
  var Key: Char);
begin
  IF Key = Esc THEN
    WITH StringGridTables DO Cells [Col, Row] := RichEditFrameset.Text;
end;

end.
