// MFCLanguageCtl.cpp : Implementation of the CMFCLanguageCtrl class.

#include "stdafx.h"
#include "MFCLanguage.h"
#include "MFCLanguageCtl.h"
#include "MFCLanguagePpg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CMFCLanguageCtrl, COleControl)

//////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CMFCLanguageCtrl, COleControl)
	//{{AFX_MSG_MAP(CMFCLanguageCtrl)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CMFCLanguageCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CMFCLanguageCtrl)
	DISP_PROPERTY_NOTIFY(CMFCLanguageCtrl, "Language", m_language, \
	                                           OnLanguageChanged, VT_I4)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CMFCLanguageCtrl, "AboutBox", DISPID_ABOUTBOX, \
	                                       AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()

//////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CMFCLanguageCtrl, COleControl)
	//{{AFX_EVENT_MAP(CMFCLanguageCtrl)
	EVENT_CUSTOM("LanguageChanged", FireLanguageChanged, VTS_I4)
	//}}AFX_EVENT_MAP
END_EVENT_MAP()

//////////////////////////////////////////////////////////////////////
// Property pages

// Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CMFCLanguageCtrl, 1)
	PROPPAGEID(CMFCLanguagePropPage::guid)
END_PROPPAGEIDS(CMFCLanguageCtrl)

//////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CMFCLanguageCtrl,
											 "MFCLANGUAGE.MFCLanguageCtrl.1",
	                     0xc4980a04, 0xa793, 0x11d0, 0xb7, 0xfa,
											 0, 0x20, 0xaf, 0x4c, 0xf0, 0x69)

//////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CMFCLanguageCtrl, _tlid, _wVerMajor, _wVerMinor)

//////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DMFCLanguage =
		{ 0xc4980a02, 0xa793, 0x11d0, { 0xb7, 0xfa, 0, 0x20, \
		                                0xaf, 0x4c, 0xf0, 0x69 } };
const IID BASED_CODE IID_DMFCLanguageEvents =
		{ 0xc4980a03, 0xa793, 0x11d0, { 0xb7, 0xfa, 0, 0x20, \
		                                0xaf, 0x4c, 0xf0, 0x69 } };

//////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwMFCLanguageOleMisc =
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CMFCLanguageCtrl, IDS_MFCLANGUAGE, 
										 _dwMFCLanguageOleMisc)

//////////////////////////////////////////////////////////////////////
// CMFCLanguageCtrl::CMFCLanguageCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CMFCLanguageCtrl

BOOL CMFCLanguageCtrl::CMFCLanguageCtrlFactory::UpdateRegistry( \
																											 BOOL bRegister)
{
	// TODO: Verify that your control follows apartment-model threading
	//  rules.  Refer to MFC TechNote 64 for more information.
	// If your control does not conform to the apartment-model rules,
	// then you must modify the code below, changing the 6th parameter
	// from afxRegApartmentThreading to 0.

	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_MFCLANGUAGE,
			IDB_MFCLANGUAGE,
			afxRegApartmentThreading,
			_dwMFCLanguageOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}

//////////////////////////////////////////////////////////////////////
// CMFCLanguageCtrl::CMFCLanguageCtrl - Constructor

CMFCLanguageCtrl::CMFCLanguageCtrl()
{
	InitializeIIDs(&IID_DMFCLanguage, &IID_DMFCLanguageEvents);

	m_imlst.Create(IDB_FLAGS,32,0,0);
	m_imlst.SetBkColor(0);
}

//////////////////////////////////////////////////////////////////////
// CMFCLanguageCtrl::~CMFCLanguageCtrl - Destructor

CMFCLanguageCtrl::~CMFCLanguageCtrl()
{
	// TODO: Cleanup your control's instance data here.
}

//////////////////////////////////////////////////////////////////////
// CMFCLanguageCtrl::OnDraw - Drawing function

void CMFCLanguageCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	POINT pt = {0,0};
	int flag = m_language;
	
	if(flag<0 || flag>2)
		flag=0;

	m_imlst.Draw(pdc,flag,pt,ILD_NORMAL);
}

//////////////////////////////////////////////////////////////////////
// CMFCLanguageCtrl::DoPropExchange - Persistence support

void CMFCLanguageCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	PX_Long(pPX, "Language", m_language, 0);
}

//////////////////////////////////////////////////////////////////////
// CMFCLanguageCtrl::OnResetState - Reset control to default state

void CMFCLanguageCtrl::OnResetState()
{
	COleControl::OnResetState();

	// TODO: Reset any other control state here.
}

//////////////////////////////////////////////////////////////////////
// CMFCLanguageCtrl::AboutBox - Display an "About" box to the user

void CMFCLanguageCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_MFCLANGUAGE);
	dlgAbout.DoModal();
}

//////////////////////////////////////////////////////////////////////
// CMFCLanguageCtrl message handlers

void CMFCLanguageCtrl::OnLanguageChanged() 
{
	FireLanguageChanged(m_language);
	SetModifiedFlag();
	InvalidateControl();
}

void CMFCLanguageCtrl::OnLButtonDown(UINT nFlags, CPoint point) 
{
	m_language++;
	if(m_language!=1 && m_language!=2)
		m_language=0;
	OnLanguageChanged();
}

BOOL CMFCLanguageCtrl::OnSetExtent(LPSIZEL lpSizeL) 
{
	SIZE s;

	s.cx=32;
	s.cy=20;
	((CDC*)NULL)->DPtoHIMETRIC(&s);
	lpSizeL->cx=s.cx;
	lpSizeL->cy=s.cy;
	return COleControl::OnSetExtent(lpSizeL);
}
