// OLEAuto.cpp : implementation file
//

#include "stdafx.h"
#include "mfcgame.h"
#include "mychild.h"
#include "mainfrm.h"
#include "OLEAuto.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////
// COLEAuto

IMPLEMENT_DYNCREATE(COLEAuto, CCmdTarget)

COLEAuto::COLEAuto()
{
	CMFCGameApp *app;

	app=GetApp();
	EnableAutomation();
	m_regcode=0;
	if(app)
		if(app->m_autoobj==NULL)
			app->m_autoobj=this;
}

COLEAuto::~COLEAuto()
{
	CMFCGameApp *app;

	app=GetApp();
	if(m_regcode)
	{
		RevokeActiveObject(m_regcode, NULL);
		m_regcode=0;
	}
	if(app && app->m_autoobj==this)
		app->m_autoobj=NULL;
}

void COLEAuto::RegisterActive()
{
	RegisterActiveObject(GetInterface(&IID_IUnknown), 
		guid, NULL, &m_regcode) == NOERROR;
}

void COLEAuto::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}

BEGIN_MESSAGE_MAP(COLEAuto, CCmdTarget)
	//{{AFX_MSG_MAP(COLEAuto)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(COLEAuto, CCmdTarget)
	//{{AFX_DISPATCH_MAP(COLEAuto)
 DISP_PROPERTY_EX(COLEAuto,"Mode4x4",GetMode4x4,SetMode4x4,VT_BOOL)
 DISP_FUNCTION(COLEAuto,"ComputerSugg",ComputerSugg,VT_EMPTY,VTS_NONE)
 DISP_FUNCTION(COLEAuto,"NewGame",NewGame,VT_EMPTY,VTS_NONE)
 DISP_FUNCTION(COLEAuto,"HitField",HitField,VT_EMPTY,VTS_I4)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IOLEAuto to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {45DC9EE3-A6A2-11D0-B7F7-0020AF4CF069}
static const IID IID_IOLEAuto =
{ 0x45dc9ee3, 0xa6a2, 0x11d0, { 0xb7, 0xf7, 0x00, 0x20, \
                                0xaf, 0x4c, 0xf0, 0x69 } };

BEGIN_INTERFACE_MAP(COLEAuto, CCmdTarget)
	INTERFACE_PART(COLEAuto, IID_IOLEAuto, Dispatch)
END_INTERFACE_MAP()

// {45DC9EE4-A6A2-11D0-B7F7-0020AF4CF069}
IMPLEMENT_OLECREATE(COLEAuto, "mfcgame.application", 0x45dc9ee4, \
        0xa6a2, 0x11d0, 0xb7, 0xf7, 0x0, 0x20, 0xaf, 0x4c, 0xf0, 0x69)

//////////////////////////////////////////////////////////////////////
// COLEAuto message handlers

CMFCGameApp * COLEAuto::GetApp()
{
	CWinApp *app;

	app=AfxGetApp();
	if(!app)
		return NULL;
	if(!app->IsKindOf(RUNTIME_CLASS(CMFCGameApp)))
		return NULL;
	return (CMFCGameApp*)app;
}

CMyChild * COLEAuto::GetChild()
{
	CWinApp *app;
	CWnd *wnd;

	app=AfxGetApp();
	if(!app)
		return NULL;
	wnd=app->m_pMainWnd;
	if(!wnd)
		return NULL;
	if(!wnd->IsKindOf(RUNTIME_CLASS(CMainFrame)))
		return NULL;
	return &((CMainFrame*)wnd)->m_mychild;
}

void COLEAuto::HitField(long index) 
{
	CMyChild *child;
	CPoint dummy;

	child=GetChild();
	if(!child)
		return;
	child->SetXO(index);
}

void COLEAuto::ComputerSugg() 
{
	CMyChild *child;

	child=GetChild();
	if(!child)
		return;
	child->OnGameSugg();
}

void COLEAuto::NewGame() 
{
	CMyChild *child;

	child=GetChild();
	if(!child)
		return;
	child->OnFileNew();
}

BOOL COLEAuto::GetMode4x4() 
{
	CMyChild *child;

	child=GetChild();
	if(!child)
		return -1;
	return child->m_quad==4;
}

void COLEAuto::SetMode4x4(BOOL bNewValue) 
{
	CMyChild *child;

	child=GetChild();
	if(!child)
		return;
	if(bNewValue)
		child->m_quad=4;
	else
		child->m_quad=3;
}
