unit MandelServ_COM;  // 10-FEB-98 as
{ Von Delphi erzeugte Schnittstellen-Unit fr die COM-Klasse
  IMandelCalc(Object). Die Eigenschaften dienen praktisch
  ausschlielich der Datenbergabe, die eigentliche Rechen-
  routine befindet sich in MandelServU und ist zeitlich
  von den DCOM-Aufrufen entkoppelt. }

interface

uses
  ComObj, ActiveX, MandelServ_TLB;

type
  TMandelCalc = class(TAutoObject, IMandelCalc)
  private  // zu Fu eingesetzt
    FCols, FLines, FColStart, FCurLine: Integer;
    FReStart, FImStart, FReStep, FImStep: Double;
    FIterMax: Integer;
    FVPixels: Variant;
    FCalculating: Boolean;
  public
    destructor Destroy; override;  // zu Fu eingesetzt
  protected
    function Get_Cols: Integer; safecall;
    function Get_ColStart: Integer; safecall;
    function Get_CurLine: Integer; safecall;
    function Get_Lines: Integer; safecall;
    procedure Set_Cols(Value: Integer); safecall;
    procedure Set_ColStart(Value: Integer); safecall;
    procedure Set_CurLine(Value: Integer); safecall;
    procedure Set_Lines(Value: Integer); safecall;
    procedure Shutdown; safecall;
    function Get_Calculating: WordBool; safecall;
    procedure StartCalc; safecall;
    procedure StopCalc; safecall;
    function Get_ImStart: Double; safecall;
    function Get_ImStep: Double; safecall;
    function Get_IterMax: Integer; safecall;
    function Get_ReStart: Double; safecall;
    function Get_ReStep: Double; safecall;
    function Get_VPixels: OleVariant; safecall;
    procedure Set_ImStart(Value: Double); safecall;
    procedure Set_ImStep(Value: Double); safecall;
    procedure Set_IterMax(Value: Integer); safecall;
    procedure Set_ReStart(Value: Double); safecall;
    procedure Set_ReStep(Value: Double); safecall;
    procedure Set_VPixels(Value: OleVariant); safecall;
    procedure SetAll(Params: OleVariant); safecall;
  end;

implementation

uses ComServ, MandelServU, MandelTypes;

destructor TMandelCalc.Destroy;
begin
  StopCalc;
  inherited Destroy;
end;

procedure TMandelCalc.StopCalc;
begin
  FCalculating := False;
end;

// Start der Berechnung. ServerForm kommt nur mit einem
// einzigen Objekt zurecht, um die Sache bersichtlich zu halten
procedure TMandelCalc.StartCalc;
begin
  FCalculating := True;
  ServerForm.CurCalcObj := Self;
end;

procedure TMandelCalc.Shutdown;
begin
  ServerForm.ShutDown;  // hartes Abwrgen des Prozesses
end;

// Smtliche Parameter en bloc setzen
procedure TMandelCalc.SetAll(Params: OleVariant);
var PParams: PParamBlock;
begin
  PParams := VarArrayLock(Params);
  with PParams^ do
  begin
    FCols := _Cols; FColStart := _ColStart;
    FLines := _Lines; FCurLine := _CurLine;
    FIterMax := _IterMax;
    FReStart := _ReStart; FImStart := _ImStart;
    FReStep := _ReStep; FImStep := _ImStep;
  end;
  VarArrayUnlock(Params);
end;

// Der Rest ist ein reines Umstapeln einzelner Eigenschaften
function TMandelCalc.Get_Cols: Integer;
begin Result := FCols; end;

function TMandelCalc.Get_ColStart: Integer;
begin Result := FColStart; end;

function TMandelCalc.Get_CurLine: Integer;
begin Result := FCurLine; end;

function TMandelCalc.Get_Lines: Integer;
begin Result := FLines; end;

procedure TMandelCalc.Set_Cols(Value: Integer);
begin FCols := Value; end;

procedure TMandelCalc.Set_ColStart(Value: Integer);
begin FColStart := Value; end;

procedure TMandelCalc.Set_CurLine(Value: Integer);
begin FCurLine := Value; end;

procedure TMandelCalc.Set_Lines(Value: Integer);
begin FLines := Value; end;

function TMandelCalc.Get_Calculating: WordBool;
begin Result := FCalculating; end;

function TMandelCalc.Get_ImStart: Double;
begin Result := FImStart; end;

function TMandelCalc.Get_ImStep: Double;
begin Result := FImStep; end;

function TMandelCalc.Get_IterMax: Integer;
begin Result := FIterMax; end;

function TMandelCalc.Get_ReStart: Double;
begin Result := FReStart; end;

function TMandelCalc.Get_ReStep: Double;
begin Result := FReStep; end;

function TMandelCalc.Get_VPixels: OleVariant;
begin Result := FVPixels; end;

procedure TMandelCalc.Set_ImStart(Value: Double);
begin FImStart := Value; end;

procedure TMandelCalc.Set_ImStep(Value: Double);
begin FImStep := Value; end;

procedure TMandelCalc.Set_IterMax(Value: Integer);
begin FIterMax := Value; end;

procedure TMandelCalc.Set_ReStart(Value: Double);
begin FReStart := Value; end;

procedure TMandelCalc.Set_ReStep(Value: Double);
begin FReStep := Value; end;

procedure TMandelCalc.Set_VPixels(Value: OleVariant);
begin FVPixels := Value; end;

initialization
  TAutoObjectFactory.Create(ComServer, TMandelCalc, Class_MandelCalc, ciMultiInstance);
end.
