#!/usr/local/bin/perl -wT
# --------------------------------------------------------------------
# telsafe.pl Einfache Telefondatenbank
# Durchsucht eine durch Tabs getrennte Textdatei
# Eingabefelder:
# keyword = zu suchender String
# database = zu durchsuchende Datei
#
$ENV{'PATH'} = '/bin:/usr/bin';    # Path auf definierten Wert

use CGI qw(:standard);             # laden des CGI Modules
# Quelle: www-genome.wi.mit.edu/ftp/pub/software/WWW/

# Der folgende Hash ordnet den Benutzereingaben Dateienamen zu
%filetable = (
    lieferanten => '../data/lief.txt',
    kunden      => '../data/kunden.txt',
    mitarbeiter => '../data/mitarb.txt',
);
$searchprog = '/usr/bin/grep';     # ggf anpassen
$OK_CHARS = 'a-zA-Z0-9';    # erlaubte Eingabebuchstaben

$user_keyword = param('keyword');  # hole Eingabefelder
$user_database = param('database');

# schlage richtige Datei in Tabelle filetable nach:
$database = $filetable{$user_database};
if( !defined( $database ) )        # falls nicht gefunden
{
   &fehlerseite("Keine g&uuml;ltige Datenbank ausgew&auml;hlt.\n");
   exit;                            # und Schluss
}

# pruefe ob Suchwort korrekt ist
if($user_keyword =~ /^([$OK_CHARS]+)$/ )
{
    $keyword = $1;                  # $1 = erkanntes Muster
}
else
{                                   # Schlechte Eingabe
    &fehlerseite("Bitte nur Buchstaben eingeben.\n");
    exit;                           # und Schluss
}

# Nutze externes Programm grep zum durchsuchen der Datenbank
# (Im speziellen Fall wuerde das auch mit Perl gehen )
# Das "|" am Ende sorgt dafuer, das Perl die Ausgabe
# des Programmes wie eine Datei einliest.
open( F, "$searchprog '$keyword' $database |")
     || &fehlerseite("$0 : kann nicht auf Datenbank zugreifen");

print &header;                     # erzeugt Content-type...
print &start_html('Telefonsuche'),
      &h1('Suchergebnisse');       # Ueberschrift
print "<table border=1>";          # Starte html Tabelle

while(<F>)                         # Fuer jede Ausgabezeile von grep
{                                  # fuer jede Zeile:
    print "<tr>\n";                # Starte Tabellenzeile
    @fields = split(/\t/);         # trenne Eingabezeile an Tabs
    foreach $field ( @fields )     # Schleife ueber alle Felder
    {                              # Suchwort markieren ( <b>...</b> )
        $field =~ s|($keyword)|<b>$1</b>|;
        print "<td>$field</td>\n"; # Jedes Feld in Spalte ausgeben
    }
    print "</tr>\n";               # Ende Tabellenzeile
}
close(F);

if( !defined( @fields ) )           # Falls kein Ergebnis vorhanden
{                                   # Rueckmeldung: kein Ergebnis
    print "<tr><td>Kein Ergebnis f&uuml;r $keyword</td></tr>\n";
}
print "</table>\n";                 # Ende Html-Tabelle

print &end_html;                     # Standard HTML Ende
#---------------------------------------------------------------------
# Funktion zur Ausgabe einer Fehlermeldungsseite
#---------------------------------------------------------------------
sub fehlerseite{
    my($message) = @_;                # Parameteruebergabe

    print &header;                    # erzeugt Content-type...
    print &start_html( 'Fehlermeldung' ),
          &h1('Fehlermeldung'),
          $message, &br;

    if( $ENV{ 'HTTP_REFERER' } )      # falls letzte Webseite bekannt
    {                                 # Zeige Link zur letzten Seite
        print &a( {href=>$ENV{'HTTP_REFERER'}},
                   "Zur&uuml;ck" );
    }
    print &end_html;                  # standard HTML Ende
}
