#!/usr/local/bin/perl -wT
#----------------------------------------------------------------
# mailsafe.cgi - einfaches CGI zum versenden von Emails
# verbesserte Version mit erhoehter Sicherheit

$ENV{'PATH'} = '/bin:/usr/bin';    # Path auf definierten Wert

use CGI qw(:standard);			   # laden des CGI Modules

# --- Bitte Konfigurieren -------------
$addressat = 'support@meinedomain.de';
$mailprog = '/usr/lib/sendmail';
# --- Ende Konfigurieren --------------

$| = 1;                            # autoflush an, wichtig bei Fehlern

# Zugriff auf die Daten des Benutzers:
$produkt   = &param('product');
$os        = &param('system');
$problem   = &param('problem');
$name      = &param('name');
$kundennr  = &param('kundennr');
$user_addr = &param('email');

# Ueberpruefen der Email-Addresse
# Siehe extra Beschreibung
if( $user_addr =~ /^([a-zA-Z0-9\-\.]+)@([a-zA-Z0-9\-\.]+\.[a-z]+)$/ )
{
	$retaddr = "$1\@$2";           # in diesem Fall koennte man auch mit
}                                  # $user_addr weiterarbeiten
else
{                                  # falls ungueltige Email-Addresse
	&fehlerseite('Bitte geben Sie Ihre Emailaddresse in der Form '
	             . ' "name@xxx.yyy" an.');
    exit;
}

# formatieren des Problemreports
# alles bis EOT wird $emailtext zugewiesen, die Variablen ($product)
# werden durch ihre Werte ersetzt.
$emailtext= <<EOT;
 Problemreport
===============
Produkt: $produkt
System : $os

 Problembeschreibung:
---------------------
$problem

 Kontakt
---------
Kunde: $name
Nr:    $kundennr
Email: $retaddr
EOT

# verschicken der Email mittels unix-program sendmail
# Das "|" am Anfang oeffnet eine Pipe, so dass Perl wie
# in eine Datei schreiben kann.
# die -t Option bewirkt, das sendmail die Eingabeparameter
# nicht von der Kommandozeile, sondern von der Standardeingabe liest
# So kriegt die Shell die Parameter nicht zu fassen
open (MAIL, "| $mailprog -t")
  or &fehlerseite("Problemreport kann z.Z. nicht versendet werden.");

print MAIL "To: $addressat\n",
           "From: $retaddr\n",
           "Subject: Problemreport\n";
print MAIL "\n";            # Trennung Mail-head von Mail-body
print MAIL $emailtext;
close MAIL;

# Rueckmeldung an Benutzer,
print &header;                      # erzeugt "Content-type..."
print &start_html('Problemreport'),
       &h1("Problemreport"),"\n",   # Ueberschrift
       "Folgender Problemreport wurde verschickt:<br>",
	   "<pre>";                     # Email ist preformatted
print  $emailtext;
print  "</pre>";

print &end_html;				       # standard HTML Ende

#---------------------------------------------------------------------
# Funktion zur Ausgabe einer Fehlermeldungsseite
#---------------------------------------------------------------------
sub fehlerseite{
    my($message) = @_;                # Parameteruebergabe

    print &header;                     # erzeugt Content-type...
    print &start_html( 'Fehlermeldung' ),
          &h1('Fehlermeldung'),
          $message, &br;

    if( $ENV{ 'HTTP_REFERER' } )      # falls letzte Webseite bekannt
	{                                 # Zeige Link zur letzten Seite
		print &a( {href=>$ENV{'HTTP_REFERER'}},
		           "Zur&uuml;ck" );
	}
    print &end_html;                   # standard HTML Ende
}
