unit PhotoshopClientU;  // 18-DEC-97 as (Arne Schpers)
// Minimalistischer COM-Client fr Photoshop 4.0

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;  // Hinweistext
    procedure Button1Click(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation
uses PhotoshopTypeLibrary_TLB;  // Projekt/Typbibliothek importieren
{$R *.DFM}

var PhotoshopApp: IPhotoshopApplication;

procedure TForm1.Button1Click(Sender: TObject);
var PSBitmap: IAutoPSDoc;
begin
  PSBitmap := PhotoshopApp.Open('C:\Windows\Wellen.bmp');
  if PSBitmap = nil then
  begin
    ShowMessage('Wellen.bmp nicht gefunden');
    Exit;
  end;
  PhotoshopApp.PlayAction('<Name der Aktion>');
  PSBitmap.SaveTo('C:\Windows\Kopie von Wellen.bmp');
  PSBitmap.Close;
  ShowMessage('Datei bearbeitet und gespeichert');
end;

initialization
  try
   PhotoshopApp := CoPhotoshopApplication.Create;
  except
    on E: Exception do
    begin
      ShowMessage(E.Message);
      Halt;
    end;
  end;
finalization
  try
    if PhotoshopApp <> nil then PhotoshopApp.Quit;
  except  // Error 217 ("Server nicht verfgbar") erschlagen
  end;
end.
