unit MiniServ_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ MiniServ Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_MiniServ: TGUID = '{F1DE0E60-7609-11D1-B84E-0080C8681C8A}';

const

{ Component class GUIDs }
  Class_Miniserver: TGUID = '{F1DE0E62-7609-11D1-B84E-0080C8681C8A}';

type

{ Forward declarations: Interfaces }
  IMiniserver = interface;
  IMiniserverDisp = dispinterface;

{ Forward declarations: CoClasses }
  Miniserver = IMiniserver;

{ Dispatch interface for Miniserver Object }

  IMiniserver = interface(IDispatch)
    ['{F1DE0E61-7609-11D1-B84E-0080C8681C8A}']
    procedure ShutDown; safecall;
    function Get_Text: WideString; safecall;
    procedure Set_Text(const Value: WideString); safecall;
    function Get_TextLen: Integer; safecall;
    procedure Method1; safecall;
    property Text: WideString read Get_Text write Set_Text;
    property TextLen: Integer read Get_TextLen;
  end;

{ DispInterface declaration for Dual Interface IMiniserver }

  IMiniserverDisp = dispinterface
    ['{F1DE0E61-7609-11D1-B84E-0080C8681C8A}']
    procedure ShutDown; dispid 1;
    property Text: WideString dispid 2;
    property TextLen: Integer readonly dispid 3;
    procedure Method1; dispid 4;
  end;

{ MiniserverObject }

  CoMiniserver = class
    class function Create: IMiniserver;
    class function CreateRemote(const MachineName: string): IMiniserver;
  end;



implementation

uses ComObj;

class function CoMiniserver.Create: IMiniserver;
begin
  Result := CreateComObject(Class_Miniserver) as IMiniserver;
end;

class function CoMiniserver.CreateRemote(const MachineName: string): IMiniserver;
begin
  Result := CreateRemoteComObject(MachineName, Class_Miniserver) as IMiniserver;
end;


end.
