// Getraenk.cpp : implementation file
//

#include "stdafx.h"
#include "MFCAutomat.h"
#include "Getraenk.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGetraenk dialog

CGetraenk::CGetraenk(CWnd* pParent /*=NULL*/)
	: CDialog(CGetraenk::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetraenk)
	m_getraenk = 0;
	m_milchkaf = FALSE;
	m_milchtee = FALSE;
	m_piece = 0;
	m_zucker = 0;
	m_fett = 3;
	//}}AFX_DATA_INIT
}

void CGetraenk::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetraenk)
	DDX_Control(pDX, IDC_PIECE3, m_ctrl_p3);
	DDX_Control(pDX, IDC_PIECE2, m_ctrl_p2);
	DDX_Control(pDX, IDC_PIECE1, m_ctrl_p1);
	DDX_Control(pDX, IDC_PIECE0, m_ctrl_p0);
	DDX_Control(pDX, IDC_ZUCKER, m_ctrl_zucker);
	DDX_Control(pDX, IDC_STATIC_TEE2, m_static_tee2);
	DDX_Control(pDX, IDC_STATIC_TEE, m_static_tee);
	DDX_Control(pDX, IDC_STATIC_MILCH2, m_static_milch2);
	DDX_Control(pDX, IDC_STATIC_MILCH, m_static_milch);
	DDX_Control(pDX, IDC_STATIC_KAF2, m_static_kaf2);
	DDX_Control(pDX, IDC_STATIC_KAF, m_static_kaf);
	DDX_Control(pDX, IDC_MILCH_TEE, m_ctrl_milchtee);
	DDX_Control(pDX, IDC_MILCH_KAF, m_ctrl_milchkaf);
	DDX_Control(pDX, IDC_FETT, m_ctrl_fett);
	DDX_Control(pDX, IDC_GETRAENK, m_ctrl_getraenk);
	DDX_CBIndex(pDX, IDC_GETRAENK, m_getraenk);
	DDX_Check(pDX, IDC_MILCH_KAF, m_milchkaf);
	DDX_Check(pDX, IDC_MILCH_TEE, m_milchtee);
	DDX_Radio(pDX, IDC_PIECE0, m_piece);
	DDX_Text(pDX, IDC_ZUCKER, m_zucker);
	DDV_MinMaxInt(pDX, m_zucker, 0, 5);
	//}}AFX_DATA_MAP
	// ab hier die eigene Validation
	DDX_Text(pDX, IDC_FETT, m_fett);
	if(pDX->m_bSaveAndValidate) {
		if(m_fett != 3 && m_fett != 5 && m_fett != 8) {
			AfxMessageBox("Fettgehalt mu 3, 5 oder 8 sein!");
			pDX->Fail();
		}
	}
}

BEGIN_MESSAGE_MAP(CGetraenk, CDialog)
	//{{AFX_MSG_MAP(CGetraenk)
	ON_CBN_SELCHANGE(IDC_GETRAENK, OnSelchangeGetraenk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetraenk message handlers

void CGetraenk::GrauOderNichtGrau(int getraenk)
{
	// Controls fr Optionen fr Kaffee
	m_static_kaf.EnableWindow(getraenk == 0);
	m_ctrl_milchkaf.EnableWindow(getraenk == 0);
	m_static_kaf2.EnableWindow(getraenk == 0);
	m_ctrl_zucker.EnableWindow(getraenk == 0);

	// Controls fr Optionen fr Tee
	m_static_tee.EnableWindow(getraenk == 1);
	m_ctrl_milchtee.EnableWindow(getraenk == 1);
	m_static_tee2.EnableWindow(getraenk == 1);
	m_ctrl_p0.EnableWindow(getraenk == 1);
	m_ctrl_p1.EnableWindow(getraenk == 1);
	m_ctrl_p2.EnableWindow(getraenk == 1);
	m_ctrl_p3.EnableWindow(getraenk == 1);
	
	// Controls fr Optionen fr Milch
	m_static_milch.EnableWindow(getraenk == 2);
	m_static_milch2.EnableWindow(getraenk == 2);
	m_ctrl_fett.EnableWindow(getraenk == 2);
}

void CGetraenk::OnSelchangeGetraenk() 
{
	int getraenk;

	// Das aktuelle Getrnk nach der nderung der Auswahl aus der
	// Kategorie "Control"-Variable mit Typ CComboBox holen.
	// Die Value-Variable m_getraenk kann nicht verwendet werden,
	// da DoDataExchange() nur am Anfang des Dialogs und beim
	// Drcken von OK aufgerufen wird.
	getraenk = m_ctrl_getraenk.GetCurSel();
	GrauOderNichtGrau(getraenk);
}

BOOL CGetraenk::OnInitDialog() 
{
	CDialog::OnInitDialog();

	GrauOderNichtGrau(m_getraenk);

	return TRUE;	// return TRUE unless you set the focus to a control
					// EXCEPTION: OCX Property Pages should return FALSE
}
