program TX97SystemMonitor;

uses DOS,CRT;

const LM78Adr  = $295;      { I/O-Adresse Adreregister LM78 auf TX97}
      LM78Data = LM78Adr+1;
      LM75SMB  = $49;       { Adresse LM75 auf SMBus, per HW fix }

type  DWORD    = array[0..1] of word;

var   LM78Reg    : array[0..$7F] of byte;
      FanDiv     : array[1..2] of byte;
      BusNr      : word;
      DeviceNr   : byte;
      FunktionNr : byte;
      bus,device : byte;
      data       : longint;
      SMBBA      : word;    { SMBus Base Address   }
      SMBHSTSTS  : word;    { SMBus Host Status    }
      SMBSLVSTS  : word;    { SMBus Slave Status   }
      SMBHSTCNT  : word;    { SMBus Host Count     }
      SMBHSTCMD  : word;    { SMBus Host Command   }
      SMBHSTADD  : word;    { SMBus Host Address   }
      SMBHSTDAT0 : word;    { SMBus Host Data 0    }
      SMBHSTDAT1 : word;    { SMBus Host Data 1    }
      SMBBLKDAT  : word;    { SMBus Block Data     }
      SMBSLVCNT  : word;    { SMBus Slave Count    }
      SMBSHDWCMD : word;    { SMBus Shadow Command }
      SMBSLVEVT  : word;    { SMBus Slave Event    }
      SMBSLVDAT  : word;    { SMBus Slave Data     }
      i,j,k,l,t  : word;
      g          : longint;
      cdummy     : char;

function NTH(data:Byte):string;
var h:String;
begin
  case data of
    0..9:h:=chr(48+data);
    else h:=chr(55+data);
  end;
  NTH:=h;
end; {NTH}

function BTH(data:Byte):string;
var h:string;
begin
  h:=NTH(data shr 4)+NTH(data and $F);
  BTH:=h;
end; {BTH}

function Tick:longint;
begin
  Tick := meml[$40:$6C];
end;

procedure FreeSlice; { Rechenzeit freigeben }
begin
  asm
    MOV  AX,$1680
    INT  $2F
    INT  $28
  end;
end;

procedure ReadLM78;
var a : byte;
begin
  for a:=0 to $7F do begin
    repeat until Port[LM78Adr]<128;
    Port[LM78Adr]:=a;
    LM78Reg[a]:=Port[LM78Data];
  end;
end;

procedure WriteZeile(i:word);
begin
  gotoxy(1,i+3);
  write(BTH(i*16),' - ');
  for j:=0 to 15 do begin
    if (j>1) and (j mod 4 =0) then write(' ');
    if (j=8) then write('-  ');
    write(BTH(LM78Reg[i*16+j]),' ');
    end;
end;

function VoltConv(i:byte):real;
const VDiv : array[0..6] of real = ( 1, 1, 1, 1.68, 38/10, -210/60.4, -90.9/60.4);
      VOff : array[0..6] of real = ( 0, 0, 0,    0,     0,         0,          0);
begin
  VoltConv:=VOff[i]+4.096*VDiv[i]*LM78Reg[$20+i]/256;
end;

function FanConv(i:byte):word;
const FanConst = 1350000;
var Rpm : word;
begin
  if LM78Reg[$27+i]=$FF then Rpm:=0
    else if (i<3) then Rpm:=Round(FanConst/LM78Reg[$27+i]/FanDiv[i])
                  else Rpm:=Round(FanConst/LM78Reg[$2A]/2);
  FanConv:=Rpm;
end;

function ReadPCI(BusNR:byte; DeviceNR:Byte; FunktionNr:Byte; POS:byte):longint;
var Base,w,w0 : Word;
    DW,DW1    : DWORD;
    p         : longint absolute DW;
    p1        : longint absolute dw1;
begin
  Base:=pos and $FC;
  DW1[1]:=($8000+BusNR);
  DW1[0]:=(word(DeviceNR and $1F) shl 11)+(FunktionNR shl 8)+Base;
  ASM
    CLI
    MOV DX,$0CF8
    DB $66; MOV AX, Word PTR P1
    DB $66; OUT DX,AX
    NOP; NOP; NOP; NOP; NOP;
    MOV DX,$0CFC
    DB $66; IN AX,DX
    NOP; NOP; NOP; NOP; NOP;
    DB $66; MOV Word PTR P,AX
    STI
    NOP
  END;
  ReadPCI:=P;
end;

function GetSMBBA:word; { Get System Management Bus Base Address }
var PIIX4Found : boolean;
    GSM        : word;
begin
  PIIX4Found:=false;
  bus:=0;
  repeat
    device:=0;
    repeat
      data:=ReadPCI(bus,device,3,0);
      PIIX4Found:=(data=$71138086); 
      { Device = 7113 (PIIX4 Function 3), Vendor = 8086 (Intel) }
      if not PIIX4Found then device:=device+1;
    until PIIX4Found or (device=32);
    if not PIIX4Found then inc(bus);
  until PIIX4Found or (bus=0); { 0 zeigt berlauf an, kein PCI gefunden... }
  if PIIX4Found then GSM:=(ReadPCI(bus,device,3,$90) AND $FFF0) else GSM:=$FFFF;
  GetSMBBA:=GSM;
end;

function SMBHostBusy:boolean;
begin
  SMBHostBusy:=((Port[SMBHSTSTS] AND $01)=$01);
end;

procedure SMBWaitBusy;
var t : longint;
begin
  t:=Tick+1; { Timeout mindestens ein Tick }
  repeat 
    FreeSlice; { Rechenzeit freigeben }
  until SMBHostBusy or (Tick>t);
end;

procedure SMBWaitReady;
var t : longint;
begin
  t:=Tick+1; { Timeout mindestens ein Tick }
  repeat 
    FreeSlice; { Rechenzeit freigeben }
  until (not SMBHostBusy) or (Tick>t);
end;

procedure SetSMBAddresses;
begin
  SMBHSTSTS :=SMBBA+$0; { SMBus Host Status  }
  SMBSLVSTS :=SMBBA+$1; { SMBus Slave Status }
  SMBHSTCNT :=SMBBA+$2; { SMBus Host Count   }
  SMBHSTCMD :=SMBBA+$3; { SMBus Host Command }
  SMBHSTADD :=SMBBA+$4; { SMBus Host Address }
  SMBHSTDAT0:=SMBBA+$5; { SMBus Host Data 0  }
  SMBHSTDAT1:=SMBBA+$6; { SMBus Host Data 1  }
  SMBBLKDAT :=SMBBA+$7; { SMBus Block Data   }
  SMBSLVCNT :=SMBBA+$8; { SMBus Slave Count  }
  SMBSHDWCMD:=SMBBA+$9; { SMBus Shadow Command }
  SMBSLVEVT :=SMBBA+$A; { SMBus Slave Event    }
  SMBSLVDAT :=SMBBA+$C; { SMBus Slave Data     }
end;

function ReadLM75:real;
begin
  SMBWaitReady;
  Port[SMBHSTDAT1]:=0;                    { SMBus-Datenbyte 1 } 
  Port[SMBHSTDAT0]:=0;                    { SMBus-Datenbyte 0 }
  Port[SMBHSTCMD] :=0;                    { SMBus-Kommandofeld, Datum fr LM75-internes Pointer-Register }
  Port[SMBHSTADD] :=(LM75SMB SHL 1) OR 1; { Adresse LM75 als Lesebefehl auf Bus}
  Port[SMBHSTSTS] :=$1F;                  { Statusbits rcksetzen }
  Port[SMBHSTCNT] :=$4C;                  { Busbefehl Data Word Read or Write mit gesetztem Startbit }
  SMBWaitBusy;
  SMBWaitReady;
  ReadLM75:=integer(Port[SMBHSTDAT0] SHL 8 + Port[SMBHSTDAT1])/256.0;
end;

procedure ShowTime;
var h,m,s,d : word;
  function ShowZahl(z:byte):string;
  var s : string[2];
  begin
    Str(z:2,s);
    if s[1]=' ' then s[1]:='0';
    ShowZahl:=s;
  end;
begin
  gotoxy(60,1);
  write(g:9);
  gotoxy(72,1);
  GetTime(h,m,s,d);
  write(ShowZahl(h),':',ShowZahl(m),':',ShowZahl(s));
end;

begin
  ClrScr;
  g:=0;
  writeln('TX97-System-Monitor 1.0, c''t, ea, 1997, Teile gs');
  { PCI-Konfiguration ermitteln }
  SMBBA:=GetSMBBA;
  if (Port[LM78Adr]<>$FF) then begin  
    Port[LM78Adr]:=$47;
    FanDiv[1]:=1 SHL ((Port[LM78Data] SHR 4) AND $3); { Fan-Divisoren ermitteln }
    FanDiv[2]:=1 SHL (Port[LM78Data] SHR 6);
  end;
  if SMBBA=$FFFF then writeln('PIIX4 nicht gefunden.')
   else begin
    SetSMBAddresses;
    if (Port[LM78Adr]<>$FF) then begin
      GetTime(i,j,t,l);
      repeat
        ShowTime;
        ReadLM78;
        for i:=0 to 7 do WriteZeile(i);
        writeln; writeln;
        writeln('  IN0   IN1   IN2   IN3   IN4   IN5   IN6  Temp  Fan1  Fan2  Fan3');
        writeln('  [V]   [V]   [V]   [V]   [V]   [V]   [V]    C  /min  /min  /min');
        for j:=0 to 6 do write(VoltConv(j):5:1,' ');
        write((LM78Reg[$27]):5,' ');
        write(FanConv(1):5,' ');
        write(FanConv(2):5,' ');
        write(FanConv(3):5,' ');
        writeln; writeln;
        writeln('CPU-Temperatursensor: ',ReadLM75:5:1,'C');
        repeat
          FreeSlice; { Rechenzeit freigeben }
          GetTime(i,j,k,l);
        until (t<>k);
        t:=k;
        inc(g);
      until Keypressed;
      cdummy:=ReadKey;
      end
     else
      writeln('LM78 nicht gefunden.')
  end;
end.
