import  java.awt.*;
import  java.awt.event.*;
import  java.awt.image.*;
import  java.util.*;
import  java.applet.Applet;
import  java.io.*;
import  java.net.*;

class ctMenu extends PopupMenu {
    ctscreen mainapp;
	ctMenu(ctscreen ma) {
		super ();
	    if (ma.getMainWindow().NoVariants>1) {
	    	add(ma.NPAGE);
		    addSeparator();  
		}
	    ma.getMainWindow().addSecVariantMenu(this);
	    add(ma.MCLOSE);
	    addSeparator();  
		for (int i=0;i<6;i++)
			add(ma.carr[i]);	
		addSeparator();
		add(ma.HELP);
		addSeparator();
		add(ma.ZURUECK);
		

		mainapp=ma;
			
	}

	public void Init(int x, int y) {
		show(mainapp.getMainWindow(),x-5,y-5);
	}

}

class ctMouseAction implements MouseListener {
	ctscreen mainapp;
	ctMenu Menu=null;

	ctMouseAction(ctscreen ma) {
		mainapp=ma;
	}


	public void mousePressed(MouseEvent e)
	{ // wird aufgerufen sobald ein Mausknopf gedrckt wird.
		if (Menu==null) {
			Menu=new ctMenu(mainapp); // neues Men
			Menu.addActionListener(new ctAction(mainapp));    // Event-Listener mitteilen
		}
		mainapp.getMainWindow().add(Menu);                // Men an das Fenster anhngen
		Menu.Init(e.getX(),e.getY());                     // Men auf der Mausposition darstellen
	}

// leerfun's die implementiert sein muessen
	public void mouseReleased(MouseEvent e) {}
	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}

}

class ctAction implements ActionListener {
	ctscreen mainapp;

	ctAction(ctscreen m) {
		mainapp=m;
	}

	public void actionPerformed(ActionEvent e)
	{
		if (e.getActionCommand()==mainapp.HELP) {
			if (mainapp.IsApplication())
				mainapp.DisplayHelp(mainapp.getCurrentWindowIdx());
			else { 
				try {
			
				mainapp.getAppletContext().showDocument(new URL(mainapp.DocumentUrl.toString()+
						"#SECTION"+String.valueOf(mainapp.getCurrentWindowIdx())));
				} catch (Exception ex) {
					return;
				}
				mainapp.getMainWindow().toBack();
			}
			return;
		}
		if (e.getActionCommand()==mainapp.NPAGE) {
		// nchste Variante des aktuellen Fensters
			mainapp.getMainWindow().SwapVariant(1);
			return;
		}
		if (e.getActionCommand()==mainapp.ZURUECK) {
		// Aktuelles fenster schliessen
			mainapp.removeDisplay();
			if (!mainapp.IsApplication()) {
				try {
			
					mainapp.getAppletContext().showDocument( 
						new URL(mainapp.DocumentUrl.toString()+"#CTSCREEN")
															);
				} catch (Exception ex) {
					return;
				}
			}
			return;
		}
		if (mainapp.ButtonPressed(e.getActionCommand())) return;
		mainapp.getMainWindow().checkSecVariantMenu(e.getActionCommand());
	}
}

class ctFrameAction implements KeyListener, WindowListener {
	ctscreen mainapp;

	ctFrameAction(ctscreen m) {
		mainapp=m;
	}

	public void keyPressed(KeyEvent e) {

		if (mainapp.getCurrentWindowIdx()<0) return;
		switch (e.getKeyCode()) {
		case e.VK_LEFT:
			mainapp.getMainWindow().SwapVariant(1);
			e.consume();
		break;
		case e.VK_RIGHT:
			mainapp.getMainWindow().SwapVariant(-1);
			e.consume();
		break;
		case e.VK_PAGE_UP:
			if (mainapp.getCurrentWindowIdx()>0) {
				mainapp.SwapDisplay(mainapp.getCurrentWindowIdx()-1);
				e.consume();
				return;
			}
			mainapp.removeDisplay();
			e.consume();
		break;
		case e.VK_PAGE_DOWN:
			if ((mainapp.getCurrentWindowIdx()>=0) && (mainapp.getCurrentWindowIdx()<mainapp.MAXCARR)) {
				mainapp.SwapDisplay(mainapp.getCurrentWindowIdx()+1);
				e.consume();
				return;
			}
			mainapp.removeDisplay();
			e.consume();
		break;
		case e.VK_UP:
			mainapp.getMainWindow().SecVariants(1);
			e.consume();
		break;
		case e.VK_DOWN:
			mainapp.getMainWindow().SecVariants(-1);
			e.consume();
		break;
		case e.VK_ESCAPE:
			mainapp.removeDisplay();
			e.consume();
		break;
	}
	}

	public void windowClosing(WindowEvent e)
	{ 
		mainapp.ButtonPressed(ctscreen.BEENDEN); // beenden button simulieren
	} 

	public void keyReleased(KeyEvent e) {}
	public void keyTyped(KeyEvent e) {}
	public void windowOpened(WindowEvent e) {}
	public void windowClosed(WindowEvent e) {}
	public void windowIconified(WindowEvent e) {}
	public void windowDeiconified(WindowEvent e) {}
	public void windowActivated(WindowEvent e) {}
	public void windowDeactivated(WindowEvent e) {}

}

class ctHelpWindow extends Frame implements WindowListener, ActionListener {

	static final String CLOSE="Schliessen";
	static final String NEXT="Naechstes Thema";
	static final String PREV="Vorheriges Thema";
	static final String MAIN="Hauptfenster";

	TextArea tfield;
	int index;
	ctscreen mainapp;
	
	ctHelpWindow(int idx, ctscreen ma) {
	
		super("c't Monitor Test Program");
		tfield=new TextArea("",30,30,TextArea.SCROLLBARS_BOTH);
		tfield.setEditable(false);
		index=idx;
		mainapp=ma;
		MenuBar mb=new MenuBar();
		Menu m=new Menu("Datei",true);
		m.add(CLOSE);
		m.addActionListener(this);
		mb.add(m);

		m=new Menu("Themen",true);
		m.add(NEXT);
		m.add(PREV);
		m.addSeparator();
		for (int i=0;i<=ma.MAXCARR;i++)
			m.add(ma.carr[i]);
		m.addSeparator();
		m.add(MAIN);
		m.addActionListener(this);
		mb.add(m);
		
		setMenuBar(mb);
		
		add(tfield);
		this.setSize(500,300);
		this.addWindowListener(this);
	}

	public void DisplayText(String name, int idx)
	{
		boolean FileFound;
		FileFound=true;
		char data[]=new char[65535];
		FileReader input=null;
		int n;
		
		index=idx;

		tfield.setText("");
		try {
			input=new FileReader(name);
		} catch (Exception e) {
			tfield.append("Konte Datei "+name+" nicht oeffnen.");
			setVisible(true);
			return;
		}
		try {
			while ((n=input.read(data,0,65535))!=-1)
				tfield.append(String.copyValueOf(data,0,n));
		} catch (Exception e) {}
		try { 
			input.close(); 
		} catch (Exception e) {}
		
		setVisible(true);
	}
		
	public void actionPerformed(ActionEvent e)
	{
		if (e.getActionCommand()==CLOSE)
		{
			setVisible(false);
			return;
		}
		if (e.getActionCommand()==NEXT)
		{
			mainapp.DisplayHelp(index+1);
			return;
		}
		if (e.getActionCommand()==PREV)
		{
			mainapp.DisplayHelp(index-1);
			return;
		}
		mainapp.DisplayHelp(e.getActionCommand());
	}
		
	public void windowClosing(WindowEvent e)
	{ 
		this.setVisible(false);
	} 


	public void windowOpened(WindowEvent e) {}
	public void windowClosed(WindowEvent e) {}
	public void windowIconified(WindowEvent e) {}
	public void windowDeiconified(WindowEvent e) {}
	public void windowActivated(WindowEvent e) {}
	public void windowDeactivated(WindowEvent e) {}
		
}		
		
class TextCanvas extends Canvas {
	String text;
	
	TextCanvas(String t)
	{
		super();
		text=t;
	}
	
	public void paint (Graphics g)
	{
		int x, y;
        Font font = g.getFont();
        FontMetrics fontMetrics = g.getFontMetrics();
        Dimension d=this.getSize();
        y=fontMetrics.getHeight();
        x=fontMetrics.stringWidth(text);
		g.setPaintMode();
		g.drawString(text,(d.width-x)/2,(d.height+y)/2);
	}
}
	
class ctCheckbox extends Checkbox {

	int idx;
	ctCheckbox(int index, CheckboxGroup boxes, boolean	status)
	{
		super(ctscreen.cbarr[index],boxes,status);
		idx=index;
	}
	
	int getIndex() {
		return idx;
	}
}


class imgcanvas extends Canvas {

	Image theImage;
	imgcanvas(Image I) {
		super();
		theImage=I;
		setBackground(Color.white);
	}

	public void paint(Graphics g)
	{
		int x,y;
		x=(getSize().width-theImage.getWidth(this))/2;
		y=(getSize().height-theImage.getHeight(this))/2;
		g.drawImage(theImage,x,y,this);
	}
}

		

class ctwindow extends Window {

	ctscreen mainapp; // Die Hauptklasse

	int Variant=0;    // Zhler fr die aktuelle Darstellung des Fensters
	int NoVariants=1; // Anzahl verschiedener Darstellungen dieses Fensters

	int wx,wy; // Breite und Hhe des Fensters.

	int NoSecondaries=1; // Anzahl mglicher Einstellungen des Zweitparameters.
	int SecondaryCounter=1; // Zhler fr zweiten Parameter bei der Fensterdarstellung.
	
	ctwindow(Frame f,ctscreen ma) { 
		super(f);

		mainapp=ma;

		addMouseListener(new ctMouseAction(mainapp));
		addKeyListener(new ctFrameAction(mainapp));
		
		Variant=0;
		
	} // handle the constructor

	void setVariantNumber(int sw) {
		NoVariants=sw;
	}
	
	public void addSecVariantMenu(ctMenu m)
	{
	}

	public void checkSecVariantMenu(String caption)
	{
	}
	
	public void SecVariants(int dir) 
	{ // leere Funktion, wird vom ableitenden Klassen bei bedarf berladen
	}

	public void SwapVariant(int dir)
	{
		Variant=(NoVariants+Variant+dir) % NoVariants;
		InitVariant(Variant);
	}
	
	public void Init(int w, int h) {
		if (mainapp.IsApplication())
			setSize(w,h);
		else
			setSize(w,h+100);
		wx=w; wy=h;
		show();
		setLocation(0,0);
		requestFocus();
	}
	

	void InitVariant(int sw) {}

}

class ctpumpbild extends ctwindow implements Runnable{

	int timer=800;
	int pmode=0;
	Thread kicker;

	static final String NEXT="  Hoehere Pumpfrequenz";
	static final String PREV="  Niedrigere Pumpfrequenz";

	ctpumpbild(Frame f,ctscreen mx) {
		super(f,mx);
		NoSecondaries=0;
		SecondaryCounter=0;
		setVariantNumber(2);
		setBackground(Color.black);
	}

	public void SecVariants(int dir)
	{
		timer =timer-(100*dir);
		if (timer<100) timer=100;
		if (timer>5000) timer = 5000;
		repaint();
	}

	public void addSecVariantMenu(ctMenu m)
	{
	    m.add(NEXT);
	    m.add(PREV);
	    m.addSeparator();
	}

	public void checkSecVariantMenu(String caption)
	{
		if (caption==NEXT)
			SecVariants(1);
		if (caption==PREV)
			SecVariants(-1);
	}

	public synchronized void start() {
		pmode=-Variant-1;
	    kicker = new Thread(this);
	    kicker.start();
    }

    public synchronized void stop() {
	try {
	    if (kicker != null) {
			kicker.stop();
	    }
	} catch (Exception e) {
	}
		kicker = null;
    }

    public void restart() {
		stop();
		start();
    }

    public void run() {
		Thread me = Thread.currentThread();
		long temp;
		me.setPriority(10);
		while (true) {
			if (kicker != me) {
		    	return;
			}
			pmode=-pmode;
		    this.repaint();
			try {
		    	me.sleep(timer);
			} catch (Exception e) {}
		    
	    }
	}

	public void Init(int w, int h) {
		int x,y;
		float ratio;

		super.Init(w,h);
		pmode=-1;
		start();
	}

	void InitVariant(int sw)
	{
		restart();
	}
			

	public void paint(Graphics  g)
	{
		g.setColor(Color.white);
		g.drawLine(0,0,wx,0);
		g.drawLine(0,0,0,wy);
		g.drawLine(wx-1,0,wx-1,wy);
		g.drawLine(0,wy-1,wx,wy-1);
		switch (pmode) {
		case -1: 
			g.setColor(Color.white);
			g.fillRect(5,5,wx-10,wy-10);
		break;
		case -2: 
		    g.setColor(Color.black);
			g.fillRect(5,5,wx-6,(wy-10)/3);
			g.fillRect(5,(wy-10)*2/3,wx-10,wy-5-((wy-10)*2/3));
			g.setColor(Color.white);
			g.fillRect(5,(wy-10)/3,wx-10,(wy-10)/3);
		break;
		case 1: 
			g.setColor(Color.black);
			g.fillRect(5,5,wx-10,wy-10);
		break;
		case 2: 
		    g.setColor(Color.white);
			g.fillRect(5,5,wx-10,(wy-10)/3);
			g.fillRect(5,(wy-10)*2/3,wx-10,wy-5-((wy-10)*2/3));
			g.setColor(Color.black);
			g.fillRect(5,(wy-10)/3,wx-10,(wy-10)/3);
		break;
		default:
			g.setPaintMode();
			g.setColor(Color.black);
			g.drawString("Dieses Fenster wurde nicht korrekt initialisiert.",20,20);
		break;
		}
	}

}



class ctaufloesung extends ctwindow { // Fenster fr Auflsung

	Color Linecolor=Color.white;
	Color Backcolor=Color.black;
	int spacing=1;
	int direction=ctaufloesung.HORIZONTAL;

	static final int HORIZONTAL=1;
	static final int VERTICAL=2;
	static final int CHECKERED=3;
	static final int HALF1=4;

	ctaufloesung(Frame f,ctscreen mx) {
		super(f,mx);

	}


	public void Init(int w, int h) {
		super.Init(w,h);
		setVariantNumber(8);
	}

	void InitVariant(int sw)
	{

		switch(sw) {
		case 0:
			direction=HORIZONTAL;
			spacing=1;
		break;
		case 2:
			direction=VERTICAL;
			spacing=1;
		break;
		case 1:
			direction=HORIZONTAL;
			spacing=2;
		break;
		case 3:
			direction=VERTICAL;
			spacing=2;
		break;
		case 4:
			direction=CHECKERED;
			spacing=1;
		break;
		case 5:
			direction=CHECKERED;
			spacing=2;
		break;
		case 6:
			direction=HALF1;
			spacing=1;
		break;
		case 7:
			direction=HALF1;
			spacing=2;
		break;
		}
		repaint();
	}

	void drawFullLine(int dir,int pos, int width, Graphics g)
	{
		if (dir==HORIZONTAL) {
			for (int i=0;i<width;i++)
				g.drawLine(0,pos*width+i,wx,pos*width+i);
		}
		if (dir==VERTICAL) {
			for (int i=0;i<width;i++)
				g.drawLine(pos*width+i,0,pos*width+i,wy);
		}
	}


	public void paint(Graphics  g)
	{
        int i;
        int nx,ny;

		g.setColor(Backcolor);
		g.setPaintMode();
		g.fillRect(0,0,wx,wy);

		g.setColor(Linecolor);
		nx=wx/2/spacing;
		ny=wy/2/spacing;

		switch (direction) {
		case VERTICAL :
			for (i=0;i<nx;i++)
				drawFullLine(direction,2*i,spacing,g);
		break;
		case HALF1 :
			for (i=0;i<nx;i++)
				drawFullLine(VERTICAL,2*i,spacing,g);
			g.setXORMode(Backcolor);
			for (i=ny/2;i<ny;i++)
				drawFullLine(HORIZONTAL,2*i,spacing,g);
		break;
		case HORIZONTAL :
			for (i=0;i<ny;i++)
				drawFullLine(direction,2*i,spacing,g);
		break;
		case CHECKERED :
			for (i=0;i<ny;i++)
				drawFullLine(HORIZONTAL,2*i,spacing,g);
			g.setXORMode(Backcolor);
			for (i=0;i<nx;i++)
				drawFullLine(VERTICAL,2*i,spacing,g);
		}

	}

}



class ctgeometrie extends ctwindow {

	Color Linecolor=Color.white;
	Color Backcolor=Color.black;
	int nx,ny,ncc,cdsmall,cdlarge;
	boolean ratiook;

	static final String SPPAGE  ="  Feineres Gitter  ";
	static final String SNPAGE  ="  Groeberes Gitter  ";


	ctgeometrie(Frame f,ctscreen mx) {
		super(f,mx);
		NoSecondaries=8;
		SecondaryCounter=4;
	}

	public void SecVariants(int dir)
	{
		SecondaryCounter-=dir;
		if (SecondaryCounter<4) SecondaryCounter=4;
		if (SecondaryCounter>NoSecondaries) SecondaryCounter=NoSecondaries;
		repaint();
	}

	public void addSecVariantMenu(ctMenu m)
	{
	    m.add(ctgeometrie.SNPAGE);
	    m.add(ctgeometrie.SPPAGE);
	    m.addSeparator();
	}

	public void checkSecVariantMenu(String caption)
	{
		if (caption==SNPAGE)
			SecVariants(1);
		if (caption==SPPAGE)
			SecVariants(-1);
	}


	public void Init(int w, int h) {
		int x,y;
		float ratio;

		super.Init(w,h);
		setBackground(Color.black);
		setVariantNumber(2);
		ratio=wx/wy;
		ratiook=true;
		if ((wx*4)==(wy*5)) {
			nx=5;ny=4;
			for (SecondaryCounter=4;
				(wx/SecondaryCounter/nx)>64;
				SecondaryCounter++);
			return;
		}
		if ((wx*3)==(wy*4)) {
			nx=4;
			ny=3;
			for (SecondaryCounter=4;
				(wx/SecondaryCounter/nx)>64;
				SecondaryCounter++);
			return;
		}
		// generate error message
		ratiook=false;
		nx=4;
		ny=3;
			for (SecondaryCounter=4;
				(wx/SecondaryCounter/nx)>64;
				SecondaryCounter++);
	}

	void InitVariant(int sw)
	{
		switch(sw) {
		case 0:
			Linecolor=Color.white;
			Backcolor=Color.black;
		break;
		case 1:
			Linecolor=Color.magenta;
			Backcolor=Color.black;
		break;
		}
		repaint();
	}
			
	void drawCircle(int cx, int cy,int r, Graphics g,boolean center)
	{
		g.drawOval(cx-r,cy-r,r*2,r*2);
		if (r>100) r=100;
		if (!center) return;
		g.drawLine(cx-r,cy,cx+r,cy);
		g.drawLine(cx,cy-r,cx,cy+r);	}


	public void paint(Graphics  g)
	{
        int i,npix,nx1,ny1;
        
        nx1=nx*SecondaryCounter;
        ny1=ny*SecondaryCounter;

		npix=(wy)/ny1;
		g.setColor(Backcolor);
		g.setPaintMode();
		g.fillRect(0,0,wx,wy);
		g.setColor(Linecolor);
		for (i=0;i<nx1;i++) {
			g.drawLine(i*npix,0,i*npix,wy);
		}
		for (i=0;i<ny1;i++) {
			g.drawLine(0,i*npix,wx,i*npix);
		}
		g.drawLine(0,wy-1,wx-1,wy-1);
		g.drawLine(wx-1,0,wx-1,wy-1);
		i=npix*3/2;
		drawCircle(i,i,npix,g,true);
		drawCircle(npix*nx1-i,i,npix,g,true);
		drawCircle(i,npix*ny1-i,npix,g,true);
		drawCircle(npix*nx1-i,npix*ny1-i,npix,g,true);
		drawCircle(npix*nx1/2,npix*ny1/2,npix,g,true);
		drawCircle(npix*nx1/2,npix*ny1/2,npix*ny1/2-1,g,false);
		if ((nx1*npix==wx) && (ny1*npix==wy) && ratiook) return;
		g.setColor(Color.red);
		g.drawLine(wx/2-npix/2,wy/2,wx/2+npix/2,wy/2);
		g.drawLine(wx/2-npix/2,wy/2-1,wx/2+npix/2,wy/2-1);
		g.drawLine(wx/2-npix/2,wy/2+1,wx/2+npix/2,wy/2+1);
		g.drawLine(wx/2,wy/2-npix/2,wx/2,wy/2+npix/2);
		g.drawLine(wx/2-1,wy/2-npix/2,wx/2-1,wy/2+npix/2);
		g.drawLine(wx/2+1,wy/2-npix/2,wx/2+1,wy/2+npix/2);
		
	}

}


class ctkontrast extends ctwindow { // Fenster fr Auflsung

	static final int NOCOL=5;
	static final int OFFS=10;
	static final String LINE1="Stellen Sie bei mittlerer Helligkeit den Kontrast so ein, dass Sie die 5 hellen";
	static final String LINE2="Graustufen gut unterscheiden Knnen. Justieren Sie nun die Helligkeit so, "; 
	static final String LINE3="dass der Hintergrund schwarz ist, Sie aber die 5 Graustufen erkennen koennen.";

	Color[] greys= new Color[NOCOL];
	Color[] whites= new Color[NOCOL]; 
	int[] gpercent= new int[NOCOL];
	int[] wpercent= new int[NOCOL];

	Color Linecolor=Color.white;
	Color Backcolor=Color.black;
	int px; int py;
	int mx; int my;

	ctkontrast(Frame f,ctscreen mx) {
		super(f,mx);
	}

	public void SecVariants(int dir) 
	{ 
		py=py-10*dir;
		if (py<0) py=0;
		if (py>my) py=my;
		repaint();
	}

	public void SwapVariant(int dir)
	{
		px=px-10*dir;
		if (px<0) px=0;
		if (px>mx) px=mx;
		repaint();
	}

	public void Init(int w, int h) {
	    int j;
		super.Init(w,h);
		px=w/2-200;
		py=h/2-200;
		mx=w-400;
		my=h-400;
		setBackground(Color.black);
		for (int i=0;i<NOCOL;i++)
		{
			greys[i]=new Color((i+1)*OFFS,(i+1)*OFFS,(i+1)*OFFS);
			gpercent[i]=(100*i*OFFS/255);
			whites[i]=new Color(255-i*OFFS,255-i*OFFS,255-i*OFFS);
			wpercent[i]=100-(100*i*OFFS/255);
		}
	}

	public void paint(Graphics  g)
	{
        int i,npix;
        int nx,ny;
		int x, y;

        Font font = g.getFont();
        FontMetrics fontMetrics = g.getFontMetrics();
        Dimension d=this.getSize();
        y=fontMetrics.getHeight();
        x=fontMetrics.stringWidth(LINE1);
        
		g.setColor(Linecolor);
		g.setPaintMode();
		if (py>3*y) {
			g.drawString(LINE1,(wx-x)/2,y);
			g.drawString(LINE2,(wx-x)/2,2*y);
			g.drawString(LINE3,(wx-x)/2,3*y);
		}
		else {
			g.drawString(LINE1,(wx-x)/2,wy-2*y);
			g.drawString(LINE2,(wx-x)/2,wy-y);
			g.drawString(LINE3,(wx-x)/2,wy);
		}
		g.drawLine(px,py,px+399,py+0);
		g.drawLine(px,py,px,py+399);
		g.drawLine(px,py+399,px+399,py+399);
		g.drawLine(px+399,py,px+399,py+399);
		nx=360/NOCOL;
		ny=(400-NOCOL*nx)/2;
		for (i=0;i<NOCOL;i++)
		{
			g.setColor(greys[i]);
			g.fillRect(px+ny+nx*i,py+20,nx,140);
			g.setColor(whites[NOCOL-i-1]);
			g.fillRect(px+ny+nx*i,py+240,nx,140);
		}

	}

}

class ctfarbflaechen extends ctwindow { // Fenster fr Farbflchen

	Color Areacolor=Color.white;

	ctfarbflaechen(Frame f,ctscreen mx) {
		super(f,mx);

	}

	
	public void Init(int w, int h) {
		super.Init(w,h);
		setVariantNumber(7);
	}

	void InitVariant(int sw)
	{

		switch(sw) {
		case 0:
			Areacolor=Color.white;
		break;
		case 1:
			Areacolor=Color.red;
		break;
		case 2:
			Areacolor=Color.green;
		break;
		case 3:
			Areacolor=Color.blue;
		break;
		case 4:
			Areacolor=Color.black;
		break;
		case 5:
			Areacolor=new Color(50,50,50);
		break;
		case 6:
			Areacolor=new Color(125,125,125);
		break;
		case 7:
			Areacolor=new Color(180,180,180);
		break;
		}
		repaint();
	}
			


	public void paint(Graphics  g)
	{
        int i,npix;
        int nx,ny;
        
		g.setColor(Areacolor);
		g.setPaintMode();
		g.fillRect(0,0,wx,wy);
	}

}

class ctschaerfe extends ctwindow { // Fenster fr Farbflchen

	Color Backcolor=Color.white;
	Color TestColor=Color.black;
	int fontsizeOffset=0;
	int testwind=1;
	Image VesaImage;
	Image TextImage;
	
	static final int TEXT=1;
	static final int VESA=2;
	static final int BMPTXT=3;

	ctschaerfe(Frame f,ctscreen mx, Image Vm, Image Tm) {
		super(f,mx);
		VesaImage=Vm;
		TextImage=Tm;
	}

	
	public void Init(int w, int h) {
		super.Init(w,h);
		setVariantNumber(3);
	}

	void InitVariant(int sw)
	{

		switch(sw) {
		case 0:
			testwind=TEXT;
		break;
		case 1:
			testwind=BMPTXT;
		break;
		case 2:
			testwind=VESA;
		break;
		}
		repaint();
	}
			
	public void SecVariants(int dir) 
	{ // leere Funktion, wird vom ableitenden Klassen bei bedarf berladen
		if (fontsizeOffset-dir>-10) fontsizeOffset-=dir;
		if (fontsizeOffset>20) fontsizeOffset=20;
		this.repaint();
	}


	public void paint(Graphics  g)
	{
        int i,j,jj;
        int nx,ny,wnx,wny;
        FontMetrics fontMetrics;
        Font font = g.getFont();
        String text;
        
		g.setColor(Backcolor);
		g.setPaintMode();
		g.fillRect(0,0,wx,wy);
		g.setColor(TestColor);

        switch(testwind) {
        
        case ctschaerfe.TEXT:
           	g.setFont(new Font(font.getName(),
           				font.getStyle(),font.getSize() + fontsizeOffset));
           	fontMetrics = g.getFontMetrics();
           	ny=wy/(fontMetrics.getHeight()-3)+1;
           	text=ctscreen.STDTEXT+String.valueOf(fontMetrics.getHeight())+" Pixel ";
           	jj=fontMetrics.stringWidth(text);
           	nx=wx/jj+1;

			g.setColor(Color.black);
			g.setPaintMode();
			for (i=0;i<nx+1;i++) for (j=0;j<ny/2+1;j++)
			{
            	g.drawString(text,jj*i,(fontMetrics.getHeight()-3)*(2*j));
            	g.drawString(text,jj*i-jj/2,(fontMetrics.getHeight()-3)*(2*j+1));
        	}
        break;
        case ctschaerfe.VESA:
			wnx=VesaImage.getWidth(this);
			wny=VesaImage.getHeight(this);
        	nx=wx/wnx;
        	ny=wx/wny;
        	i=0;j=0;
        	for (i=0;i<=nx;i++) for (j=0;j<=ny;j++) {
				g.drawImage(VesaImage,i*wnx,j*wny,this);
        	}
        break;
        case ctschaerfe.BMPTXT:
			wnx=TextImage.getWidth(this);
			wny=TextImage.getHeight(this);
        	nx=wx/wnx;
        	ny=wx/wny;
        	i=0;j=0;
        	for (i=0;i<=nx;i++) for (j=0;j<=ny;j++) {
				g.drawImage(TextImage,i*wnx,j*wny,this);
        	}
        }
        
	}

}

	


public  class  ctscreen extends Applet {
	Frame fx=new Frame("c't Monitor Test Programm");
	ctAction ml;
	ctFrameAction fl;
	int actw=-1;
	int sx=640;
	int sy=480;
	ctwindow TestWindow;
	CheckboxGroup boxes;
	Image Myimg;
	boolean isApplication=false;
	URL BaseUrl;
	URL DocumentUrl;
	ctHelpWindow HlpWnd=null;
	TextField breite,hoehe;
	TextCanvas t;
	Color bc;

static final int MAXCARR=5;
static final String[] carr =  {"  Helligkeit/Kontrast  ",
				"  Geometrie  ",
				"  Aufloesung  ",
				"  Schaerfe  ",
				"  Farbreinheit  ",
				"  Pumpbild  ",
				"  Ergonomie  "};
static final String[] helpfiles = {"hellKont",
				"geometr",
				"aufloes",
				"schaerfe",
				"Farbrein",
				"pumpbild",
				"ergonom"};
static final String mainhelp="ctscreen";

static final String[] cbarr={" 640 x 480"," 800 x 600","1024 x 768",
				"1280 x 1024","1152 x 864","1600 x 1200",
				"   Auto   ","Benutzerdefiniert"};
				
static final int[][] scarr={{640,480},{800,600},{1024,768},
				{1280,1024},{1152,864},{1600,1200},{-1,-1},{-2,-2}};

	
static final String BEENDEN="  Beenden  ";
static final String MCLOSE="  Schliessen  ";
static final String ZURUECK="  Hauptmenue  ";
static final String NPAGE  ="  andere Variante  ";
static final String STDTEXT = "c't Monitortestprogramm, Systemschrift ";       
static final String HELP = "  Hilfe  ";


	protected  void  makebutton(String  name, GridBagLayout gridbag, GridBagConstraints  c)  {
		Button  button  =  new  Button(name);
		gridbag.setConstraints(button,  c);
		button.addActionListener(ml);
		button.addKeyListener(fl);
		add(button);
    }


	protected  void  makecbox(int idx, GridBagLayout gridbag, GridBagConstraints  c, boolean status)  {
		ctCheckbox  cb  =  new  ctCheckbox(idx, boxes, status);
		cb.setBackground(bc);
		gridbag.setConstraints(cb, c);
		cb.addKeyListener(fl);
		add(cb);
    }
    
    protected void addFramer(GridBagLayout gridbag, GridBagConstraints c)
    {
    	Canvas tf=new Canvas();
		gridbag.setConstraints(tf,  c);
		add(tf);
	}


	public int getCurrentWindowIdx()
	{
		return actw;
	}

	public void removeDisplay()
	{
		if (actw<0) return;
		TestWindow.dispose();
		actw=-1;
	}


	public void DisplayHelp(int idx)
	{
		if ((idx<0) || (idx>MAXCARR)) return;
		if (HlpWnd==null) {
			HlpWnd=new ctHelpWindow(idx,this);
		}
		HlpWnd.DisplayText(helpfiles[idx],idx);
	}
	

	public void DisplayHelp(String Caption)
	{
		if (HlpWnd==null) {
			HlpWnd=new ctHelpWindow(0,this);
		}
		if (Caption==ctHelpWindow.MAIN) {
			HlpWnd.DisplayText(mainhelp,-1);
			return;
		}
		if (Caption=="") 
			HlpWnd.DisplayText(helpfiles[getCurrentWindowIdx()],getCurrentWindowIdx());
		else
			for (int i=0;i<MAXCARR;i++) {
				if (Caption==carr[i]) {
					HlpWnd.DisplayText(helpfiles[i],i);
					return;
				}
			}
	}

	public void SwapDisplay(int toDisplay)
	{
		ctwindow w=null;
		if (toDisplay==actw) return; // same window

		if ((toDisplay>0) || (toDisplay<MAXCARR)) {
			switch (toDisplay) {
				case 1: w=new ctgeometrie(fx,this);
				break;
				case 0: w=new ctkontrast(fx,this);
				break;
				case 2: w=new ctaufloesung(fx,this);
				break;
				case 3: if (IsApplication()) {
					w=new ctschaerfe(fx,this,
						Toolkit.getDefaultToolkit().getImage("vesa.gif"),
						Toolkit.getDefaultToolkit().getImage("text.gif"));
					}
					else try {
					w=new ctschaerfe(fx,this,
						this.getAppletContext().getImage(new URL(BaseUrl.toString()+"vesa.gif")),
						this.getAppletContext().getImage(new URL(BaseUrl.toString()+"text.gif")));
					} catch(Exception e) {}
						
				break;
				case 4: w=new ctfarbflaechen(fx,this);
				break;
				case 5: w=new ctpumpbild(fx,this);
				break;
				case 6: w=new ctwindow(fx,this);
				break;
				default: w=new ctwindow(fx,this);
			}
			w.Init(sx,sy);
		} else w=null;
		if (actw>-1) TestWindow.dispose();

		TestWindow=w;
		actw=toDisplay;
	}

	public void SwapVariant() {
		if (actw>-1)
			TestWindow.SwapVariant(1);
	}
		
    public boolean ButtonPressed(String caption) {
    	int i=0;
        Checkbox b=boxes.getSelectedCheckbox();
    	for (i=0;i<8;i++) {
    		if (b.getLabel()==ctscreen.cbarr[i]) {
    			sx=scarr[i][0];
    			sy=scarr[i][1];
    		}
    	}
    	if (sx==-1) {
			Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
			sx=d.width;
			sy=d.height;
        }
        if (sx==-2) {
        	try {
        		sx=Integer.parseInt(breite.getText());
        	} catch(Exception ex) {
        		return true;
        	}
        	try {
        		sy=Integer.parseInt(hoehe.getText());
        	} catch(Exception ex) {
        		return true;
        	}
        }
    
    	for (i=0;i<7;i++)
    		if (caption==ctscreen.carr[i]) {
    			SwapDisplay(i);
    			return true;
    		}
    	if (caption==ctscreen.BEENDEN)
    	{
    		this.destroy();
    		fx.dispose();
    		if (isApplication) System.exit(0);
    		return true;
    	}
    	return false;
    }
    			    
	public void setFrame(Frame f) {
		fx=f;
	}

	public ctwindow getMainWindow() {
		return TestWindow;
	}

	public boolean IsApplication()
	{
		return isApplication;
	}

	public  void  init()  {
		ml=new ctAction(this);
		fl=new ctFrameAction(this);
		if (!IsApplication()) {
			BaseUrl=this.getCodeBase();
			DocumentUrl=getDocumentBase();
			if (DocumentUrl.toString().indexOf(BaseUrl.toString())!=0)
			return;
		}	
		bc=fx.getBackground();

		GridBagLayout  gridbag  =  new  GridBagLayout();
		GridBagConstraints  c  =  new  GridBagConstraints();
		setLayout(gridbag);
		c.fill  =  GridBagConstraints.BOTH;
		c.weightx  =  1.0;
		boxes = new CheckboxGroup();


		imgcanvas w=null;
		if (IsApplication())
			w=new imgcanvas(Toolkit.getDefaultToolkit().getImage("ct.gif"));
		else
			try {
				w=new imgcanvas(this.getAppletContext().getImage(new URL(BaseUrl.toString()+"ct.gif")));
			} catch(Exception ex) {}

		c.gridwidth=1;
		c.gridheight=8;
		addFramer(gridbag, c);

		c.gridwidth  =  6;	      	      
		c.gridheight  =  4;
		gridbag.setConstraints(w,  c);
		add(w);
		
		c.gridwidth=1;
		addFramer(gridbag,c);
			
		c.gridheight =  1;	      	      
		makebutton(carr[0],  gridbag,  c);

		c.gridwidth  =  GridBagConstraints.REMAINDER; 
		addFramer(gridbag, c);

		c.gridwidth =  4;
		makebutton(carr[1],  gridbag,  c);

		c.gridwidth  =  GridBagConstraints.REMAINDER;  
		addFramer(gridbag, c);

		c.gridwidth =  4;
		makebutton(carr[2],  gridbag,  c);

		c.gridwidth  =  GridBagConstraints.REMAINDER;  
		addFramer(gridbag, c);

		c.gridwidth =  4;	
		makebutton(carr[3],  gridbag,  c);

		c.gridwidth  =  GridBagConstraints.REMAINDER;  
		addFramer(gridbag, c);

		c.gridwidth =  3;	      	     
		makecbox(0,  gridbag,  c,false);

		makecbox(1,  gridbag,  c,false);
		c.gridwidth=1;
		addFramer(gridbag,c);

		c.gridwidth = 4;    
		makebutton(carr[4],  gridbag,  c);

		c.gridwidth  =  GridBagConstraints.REMAINDER;
		addFramer(gridbag, c);

		c.gridwidth = 3;    
		makecbox(2,  gridbag,  c,false);

		makecbox(3,  gridbag,  c,false);
		c.gridwidth=1;
		addFramer(gridbag,c);

		c.gridwidth = 4;    
		makebutton(carr[5],  gridbag,  c);

		c.gridwidth  =  GridBagConstraints.REMAINDER; 
		addFramer(gridbag, c);

		c.gridwidth = 3;    
		makecbox(4,  gridbag,  c,false);

		makecbox(5,  gridbag,  c,false);
		c.gridwidth=1;
		addFramer(gridbag,c);

		c.gridwidth = 4;    
//		makebutton(carr[6],  gridbag,  c);
		c.gridwidth  =  GridBagConstraints.REMAINDER;  

		addFramer(gridbag, c);

		c.gridwidth = 3;    
		makecbox(6,  gridbag,  c,true);
		addFramer(gridbag,c);
		c.gridwidth=1;
		addFramer(gridbag,c);
		
		
		c.gridwidth  =  GridBagConstraints.REMAINDER; 
		addFramer(gridbag, c);
		c.gridwidth=1;
		addFramer(gridbag,c);
		c.gridwidth=3;
		makecbox(7,  gridbag,  c,false);
		
		c.gridwidth  = 1; 
		c.gridheight = 1;
		
		breite=new TextField("640",5);
		gridbag.setConstraints(breite,  c);
		add(breite);
		
		t=new TextCanvas("X");
		gridbag.setConstraints(t,  c);
		add(t);

		hoehe=new TextField("480",5);
		gridbag.setConstraints(hoehe,  c);
		add(hoehe);
		
		addFramer(gridbag,c);
		c.gridwidth = 4;
		if (isApplication) makebutton(ctscreen.BEENDEN,  gridbag,  c);

		
		c.gridwidth = GridBagConstraints.REMAINDER;
		addFramer(gridbag, c);

		c.gridheight=GridBagConstraints.REMAINDER;
		addFramer(gridbag, c);
		
	}	

	public  static  void  main(String  args[])  {
		ctscreen  ex1  =  new  ctscreen();
		ex1.isApplication=true;

		ex1.init();
// 		ex1.setSize(580,300);

		ex1.fx.add("Center",  ex1);
		ex1.fx.pack();
		ex1.fx.show();
		ex1.fx.addKeyListener(new ctFrameAction(ex1));
		ex1.fx.addWindowListener(new ctFrameAction(ex1));
		ex1.fx.setSize(500,250);
	}
}

