(* ... *)

private
    { Private-Deklarationen in TEditForm }

    FRow:              LongInt;
    FColumn:           LongInt;

    procedure SetRow (Value: LongInt);
    procedure SetColumn (Value: LongInt);
    function GetRow: LongInt;
    function GetColumn: LongInt;

  public
    { Public-Deklarationen }
    property Row: LongInt read GetRow write SetRow;
    property Column: LongInt read GetColumn write SetColumn;

(* ... *)

procedure TEditForm.SetRow (Value: LongInt);
VAR sel: Integer;
begin
  WITH Editor DO BEGIN
    Value := Value - 1; IF Value < 0 THEN Value := 0;
    Sel := Perform (EM_LINEINDEX, Value, 0);
    IF Sel < 0 THEN Sel := 0;
    SelStart := Sel;
    FRow := SelStart;
  END (* WITH *);
end (* SetRow *);

function TEditForm.GetRow: LongInt;
begin
  WITH Editor DO
    Result := Perform (EM_LINEFROMCHAR, SelStart, 0) + 1;
end (* GetRow *);

procedure TEditForm.SetColumn (Value: LongInt);
VAR sel: Integer;
    row: Integer;
begin
  WITH Editor DO BEGIN
    DEC (Value); IF Value < 0 THEN Value := 0;
    row := GetRow - 1;
    FColumn := Perform (EM_LINELENGTH, Perform 
(EM_LINEINDEX, Row, 0), 0);
    if FColumn > Value then
      FColumn := Value; (* Cursor kann nicht hinter Zeilenende 
stehen *)
    Sel := Perform (EM_LINEINDEX, Row, 0) + FColumn;
    SelStart := Sel;
  END (* WITH *);
end (* SetColumn *);

function TEditForm.GetColumn: LongInt;
begin
  WITH Editor DO
   Result := SelStart - Perform (EM_LINEINDEX, GetRow -1, 0) 
+ 1;
end (* GetColumn *);

procedure TLRFrame.StringSuchen(Sender: TObject);
VAR
  ST:    TSearchTypes;
  Rslt:  Integer;
begin
  IF ActiveMDIChild = NIL THEN EXIT;
  ST := [];
  WITH Sender AS TFindDialog DO BEGIN
      IF frWholeWord IN Options THEN ST := [stWholeWord];
      IF frMatchCase IN Options THEN ST := ST + 
[stMatchCase];
    IF ActiveMDIChild IS TEditForm THEN
      WITH ActiveMDIChild AS TEditForm DO BEGIN
        Rslt := Editor.FindText(FindText, Editor.SelStart +
          Editor.SelLength, Editor.GetTextLen, ST);
        IF Rslt > -1 THEN
          BEGIN
            Editor.SelStart := Rslt;
            Editor.SelLength := Length(FindText);
          END
        ELSE BEGIN
          IF NOT (Sender IS TReplaceDialog) THEN
            ShowMessage ('Suchbegriff "' + FindDialog1.FindText +
            '" nicht gefunden!');
        END (* ELSE *);
      END (* WITH ActiveMDIChild *);
      (*CloseDialog;*)
    END (* WITH *);
end;

